/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddressManager {
    private static final Logger LOGGER = Logger.getLogger(AddressManager.class.getName());
    private final Set<InetSocketAddress> errors = Collections.synchronizedSet(new HashSet());

    public InetSocketAddress getAddress(String host, String portsString) throws UnknownHostException {
        List<Integer> ports = AddressManager.parsePorts(portsString);
        if (ports.isEmpty()) {
            LOGGER.warning("No port to connect to found: " + portsString);
            return null;
        }
        if (host == null || host.isEmpty()) {
            LOGGER.warning("No host to connect to provided.");
            return null;
        }
        InetAddress[] ips = InetAddress.getAllByName(host);
        HashSet<InetSocketAddress> tried = new HashSet<InetSocketAddress>();
        for (InetAddress ip : ips) {
            for (int port : ports) {
                InetSocketAddress address = new InetSocketAddress(ip, port);
                if (!this.errors.contains(address)) {
                    return address;
                }
                tried.add(address);
            }
        }
        LOGGER.info("Tried all available sockets.. trying from the start.");
        this.clearErrorsForAddresses(tried);
        return (InetSocketAddress)tried.iterator().next();
    }

    public void addError(InetSocketAddress address) {
        this.errors.add(address);
    }

    private void clearErrorsForAddresses(Set<InetSocketAddress> addresses) {
        this.errors.removeAll(addresses);
    }

    public static List<Integer> parsePorts(String ports) {
        String[] split = ports.split("[^0-9]");
        ArrayList<Integer> parsedPorts = new ArrayList<Integer>();
        for (String portString : split) {
            if (portString.isEmpty()) continue;
            try {
                parsedPorts.add(Integer.parseInt(portString));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return parsedPorts;
    }

    public static void main(String[] args) {
        AddressManager m = new AddressManager();
        try {
            for (int i = 0; i < 60; ++i) {
                InetSocketAddress addr = m.getAddress("irc.chat.twitch.tv", "6697,6667,443,80");
                System.out.println(addr);
                m.addError(addr);
            }
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(AddressManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

