/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.AddressbookEntry;
import chatty.util.FileWatcher;
import chatty.util.MiscUtil;
import chatty.util.StringUtil;
import chatty.util.settings.Settings;
import chatty.util.settings.SettingsListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Addressbook {
    private static final Logger LOGGER = Logger.getLogger(Addressbook.class.getName());
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String SETTING_NAME = "abEntries";
    private final Settings settings;
    private final Map<String, AddressbookEntry> entries = new HashMap<String, AddressbookEntry>();
    private final Set<String> presetCategories = new TreeSet<String>();
    private final Set<String> somewhatUniqueCategories = new HashSet<String>();
    private final String fileName;
    private final String importFileName;

    public Addressbook(String fileName, String importFilename, Settings settings) {
        this.fileName = fileName;
        this.importFileName = importFilename;
        this.settings = settings;
        if (settings != null) {
            settings.addSettingsListener(new SettingsListener(){

                @Override
                public void aboutToSaveSettings(Settings settings) {
                    Addressbook.this.saveToSettings();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSomewhatUniqueCategories(String cats) {
        if (cats == null) {
            return;
        }
        Set<String> set = this.somewhatUniqueCategories;
        synchronized (set) {
            String[] split;
            this.somewhatUniqueCategories.clear();
            for (String cat : split = cats.split(",")) {
                if (cat.trim().isEmpty()) continue;
                this.somewhatUniqueCategories.add(cat.trim());
            }
        }
    }

    public synchronized String command(String text) {
        if ((text = StringUtil.removeDuplicateWhitespace(text).trim()).isEmpty()) {
            return "Invalid command.";
        }
        String[] split = text.split(" ", 2);
        String command = split[0];
        String[] parameters = new String[]{};
        String parameter = "";
        if (split.length == 2) {
            parameters = split[1].split(" ");
            parameter = split[1].trim();
        }
        if (command.equals("get")) {
            return this.commandGet(parameters);
        }
        if (command.equals("add")) {
            return this.commandAdd(parameters);
        }
        if (command.equals("set")) {
            return this.commandSet(parameters);
        }
        if (command.equals("remove")) {
            return this.commandRemove(parameters);
        }
        if (command.equals("renameCategory")) {
            return this.commandRenameCategory(parameters);
        }
        if (command.equals("removeCategory")) {
            return this.commandRemoveCategory(parameters);
        }
        if (command.equals("change")) {
            return this.commandChange(parameter);
        }
        if (command.equals("info")) {
            return this.commandInfo();
        }
        return "Invalid command.";
    }

    private String commandGet(String[] parameters) {
        if (parameters.length == 1) {
            String name = parameters[0].trim();
            AddressbookEntry entry = this.get(name);
            if (entry == null) {
                return "No entry for '" + name + "'.";
            }
            return "'" + name + "' has categories " + Addressbook.categoriesToString(entry.getCategories()) + ".";
        }
        return "Get: Invalid number of parameters.";
    }

    private String commandAdd(String[] parameters) {
        if (parameters.length == 1) {
            String name = parameters[0].trim();
            if (this.add(name, "") == null) {
                return "Added '" + name + "'.";
            }
            return "Didn't add '" + name + "' (already present).";
        }
        if (parameters.length == 2) {
            String name = parameters[0].trim();
            String categoriesString = parameters[1].trim();
            Set<String> categories = Addressbook.getCategoriesFromString(categoriesString);
            AddressbookEntry previous = this.get(name);
            this.clearSomewhatUniqueCategories(categories);
            AddressbookEntry result = this.add(name, categories);
            if (result == null) {
                return "Added '" + name + "' with categories '" + categoriesString + "'.";
            }
            Set<String> resultCategories = result.getCategories();
            if (previous.getCategories().equals(resultCategories)) {
                return "Didn't change '" + name + "', categories already " + Addressbook.categoriesToString(resultCategories) + ".";
            }
            return "Changed '" + name + "', categories now " + Addressbook.categoriesToString(result.getCategories()) + ".";
        }
        return "Add: Invalid number of parameters.";
    }

    private String commandChange(String parameter) {
        String[] parameters = parameter.split(" ", 2);
        if (parameters.length == 2) {
            String name = parameters[0].trim();
            AddressbookEntry current = this.get(name);
            Set<String> categories = current == null ? new HashSet<String>() : current.getCategories();
            Set<String> changedCats = Addressbook.changeCategories(categories, parameters[1]);
            this.set(name, changedCats);
            String catOutput = Addressbook.categoriesToString(changedCats);
            if (current == null) {
                return "Added '" + name + "' with categories " + catOutput + ".";
            }
            if (categories.equals(changedCats)) {
                return "Didn't change '" + name + "', categories already " + catOutput + ".";
            }
            return "Changed '" + name + "', categories now " + catOutput + ".";
        }
        return "Change: Invalid number of parameters.";
    }

    private String commandSet(String[] parameters) {
        if (parameters.length == 2) {
            String name = parameters[0].trim();
            String categoriesString = parameters[1].trim();
            Set<String> categories = Addressbook.getCategoriesFromString(categoriesString);
            AddressbookEntry previousEntry = this.get(name);
            this.clearSomewhatUniqueCategories(categories);
            this.set(name, categories);
            String categoriesOutput = Addressbook.categoriesToString(categories);
            if (previousEntry == null) {
                return "Added '" + name + "' with categories " + categoriesOutput + ".";
            }
            if (previousEntry.getCategories().equals(categories)) {
                return "Didn't change '" + name + "', categories already " + categoriesOutput + ".";
            }
            return "Set '" + name + "' to categories " + categoriesOutput + ".";
        }
        return "Set: Invalid number of parameters.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSomewhatUniqueCategories(Set<String> catsToCheck) {
        for (String cat : catsToCheck) {
            Set<String> set = this.somewhatUniqueCategories;
            synchronized (set) {
                if (this.somewhatUniqueCategories.contains(cat)) {
                    this.removeCategory(cat);
                }
            }
        }
    }

    private String commandRemove(String[] parameters) {
        if (parameters.length == 1) {
            String name = parameters[0].trim();
            if (this.remove(name) == null) {
                return "Didn't remove '" + name + "' (entry not present).";
            }
            return "Removed '" + name + "'.";
        }
        if (parameters.length == 2) {
            String name = parameters[0].trim();
            Set<String> categories = Addressbook.getCategoriesFromString(parameters[1].trim());
            AddressbookEntry currentEntry = this.get(name);
            AddressbookEntry result = this.remove(name, categories);
            if (result == null) {
                return "Didn't remove anything from '" + name + "' (entry not present).";
            }
            if (result.equalsFully(currentEntry)) {
                return "Didn't remove anything from '" + name + "', categories are " + Addressbook.categoriesToString(currentEntry.getCategories());
            }
            return "Removed categories " + Addressbook.categoriesToString(categories) + " from '" + name + "' (categories now " + Addressbook.categoriesToString(result.getCategories()) + ").";
        }
        return "Remove: Invalid number of parameters.";
    }

    private String commandRenameCategory(String[] parameters) {
        if (parameters.length != 2) {
            return "Rename category: Invalid number of parameters.";
        }
        String oldCategoryName = parameters[0];
        String newCategoryName = parameters[1];
        int result = this.renameCategory(oldCategoryName, newCategoryName);
        return "Renamed category '" + oldCategoryName + "'->'" + newCategoryName + "' in " + result + " entries.";
    }

    private String commandRemoveCategory(String[] parameters) {
        if (parameters.length != 1) {
            return "Remove category: Invalid number of parameters.";
        }
        int result = this.removeCategory(parameters[0]);
        return "Removed category '" + parameters[0] + "' from " + result + " entries.";
    }

    private String commandInfo() {
        return "Number of entries: " + this.getNumEntries() + " / Used categories: " + this.getCategories();
    }

    public void enableAutoImport() {
        FileWatcher.createFileWatcher(Paths.get(this.importFileName, new String[0]), new FileWatcher.FileChangedListener(){

            @Override
            public void fileChanged() {
                LOGGER.info("[AddressbookImport] Detected file change: Auto import..");
                Addressbook.this.importFromFile();
            }
        });
    }

    public synchronized void importFromFile() {
        Path file = Paths.get(this.importFileName, new String[0]);
        try (BufferedReader reader = Files.newBufferedReader(file, CHARSET);){
            String line;
            LOGGER.info("[AddressbookImport] " + file.toAbsolutePath());
            while ((line = reader.readLine()) != null) {
                String result = this.command(line);
                LOGGER.info(String.format("[AddressbookImport] %s [%s]", result, line));
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Failed importing addressbook from file: " + ex);
        }
    }

    public AddressbookEntry add(String name, String categories) {
        return this.add(name, Addressbook.getCategoriesFromString(categories));
    }

    public synchronized AddressbookEntry add(String name, Set<String> categories) {
        name = StringUtil.toLowerCase(name);
        this.addPresetCategories(categories);
        if (!this.entries.containsKey(name)) {
            this.set(name, categories);
            return null;
        }
        AddressbookEntry currentEntry = this.entries.get(name);
        AddressbookEntry changedEntry = new AddressbookEntry(currentEntry, categories);
        this.entries.put(name, changedEntry);
        if (!changedEntry.equalsFully(currentEntry)) {
            this.saveOnChange();
        }
        return changedEntry;
    }

    public synchronized void set(String name, Set<String> categories) {
        AddressbookEntry entry = new AddressbookEntry(name, categories);
        this.set(entry);
    }

    public synchronized void set(AddressbookEntry entry) {
        this.addPresetCategories(entry.getCategories());
        AddressbookEntry previousEntry = this.entries.put(entry.getName(), entry);
        if (!entry.equalsFully(previousEntry)) {
            this.saveOnChange();
        }
    }

    public synchronized void remove(AddressbookEntry entry) {
        this.remove(entry.getName());
    }

    public synchronized AddressbookEntry remove(String name) {
        AddressbookEntry removedEntry = this.entries.remove(StringUtil.toLowerCase(name));
        if (removedEntry != null) {
            this.saveOnChange();
        }
        return removedEntry;
    }

    public AddressbookEntry remove(String name, String categories) {
        return this.remove(name, Addressbook.getCategoriesFromString(categories));
    }

    public synchronized AddressbookEntry remove(String name, Set<String> categoriesToRemove) {
        AddressbookEntry currentEntry = this.entries.get(name = StringUtil.toLowerCase(name));
        if (currentEntry != null) {
            Set<String> currentCategories = currentEntry.getCategories();
            for (String category : categoriesToRemove) {
                currentCategories.remove(category);
            }
            AddressbookEntry changedEntry = new AddressbookEntry(name, currentCategories);
            this.entries.put(name, changedEntry);
            if (!currentEntry.equalsFully(changedEntry)) {
                this.saveOnChange();
            }
            return changedEntry;
        }
        return null;
    }

    public synchronized void rename(String name, AddressbookEntry entry) {
        this.entries.remove(StringUtil.toLowerCase(name));
        this.set(entry);
    }

    public synchronized int renameCategory(String currentName, String newName) {
        int count = 0;
        for (Map.Entry<String, AddressbookEntry> entry : this.entries.entrySet()) {
            if (!entry.getValue().hasCategory(currentName)) continue;
            AddressbookEntry changedEntry = Addressbook.renameCategory(entry.getValue(), currentName, newName);
            entry.setValue(changedEntry);
            ++count;
        }
        if (count > 0) {
            this.saveOnChange();
        }
        return count;
    }

    public synchronized int removeCategory(String categoryName) {
        int count = 0;
        for (Map.Entry<String, AddressbookEntry> entry : this.entries.entrySet()) {
            if (!entry.getValue().hasCategory(categoryName)) continue;
            AddressbookEntry changedEntry = Addressbook.renameCategory(entry.getValue(), categoryName, null);
            entry.setValue(changedEntry);
            ++count;
        }
        if (count > 0) {
            this.saveOnChange();
        }
        return count;
    }

    public static AddressbookEntry renameCategory(AddressbookEntry entry, String oldCategoryName, String newCategoryName) {
        Set<String> categories = entry.getCategories();
        categories.remove(oldCategoryName);
        if (newCategoryName != null) {
            categories.add(newCategoryName);
        }
        return new AddressbookEntry(entry.getName(), categories);
    }

    public synchronized AddressbookEntry get(String name) {
        return this.entries.get(StringUtil.toLowerCase(name));
    }

    public synchronized boolean hasCategory(String name, String category) {
        AddressbookEntry entry = this.get(name);
        if (entry != null) {
            return entry.hasCategory(category);
        }
        return false;
    }

    public synchronized Set<String> getNamesByCategory(String category) {
        HashSet<String> result = new HashSet<String>();
        for (AddressbookEntry entry : this.entries.values()) {
            if (!entry.hasCategory(category)) continue;
            result.add(entry.getName());
        }
        return result;
    }

    public synchronized List<AddressbookEntry> getEntries() {
        return new ArrayList<AddressbookEntry>(this.entries.values());
    }

    public static Set<String> getCategoriesFromString(String categoriesString) {
        String[] split;
        HashSet<String> categories = new HashSet<String>();
        for (String category : split = categoriesString.split(",")) {
            if ((category = StringUtil.toLowerCase(category.trim())).isEmpty() || category.contains(" ")) continue;
            categories.add(category);
        }
        return categories;
    }

    public static Set<String> changeCategories(Set<String> present, String change) {
        HashSet<String> result = new HashSet<String>(present);
        Pattern p = Pattern.compile("(\\+|-|!)(\\S+)");
        Matcher m = p.matcher(change);
        while (m.find()) {
            String action = m.group(1);
            Set<String> categories = Addressbook.getCategoriesFromString(m.group(2));
            if (action.equals("+")) {
                result.addAll(categories);
                continue;
            }
            if (action.equals("-")) {
                result.removeAll(categories);
                continue;
            }
            if (!action.equals("!")) continue;
            for (String cat : categories) {
                if (present.contains(cat)) {
                    result.remove(cat);
                    continue;
                }
                result.add(cat);
            }
        }
        return result;
    }

    public static String getStringFromCategories(Collection<String> categories) {
        return StringUtil.join(categories, ",");
    }

    public static String categoriesToString(Collection<String> categories) {
        return "'" + Addressbook.getStringFromCategories(categories) + "'";
    }

    public synchronized void loadFromFile() {
        this.entries.clear();
        Path file = Paths.get(this.fileName, new String[0]);
        try (BufferedReader reader = Files.newBufferedReader(file, CHARSET);){
            String line;
            do {
                AddressbookEntry parsedEntry;
                if ((parsedEntry = Addressbook.parseLine(line = reader.readLine())) == null) continue;
                this.entries.put(parsedEntry.getName(), parsedEntry);
            } while (line != null);
        }
        catch (IOException ex) {
            LOGGER.warning("Error reading addressbook: " + ex);
        }
        LOGGER.info("Read " + this.entries.size() + " addressbook entries from " + this.fileName);
        this.scanCategories();
    }

    public synchronized boolean loadFromSettings() {
        if (!this.settings.isValueSet(SETTING_NAME)) {
            LOGGER.info("Didn't load addressbook from settings");
            return false;
        }
        this.entries.clear();
        List values = this.settings.getList(SETTING_NAME);
        for (Object item : values) {
            AddressbookEntry entry;
            if (!(item instanceof List) || (entry = Addressbook.listToEntry((List)item)) == null) continue;
            this.entries.put(entry.getName(), entry);
        }
        LOGGER.info(String.format(Locale.ROOT, "Read %d addressbook entries from settings", this.entries.size()));
        this.scanCategories();
        return true;
    }

    private static AddressbookEntry listToEntry(List list) {
        if (list.size() > 1 && list.get(0) instanceof String && list.get(1) instanceof List) {
            String name = (String)list.get(0);
            HashSet<String> cats = new HashSet<String>();
            for (Object catObject : (List)list.get(1)) {
                if (!(catObject instanceof String)) continue;
                cats.add((String)catObject);
            }
            return new AddressbookEntry(name, cats);
        }
        return null;
    }

    private synchronized void saveToSettings() {
        ArrayList result = new ArrayList();
        for (AddressbookEntry entry : this.entries.values()) {
            ArrayList<Object> entryList = new ArrayList<Object>();
            entryList.add(entry.getName());
            entryList.add(new ArrayList<String>(entry.getCategories()));
            result.add(entryList);
        }
        this.settings.putList(SETTING_NAME, result);
    }

    public synchronized void setEntries(Collection<AddressbookEntry> newEntries) {
        this.entries.clear();
        for (AddressbookEntry entry : newEntries) {
            this.entries.put(entry.getName(), entry);
        }
        this.scanCategories();
    }

    public static AddressbookParsedEntries getParsedEntries(String input) {
        String[] split;
        ArrayList<String> duplicateNames = new ArrayList<String>();
        HashMap<String, AddressbookEntry> validEntries = new HashMap<String, AddressbookEntry>();
        ArrayList<String> invalidEntries = new ArrayList<String>();
        for (String line : split = StringUtil.splitLines(input)) {
            AddressbookEntry entry = Addressbook.parseLine(line);
            if (entry != null) {
                AddressbookEntry alreadyAddedEntry = validEntries.put(entry.getName(), entry);
                if (alreadyAddedEntry == null) continue;
                duplicateNames.add(alreadyAddedEntry.getName());
                continue;
            }
            if (line.trim().isEmpty()) continue;
            invalidEntries.add(line);
        }
        return new AddressbookParsedEntries(new ArrayList<AddressbookEntry>(validEntries.values()), invalidEntries, duplicateNames);
    }

    public static AddressbookEntry parseLine(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        String[] split = line.trim().split(" ");
        if (split.length == 1) {
            String name = split[0];
            return new AddressbookEntry(name, new HashSet<String>());
        }
        if (split.length == 2) {
            String name = split[0];
            Set<String> categories = Addressbook.getCategoriesFromString(split[1]);
            return new AddressbookEntry(name, categories);
        }
        return null;
    }

    private void saveOnChange() {
        if (this.settings != null && this.settings.getBoolean("abSaveOnChange")) {
            this.saveToFile();
        }
    }

    public synchronized void saveToFile() {
        Path file = Paths.get(this.fileName, new String[0]);
        Path tempFile = Paths.get(this.fileName + "-temp", new String[0]);
        LOGGER.info("Writing addressbook to " + this.fileName);
        System.out.println("Saving addressbook.");
        try {
            try (BufferedWriter writer = Files.newBufferedWriter(tempFile, CHARSET, new OpenOption[0]);){
                for (AddressbookEntry entry : this.entries.values()) {
                    writer.write(Addressbook.makeLine(entry));
                    writer.newLine();
                }
            }
            MiscUtil.moveFile(tempFile, file);
        }
        catch (IOException ex) {
            LOGGER.warning("Error writing addressbook: " + ex);
        }
    }

    public static String makeLine(AddressbookEntry entry) {
        return entry.getName() + " " + Addressbook.getStringFromCategories(entry.getCategories());
    }

    private void scanCategories() {
        this.presetCategories.clear();
        for (AddressbookEntry entry : this.entries.values()) {
            this.addPresetCategories(entry.getCategories());
        }
    }

    private void addPresetCategories(Collection<String> categories) {
        this.presetCategories.addAll(categories);
    }

    public synchronized List<String> getCategories() {
        return new ArrayList<String>(this.presetCategories);
    }

    public synchronized int getNumEntries() {
        return this.entries.size();
    }

    public static class AddressbookParsedEntries {
        public final List<AddressbookEntry> validEntries;
        public final List<String> invalidEntries;
        public final List<String> duplicateEntries;

        public AddressbookParsedEntries(List<AddressbookEntry> validEntries, List<String> invalidEntries, List<String> duplicateNames) {
            this.validEntries = validEntries;
            this.invalidEntries = invalidEntries;
            this.duplicateEntries = duplicateNames;
        }
    }
}

