/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.util.StringUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AddressbookEntry {
    private final String name;
    private final Set<String> categories;

    public AddressbookEntry(String name, Set<String> categories) {
        this.name = StringUtil.toLowerCase(name);
        this.categories = AddressbookEntry.createCategoriesSet(categories);
    }

    public AddressbookEntry(AddressbookEntry other, Set<String> categories) {
        this.name = StringUtil.toLowerCase(other.getName());
        this.categories = AddressbookEntry.createCategoriesSet(other.getCategories());
        this.categories.addAll(AddressbookEntry.createCategoriesSet(categories));
    }

    private static Set<String> createCategoriesSet(Set<String> categories) {
        HashSet<String> result = new HashSet<String>();
        for (String cat : categories) {
            result.add(StringUtil.toLowerCase(cat));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getCategories() {
        return new HashSet<String>(this.categories);
    }

    public boolean hasCategory(String category) {
        if (category == null) {
            return false;
        }
        return this.categories.contains(StringUtil.toLowerCase(category));
    }

    public String toString() {
        return this.name + " " + this.categories.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof AddressbookEntry) {
            return this.name.equals(((AddressbookEntry)o).getName());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equalsFully(AddressbookEntry o) {
        if (o == null) {
            return false;
        }
        return o.equals(this) && o.getCategories().equals(this.categories);
    }
}

