/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Helper;
import chatty.Room;
import chatty.RoomManager;
import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChannelFavorites {
    private static final int DAY = 86400000;
    private static final String SETTING = "roomFavorites";
    private final Settings settings;
    private final RoomManager roomManager;
    private final Map<String, Favorite> data = new HashMap<String, Favorite>();
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();

    public ChannelFavorites(Settings settings, RoomManager roomManager) {
        this.settings = settings;
        this.roomManager = roomManager;
        this.loadFromSettings();
        if (settings.getBoolean("historyClear")) {
            this.removeOld();
        }
        HashSet<Room> rooms = new HashSet<Room>();
        for (Favorite f : this.data.values()) {
            rooms.add(f.room);
        }
        roomManager.addRoomsIfNone(rooms);
        settings.addSettingsListener(s -> this.saveToSettings());
    }

    private synchronized void removeOld() {
        long days = this.settings.getLong("channelHistoryKeepDays");
        long keepAfter = System.currentTimeMillis() - days * 86400000L;
        this.clearHistory(keepAfter);
    }

    public void clearHistory() {
        this.clearHistory(System.currentTimeMillis());
    }

    private synchronized void clearHistory(long removeIfBefore) {
        Iterator<Map.Entry<String, Favorite>> it = this.data.entrySet().iterator();
        while (it.hasNext()) {
            Favorite f = it.next().getValue();
            if (f.isFavorite || f.lastJoined >= removeIfBefore) continue;
            it.remove();
        }
    }

    public synchronized Favorite get(String channel) {
        return this.data.get(channel);
    }

    public synchronized List<Favorite> getAll() {
        return new ArrayList<Favorite>(this.data.values());
    }

    public synchronized Set<String> getFavorites() {
        HashSet<String> result = new HashSet<String>();
        for (Favorite f : this.data.values()) {
            if (!f.isFavorite) continue;
            result.add(f.getChannel());
        }
        return result;
    }

    public synchronized boolean isFavorite(String channel) {
        if ((channel = Helper.toChannel(channel)) == null) {
            return false;
        }
        for (Favorite f : this.data.values()) {
            if (!f.isFavorite || !f.getChannel().equals(channel)) continue;
            return true;
        }
        return false;
    }

    public synchronized Favorite addFavorite(Favorite favorite) {
        Favorite existing = this.data.get(favorite.getChannel());
        if (existing != null) {
            return this.set(existing.setFavorite(true));
        }
        return this.set(favorite.setFavorite(true));
    }

    public synchronized Favorite addFavorite(String channel) {
        if (!Helper.isValidChannel(channel)) {
            return null;
        }
        Room room = this.roomManager.getRoom(Helper.toChannel(channel));
        return this.addFavorite(room);
    }

    public synchronized Favorite addFavorite(Room room) {
        return this.setFavorite(room, true);
    }

    public synchronized Favorite removeFavorite(Room room) {
        return this.setFavorite(room, false);
    }

    public synchronized Favorite removeFavorite(String channel) {
        if (!Helper.isValidChannel(channel)) {
            return null;
        }
        Room room = this.roomManager.getRoom(Helper.toChannel(channel));
        return this.removeFavorite(room);
    }

    public synchronized Favorite setFavorite(Room room, boolean isFavorite) {
        Favorite existing = this.data.get(room.getChannel());
        if (existing != null) {
            return this.set(existing.setFavorite(isFavorite));
        }
        if (isFavorite) {
            return this.set(new Favorite(room, -1L, isFavorite));
        }
        return null;
    }

    public synchronized void addJoined(Room room) {
        if (!this.settings.getBoolean("saveChannelHistory")) {
            return;
        }
        Favorite existing = this.data.get(room.getChannel());
        boolean isFavorite = false;
        if (existing != null) {
            isFavorite = existing.isFavorite;
        }
        this.set(new Favorite(room, System.currentTimeMillis(), isFavorite));
    }

    public synchronized Favorite remove(Favorite favorite) {
        if (this.data.containsKey(favorite.getChannel())) {
            Favorite removed = this.data.remove(favorite.getChannel());
            if (removed.isFavorite) {
                this.informListeners();
            }
            return removed;
        }
        return null;
    }

    private Favorite set(Favorite fav) {
        Favorite prev = this.data.put(fav.getChannel(), fav);
        if (prev == null && fav.isFavorite || prev != null && fav.isFavorite != prev.isFavorite) {
            this.informListeners();
        }
        return fav;
    }

    private synchronized void loadFromSettings() {
        this.data.clear();
        Map entries = this.settings.getMap(SETTING);
        for (String channel : entries.keySet()) {
            List entryValues = (List)entries.get(channel);
            Favorite fav = Favorite.fromList(entryValues, channel);
            if (fav == null) continue;
            this.data.put(fav.room.getChannel(), fav);
        }
        this.informListeners();
    }

    private synchronized void saveToSettings() {
        HashMap<String, List> entries = new HashMap<String, List>();
        for (Favorite f : this.data.values()) {
            List list = f.toList();
            entries.put(f.getChannel(), list);
        }
        this.settings.putMap(SETTING, entries);
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void informListeners() {
        for (ChangeListener listener : this.listeners) {
            listener.favoritesChanged();
        }
    }

    public static class Favorite {
        public final Room room;
        public final long lastJoined;
        public final boolean isFavorite;

        public Favorite(Room room, long lastJoined, boolean isFavorite) {
            this.room = room;
            this.lastJoined = lastJoined;
            this.isFavorite = isFavorite;
        }

        public String getChannel() {
            return this.room.getChannel();
        }

        public static Favorite fromList(List input, String channel) {
            String ownerStream;
            String name;
            Room room;
            long lastJoined = ((Number)input.get(0)).longValue();
            boolean isFavorite = (Boolean)input.get(1);
            if (input.size() == 2) {
                return new Favorite(Room.createRegular(channel), lastJoined, isFavorite);
            }
            if (input.size() == 3) {
                String ownerId = (String)input.get(2);
                return new Favorite(Room.createRegularWithId(channel, ownerId), lastJoined, isFavorite);
            }
            if (input.size() == 4 && (room = Room.createFromChannel(channel, name = (String)input.get(2), Helper.toChannel(ownerStream = (String)input.get(3)))) != null) {
                return new Favorite(room, lastJoined, isFavorite);
            }
            return null;
        }

        public List toList() {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.lastJoined);
            result.add(this.isFavorite);
            if (this.room.hasOwnerChannel() && this.room.hasStream() && !this.room.isOwner()) {
                result.add(this.room.getName());
                result.add(this.room.getStream());
            } else if (this.room.getStreamId() != null) {
                result.add(this.room.getStreamId());
            }
            return result;
        }

        public Favorite setFavorite(boolean isFavorite) {
            if (this.isFavorite == isFavorite) {
                return this;
            }
            return new Favorite(this.room, this.lastJoined, isFavorite);
        }

        public Favorite setJoined(long lastJoined) {
            return new Favorite(this.room, lastJoined, this.isFavorite);
        }

        public String toString() {
            return this.room.toString();
        }
    }

    public static interface ChangeListener {
        public void favoritesChanged();
    }
}

