/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.util.DateTime;
import chatty.util.StringUtil;

public class ChannelState {
    public static final int SLOWMODE_ON_INVALID = -2;
    private final String channel;
    private boolean subMode;
    private int slowMode;
    private boolean r9kMode;
    private boolean emoteOnly;
    private String lang;
    private int followersOnly = -1;
    private boolean shieldMode;
    private String info = "";

    public ChannelState(String channel) {
        this.channel = channel;
    }

    public String getChannel() {
        return this.channel;
    }

    public synchronized boolean reset() {
        boolean changed = false;
        if (this.setSubMode(false)) {
            changed = true;
        }
        if (this.setSlowMode(-1)) {
            changed = true;
        }
        if (this.setR9kMode(false)) {
            changed = true;
        }
        if (this.setEmoteOnly(false)) {
            changed = true;
        }
        if (this.setFollowersOnly(-1)) {
            changed = true;
        }
        if (this.setShieldMode(false)) {
            changed = true;
        }
        return changed;
    }

    public synchronized boolean setSubMode(boolean enabled) {
        if (this.subMode != enabled) {
            this.subMode = enabled;
            this.updateInfo();
            return true;
        }
        return false;
    }

    public synchronized boolean subMode() {
        return this.subMode;
    }

    public synchronized boolean setSlowMode(int length) {
        if (this.slowMode != length) {
            this.slowMode = length;
            this.updateInfo();
            return true;
        }
        return false;
    }

    public synchronized int slowMode() {
        return this.slowMode;
    }

    public synchronized boolean setR9kMode(boolean enabled) {
        if (this.r9kMode != enabled) {
            this.r9kMode = enabled;
            this.updateInfo();
            return true;
        }
        return false;
    }

    public synchronized boolean r9kMode() {
        return this.r9kMode;
    }

    public synchronized boolean setEmoteOnly(boolean enabled) {
        if (this.emoteOnly != enabled) {
            this.emoteOnly = enabled;
            this.updateInfo();
            return true;
        }
        return false;
    }

    public synchronized boolean emoteOnly() {
        return this.emoteOnly;
    }

    public synchronized boolean setShieldMode(boolean enabled) {
        if (this.shieldMode != enabled) {
            this.shieldMode = enabled;
            this.updateInfo();
            return true;
        }
        return false;
    }

    public synchronized boolean shieldMode() {
        return this.shieldMode;
    }

    public synchronized boolean setLang(String lang) {
        if (this.lang == null && lang != null || this.lang != null && !this.lang.equals(lang)) {
            this.lang = lang;
            this.updateInfo();
            return true;
        }
        return false;
    }

    public synchronized boolean setFollowersOnly(int minutes) {
        if (this.followersOnly != minutes) {
            this.followersOnly = minutes;
            this.updateInfo();
            return true;
        }
        return false;
    }

    public synchronized int followersOnly() {
        return this.followersOnly;
    }

    public String getInfo() {
        return this.info;
    }

    private void updateInfo() {
        String result = "";
        String sep = "|";
        if (this.shieldMode) {
            result = StringUtil.append(result, sep, "Shield");
        }
        if (this.slowMode == -2 || this.slowMode > 86400) {
            result = StringUtil.append(result, sep, "Slow: >day");
        } else if (this.slowMode > 999) {
            result = StringUtil.append(result, sep, "Slow: " + DateTime.duration((long)(this.slowMode * 1000), 1, 0, new DateTime.Formatting[0]));
        } else if (this.slowMode > 0) {
            result = StringUtil.append(result, sep, "Slow: " + this.slowMode);
        }
        if (this.subMode) {
            result = StringUtil.append(result, sep, "Sub");
        }
        if (this.followersOnly == -2) {
            result = StringUtil.append(result, sep, "Followers: ?");
        } else if (this.followersOnly > 0) {
            result = StringUtil.append(result, sep, "Followers: " + DateTime.duration((long)this.followersOnly * 60L * 1000L, 1, 1, DateTime.Formatting.COMPACT));
        } else if (this.followersOnly == 0) {
            result = StringUtil.append(result, sep, "Followers");
        }
        if (this.r9kMode) {
            result = StringUtil.append(result, sep, "r9k");
        }
        if (this.emoteOnly) {
            result = StringUtil.append(result, sep, "EmoteOnly");
        }
        if (this.lang != null && !this.lang.isEmpty()) {
            result = StringUtil.append(result, sep, this.lang);
        }
        if (!result.isEmpty()) {
            result = "[" + result + "]";
        }
        this.info = result;
    }
}

