/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.ChannelState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ChannelStateManager {
    private final Map<String, ChannelState> states = new HashMap<String, ChannelState>();
    private final Set<ChannelStateListener> listeners = new HashSet<ChannelStateListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelState getState(String channel) {
        Map<String, ChannelState> map = this.states;
        synchronized (map) {
            ChannelState s = this.states.get(channel);
            if (s != null) {
                return s;
            }
            s = new ChannelState(channel);
            this.states.put(channel, s);
            return s;
        }
    }

    public void addListener(ChannelStateListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void updated(String channel) {
        ChannelState s = this.getState(channel);
        for (ChannelStateListener l : this.listeners) {
            l.channelStateUpdated(s);
        }
    }

    public void setSlowmode(String channel, int length) {
        if (this.getState(channel).setSlowMode(length)) {
            this.updated(channel);
        }
    }

    public void setSlowmode(String channel, String length) {
        if (length != null && length.matches("^[0-9]+$")) {
            try {
                this.setSlowmode(channel, Integer.parseInt(length));
            }
            catch (NumberFormatException ex) {
                this.setSlowmode(channel, -2);
            }
        } else {
            this.setSlowmode(channel, -1);
        }
    }

    public void setFollowersOnly(String channel, int minutes) {
        if (this.getState(channel).setFollowersOnly(minutes)) {
            this.updated(channel);
        }
    }

    public void setFollowersOnly(String channel, String length) {
        if (length != null && length.matches("^-?[0-9]+$")) {
            try {
                this.setFollowersOnly(channel, Integer.parseInt(length));
            }
            catch (NumberFormatException ex) {
                this.setFollowersOnly(channel, -2);
            }
        } else {
            this.setSlowmode(channel, -1);
        }
    }

    public void setShieldMode(String channel, boolean enabled) {
        if (this.getState(channel).setShieldMode(enabled)) {
            this.updated(channel);
        }
    }

    public void setSubmode(String channel, boolean enabled) {
        if (this.getState(channel).setSubMode(enabled)) {
            this.updated(channel);
        }
    }

    public void setR9kMode(String channel, boolean enabled) {
        if (this.getState(channel).setR9kMode(enabled)) {
            this.updated(channel);
        }
    }

    public void setEmoteOnly(String channel, boolean enabled) {
        if (this.getState(channel).setEmoteOnly(enabled)) {
            this.updated(channel);
        }
    }

    public void setLang(String channel, String lang) {
        if (this.getState(channel).setLang(lang)) {
            this.updated(channel);
        }
    }

    public void reset(String channel) {
        if (this.getState(channel).reset()) {
            this.updated(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashSet<ChannelState> statesCopy;
        Map<String, ChannelState> map = this.states;
        synchronized (map) {
            statesCopy = new HashSet<ChannelState>(this.states.values());
        }
        for (ChannelState s : statesCopy) {
            if (!s.reset()) continue;
            this.updated(s.getChannel());
        }
    }

    public static interface ChannelStateListener {
        public void channelStateUpdated(ChannelState var1);
    }
}

