/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.CustomPaths;
import chatty.Helper;
import chatty.TwitchClient;
import chatty.gui.components.updating.Stuff;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.ElapsedTime;
import chatty.util.LogUtil;
import chatty.util.MiscUtil;
import chatty.util.SingleInstance;
import chatty.util.settings.Settings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Chatty {
    public static final boolean DEBUG = false;
    public static final boolean HOTKEY = true;
    public static final String WEBSITE = "https://chatty.github.io";
    public static final String CLIENT_ID = "spyiu9jqdnfjtwv6l1xjk5zgt8qb91l";
    public static final String REDIRECT_URI = "http://127.0.0.1:61324/token/";
    public static final String VERSION = "0.28";
    public static final boolean VERSION_CHECK_ENABLED = false;
    public static final String VERSION_URL = "http://chatty.github.io/version.txt";
    public static final String VERSION_TEST_URL = "http://127.0.0.1/twitch/version.txt";
    private static final int DEFAULT_SINGLE_INSTANCE_PORT = 48724;
    private static final ElapsedTime UPTIME = new ElapsedTime(true);
    private static final long STARTED_TIME = System.currentTimeMillis();
    private static final CustomPaths paths = new CustomPaths();
    private static String[] args;

    public static void main(String[] args) {
        Path path;
        int port;
        Chatty.args = args;
        Map<String, String> parsedArgs = MiscUtil.parseArgs(args);
        if (parsedArgs.containsKey("single") && !SingleInstance.registerInstance(port = Chatty.getInstancePort(parsedArgs))) {
            SingleInstance.notifyRunningInstance(port, Chatty.encodeParametersToJSON(parsedArgs));
            return;
        }
        if (parsedArgs.containsKey("appwdir") && !parsedArgs.containsKey("regularwdir") && (path = Stuff.determineJarPath()) != null) {
            path = path.getParent();
            paths.setCustom(PathType.WORKING, path, "-appwdir", false);
            System.setProperty("user.dir", path.toString());
        }
        if (parsedArgs.containsKey("cd")) {
            paths.setCustom(PathType.SETTINGS, System.getProperty("user.dir"), "-cd", false);
        }
        if (parsedArgs.containsKey("portable") && (path = Stuff.determineJarPath()) != null) {
            paths.setCustom(PathType.SETTINGS, path.getParent().resolve("portable_settings"), "-portable", false);
        }
        if (parsedArgs.containsKey("d")) {
            paths.setCustom(PathType.SETTINGS, parsedArgs.get("d"), "-d", true);
        }
        if (parsedArgs.containsKey("debugdir")) {
            paths.setCustom(PathType.DEBUG, parsedArgs.get("debugdir"), "-debugdir", true);
        }
        TwitchClient client = new TwitchClient(parsedArgs);
        SingleInstance.setNewInstanceListener(message -> {
            Map<String, String> args1 = Chatty.decodeParametersFromJSON(message);
            if (args1.containsKey("channel")) {
                String channel = args1.get("channel");
                client.joinChannels(Helper.parseChannelsFromString(channel, false));
            }
            client.customCommandLaunch(args1.get("cc"));
        });
        LogUtil.startMemoryUsageLogging();
        LogUtil.startEdtLockDetection();
    }

    private static String encodeParametersToJSON(Map<String, String> parameters) {
        JSONObject object = new JSONObject();
        object.putAll(parameters);
        return object.toJSONString();
    }

    private static Map<String, String> decodeParametersFromJSON(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            HashMap<String, String> result = new HashMap<String, String>();
            for (Object key : root.keySet()) {
                result.put((String)key, (String)root.get(key));
            }
            return result;
        }
        catch (Exception ex) {
            return new HashMap<String, String>();
        }
    }

    private static int getInstancePort(Map<String, String> args) {
        int port = 48724;
        String arg = args.get("single");
        if (arg != null) {
            try {
                port = Integer.parseInt(arg);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return port;
    }

    private static Path getUserDataDirectory() {
        return paths.getPath(PathType.SETTINGS);
    }

    private static Path getWorkingDirectory() {
        return paths.getPath(PathType.WORKING);
    }

    public static Path toAbsolutePathWdir(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return Paths.get(System.getProperty("user.dir"), path.toString());
    }

    public static Path getPath(PathType type) {
        return paths.getPath(type);
    }

    public static Path getPathCreate(PathType type) {
        return paths.getPathAndCreate(type);
    }

    public static void updateCustomPathFromSettings(PathType type) {
        paths.updateFromSettings(type);
    }

    public static void setCustomPath(PathType type, Path path) {
        paths.setCustom(type, path, null, true);
    }

    public static Path getDefaultPath(PathType type) {
        return paths.get(type).getDefault();
    }

    public static Path getOrigPath(PathType type) {
        return paths.get(type).getOrig();
    }

    public static String getPathDebug() {
        return paths.getDebugInfo();
    }

    public static String getCustomPathInfo(PathType type) {
        return paths.get(type).getCustomInfo();
    }

    public static String getPathInfo(PathType type) {
        return paths.getInfo(type);
    }

    public static String getInvalidCustomPath(PathType type) {
        return paths.get(type).getInvalid();
    }

    public static String getInvalidPathInfo() {
        return paths.getInvalidInfo();
    }

    public static void setSettings(Settings settings) {
        paths.setSettings(settings);
    }

    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String chattyVersion() {
        return String.format("Chatty Version %s%s%s", VERSION, " Hotkey", "");
    }

    public static String uptime() {
        return DateTime.duration(UPTIME.millisElapsedSync(), new DateTime.Formatting[0]);
    }

    public static long uptimeMillis() {
        return UPTIME.millisElapsedSync();
    }

    public static long uptimeSeconds() {
        return UPTIME.secondsElapsedSync();
    }

    public static long startedTime() {
        return STARTED_TIME;
    }

    public static String[] getArgs() {
        return args;
    }

    public static void println(String output) {
        if (Debugging.isEnabled("println")) {
            System.out.println(output);
        }
    }

    public static enum PathType {
        SETTINGS(() -> Paths.get(System.getProperty("user.home"), ".chatty"), null),
        WORKING(() -> Paths.get(System.getProperty("user.dir"), new String[0]), null),
        BACKUP(() -> Chatty.getUserDataDirectory().resolve("backup"), null),
        IMAGE(() -> Chatty.getWorkingDirectory().resolve("img"), "imgPath"),
        DEBUG(() -> Chatty.getUserDataDirectory().resolve("debuglogs"), null),
        CACHE(() -> Chatty.getUserDataDirectory().resolve("cache"), "cachePath"),
        SOUND(() -> Chatty.getWorkingDirectory().resolve("sounds"), "soundsPath"),
        EXPORT(() -> Chatty.getUserDataDirectory().resolve("exported"), "exportPath"),
        LOGS(() -> Chatty.getUserDataDirectory().resolve("logs"), "logPath");

        public final Supplier<Path> createDefault;
        public final String settingName;

        private PathType(Supplier<Path> createDefault, String settingName) {
            this.createDefault = createDefault;
            this.settingName = settingName;
        }
    }
}

