/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Room;
import chatty.util.StringUtil;
import chatty.util.commands.Parameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;

public class Commands {
    private final Map<String, Command> commands = new HashMap<String, Command>();

    public void add(String name, Consumer<CommandParameters> action, String ... aliases) {
        this.add(name, "", action, false, aliases);
    }

    public void add(String name, String description, Consumer<CommandParameters> action, String ... aliases) {
        this.add(name, description, action, false, aliases);
    }

    public void addEdt(String name, Consumer<CommandParameters> action, String ... aliases) {
        this.add(name, "", action, true, aliases);
    }

    public void addEdt(String name, String description, Consumer<CommandParameters> action, String ... aliases) {
        this.add(name, description, action, true, aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name, String description, Consumer<CommandParameters> action, boolean edt, String ... aliases) {
        Map<String, Command> map = this.commands;
        synchronized (map) {
            Command c = new Command(name, new ArrayList<String>(Arrays.asList(aliases)), description, action, edt);
            this.commands.put(StringUtil.toLowerCase(name), c);
            for (String alias : aliases) {
                this.commands.put(StringUtil.toLowerCase(alias), c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCommand(String name) {
        Map<String, Command> map = this.commands;
        synchronized (map) {
            return this.commands.containsKey(StringUtil.toLowerCase(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCommandNames() {
        Map<String, Command> map = this.commands;
        synchronized (map) {
            HashSet<String> result = new HashSet<String>();
            for (Command c : this.commands.values()) {
                result.add(c.name);
                c.aliases.forEach(name -> result.add((String)name));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Command getCommand(String commandName) {
        Map<String, Command> map = this.commands;
        synchronized (map) {
            return this.commands.get(StringUtil.toLowerCase(commandName));
        }
    }

    public boolean performCommand(String commandName, Room room, Parameters parameters) {
        Command c = this.getCommand(commandName);
        if (c != null) {
            c.performAction(room, parameters, commandName);
            return true;
        }
        return false;
    }

    public static class Command {
        private final String name;
        private final String description;
        private final Consumer<CommandParameters> action;
        private final boolean edt;
        private final List<String> aliases;

        public Command(String name, List<String> aliases, String description, Consumer<CommandParameters> action, boolean edt) {
            this.name = name;
            this.aliases = aliases;
            this.description = description;
            this.action = action;
            this.edt = edt;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUsage() {
            if (StringUtil.isNullOrEmpty(this.description)) {
                return null;
            }
            return String.format("Usage: /%s %s%s", this.name, this.description, StringUtil.aEmptyb(StringUtil.join(this.aliases, ", ", o -> "/" + o), "", " (Alias: %s)"));
        }

        public void performAction(Room room, Parameters parameters, String enteredCommandName) {
            if (this.edt && !SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(() -> this.action.accept(new CommandParameters(room, parameters, this, enteredCommandName)));
            } else {
                this.action.accept(new CommandParameters(room, parameters, this, enteredCommandName));
            }
        }
    }

    public static class CommandParsedArgs {
        public final String[] args;
        public final String options;

        public CommandParsedArgs(String options, String[] args) {
            this.args = args;
            this.options = options;
        }

        public String get(int index) {
            return this.args[index];
        }

        public boolean has(int index) {
            return this.args.length > index;
        }

        public String get(int index, String def) {
            if (this.has(index)) {
                return this.args[index];
            }
            return def;
        }

        public int getInt(int index, int def) {
            if (this.has(index)) {
                try {
                    return Integer.parseInt(this.args[index]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return def;
        }

        public boolean hasOption(String option) {
            return this.options != null && this.options.contains(option);
        }

        public static CommandParsedArgs parse(String input, int numArgs) {
            return CommandParsedArgs.parse(input, numArgs, numArgs);
        }

        public static CommandParsedArgs parse(String input, int numArgs, int numRequiredArgs) {
            if (input == null) {
                if (numRequiredArgs == 0) {
                    return new CommandParsedArgs(null, "".split(""));
                }
                return null;
            }
            String options = null;
            int optionsTo = 0;
            if (input.startsWith("-")) {
                optionsTo = input.indexOf(" ");
                if (optionsTo == -1) {
                    optionsTo = input.length();
                }
                if ((options = input.substring(1, optionsTo)).isEmpty()) {
                    options = null;
                }
                ++optionsTo;
            }
            if (optionsTo >= input.length()) {
                if (numArgs == 0) {
                    return new CommandParsedArgs(options, null);
                }
                return null;
            }
            String args = input.substring(optionsTo);
            if (numArgs > 0) {
                String[] split = args.split(" ", numArgs);
                if (split.length >= numRequiredArgs) {
                    return new CommandParsedArgs(options, split);
                }
                return null;
            }
            return new CommandParsedArgs(options, new String[]{args});
        }
    }

    public static class CommandParameters {
        private final Room room;
        private final Parameters parameters;
        private final Command command;
        private final String enteredCommandName;

        public CommandParameters(Room room, Parameters parameters, Command command, String enteredCommandName) {
            this.room = room;
            this.parameters = parameters;
            this.command = command;
            this.enteredCommandName = enteredCommandName;
        }

        public Command getCommand() {
            return this.command;
        }

        public String getEnteredCommandName() {
            return this.enteredCommandName;
        }

        public Room getRoom() {
            return this.room;
        }

        public String getChannel() {
            return this.room.getChannel();
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        public String getArgs() {
            return this.parameters.getArgs();
        }

        public String getArgsTrimNonNull() {
            String args = StringUtil.trim(this.getArgs());
            if (args != null) {
                return args;
            }
            return "";
        }

        public boolean hasArgs() {
            return !StringUtil.isNullOrEmpty(this.parameters.getArgs());
        }

        public CommandParsedArgs parsedArgs(int numArgs) {
            return CommandParsedArgs.parse(this.getArgs(), numArgs);
        }

        public CommandParsedArgs parsedArgs(int numArgs, int numRequiredArgs) {
            return CommandParsedArgs.parse(this.getArgs(), numArgs, numRequiredArgs);
        }
    }
}

