/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Helper;
import chatty.util.Debugging;
import chatty.util.StringUtil;
import chatty.util.settings.SettingChangeListener;
import chatty.util.settings.Settings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CustomNames {
    private static final String SETTING_NAME = "customNames";
    private final Set<CustomNamesListener> listeners = new HashSet<CustomNamesListener>();
    private final Settings settings;
    private final Set<String> origNames = new HashSet<String>();

    public CustomNames(Settings settings) {
        this.settings = settings;
        this.updateOrigNames();
        settings.addSettingChangeListener(new SettingChangeListener(){

            @Override
            public void settingChanged(String setting, int type, Object value) {
                if (setting.equals(CustomNames.SETTING_NAME)) {
                    CustomNames.this.informListenersAllChanged();
                }
            }
        });
    }

    public void setCustomName(String nick, String customNick) {
        if (nick == null) {
            return;
        }
        nick = StringUtil.toLowerCase(nick);
        if (customNick == null) {
            this.settings.mapRemove(SETTING_NAME, nick);
        } else {
            this.settings.mapPut(SETTING_NAME, nick, customNick);
        }
        this.informListeners(nick, customNick);
        this.updateOrigNames();
    }

    public String getCustomName(String nick) {
        nick = StringUtil.toLowerCase(nick);
        return (String)this.settings.mapGet(SETTING_NAME, nick);
    }

    public String commandSetCustomName(String parameter) {
        String[] split;
        if (parameter != null && (split = parameter.split(" ", 2)).length == 2) {
            String name = split[0];
            String customName = split[1];
            if (!Helper.isValidStream(name)) {
                return "Invalid name.";
            }
            this.setCustomName(name, customName);
            return "Set custom name for '" + name + "' to '" + customName + "'";
        }
        return "Usage: /setname <name> <custom_name>";
    }

    public String commandResetCustomname(String parameter) {
        String[] split;
        if (parameter != null && (split = parameter.split(" ")).length == 1) {
            String name = split[0];
            if (!Helper.isValidStream(name)) {
                return "Invalid name.";
            }
            this.setCustomName(name, null);
            return "Removed custom name for '" + name + "'";
        }
        return "Usage: /resetname <name>";
    }

    private void informListeners(String name, String customName) {
        Debugging.println(SETTING_NAME, "%s => %s", name, customName);
        for (CustomNamesListener listener : this.getListeners()) {
            listener.setName(name, customName);
        }
    }

    private void informListenersAllChanged() {
        Map customNames = this.settings.getMap(SETTING_NAME);
        this.fillRemovedNames(customNames);
        for (String username : customNames.keySet()) {
            this.informListeners(username, (String)customNames.get(username));
        }
        this.updateOrigNames();
    }

    public synchronized void addListener(CustomNamesListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private synchronized Set<CustomNamesListener> getListeners() {
        return new HashSet<CustomNamesListener>(this.listeners);
    }

    private synchronized void updateOrigNames() {
        Map customNames = this.settings.getMap(SETTING_NAME);
        this.origNames.clear();
        this.origNames.addAll(customNames.keySet());
        Debugging.println(SETTING_NAME, "OrigNames: %s", this.origNames);
    }

    private synchronized void fillRemovedNames(Map<String, String> names) {
        for (String name : this.origNames) {
            if (names.containsKey(name)) continue;
            names.put(name, null);
        }
    }

    public static interface CustomNamesListener {
        public void setName(String var1, String var2);
    }
}

