/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Chatty;
import chatty.util.StringUtil;
import chatty.util.settings.Settings;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class CustomPaths {
    private final Map<Chatty.PathType, ChattyPath> paths = new HashMap<Chatty.PathType, ChattyPath>();
    private Settings settings;

    public synchronized Path getPath(Chatty.PathType type) {
        return this.get(type).get();
    }

    public synchronized Path getPathAndCreate(Chatty.PathType type) {
        return this.get(type).getAndCreate();
    }

    public synchronized ChattyPath get(Chatty.PathType type) {
        if (!this.paths.containsKey((Object)type)) {
            ChattyPath p = new ChattyPath();
            p.defaultDir = type.createDefault.get();
            this.paths.put(type, p);
        }
        return this.paths.get((Object)type);
    }

    public synchronized void setSettings(Settings settings) {
        this.settings = settings;
        for (Chatty.PathType type : Chatty.PathType.values()) {
            if (type.settingName == null) continue;
            this.loadFromSettings(type);
        }
    }

    private synchronized boolean loadFromSettings(Chatty.PathType type) {
        if (this.settings == null || type.settingName == null) {
            return false;
        }
        String value = this.settings.getString(type.settingName);
        if (value.isEmpty()) {
            return false;
        }
        try {
            Path path = Paths.get(value, new String[0]);
            this.setCustom(type, path, "setting " + type.settingName, true);
            return true;
        }
        catch (InvalidPathException ex) {
            ChattyPath p = this.get(type);
            p.customDir = null;
            p.invalidCustomDir = value;
            p.customInfo = "setting " + type.settingName;
            return false;
        }
    }

    public void updateFromSettings(Chatty.PathType type) {
        this.loadFromSettings(type);
    }

    public synchronized void setCustom(Chatty.PathType type, Path path, String info, boolean requireExists) {
        ChattyPath p = this.get(type);
        if (!path.isAbsolute()) {
            path = Paths.get(System.getProperty("user.dir"), path.toString());
        }
        if (requireExists && !Files.isDirectory(path, new LinkOption[0])) {
            p.customDir = null;
            p.invalidCustomDir = path.toString();
            p.customInfo = info;
        } else {
            p.customDir = path;
            p.invalidCustomDir = null;
            p.customInfo = info;
        }
    }

    public void setCustom(Chatty.PathType type, String path, String info, boolean requireExists) {
        this.setCustom(type, Paths.get(path, new String[0]), info, requireExists);
    }

    public synchronized String getInfo(Chatty.PathType type) {
        String customInfo;
        ChattyPath p = this.get(type);
        String string = customInfo = p.getCustomInfo() != null ? " (via " + p.getCustomInfo() + ")" : "";
        if (p.getInvalid() != null) {
            return String.format("'%s', invalid custom path not used: '%s'%s", p.get(), p.getInvalid(), customInfo);
        }
        return String.format("'%s'%s%s", p.get(), customInfo, p.getOrig() != null ? " (default: '" + p.getOrig() + "')" : "");
    }

    public synchronized String getDebugInfo() {
        StringBuilder b = new StringBuilder();
        for (Chatty.PathType type : this.paths.keySet()) {
            ChattyPath path = this.paths.get((Object)type);
            String info = "";
            if (path.getInvalid() != null) {
                info = StringUtil.append(info, " ", String.format("[Invalid] %s", path.getInvalid()));
            }
            if (path.getOrig() != null) {
                info = StringUtil.append(info, " ", String.format("%s (%s)", path.customDir, path.getOrig()));
            }
            if (path.getCustomInfo() != null) {
                info = StringUtil.append(info, " ", String.format("via %s", path.getCustomInfo()));
            }
            if (info.isEmpty()) continue;
            b.append(String.format("[%s] %s\n", new Object[]{type, info}));
        }
        if (b.length() > 0) {
            b.insert(0, "[Custom Paths]\n");
        }
        return b.toString();
    }

    public synchronized String getInvalidInfo() {
        StringBuilder b = new StringBuilder();
        for (Chatty.PathType type : this.paths.keySet()) {
            ChattyPath path = this.paths.get((Object)type);
            String info = "";
            if (path.getInvalid() == null) continue;
            b.append(StringUtil.append(info, " ", String.format("[%s] %s (%s)\n", new Object[]{type, path.getInvalid(), path.getCustomInfo()})));
        }
        if (b.length() > 0) {
            b.insert(0, "Invalid custom paths:\n");
        }
        return b.toString();
    }

    public static class ChattyPath {
        private Path defaultDir;
        private String invalidCustomDir;
        private Path customDir;
        private String customInfo;

        public Path get() {
            if (this.customDir != null) {
                return this.customDir;
            }
            return this.defaultDir;
        }

        public Path getAndCreate() {
            Path path = this.get();
            path.toFile().mkdirs();
            return path;
        }

        public String getInvalid() {
            return this.invalidCustomDir;
        }

        public Path getOrig() {
            return this.customDir != null ? this.defaultDir : null;
        }

        public String getCustomInfo() {
            return this.customInfo;
        }

        public Path getDefault() {
            return this.defaultDir;
        }
    }
}

