/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Logging;
import chatty.util.TimedCounter;
import java.util.logging.Logger;

public class ErrorHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(ErrorHandler.class.getName());
    private final TimedCounter counter = new TimedCounter(60000L);

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.counter.increase();
        if (this.counter.getCount(false) > 1000) {
            LOGGER.warning("Over 1000 errors in a minute, exiting application.");
            System.exit(1);
        }
        if (e == null && t != null) {
            LOGGER.severe("Unknown exception in thread " + t.toString());
            return;
        }
        if (e == null && t == null) {
            LOGGER.severe("Unknown exception");
            return;
        }
        try {
            String stacktrace = Logging.getStacktrace(e);
            if (t != null && t.getName() != null && t.getName().startsWith("JKeyMaster-")) {
                LOGGER.warning(String.format("[%s/%s][%s][%s]\n%s", e.getClass(), e.getLocalizedMessage(), e.getCause(), Thread.currentThread(), stacktrace));
                LOGGER.log(Logging.USERINFO, "A global hotkey error occured. Check debug logs for more details.");
            } else {
                LOGGER.severe(String.format("[%s/%s][%s][%s]\n%s", e.getClass(), e.getLocalizedMessage(), e.getCause(), Thread.currentThread(), stacktrace));
            }
        }
        catch (Throwable ex) {
            LOGGER.severe("Exception " + ex + "\n\toccured during logging of uncaught exception: " + e.getClass().getName() + " [" + t.toString() + "]");
        }
    }
}

