/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Room;
import chatty.User;
import chatty.gui.MainGui;
import chatty.gui.components.settings.MainSettings;
import chatty.gui.components.textpane.UserNotice;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.Replacer;
import chatty.util.StringUtil;
import chatty.util.commands.Parameters;
import chatty.util.dnd.DockLayout;
import chatty.util.irc.MsgTags;
import chatty.util.settings.FileManager;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final Logger LOGGER = Logger.getLogger(Helper.class.getName());
    public static final DecimalFormat VIEWERCOUNT_FORMAT = new DecimalFormat();
    public static ParseChannelHelper parseChannelHelper;
    public static final String USERNAME_REGEX = "[a-zA-Z0-9][a-zA-Z0-9_]+";
    public static final Pattern CHANNEL_PATTERN;
    public static final Pattern CHATROOM_PATTERN;
    public static final Pattern STREAM_PATTERN;
    public static final Pattern WHISPER_PATTERN;
    private static final String TWITCH_URL_PREFIX = "(?:https?://)?(?:www\\.)?twitch\\.tv";
    private static final Pattern CHANNEL_URL_PATTERN;
    private static final Pattern POPOUT_URL_PATTERN;
    private static final Pattern COMBINING_CHARACTERS_STRICT;
    private static final Pattern COMBINING_CHARACTERS_LENIENT;
    public static final int FILTER_COMBINING_CHARACTERS_OFF = 0;
    public static final int FILTER_COMBINING_CHARACTERS_LENIENT = 1;
    public static final int FILTER_COMBINING_CHARACTERS_STRICT = 2;
    private static final Pattern ALL_UPERCASE_LETTERS;
    private static final Replacer HTMLSPECIALCHARS_ENCODE;
    private static final Replacer HTMLSPECIALCHARS_DECODE;
    private static final Replacer TAGS_VALUE_DECODE;
    private static final Replacer TAGS_VALUE_ENCODE;
    private static final Pattern EMOJI_VARIATION_SELECTOR;
    private static final Pattern UNDERSCORE;
    private static final String TLD = "(?:tv|com|org|edu|gov|uk|net|ca|de|jp|fr|au|us|ru|ch|it|nl|se|no|es|me|gl|fm|io|gg|be)";
    private static final String MID = "[^\\s]";
    private static final String END = "[^:,.\\s]";
    private static final String S1 = "(?:(?:https?)://|www\\.)";
    private static final String S2 = "(?:[A-Z0-9.-]+[A-Z0-9]\\.(?:tv|com|org|edu|gov|uk|net|ca|de|jp|fr|au|us|ru|ch|it|nl|se|no|es|me|gl|fm|io|gg|be)\\b)";
    private static final String T1 = "(?:(?:(?:(?:https?)://|www\\.)|(?:[A-Z0-9.-]+[A-Z0-9]\\.(?:tv|com|org|edu|gov|uk|net|ca|de|jp|fr|au|us|ru|ch|it|nl|se|no|es|me|gl|fm|io|gg|be)\\b))[^\\s]*[^:,.\\s])";
    private static final String T2 = "(?:(?:[A-Z0-9.-]+[A-Z0-9]\\.(?:tv|com|org|edu|gov|uk|net|ca|de|jp|fr|au|us|ru|ch|it|nl|se|no|es|me|gl|fm|io|gg|be)\\b))";
    private static final String URL_REGEX = "(?i)\\b(?:(?:(?:(?:https?)://|www\\.)|(?:[A-Z0-9.-]+[A-Z0-9]\\.(?:tv|com|org|edu|gov|uk|net|ca|de|jp|fr|au|us|ru|ch|it|nl|se|no|es|me|gl|fm|io|gg|be)\\b))[^\\s]*[^:,.\\s])|(?:(?:[A-Z0-9.-]+[A-Z0-9]\\.(?:tv|com|org|edu|gov|uk|net|ca|de|jp|fr|au|us|ru|ch|it|nl|se|no|es|me|gl|fm|io|gg|be)\\b))";
    private static final Pattern URL_PATTERN;
    public static String ESCAPE_FOR_CHAIN_COMMAND;
    public static String ESCAPE_FOR_FOREACH_COMMAND;
    private static final Map<UserNotice, Timer> pointsMerge;
    private static final Instant CHAT_COMMAND_SHUTOFF;

    public static String formatViewerCount(int viewerCount) {
        return VIEWERCOUNT_FORMAT.format(viewerCount);
    }

    public static Set<String> parseChannelsFromString(String channels, boolean prepend) {
        String[] parts = channels.split(",");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String part : parts) {
            String channel = part.trim();
            if (Helper.isValidChannel(channel = Helper.getChannelFromUrl(channel))) {
                Helper.addValidChannel(channel, prepend, result);
                continue;
            }
            if (!channel.startsWith("[") || !channel.endsWith("]") || channel.length() <= 2 || parseChannelHelper == null) continue;
            String[] catSplit = channel.substring(1, channel.length() - 1).split(" ");
            String cat = catSplit[0];
            boolean noChans = false;
            boolean onlyChans = false;
            boolean onlyLive = false;
            for (int i = 1; i < catSplit.length; ++i) {
                if (catSplit[i].equals("#")) {
                    onlyChans = true;
                    continue;
                }
                if (catSplit[i].equals("!#")) {
                    noChans = true;
                    continue;
                }
                if (!catSplit[i].equals("live")) continue;
                onlyLive = true;
            }
            ArrayList<Object> chans = new ArrayList();
            if (cat.equals("*")) {
                chans = new ArrayList<String>(parseChannelHelper.getFavorites());
            } else {
                for (String string : parseChannelHelper.getNamesByCategory(cat)) {
                    if (noChans && string.startsWith("#") || onlyChans && !string.startsWith("#")) continue;
                    chans.add(string);
                }
            }
            for (String string : chans) {
                if (onlyLive && !parseChannelHelper.isStreamLive(Helper.toStream(string))) continue;
                Helper.addValidChannel(string, prepend, result);
            }
        }
        return result;
    }

    private static void addValidChannel(String channel, boolean prepend, Collection<String> collection) {
        if (Helper.isValidChannel(channel)) {
            if (prepend && !channel.startsWith("#")) {
                channel = "#" + channel;
            }
            collection.add(StringUtil.toLowerCase(channel));
        }
    }

    public static String getChannelFromUrl(String url) {
        Matcher m = CHANNEL_URL_PATTERN.matcher(url);
        if (m.matches()) {
            TwitchPopoutUrlInfo popoutInfo;
            String channel = m.group(1);
            if (channel.equals("popout") && (popoutInfo = Helper.getPopoutUrlInfo(url)) != null) {
                return popoutInfo.channel;
            }
            return channel;
        }
        return url;
    }

    public static TwitchPopoutUrlInfo getPopoutUrlInfo(String url) {
        Matcher m = POPOUT_URL_PATTERN.matcher(url);
        if (m.matches()) {
            return new TwitchPopoutUrlInfo(m.group(1), m.group(2), m.group(3));
        }
        return null;
    }

    public static String[] parseChannels(String channels, boolean prepend) {
        return Helper.parseChannelsFromString(channels, prepend).toArray(new String[0]);
    }

    public static String[] parseChannels(String channels) {
        return Helper.parseChannels(channels, true);
    }

    public static String buildStreamsString(Collection<String> set) {
        String result = "";
        String sep = "";
        for (String channel : set) {
            result = result + sep + channel.replace("#", "");
            sep = ", ";
        }
        return result;
    }

    public static boolean isValidChannel(String channel) {
        try {
            return CHANNEL_PATTERN.matcher(channel).matches() || CHATROOM_PATTERN.matcher(channel).matches();
        }
        catch (NullPointerException | PatternSyntaxException ex) {
            return false;
        }
    }

    public static boolean isValidChannelStrict(String channel) {
        return Helper.isValidChannel(channel) && channel.startsWith("#");
    }

    public static boolean isRegularChannel(String channel) {
        try {
            return CHANNEL_PATTERN.matcher(channel).matches();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isRegularChannelStrict(String channel) {
        return Helper.isRegularChannel(channel) && channel.startsWith("#");
    }

    public static boolean isValidStream(String stream) {
        try {
            return STREAM_PATTERN.matcher(stream).matches();
        }
        catch (NullPointerException | PatternSyntaxException ex) {
            return false;
        }
    }

    public static boolean isChatroomChannel(String channel) {
        try {
            return channel.startsWith("#") && CHATROOM_PATTERN.matcher(channel).matches();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isValidWhisperChannel(String channel) {
        try {
            return WHISPER_PATTERN.matcher(channel).matches();
        }
        catch (NullPointerException | PatternSyntaxException ex) {
            return false;
        }
    }

    public static String toValidChannel(String channel) {
        if (channel == null) {
            return null;
        }
        if (!Helper.isValidChannel(channel)) {
            return null;
        }
        if (!channel.startsWith("#")) {
            channel = "#" + channel;
        }
        return StringUtil.toLowerCase(channel);
    }

    public static String toChannel(String chan) {
        if (chan == null) {
            return null;
        }
        if (Helper.isValidChannel(chan) && !chan.startsWith("#")) {
            return StringUtil.toLowerCase("#" + chan);
        }
        return StringUtil.toLowerCase(chan);
    }

    public static String toStream(String channel) {
        if (channel == null) {
            return null;
        }
        if (channel.startsWith("#")) {
            return channel.substring(1);
        }
        return channel;
    }

    public static String toValidStream(String channel) {
        String stream = Helper.toStream(channel);
        if (!Helper.isValidStream(stream)) {
            return null;
        }
        return stream;
    }

    public static String[] toStream(String[] channels) {
        String[] result = new String[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            result[i] = Helper.toStream(channels[i]);
        }
        return result;
    }

    public static Collection<String> toStream(Collection<String> channels) {
        ArrayList<String> result = new ArrayList<String>();
        for (String channel : channels) {
            result.add(Helper.toStream(channel));
        }
        return result;
    }

    public static String makeDisconnectReason(int reason, String reasonMessage) {
        String result = "";
        switch (reason) {
            case 100: {
                result = Language.getString("chat.error.unknownHost");
                break;
            }
            case 103: {
                result = "Requested";
                break;
            }
            case 104: {
                result = "";
                break;
            }
            case 105: {
                result = Language.getString("chat.error.loginFailed");
                break;
            }
            case 101: {
                result = Language.getString("chat.error.connectionTimeout");
                break;
            }
            case 107: {
                result = "Could not establish secure connection (" + reasonMessage + ")";
                break;
            }
            case 102: {
                result = reasonMessage;
            }
        }
        if (!result.isEmpty()) {
            result = " (" + result + ")";
        }
        return result;
    }

    public static String filterCombiningCharacters(String text, String replaceWith, int mode) {
        if (mode == 2) {
            return COMBINING_CHARACTERS_STRICT.matcher(text).replaceAll(replaceWith);
        }
        if (mode == 1) {
            return COMBINING_CHARACTERS_LENIENT.matcher(text).replaceAll(replaceWith);
        }
        return text;
    }

    public static boolean isAllUppercaseLetters(String text) {
        return ALL_UPERCASE_LETTERS.matcher(text).matches();
    }

    public static String tagsvalue_decode(String s) {
        if (s == null) {
            return null;
        }
        return TAGS_VALUE_DECODE.replace(s);
    }

    public static String tagsvalue_encode(String s) {
        if (s == null) {
            return null;
        }
        return TAGS_VALUE_ENCODE.replace(s);
    }

    public static String htmlspecialchars_decode(String s) {
        if (s == null) {
            return null;
        }
        return HTMLSPECIALCHARS_DECODE.replace(s);
    }

    public static String htmlspecialchars_encode(String s) {
        if (s == null) {
            return null;
        }
        return HTMLSPECIALCHARS_ENCODE.replace(s);
    }

    public static String prepareForHtml(String s) {
        if (s == null) {
            return null;
        }
        return Helper.htmlspecialchars_encode(s).replaceAll(" ", "&nbsp;").replaceAll("\n", "<br />");
    }

    public static String removeEmojiVariationSelector(String input) {
        if (input == null) {
            return null;
        }
        return EMOJI_VARIATION_SELECTOR.matcher(input).replaceAll("");
    }

    public static String replaceUnderscoreWithSpace(String input) {
        return UNDERSCORE.matcher(input).replaceAll(" ");
    }

    public static <T> List<T> subList(List<T> list, int start, int end) {
        ArrayList<T> subList = new ArrayList<T>();
        for (int i = start; i < end && list.size() > i; ++i) {
            subList.add(list.get(i));
        }
        return subList;
    }

    public static void unhandledException() {
        String[] a = new String[]{};
        String b = a[1];
    }

    public static boolean arrayContainsInt(int[] array, int test) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != test) continue;
            return true;
        }
        return false;
    }

    public static IntegerPair getNumbersFromString(String input) {
        String[] split = input.split(",");
        if (split.length != 2) {
            return null;
        }
        try {
            int a = Integer.parseInt(split[0]);
            int b = Integer.parseInt(split[1]);
            return new IntegerPair(a, b);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static final void main(String[] args) {
        System.out.println(Arrays.asList(Helper.parseChannels("b,a,b,c")));
        System.out.println(Helper.getServer("server"));
        System.out.println(Helper.getPort("server"));
        NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(1);
        System.out.println(nf.format((double)(Math.round(2.466666666666667) * 30L) / 60.0));
    }

    public static boolean matchUserStatus(String id, User user) {
        return id.equals("$mod") ? user.isModerator() : (id.equals("$sub") ? user.isSubscriber() : (id.equals("$turbo") ? user.hasTurbo() : (id.equals("$admin") ? user.isAdmin() : (id.equals("$broadcaster") ? user.isBroadcaster() : (id.equals("$staff") ? user.isStaff() : (id.equals("$bot") ? user.isBot() : (id.equals("$globalmod") ? user.isGlobalMod() : (id.equals("$anymod") ? user.isAdmin() || user.isBroadcaster() || user.isGlobalMod() || user.isModerator() || user.isStaff() : id.equals("$vip") && user.hasTwitchBadge("vip")))))))));
    }

    public static String checkHttpUrl(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("//")) {
            url = "https:" + url;
        }
        return url;
    }

    public static URL createUrlNoError(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static String systemInfo() {
        return String.format("Java: %s (%s / %s) OS: %s (%s/%s) Locale: %s", System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.home"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), Locale.getDefault());
    }

    public static Pattern getUrlPattern() {
        return URL_PATTERN;
    }

    public static String buildUrlString(String scheme, String host, String path) {
        try {
            URI uri = new URI(scheme, host, path, null);
            return uri.toASCIIString();
        }
        catch (URISyntaxException ex) {
            LOGGER.warning("Error building URL: " + ex);
            return null;
        }
    }

    public static String getServer(String serverAndPort) {
        int p = serverAndPort.lastIndexOf(":");
        if (p == -1) {
            return serverAndPort;
        }
        return serverAndPort.substring(0, p);
    }

    public static int getPort(String serverAndPort) {
        int p = serverAndPort.lastIndexOf(":");
        if (p == -1) {
            return -1;
        }
        String port = serverAndPort.substring(p + 1);
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static String makeBanInfoDuration(long duration) {
        if (duration < 120L) {
            return String.format("%ds", duration);
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(1);
        if (duration < 7200L) {
            return String.format("%sm", nf.format((double)(Math.round((double)duration / 30.0) * 30L) / 60.0));
        }
        return String.format("%sh", nf.format((double)(Math.round((double)(duration /= 60L) / 30.0) * 30L) / 60.0));
    }

    public static String makeBanInfo(long duration, String reason, boolean durationEnabled, boolean reasonEnabled, boolean includeBan) {
        String banInfo = "";
        if (durationEnabled) {
            if (duration > 0L) {
                banInfo = String.format("(%s)", Helper.makeBanInfoDuration(duration));
            } else if (duration == -2L) {
                banInfo = "(deleted)";
            } else if (includeBan) {
                banInfo = "(banned)";
            }
        }
        return banInfo;
    }

    public static String makeBanCommand(User user, long duration, String id) {
        if (duration > 0L) {
            return StringUtil.concats("timeout", user.getName()).trim();
        }
        if (duration == -2L) {
            return StringUtil.concats("delete", id).trim();
        }
        return StringUtil.concats("ban", user.getName()).trim();
    }

    public static Dimension getDimensionFromParameter(String parameter) {
        String[] split;
        if (parameter != null && !parameter.trim().isEmpty() && (split = parameter.trim().split("x|\\s")).length == 2) {
            try {
                int width = Integer.parseInt(split[0]);
                int height = Integer.parseInt(split[1]);
                if (width > 0 && height > 0) {
                    return new Dimension(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static short parseShort(String input, short defaultValue) {
        try {
            return Short.parseShort(input);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static String makeDisplayNick(User user, long displayNamesMode) {
        if (user.hasCustomNickSet()) {
            return user.getFullNick();
        }
        if (displayNamesMode == 0L) {
            if (user.hasRegularDisplayNick()) {
                return user.getFullNick();
            }
            return user.getFullNick() + " (" + user.getRegularDisplayNick() + ")";
        }
        if (displayNamesMode == 2L) {
            return user.getFullNick();
        }
        if (displayNamesMode == 1L) {
            return user.getModeSymbol() + user.getRegularDisplayNick();
        }
        if (displayNamesMode == 3L) {
            return user.getModeSymbol() + user.getName();
        }
        return user.getFullNick();
    }

    public static String encodeFilename(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding lol");
        }
    }

    public static String encodeFilename2(String input) {
        return input.replaceAll("[%\\.\"\\*/:<>\\?\\\\\\|\\+,\\.;=\\[\\]]", "_");
    }

    public static List<String> getChainedCommands(String input) {
        String[] split;
        if (StringUtil.isNullOrEmpty(input)) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String part : split = input.split("(?<!\\|)\\|(?!\\|)")) {
            if ((part = part.trim().replaceAll("\\|(\\|+)", "$1")).isEmpty()) continue;
            result.add(part);
        }
        return result;
    }

    public static String escapeForChainCommand(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("(\\|+)", "$1|");
    }

    public static String[] getForeachParams(String input) {
        if (StringUtil.isNullOrEmpty(input)) {
            return new String[2];
        }
        String[] split = input.split("(?<!>)>(?!>)", 2);
        String list = null;
        String command = null;
        Function<String, String> prepare = s -> s.trim().replaceAll(">(>+)", "$1");
        if (!split[0].trim().isEmpty()) {
            list = prepare.apply(split[0]);
        }
        if (split.length == 2 && !split[1].trim().isEmpty()) {
            command = prepare.apply(split[1]);
        }
        return new String[]{list, command};
    }

    public static String escapeForForeachCommand(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("(>+)", "$1>");
    }

    public static void addUserParameters(User user, String msgId, String autoModMsgId, Parameters parameters) {
        if (msgId != null) {
            User.SubMessage sm;
            parameters.put("msg-id", msgId);
            User.TextMessage m = user.getMessage(msgId);
            if (m != null) {
                parameters.put("msg", m.text);
                parameters.put("msg-time", String.valueOf(m.getTime()));
            }
            if ((sm = user.getSubMessage(msgId)) != null) {
                parameters.put("msg", sm.attached_message);
                parameters.put("msg-time", String.valueOf(sm.getTime()));
            }
        }
        if (autoModMsgId != null) {
            parameters.put("automod-msg-id", autoModMsgId);
            String autoModMsg = user.getAutoModMessageText(autoModMsgId);
            if (autoModMsg != null) {
                parameters.put("msg", autoModMsg);
            }
        }
        parameters.putObject("user", user);
    }

    public static Parameters createRoomParameters(Room room) {
        Parameters parameters = Parameters.create("");
        parameters.putObject("room", room);
        return parameters;
    }

    public static void pointsMerge(UserNotice newNotice, MainGui g) {
        UserNotice result = Helper.findPointsMerge(newNotice);
        if (result == null) {
            Timer timer = new Timer(1000, e -> {
                pointsMerge.remove(newNotice);
                UserNotice m = new UserNotice(newNotice.type, newNotice.user, newNotice.infoText, newNotice.attachedMessage, newNotice.tags);
                m.objectId = newNotice.objectId;
                g.printUsernotice(m);
            });
            timer.setRepeats(false);
            pointsMerge.put(newNotice, timer);
            timer.start();
        } else {
            UserNotice m = new UserNotice(result.type, result.user, result.infoText, result.attachedMessage, result.tags);
            m.objectId = result.objectId;
            g.printUsernotice(m);
        }
    }

    private static UserNotice findPointsMerge(UserNotice newNotice) {
        UserNotice found = null;
        for (Map.Entry<UserNotice, Timer> entry : pointsMerge.entrySet()) {
            UserNotice stored = entry.getKey();
            if (stored.tags.getCustomRewardId() == null || !stored.tags.getCustomRewardId().equals(newNotice.tags.getCustomRewardId())) continue;
            found = stored;
            entry.getValue().stop();
        }
        if (found != null) {
            pointsMerge.remove(found);
            UserNotice fromEventSub = found.tags.isFromEventSub() ? found : newNotice;
            UserNotice fromIrc = found.tags.isFromEventSub() ? newNotice : found;
            UserNotice result = new UserNotice(fromEventSub.type, fromEventSub.user, fromEventSub.infoText, fromIrc.attachedMessage, MsgTags.merge(found.tags, newNotice.tags));
            result.objectId = fromEventSub.objectId;
            return result;
        }
        return null;
    }

    public static void setDefaultTimezone(String input) {
        if (!StringUtil.isNullOrEmpty(input)) {
            MainSettings.DEFAULT_TIMEZONE = TimeZone.getDefault();
            TimeZone tz = TimeZone.getTimeZone(input);
            TimeZone.setDefault(tz);
            DateTime.setTimeZone(tz);
            LOGGER.info(String.format("[Timezone] Set to %s [%s]", tz.getDisplayName(), input));
        }
    }

    public static void setDefaultLocale(String input) {
        if (!StringUtil.isNullOrEmpty(input)) {
            Locale locale = Locale.forLanguageTag(input);
            Locale.setDefault(locale);
            LOGGER.info(String.format("[Locale] Set to %s [%s]", locale.getDisplayName(), locale.toLanguageTag()));
        }
    }

    public static String getErrorMessageWithCause(Throwable ex) {
        Throwable cause = ex.getCause();
        if (cause != null) {
            return String.format("%s [%s]", Helper.getErrorMessageCompact(ex), Helper.getErrorMessageCompact(cause));
        }
        return Helper.getErrorMessageCompact(ex);
    }

    public static String getErrorMessageCompact(Throwable ex) {
        if (ex.getLocalizedMessage() != null) {
            return ex.getClass().getSimpleName() + ": " + ex.getLocalizedMessage();
        }
        return ex.getClass().getSimpleName();
    }

    public static String makeSaveResultInfo(List<FileManager.SaveResult> result) {
        StringBuilder b = new StringBuilder();
        int index = 0;
        for (FileManager.SaveResult r : result) {
            if (r == null) continue;
            if (r.written) {
                b.append(String.format("* File written to %s\n", r.filePath));
            } else if (r.writeError != null) {
                b.append(String.format("* Writing failed: %s\n", Helper.getErrorMessageCompact(r.writeError)));
            }
            if (r.backupWritten) {
                b.append(String.format("* Backup written to %s\n", r.backupPath));
            } else if (r.backupError != null) {
                b.append(String.format("* Backup failed: %s\n", Helper.getErrorMessageCompact(r.backupError)));
            } else if (r.cancelReason == FileManager.SaveResult.CancelReason.INVALID_CONTENT) {
                b.append("* Backup failed: Invalid content\n");
            }
            if (r.removed) {
                b.append("* Removed unused file\n");
            }
            if (b.length() <= index) continue;
            b.insert(index, String.format("[%s]\n", r.id));
            index = b.length();
        }
        return b.toString();
    }

    public static Map<String, DockLayout> getLayoutsFromSettings(Settings settings) {
        HashMap<String, DockLayout> layouts = new HashMap<String, DockLayout>();
        Map values = settings.getMap("layouts");
        for (Map.Entry entry : values.entrySet()) {
            DockLayout layout = DockLayout.fromList((List)entry.getValue());
            if (layout == null) continue;
            layouts.put((String)entry.getKey(), layout);
        }
        return layouts;
    }

    public static void checkSLF4JBinding() {
        try {
            if (!LoggerFactory.getILoggerFactory().getClass().getName().equals("org.slf4j.impl.JDK14LoggerFactory")) {
                throw new RuntimeException("Wrong SLF4F binding: " + LoggerFactory.getILoggerFactory().getClass().getName());
            }
        }
        catch (Throwable ex) {
            Helper.startError("An error occured getting logger binding. See debug logs for details.");
            throw ex;
        }
    }

    public static void startError(String msg) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JLabel label = new JLabel(msg);
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        frame.add((Component)label, "Center");
        frame.setTitle("Chatty Start Error");
        JButton closeButton = new JButton("OK");
        closeButton.addActionListener(e -> System.exit(0));
        frame.add((Component)closeButton, "South");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static boolean isBeforeChatCommandsShutoff() {
        return Instant.now().isBefore(CHAT_COMMAND_SHUTOFF);
    }

    static {
        CHANNEL_PATTERN = Pattern.compile("(?i)^#?[a-zA-Z0-9][a-zA-Z0-9_]+$");
        CHATROOM_PATTERN = Pattern.compile("(?i)^#?chatrooms:[0-9a-z-:]+$");
        STREAM_PATTERN = Pattern.compile("(?i)^[a-zA-Z0-9][a-zA-Z0-9_]+$");
        WHISPER_PATTERN = Pattern.compile("(?i)^\\$[a-zA-Z0-9][a-zA-Z0-9_]+$");
        CHANNEL_URL_PATTERN = Pattern.compile("(?:https?://)?(?:www\\.)?twitch\\.tv/([a-zA-Z0-9][a-zA-Z0-9_]+)[/a-zA-Z0-9_]*");
        POPOUT_URL_PATTERN = Pattern.compile(String.format("%s/popout/(%s)/([a-z]+)(?:/(%s)[/a-z]*)?", TWITCH_URL_PREFIX, USERNAME_REGEX, USERNAME_REGEX));
        COMBINING_CHARACTERS_STRICT = Pattern.compile("[\\u0300-\\u036f\\u0483-\\u0489\\u1dc0-\\u1dff\\u20d0-\\u20ff\\ufe20-\\ufe2f]{1,}");
        COMBINING_CHARACTERS_LENIENT = Pattern.compile("[\\u0300-\\u036f\\u0483-\\u0489\\u1dc0-\\u1dff\\u20d0-\\u20ff\\ufe20-\\ufe2f]{3,}");
        ALL_UPERCASE_LETTERS = Pattern.compile("[A-Z]+");
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("&amp;", "&");
        replacements.put("&lt;", "<");
        replacements.put("&gt;", ">");
        replacements.put("&quot;", "\"");
        HashMap<String, String> replacementsReverse = new HashMap<String, String>();
        for (String key : replacements.keySet()) {
            replacementsReverse.put((String)replacements.get(key), key);
        }
        HTMLSPECIALCHARS_ENCODE = new Replacer(replacementsReverse);
        HTMLSPECIALCHARS_DECODE = new Replacer(replacements);
        HashMap<String, String> replacements2 = new HashMap<String, String>();
        replacements2.put("\\\\s", " ");
        replacements2.put("\\\\n", "\n");
        replacements2.put("\\\\r", "\r");
        replacements2.put("\\\\:", ";");
        replacements2.put("\\\\\\\\", "\\");
        HashMap<String, String> replacements2Reverse = new HashMap<String, String>();
        replacements2Reverse.put("\\s", "\\s");
        replacements2Reverse.put("\n", "\\n");
        replacements2Reverse.put("\r", "\\r");
        replacements2Reverse.put(";", "\\:");
        replacements2Reverse.put("\\\\", "\\\\");
        TAGS_VALUE_ENCODE = new Replacer(replacements2Reverse);
        TAGS_VALUE_DECODE = new Replacer(replacements2);
        EMOJI_VARIATION_SELECTOR = Pattern.compile("[\ufe0e\ufe0f]");
        UNDERSCORE = Pattern.compile("_");
        URL_PATTERN = Pattern.compile(URL_REGEX);
        ESCAPE_FOR_CHAIN_COMMAND = "escape-pipe";
        ESCAPE_FOR_FOREACH_COMMAND = "escape-greater";
        pointsMerge = new HashMap<UserNotice, Timer>();
        CHAT_COMMAND_SHUTOFF = ZonedDateTime.of(2023, 2, 10, 0, 0, 0, 0, ZoneId.of("-07:00")).toInstant();
    }

    public static interface ParseChannelHelper {
        public Collection<String> getFavorites();

        public Collection<String> getNamesByCategory(String var1);

        public boolean isStreamLive(String var1);
    }

    public static class TwitchPopoutUrlInfo {
        public final String channel;
        public final String type;
        public final String username;

        private TwitchPopoutUrlInfo(String channel, String type, String username) {
            this.channel = channel;
            this.type = type;
            this.username = username;
        }
    }

    public static class IntegerPair {
        public final int a;
        public final int b;

        public IntegerPair(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }
}

