/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.AddressManager;
import chatty.Connection;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.DelayedActionQueue;
import chatty.util.irc.MsgParameters;
import chatty.util.irc.MsgTags;
import chatty.util.irc.ParsedMsg;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.logging.Logger;

public abstract class Irc {
    private static final Logger LOGGER = Logger.getLogger(Irc.class.getName());
    private static final int JOIN_DELAY = 750;
    private final AddressManager addressManager = new AddressManager();
    private final DelayedActionQueue<String> joinQueue = DelayedActionQueue.create(new DelayedJoinAction(), 750L);
    private final Object lock = new Object();
    private volatile String nick;
    private volatile String pass;
    private volatile Connection connection;
    private String quitmessage = "Quit";
    private volatile String connectedIp = "";
    private volatile int connectedPort;
    private volatile long connectedSince = -1L;
    private volatile int state = 0;
    public static final int STATE_RECONNECTING = -1;
    public static final int STATE_OFFLINE = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_REGISTERED = 3;
    public static final int ERROR_UNKNOWN_HOST = 100;
    public static final int ERROR_SOCKET_TIMEOUT = 101;
    public static final int ERROR_SOCKET_ERROR = 102;
    public static final int REQUESTED_DISCONNECT = 103;
    public static final int ERROR_CONNECTION_CLOSED = 104;
    public static final int ERROR_REGISTRATION_FAILED = 105;
    public static final int REQUESTED_RECONNECT = 106;
    public static final int SSL_ERROR = 107;
    private volatile boolean requestedDisconnect = false;
    private volatile boolean cancelConnecting = false;
    private final String id;
    private final String idPrefix;

    public Irc(String id) {
        this.id = id;
        this.idPrefix = "[" + id + "] ";
    }

    private void info(String message) {
        LOGGER.info(this.idPrefix + message);
    }

    private void warning(String message) {
        LOGGER.warning(this.idPrefix + message);
    }

    protected void setState(int newState) {
        this.state = newState;
    }

    public int getState() {
        return this.state;
    }

    public boolean isRegistered() {
        return this.state == 3;
    }

    public boolean isOffline() {
        return this.state == 0;
    }

    public boolean shouldCancelConnecting() {
        return this.cancelConnecting;
    }

    public String getIp() {
        return this.connectedIp;
    }

    public String getConnectionInfo() {
        if (this.state >= 2) {
            return this.connectedIp + ":" + this.connectedPort;
        }
        return null;
    }

    public String getConnectedSince() {
        return DateTime.ago(this.connectedSince, new DateTime.Formatting[0]);
    }

    public abstract void debug(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(String server, String port, String nick, String pass, Collection<Integer> securedPorts) {
        String error = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.state >= 1) {
                error = "Already trying to connect.";
            }
            if (this.state >= 2) {
                error = "Already connected.";
            }
            if (error == null) {
                this.state = 1;
                this.cancelConnecting = false;
            }
        }
        if (error != null) {
            this.warning(error);
            return;
        }
        this.info("Resolving " + server + " " + port);
        this.onConnectionPrepare(server);
        if (Debugging.isEnabled("resolvedelay")) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        InetSocketAddress address = null;
        try {
            address = this.addressManager.getAddress(server, port);
        }
        catch (UnknownHostException ex) {
            this.onConnectionAttempt(server, -1, false);
            this.warning("Could not resolve host: " + server);
            this.disconnected(100);
            return;
        }
        if (address == null) {
            this.onConnectionAttempt(null, -1, false);
            this.warning("Invalid address: " + server + ":" + port);
            this.setState(0);
            return;
        }
        if (this.cancelConnecting) {
            this.cancelConnecting = false;
            this.disconnected(103);
            return;
        }
        this.pass = pass;
        this.nick = nick;
        boolean secured = securedPorts.contains(address.getPort());
        this.onConnectionAttempt(address.getHostString(), address.getPort(), secured);
        this.connection = new Connection(this, address, this.id, secured);
        new Thread((Runnable)this.connection, "IRC").start();
    }

    public boolean disconnect() {
        if (this.state > 1 && this.connection != null) {
            this.requestedDisconnect = true;
            this.quit();
            this.connection.close();
            return true;
        }
        this.onConnectionAttemptCancel();
        this.cancelConnecting = true;
        return false;
    }

    private void quit() {
        this.sendCommand("QUIT", this.quitmessage);
    }

    public void simulate(String data) {
        this.received(data);
    }

    public void debugConnection() {
        if (this.connection != null) {
            this.connection.debug();
        }
    }

    protected void received(String data) {
        if (data == null) {
            return;
        }
        this.raw(data);
        ParsedMsg p = ParsedMsg.parse(data);
        if (p != null) {
            this.receivedCommand(p.getPrefix(), p.getNick(), p.getCommand(), p.getParameters(), p.getTags());
        }
    }

    private void receivedCommand(String prefix, String nick, String command, MsgParameters parameters, MsgTags tags) {
        this.parsed(prefix, command, parameters);
        if (!parameters.isEmpty(0)) {
            if (parameters.isChan(0)) {
                this.onChannelCommand(tags, nick, parameters.get(0), command, parameters.getOrEmpty(1));
            } else {
                this.onCommand(nick, command, parameters.get(0), parameters.getOrEmpty(1), tags);
            }
        }
        if (command.equals("PING")) {
            this.sendCommand("PONG", parameters.getOrEmpty(0));
        } else if (command.equals("PRIVMSG")) {
            if (parameters.has(1)) {
                String channel = parameters.get(0);
                String message = parameters.get(1);
                if (parameters.get(0).startsWith("#")) {
                    if (message.charAt(0) == '\u0001' && message.startsWith("ACTION", 1)) {
                        this.onChannelMessage(channel, nick, prefix, message.substring(7).trim(), tags, true);
                    } else {
                        this.onChannelMessage(channel, nick, prefix, message, tags, false);
                    }
                } else if (channel.equalsIgnoreCase(this.nick)) {
                    this.onQueryMessage(nick, prefix, message);
                }
            } else if (parameters.has(0)) {
                String message = parameters.get(0);
                this.onQueryMessage(nick, prefix, message);
            }
        } else if (command.equals("NOTICE")) {
            if (parameters.has(1)) {
                String channel = parameters.get(0);
                String message = parameters.get(1);
                if (!channel.startsWith("#")) {
                    this.onNotice(nick, prefix, message);
                } else {
                    this.onNotice(channel, message, tags);
                }
            }
        } else if (command.equals("USERNOTICE")) {
            if (parameters.isChan(0)) {
                String channel = parameters.get(0);
                String message = parameters.getOrEmpty(1);
                this.onUsernotice(channel, message, tags);
            }
        } else if (command.equals("JOIN")) {
            if (parameters.has(0)) {
                String channel = parameters.get(0);
                this.onJoin(channel, nick);
            }
        } else if (command.equals("PART")) {
            if (parameters.has(0)) {
                String channel = parameters.get(0);
                this.onPart(channel, nick);
            }
        } else if (command.equals("MODE")) {
            if (parameters.size() == 3) {
                String chan = parameters.get(0);
                String mode = parameters.get(1);
                String name = parameters.get(2);
                if (mode.length() == 2) {
                    String modeChar = mode.substring(1, 2);
                    if (mode.startsWith("+")) {
                        this.onModeChange(chan, name, true, modeChar, prefix);
                    } else if (mode.startsWith("-")) {
                        this.onModeChange(chan, name, false, modeChar, prefix);
                    }
                }
            }
        } else if (command.equals("004")) {
            this.setState(3);
            this.onRegistered();
        } else if (command.equals("353")) {
            if (parameters.size() == 4 && parameters.get(1).equals("=") && parameters.isChan(2)) {
                String[] names = parameters.get(3).split(" ");
                this.onUserlist(parameters.get(2), names);
            }
        } else if (!command.equals("352")) {
            if (command.equals("USERSTATE")) {
                if (tags != null && parameters.isChan(0)) {
                    String channel = parameters.get(0);
                    this.onUserstate(channel, tags);
                }
            } else if (command.equals("GLOBALUSERSTATE")) {
                if (tags != null) {
                    this.onGlobalUserstate(tags);
                }
            } else if (command.equals("CLEARCHAT")) {
                if (parameters.isChan(0)) {
                    String channel = parameters.get(0);
                    String message = parameters.getOrEmpty(1);
                    if (message.isEmpty()) {
                        this.onClearChat(tags, channel, null);
                    } else {
                        this.onClearChat(tags, channel, message);
                    }
                }
            } else if (command.equals("CLEARMSG") && parameters.isChan(0)) {
                String channel = parameters.get(0);
                String message = parameters.getOrEmpty(1);
                this.onClearMsg(tags, channel, message);
            }
        }
    }

    public String getNickFromPrefix(String sender) {
        int endOfNick = sender.indexOf("!");
        if (endOfNick == -1) {
            return sender;
        }
        return sender.substring(0, endOfNick);
    }

    public void sendCommand(String command, String parameter) {
        this.send(command + " :" + parameter);
    }

    public void joinChannel(String channel) {
        this.info("JOINING: " + channel);
        this.joinQueue.add(channel);
    }

    public void joinChannelImmediately(String channel) {
        if (this.state >= 3) {
            if (!channel.startsWith("#")) {
                channel = "#" + channel;
            }
            this.send("JOIN " + channel);
            this.onJoinAttempt(channel);
        }
    }

    public void partChannel(String channel) {
        if (!channel.startsWith("#")) {
            channel = "#" + channel;
        }
        this.send("PART " + channel);
    }

    public void sendMessage(String to, String message, MsgTags tags) {
        if (!tags.isEmpty()) {
            this.send(String.format("@%s PRIVMSG %s :%s", tags.toTagsString(), to, message));
        } else {
            this.send("PRIVMSG " + to + " :" + message);
        }
    }

    public void sendActionMessage(String to, String message) {
        this.send("PRIVMSG " + to + " :" + '\u0001' + "ACTION " + message + '\u0001');
    }

    public synchronized void send(String data) {
        if (this.state > 0) {
            this.connection.send(data);
        }
    }

    protected void connected(String ip, int port) {
        this.connectedIp = ip;
        this.connectedPort = port;
        this.connectedSince = System.currentTimeMillis();
        this.setState(2);
        this.onConnect();
        if (this.pass != null) {
            this.send("PASS " + this.pass);
        }
        this.send("NICK " + this.nick);
        this.send(String.format("USER %s 0 * :Chatty", this.nick));
    }

    protected void disconnected(int reason, String reasonMessage) {
        this.joinQueue.clear();
        int oldState = this.getState();
        this.setState(0);
        if (!this.requestedDisconnect && oldState != 3 && this.connection != null) {
            this.addressManager.addError(this.connection.getAddress());
        }
        if (this.requestedDisconnect) {
            this.requestedDisconnect = false;
            this.onDisconnect(103, reasonMessage);
        } else if (reason == 104 && oldState != 3) {
            this.onDisconnect(105, reasonMessage);
        } else {
            this.onDisconnect(reason, reasonMessage);
        }
    }

    void disconnected(int reason) {
        this.disconnected(reason, "");
    }

    void onChannelMessage(String channel, String nick, String from, String text, MsgTags tags, boolean action) {
    }

    void onQueryMessage(String nick, String from, String text) {
    }

    void onNotice(String nick, String from, String text) {
    }

    void onNotice(String channel, String text, MsgTags tags) {
    }

    void onJoinAttempt(String channel) {
    }

    void onJoin(String channel, String nick) {
    }

    void onPart(String channel, String nick) {
    }

    void onModeChange(String channel, String nick, boolean modeAdded, String mode, String prefix) {
    }

    void onUserlist(String channel, String[] nicks) {
    }

    void onWhoResponse(String channel, String nick) {
    }

    void onConnectionPrepare(String server) {
    }

    void onConnectionAttempt(String server, int port, boolean secured) {
    }

    void onConnectionAttemptCancel() {
    }

    void onConnect() {
    }

    void onRegistered() {
    }

    void onDisconnect(int reason, String reasonMessage) {
    }

    void parsed(String prefix, String command, MsgParameters parameters) {
    }

    void raw(String message) {
    }

    void sent(String message) {
    }

    void onUserstate(String channel, MsgTags tags) {
    }

    void onGlobalUserstate(MsgTags tags) {
    }

    void onClearChat(MsgTags tags, String channel, String name) {
    }

    void onClearMsg(MsgTags tags, String channel, String msg) {
    }

    void onChannelCommand(MsgTags tags, String nick, String channel, String command, String trailing) {
    }

    void onCommand(String nick, String command, String parameter, String text, MsgTags tags) {
    }

    void onUsernotice(String channel, String message, MsgTags tags) {
    }

    private class DelayedJoinAction
    implements DelayedActionQueue.DelayedActionListener<String> {
        private DelayedJoinAction() {
        }

        @Override
        public void actionPerformed(String item) {
            Irc.this.info("JOIN: " + item + " (delayed)");
            Irc.this.joinChannelImmediately(item);
        }
    }
}

