/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Irc;
import chatty.Logging;
import chatty.lang.Language;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class JoinChecker {
    private static final Logger LOGGER = Logger.getLogger(JoinChecker.class.getName());
    private static final int[] DELAY = new int[]{10, 30, 30, 30, 86400};
    private final Irc irc;
    private final HashMap<String, Timer> pendingChecks = new HashMap();
    private final Map<String, Integer> joinAttempts = new HashMap<String, Integer>();

    public JoinChecker(Irc irc) {
        this.irc = irc;
    }

    public synchronized void joinAttempt(final String channel) {
        int count = this.joinAttempts.containsKey(channel) ? this.joinAttempts.get(channel) + 1 : 1;
        int delay = count > DELAY.length ? DELAY[DELAY.length - 1] : DELAY[count - 1];
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                LOGGER.warning("Join may have failed (" + channel + ")");
                LOGGER.log(Logging.USERINFO, Language.getString("chat.error.joinFailed", channel));
                JoinChecker.this.irc.joinChannel(channel);
            }
        }, delay * 1000);
        this.pendingChecks.put(channel, timer);
        this.joinAttempts.put(channel, count);
    }

    public synchronized void cancel(String channel) {
        Timer timer = this.pendingChecks.remove(channel);
        if (timer != null) {
            timer.cancel();
        }
        this.joinAttempts.remove(channel);
    }

    public synchronized void cancelAll() {
        HashSet<String> toRemove = new HashSet<String>(this.pendingChecks.keySet());
        for (String channel : toRemove) {
            this.cancel(channel);
        }
    }
}

