/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Chatty;
import chatty.TwitchClient;
import chatty.gui.laf.LaFChanger;
import chatty.util.RingBuffer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Logging {
    public static final Level USERINFO = new UserinfoLevel();
    private static final String LOG_FILE = Chatty.getPath(Chatty.PathType.DEBUG).toString() + File.separator + "debug%g.log";
    private static final String LOG_FILE_IRC = Chatty.getPath(Chatty.PathType.DEBUG).toString() + File.separator + "debug_irc%g.log";
    private static final String LOG_FILE_EVENTSUB = Chatty.getPath(Chatty.PathType.DEBUG).toString() + File.separator + "debug_eventsub%g.log";
    private static final int MAX_LOG_SIZE = 0x200000;
    private static final int MAX_LOG_FILES = 3;
    private final RingBuffer<LogRecord> lastMessages = new RingBuffer(8);
    private static TwitchClient client;
    private static Logger LOGGER_EVENTSUB;

    public Logging(final TwitchClient client) {
        Logging.client = client;
        Logging.createLogDir();
        LogManager.getLogManager().reset();
        ConsoleHandler c = new ConsoleHandler();
        c.setFormatter(new TextFormatter());
        c.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return record.getLevel() != USERINFO;
            }
        });
        Logger.getLogger("").addHandler(c);
        try {
            FileHandler file = new FileHandler(LOG_FILE, 0x200000, 3, true);
            file.setFormatter(new TextFormatter());
            file.setLevel(Level.INFO);
            file.setFilter(new FileFilter());
            Logger.getLogger("").addHandler(file);
        }
        catch (IOException | SecurityException ex) {
            Logging.fileWarning(ex);
        }
        Handler guiHandler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel() != USERINFO) {
                    client.debug(Logging.simpleFormatMessage(record));
                    if (record.getMessage().startsWith("[FFZ-WS]")) {
                        client.debugFFZ(record.getMessage());
                    }
                    if (record.getMessage().startsWith("[PubSub]")) {
                        client.debugPubSub(record.getMessage());
                    }
                    if (record.getMessage().startsWith("[EventSub]") || record.getMessage().contains("https://api.twitch.tv/helix/eventsub/subscriptions")) {
                        client.debugEventSub(record.getMessage());
                        LOGGER_EVENTSUB.info(record.getMessage());
                    }
                }
                if (record.getLevel() == Level.SEVERE) {
                    if (client.g != null) {
                        String msg = record.getMessage();
                        boolean flatLafError = msg.startsWith("FlatLaf: Failed to parse:");
                        if (flatLafError) {
                            LaFChanger.loggedFlatLookAndFeelError(msg + " " + record.getThrown().getLocalizedMessage());
                        } else {
                            client.g.error(record, Logging.this.lastMessages.getItems());
                        }
                    }
                } else if (record.getLevel() == USERINFO) {
                    client.warning(record.getMessage());
                } else {
                    Logging.this.lastMessages.add(record);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        guiHandler.setLevel(Level.INFO);
        Logger.getLogger("").addHandler(guiHandler);
        Logging.createEventSubLogger();
    }

    public static String formatRecordCompact(LogRecord record) {
        return String.format("[%1$tT/%1$tL] %2$s%5$s [%3$s/%4$s]\n", new Date(record.getMillis()), Logging.simpleFormatMessage(record), record.getSourceClassName(), record.getSourceMethodName(), Logging.getStacktraceForLogging(record.getThrown()));
    }

    private static String simpleFormatMessage(LogRecord record) {
        Object[] params = record.getParameters();
        if (params == null || params.length == 0) {
            return record.getMessage();
        }
        try {
            return MessageFormat.format(record.getMessage(), params);
        }
        catch (Exception ex) {
            return record.getMessage();
        }
    }

    public static String getStacktrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String getStacktraceForLogging(Throwable t) {
        if (t != null) {
            try {
                return "\n:" + Logging.getStacktrace(t);
            }
            catch (Exception ex) {
                return "\n:Error getting stacktrace";
            }
        }
        return "";
    }

    private static void createEventSubLogger() {
        LOGGER_EVENTSUB = Logger.getLogger(Logging.class.getName() + "EVENTSUB");
        LOGGER_EVENTSUB.setUseParentHandlers(false);
        FileHandler handler = Logging.getExtraFileHandler(LOG_FILE_EVENTSUB);
        if (handler != null) {
            LOGGER_EVENTSUB.addHandler(handler);
        }
    }

    public static void logEventSub(String line) {
        LOGGER_EVENTSUB.info(line);
    }

    public static FileHandler getIrcFileHandler() {
        return Logging.getExtraFileHandler(LOG_FILE_IRC);
    }

    public static FileHandler getExtraFileHandler(String path) {
        Logging.createLogDir();
        try {
            FileHandler file = new FileHandler(path, 0x800000, 2, true);
            file.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return String.format("[%1$tF %1$tT/%1$tL] %2$s\n", new Date(record.getMillis()), record.getMessage());
                }
            });
            file.setLevel(Level.INFO);
            return file;
        }
        catch (IOException | SecurityException ex) {
            Logging.fileWarning(ex);
            return null;
        }
    }

    public static void createLogDir() {
        try {
            Files.createDirectories(Chatty.getPath(Chatty.PathType.DEBUG), new FileAttribute[0]);
        }
        catch (IOException ex) {
            Logging.fileWarning(ex);
        }
    }

    private static void fileWarning(Throwable ex) {
        if (client != null) {
            client.warning(String.format("Failed creating log files. Check that %s can be written to. (%s)", Chatty.getPath(Chatty.PathType.DEBUG), ex));
        }
    }

    static class TextFormatter
    extends Formatter {
        TextFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return String.format("[%1$tF %1$tT/%1$tL %5$s] %2$s%6$s [%3$s/%4$s]\n", new Date(record.getMillis()), Logging.simpleFormatMessage(record), record.getSourceClassName(), record.getSourceMethodName(), record.getLevel().getName(), Logging.getStacktraceForLogging(record.getThrown()));
        }
    }

    static class FileFilter
    implements Filter {
        FileFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return !record.getSourceClassName().equals("chatty.util.TwitchApiRequest") || record.getLevel() != Level.INFO;
        }
    }

    private static class UserinfoLevel
    extends Level {
        private UserinfoLevel() {
            super("Userinfo", 950);
        }
    }
}

