/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Helper;
import chatty.lang.Language;
import chatty.util.StringUtil;
import java.util.Objects;

public class Room {
    public static final Room EMPTY = Room.createRegular("");
    private final String channel;
    private final String ownerChannel;
    private final String name;
    private final String customName;
    private final String id;
    private final String topic;
    private final String displayName;
    private final String fileName;
    private final boolean isOwner;
    private final boolean isChatroom;
    private final String streamId;
    private final String stream;

    public static Room createRegular(String channel) {
        return new Room(channel, null, channel, null, null, null, null);
    }

    public static Room createRegularWithId(String channel, String ownerId) {
        return new Room(channel, null, channel, ownerId, null, null, null);
    }

    public static Room createFromId(String id, String name, String ownerId, String ownerChannel, String topic) {
        String channel = "#chatrooms:" + ownerId + ":" + id;
        return new Room(channel, id, name, ownerId, ownerChannel, null, topic);
    }

    public static Room createFromChannel(String channel, String name, String ownerChannel) {
        try {
            String[] split = channel.split(":");
            String ownerId = split[1];
            String id = split[2];
            return new Room(channel, id, name, ownerId, ownerChannel, null, null);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private Room(String channel, String id, String name, String ownerId, String ownerChannel, String customName, String topic) {
        channel = StringUtil.toLowerCase(channel);
        this.isOwner = !channel.startsWith("#chatrooms:");
        this.isChatroom = channel.startsWith("#chatrooms:");
        this.channel = channel;
        this.topic = topic;
        this.name = name;
        this.ownerChannel = ownerChannel != null ? ownerChannel : (this.isOwner ? channel : null);
        this.customName = customName;
        this.id = id;
        this.streamId = ownerId;
        this.stream = channel.startsWith("#") ? (this.isOwner ? Helper.toStream(channel) : Helper.toStream(ownerChannel)) : null;
        if (channel.isEmpty()) {
            this.displayName = "";
            this.fileName = "";
        } else if (!this.isOwner && name != null && ownerChannel != null) {
            this.displayName = ownerChannel + " (" + name + ")";
            this.fileName = ownerChannel + "-" + Helper.encodeFilename2(name);
        } else {
            this.displayName = name;
            this.fileName = Helper.encodeFilename2(channel);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getStream() {
        return this.stream;
    }

    public boolean hasStream() {
        return this.stream != null;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public boolean isOwner() {
        return this.isOwner;
    }

    public String getOwnerChannel() {
        return this.ownerChannel;
    }

    public boolean hasOwnerChannel() {
        return this.ownerChannel != null;
    }

    public boolean isChatroom() {
        return this.isChatroom;
    }

    public String getFilename() {
        return this.fileName;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean hasTopic() {
        return this.topic != null && !this.topic.isEmpty();
    }

    public String getTopicText() {
        return "[" + Language.getString("chat.topic") + "] " + this.topic;
    }

    public boolean sameChannel(Room other) {
        return this.channel.equals(other.channel);
    }

    public String toString() {
        return this.displayName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Room other = (Room)obj;
        return Objects.equals(this.channel, other.channel);
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.channel);
        return hash;
    }
}

