/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Room;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RoomManager {
    private final Map<String, Room> roomsByChannel = new HashMap<String, Room>();
    private final Map<String, Set<Room>> roomsByOwner = new HashMap<String, Set<Room>>();
    private final RoomUpdatedListener listener;

    public RoomManager(RoomUpdatedListener listener) {
        this.listener = listener;
    }

    public synchronized void addRooms(Collection<Room> newRooms) {
        if (newRooms != null) {
            for (Room r : newRooms) {
                this.addRoom(r);
            }
        }
    }

    public synchronized void addRoomsIfNone(Collection<Room> newRooms) {
        if (newRooms != null) {
            for (Room r : newRooms) {
                if (this.roomsByChannel.containsValue(r)) continue;
                this.addRoom(r);
            }
        }
    }

    public synchronized void addRoom(Room r) {
        if (r == null) {
            return;
        }
        Room previous = this.roomsByChannel.put(r.getChannel(), r);
        if (previous != r) {
            this.listener.roomUpdated(r);
        }
        if (r.hasOwnerChannel()) {
            if (!this.roomsByOwner.containsKey(r.getOwnerChannel())) {
                this.roomsByOwner.put(r.getOwnerChannel(), new HashSet());
            }
            this.roomsByOwner.get(r.getOwnerChannel()).add(r);
        }
    }

    public synchronized Collection<Room> getRoomsByOwner(String ownerChannel) {
        Collection result = this.roomsByOwner.get(ownerChannel);
        if (result != null) {
            return new HashSet<Room>(result);
        }
        return new HashSet<Room>();
    }

    public synchronized Room getRoom(String channel) {
        if (channel == null) {
            return null;
        }
        if (!this.roomsByChannel.containsKey(channel)) {
            this.addRoom(Room.createRegular(channel));
        }
        return this.roomsByChannel.get(channel);
    }

    public static interface RoomUpdatedListener {
        public void roomUpdated(Room var1);
    }
}

