/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Helper;
import chatty.User;
import chatty.gui.MainGui;
import chatty.gui.emoji.EmojiUtil;
import chatty.util.Debugging;
import chatty.util.SpecialMap;
import chatty.util.api.TwitchApi;
import chatty.util.history.QueuedMessage;
import chatty.util.irc.MsgTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SendMessageManager {
    private int sentMessageId = 0;
    private final SpecialMap<String, Set<String>> sentMessagePending = new SpecialMap(new HashMap(), () -> new HashSet());
    private final Set<String> ignoreByMsgId = new HashSet<String>();
    private final TwitchApi api;
    private final MainGui g;
    private final Object LOCK = new Object();
    private final SpecialMap<String, List<QueuedMessage>> queuedMessages = new SpecialMap(new HashMap(), () -> new ArrayList());

    public SendMessageManager(TwitchApi api, MainGui g) {
        this.api = api;
        this.g = g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendApiMessage(String channel, String text, String replyToMsgId, boolean action) {
        String tempMsgId;
        if (this.g.getSettings().getLong("emojiZWJ") == 2L) {
            text = EmojiUtil.encodeZWJ(text);
        }
        if (action) {
            text = "\u0001ACTION " + text + '\u0001';
        }
        Object object = this.LOCK;
        synchronized (object) {
            tempMsgId = String.valueOf(this.sentMessageId);
            ++this.sentMessageId;
            this.sentMessagePending.getPut(channel).add(tempMsgId);
        }
        this.api.sendChatMessage(Helper.toStream(channel), text, replyToMsgId, result -> {
            if (!result.wasSent) {
                this.g.printLine("# Message not sent: " + result.dropReasonMessage);
            }
            Object object = this.LOCK;
            synchronized (object) {
                this.sentMessagePending.getOptional(channel).remove(tempMsgId);
                this.sentMessagePending.removeEmptyValues();
                if (result.wasSent && result.msgId != null) {
                    this.ignoreByMsgId.add(result.msgId);
                    Debugging.println("sendmsg", "Now ignoring: %s", result.msgId);
                }
            }
            this.handleQueuedMessages(channel);
        });
        return tempMsgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueuedMessages(String channel) {
        Object object = this.LOCK;
        synchronized (object) {
            this.debugStatus("sendQueued");
            if (this.sentMessagePending.containsKey(channel)) {
                return;
            }
            if (!this.queuedMessages.containsKey(channel)) {
                return;
            }
        }
        ArrayList<QueuedMessage> messages = new ArrayList<QueuedMessage>();
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            for (QueuedMessage message : this.queuedMessages.getOptional(channel)) {
                if (this.ignoreByMsgId.contains(message.tags.getId())) {
                    this.ignoreByMsgId.remove(message.tags.getId());
                    continue;
                }
                messages.add(message);
            }
            this.queuedMessages.remove(channel);
        }
        for (QueuedMessage message : messages) {
            this.g.printMessage(message.user, message.text, message.action, message.tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldIgnoreMessage(User user, String text, MsgTags tags, boolean action) {
        Object object = this.LOCK;
        synchronized (object) {
            this.debugStatus("shouldIgnore");
            if (this.ignoreByMsgId.contains(tags.getId())) {
                this.ignoreByMsgId.remove(tags.getId());
                Debugging.println("sendMsg", "Ignored: %s", text);
                return true;
            }
            if (this.sentMessagePending.containsKey(user.getChannel())) {
                Debugging.println("sendMsg", "Ignored for now (messages pending): %s", text);
                this.queuedMessages.getPut(user.getChannel()).add(new QueuedMessage(user, text, action, tags));
                return true;
            }
            return false;
        }
    }

    private void debugStatus(String where) {
        Debugging.println("sendMsg", "[%s] Temp: %s Ignore: %s Queue: %s", where, this.sentMessagePending, this.ignoreByMsgId, this.queuedMessages);
    }
}

