/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.ChannelFavorites;
import chatty.Chatty;
import chatty.Helper;
import chatty.Room;
import chatty.TwitchClient;
import chatty.gui.components.eventlog.EventLog;
import chatty.gui.components.updating.Version;
import chatty.gui.notifications.Notification;
import chatty.util.ElapsedTime;
import chatty.util.StringUtil;
import chatty.util.colors.ColorCorrection;
import chatty.util.colors.HtmlColors;
import chatty.util.hotkeys.Hotkey;
import chatty.util.settings.FileManager;
import chatty.util.settings.Settings;
import java.awt.Color;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SettingsManager {
    private static final Logger LOGGER = Logger.getLogger(SettingsManager.class.getName());
    public final Settings settings;
    public final FileManager fileManager;
    private final List<DefaultHotkey> defaultHotkeys = new ArrayList<DefaultHotkey>();
    public static final long DISPLAY_NAMES_MODE_BOTH = 0L;
    public static final long DISPLAY_NAMES_MODE_CAPITALIZED = 1L;
    public static final long DISPLAY_NAMES_MODE_LOCALIZED = 2L;
    public static final long DISPLAY_NAMES_MODE_USERNAME = 3L;
    private final String[] debugSettings = new String[]{"server", "port", "serverDefault", "portDefault", "membershipEnabled", "whisperEnabled", "groupChatServer", "groupChatPort", "imageCache", "dontSaveSettings", "usePassword", "debugLogIrc", "showJoinsParts", "saveChannelHistory", "historyClear", "autoScroll", "bufferSize"};
    private boolean loadSuccess;
    private static String previousVersion;
    private final ElapsedTime lastAutoSaved = new ElapsedTime(true);

    public SettingsManager() {
        this.fileManager = new FileManager(Chatty.getPathCreate(Chatty.PathType.SETTINGS), Chatty.getPathCreate(Chatty.PathType.BACKUP));
        FileManager.FileContentInfoProvider fileInfoProvider = new FileManager.FileContentInfoProvider(){

            @Override
            public FileManager.FileContentInfo getInfo(String content) {
                try {
                    JSONParser parser = new JSONParser();
                    JSONObject root = (JSONObject)parser.parse(content);
                    JSONArray ab = (JSONArray)root.get("abEntries");
                    return new FileManager.FileContentInfo(true, String.format(Locale.ROOT, "%d settings, %d addressbook entries", root.size(), ab != null ? ab.size() : 0));
                }
                catch (Exception ex) {
                    return new FileManager.FileContentInfo(false, "Error parsing: " + ex.toString());
                }
            }
        };
        this.fileManager.add("settings", "settings", true, fileInfoProvider);
        this.fileManager.add("login", "login", false, fileInfoProvider);
        this.fileManager.add("favoritesAndHistory", "favoritesAndHistory", false, fileInfoProvider);
        this.fileManager.add("statusPresets", "statusPresets", false, fileInfoProvider);
        this.settings = new Settings("settings", this.fileManager);
    }

    public void defineSettings() {
        String loginFile = "login";
        String historyFile = "favoritesAndHistory";
        String statusPresetsFile = "statusPresets";
        this.settings.addFile(loginFile);
        this.settings.addFile(historyFile);
        this.settings.addFile(statusPresetsFile);
        this.settings.addBoolean("dontSaveSettings", false);
        this.settings.addLong("autoSaveSettings", 15L);
        this.settings.addBoolean("debugLogIrc", false);
        this.settings.addBoolean("debugLogIrcFile", false);
        this.settings.addString("ignoreError", "");
        this.settings.addBoolean("autoRequestMods", false);
        this.settings.addLong("backupDelay", 1L);
        this.settings.addLong("backupCount", 10L);
        this.settings.addLong("versionLastChecked", 0L);
        this.settings.addString("updateAvailable", "");
        this.settings.addBoolean("checkNewVersion", true);
        this.settings.addBoolean("checkNewBeta", false);
        this.settings.addBoolean("updateJar", false);
        this.settings.addBoolean("newsAutoRequest", true);
        this.settings.addLong("newsLastRead", 0L);
        this.settings.addString("currentVersion", "");
        this.addDefaultHotkeyAppWide("0.7.3", "dialog.streams", "ctrl L");
        this.addDefaultHotkeyAppWide("0.7.3", "dialog.toggleEmotes", "ctrl E");
        this.addDefaultHotkey("0.7.3", "dialog.search", "ctrl F");
        this.addDefaultHotkey("0.7.3", "dialog.joinChannel", "ctrl J");
        this.addDefaultHotkeyAppWide("0.7.3", "window.toggleUserlist", "F9");
        this.addDefaultHotkeyAppWide("0.7.3", "window.toggleInput", "ctrl F10");
        this.addDefaultHotkeyAppWide("0.7.3", "window.toggleCompact", "F10");
        this.addDefaultHotkeyAppWide("0.7.3", "window.toggleCompactMaximized", "F11");
        this.addDefaultHotkey("0.7.3", "tabs.close", "ctrl W");
        this.addDefaultHotkeyAppWide("0.7.3", "tabs.next", "ctrl TAB");
        this.addDefaultHotkeyAppWide("0.7.3", "tabs.previous", "ctrl shift TAB");
        this.addDefaultHotkey("0.7.3", "selection.toggle", "ctrl SPACE");
        this.addDefaultHotkey("0.7.3", "selection.toggle", "ctrl S");
        this.addDefaultHotkeyAppWide("0.9b1", "about", "F1");
        this.addDefaultHotkeyAppWide("0.26-b3", "scroll.pageUp", "PAGE_UP");
        this.addDefaultHotkeyAppWide("0.26-b3", "scroll.pageDown", "PAGE_DOWN");
        this.settings.addList("hotkeys", this.getDefaultHotkeySettingValue(), 4);
        this.settings.addBoolean("globalHotkeysEnabled", true);
        this.settings.addBoolean("inputHistoryMultirowRequireCtrl", true);
        this.settings.addString("cachePath", "");
        this.settings.addString("imgPath", "");
        this.settings.addString("exportPath", "");
        this.settings.addString("serverDefault", "irc.chat.twitch.tv");
        this.settings.addString("portDefault", "6697,443");
        this.settings.addString("server", "", false);
        this.settings.addString("port", "", false);
        this.settings.addList("securedPorts", new LinkedHashSet<Long>(Arrays.asList(6697L, 443L)), 2);
        this.settings.addBoolean("membershipEnabled", true);
        this.settings.addString("pubsub", "wss://pubsub-edge.twitch.tv");
        this.settings.addLong("maxReconnectionAttempts", -1L);
        this.settings.addString("channel", "");
        this.settings.addString("username", "");
        this.settings.setFile("username", loginFile);
        this.settings.addString("userid", "");
        this.settings.setFile("userid", loginFile);
        this.settings.addString("password", "", false);
        this.settings.addBoolean("connectOnStartup", false, false);
        this.settings.addLong("onStart", 3L);
        this.settings.addBoolean("connectDialogIfMissing", true);
        this.settings.addLong("minimizeOnStart", 0L);
        this.settings.addString("autojoinChannel", "");
        this.settings.addString("previousChannel", "");
        this.settings.addString("token", "");
        this.settings.setFile("token", loginFile);
        this.settings.addBoolean("allowTokenOverride", false);
        this.settings.addBoolean("foreignToken", false);
        this.settings.addBoolean("usePassword", false, false);
        this.settings.addList("scopes", new HashSet(), 1);
        this.settings.setFile("scopes", loginFile);
        this.settings.addBoolean("ontop", false);
        this.settings.addString("laf", "default");
        this.settings.addString("lafTheme", "Default");
        this.settings.addMap("lafCustomTheme", new HashMap(), 1);
        this.settings.addLong("lafFontScale", 100L);
        this.settings.addString("lafForeground", "#B4BEB9");
        this.settings.addString("lafBackground", "#323433");
        this.settings.addLong("lafGradient", 5L);
        this.settings.addLong("lafVariant", 0L);
        this.settings.addString("lafStyle", "regular");
        this.settings.addString("lafScroll", "default");
        this.settings.addBoolean("lafNativeWindow", true);
        this.settings.addBoolean("lafFlatStyledWindow", true);
        this.settings.addBoolean("lafFlatEmbeddedMenu", false);
        this.settings.addString("lafFlatProperties", "");
        this.settings.addLong("lafFlatTabs", 3L);
        this.settings.addBoolean("lafErrorSound", false);
        this.settings.addString("language", "");
        this.settings.addString("locale", "");
        this.settings.addString("timezone", "");
        this.settings.addBoolean("inputLimitsEnabled", true);
        this.settings.addBoolean("macScreenMenuBar", true);
        this.settings.addBoolean("macSystemAppearance", true);
        this.settings.addLong("dialogFontSize", -1L);
        this.settings.addString("font", "Dialog");
        this.settings.addLong("fontSize", 14L);
        this.settings.addBoolean("timestampFontEnabled", false);
        this.settings.addString("timestampFont", "Dialog 12");
        this.settings.addString("inputFont", "Dialog 14");
        this.settings.addString("userlistFont", "Dialog 12");
        this.settings.addLong("lineSpacing", 2L);
        this.settings.addLong("paragraphSpacing", 8L);
        this.settings.addLong("bottomMargin", -1L);
        this.settings.addString("timestamp", "HH:mm");
        this.settings.addString("timestampTimezone", "");
        this.settings.addBoolean("capitalizedNames", true);
        this.settings.addBoolean("correctlyCapitalizedNames", false);
        this.settings.addMap("customNames", new HashMap(), 1);
        this.settings.addBoolean("actionColored", false);
        this.settings.addLong("displayNamesMode", 0L);
        this.settings.addLong("displayNamesModeUserlist", 1L);
        this.settings.addBoolean("showImageTooltips", true);
        this.settings.addBoolean("showTooltipImages", true);
        this.settings.addLong("mentions", 3L);
        this.settings.addLong("mentionsInfo", 3L);
        this.settings.addLong("markHoveredUser", 2L);
        this.settings.addLong("mentionMessages", 0L);
        this.settings.addBoolean("emoticonsEnabled", true);
        this.settings.addLong("emoteMaxHeight", 0L);
        this.settings.addLong("emoteScale", 100L);
        this.settings.addLong("emoteScaleDialog", 100L);
        this.settings.addLong("emoteScaleGigantified", 200L);
        this.settings.addList("emoteHiddenSets", new ArrayList(), 1);
        this.settings.addBoolean("closeEmoteDialogOnDoubleClick", false);
        this.settings.addBoolean("ffz", true);
        this.settings.addBoolean("ffzEvent", true);
        this.settings.addBoolean("ffzModIcon", true);
        this.settings.addBoolean("bttvEmotes", true);
        this.settings.addBoolean("seventv", true);
        this.settings.addBoolean("animatedEmotes", true);
        this.settings.addLong("animationPause", 2L);
        this.settings.addLong("animationPauseFrame", 2L);
        this.settings.addBoolean("legacyAnimations", false);
        this.settings.addList("ignoredEmotes", new ArrayList(), 1);
        this.settings.addList("favoriteEmotes", new ArrayList(), 4);
        this.settings.addLong("smilies", 10L);
        this.settings.addList("localEmotes", new ArrayList(), 4);
        this.settings.addBoolean("webp", true);
        this.settings.addString("emoji", "twemoji");
        this.settings.addBoolean("emojiReplace", true);
        this.settings.addLong("emojiZWJ", 2L);
        this.settings.addString("cheersType", "animated");
        this.settings.addBoolean("usericonsEnabled", true);
        this.settings.addLong("usericonScale", 100L);
        this.settings.addLong("customUsericonScaleMode", 0L);
        this.settings.addList("customUsericons", new ArrayList(), 4);
        this.settings.addBoolean("customUsericonsEnabled", false);
        this.settings.addList("hiddenUsericons", new ArrayList(), 4);
        this.settings.addBoolean("botBadgeEnabled", true);
        this.settings.addBoolean("botNamesBTTV", true);
        this.settings.addBoolean("botNamesFFZ", true);
        this.settings.addList("botNames", new LinkedHashSet<String>(Arrays.asList("nightbot", "moobot", "kabukibot", "slowton2", "xanbot")), 1);
        this.settings.addBoolean("imageCache", true);
        this.settings.addString("foregroundColor", "#111111");
        this.settings.addString("backgroundColor", "#FAFAFA");
        this.settings.addBoolean("alternateBackground", false);
        this.settings.addString("backgroundColor2", "#EAEAEA");
        this.settings.addBoolean("messageSeparator", false);
        this.settings.addString("separatorColor", "#DFDFDF");
        this.settings.addBoolean("timestampColorEnabled", false);
        this.settings.addString("timestampColorInherit", "off");
        this.settings.addString("timestampColor", "#111111");
        this.settings.addString("infoColor", "#001480");
        this.settings.addString("compactColor", "#A0A0A0");
        this.settings.addString("inputBackgroundColor", "White");
        this.settings.addString("inputForegroundColor", "Black");
        this.settings.addString("highlightColor", "#D10000");
        this.settings.addBoolean("highlightBackground", true);
        this.settings.addString("highlightBackgroundColor", "#FFFFEA");
        this.settings.addString("searchResultColor", "LightYellow");
        this.settings.addString("searchResultColor2", "#FFFF80");
        this.settings.addBoolean("colorCorrection", true);
        this.settings.addString("nickColorCorrection", "normal");
        this.settings.addLong("nickColorBackground", 1L);
        this.settings.addList("colorPresets", new ArrayList(), 4);
        this.settings.addBoolean("displayColoredNamesInUserlist", false);
        this.settings.addBoolean("msgColorsEnabled", false);
        this.settings.addList("msgColors", new LinkedList(), 1);
        this.settings.addBoolean("msgColorsPrefer", false);
        this.settings.addBoolean("msgColorsLinks", true);
        this.settings.addBoolean("customUsercolors", false);
        this.settings.addList("usercolors", new LinkedList(), 1);
        this.settings.addLong("transparencyBackground", 50L);
        this.settings.addBoolean("transparencyClickThrough", true);
        this.settings.addString("transparencyCurrentId", "");
        this.settings.addString("abCommandsChannel", "");
        this.settings.addString("abCommands", "add,set,remove");
        this.settings.addString("abUniqueCats", "");
        this.settings.addBoolean("abAutoImport", false);
        this.settings.addString("abSubMonthsChan", "");
        this.settings.addList("abSubMonths", new TreeSet(), 2);
        this.settings.addBoolean("abSaveOnChange", false);
        this.settings.addList("abEntries", new ArrayList(), 4);
        ArrayList<String> commandsDefault = new ArrayList<String>();
        commandsDefault.add("/slap /me slaps $$1- around a bit with a large trout");
        commandsDefault.add("/permit !permit $$1");
        commandsDefault.add("/j /join $$1-");
        this.settings.addList("commands", commandsDefault, 1);
        this.settings.addMap("var", new HashMap(), 1);
        this.settings.addList("timers", new ArrayList(), 4);
        this.settings.addString("timeoutButtons", "/Ban[B], /Unban[U], 5s[1], 2m[2], 10m[3], 30m[4], /ModUnmod\n\n@AutoMod\n.Approve=/Automod_approve\n.Deny=/Automod_deny\n\nDelete=/delete $$(msg-id)");
        this.settings.addString("banReasons", "Spam\nPosting Bad Links\nBan Evasion\nHate / Harassment\nSpoilers / Backseat Gaming");
        this.settings.addString("banReasonsHotkey", "");
        this.settings.addString("userContextMenu", "");
        this.settings.addString("channelContextMenu", "");
        this.settings.addString("streamsContextMenu", "");
        this.settings.addString("textContextMenu", "-\nTranslate=/openUrlPrompt https://translate.google.com/#view=home&op=translate&sl=auto&tl=en&text=$$urlencode($(msg))");
        this.settings.addString("adminContextMenu", "!title=!title $(title)\n!game=!game $(game)");
        this.settings.addBoolean("menuCommandLabels", false);
        this.settings.addBoolean("menuRestrictions", false);
        this.settings.addBoolean("closeUserDialogOnAction", true);
        this.settings.addBoolean("openUserDialogByMouse", true);
        this.settings.addBoolean("reuseUserDialog", false);
        this.settings.addString("userDialogTimestamp", "[HH:mm:ss]");
        this.settings.addLong("clearUserMessages", 12L);
        this.settings.addLong("userMessagesHighlight", 15L);
        this.settings.addMap("userNotes", new HashMap(), 1);
        this.settings.addMap("userNotesChat", new HashMap(), 1);
        this.settings.addLong("userDialogMessageLimit", 100L);
        this.settings.addMap("channelHistory", new TreeMap(), 2);
        this.settings.addList("channelFavorites", new ArrayList(), 1);
        this.settings.addMap("roomFavorites", new HashMap(), 4);
        this.settings.addLong("channelHistoryKeepDays", 30L);
        this.settings.addBoolean("saveChannelHistory", true);
        this.settings.addBoolean("historyClear", true);
        this.settings.addLong("favoritesSorting", 20L);
        this.settings.addList("gameFavorites", new ArrayList(), 1);
        this.settings.addBoolean("historyServiceEnabled", false);
        this.settings.addLong("historyServiceLimit", 30L);
        this.settings.addList("historyServiceExcluded", new ArrayList(), 1);
        this.settings.addBoolean("historyMessageHighlight", false);
        this.settings.addBoolean("historyMessageMsgColors", false);
        this.settings.addBoolean("historyMessageIgnore", true);
        this.settings.addBoolean("historyMessageRouting", false);
        this.settings.addBoolean("historyMessageNotifications", false);
        this.settings.addList("gamesFavorites", new ArrayList(), 1);
        this.settings.addList("gamesFavorites2", new ArrayList(), 4);
        this.settings.addMap("tagsFavorites", new HashMap(), 1);
        this.settings.addList("statusPresets", new ArrayList(), 4);
        this.settings.addBoolean("saveStatusHistory", true);
        this.settings.addBoolean("statusHistoryClear", true);
        this.settings.addLong("statusHistoryKeepDays", 30L);
        this.settings.addString("statusHistorySorting", "");
        this.settings.addString("commercialHotkey", "");
        this.settings.addBoolean("adDelay", false);
        this.settings.addLong("adDelayLength", 300L);
        this.settings.addString("slowmodeDurations", "3s\n5s\n10s\n20s\n30s\n60s\n120s");
        this.settings.addString("followeronlyDurations", "0m\n10m\n30m\n1h\n1d\n7d\n30d\n90d");
        this.settings.addBoolean("urlPrompt", true);
        this.settings.addBoolean("urlCommandEnabled", false);
        this.settings.addString("urlCommand", "");
        this.settings.addBoolean("attachedWindows", false);
        this.settings.addBoolean("maximized", false);
        this.settings.addBoolean("nod3d", true);
        this.settings.addBoolean("noddraw", false);
        this.settings.addLong("uiScale", 0L);
        this.settings.addBoolean("bufferStrategy1", false);
        this.settings.addBoolean("mainResizable", true);
        this.settings.addBoolean("splash", true);
        this.settings.addBoolean("hideStreamsOnMinimize", true);
        this.settings.addLong("inputFocus", 0L);
        this.settings.addList("icons", new ArrayList(), 1);
        this.settings.addBoolean("closeToTray", false);
        this.settings.addBoolean("minimizeToTray", false);
        this.settings.addBoolean("hidePopoutsIfTray", true);
        this.settings.addBoolean("trayIconAlways", false);
        this.settings.addBoolean("singleClickTrayOpen", true);
        this.settings.addMap("windows", new HashMap(), 1);
        this.settings.addLong("restoreMode", 3L);
        this.settings.addBoolean("restoreOnlyIfOnScreen", true);
        this.settings.addMap("dock", new HashMap(), 2);
        this.settings.addMap("layouts", new HashMap(), 4);
        this.settings.addLong("layoutsOptions", 3L);
        this.settings.addBoolean("restoreLayout", true);
        this.settings.addBoolean("restoreLayoutWhisper", false);
        this.settings.addBoolean("initSettingsDialog", false);
        this.settings.addBoolean("popoutSaveAttributes", true);
        this.settings.addBoolean("popoutCloseLastChannel", false);
        this.settings.addList("popoutAttributes", new ArrayList(), 1);
        this.settings.addString("popoutClose", "ask");
        this.settings.addBoolean("simpleTitle", false);
        this.settings.addBoolean("titleShowUptime", true);
        this.settings.addBoolean("titleLongerUptime", true);
        this.settings.addBoolean("titleShowViewerCount", true);
        this.settings.addBoolean("titleShowChannelState", true);
        this.settings.addBoolean("titleConnections", true);
        this.settings.addString("titleAddition", "");
        this.settings.addString("tabOrder", "normal");
        HashMap<String, Long> tabsPos = new HashMap<String, Long>();
        tabsPos.put("-nochannel-", -2L);
        tabsPos.put("#", -1L);
        tabsPos.put("-", 1L);
        this.settings.addMap("tabsPos", tabsPos, 2);
        this.settings.addBoolean("tabsAutoSort", true);
        this.settings.addString("tabsOpen", "activeChan");
        this.settings.addBoolean("tabsMwheelScrolling", false);
        this.settings.addBoolean("tabsMwheelScrollingAnywhere", true);
        this.settings.addBoolean("tabsCloseMMB", true);
        this.settings.addBoolean("tabsCloseSwitchToPrev", true);
        this.settings.addString("tabsPlacement", "top");
        this.settings.addString("tabsLayout", "wrap");
        this.settings.addBoolean("tabsHideIfSingle", true);
        this.settings.addLong("tabsLive", 16L);
        this.settings.addLong("tabsMessage", 4L);
        this.settings.addLong("tabsHighlight", 8L);
        this.settings.addLong("tabsStatus", 32L);
        this.settings.addLong("tabsActive", 128L);
        this.settings.addLong("tabsPopoutDrag", 2L);
        this.settings.addLong("tabsMaxWidth", 200L);
        this.settings.addBoolean("tabsCloseEmpty", true);
        this.settings.addBoolean("closeTabsSameType", true);
        this.settings.addBoolean("tabsChanTitles", false);
        this.settings.addBoolean("chatScrollbarAlways", false);
        this.settings.addLong("userlistWidth", 120L);
        this.settings.addLong("userlistMinWidth", 0L);
        this.settings.addBoolean("userlistEnabled", true);
        this.settings.addBoolean("inputEnabled", true);
        this.settings.addLong("bufferSize", 500L);
        this.settings.addMap("bufferSizes", new HashMap(), 2);
        this.settings.addBoolean("chatInsertTop", false);
        this.settings.addString("liveStreamsSorting", "recent");
        this.settings.addBoolean("liveStreamsSortingFav", true);
        this.settings.addString("liveStreamsAction", "info");
        this.settings.addString("liveStreamsCommand", "");
        this.settings.addBoolean("liveStreamsChatIcon", true);
        this.settings.addBoolean("liveStreamsNotificationAction", false);
        this.settings.addBoolean("liveStreamsFavsOnly", false);
        this.settings.addLong("historyRange", 0L);
        this.settings.addBoolean("historyVerticalZoom", false);
        this.settings.addBoolean("followersCompact", false);
        this.settings.addBoolean("followersReg", true);
        this.settings.addBoolean("sounds", true);
        this.settings.addString("soundsPath", "");
        this.settings.addString("soundDevice", "");
        this.settings.addBoolean("soundCommandEnabled", false);
        this.settings.addString("soundCommand", "");
        this.settings.addString("highlightSound", "off");
        this.settings.addString("highlightSoundFile", "ding.wav");
        this.settings.addLong("highlightSoundDelay", 15L);
        this.settings.addLong("soundDelay", 15L);
        this.settings.addLong("highlightSoundVolume", 100L);
        this.settings.addString("statusSound", "off");
        this.settings.addString("statusSoundFile", "dingdong.wav");
        this.settings.addLong("statusSoundVolume", 100L);
        this.settings.addLong("statusSoundDelay", 15L);
        this.settings.addString("messageSound", "off");
        this.settings.addString("messageSoundFile", "dingdong.wav");
        this.settings.addLong("messageSoundVolume", 100L);
        this.settings.addLong("messageSoundDelay", 5L);
        this.settings.addString("joinPartSound", "off");
        this.settings.addString("joinPartSoundFile", "dingdong.wav");
        this.settings.addLong("joinPartSoundVolume", 100L);
        this.settings.addLong("joinPartSoundDelay", 10L);
        this.settings.addString("followerSound", "off");
        this.settings.addString("followerSoundFile", "dingdong.wav");
        this.settings.addLong("followerSoundVolume", 100L);
        this.settings.addLong("followerSoundDelay", 10L);
        this.settings.addBoolean("requestFollowedStreams", true);
        this.settings.addLong("nType", 0L);
        this.settings.addLong("nScreen", -1L);
        this.settings.addLong("nPosition", 3L);
        this.settings.addLong("nDisplayTime", 10L);
        this.settings.addLong("nMaxDisplayTime", 1800L);
        this.settings.addBoolean("nKeepOpenOnHover", true);
        this.settings.addLong("nMaxDisplayed", 4L);
        this.settings.addLong("nMaxQueueSize", 4L);
        this.settings.addBoolean("nActivity", false);
        this.settings.addLong("nActivityTime", 10L);
        this.settings.addString("nCommand", "");
        this.settings.addBoolean("nHideOnStart", false);
        this.settings.addBoolean("nInfoMsgEnabled", false);
        this.settings.addString("nInfoMsgTarget", "Notifications");
        this.settings.addList("notifications", this.getDefaultNotificationSettingValue(), 4);
        this.settings.addList("nColorPresets", new ArrayList(), 4);
        this.settings.addBoolean("tips", true);
        this.settings.addLong("lastTip", 0L);
        this.settings.addList("readEvents", new ArrayList(), 1);
        this.settings.addString("spamProtection", "18/30");
        this.settings.addBoolean("autoScroll", true);
        this.settings.addLong("autoScrollTimeout", 30L);
        this.settings.addBoolean("pauseChatOnMouseMove", false);
        this.settings.addBoolean("pauseChatOnMouseMoveCtrlRequired", false);
        this.settings.addString("commandOnCtrlClick", "");
        this.settings.addString("commandOnMiddleClick", "");
        this.settings.addString("commandOnCtrlMiddleClick", "");
        this.settings.addBoolean("ignoreJoinsParts", false);
        this.settings.addBoolean("showJoinsParts", false);
        this.settings.addBoolean("showModMessages", false);
        this.settings.addBoolean("twitchnotifyAsInfo", true);
        this.settings.addBoolean("printStreamStatus", true);
        this.settings.addBoolean("showModActions", true);
        this.settings.addBoolean("showModActionsRestrict", true);
        this.settings.addBoolean("showActionBy", true);
        this.settings.addBoolean("showAutoMod", true);
        this.settings.addBoolean("showBanMessages", false);
        this.settings.addBoolean("banDurationAppended", true);
        this.settings.addBoolean("banReasonAppended", true);
        this.settings.addBoolean("banDurationMessage", true);
        this.settings.addBoolean("banReasonMessage", true);
        this.settings.addBoolean("combineBanMessages", true);
        this.settings.addBoolean("deleteMessages", false);
        this.settings.addString("deletedMessagesMode", "keepShortened");
        this.settings.addLong("deletedMessagesMaxLength", 50L);
        this.settings.addBoolean("clearChatOnChannelCleared", false);
        this.settings.addLong("filterCombiningCharacters", 1L);
        this.settings.addBoolean("showLowTrustInfo", false);
        this.settings.addBoolean("showRestrictedMessages", false);
        this.settings.addList("highlight", new ArrayList(), 1);
        this.settings.addBoolean("highlightEnabled", true);
        this.settings.addBoolean("highlightUsername", true);
        this.settings.addBoolean("highlightOwnText", false);
        this.settings.addBoolean("highlightNextMessages", false);
        this.settings.addBoolean("highlightIgnored", false);
        this.settings.addBoolean("highlightOverrideIgnored", false);
        this.settings.addList("noHighlightUsers", new ArrayList(), 1);
        this.settings.addList("highlightBlacklist", new ArrayList(), 1);
        this.settings.addBoolean("highlightMatches", true);
        this.settings.addBoolean("highlightMatchesAll", true);
        this.settings.addBoolean("highlightMatchesAllEntries", false);
        this.settings.addBoolean("highlightByPoints", true);
        this.settings.addList("ignore", new ArrayList(), 1);
        this.settings.addBoolean("ignoreEnabled", false);
        this.settings.addBoolean("ignoreOwnText", false);
        this.settings.addLong("ignoreMode", 0L);
        this.settings.addBoolean("ignoreShowNotDialog", false);
        this.settings.addList("ignoredUsers", new ArrayList(), 1);
        this.settings.addList("ignoredUsersWhisper", new ArrayList(), 1);
        this.settings.addBoolean("ignoredUsersHideInGUI", true);
        this.settings.addList("ignoreBlacklist", new ArrayList(), 1);
        this.settings.addList("highlightDialog", new ArrayList(), 2);
        this.settings.addList("ignoreDialog", new ArrayList(), 2);
        this.settings.addList("filter", new ArrayList(), 1);
        this.settings.addBoolean("filterEnabled", true);
        this.settings.addBoolean("filterOwnText", true);
        this.settings.addList("routingTargets", new ArrayList(), 4);
        this.settings.addList("routing", new ArrayList(), 1);
        this.settings.addBoolean("routingMulti", true);
        ArrayList<String> matchingPresetsDefault = new ArrayList<String>();
        matchingPresetsDefault.add("# _custom replaces \\! with [\\W_]*? (matches non-word characters and underscore 0 or more times)");
        matchingPresetsDefault.add("_custom $replace($1-,$\"\\\\!\",$\"[\\W_]*?\",reg)");
        matchingPresetsDefault.add("# _special replaces every letter of words surrounded by ~ with: (<letter>[\\W_]*?)+");
        matchingPresetsDefault.add("_special $replace($1-,$\"~([^~]+)~\",$replace($(g1),$\"(\\w)\",$\"($1[\\\\W_]*?)+\",regRef),regCustom)");
        this.settings.addList("matchingPresets", matchingPresetsDefault, 1);
        this.settings.addList("matchingSubstitutes", new ArrayList(), 1);
        this.settings.addBoolean("matchingSubstitutesEnabled", false);
        this.settings.addBoolean("repeatMsg", false);
        this.settings.addLong("repeatMsgSim", 80L);
        this.settings.addLong("repeatMsgRep", 2L);
        this.settings.addLong("repeatMsgLen", 0L);
        this.settings.addLong("repeatMsgTime", 3600L);
        this.settings.addLong("repeatMsgMethod", 1L);
        this.settings.addString("repeatMsgIgnored", "");
        this.settings.addString("repeatMsgMatch", "!status:M");
        this.settings.addString("logMode", "always");
        this.settings.addBoolean("logMessage", true);
        this.settings.addString("logMessageTemplate", "$if(timestamp,$(timestamp) )<$(full-nick2)>$if(action,*) $(msg)");
        this.settings.addBoolean("logMod", false);
        this.settings.addBoolean("logJoinPart", false);
        this.settings.addBoolean("logBan", true);
        this.settings.addBoolean("logDeleted", true);
        this.settings.addBoolean("logSystem", false);
        this.settings.addBoolean("logInfo", true);
        this.settings.addBoolean("logViewerstats", true);
        this.settings.addBoolean("logViewercount", false);
        this.settings.addBoolean("logModAction", true);
        this.settings.addBoolean("logIgnored", true);
        this.settings.addBoolean("logBits", true);
        this.settings.addList("logWhitelist", new ArrayList(), 1);
        this.settings.addList("logBlacklist", new ArrayList(), 1);
        this.settings.addBoolean("logHighlighted2", false);
        this.settings.addBoolean("logIgnored2", false);
        this.settings.addString("logPath", "");
        this.settings.addString("logSplit", "never");
        this.settings.addBoolean("logSubdirectories", false);
        this.settings.addString("logTimestamp", "[yyyy-MM-dd HH:mm:ss]");
        this.settings.addBoolean("logLockFiles", true);
        this.settings.addBoolean("completionEnabled", true);
        this.settings.addMap("customCompletion", new HashMap(), 1);
        this.settings.addLong("completionMaxItemsShown", 5L);
        this.settings.addBoolean("completionShowPopup", true);
        this.settings.addBoolean("completionCommonPrefix", false);
        this.settings.addString("completionSorting", "predictive");
        this.settings.addBoolean("completionAllNameTypes", true);
        this.settings.addBoolean("completionPreferUsernames", true);
        this.settings.addBoolean("completionAllNameTypesRestriction", true);
        this.settings.addString("completionTab", "both");
        this.settings.addString("completionTab2", "emotes");
        this.settings.addString("completionSearch", "words");
        this.settings.addBoolean("completionAuto", true);
        this.settings.addString("completionEmotePrefix", ":");
        this.settings.addLong("completionMixed", 0L);
        this.settings.addBoolean("completionSpace", false);
        this.settings.addBoolean("completionFavEmotesFirst", true);
        this.settings.addBoolean("mentionReplyRestricted", false);
        this.settings.addLong("streamChatMessageTimeout", -1L);
        this.settings.addList("streamChatChannels", new ArrayList(), 1);
        this.settings.addBoolean("streamChatBottom", true);
        this.settings.addBoolean("streamChatResizable", true);
        this.settings.addString("streamChatLogos", "22");
        this.settings.addBoolean("whisperEnabled", false);
        this.settings.addBoolean("whisperWhitelist", false);
        this.settings.addLong("whisperDisplayMode", 2L);
        this.settings.addString("groupChatServer", "");
        this.settings.addString("groupChatPort", "");
        this.settings.addBoolean("whisperAutoRespond", false);
        this.settings.addString("whisperAutoRespondCustom", "");
        this.settings.addBoolean("whisperApi", false);
        this.settings.addBoolean("cmEnabled", false);
        this.settings.addString("cmChannel", "");
        this.settings.addString("cmTemplate", "{user}: {message}");
        this.settings.addBoolean("cmHighlightedOnly", false);
        this.settings.addBoolean("rulesAutoShow", true);
        this.settings.addList("rulesShown", new HashSet(), 1);
        this.settings.addLong("sharedBadges", 11L);
        this.settings.addLong("sharedLogoSize", 22L);
        this.settings.addBoolean("sharedLogoAlways", true);
        this.settings.addBoolean("livestreamer", false);
        this.settings.addString("livestreamerQualities", "Best, Worst, Select");
        this.settings.addString("livestreamerCommand", "livestreamer");
        this.settings.addBoolean("livestreamerShowDialog", true);
        this.settings.addBoolean("livestreamerAutoCloseDialog", true);
        this.settings.addString("streamHighlightCommand", "!highlight");
        this.settings.addString("streamHighlightMatch", "status:bm");
        this.settings.addString("streamHighlightChannel", "");
        this.settings.addBoolean("streamHighlightChannelRespond", false);
        this.settings.addString("streamHighlightResponseMsg", "Added stream $(added) for $(chan) [$(uptime)] $(comment)");
        this.settings.addBoolean("streamHighlightMarker", true);
        this.settings.addBoolean("streamHighlightCustomEnabled", false);
        this.settings.addString("streamHighlightCustom", "$(timestamp),$(chan),$(uptime),$(streamgame),$(chatuser),$quote($(rawcomment))");
        this.settings.addBoolean("streamHighlightExtra", true);
        this.settings.addLong("streamHighlightCooldown", 0L);
        this.settings.addBoolean("enableStatusWriter", false);
        this.settings.addString("statusWriter", "");
        this.settings.addMap("rewards", new HashMap(), 1);
        this.settings.addBoolean("pronouns", false);
        this.settings.addBoolean("pronounsChat", false);
        this.settings.addBoolean("ttsEnabled", false);
        this.settings.addMap("ttsVoice", new HashMap(), 1);
        this.settings.addLong("ttsMaxLength", 2000L);
        this.settings.addLong("ttsVolume", 100L);
        this.settings.addLong("ttsRate", 100L);
        this.settings.addLong("ttsPitch", 0L);
        this.settings.addLong("ttsHotkeysVolume", 80L);
        this.settings.addBoolean("ttsReadMessages", false);
        this.settings.addBoolean("ttsIgnoreEmoteOnly", false);
    }

    public boolean loadSettingsFromFile() {
        this.loadSuccess = this.settings.loadSettingsFromJson();
        return this.loadSuccess;
    }

    public boolean getLoadSuccess() {
        return this.loadSuccess;
    }

    public boolean wasMainFileLoaded() {
        return this.settings.wasFileLoaded("settings");
    }

    public void backupFiles() {
        long backupDelay = 86400L * this.settings.getLong("backupDelay");
        try {
            this.fileManager.backup(backupDelay, (int)this.settings.getLong("backupCount"));
        }
        catch (IOException ex) {
            LOGGER.warning("Backup failed: " + ex);
        }
    }

    public void loadCommandLineSettings(Map<String, String> args) {
        for (String key : args.keySet()) {
            String value = args.get(key);
            if (key == null) continue;
            switch (key) {
                case "user": {
                    this.settings.setString("username", value);
                    break;
                }
                case "channel": {
                    this.settings.setString("channel", value);
                    break;
                }
                case "connect": {
                    this.settings.setBoolean("connectOnStartup", true);
                    break;
                }
                case "token": {
                    if (!value.isEmpty() && (this.settings.getBoolean("allowTokenOverride") || this.settings.getString("token").isEmpty() || this.settings.getBoolean("foreignToken"))) {
                        this.settings.setString("token", value);
                        this.settings.setBoolean("foreignToken", true);
                    }
                    this.settings.setBoolean("usePassword", false);
                    break;
                }
                case "password": {
                    this.settings.setString("password", value);
                    this.settings.setBoolean("usePassword", true);
                    break;
                }
                case "ds": {
                    this.settings.setBoolean("dontSaveSettings", true);
                    break;
                }
                case "server": {
                    this.settings.setString("server", value);
                    break;
                }
                case "port": {
                    this.settings.setString("port", value);
                    break;
                }
                case "single": {
                    LOGGER.info("Single instance (port: " + (value.isEmpty() ? "default" : value) + ")");
                }
            }
            if (!key.startsWith("set:") || key.length() <= 4) continue;
            LOGGER.info("Setting commandline setting: " + this.settings.setTextual(key.substring(4) + " " + value, true));
        }
    }

    public void overrideSettings() {
        Color bgColor;
        String currentValue;
        previousVersion = this.settings.getString("currentVersion");
        if (!"0.28".equals(previousVersion)) {
            LOGGER.info("Changed from version " + previousVersion);
        }
        this.settings.setBoolean("ignoreJoinsParts", false);
        if (SettingsManager.switchedFromVersionBefore("0.7.2")) {
            String value = this.settings.getString("timeoutButtons");
            if (value.equals("5,2m,10m,30m")) {
                this.settings.setString("timeoutButtons", null);
                LOGGER.warning("Updated timeoutButtons setting to new default");
            } else if (!StringUtil.toLowerCase(value).contains("/ban") && !StringUtil.toLowerCase(value).contains("/unban")) {
                String newValue = "/Ban[B], /Unban[U], " + value;
                this.settings.setString("timeoutButtons", newValue);
                LOGGER.warning("Added /Ban,/Unban to timeoutButtons setting, now: " + newValue);
            }
        }
        if (SettingsManager.switchedFromVersionBefore("0.8.1") && this.settings.getString("portDefault").equals("6667,80")) {
            this.settings.setString("portDefault", "6667,443");
        }
        if (SettingsManager.switchedFromVersionBefore("0.8.2")) {
            if (this.settings.getString("serverDefault").equals("irc.twitch.tv")) {
                this.settings.setString("serverDefault", "irc.chat.twitch.tv");
            }
            if (this.settings.getString("portDefault").equals("6667,443")) {
                this.settings.setString("portDefault", "6697,6667,443,80");
            }
            this.settings.setAdd("securedPorts", 443L);
        }
        if (SettingsManager.switchedFromVersionBefore("0.8.5b4") && !StringUtil.toLowerCase(currentValue = this.settings.getString("timeoutButtons")).contains("/modunmod")) {
            this.settings.setString("timeoutButtons", currentValue + "\n/ModUnmod");
        }
        if (SettingsManager.switchedFromVersionBefore("0.8.6b3")) {
            this.settings.putList("notifications", this.getDefaultNotificationSettingValue());
        }
        if (SettingsManager.switchedFromVersionBefore("0.8.7b1") && !StringUtil.toLowerCase(currentValue = this.settings.getString("timeoutButtons")).contains("/automod_approve")) {
            this.settings.setString("timeoutButtons", currentValue + "\n\n@AutoMod\n.Approve=/Automod_approve\n.Deny=/Automod_deny");
        }
        if (SettingsManager.switchedFromVersionBefore("0.9.3") && !StringUtil.toLowerCase(currentValue = this.settings.getString("timeoutButtons")).contains("/delete")) {
            this.settings.setString("timeoutButtons", currentValue + "\n\nDelete=/delete $$(msg-id)");
        }
        if (SettingsManager.switchedFromVersionBefore("0.9.1b3")) {
            LOGGER.info("Migrating Favorites/History");
            List favs = this.settings.getList("channelFavorites");
            Map history = this.settings.getMap("channelHistory");
            Map data = this.settings.getMap("roomFavorites");
            for (String stream : history.keySet()) {
                boolean isFavorite = favs.contains(stream);
                long lastJoined = (Long)history.get(stream);
                String channel = Helper.toChannel(stream);
                if (data.containsKey(channel)) continue;
                data.put(channel, new ChannelFavorites.Favorite(Room.createRegular(channel), lastJoined, isFavorite).toList());
            }
            for (String fav : favs) {
                String channel = Helper.toChannel(fav);
                if (data.containsKey(channel)) continue;
                data.put(channel, new ChannelFavorites.Favorite(Room.createRegular(channel), -1L, true).toList());
            }
            this.settings.putMap("roomFavorites", data);
        }
        if (ColorCorrection.isDarkColor(bgColor = HtmlColors.decode(this.settings.getString("backgroundColor"))) && !this.settings.isValueSet("highlightBackground")) {
            this.settings.setBoolean("highlightBackground", false);
        }
        if (SettingsManager.switchedFromVersionBefore("0.9.3-b5") && !this.settings.getBoolean("colorCorrection")) {
            this.settings.setString("nickColorCorrection", "off");
        }
        if (SettingsManager.switchedFromVersionBefore("0.9.7-b4")) {
            this.settings.setLong("mentionsInfo", this.settings.getLong("mentions"));
        }
        if (SettingsManager.switchedFromVersionBefore("0.16")) {
            for (String setting : new String[]{"timestamp", "logTimestamp", "userDialogTimestamp"}) {
                this.settings.setString(setting, this.settings.getString(setting).replace("Y", "y"));
            }
        }
        if (SettingsManager.switchedFromVersionBefore("0.21-b3")) {
            this.settings.setBoolean("ffzEvent", false);
        }
        this.overrideHotkeySettings();
    }

    public static boolean switchedFromVersionBefore(String version) {
        if (previousVersion != null) {
            return Version.compareVersions(previousVersion, version) == 1;
        }
        return false;
    }

    public void debugSettings() {
    }

    public boolean checkSettingsDir() {
        return Files.isDirectory(Chatty.getPath(Chatty.PathType.SETTINGS), new LinkOption[0]);
    }

    private void addDefaultHotkey(String version, String id, String hotkey) {
        this.defaultHotkeys.add(new DefaultHotkey(version, Arrays.asList(id, hotkey)));
    }

    private void addDefaultHotkeyAppWide(String version, String id, String hotkey) {
        this.defaultHotkeys.add(new DefaultHotkey(version, Arrays.asList(id, hotkey, Hotkey.Type.APPLICATION.id)));
    }

    private List<List> getDefaultHotkeySettingValue() {
        ArrayList<List> data = new ArrayList<List>();
        for (DefaultHotkey hotkey : this.defaultHotkeys) {
            data.add(hotkey.data);
        }
        return data;
    }

    private void overrideHotkeySettings() {
        for (DefaultHotkey hotkey : this.defaultHotkeys) {
            if (!SettingsManager.switchedFromVersionBefore(hotkey.version)) continue;
            List setting = this.settings.getList("hotkeys");
            Iterator it = setting.iterator();
            while (it.hasNext()) {
                if (!((List)it.next()).get(0).equals(hotkey.data.get(0))) continue;
                it.remove();
            }
            setting.add(hotkey.data);
            LOGGER.info("Overriding hotkey setting: " + hotkey.data);
            this.settings.putList("hotkeys", setting);
        }
    }

    void startAutoSave(final TwitchClient c) {
        Timer timer = new Timer("AutoSaveSettings", false);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                int delay = (int)SettingsManager.this.settings.getLong("autoSaveSettings") * 60;
                if (delay > 0 && SettingsManager.this.lastAutoSaved.secondsElapsedSync(delay)) {
                    SettingsManager.this.lastAutoSaved.setSync();
                    List<FileManager.SaveResult> results = c.saveSettings(false, false);
                    if (results == null) {
                        return;
                    }
                    for (FileManager.SaveResult r : results) {
                        if (r.writeError == null) continue;
                        String msg = "[" + r.id + "] " + Helper.getErrorMessageCompact(r.writeError) + " (You can save manually under 'Main - Save..' to check if the issue persists.)";
                        if (r.backupWritten && r.backupError == null) {
                            msg = msg + "\nBackup was successfully written to: " + r.backupPath;
                        }
                        EventLog.addSystemEvent("session.settings.writeError", msg);
                    }
                }
            }
        }, 30000L, 30000L);
    }

    private List<List> getDefaultNotificationSettingValue() {
        String hl = "either";
        String st = "either";
        Notification.Builder hlNew = new Notification.Builder(Notification.Type.HIGHLIGHT);
        hlNew.setForeground(Color.BLACK);
        hlNew.setBackground(HtmlColors.decode("#FFFF79"));
        hlNew.setDesktopEnabled(SettingsManager.convertOldState(hl));
        Notification.Builder stNew = new Notification.Builder(Notification.Type.STREAM_STATUS);
        stNew.setForeground(Color.BLACK);
        stNew.setBackground(HtmlColors.decode("#FFFFF0"));
        stNew.setDesktopEnabled(SettingsManager.convertOldState(st));
        ArrayList<List> result = new ArrayList<List>();
        result.add(new Notification(hlNew).toList());
        result.add(new Notification(stNew).toList());
        return result;
    }

    private static Notification.State convertOldState(String input) {
        switch (input) {
            case "off": {
                return Notification.State.OFF;
            }
            case "both": {
                return Notification.State.CHANNEL_AND_APP_NOT_ACTIVE;
            }
            case "either": {
                return Notification.State.CHANNEL_OR_APP_NOT_ACTIVE;
            }
            case "app": {
                return Notification.State.APP_NOT_ACTIVE;
            }
            case "channel": {
                return Notification.State.CHANNEL_NOT_ACTIVE;
            }
            case "channelActive": {
                return Notification.State.CHANNEL_ACTIVE;
            }
            case "always": {
                return Notification.State.ALWAYS;
            }
        }
        return Notification.State.OFF;
    }

    private static class DefaultHotkey {
        String version;
        List data;

        DefaultHotkey(String version, List data) {
            this.version = version;
            this.data = data;
        }
    }
}

