/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.util.TimedCounter;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class SpamProtection {
    private final TimedCounter counter = new TimedCounter(30000L);
    private boolean enabled = false;
    private int lines;
    private int seconds;

    public synchronized void setLinesPerSeconds(int lines, int seconds) {
        this.enabled = lines > 0 && seconds > 0;
        this.lines = lines;
        this.seconds = seconds;
        this.counter.setInterval(TimeUnit.SECONDS.toMillis(seconds));
    }

    public void setLinesPerSeconds(String linesPerSeconds) {
        String[] split = linesPerSeconds.split("/");
        if (split.length == 2) {
            try {
                Integer lines = Integer.parseInt(split[0]);
                Integer seconds = Integer.parseInt(split[1]);
                this.setLinesPerSeconds(lines, seconds);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean check() {
        return this.getAllowance() > 0;
    }

    public synchronized int getAllowance() {
        if (!this.enabled) {
            return 1;
        }
        return this.lines - this.counter.getCount(true);
    }

    public synchronized void increase() {
        this.counter.increase();
    }

    public synchronized boolean tryMessage() {
        if (this.check()) {
            this.increase();
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%d lines in %d seconds, %d left", this.lines, this.seconds, this.getAllowance());
    }
}

