/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Addressbook;
import chatty.ChannelFavorites;
import chatty.ChannelState;
import chatty.ChannelStateManager;
import chatty.Chatty;
import chatty.Commands;
import chatty.CustomNames;
import chatty.ErrorHandler;
import chatty.Helper;
import chatty.Logging;
import chatty.Room;
import chatty.RoomManager;
import chatty.SendMessageManager;
import chatty.SettingsManager;
import chatty.Shutdown;
import chatty.SpamProtection;
import chatty.TestTimer;
import chatty.TwitchCommands;
import chatty.TwitchConnection;
import chatty.User;
import chatty.WhisperManager;
import chatty.gui.GuiUtil;
import chatty.gui.Highlighter;
import chatty.gui.MainGui;
import chatty.gui.colors.UsercolorManager;
import chatty.gui.components.SelectReplyMessage;
import chatty.gui.components.admin.StatusHistory;
import chatty.gui.components.eventlog.EventLog;
import chatty.gui.components.menus.UserContextMenu;
import chatty.gui.components.textpane.ModLogInfo;
import chatty.gui.components.updating.Stuff;
import chatty.gui.components.updating.Version;
import chatty.gui.defaults.DefaultsDialog;
import chatty.gui.laf.LaF;
import chatty.lang.Language;
import chatty.splash.Splash;
import chatty.util.BTTVEmotes;
import chatty.util.BatchAction;
import chatty.util.BotNameManager;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.EmoticonListener;
import chatty.util.IconManager;
import chatty.util.ImageCache;
import chatty.util.LogUtil;
import chatty.util.MacAwtOptions;
import chatty.util.MiscUtil;
import chatty.util.OtherBadges;
import chatty.util.ProcessManager;
import chatty.util.Pronouns;
import chatty.util.RawMessageTest;
import chatty.util.ReplyManager;
import chatty.util.Sound;
import chatty.util.Speedruncom;
import chatty.util.StreamHighlightHelper;
import chatty.util.StreamStatusWriter;
import chatty.util.StringUtil;
import chatty.util.TimerCommand;
import chatty.util.Timestamp;
import chatty.util.TwitchEmotesApi;
import chatty.util.UserRoom;
import chatty.util.Webserver;
import chatty.util.api.AccessChecker;
import chatty.util.api.AutoModCommandHelper;
import chatty.util.api.ChannelInfo;
import chatty.util.api.ChannelStatus;
import chatty.util.api.CheerEmoticon;
import chatty.util.api.EmotesetManager;
import chatty.util.api.Emoticon;
import chatty.util.api.EmoticonSizeCache;
import chatty.util.api.EmoticonUpdate;
import chatty.util.api.Emoticons;
import chatty.util.api.Follower;
import chatty.util.api.FollowerInfo;
import chatty.util.api.ResultManager;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamInfo;
import chatty.util.api.StreamInfoListener;
import chatty.util.api.TokenInfo;
import chatty.util.api.TwitchApi;
import chatty.util.api.TwitchApiResultListener;
import chatty.util.api.UserInfo;
import chatty.util.api.eventsub.EventSubListener;
import chatty.util.api.eventsub.EventSubManager;
import chatty.util.api.eventsub.Message;
import chatty.util.api.eventsub.Payload;
import chatty.util.api.eventsub.payloads.ChannelPointsRedemptionPayload;
import chatty.util.api.eventsub.payloads.ModActionPayload;
import chatty.util.api.eventsub.payloads.PollPayload;
import chatty.util.api.eventsub.payloads.RaidPayload;
import chatty.util.api.eventsub.payloads.ShieldModePayload;
import chatty.util.api.eventsub.payloads.ShoutoutPayload;
import chatty.util.api.eventsub.payloads.SuspiciousMessagePayload;
import chatty.util.api.eventsub.payloads.SuspiciousUpdatePayload;
import chatty.util.api.eventsub.payloads.UserMessageHeldPayload;
import chatty.util.api.eventsub.payloads.WarningAcknowledgePayload;
import chatty.util.api.usericons.Usericon;
import chatty.util.api.usericons.UsericonManager;
import chatty.util.chatlog.ChatLog;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.CustomCommands;
import chatty.util.commands.Parameters;
import chatty.util.ffz.FrankerFaceZ;
import chatty.util.ffz.FrankerFaceZListener;
import chatty.util.history.HistoryManager;
import chatty.util.history.HistoryMessage;
import chatty.util.history.QueuedMessage;
import chatty.util.irc.MsgTags;
import chatty.util.irc.UserTagsUtil;
import chatty.util.settings.FileManager;
import chatty.util.settings.Settings;
import chatty.util.settings.SettingsListener;
import chatty.util.seventv.SevenTV;
import chatty.util.seventv.WebPUtil;
import chatty.util.srl.SpeedrunsLive;
import chatty.util.tts.TextToSpeech;
import chatty.util.tts.TextToSpeechCommands;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class TwitchClient {
    private static final Logger LOGGER = Logger.getLogger(TwitchClient.class.getName());
    private volatile boolean shuttingDown = false;
    private volatile boolean settingsAlreadySavedOnExit = false;
    public static final String REQUEST_TOKEN_URL = "https://id.twitch.tv/oauth2/authorize?response_type=token&client_id=spyiu9jqdnfjtwv6l1xjk5zgt8qb91l&redirect_uri=http://127.0.0.1:61324/token/&force_verify=true&scope=";
    public final Settings settings;
    public final ChatLog chatLog;
    private final TwitchConnection c;
    public final TwitchApi api;
    public final EventSubManager eventSub;
    public final EmotesetManager emotesetManager;
    public final BTTVEmotes bttvEmotes;
    public final FrankerFaceZ frankerFaceZ;
    public final SevenTV sevenTV;
    public final ChannelFavorites channelFavorites;
    public final UsercolorManager usercolorManager;
    public final UsericonManager usericonManager;
    public final Addressbook addressbook;
    public final SpeedrunsLive speedrunsLive;
    public final Speedruncom speedruncom;
    public final StatusHistory statusHistory;
    public final StreamStatusWriter streamStatusWriter;
    protected final BotNameManager botNameManager;
    protected final CustomNames customNames;
    private final AutoModCommandHelper autoModCommandHelper;
    public final RoomManager roomManager;
    public final HistoryManager historyManager;
    private final SendMessageManager sendMessageManager;
    protected MainGui g;
    private final List<String> cachedDebugMessages = new ArrayList<String>();
    private final List<String> cachedWarningMessages = new ArrayList<String>();
    private User testUser;
    private final StreamInfo testStreamInfo = new StreamInfo("testStreamInfo", null);
    private Webserver webserver;
    private final SettingsManager settingsManager;
    private final SpamProtection spamProtection;
    public final CustomCommands customCommands;
    public final Commands commands = new Commands();
    private final TimerCommand timerCommand;
    private final StreamHighlightHelper streamHighlights;
    private final Set<String> refreshRequests = Collections.synchronizedSet(new HashSet());
    private final WhisperManager w;
    private final IrcLogger ircLogger;
    private boolean fixServer = false;
    private String launchCommand;

    public TwitchClient(Map<String, String> args) {
        new Logging(this);
        Thread.setDefaultUncaughtExceptionHandler(new ErrorHandler());
        LOGGER.info("### Log start (" + DateTime.fullDateTime() + ")");
        LOGGER.info(Chatty.chattyVersion());
        LOGGER.info(Helper.systemInfo());
        LOGGER.info("[Working Directory] " + System.getProperty("user.dir") + " [Settings Directory] " + Chatty.getPath(Chatty.PathType.SETTINGS) + " [Classpath] " + System.getProperty("java.class.path") + " [Launch Options] " + ManagementFactory.getRuntimeMXBean().getInputArguments());
        Helper.checkSLF4JBinding();
        this.settingsManager = new SettingsManager();
        this.settings = this.settingsManager.settings;
        this.settingsManager.defineSettings();
        this.settingsManager.loadSettingsFromFile();
        this.settingsManager.loadCommandLineSettings(args);
        this.settingsManager.overrideSettings();
        this.settingsManager.debugSettings();
        this.settingsManager.backupFiles();
        this.settingsManager.startAutoSave(this);
        MacAwtOptions.setMacLookSettings(this.settings);
        GuiUtil.inputLimitsEnabled = this.settings.getBoolean("inputLimitsEnabled");
        Chatty.setSettings(this.settings);
        Language.setLanguage(this.settings.getString("language"));
        Helper.setDefaultLocale(this.settings.getString("locale"));
        Helper.setDefaultTimezone(this.settings.getString("timezone"));
        String pathDebug = Chatty.getPathDebug();
        if (!StringUtil.isNullOrEmpty(pathDebug)) {
            LOGGER.info(pathDebug);
        }
        this.launchCommand = args.get("cc");
        this.addressbook = new Addressbook(Chatty.getPath(Chatty.PathType.SETTINGS).resolve("addressbook").toString(), Chatty.getPath(Chatty.PathType.SETTINGS).resolve("addressbookImport.txt").toString(), this.settings);
        if (!this.addressbook.loadFromSettings()) {
            this.addressbook.loadFromFile();
        }
        this.addressbook.setSomewhatUniqueCategories(this.settings.getString("abUniqueCats"));
        if (this.settings.getBoolean("abAutoImport")) {
            this.addressbook.enableAutoImport();
        }
        this.initDxSettings();
        System.setProperty("http.agent", "Chatty 0.28");
        System.setProperty("jna.debug_load", "true");
        if (!this.settingsManager.wasMainFileLoaded()) {
            DefaultsDialog.showAndWait(this.settings);
        }
        IconManager.setCustomIcons(this.settings.getList("icons"));
        if (this.settings.getBoolean("splash")) {
            Splash.initSplashScreen(Splash.getLocation((String)this.settings.mapGet("windows", "main")));
        }
        this.ircLogger = new IrcLogger();
        this.createTestUser("tduva", "");
        this.api = new TwitchApi(new TwitchApiResults(), new MyStreamInfoListener());
        this.addTwitchApiResultListeners();
        this.bttvEmotes = new BTTVEmotes(new EmoteListener(), this.api);
        TwitchEmotesApi.api.setTwitchApi(this.api);
        Timestamp.setTwitchApi(this.api);
        this.eventSub = new EventSubManager("wss://eventsub.wss.twitch.tv/ws", new EventSubResults(), this.api);
        this.frankerFaceZ = new FrankerFaceZ(new EmoticonsListener(), this.settings, this.api);
        this.sevenTV = new SevenTV(new EmoteListener(), this.api);
        ImageCache.setDefaultPath(Chatty.getPathCreate(Chatty.PathType.CACHE).resolve("img"));
        ImageCache.setCachingEnabled(this.settings.getBoolean("imageCache"));
        ImageCache.deleteExpiredFiles();
        EmoticonSizeCache.loadFromFile();
        this.usercolorManager = new UsercolorManager(this.settings);
        this.usericonManager = new UsericonManager(this.settings);
        this.customCommands = new CustomCommands(this.settings, this.api, this);
        this.botNameManager = new BotNameManager(this.settings);
        this.settings.addSettingsListener(new SettingSaveListener());
        this.streamHighlights = new StreamHighlightHelper(this.settings, this.api);
        this.customNames = new CustomNames(this.settings);
        this.chatLog = new ChatLog(this.settings);
        this.chatLog.start();
        this.testUser.setUserSettings(new User.UserSettings(100, this.usercolorManager, this.addressbook, this.usericonManager));
        this.speedrunsLive = new SpeedrunsLive();
        this.speedruncom = new Speedruncom(this.api);
        this.statusHistory = new StatusHistory(this.settings);
        this.settings.addSettingsListener(this.statusHistory);
        this.spamProtection = new SpamProtection();
        this.spamProtection.setLinesPerSeconds(this.settings.getString("spamProtection"));
        this.roomManager = new RoomManager(new MyRoomUpdatedListener());
        this.channelFavorites = new ChannelFavorites(this.settings, this.roomManager);
        this.historyManager = new HistoryManager(this.settings);
        this.c = new TwitchConnection(new Messages(), this.settings, "main", this.roomManager);
        this.c.setUserSettings(new User.UserSettings(this.settings.getInt("userDialogMessageLimit"), this.usercolorManager, this.addressbook, this.usericonManager));
        this.c.setCustomNamesManager(this.customNames);
        this.c.setBotNameManager(this.botNameManager);
        this.c.addChannelStateListener(new ChannelStateUpdater());
        this.c.setMaxReconnectionAttempts(this.settings.getLong("maxReconnectionAttempts"));
        AccessChecker.setInstance(new AccessChecker(this.settings, this));
        this.w = new WhisperManager(new MyWhisperListener(), this.settings, this.c, this);
        this.streamStatusWriter = new StreamStatusWriter(Chatty.getPath(Chatty.PathType.EXPORT), this.api);
        this.streamStatusWriter.setSetting(this.settings.getString("statusWriter"));
        this.streamStatusWriter.setEnabled(this.settings.getBoolean("enableStatusWriter"));
        this.settings.addSettingChangeListener(this.streamStatusWriter);
        LaF.setLookAndFeel(LaF.LaFSettings.fromSettings(this.settings));
        GuiUtil.addMacKeyboardActions();
        if (this.settings.getBoolean("webp")) {
            WebPUtil.runIfWebPAvailable(() -> {});
        }
        WebPUtil.setUseWebP(this.settings.getBoolean("webp"));
        LOGGER.info("Create GUI..");
        this.g = new MainGui(this);
        this.g.loadSettings();
        this.emotesetManager = new EmotesetManager(this.api, this.g, this.settings);
        this.g.showGui();
        this.autoModCommandHelper = new AutoModCommandHelper(this.g, this.api);
        this.sendMessageManager = new SendMessageManager(this.api, this.g);
        this.timerCommand = new TimerCommand(this.settings, new TimerCommand.TimerAction(){

            @Override
            public void performAction(String command, String chan, Parameters parameters, Set<TimerCommand.Option> options) {
                if (TwitchClient.this.isChannelOpen(chan)) {
                    TwitchClient.this.textInput(TwitchClient.this.c.getRoomByChannel(chan), command, parameters);
                } else if (options.contains((Object)TimerCommand.Option.CHANNEL_LENIENT)) {
                    parameters.put("timercommand-changed-channel", "true");
                    TwitchClient.this.textInput(TwitchClient.this.g.getActiveRoom(), command, parameters);
                } else {
                    TwitchClient.this.g.printSystem("Timed command not run, channel " + chan + " not open or not valid");
                    TwitchClient.this.g.printTimerLog("Timed command not run, channel " + chan + " not open or not valid: " + command);
                }
            }

            @Override
            public void log(String line) {
                TwitchClient.this.g.printTimerLog(line);
            }
        });
    }

    public void init() {
        String customPathsWarning;
        LOGGER.info("GUI shown");
        Splash.closeSplashScreen();
        this.warning(null);
        if (!this.settingsManager.checkSettingsDir()) {
            this.warning("The settings directory could not be created, so Chatty will not function correctly. Make sure that " + Chatty.getPath(Chatty.PathType.SETTINGS) + " is accessible or change it using launch options.");
            return;
        }
        this.addCommands();
        this.g.addGuiCommands();
        this.updateCustomCommands();
        this.checkForVersionChange();
        Helper.parseChannelHelper = new Helper.ParseChannelHelper(){

            @Override
            public Collection<String> getFavorites() {
                return TwitchClient.this.channelFavorites.getFavorites();
            }

            @Override
            public Collection<String> getNamesByCategory(String category) {
                return TwitchClient.this.addressbook.getNamesByCategory(category);
            }

            @Override
            public boolean isStreamLive(String stream) {
                StreamInfo info = TwitchClient.this.api.getCachedStreamInfo(stream);
                return info != null && info.isValidEnough() && info.getOnline();
            }
        };
        if (this.settings.getBoolean("connectOnStartup")) {
            this.prepareConnection();
        } else {
            switch ((int)this.settings.getLong("onStart")) {
                case 1: {
                    this.g.openConnectDialog(null);
                    break;
                }
                case 2: {
                    this.prepareConnectionWithChannel(this.settings.getString("autojoinChannel"));
                    break;
                }
                case 3: {
                    this.prepareConnectionWithChannel(this.settings.getString("previousChannel"));
                    break;
                }
                case 4: {
                    this.prepareConnectionWithChannel(Helper.buildStreamsString(this.channelFavorites.getFavorites()));
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Shutdown(this)));
        UserContextMenu.client = this;
        this.customCommandLaunch(this.launchCommand);
        this.launchCommand = null;
        String timerCommandLoadResult = this.timerCommand.loadFromSettings(this.settings);
        if (timerCommandLoadResult != null) {
            this.g.printSystem(timerCommandLoadResult);
        }
        if (!(customPathsWarning = Chatty.getInvalidPathInfo()).isEmpty()) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.g, customPathsWarning));
        }
    }

    private void initDxSettings() {
        try {
            Boolean d3d = !this.settings.getBoolean("nod3d");
            Boolean ddraw = this.settings.getBoolean("noddraw");
            String uiScale = null;
            if (this.settings.getLong("uiScale") > 0L) {
                uiScale = String.valueOf((double)this.settings.getLong("uiScale") / 100.0);
            }
            LOGGER.info(String.format("d3d: %s (%s) / noddraw: %s (%s) / opengl: (%s) / retina: %s / uiScale: %s", d3d, System.getProperty("sun.java2d.d3d"), ddraw, System.getProperty("sun.java2d.noddraw"), System.getProperty("sun.java2d.opengl"), GuiUtil.hasRetinaDisplay(), uiScale));
            System.setProperty("sun.java2d.d3d", d3d.toString());
            System.setProperty("sun.java2d.noddraw", ddraw.toString());
            if (uiScale != null) {
                System.setProperty("sun.java2d.uiScale", uiScale);
            }
        }
        catch (SecurityException ex) {
            LOGGER.warning("Error setting drawing settings: " + ex.getLocalizedMessage());
        }
    }

    public void updateCustomCommands() {
        this.customCommands.update(this.commands);
    }

    private void checkForVersionChange() {
        String currentVersion = this.settings.getString("currentVersion");
        if (!currentVersion.equals("0.28")) {
            this.settings.setString("currentVersion", "0.28");
            this.settings.setString("updateAvailable", "");
            if (this.settingsManager.wasMainFileLoaded()) {
                this.g.openReleaseInfo();
            }
        }
    }

    private void checkNewVersion() {
        Version.check(this.settings, (newVersion, releases) -> {
            if (newVersion != null) {
                this.g.setUpdateAvailable(newVersion, releases);
            } else {
                this.g.printSystem("You already have the newest version.");
            }
        });
    }

    private void createTestUser(String name, String channel) {
        this.testUser = new User(name, name, Room.createRegular(channel));
        this.testUser.setColor(new Color(94, 0, 211));
        this.testUser.setColor(new Color(255, 255, 255));
        this.testUser.setModerator(true);
        this.testUser.setSubscriber(true);
    }

    private void closeAllChannelsExcept(String[] except) {
        Set<String> copy = this.c.getOpenChannels();
        for (String channel : copy) {
            if (Arrays.asList(except).contains(channel)) continue;
            this.closeChannel(channel);
        }
    }

    public void closeChannel(String channel) {
        if (this.c.onChannel(channel)) {
            this.c.partChannel(channel);
        } else {
            Room room = this.roomManager.getRoom(channel);
            this.logViewerstats(channel);
            this.c.closeChannel(channel);
            this.closeChannelStuff(room);
            this.g.removeChannel(channel);
            this.chatLog.closeChannel(room.getFilename());
            this.updateStreamInfoChannelOpen(channel);
        }
        this.historyManager.channelClosed(Helper.toStream(channel));
    }

    private void closeChannelStuff(Room room) {
        if (!this.c.onOwnerChannel(room.getOwnerChannel())) {
            this.frankerFaceZ.left(room.getOwnerChannel());
            this.eventSub.unlistenRaid(room.getStream());
            this.eventSub.unlistenPoll(room.getStream());
            this.eventSub.unlistenShield(room.getStream());
            this.eventSub.unlistenShoutouts(room.getStream());
            this.eventSub.unlistenModActions(room.getStream());
            this.eventSub.unlistenAutoMod(room.getStream());
            this.eventSub.unlistenSuspicousMessage(room.getStream());
            this.eventSub.unlistenWarnings(room.getStream());
            this.eventSub.unlistenMessageHeld(room.getStream());
        }
    }

    private void addressbookCommands(String channel, User user, String text) {
        if (this.settings.getString("abCommandsChannel").equalsIgnoreCase(channel) && user.isModerator()) {
            if ((text = text.trim()).length() < 2) {
                return;
            }
            String command = text.split(" ")[0].substring(1);
            List<String> activatedCommands = Arrays.asList(this.settings.getString("abCommands").split(","));
            if (activatedCommands.contains(command)) {
                String commandText = text.substring(1);
                this.g.printSystem("[Ab/Mod] " + this.addressbook.command(commandText));
            }
        }
    }

    public String getUsername() {
        return this.c.getUsername();
    }

    public User getUser(String channel, String name) {
        return this.c.getUser(channel, name);
    }

    public User getExistingUser(String channel, String name) {
        return this.c.getExistingUser(channel, name);
    }

    public User getLocalUser(String channel) {
        return this.c.getExistingUser(channel, this.c.getUsername());
    }

    public void clearUserList() {
        this.c.setAllOffline();
        this.g.clearUsers(null);
    }

    private String getServer() {
        String serverDefault = this.settings.getString("serverDefault");
        String serverTemp = this.settings.getString("server");
        return serverTemp.length() > 0 ? serverTemp : serverDefault;
    }

    private String getPorts() {
        String portDefault = this.settings.getString("portDefault");
        String portTemp = this.settings.getString("port");
        return portTemp.length() > 0 ? portTemp : portDefault;
    }

    public final boolean prepareConnection() {
        return this.prepareConnection(this.getServer(), this.getPorts());
    }

    public boolean prepareConnection(boolean rejoinOpenChannels) {
        if (rejoinOpenChannels) {
            return this.prepareConnection(this.getServer(), this.getPorts(), null);
        }
        return this.prepareConnection();
    }

    public final boolean prepareConnectionWithChannel(String channel) {
        return this.prepareConnection(this.getServer(), this.getPorts(), channel);
    }

    public boolean prepareConnection(String server, String ports) {
        return this.prepareConnection(server, ports, this.settings.getString("channel"));
    }

    public final boolean prepareConnectionAnyChannel(String server, String ports) {
        String channel = null;
        if (this.c.getOpenChannels().isEmpty()) {
            channel = this.settings.getString("channel");
        }
        return this.prepareConnection(server, ports, channel);
    }

    public boolean prepareConnection(String server, String ports, String channel) {
        String username = this.settings.getString("username");
        String password = this.settings.getString("password");
        boolean usePassword = this.settings.getBoolean("usePassword");
        String token = this.settings.getString("token");
        String login = "oauth:" + token;
        if (token.isEmpty()) {
            login = "";
        }
        if (usePassword) {
            login = password;
            LOGGER.info("Using password instead of token.");
        }
        return this.prepareConnection(username, login, channel, server, ports);
    }

    public boolean prepareConnection(String name, String password, String channel, String server, String ports) {
        String[] autojoin;
        this.fixServer = false;
        if (this.c.getState() > 0) {
            this.g.showMessage("Cannot connect: Already connected.");
            return false;
        }
        if (name == null || name.isEmpty() || password == null || password.isEmpty()) {
            this.g.showMessage(Language.getString("connect.error.noLogin"));
            this.showConnectDialogIfMissing();
            return false;
        }
        Set<String> openChannels = this.c.getOpenChannels();
        if (channel == null) {
            autojoin = new String[openChannels.size()];
            openChannels.toArray(autojoin);
        } else {
            autojoin = Helper.parseChannels(channel);
        }
        if (autojoin.length == 0) {
            this.g.showMessage(Language.getString("connect.error.noChannel"));
            this.showConnectDialogIfMissing();
            return false;
        }
        if (server == null || server.isEmpty()) {
            this.g.showMessage("Invalid server specified.");
            return false;
        }
        this.closeAllChannelsExcept(autojoin);
        this.settings.setString("username", name);
        if (channel != null) {
            this.settings.setString("channel", channel);
        }
        this.api.requestUserId(Helper.toStream(autojoin));
        this.c.connect(server, ports, name, password, autojoin);
        return true;
    }

    private void showConnectDialogIfMissing() {
        if (this.settings.getBoolean("connectDialogIfMissing")) {
            this.g.openConnectDialog(null);
        }
    }

    public boolean disconnect() {
        return this.c.disconnect();
    }

    public void joinChannels(Set<String> channels) {
        this.c.joinChannels(channels);
    }

    public void joinChannel(String channels) {
        this.c.joinChannel(channels);
    }

    public int getState() {
        return this.c.getState();
    }

    public void textInput(Room room, String text, Parameters commandParameters) {
        if (text.isEmpty()) {
            return;
        }
        Debugging.println("textinput", "'%s' in %s (%s)", text, room, commandParameters);
        text = this.g.replaceEmojiCodes(text);
        String channel = room.getChannel();
        if (text.startsWith("//")) {
            this.anonCustomCommand(room, text.substring(1), commandParameters);
        } else if (text.startsWith("/")) {
            this.commandInput(room, text, commandParameters);
        } else if (!this.checkRejectTimedMessage(room, commandParameters)) {
            if (this.c.onChannel(channel)) {
                this.sendMessage(channel, text, true);
            } else if (channel.startsWith("$")) {
                this.w.whisperChannel(channel, text);
            } else if (channel.startsWith("*")) {
                this.c.sendCommandMessage(channel, text, "> " + text);
            } else {
                this.g.printLine("Not in a channel");
            }
        }
    }

    private void sendMessage(String channel, String text) {
        if (this.c.onChannel(channel, true)) {
            this.sendMessage(channel, text, false);
        }
    }

    private void sendMessage(String channel, String text, boolean allowCommandMessageLocally) {
        if (this.sendAsReply(channel, text)) {
            return;
        }
        if (this.c.sendSpamProtectedMessage(channel, text, false)) {
            User user = this.c.localUserJoined(channel);
            this.g.printMessage(user, text, false);
            if (allowCommandMessageLocally) {
                this.modCommandAddStreamHighlight(user, text, MsgTags.EMPTY);
            }
        } else {
            this.g.printLine("# Message not sent to prevent ban: " + text);
        }
    }

    private boolean sendAsReply(String channel, String text) {
        String[] split;
        boolean restricted = this.settings.getBoolean("mentionReplyRestricted");
        boolean doubleAt = text.startsWith("@@");
        if ((doubleAt || !restricted && text.startsWith("@")) && (split = text.split(" ", 2)).length == 2 && split[0].length() > 2 && split[1].length() > 0) {
            String username = split[0].substring(doubleAt ? 2 : 1);
            String actualMsg = split[1];
            User user = this.c.getExistingUser(channel, username);
            if (user != null) {
                SelectReplyMessage.settings = this.settings;
                SelectReplyMessage.SelectReplyMessageResult result = SelectReplyMessage.show(user);
                if (result.action != SelectReplyMessage.SelectReplyMessageResult.Action.SEND_NORMALLY) {
                    if (result.action == SelectReplyMessage.SelectReplyMessageResult.Action.REPLY) {
                        this.sendReply(channel, actualMsg, username, result.atMsgId, result.atMsg);
                    } else {
                        this.g.insert(text, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void sendReply(String channel, String text, String atUsername, String atMsgId, String atMsg) {
        String tempMsgId = this.sendMessageManager.sendApiMessage(channel, text, atMsgId, false);
        MsgTags tags = MsgTags.create("reply-parent-msg-id", atMsgId, "chatty-temp-msg-id", tempMsgId);
        User user = this.c.localUserJoined(channel);
        String localOutputText = text;
        if (!text.startsWith("@")) {
            localOutputText = String.format("@%s %s", atUsername, text);
        }
        this.g.printMessage(user, localOutputText, false, tags);
    }

    public boolean isOwnUsername(String name) {
        String ownUsername = this.getUsername();
        return ownUsername != null && ownUsername.equalsIgnoreCase(name);
    }

    private boolean checkRejectTimedMessage(Room room, Parameters parameters) {
        boolean rejected;
        User localUser = this.getLocalUser(room.getChannel());
        boolean isTimed = parameters != null && parameters.hasKey("timercommand");
        boolean bl = rejected = isTimed && (!Helper.isRegularChannelStrict(room.getChannel()) || localUser == null || !localUser.hasModeratorRights() || parameters.hasKey("timercommand-changed-channel"));
        if (rejected) {
            this.g.printSystem(room, "Could not send timed message (not a moderator or invalid channel)");
        }
        return rejected;
    }

    private boolean rejectTimedMessage(String command, Room room, Parameters parameters) {
        boolean rejected;
        boolean bl = rejected = parameters != null && parameters.hasKey("timercommand");
        if (rejected) {
            this.g.printSystem(room, "Could not send timed message (command /" + command + " not allowed)");
            this.g.printTimerLog("Could not send timed message (command /" + command + " not allowed): " + parameters.getArgs());
        }
        return rejected;
    }

    public boolean isChannelOpen(String channel) {
        return this.c.isChannelOpen(channel);
    }

    public boolean isChannelJoined(String channel) {
        return this.c.onChannel(channel, false);
    }

    public void updateStreamInfoChannelOpen(String channel) {
        StreamInfo streamInfo = this.api.getCachedStreamInfo(Helper.toStream(channel));
        if (streamInfo != null) {
            streamInfo.setIsOpen(this.c.isChannelOpen(channel));
        }
    }

    public boolean isUserlistLoaded(String channel) {
        return this.c.isUserlistLoaded(channel);
    }

    public boolean commandInput(Room room, String text) {
        return this.commandInput(room, text, null);
    }

    public boolean commandInput(Room room, String text, Parameters parameters) {
        String[] split = text.split(" ", 2);
        String command = split[0].substring(1);
        String args = null;
        if (split.length == 2) {
            args = split[1];
        }
        if (parameters == null) {
            parameters = Parameters.create(args);
        } else {
            parameters.putArgs(args);
        }
        return this.command(room, command, parameters);
    }

    public boolean command(Room room, String command) {
        return this.command(room, command, Parameters.create(null));
    }

    public boolean command(Room room, String command, String parameter) {
        return this.command(room, command, Parameters.create(parameter));
    }

    private void addCommands() {
        this.commands.add("quit", p -> this.c.quit(), new String[0]);
        this.commands.add("server", p -> this.commandServer(p.getArgs()), new String[0]);
        this.commands.add("reconnect", p -> this.commandReconnect(), new String[0]);
        this.commands.add("connection", p -> this.g.printLine(p.getRoom(), this.c.getConnectionInfo()), new String[0]);
        this.commands.add("join", p -> this.commandJoinChannel(p.getArgs()), new String[0]);
        this.commands.add("part", p -> this.commandPartChannel(p.getChannel()), "close");
        this.commands.add("rejoin", p -> this.commandRejoinChannel(p.getChannel()), new String[0]);
        this.commands.add("raw", p -> {
            if (this.rejectTimedMessage("raw", p.getRoom(), p.getParameters())) {
                return;
            }
            if (p.hasArgs()) {
                this.c.sendRaw(p.getArgs());
            }
        }, new String[0]);
        this.commands.add("me", p -> {
            if (this.checkRejectTimedMessage(p.getRoom(), p.getParameters())) {
                return;
            }
            this.commandActionMessage(p.getChannel(), p.getArgs());
        }, new String[0]);
        this.commands.add("say", p -> {
            if (this.checkRejectTimedMessage(p.getRoom(), p.getParameters())) {
                return;
            }
            if (p.hasArgs()) {
                this.sendMessage(p.getChannel(), p.getArgs());
            } else {
                this.g.printLine(p.getRoom(), "Usage: /say <message>");
            }
        }, new String[0]);
        this.commands.add("msg", p -> {
            if (this.rejectTimedMessage("msg", p.getRoom(), p.getParameters())) {
                return;
            }
            this.commandCustomMessage(p.getArgs());
        }, new String[0]);
        this.commands.add("msgreply", p -> {
            if (this.checkRejectTimedMessage(p.getRoom(), p.getParameters())) {
                return;
            }
            if (p.getParameters().notEmpty("nick", "msg-id", "msg") && p.hasArgs()) {
                String atUsername = p.getParameters().get("nick");
                String atMsgId = p.getParameters().get("msg-id");
                String atMsg = p.getParameters().get("msg");
                String msg = p.getArgs();
                this.sendReply(p.getChannel(), msg, atUsername, atMsgId, atMsg);
            } else {
                this.g.printLine("Invalid reply parameters");
            }
        }, "msgreplythread");
        this.commands.add("w", p -> {
            if (this.rejectTimedMessage("w", p.getRoom(), p.getParameters())) {
                return;
            }
            this.w.whisperCommand(p.getArgs(), false);
        }, new String[0]);
        this.commands.add("changeToken", p -> this.g.changeToken(p.getArgs()), new String[0]);
        this.commands.add("dir", p -> this.g.printSystem("Settings directory: " + Chatty.getPathInfo(Chatty.PathType.SETTINGS)), new String[0]);
        this.commands.add("wdir", p -> this.g.printSystem("Working directory: " + Chatty.getPathInfo(Chatty.PathType.WORKING)), new String[0]);
        this.commands.add("opendir", p -> MiscUtil.openFile(Chatty.getPath(Chatty.PathType.SETTINGS), (Component)this.g), new String[0]);
        this.commands.add("openwdir", p -> MiscUtil.openFile(Chatty.getPath(Chatty.PathType.WORKING), (Component)this.g), new String[0]);
        this.commands.add("showJarDir", p -> {
            Path path = Stuff.determineJarPath();
            if (path != null) {
                this.g.printSystem("JAR directory: " + path.getParent());
            } else {
                this.g.printSystem("JAR directory unknown");
            }
        }, new String[0]);
        this.commands.add("openJarDir", p -> {
            Path path = Stuff.determineJarPath();
            if (path != null) {
                MiscUtil.openFile(path.getParent().toFile(), (Component)this.g);
            } else {
                this.g.printSystem("JAR directory unknown");
            }
        }, new String[0]);
        this.commands.add("showBackupDir", p -> this.g.printSystem("Backup directory: " + Chatty.getPathInfo(Chatty.PathType.BACKUP)), new String[0]);
        this.commands.add("openBackupDir", p -> MiscUtil.openFile(Chatty.getPathCreate(Chatty.PathType.BACKUP), (Component)this.g), new String[0]);
        this.commands.add("showTempDir", p -> this.g.printSystem("System Temp directory: " + Chatty.getTempDirectory()), new String[0]);
        this.commands.add("openTempDir", p -> MiscUtil.openFile(new File(Chatty.getTempDirectory()), (Component)this.g), new String[0]);
        this.commands.add("showDebugDir", p -> this.g.printSystem("Debug Log Directory: " + Chatty.getPathInfo(Chatty.PathType.DEBUG)), new String[0]);
        this.commands.add("openDebugDir", p -> MiscUtil.openFile(Chatty.getPath(Chatty.PathType.DEBUG), (Component)this.g), new String[0]);
        this.commands.add("showLogDir", p -> this.g.printSystem("Chat Log Directory: " + Chatty.getPathInfo(Chatty.PathType.LOGS)), new String[0]);
        this.commands.add("openLogDir", p -> {
            if (this.chatLog.getPath() != null) {
                MiscUtil.openFile(this.chatLog.getPath().toAbsolutePath().toFile(), (Component)this.g);
            } else {
                this.g.printSystem("Invalid Chat Log Directory");
            }
        }, new String[0]);
        this.commands.add("showJavaDir", p -> this.g.printSystem("JRE directory: " + System.getProperty("java.home")), new String[0]);
        this.commands.add("openJavaDir", p -> MiscUtil.openFile(new File(System.getProperty("java.home")), (Component)this.g), new String[0]);
        this.commands.add("showFallbackFontDir", p -> {
            Path path = Paths.get(System.getProperty("java.home"), "lib", "fonts", "fallback");
            this.g.printSystem("Fallback font directory (may not exist yet): " + path);
        }, new String[0]);
        this.commands.add("openFallbackFontDir", p -> {
            Path path = Paths.get(System.getProperty("java.home"), "lib", "fonts", "fallback");
            if (Files.exists(path, new LinkOption[0])) {
                MiscUtil.openFile(path.toFile(), (Component)this.g);
            } else {
                path = path.getParent();
                this.g.showPopupMessage("Fallback font folder does not exist. Create a folder called 'fallback' in '" + path + "'.");
                MiscUtil.openFile(path.toFile(), (Component)this.g);
            }
        }, new String[0]);
        this.commands.add("copy", p -> MiscUtil.copyToClipboard(p.getArgs()), new String[0]);
        this.commands.add("releaseInfo", p -> this.g.openReleaseInfo(), new String[0]);
        this.commands.add("echo", p -> {
            if (p.hasArgs()) {
                this.g.printLine(p.getRoom(), p.getArgs());
            } else {
                this.g.printLine(p.getRoom(), "Invalid parameters: /echo <message>");
            }
        }, new String[0]);
        this.commands.add("echoall", p -> {
            if (p.hasArgs()) {
                this.g.printLineAll(p.getArgs());
            } else {
                this.g.printLine("Invalid parameters: /echoall <message>");
            }
        }, new String[0]);
        this.commands.add("uptime", p -> this.g.printSystem("Chatty has been running for " + Chatty.uptime()), new String[0]);
        this.commands.add("appinfo", p -> this.g.printSystem(LogUtil.getAppInfo() + " [Connection] " + this.c.getConnectionInfo()), new String[0]);
        this.commands.add("timer", p -> {
            TimerCommand.TimerResult result = this.timerCommand.command(p.getArgs(), p.getRoom(), p.getParameters());
            if (result.message != null) {
                this.g.printSystemMultline(null, result.message);
                this.g.printTimerLog(result.message);
            }
        }, new String[0]);
        this.commands.add("exportText", p -> {
            Commands.CommandParsedArgs args = p.parsedArgs(2);
            if (args != null) {
                boolean success;
                String file = args.get(0);
                String text = args.hasOption("n") ? args.get(1).replace("\\n", "\n") : args.get(1);
                boolean append = args.hasOption("a");
                if (args.hasOption("A")) {
                    text = text + "\n";
                    append = true;
                }
                if (args.hasOption("L")) {
                    text = "\n" + text;
                    append = true;
                }
                if (success = MiscUtil.exportText(file, text, append)) {
                    if (!args.hasOption("s")) {
                        this.g.printSystem("File written successfully.");
                    }
                } else {
                    this.g.printSystem("Failed to write file, see debug log.");
                }
            } else {
                this.g.printSystem("Usage: /exportText <fileName> <text>");
            }
        }, new String[0]);
        this.commands.add("clearUserMessages", p -> {
            Commands.CommandParsedArgs a = p.parsedArgs(0);
            String chan = p.getChannel();
            boolean numOnly = false;
            if (a != null) {
                chan = a.hasOption("a") ? null : p.getChannel();
                numOnly = a.hasOption("n");
            }
            int result = this.c.clearLines(chan, numOnly);
            this.g.printSystem(p.getRoom(), String.format("%s of %d users in %s", numOnly ? "Reset number of messages" : "Cleared message history", result, chan != null ? chan : "all channels"));
        }, new String[0]);
        this.commands.add("logAudioInfo", p -> Sound.logAudioSystemInfo(), new String[0]);
        this.commands.add("set", p -> this.g.printSystem(this.settings.setTextual(p.getArgs(), true)), new String[0]);
        this.commands.add("set2", p -> this.g.printSystem(this.settings.setTextual(p.getArgs(), false)), new String[0]);
        this.commands.add("setSwitch", p -> this.g.printSystem(this.settings.setSwitchTextual(p.getArgs(), true)), new String[0]);
        this.commands.add("setSwitch2", p -> this.g.printSystem(this.settings.setSwitchTextual(p.getArgs(), false)), new String[0]);
        this.commands.add("setList", p -> this.g.printSystem(this.settings.setListTextual(p.getArgs())), new String[0]);
        this.commands.add("get", p -> this.g.printSystem(this.settings.getTextual(p.getArgs())), new String[0]);
        this.commands.add("clearsetting", p -> this.g.printSystem(this.settings.clearTextual(p.getArgs())), new String[0]);
        this.commands.add("reset", p -> this.g.printSystem(this.settings.resetTextual(p.getArgs())), new String[0]);
        this.commands.add("add", p -> this.g.printSystem(this.settings.addTextual(p.getArgs(), true)), new String[0]);
        this.commands.add("add2", p -> this.g.printSystem(this.settings.addTextual(p.getArgs(), false)), new String[0]);
        this.commands.add("addUnique", p -> this.g.printSystem(this.settings.addUniqueTextual(p.getArgs(), true)), new String[0]);
        this.commands.add("addUnique2", p -> this.g.printSystem(this.settings.addUniqueTextual(p.getArgs(), false)), new String[0]);
        this.commands.add("remove", p -> this.g.printSystem(this.settings.removeTextual(p.getArgs(), true)), new String[0]);
        this.commands.add("remove2", p -> this.g.printSystem(this.settings.removeTextual(p.getArgs(), false)), new String[0]);
        this.commands.add("setcolor", p -> {
            if (p.hasArgs()) {
                this.g.setColor(p.getArgs());
            }
        }, new String[0]);
        this.commands.add("setname", p -> this.g.printLine(this.customNames.commandSetCustomName(p.getArgs())), new String[0]);
        this.commands.add("resetname", p -> this.g.printLine(this.customNames.commandResetCustomname(p.getArgs())), new String[0]);
        this.commands.add("customCompletion", p -> this.commandCustomCompletion(p.getArgs()), new String[0]);
        this.commands.add("ab", p -> this.g.printSystem("[Addressbook] " + this.addressbook.command(p.hasArgs() ? p.getArgs() : "")), "users");
        this.commands.add("abimport", p -> {
            this.g.printSystem("[Addressbook] Importing from file..");
            this.addressbook.importFromFile();
        }, new String[0]);
        this.commands.add("ignore", p -> this.commandSetIgnored(p.getArgs(), null, true), new String[0]);
        this.commands.add("unIgnore", p -> this.commandSetIgnored(p.getArgs(), null, false), new String[0]);
        this.commands.add("ignoreChat", p -> this.commandSetIgnored(p.getArgs(), "chat", true), new String[0]);
        this.commands.add("unignoreChat", p -> this.commandSetIgnored(p.getArgs(), "chat", false), new String[0]);
        this.commands.add("ignoreWhisper", p -> this.commandSetIgnored(p.getArgs(), "whisper", true), new String[0]);
        this.commands.add("unignoreWhisper", p -> this.commandSetIgnored(p.getArgs(), "whisper", false), new String[0]);
        this.commands.add("ffz", p -> {
            if (p.hasArgs() && p.getArgs().startsWith("following")) {
                this.commandFFZFollowing(p.getRoom().getOwnerChannel(), p.getArgs());
            } else {
                this.commandFFZ(p.getRoom().getOwnerChannel());
            }
        }, new String[0]);
        this.commands.add("ffzws", p -> this.g.printSystem("[FFZ-WS] Status: " + this.frankerFaceZ.getWsStatus()), new String[0]);
        this.commands.add("pubsubstatus", p -> this.g.printSystem("[PubSub] Removed"), new String[0]);
        this.commands.add("refresh", p -> this.commandRefresh(p.getRoom().getOwnerChannel(), p.getArgs()), new String[0]);
        this.commands.add("clearimagecache", p -> {
            this.g.printLine("Clearing image cache (this can take a few seconds)");
            int result = ImageCache.clearCache(null);
            if (result == -1) {
                this.g.printLine("Failed clearing image cache.");
            } else {
                this.g.printLine(String.format("Deleted %d image cache files", result));
            }
        }, new String[0]);
        this.commands.add("clearemotecache", p -> {
            this.g.printLine("Clearing Emoticon image cache for type " + p.getArgs() + ".");
            int result = ImageCache.clearCache("emote_" + p.getArgs());
            if (result == -1) {
                this.g.printLine("Failed clearing image cache.");
            } else {
                this.g.printLine(String.format("Deleted %d image cache files", result));
            }
        }, new String[0]);
        this.commands.add("follow", p -> this.commandFollow(p.getChannel(), p.getArgs()), new String[0]);
        this.commands.add("unfollow", p -> this.commandUnfollow(p.getChannel(), p.getArgs()), new String[0]);
        this.commands.add("favorite", p -> {
            ChannelFavorites.Favorite result = !p.hasArgs() ? this.channelFavorites.addFavorite(p.getChannel()) : this.channelFavorites.addFavorite(p.getArgs());
            if (result != null) {
                this.g.printSystem("Added '" + result + "' to favorites");
            } else {
                this.g.printSystem("Failed adding favorite");
            }
        }, new String[0]);
        this.commands.add("unfavorite", p -> {
            ChannelFavorites.Favorite result = !p.hasArgs() ? this.channelFavorites.removeFavorite(p.getChannel()) : this.channelFavorites.removeFavorite(p.getArgs());
            if (result != null) {
                this.g.printSystem("Removed '" + result + "' from favorites");
            } else {
                this.g.printSystem("Failed removing favorite");
            }
        }, new String[0]);
        this.commands.add("automod_approve", p -> this.autoModCommandHelper.approve(p.getChannel(), p.getArgs()), new String[0]);
        this.commands.add("automod_deny", p -> this.autoModCommandHelper.deny(p.getChannel(), p.getArgs()), new String[0]);
        this.commands.add("marker", p -> this.commandAddStreamMarker(p.getRoom(), p.getArgs()), new String[0]);
        this.commands.add("createClip", p -> {
            this.api.subscribe(ResultManager.Type.CREATE_CLIP, this.commands, (editUrl, viewUrl, error) -> {
                if (error != null) {
                    this.g.printLine(p.getRoom(), error);
                } else {
                    MsgTags tags = MsgTags.createLinks(new MsgTags.Link(MsgTags.Link.Type.URL, editUrl, 14, 22));
                    this.g.printInfo(p.getRoom(), "Clip created (Edit Clip): " + viewUrl, tags);
                }
            });
            this.api.createClip(p.getRoom().getStream());
        }, new String[0]);
        this.c.addNewCommands(this.commands, this);
        this.commands.add("addStreamHighlight", p -> this.commandAddStreamHighlight(p.getRoom(), p.getArgs()), new String[0]);
        this.commands.add("openStreamHighlights", p -> this.commandOpenStreamHighlights(p.getRoom()), new String[0]);
        this.commands.add("triggerNotification", p -> {
            Commands.CommandParsedArgs args = p.parsedArgs(1);
            if (args != null) {
                List<String> split;
                String title = null;
                String text = args.get(0);
                if (args.hasOption("t") && (split = StringUtil.split(text, ' ', '\"', '\"', 2, 1)).size() == 2) {
                    title = split.get(0);
                    text = split.get(1);
                }
                String item = "";
                if (args.hasOption("h")) {
                    item = item + " config:!notify";
                }
                if (args.hasOption("m")) {
                    item = item + " config:silent";
                }
                this.g.triggerCommandNotification(p.getChannel(), title, text, new Highlighter.HighlightItem(item));
            } else {
                this.g.printSystem("Usage: /triggerNotification [-hmt] <text>");
            }
        }, new String[0]);
        this.commands.add("testNotification", p -> {
            String[] split;
            String args = p.getArgs();
            if (args == null) {
                args = "";
            }
            if ((split = args.split("\\|\\|", 2)).length == 2) {
                this.g.showTestNotification(null, split[0], split[1]);
            } else {
                this.g.showTestNotification(args, null, null);
            }
        }, new String[0]);
        this.commands.add("clearChat", p -> this.g.clearChat(), new String[0]);
        this.commands.add("resortUserlist", p -> this.g.resortUsers(p.getRoom()), new String[0]);
        this.commands.add("proc", p -> this.g.printSystem("[Proc] " + ProcessManager.command(p.getArgs(), s -> this.g.printSystem("[ProcOutput] " + s))), new String[0]);
        this.commands.add("chain", p -> {
            List<String> commands = Helper.getChainedCommands(p.getArgs());
            if (commands.isEmpty()) {
                this.g.printSystem("No valid commands");
            }
            for (String chainedCommand : commands) {
                this.textInput(p.getRoom(), chainedCommand, p.getParameters().copy());
            }
        }, new String[0]);
        this.commands.add("foreach", p -> {
            if (p.hasArgs()) {
                String[] split = Helper.getForeachParams(p.getArgs());
                if (split[0] == null) {
                    this.g.printSystem("No list specified for foreach");
                } else if (split[1] == null) {
                    this.g.printSystem("No command specified for foreach");
                } else {
                    String list = split[0];
                    String command = split[1];
                    String[] splitList = list.split(" ");
                    CustomCommand customCommand = CustomCommand.parse(command);
                    if (customCommand.hasError()) {
                        this.g.printSystem("Command specified for foreach is invalid");
                    } else {
                        for (String item : splitList) {
                            Parameters param = Parameters.create(item);
                            if (p.getParameters().hasKey("timercommand")) {
                                param.put("timercommand", p.getParameters().get("timercommand"));
                            }
                            Debugging.println("foreach", "Foreach command: %s Param: %s", customCommand, param);
                            this.anonCustomCommand(p.getRoom(), customCommand, param);
                        }
                    }
                }
            } else {
                this.g.printSystem("Usage: /foreach [list] > [command]");
            }
        }, new String[0]);
        this.commands.add("tts", "Text to Speech", p -> {
            TextToSpeechCommands.settings = this.settings;
            this.g.printSystem(TextToSpeechCommands.command(p));
        }, new String[0]);
        this.commands.add("runin", p -> {
            String[] split;
            if (!p.hasArgs() || (split = p.getArgs().split(" ", 2)).length != 2) {
                this.g.printSystem("Usage: /runin [channel] [command]");
                return;
            }
            String chan = split[0];
            String command = split[1];
            if (Helper.isValidStream(chan)) {
                chan = Helper.toChannel(chan);
            }
            if (this.isChannelOpen(chan = StringUtil.toLowerCase(chan)) || Helper.isValidWhisperChannel(chan)) {
                this.textInput(this.c.getRoomByChannel(chan), command, p.getParameters().copy());
            } else {
                this.g.printSystem("Invalid channel: " + chan);
            }
        }, new String[0]);
        this.commands.add("debug", p -> {
            if (this.rejectTimedMessage("debug", p.getRoom(), p.getParameters())) {
                return;
            }
            String[] split = p.getArgs().split(" ", 2);
            String actualCommand = split[0];
            String actualParamter = null;
            if (split.length == 2) {
                actualParamter = split[1];
            }
            this.testCommands(p.getRoom(), actualCommand, actualParamter);
        }, new String[0]);
    }

    public boolean command(Room room, String command, Parameters parameters) {
        String channel = room.getChannel();
        String parameter = parameters.getArgs();
        if (!this.commands.performCommand(command = StringUtil.toLowerCase(command), room, parameters)) {
            if (TwitchCommands.isCommand(command)) {
                if (!this.checkRejectTimedMessage(room, parameters)) {
                    this.c.command(channel, command, parameter, null);
                }
            } else if (this.customCommands.containsCommand(command, room)) {
                this.customCommand(room, command, parameters);
            } else {
                this.g.printLine(Language.getString("chat.unknownCommand", command));
                return false;
            }
        }
        return true;
    }

    private void testCommands(Room room, String command, String parameter) {
        String channel = room.getChannel();
        if (command.equals("addchans")) {
            String[] split2;
            String[] splitSpace = parameter.split(" ");
            for (String chan : split2 = splitSpace[0].split(",")) {
                this.g.printLine(this.c.getUser(chan, "test").getRoom(), "test");
            }
        } else if (command.equals("switchchan")) {
            this.g.switchToChannel(parameter);
        } else if (command.equals("settestuser")) {
            String[] split = parameter.split(" ");
            this.createTestUser(split[0], split[1]);
        } else if (command.equals("getemoteset")) {
            this.g.printLine(this.g.emoticons.getEmoticonsBySet(parameter).toString());
        } else if (command.equals("testcolor")) {
            this.testUser.setColor(parameter);
        } else if (command.equals("testupdatenotification")) {
            this.g.setUpdateAvailable("[test]", null);
        } else if (command.equals("testnewevent")) {
            this.g.setSystemEventCount(Integer.valueOf(parameter));
        } else if (command.equals("addevent")) {
            String[] split = parameter.split(" ", 3);
            EventLog.addSystemEvent(split[0], split[1], split[2]);
        } else if (command.equals("addevent2")) {
            String[] split = parameter.split(" ", 3);
            new Thread(() -> EventLog.addSystemEvent(split[0], split[1], split[2])).start();
        } else if (command.equals("removechan")) {
            this.g.removeChannel(parameter);
        } else if (command.equals("tt")) {
            String[] split = parameter.split(" ", 3);
            int repeats = Integer.parseInt(split[0]);
            int delay = Integer.parseInt(split[1]);
            String c = split[2];
            TestTimer.testTimer(this, room, c, repeats, delay);
        } else if (command.equals("bantest")) {
            int duration = -1;
            String reason = "";
            if (parameter != null) {
                String[] split = parameter.split(" ", 2);
                duration = Integer.parseInt(split[0]);
                if (split.length > 1) {
                    reason = split[1];
                }
            }
            this.g.userBanned(this.testUser, duration, reason, null);
        } else if (command.equals("ban")) {
            String[] split = parameter.split(" ", 3);
            int duration = -1;
            if (split.length > 1) {
                duration = Integer.parseInt(split[1]);
            }
            String reason = "";
            if (split.length > 2) {
                reason = split[2];
            }
            this.g.userBanned(this.c.getUser(channel, split[0]), duration, reason, null);
        } else if (command.equals("userjoined")) {
            this.c.userJoined("#test", parameter);
        } else if (command.equals("echomessage")) {
            String[] split = parameter.split(" ");
        } else if (command.equals("loadffz")) {
            this.frankerFaceZ.requestEmotes(parameter, true);
        } else if (command.equals("testtw")) {
            this.g.showTokenWarning();
        } else if (command.equals("tsonline")) {
            this.testStreamInfo.set(parameter, new StreamCategory(null, "Game"), 123, -1L, StreamInfo.StreamType.LIVE);
            this.g.addStreamInfo(this.testStreamInfo);
        } else if (command.equals("tsoffline")) {
            this.testStreamInfo.setOffline();
            this.g.addStreamInfo(this.testStreamInfo);
        } else if (command.equals("testspam")) {
            this.g.printLine("test" + this.spamProtection.getAllowance() + this.spamProtection.tryMessage());
        } else if (command.equals("spamprotectioninfo")) {
            this.g.printSystem("Spam Protection: " + this.spamProtection);
        } else if (command.equals("tsv")) {
            this.testStreamInfo.set("Title", new StreamCategory(null, "Game"), Integer.parseInt(parameter), -1L, StreamInfo.StreamType.LIVE);
        } else if (command.equals("tsvs")) {
            System.out.println(this.testStreamInfo.getViewerStats(true));
        } else if (command.equals("tsaoff")) {
            StreamInfo info = this.api.getStreamInfo(this.g.getActiveStream(), null);
            info.setOffline();
        } else if (command.equals("tsaon")) {
            StreamInfo info = this.api.getStreamInfo(this.g.getActiveStream(), null);
            info.set("Test", new StreamCategory(null, "Game"), 12, System.currentTimeMillis() - 1000L, StreamInfo.StreamType.LIVE);
        } else if (command.equals("tss")) {
            StreamInfo info = this.api.getStreamInfo(parameter, null);
            info.set("Test", new StreamCategory(null, "Game"), 12, System.currentTimeMillis() - 1000L, StreamInfo.StreamType.LIVE);
        } else if (command.equals("tston")) {
            int viewers = 12;
            try {
                viewers = Integer.parseInt(parameter);
            }
            catch (NumberFormatException duration) {
                // empty catch block
            }
            StreamInfo info = this.api.getStreamInfo("tduva", null);
            info.set("Test 2", new StreamCategory(null, "Game"), viewers, System.currentTimeMillis() - 1000L, StreamInfo.StreamType.LIVE);
        } else if (command.equals("newstatus")) {
            this.g.setChannelNewStatus(parameter, "");
        } else if (command.equals("refreshstreams")) {
            this.api.manualRefreshStreams();
        } else if (command.equals("usericonsinfo")) {
            this.usericonManager.debug();
        } else if (!command.equals("userlisttest")) {
            if (command.equals("requestfollowers")) {
                this.api.getFollowers(parameter, false);
            } else if (command.equals("simulate2")) {
                this.c.simulate(parameter);
            } else if (command.equals("simulate")) {
                if (parameter.equals("bits")) {
                    parameter = "bits " + this.g.emoticons.getCheerEmotesString(null);
                } else if (parameter.equals("bitslocal")) {
                    parameter = "bits " + this.g.emoticons.getCheerEmotesString(Helper.toStream(channel));
                } else if (parameter.startsWith("bits ")) {
                    parameter = "bits " + parameter.substring("bits ".length());
                } else if (parameter.startsWith("emoji ")) {
                    int num = Integer.parseInt(parameter.substring("emoji ".length()));
                    StringBuilder b = new StringBuilder();
                    for (Emoticon emote : this.g.emoticons.getEmoji()) {
                        b.append(emote.code);
                        if (--num != 0) continue;
                        break;
                    }
                    parameter = "message " + b.toString();
                } else {
                    if (parameter.startsWith("subbomb")) {
                        String gifter = parameter.equals("subbomb") ? "Gifter" : "Gifter2";
                        String secondParam = parameter.substring("subbomb".length());
                        int amount = 10;
                        try {
                            amount = Integer.parseInt(secondParam.trim());
                        }
                        catch (NumberFormatException emote) {
                            // empty catch block
                        }
                        for (int i = 0; i < amount; ++i) {
                            String raw = RawMessageTest.simulateIRC(channel, "subbomb recipient" + i, gifter);
                            this.c.simulate(raw);
                        }
                        return;
                    }
                    if (parameter.startsWith("file ")) {
                        RawMessageTest.simulateFile(this.c, parameter.substring("file ".length()));
                    }
                }
                String raw = RawMessageTest.simulateIRC(channel, parameter, this.c.getUsername());
                if (raw != null) {
                    this.c.simulate(raw);
                }
            } else if (command.equals("c1")) {
                this.sendMessage(channel, '\u0001' + parameter);
            } else if (command.equals("gc")) {
                Runtime.getRuntime().gc();
                LogUtil.logMemoryUsage();
            } else if (command.equals("wsconnect")) {
                this.frankerFaceZ.connectWs();
            } else if (command.equals("wsdisconnect")) {
                this.frankerFaceZ.disconnectWs();
            } else if (command.equals("eventsubreconnect")) {
                this.eventSub.reconnect();
            } else if (command.equals("simulateeventsub")) {
                this.eventSub.simulate(parameter);
            } else if (command.equals("es_s")) {
                this.api.getEventSubSubs(s -> {
                    LOGGER.info(s.total + " " + s.getCountBySession());
                    LOGGER.info(s.toString());
                });
            } else if (command.equals("es_t")) {
                LOGGER.info(this.eventSub.getTopics());
            } else if (command.equals("es_lt")) {
                this.eventSub.logActiveTopics();
            } else if (command.equals("repeat")) {
                String[] split = parameter.split(" ", 2);
                int count = Integer.parseInt(split[0]);
                for (int i = 0; i < count; ++i) {
                }
            } else if (command.equals("loadsoferrors")) {
                for (int i = 0; i < 10000; ++i) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Helper.unhandledException();
                        }
                    });
                }
            } else if (command.equals("error")) {
                Helper.unhandledException();
            } else if (command.equals("getuserid")) {
                if (parameter == null) {
                    this.g.printSystem("Parameter required.");
                } else {
                    this.api.getUserIdAsap(r -> {
                        String result = r.getData().toString();
                        if (r.hasError()) {
                            result = result + " Error: " + r.getError();
                        }
                        this.g.printSystem(result);
                    }, parameter.split("[ ,]"));
                }
            } else if (command.equals("getuserids2")) {
                this.api.getUserIDsTest2(parameter);
            } else if (command.equals("getuserids3")) {
                this.api.getUserIDsTest3(parameter);
            } else if (command.equals("clearoldsetups")) {
                Stuff.init();
                Stuff.clearOldSetups();
            } else if (command.equals("-")) {
                this.g.printSystem(Debugging.command(parameter));
            } else if (command.equals("connection")) {
                this.c.debugConnection();
            } else if (command.equals("clearoldcachefiles")) {
                ImageCache.deleteExpiredFiles();
            } else if (command.equals("sha1")) {
                this.g.printSystem(ImageCache.sha1(parameter));
            } else if (command.equals("letstakeabreak")) {
                try {
                    Thread.sleep(Integer.parseInt(parameter));
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(TwitchClient.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                if (command.equals("infiniteloop")) {
                    while (true) {
                        // Infinite loop
                    }
                }
                if (command.equals("threadinfo")) {
                    LogUtil.logThreadInfo();
                } else if (command.equals("addusers")) {
                    String[] split = parameter.split(" ", 2);
                    int amount = Integer.parseInt(split[0]);
                    int messageAmount = Integer.parseInt(split[1]);
                    for (int i = 0; i < amount; ++i) {
                        User user = this.c.getUser(channel, "user" + i);
                        for (int m = 0; m < messageAmount; ++m) {
                            user.addMessage("abc" + i + " " + m, false, "abc id" + i + " " + m);
                        }
                    }
                } else if (command.equals("testr")) {
                    this.api.test();
                } else if (command.equals("joinlink")) {
                    MsgTags tags = MsgTags.createLinks(new MsgTags.Link(MsgTags.Link.Type.JOIN, Helper.toChannel("twitch"), "Join"));
                    this.g.printInfo(this.c.getRoomByChannel(channel), "Join link:", tags);
                }
            }
        }
    }

    public void anonCustomCommand(Room room, String text, Parameters parameters) {
        CustomCommand command = CustomCommand.parse(text);
        if (parameters == null) {
            parameters = Parameters.create(null);
        }
        this.anonCustomCommand(room, command, parameters);
    }

    public void anonCustomCommand(Room room, CustomCommand command, Parameters parameters) {
        if (command.hasError()) {
            this.g.printLine("Parse error: " + command.getSingleLineError());
            return;
        }
        if (room == null) {
            this.g.printLine("Custom command: Not on a channel");
            return;
        }
        this.customCommands.command(command, parameters, room, result -> {
            if (result == null) {
                this.g.printLine("Custom command: Insufficient parameters/data");
            } else if (result.isEmpty()) {
                this.g.printLine("Custom command: No action specified");
            } else {
                this.textInput(room, (String)result, parameters);
            }
        });
    }

    public void customCommandLaunch(String commandAndParameters) {
        if (StringUtil.isNullOrEmpty(commandAndParameters)) {
            return;
        }
        LOGGER.info("Running launch command: " + commandAndParameters);
        String[] split = commandAndParameters.split(" ", 2);
        String commandName = split[0];
        Parameters p = split.length == 2 ? Parameters.create(split[1]) : Parameters.create(null);
        p.put("-cc", "true");
        SwingUtilities.invokeLater(() -> this.customCommand(this.g.getActiveRoom(), commandName, p));
    }

    public void customCommand(Room room, String command, Parameters parameters) {
        if (room == null) {
            this.g.printLine("Custom command: Not on a channel");
            return;
        }
        if (!this.customCommands.containsCommand(command, room)) {
            this.g.printLine("Custom command not found: " + command);
            return;
        }
        if (CustomCommands.getCustomCommandCount(parameters) > 2) {
            this.g.printLine(String.format("Stopped executing '%s' (too many nested Custom Commands)", command));
            return;
        }
        this.customCommands.command(command, parameters, room, result -> {
            if (result == null) {
                this.g.printLine("Custom command '" + command + "': Insufficient parameters/data");
            } else if (result.isEmpty()) {
                this.g.printLine("Custom command '" + command + "': No action specified");
            } else {
                this.textInput(room, (String)result, parameters);
            }
        });
    }

    public void commandSetIgnored(String parameter, String type, boolean ignore) {
        if (parameter != null && !parameter.isEmpty()) {
            String[] split = parameter.split(" ");
            String name = StringUtil.toLowerCase(split[0]);
            String message = "";
            ArrayList<String> setting = new ArrayList<String>();
            if (type == null || type.equals("chat")) {
                message = "in chat";
                setting.add("ignoredUsers");
            }
            if (type == null || type.equals("whisper")) {
                message = StringUtil.append(message, "/", "from whispering you");
                setting.add("ignoredUsersWhisper");
            }
            boolean changed = false;
            for (String s : setting) {
                if (ignore) {
                    if (!this.settings.setAdd(s, name)) continue;
                    changed = true;
                    continue;
                }
                if (!this.settings.listRemove(s, name)) continue;
                changed = true;
            }
            if (changed) {
                if (ignore) {
                    this.g.printSystem(String.format("Ignore: '%s' now ignored %s", name, message));
                } else {
                    this.g.printSystem(String.format("Ignore: '%s' no longer ignored %s", name, message));
                }
            } else if (ignore) {
                this.g.printSystem(String.format("Ignore: '%s' already ignored %s", name, message));
            } else {
                this.g.printSystem(String.format("Ignore: '%s' not ignored %s", name, message));
            }
        } else {
            this.g.printSystem("Ignore: Invalid name");
        }
    }

    private void commandServer(String parameter) {
        if (parameter == null) {
            this.g.printLine("Usage: /server <address>[:port]");
            return;
        }
        String[] split = parameter.split(":");
        if (split.length == 1) {
            this.prepareConnectionAnyChannel(split[0], this.getPorts());
        } else if (split.length == 2) {
            this.prepareConnectionAnyChannel(split[0], split[1]);
        } else {
            this.g.printLine("Invalid format. Usage: /server <address>[:port]");
        }
    }

    public void commandJoinChannel(String channelString) {
        String[] channelList;
        if (channelString == null) {
            channelString = "";
        }
        if ((channelList = Helper.parseChannels(channelString)).length == 0) {
            this.g.printLine("No valid channel specified.");
        } else {
            this.c.joinChannels(new LinkedHashSet<String>(Arrays.asList(channelList)));
        }
    }

    private void commandPartChannel(String channel) {
        if (channel == null || channel.isEmpty()) {
            this.g.printLine("No channel to leave.");
        } else {
            this.closeChannel(channel);
        }
    }

    private void commandRejoinChannel(String channel) {
        if (channel == null || channel.isEmpty()) {
            this.g.printLine("No channel to rejoin.");
        } else {
            this.c.rejoinChannel(channel);
        }
    }

    private void commandActionMessage(String channel, String message) {
        if (message != null) {
            this.sendActionMessage(channel, message);
        } else {
            this.g.printLine("Usage: /me <message>");
        }
    }

    public void sendActionMessage(String channel, String message) {
        if (this.c.onChannel(channel, true)) {
            if (this.c.sendSpamProtectedMessage(channel, message, true)) {
                this.g.printMessage(this.c.localUserJoined(channel), message, true);
            } else {
                this.g.printLine("# Action Message not sent to prevent ban: " + message);
            }
        }
    }

    private void commandCustomMessage(String parameter) {
        String[] split;
        if (parameter != null && !parameter.isEmpty() && (split = parameter.split(" ", 2)).length == 2) {
            String to = split[0];
            String message = split[1];
            this.c.sendSpamProtectedMessage(to, message, false);
            this.g.printLine(String.format("-> %s: %s", to, message));
            return;
        }
        this.g.printSystem("Invalid parameters.");
    }

    public void commandReconnect() {
        if (this.c.disconnect()) {
            this.c.reconnect();
        } else {
            this.g.printLine("Could not reconnect.");
        }
    }

    public void updateLogin() {
        String username = this.settings.getString("username");
        String token = this.settings.getString("token");
        this.c.setLogin(username, "oauth:" + token);
        this.eventSub.tokenUpdated();
    }

    private void commandCustomCompletion(String parameter) {
        String usage = "Usage: /customCompletion <add/set/remove> <item> <value>";
        if (parameter == null) {
            this.g.printLine(usage);
            return;
        }
        String[] split = parameter.split(" ", 3);
        if (split.length < 2) {
            this.g.printLine(usage);
        } else {
            String type = split[0];
            String key = split[1];
            if (type.equals("add") || type.equals("set")) {
                if (split.length < 3) {
                    this.g.printLine("Invalid number of parameters for adding completion item.");
                } else {
                    String value = split[2];
                    if (!type.equals("set") && this.settings.mapGet("customCompletion", key) != null) {
                        this.g.printLine("Completion item '" + key + "' already exists, use '/customCompletion set <key> <value>' to overwrite");
                    } else {
                        this.settings.mapPut("customCompletion", key, value);
                        this.g.printLine("Set custom completion '" + key + "' to '" + value + "'");
                    }
                }
            } else if (type.equals("remove")) {
                this.settings.mapRemove("customCompletion", key);
                this.g.printLine("Removed '" + key + "' from custom completion");
            } else {
                this.g.printLine(usage);
            }
        }
    }

    public void commandFollow(String channel, String parameter) {
        this.g.printSystem("Following/unfollowing has been removed from the Twitch API");
    }

    public void commandUnfollow(String channel, String parameter) {
        this.g.printSystem("Following/unfollowing has been removed from the Twitch API");
    }

    public void commandAddStreamHighlight(Room room, String parameter) {
        this.g.printLine(room, this.streamHighlights.addHighlight(room.getOwnerChannel(), parameter, null));
    }

    public void commandOpenStreamHighlights(Room room) {
        this.g.printLine(room, this.streamHighlights.openFile());
    }

    public void modCommandAddStreamHighlight(User user, String message, MsgTags tags) {
        String result = this.streamHighlights.modCommand(user, message, tags);
        if (result != null) {
            result = user.getDisplayNick() + ": " + result;
            if (this.settings.getBoolean("streamHighlightChannelRespond")) {
                this.sendMessage(user.getChannel(), result);
            } else {
                this.g.printLine(user.getRoom(), result);
            }
        }
    }

    public void commandAddStreamMarker(Room room, String description) {
        this.api.createStreamMarker(room.getStream(), description, error -> {
            String info = StringUtil.aEmptyb(description, "no description", "'%s'");
            if (error == null) {
                this.g.printLine("Stream marker created (" + info + ")");
            } else {
                this.g.printLine("Failed to create stream marker (" + info + "): " + error);
            }
        });
    }

    private void commandRefresh(String channel, String parameter) {
        if (!Helper.isRegularChannel(channel)) {
            channel = null;
        }
        if (parameter == null) {
            this.g.printLine("Usage: /refresh <type> (see help)");
        } else if (parameter.equals("emoticons")) {
            this.g.printLine("Refreshing emoticons.. (this can take a few seconds)");
            this.refreshRequests.add("emoticons");
            this.api.refreshEmotes();
        } else if (parameter.equals("bits")) {
            this.g.printLine("Refreshing bits..");
            this.refreshRequests.add("bits");
            this.api.getCheers(channel, true);
        } else if (parameter.equals("badges")) {
            if (!Helper.isValidChannel(channel)) {
                this.g.printLine("Must be on a channel to use this.");
            } else {
                this.g.printLine("Refreshing badges for " + channel + "..");
                this.refreshRequests.add("badges");
                this.api.getGlobalBadges(true);
                this.api.getRoomBadges(Helper.toStream(channel), true);
                OtherBadges.requestBadges(r -> this.usericonManager.setThirdPartyIcons(r), true);
            }
        } else if (parameter.equals("ffz")) {
            if (channel == null || channel.isEmpty()) {
                this.g.printLine("Must be on a channel to use this.");
            } else {
                this.g.printLine("Refreshing FFZ emotes for " + channel + "..");
                this.refreshRequests.add("ffz");
                this.frankerFaceZ.requestEmotes(channel, true);
            }
        } else if (parameter.equals("ffzglobal")) {
            this.g.printLine("Refreshing global FFZ emotes..");
            this.refreshRequests.add("ffzglobal");
            this.frankerFaceZ.requestGlobalEmotes(true);
        } else if (parameter.equals("bttvemotes")) {
            this.g.printLine("Refreshing BTTV emotes..");
            this.refreshRequests.add("bttvemotes");
            this.bttvEmotes.requestEmotes("$global$", true);
            this.bttvEmotes.requestEmotes(channel, true);
        } else if (parameter.equals("7tv")) {
            this.g.printSystem("Refreshing 7TV emotes..");
            this.refreshRequests.add("seventv");
            if (!StringUtil.isNullOrEmpty(channel)) {
                this.sevenTV.requestEmotes(channel, true);
            }
            this.sevenTV.requestEmotes(null, true);
        } else {
            this.g.printLine("Usage: /refresh <type> (invalid type, see help)");
        }
    }

    public User getSpecialUser() {
        return this.c.getSpecialUser();
    }

    public Set<String> getEmotesetsByChannel(String channel) {
        return this.emotesetManager.getEmotesetsByChannel(channel);
    }

    private void commandFFZ(String channel) {
        Set<Emoticon> output;
        StringBuilder b = new StringBuilder();
        if (channel == null) {
            b.append("Global FFZ emotes: ");
            output = Emoticons.filterByType(this.g.emoticons.getGlobalTwitchEmotes(), Emoticon.Type.FFZ);
        } else {
            b.append("This channel's FFZ emotes: ");
            Set<Emoticon> emotes = this.g.emoticons.getEmoticonsByStream(Helper.toStream(channel));
            output = Emoticons.filterByType(emotes, Emoticon.Type.FFZ);
        }
        if (output.isEmpty()) {
            b.append("None found.");
        }
        String sep = "";
        for (Emoticon emote : output) {
            b.append(sep);
            b.append(emote.code);
            sep = ", ";
        }
        this.g.printLine(this.roomManager.getRoom(channel), b.toString());
    }

    private void commandFFZFollowing(String channel, String parameter) {
        String stream = Helper.toStream(channel);
        if (stream == null) {
            this.g.printSystem("FFZ: No valid channel.");
        } else if (!this.c.isRegistered()) {
            this.g.printSystem("FFZ: You have to be connected to use this command.");
        } else {
            if (!stream.equals(this.c.getUsername())) {
                this.g.printSystem("FFZ: You may only be able to run this command on your own channel.");
            }
            parameter = parameter.substring("following".length()).trim();
            this.frankerFaceZ.setFollowing(this.c.getUsername(), stream, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String line) {
        if (this.shuttingDown) {
            return;
        }
        List<String> list = this.cachedDebugMessages;
        synchronized (list) {
            if (this.g == null) {
                this.cachedDebugMessages.add("[" + DateTime.currentTimeExact() + "] " + line);
            } else {
                if (!this.cachedDebugMessages.isEmpty()) {
                    this.g.printDebug("[Start of cached messages]");
                    for (String cachedLine : this.cachedDebugMessages) {
                        this.g.printDebug(cachedLine);
                    }
                    this.g.printDebug("[End of cached messages]");
                    this.cachedDebugMessages.clear();
                }
                this.g.printDebug(line);
            }
        }
    }

    public void debugFFZ(String line) {
        if (this.shuttingDown || this.g == null) {
            return;
        }
        this.g.printDebugFFZ(line);
    }

    public void debugPubSub(String line) {
        if (this.shuttingDown || this.g == null) {
            return;
        }
        this.g.printDebugPubSub(line);
    }

    public void debugEventSub(String line) {
        if (this.shuttingDown || this.g == null) {
            return;
        }
        this.g.printDebugEventSub(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void warning(String line) {
        if (this.shuttingDown) {
            return;
        }
        List<String> list = this.cachedWarningMessages;
        synchronized (list) {
            if (this.g == null) {
                this.cachedWarningMessages.add(line);
            } else {
                if (!this.cachedWarningMessages.isEmpty()) {
                    for (String cachedLine : this.cachedWarningMessages) {
                        this.g.printLine(cachedLine);
                    }
                    this.cachedWarningMessages.clear();
                }
                if (line != null) {
                    this.g.printLine(line);
                }
            }
        }
    }

    private void handleModAction(ModActionPayload data) {
        if (data.stream != null) {
            String targetUsername;
            String warnedUsername;
            String unbannedUsername;
            String channel = Helper.toChannel(data.stream);
            this.g.printModerationAction(data, data.created_by.equals(this.c.getUsername()));
            this.chatLog.modAction(data);
            boolean addedTargetUserInfo = false;
            User modUser = this.c.getUser(channel, data.created_by);
            modUser.addModAction(data);
            this.g.updateUserinfo(modUser);
            String bannedUsername = ModLogInfo.getBannedUsername(data);
            if (bannedUsername != null) {
                User bannedUser = this.c.getUser(channel, bannedUsername);
                bannedUser.addBanInfo(data);
                this.g.updateUserinfo(bannedUser);
                addedTargetUserInfo = true;
            }
            if ((unbannedUsername = ModLogInfo.getUnbannedUsername(data)) != null) {
                User unbannedUser = this.c.getUser(channel, unbannedUsername);
                int type = User.UnbanMessage.getType(data.moderation_action);
                unbannedUser.addUnban(type, data.created_by, data.getSourceChannel());
                this.g.updateUserinfo(unbannedUser);
                addedTargetUserInfo = true;
            }
            if (data.moderation_action.equals("warn") && (warnedUsername = ModLogInfo.getTargetUsername(data)) != null) {
                User warnedUser = this.c.getUser(channel, warnedUsername);
                String reason = ((ModActionPayload.Warn)data.action).getReason();
                warnedUser.addWarning(reason, data.created_by);
                this.g.updateUserinfo(warnedUser);
                addedTargetUserInfo = true;
            }
            if (!addedTargetUserInfo && (targetUsername = ModLogInfo.getTargetUsername(data)) != null) {
                User targetUser = this.c.getUser(channel, targetUsername);
                targetUser.addModAction(data);
                this.g.updateUserinfo(targetUser);
            }
        }
    }

    private void addTwitchApiResultListeners() {
        this.api.subscribe(ResultManager.Type.SHIELD_MODE_RESULT, (stream, enabled) -> {
            String channel = Helper.toChannel(stream);
            this.getChannelState(channel).setShieldMode(enabled);
        });
    }

    public void startWebserver() {
        if (this.webserver == null) {
            this.webserver = new Webserver(new WebserverListener());
            new Thread(this.webserver).start();
        } else {
            LOGGER.warning("Webserver already running");
            this.g.webserverStarted();
        }
    }

    public void stopWebserver() {
        if (this.webserver != null) {
            this.webserver.stop();
        } else {
            LOGGER.info("No webserver running, can't stop it");
        }
    }

    public void updateStreamChatLogos(Collection<String> joiningChannels) {
        ArrayList<String> logins = new ArrayList<String>();
        for (String channel : joiningChannels) {
            if (!Helper.isRegularChannel(channel)) continue;
            logins.add(Helper.toStream(channel));
        }
        this.api.getCachedUserInfo(logins, result -> {
            for (Map.Entry entry : result.entrySet()) {
                UserInfo info = (UserInfo)entry.getValue();
                if (info == null || StringUtil.isNullOrEmpty(info.profileImageUrl)) continue;
                this.usericonManager.addChannelLogoUrl(Helper.toChannel(info.login), info.profileImageUrl);
            }
        });
    }

    public void resolveSourceData(User user, MsgTags tags, Consumer<MsgTags> resultListener) {
        if (!tags.isSharedMessage()) {
            resultListener.accept(tags);
        } else {
            String sourceRoomId = tags.get("source-room-id");
            this.api.getCachedUserInfoById(Arrays.asList(sourceRoomId), requestResult -> {
                UserInfo info = (UserInfo)requestResult.get(sourceRoomId);
                if (info != null) {
                    if (!StringUtil.isNullOrEmpty(info.profileImageUrl)) {
                        this.usericonManager.addChannelLogoUrl(Helper.toChannel(info.login), info.profileImageUrl);
                    }
                    resultListener.accept(MsgTags.addTag(tags, "chatty-source-channel", Helper.toChannel(info.login)));
                } else {
                    resultListener.accept(tags);
                }
            });
        }
    }

    private void logAllViewerstats() {
        for (String channel : this.c.getOpenChannels()) {
            this.logViewerstats(channel);
        }
    }

    private void logViewerstats(String channel) {
        if (Helper.isRegularChannelStrict(channel)) {
            StreamInfo.ViewerStats stats = this.api.getStreamInfo(Helper.toStream(channel), null).getViewerStats(true);
            this.chatLog.viewerstats(channel, stats);
        }
    }

    public void testHotkey() {
        this.g.showTokenWarning();
    }

    public void runCommercial(String stream, int length) {
        String channel = Helper.toChannel(stream);
        if (stream == null || stream.isEmpty()) {
            this.commercialResult(stream, "Can't run commercial, not on a channel.", TwitchApi.RequestResultCode.FAILED);
        } else if (stream.equals(this.settings.getString("username"))) {
            if (this.isChannelOpen(channel)) {
                this.g.printLine(this.roomManager.getRoom(channel), Language.getString("chat.twitchcommands.commercial", length));
            } else {
                this.g.printLine(Language.getString("chat.twitchcommands.commercial", length) + " (" + stream + ")");
            }
            this.api.runCommercial(stream, length);
        } else if (this.isChannelOpen(channel)) {
            this.c.command(channel, "commercial", String.valueOf(length), null);
        } else {
            this.commercialResult(stream, "Can't run commercial, not in the channel.", TwitchApi.RequestResultCode.FAILED);
        }
    }

    private void commercialResult(String stream, String text, TwitchApi.RequestResultCode result) {
        String channel = "#" + stream;
        if (this.isChannelOpen(channel)) {
            this.g.printLine(this.roomManager.getRoom(channel), text);
        } else {
            this.g.printLine(text + " (" + stream + ")");
        }
        this.g.commercialResult(stream, text, result);
    }

    public void requestChannelEmotes(String channel) {
        if (this.settings.getBoolean("ffz")) {
            this.frankerFaceZ.requestEmotes(channel, false);
            this.frankerFaceZ.autoUpdateFeatureFridayEmotes();
        }
        if (this.settings.getBoolean("bttvEmotes")) {
            this.bttvEmotes.requestEmotes(channel, false);
        }
        if (this.settings.getBoolean("seventv")) {
            this.sevenTV.requestEmotes(channel, false);
            this.sevenTV.requestEmotes(null, false);
        }
    }

    public void requestChannelHistory(String stream) {
        if (!this.historyManager.isEnabled()) {
            return;
        }
        if (this.historyManager.isChannelExcluded(stream)) {
            return;
        }
        String channelName = Helper.toChannel(stream);
        Room room = Room.createRegular(channelName);
        this.g.printSystem(room, "### Pulling information from history service. ###");
        this.historyManager.getHistoricChatMessages(room, history -> {
            for (int i = 0; i < history.size(); ++i) {
                HistoryMessage currentMsg = (HistoryMessage)history.get(i);
                User user = this.c.getUser(channelName, currentMsg.userName);
                UserTagsUtil.updateUserFromTags(user, currentMsg.tags);
                this.g.printMessage(user, currentMsg.message, currentMsg.action, currentMsg.tags);
            }
            this.g.printSystem(room, "### Finished with history logs. ###");
            this.historyManager.setMessageSeen(stream);
            for (QueuedMessage msg : this.historyManager.getQueuedMessages(stream)) {
                this.g.printMessage(msg.user, msg.text, msg.action, msg.tags);
            }
        });
    }

    public void setLinesPerSeconds(String value) {
        this.spamProtection.setLinesPerSeconds(value);
        this.c.setSpamProtection(value);
    }

    public void exit() {
        this.shuttingDown = true;
        this.saveSettings(true, false);
        TextToSpeech.shutdownIfNecessary();
        this.logAllViewerstats();
        Pronouns.instance().saveCache();
        this.c.disconnect();
        this.frankerFaceZ.disconnectWs();
        this.eventSub.disconnect();
        this.g.cleanUp();
        this.chatLog.close();
        System.exit(0);
    }

    public List<FileManager.SaveResult> saveSettings(boolean onExit, boolean force) {
        if (onExit) {
            if (this.settingsAlreadySavedOnExit) {
                return null;
            }
            this.settingsAlreadySavedOnExit = true;
        }
        if (this.g != null && this.g.guiCreated) {
            GuiUtil.edtAndWait(() -> this.g.saveWindowStates(), "Save Window States");
        }
        if (force || !this.settings.getBoolean("dontSaveSettings")) {
            LOGGER.info("Saving settings..");
            System.out.println("Saving settings..");
            return this.settings.saveSettingsToJson(force);
        }
        LOGGER.info("Not saving settings (disabled)");
        return null;
    }

    public List<FileManager.SaveResult> manualBackup() {
        return this.settingsManager.fileManager.manualBackup();
    }

    public ChannelState getChannelState(String channel) {
        return this.c.getChannelState(channel);
    }

    public Collection<String> getOpenChannels() {
        return this.c.getOpenChannels();
    }

    public Collection<Room> getOpenRooms() {
        return this.c.getOpenRooms();
    }

    public List<UserRoom> getOpenUserRooms(User user) {
        ArrayList<UserRoom> result = new ArrayList<UserRoom>();
        Collection<Room> rooms = this.getOpenRooms();
        for (Room room : rooms) {
            User roomUser = this.c.getExistingUser(room.getChannel(), user.getName());
            result.add(new UserRoom(room, roomUser));
        }
        return result;
    }

    public String getSecondaryConnectionsStatus() {
        return String.format("%s%s", this.frankerFaceZ.isWsConnected() ? "F" : "", this.eventSub.isConnected() ? "M" : "");
    }

    private class IrcLogger {
        private final Logger IRC_LOGGER = Logger.getLogger(IrcLogger.class.getName());

        IrcLogger() {
            this.IRC_LOGGER.setUseParentHandlers(false);
            FileHandler handler = Logging.getIrcFileHandler();
            if (handler != null) {
                this.IRC_LOGGER.addHandler(handler);
            }
        }

        public void onRawReceived(String text) {
            if (TwitchClient.this.settings.getBoolean("debugLogIrc")) {
                TwitchClient.this.g.printDebugIrc("--> " + text);
            }
            if (TwitchClient.this.settings.getBoolean("debugLogIrcFile")) {
                this.IRC_LOGGER.info("--> " + text);
            }
        }

        public void onRawSent(String text) {
            if (TwitchClient.this.settings.getBoolean("debugLogIrc")) {
                TwitchClient.this.g.printDebugIrc("<-- " + text);
            }
            if (TwitchClient.this.settings.getBoolean("debugLogIrcFile")) {
                this.IRC_LOGGER.info("<-- " + text);
            }
        }
    }

    private class TwitchApiResults
    implements TwitchApiResultListener {
        private TwitchApiResults() {
        }

        @Override
        public void receivedEmoticons(EmoticonUpdate update) {
            TwitchClient.this.g.updateEmoticons(update);
            if (TwitchClient.this.refreshRequests.contains("emoticons")) {
                TwitchClient.this.g.printLine("Emoticons list updated.");
                TwitchClient.this.refreshRequests.remove("emoticons");
            }
        }

        @Override
        public void tokenVerified(String token, TokenInfo tokenInfo) {
            TwitchClient.this.g.tokenVerified(token, tokenInfo);
        }

        @Override
        public void tokenRevoked(String error) {
        }

        @Override
        public void runCommercialResult(String stream, String text, TwitchApi.RequestResultCode result) {
            TwitchClient.this.commercialResult(stream, text, result);
        }

        @Override
        public void receivedChannelInfo(String stream, ChannelInfo info, TwitchApi.RequestResultCode result) {
        }

        @Override
        public void receivedChannelStatus(ChannelStatus status, TwitchApi.RequestResultCode resultCode) {
            TwitchClient.this.g.channelStatusReceived(status, resultCode);
        }

        @Override
        public void putChannelInfoResult(TwitchApi.RequestResultCode result, String error) {
            TwitchClient.this.g.putChannelInfoResult(result, error);
        }

        @Override
        public void accessDenied() {
            TwitchClient.this.api.checkToken();
        }

        @Override
        public void receivedUsericons(List<Usericon> icons) {
            TwitchClient.this.usericonManager.addDefaultIcons(icons);
            TwitchClient.this.g.updateModButtons(null);
            if (TwitchClient.this.refreshRequests.contains("badges2")) {
                TwitchClient.this.g.printLine("Badges2 updated.");
                TwitchClient.this.refreshRequests.remove("badges2");
            }
            if (TwitchClient.this.refreshRequests.contains("badges")) {
                TwitchClient.this.g.printLine("Badges updated.");
                TwitchClient.this.refreshRequests.remove("badges");
            }
        }

        @Override
        public void receivedFollowers(FollowerInfo followerInfo) {
            TwitchClient.this.g.setFollowerInfo(followerInfo);
            this.followerInfoNames(followerInfo);
            this.receivedFollowerOrSubscriberCount(followerInfo);
        }

        private void receivedFollowerOrSubscriberCount(FollowerInfo followerInfo) {
            if (followerInfo.requestError) {
                return;
            }
            StreamInfo streamInfo = TwitchClient.this.api.getCachedStreamInfo(followerInfo.stream);
            if (streamInfo != null) {
                boolean changed = false;
                if (followerInfo.type == Follower.Type.SUBSCRIBER) {
                    changed = streamInfo.setSubscriberCount(followerInfo.total);
                } else if (followerInfo.type == Follower.Type.FOLLOWER) {
                    changed = streamInfo.setFollowerCount(followerInfo.total);
                }
                if (changed && streamInfo.isValid()) {
                    TwitchClient.this.streamStatusWriter.streamStatus(streamInfo);
                }
            }
        }

        @Override
        public void newFollowers(FollowerInfo followerInfo) {
            TwitchClient.this.g.newFollowers(followerInfo);
        }

        @Override
        public void receivedSubscribers(FollowerInfo info) {
            TwitchClient.this.g.setSubscriberInfo(info);
            this.followerInfoNames(info);
            this.receivedFollowerOrSubscriberCount(info);
        }

        private void followerInfoNames(FollowerInfo info) {
        }

        @Override
        public void receivedFollower(String stream, String username, TwitchApi.RequestResultCode result, Follower follower) {
            TwitchClient.this.g.setFollowInfo(stream, username, result, follower);
        }

        @Override
        public void receivedDisplayName(String name, String displayName) {
        }

        @Override
        public void receivedServer(String channel, String server) {
            LOGGER.info("Received server info: " + channel + "/" + server);
            if (TwitchClient.this.fixServer && server != null) {
                String s = Helper.getServer(server);
                int p = Helper.getPort(server);
                TwitchClient.this.c.disconnect();
                TwitchClient.this.prepareConnectionAnyChannel(s, String.valueOf(p));
            }
        }

        @Override
        public void followResult(String message) {
            TwitchClient.this.g.printSystem(message);
        }

        @Override
        public void autoModResult(TwitchApi.AutoModAction action, String msgId, TwitchApi.AutoModActionResult result) {
            TwitchClient.this.g.autoModRequestResult(action, msgId, result);
            TwitchClient.this.autoModCommandHelper.requestResult(action, msgId, result);
        }

        @Override
        public void receivedCheerEmoticons(Set<CheerEmoticon> emoticons) {
            if (TwitchClient.this.refreshRequests.contains("bits")) {
                TwitchClient.this.g.printLine("Bits received.");
                TwitchClient.this.refreshRequests.remove("bits");
            }
            TwitchClient.this.g.setCheerEmotes(emoticons);
        }

        @Override
        public void errorMessage(String error) {
            TwitchClient.this.g.printLine(error);
        }
    }

    private class MyStreamInfoListener
    implements StreamInfoListener {
        private final ConcurrentMap<StreamInfo, Object> notFoundInfoDone = new ConcurrentHashMap<StreamInfo, Object>();

        private MyStreamInfoListener() {
        }

        @Override
        public void streamInfoUpdated(StreamInfo info) {
            TwitchClient.this.g.updateState(true);
            TwitchClient.this.g.updateChannelInfo(info);
            TwitchClient.this.g.updateStreamLive(info);
            TwitchClient.this.g.addStreamInfo(info);
            String channel = "#" + info.getStream();
            if (TwitchClient.this.isChannelOpen(channel)) {
                TwitchClient.this.chatLog.viewerstats(channel, info.getViewerStats(false));
                if (info.getOnline() && info.isValid()) {
                    TwitchClient.this.chatLog.viewercount(channel, info.getViewers());
                }
            }
            TwitchClient.this.streamStatusWriter.streamStatus(info);
            if (info.isNotFound() && this.notFoundInfoDone.putIfAbsent(info, info) == null) {
                TwitchClient.this.g.printLine("** This channel doesn't seem to exist on Twitch. You may not be able to join this channel, but trying anyways. **");
            }
        }

        @Override
        public void streamInfoStatusChanged(StreamInfo info, String newStatus) {
            String channel = "#" + info.getStream();
            if (TwitchClient.this.isChannelOpen(channel)) {
                if (TwitchClient.this.settings.getBoolean("printStreamStatus")) {
                    TwitchClient.this.g.printLineByOwnerChannel(channel, "~" + newStatus + "~");
                }
                TwitchClient.this.g.setChannelNewStatus(channel, newStatus);
            }
            TwitchClient.this.g.statusNotification(channel, info);
        }
    }

    private class EmoteListener
    implements EmoticonListener {
        private EmoteListener() {
        }

        @Override
        public void receivedEmoticons(EmoticonUpdate emoticons) {
            TwitchClient.this.g.updateEmoticons(emoticons);
            if (TwitchClient.this.refreshRequests.contains("bttvemotes")) {
                TwitchClient.this.g.printLine("BTTV emotes updated.");
                TwitchClient.this.refreshRequests.remove("bttvemotes");
            } else if (TwitchClient.this.refreshRequests.contains("seventv")) {
                TwitchClient.this.g.printLine("7TV emotes updated.");
                TwitchClient.this.refreshRequests.remove("seventv");
            }
        }

        @Override
        public void receivedBotNames(String stream, Set<String> names) {
            if (TwitchClient.this.settings.getBoolean("botNamesBTTV")) {
                String channel = Helper.toValidChannel(stream);
                TwitchClient.this.botNameManager.addBotNames(channel, names);
            }
        }
    }

    private class EventSubResults
    implements EventSubListener {
        private EventSubResults() {
        }

        @Override
        public void messageReceived(Message message) {
            User user;
            User targetUser;
            Payload data;
            String channel;
            String pollMessage;
            if (message.data instanceof RaidPayload) {
                RaidPayload raid = (RaidPayload)message.data;
                String channel2 = Helper.toChannel(raid.fromLogin);
                String text = String.format("[Raid] Now raiding %s with %d viewers.", raid.toLogin, raid.viewers);
                MsgTags tags = MsgTags.createLinks(new MsgTags.Link(MsgTags.Link.Type.JOIN, Helper.toChannel(raid.toLogin), "Join"));
                TwitchClient.this.g.printInfo(TwitchClient.this.c.getRoomByChannel(channel2), text, tags);
            }
            if ((pollMessage = PollPayload.getPollMessage(message)) != null) {
                PollPayload poll = (PollPayload)message.data;
                TwitchClient.this.g.printInfo(TwitchClient.this.c.getRoomByChannel(Helper.toChannel(poll.stream)), pollMessage, MsgTags.EMPTY);
            }
            if (message.data instanceof ShieldModePayload) {
                ShieldModePayload mode = (ShieldModePayload)message.data;
                channel = Helper.toChannel(mode.stream);
                ChannelState state = TwitchClient.this.c.getChannelState(channel);
                state.setShieldMode(mode.enabled);
                String infoText = String.format("[Info] Shield mode turned %s (@%s)", mode.enabled ? "on" : "off", mode.moderatorLogin);
                TwitchClient.this.g.printInfo(TwitchClient.this.c.getRoomByChannel(channel), infoText, MsgTags.EMPTY);
                TwitchClient.this.handleModAction(new ModActionPayload(mode.enabled ? "shieldMode" : "shieldModeOff", mode.moderatorLogin, null, mode.stream, null));
            }
            if (message.data instanceof ShoutoutPayload) {
                ShoutoutPayload shoutout = (ShoutoutPayload)message.data;
                channel = Helper.toChannel(shoutout.stream);
                String infoText = String.format("[Shoutout] Was given to %s (@%s)", shoutout.target_name, shoutout.moderator_login);
                MsgTags tags = MsgTags.createLinks(new MsgTags.Link(MsgTags.Link.Type.JOIN, Helper.toChannel(shoutout.target_login), "Join"));
                TwitchClient.this.g.printInfo(TwitchClient.this.c.getRoomByChannel(channel), infoText, tags);
                TwitchClient.this.handleModAction(new ModActionPayload("shoutout", shoutout.moderator_login, new ModActionPayload.Shoutout(shoutout.target_login), shoutout.stream, null));
            }
            if (message.data instanceof ModActionPayload) {
                ModActionPayload modAction = (ModActionPayload)message.data;
                if (TwitchClient.this.c.isChannelOpen(Helper.toChannel(modAction.stream))) {
                    TwitchClient.this.handleModAction(modAction);
                }
            }
            if (message.data instanceof SuspiciousMessagePayload) {
                data = (SuspiciousMessagePayload)message.data;
                if (TwitchClient.this.c.isChannelOpen(Helper.toChannel(((SuspiciousMessagePayload)data).stream))) {
                    channel = Helper.toChannel(((SuspiciousMessagePayload)data).stream);
                    targetUser = TwitchClient.this.c.getUser(channel, ((SuspiciousMessagePayload)data).username);
                    TwitchClient.this.g.printLowTrustUserInfo(targetUser, (SuspiciousMessagePayload)data);
                    targetUser.addLowTrust((SuspiciousMessagePayload)data);
                    TwitchClient.this.g.updateUserinfo(targetUser);
                }
            }
            if (message.data instanceof SuspiciousUpdatePayload) {
                data = (SuspiciousUpdatePayload)message.data;
                channel = Helper.toChannel(((SuspiciousUpdatePayload)data).stream);
                TwitchClient.this.handleModAction(new ModActionPayload(((SuspiciousUpdatePayload)data).treatment.id, ((SuspiciousUpdatePayload)data).moderatorUsername, new ModActionPayload.SuspiciousUpdate(((SuspiciousUpdatePayload)data).treatment.id, ((SuspiciousUpdatePayload)data).targetUsername), ((SuspiciousUpdatePayload)data).stream, null));
                targetUser = TwitchClient.this.c.getUser(channel, ((SuspiciousUpdatePayload)data).targetUsername);
                targetUser.addInfo("", ((SuspiciousUpdatePayload)data).makeInfo(), false, null);
                TwitchClient.this.g.updateUserinfo(targetUser);
            }
            if (message.data instanceof WarningAcknowledgePayload) {
                data = (WarningAcknowledgePayload)message.data;
                user = TwitchClient.this.c.getUser(Helper.toChannel(((WarningAcknowledgePayload)data).stream), ((WarningAcknowledgePayload)data).username);
                user.addWarningAcknowledged();
                TwitchClient.this.g.updateUserinfo(user);
                TwitchClient.this.g.printModerationAction(new ModActionPayload("acknowledge_warning", ((WarningAcknowledgePayload)data).username, null, ((WarningAcknowledgePayload)data).stream, null), false);
            }
            if (message.data instanceof UserMessageHeldPayload) {
                data = (UserMessageHeldPayload)message.data;
                if (TwitchClient.this.c.isChannelOpen(Helper.toChannel(((UserMessageHeldPayload)data).stream))) {
                    TwitchClient.this.g.printLine(TwitchClient.this.c.getRoomByChannel(Helper.toChannel(((UserMessageHeldPayload)data).stream)), ((UserMessageHeldPayload)data).info);
                }
            }
            if (message.data instanceof ChannelPointsRedemptionPayload) {
                data = (ChannelPointsRedemptionPayload)message.data;
                if (TwitchClient.this.c.isChannelOpen(Helper.toChannel(((ChannelPointsRedemptionPayload)data).stream))) {
                    user = TwitchClient.this.c.getUser(Helper.toChannel(((ChannelPointsRedemptionPayload)data).stream), ((ChannelPointsRedemptionPayload)data).redeemedByUsername);
                    String text = String.format("%s redeemed %s (%,d)", ((ChannelPointsRedemptionPayload)data).redeemedByUsername, ((ChannelPointsRedemptionPayload)data).rewardTitle, ((ChannelPointsRedemptionPayload)data).rewardCost);
                    TwitchClient.this.g.printPointsNotice(user, text, ((ChannelPointsRedemptionPayload)data).attachedMsg, MsgTags.create("chatty-source", "eventsub", "custom-reward-id", ((ChannelPointsRedemptionPayload)data).rewardId), ((ChannelPointsRedemptionPayload)data).redemptionId, ((ChannelPointsRedemptionPayload)data).isUpdate, ((ChannelPointsRedemptionPayload)data).status);
                }
            }
        }

        @Override
        public void info(String info) {
            TwitchClient.this.g.printDebugEventSub(info);
            Logging.logEventSub(info);
        }
    }

    private class EmoticonsListener
    implements FrankerFaceZListener {
        private EmoticonsListener() {
        }

        @Override
        public void channelEmoticonsReceived(EmoticonUpdate emotes) {
            TwitchClient.this.g.updateEmoticons(emotes);
            if (TwitchClient.this.refreshRequests.contains("ffz")) {
                TwitchClient.this.g.printLine("FFZ emotes updated.");
                TwitchClient.this.refreshRequests.remove("ffz");
            }
            if (TwitchClient.this.refreshRequests.contains("ffzglobal")) {
                TwitchClient.this.g.printLine("Global FFZ emotes updated.");
                TwitchClient.this.refreshRequests.remove("ffzglobal");
            }
        }

        @Override
        public void usericonsReceived(List<Usericon> icons) {
            TwitchClient.this.usericonManager.addDefaultIcons(icons);
        }

        @Override
        public void botNamesReceived(String stream, Set<String> botNames) {
            if (TwitchClient.this.settings.getBoolean("botNamesFFZ")) {
                String channel = Helper.toValidChannel(stream);
                TwitchClient.this.botNameManager.addBotNames(channel, botNames);
            }
        }

        @Override
        public void wsInfo(String info) {
            TwitchClient.this.g.printDebugFFZ(info);
        }

        @Override
        public void authorizeUser(String code) {
            TwitchClient.this.c.sendSpamProtectedMessage("#frankerfacezauthorizer", "AUTH " + code, false);
        }

        @Override
        public void wsUserInfo(String info) {
            TwitchClient.this.g.printSystem("FFZ: " + info);
        }
    }

    private class SettingSaveListener
    implements SettingsListener {
        private SettingSaveListener() {
        }

        @Override
        public void aboutToSaveSettings(Settings settings) {
            GuiUtil.edtAndWait(() -> settings.setString("previousChannel", Helper.buildStreamsString(TwitchClient.this.g.getOpenChannels())), "Save previous channels");
            EmoticonSizeCache.saveToFile();
        }
    }

    private class MyRoomUpdatedListener
    implements RoomManager.RoomUpdatedListener {
        private MyRoomUpdatedListener() {
        }

        @Override
        public void roomUpdated(Room room) {
            if (TwitchClient.this.c != null) {
                TwitchClient.this.c.updateRoom(room);
            }
            if (TwitchClient.this.g != null) {
                TwitchClient.this.g.updateRoom(room);
            }
        }
    }

    private class Messages
    implements TwitchConnection.ConnectionListener {
        private Object connectAttemptMsgId;

        private Messages() {
        }

        private void checkEventSubListen(User user) {
            if (!user.getName().equals(TwitchClient.this.c.getUsername()) || user.getStream() == null) {
                return;
            }
            Debugging.println("es", "Check %s (mod: %s)", user.getChannel(), user.hasChannelModeratorRights());
            BatchAction.queue(TwitchClient.this.eventSub, 100L, false, true, () -> this.checkEventSubListenInternal(user));
        }

        private void checkEventSubListenInternal(User user) {
            TwitchClient.this.eventSub.setLocalUsername(TwitchClient.this.c.getUsername());
            TwitchClient.this.eventSub.listenRaid(user.getStream());
            if (AccessChecker.isBroadcaster(user, TokenInfo.Scope.MANAGE_POLLS)) {
                TwitchClient.this.eventSub.listenPoll(user.getStream());
            }
            if (AccessChecker.isModerator(user, TokenInfo.Scope.MANAGE_SHIELD)) {
                TwitchClient.this.eventSub.listenShield(user.getStream());
                TwitchClient.this.api.getShieldMode(user.getRoom(), true);
            }
            if (AccessChecker.isModerator(user, TokenInfo.Scope.MANAGE_SHOUTOUTS)) {
                TwitchClient.this.eventSub.listenShoutouts(user.getStream());
            }
            if (AccessChecker.isModerator("modActions", user, TokenInfo.Scope.BLOCKED_READ, TokenInfo.Scope.MANAGE_CHAT, TokenInfo.Scope.MANAGE_UNBAN_REQUESTS, TokenInfo.Scope.MANAGE_BANS, TokenInfo.Scope.MANAGE_MSGS, TokenInfo.Scope.MANAGE_WARNINGS, TokenInfo.Scope.READ_MODS, TokenInfo.Scope.READ_VIPS)) {
                TwitchClient.this.eventSub.listenModActions(user.getStream());
            }
            if (AccessChecker.isModerator(user, TokenInfo.Scope.AUTOMOD)) {
                TwitchClient.this.eventSub.listenAutoMod(user.getStream());
            }
            if (AccessChecker.isModerator(user, TokenInfo.Scope.READ_SUSPICIOUS_USERS)) {
                TwitchClient.this.eventSub.listenSuspiciousMessage(user.getStream());
            }
            if (AccessChecker.isModerator(user, TokenInfo.Scope.MANAGE_WARNINGS)) {
                TwitchClient.this.eventSub.listenWarnings(user.getStream());
            }
            if (!user.hasChannelModeratorRights()) {
                if (AccessChecker.hasScope(TokenInfo.Scope.USER_READ_CHAT)) {
                    TwitchClient.this.eventSub.listenMessageHeld(user.getStream());
                }
            } else {
                TwitchClient.this.eventSub.unlistenMessageHeld(user.getStream());
            }
            if (AccessChecker.isBroadcaster(user, TokenInfo.Scope.READ_POINTS)) {
                TwitchClient.this.eventSub.listenPoints(user.getStream());
            }
        }

        @Override
        public void onChannelJoined(User user) {
            TwitchClient.this.channelFavorites.addJoined(user.getRoom());
            TwitchClient.this.g.printLine(user.getRoom(), Language.getString("chat.joined", user.getRoom()));
            if (user.getRoom().hasTopic()) {
                TwitchClient.this.g.printLine(user.getRoom(), user.getRoom().getTopicText());
            }
            TwitchClient.this.api.getGlobalBadges(false);
            String stream = user.getStream();
            if (Helper.isValidStream(stream)) {
                TwitchClient.this.api.getRoomBadges(stream, false);
                TwitchClient.this.api.getCheers(stream, false);
                TwitchClient.this.api.getEmotesByChannelId(stream, null, false);
                TwitchClient.this.requestChannelEmotes(stream);
                TwitchClient.this.frankerFaceZ.joined(stream);
                TwitchClient.this.requestChannelHistory(stream);
                TwitchClient.this.api.removeShieldModeCache(user.getRoom());
                this.checkEventSubListen(user);
                TwitchClient.this.updateStreamInfoChannelOpen(user.getChannel());
            }
        }

        @Override
        public void onChannelLeft(Room room, boolean closeChannel) {
            TwitchClient.this.chatLog.info(room.getFilename(), "You have left " + room.getDisplayName(), null);
            if (closeChannel) {
                TwitchClient.this.closeChannel(room.getChannel());
            } else {
                TwitchClient.this.g.printLine(room, Language.getString("chat.left", room));
            }
        }

        @Override
        public void onJoin(User user) {
            if (TwitchClient.this.settings.getBoolean("showJoinsParts") && this.showUserInGui(user)) {
                TwitchClient.this.g.printCompact("JOIN", user);
            }
            TwitchClient.this.g.userJoined(user);
            TwitchClient.this.chatLog.compact(user.getRoom().getFilename(), "JOIN", user.getRegularDisplayNick());
        }

        @Override
        public void onPart(User user) {
            if (TwitchClient.this.settings.getBoolean("showJoinsParts") && this.showUserInGui(user)) {
                TwitchClient.this.g.printCompact("PART", user);
            }
            TwitchClient.this.chatLog.compact(user.getRoom().getFilename(), "PART", user.getRegularDisplayNick());
            TwitchClient.this.g.userLeft(user);
        }

        @Override
        public void onUserUpdated(User user) {
            if (this.showUserInGui(user)) {
                TwitchClient.this.g.updateUser(user);
            }
            TwitchClient.this.g.updateUserinfo(user);
            this.checkEventSubListen(user);
        }

        @Override
        public void onChannelMessage(User user, String text, boolean action, MsgTags tags) {
            if (tags.isCustomReward()) {
                String rewardInfo = (String)TwitchClient.this.settings.mapGet("rewards", tags.getCustomRewardId());
                String info = String.format("%s redeemed a custom reward (%s)", user.getDisplayNick(), rewardInfo != null ? rewardInfo : "unknown");
                TwitchClient.this.g.printPointsNotice(user, info, text, tags, null, false, null);
            } else {
                if (!(TwitchClient.this.historyManager.addQueueMessage(user, text, tags, action) || TwitchClient.this.isOwnUsername(user.getName()) && TwitchClient.this.sendMessageManager.shouldIgnoreMessage(user, text, tags, action))) {
                    TwitchClient.this.g.printMessage(user, text, action, tags);
                }
                if (tags.isReply() && tags.hasReplyUserMsg() && tags.hasId()) {
                    ReplyManager.addReply(tags.getReplyParentMsgId(), tags.getReplyThreadParentMsgId(), tags.getId(), String.format("<%s> %s", user.getName(), text), tags.getReplyUserMsg());
                }
                if (!action) {
                    TwitchClient.this.addressbookCommands(user.getChannel(), user, text);
                    TwitchClient.this.modCommandAddStreamHighlight(user, text, tags);
                }
                TwitchClient.this.historyManager.setMessageSeen(user.getStream());
            }
        }

        @Override
        public void onNotice(String message) {
            TwitchClient.this.g.printLine("[Notice] " + message);
        }

        @Override
        public void onInfo(Room room, String infoMessage, MsgTags tags) {
            if (tags != null) {
                if (tags.isValue("msg-id", "commercial_success")) {
                    TwitchClient.this.g.commercialResult(room.getStream(), StringUtil.shortenTo(infoMessage, 60), TwitchApi.RequestResultCode.SUCCESS);
                } else if (tags.isValue("msg-id", "bad_commercial_error")) {
                    TwitchClient.this.g.commercialResult(room.getStream(), StringUtil.shortenTo(infoMessage, 60), TwitchApi.RequestResultCode.UNKNOWN);
                }
            }
            TwitchClient.this.g.printInfo(room, infoMessage, tags);
        }

        @Override
        public void onInfo(String message) {
            TwitchClient.this.g.printLine(message);
        }

        @Override
        public void onJoinScheduled(Collection<String> channels) {
            for (String channel : channels) {
                TwitchClient.this.g.joinScheduled(channel);
            }
            TwitchClient.this.updateStreamChatLogos(channels);
            TwitchClient.this.api.getStreamInfo(null, new HashSet<String>(Helper.toStream(channels)));
        }

        @Override
        public void onJoinAttempt(Room room) {
            if (!TwitchClient.this.isChannelOpen(room.getChannel())) {
                TwitchClient.this.g.printStreamInfo(room);
            }
            TwitchClient.this.g.printLine(room, Language.getString("chat.joining", room));
        }

        @Override
        public void onUserAdded(User user) {
            if (this.showUserInGui(user)) {
                TwitchClient.this.g.addUser(user);
            }
        }

        private boolean showUserInGui(User user) {
            if (!TwitchClient.this.settings.getBoolean("ignoredUsersHideInGUI")) {
                return true;
            }
            return !TwitchClient.this.settings.listContains("ignoredUsers", user.getName());
        }

        @Override
        public void onUserRemoved(User user) {
            TwitchClient.this.g.removeUser(user);
        }

        @Override
        public void onBan(User user, long duration, String reason, String targetMsgId) {
            User localUser = TwitchClient.this.c.getLocalUser(user.getChannel());
            if (localUser != user && !localUser.hasModeratorRights()) {
                reason = "";
            }
            TwitchClient.this.g.userBanned(user, duration, reason, targetMsgId);
            UserInfo userInfo = TwitchClient.this.api.getCachedOnlyUserInfo(user.getName());
            TwitchClient.this.chatLog.userBanned(user.getRoom().getFilename(), user.getRegularDisplayNick(), duration, reason, userInfo);
        }

        @Override
        public void onMsgDeleted(User user, String targetMsgId, String msg) {
            User localUser = TwitchClient.this.c.getLocalUser(user.getChannel());
            if (localUser == user) {
                TwitchClient.this.g.printLine(user.getRoom(), "Your message was deleted: " + msg);
            } else {
                TwitchClient.this.g.msgDeleted(user, targetMsgId, msg);
            }
            TwitchClient.this.chatLog.msgDeleted(user, msg);
        }

        @Override
        public void onConnectionPrepare(String server) {
            TwitchClient.this.g.updateState(true);
            this.connectAttemptMsgId = TwitchClient.this.g.printLineAll(Language.getString("chat.connecting2"));
            TwitchClient.this.g.printLineAllAppend(server + "..", this.connectAttemptMsgId);
        }

        @Override
        public void onConnectAttempt(String server, int port, boolean secured) {
            if (server != null) {
                if (this.connectAttemptMsgId != null) {
                    String text = String.format("%s:%d..%s", server, port, secured ? " (" + Language.getString("chat.secured") + ")" : "");
                    TwitchClient.this.g.printLineAllAppend(text, this.connectAttemptMsgId);
                    this.connectAttemptMsgId = null;
                }
            } else {
                TwitchClient.this.g.printLineAll("Failed to connect (server or port invalid)");
            }
        }

        @Override
        public void onRegistered() {
            TwitchClient.this.g.updateHighlightSetUsername(TwitchClient.this.c.getUsername());
        }

        @Override
        public void onMod(User user) {
            boolean modMessagesEnabled = TwitchClient.this.settings.getBoolean("showModMessages");
            if (modMessagesEnabled && this.showUserInGui(user)) {
                TwitchClient.this.g.printCompact("MOD", user);
            }
            TwitchClient.this.chatLog.compact(user.getRoom().getFilename(), "MOD", user.getRegularDisplayNick());
        }

        @Override
        public void onUnmod(User user) {
            boolean modMessagesEnabled = TwitchClient.this.settings.getBoolean("showModMessages");
            if (modMessagesEnabled && this.showUserInGui(user)) {
                TwitchClient.this.g.printCompact("UNMOD", user);
            }
            TwitchClient.this.chatLog.compact(user.getRoom().getFilename(), "UNMOD", user.getRegularDisplayNick());
        }

        @Override
        public void onDisconnect(int reason, String reasonMessage) {
            if (reason == 105) {
                TwitchClient.this.api.checkToken();
            }
            if (reason == 104) {
                // empty if block
            }
        }

        @Override
        public void onConnectionStateChanged(int state) {
            TwitchClient.this.g.updateState(true);
        }

        @Override
        public void onEmotesets(String channel, Set<String> emotesets) {
            TwitchClient.this.emotesetManager.setIrcEmotesets(channel, emotesets);
        }

        @Override
        public void onConnectError(String message) {
            TwitchClient.this.g.printLine(message);
        }

        @Override
        public void onJoinError(Set<String> toJoin, String errorChannel, TwitchConnection.JoinError error) {
            if (error == TwitchConnection.JoinError.NOT_REGISTERED) {
                String validChannels = Helper.buildStreamsString(toJoin);
                if (TwitchClient.this.c.isOffline()) {
                    TwitchClient.this.prepareConnectionWithChannel(validChannels);
                } else {
                    TwitchClient.this.g.printLine(Language.getString("chat.joinError.notConnected", validChannels));
                }
            } else if (error == TwitchConnection.JoinError.ALREADY_JOINED) {
                if (toJoin.size() == 1) {
                    TwitchClient.this.g.switchToChannel(errorChannel);
                } else {
                    TwitchClient.this.g.printLine(Language.getString("chat.joinError.alreadyJoined", errorChannel));
                }
            } else if (error == TwitchConnection.JoinError.INVALID_NAME) {
                TwitchClient.this.g.printLine(Language.getString("chat.joinError.invalid", errorChannel));
            } else if (error == TwitchConnection.JoinError.ROOM) {
                TwitchClient.this.g.printLine(Language.getString("chat.joinError.rooms", errorChannel));
            }
        }

        @Override
        public void onRawReceived(String text) {
            TwitchClient.this.ircLogger.onRawReceived(text);
        }

        @Override
        public void onRawSent(String text) {
            TwitchClient.this.ircLogger.onRawSent(text);
        }

        @Override
        public void onGlobalInfo(String message) {
            TwitchClient.this.g.printLineAll(message);
        }

        @Override
        public void onUserlistCleared(String channel) {
            TwitchClient.this.g.clearUsers(channel);
        }

        @Override
        public void onChannelCleared(Room room) {
            if (room != null) {
                if (TwitchClient.this.settings.getBoolean("clearChatOnChannelCleared")) {
                    TwitchClient.this.g.clearChat(room);
                }
                TwitchClient.this.g.printLine(room, "Channel was cleared by a moderator.");
            } else {
                TwitchClient.this.g.printLine("One of the channels you joined was cleared by a moderator.");
            }
        }

        @Override
        public void onWhisper(User user, String message, String emotes) {
            TwitchClient.this.w.whisperReceived(user, message, emotes);
        }

        @Override
        public void onSubscriberNotification(User user, String text, String message, int months, MsgTags tags) {
            TwitchClient.this.g.printSubscriberMessage(user, text, message, tags);
            if (user.getName().isEmpty()) {
                return;
            }
            String name = user.getName();
            if (!TwitchClient.this.settings.getString("abSubMonthsChan").equalsIgnoreCase(user.getChannel())) {
                return;
            }
            ArrayList monthsDef = new ArrayList();
            TwitchClient.this.settings.getList("abSubMonths", monthsDef);
            long max = 0L;
            Iterator iterator = monthsDef.iterator();
            while (iterator.hasNext()) {
                long entry = (Long)iterator.next();
                if ((long)months < entry || entry <= max) continue;
                max = entry;
            }
            if (name != null && max > 0L) {
                String cat = max + "months";
                TwitchClient.this.addressbook.add(name, cat);
                LOGGER.info(String.format("[Subscriber] Added '%s' with category '%s'", name, cat));
            }
        }

        @Override
        public void onUsernotice(String type, User user, String text, String message, MsgTags tags) {
            TwitchClient.this.g.printUsernotice(type, user, text, message, tags);
        }

        @Override
        public void onSpecialMessage(String name, String message) {
            TwitchClient.this.g.printLine(TwitchClient.this.roomManager.getRoom(name), message);
        }

        @Override
        public void onRoomId(String channel, String id) {
            if (Helper.isRegularChannel(channel)) {
                TwitchClient.this.api.setUserId(Helper.toStream(channel), id);
            }
        }
    }

    private class ChannelStateUpdater
    implements ChannelStateManager.ChannelStateListener {
        private ChannelStateUpdater() {
        }

        @Override
        public void channelStateUpdated(ChannelState state) {
            TwitchClient.this.g.updateState(true);
            TwitchClient.this.g.channelStateUpdated(state);
        }
    }

    private class MyWhisperListener
    implements WhisperManager.WhisperListener {
        private MyWhisperListener() {
        }

        @Override
        public void whisperReceived(User user, String message, String emotes) {
            TwitchClient.this.g.printMessage(user, message, false, MsgTags.create("emotes", emotes));
            TwitchClient.this.g.updateUser(user);
        }

        @Override
        public void info(String message) {
            TwitchClient.this.g.printLine(message);
        }

        @Override
        public void whisperSent(User to, String message) {
            TwitchClient.this.g.printMessage(to, message, true);
        }
    }

    private class WebserverListener
    implements Webserver.WebserverListener {
        private WebserverListener() {
        }

        @Override
        public void webserverStarted() {
            TwitchClient.this.g.webserverStarted();
        }

        @Override
        public void webserverStopped() {
            TwitchClient.this.webserver = null;
        }

        @Override
        public void webserverError(String error) {
            TwitchClient.this.g.webserverError(error);
            TwitchClient.this.webserver = null;
        }

        @Override
        public void webserverTokenReceived(String token) {
            TwitchClient.this.g.webserverTokenReceived(token);
        }
    }
}

