/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Commands;
import chatty.Helper;
import chatty.Room;
import chatty.TwitchClient;
import chatty.TwitchConnection;
import chatty.User;
import chatty.gui.MainGui;
import chatty.gui.UrlOpener;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.RecentlyAffectedUsers;
import chatty.util.StringUtil;
import chatty.util.api.TwitchApi;
import chatty.util.irc.MsgTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class TwitchCommands {
    private static final Logger LOGGER = Logger.getLogger(TwitchCommands.class.getName());
    private final Set<String> silentModsRequestChannel = Collections.synchronizedSet(new HashSet());
    private static final Set<String> SIMPLE_COMMANDS = new HashSet<String>(Arrays.asList("commercial"));
    private static final Set<String> NO_PARAMETER_COMMANDS = new HashSet<String>(Arrays.asList(new String[0]));
    private static final Set<String> OTHER_COMMANDS = new HashSet<String>(Arrays.asList(new String[0]));
    private final TwitchConnection c;

    public TwitchCommands(TwitchConnection c) {
        this.c = c;
    }

    public static boolean isCommand(String command) {
        if (SIMPLE_COMMANDS.contains(command = StringUtil.toLowerCase(command))) {
            return true;
        }
        return OTHER_COMMANDS.contains(command);
    }

    public boolean command(String channel, String msgId, String command, String parameter) {
        if (SIMPLE_COMMANDS.contains(command)) {
            if (this.onChannel(channel, true)) {
                parameter = StringUtil.trim(parameter);
                String message = Language.getStringNull("chat.twitchcommands." + command, !StringUtil.isNullOrEmpty(parameter) ? parameter : "default");
                if (parameter == null || parameter.trim().isEmpty() || NO_PARAMETER_COMMANDS.contains(command)) {
                    String output = message != null ? message : "Trying to " + command + "..";
                    this.sendMessage(channel, "/" + command, output);
                } else {
                    String output = message != null ? message : "Trying to " + command + " " + parameter + "..";
                    this.sendMessage(channel, "/" + command + " " + parameter, output);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public void addNewCommands(Commands commands, TwitchClient client) {
        MainGui g = client.g;
        TwitchApi api = client.api;
        for (String color : TwitchApi.ANNOUNCEMENT_COLORS) {
            commands.add("announce" + color, p -> {
                if (!p.hasArgs() || p.getArgs().trim().isEmpty()) {
                    g.printSystem("Usage: /announce" + color + " <message>");
                } else {
                    api.sendAnnouncement(p.getRoom().getStream(), p.getArgs(), color);
                }
            }, new String[0]);
        }
        commands.add("timeout", "<user> [duration] [reason]", p -> {
            String reason;
            int seconds;
            Commands.CommandParsedArgs args = p.parsedArgs(3, 1);
            if (args != null) {
                seconds = TwitchCommands.getTimeoutSeconds(args);
                reason = args.get(2, "");
            } else {
                seconds = -1;
                reason = "";
            }
            String info = StringUtil.append(TwitchCommands.formatDuration(seconds), ", ", reason);
            this.userCommand(client, (Commands.CommandParameters)p, args, (user, resultListener) -> api.ban((User)user, seconds, reason, (TwitchApi.SimpleRequestResultListener)resultListener), StringUtil.aEmptyb(info, "", " (%s)"));
        }, "to");
        commands.add("ban", "<user> [reason]", p -> {
            Commands.CommandParsedArgs args = p.parsedArgs(2, 1);
            String reason = args != null ? args.get(1, "") : "";
            this.userCommand(client, (Commands.CommandParameters)p, args, (user, resultListener) -> api.ban((User)user, 0, reason, (TwitchApi.SimpleRequestResultListener)resultListener), StringUtil.aEmptyb(reason, "", " (%s)"));
        }, new String[0]);
        commands.add("unban", "<user>", p -> this.userCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 1), (user, resultListener) -> api.unban((User)user, (TwitchApi.SimpleRequestResultListener)resultListener), ""), "untimeout");
        commands.add("delete", "<messageId>", p -> {
            Commands.CommandParsedArgs args = p.parsedArgs(1, 1);
            this.channelCommand(client, (Commands.CommandParameters)p, args, listener -> api.deleteMsg(p.getRoom(), args.get(0), (TwitchApi.SimpleRequestResultListener)listener));
        }, new String[0]);
        commands.add("clear", p -> this.channelCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 0), listener -> api.deleteMsg(p.getRoom(), null, (TwitchApi.SimpleRequestResultListener)listener)), new String[0]);
        commands.add("shoutout", "<user>", p -> this.userCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 1), (user, resultListener) -> api.shoutout((User)user, (TwitchApi.SimpleRequestResultListener)resultListener), ""), new String[0]);
        commands.add("warn", "<user> <reason>", p -> {
            Commands.CommandParsedArgs args = p.parsedArgs(2, 2);
            String reason = args != null ? args.get(1, "") : "";
            this.userCommand(client, (Commands.CommandParameters)p, args, (user, resultListener) -> api.warn((User)user, reason, (TwitchApi.SimpleRequestResultListener)resultListener), StringUtil.aEmptyb(reason, "", " (%s)"));
        }, new String[0]);
        commands.add("mod", "<user>", p -> this.userCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 1), (user, resultListener) -> api.setModerator((User)user, true, (TwitchApi.SimpleRequestResultListener)resultListener), ""), new String[0]);
        commands.add("unmod", "<user>", p -> this.userCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 1), (user, resultListener) -> api.setModerator((User)user, false, (TwitchApi.SimpleRequestResultListener)resultListener), ""), new String[0]);
        commands.add("vip", "<user>", p -> this.userCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 1), (user, resultListener) -> api.setVip((User)user, true, (TwitchApi.SimpleRequestResultListener)resultListener), ""), new String[0]);
        commands.add("unvip", "<user>", p -> this.userCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 1), (user, resultListener) -> api.setVip((User)user, false, (TwitchApi.SimpleRequestResultListener)resultListener), ""), new String[0]);
        commands.add("mods", p -> {
            if (this.localUserIsBroadcaster(p.getRoom(), client)) {
                this.channelCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 0), listener -> api.requestModerators(p.getRoom(), (TwitchApi.SimpleRequestResultListener)listener));
            } else {
                this.sendMessage(p.getChannel(), "/mods", Language.getString("chat.twitchcommands.mods") + " (will only work for broadcaster after February 18, 2023)");
            }
        }, new String[0]);
        commands.add("vips", p -> {
            if (this.localUserIsBroadcaster(p.getRoom(), client)) {
                this.channelCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 0), listener -> api.requestVips(p.getRoom(), (TwitchApi.SimpleRequestResultListener)listener));
            } else {
                this.sendMessage(p.getChannel(), "/vips", Language.getString("chat.twitchcommands.vips") + " (will only work for broadcaster after February 18, 2023)");
            }
        }, new String[0]);
        commands.add("raid", p -> {
            Commands.CommandParsedArgs args = p.parsedArgs(1, 1);
            this.channelCommand(client, (Commands.CommandParameters)p, args, listener -> api.startRaid(p.getRoom(), args.get(0), (TwitchApi.SimpleRequestResultListener)listener), () -> args.get(0));
        }, new String[0]);
        commands.add("unraid", p -> this.channelCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 0), listener -> api.cancelRaid(p.getRoom(), (TwitchApi.SimpleRequestResultListener)listener)), new String[0]);
        commands.add("commercial", p -> {
            Commands.CommandParsedArgs args = p.parsedArgs(1, 0);
            client.runCommercial(p.getRoom().getStream(), args.getInt(0, 30));
        }, new String[0]);
        commands.add("uniquechat", p -> this.updateChatSettings(client, (Commands.CommandParameters)p, "", "unique_chat_mode", true), "r9kbeta", "r9k");
        commands.add("uniquechatOff", p -> this.updateChatSettings(client, (Commands.CommandParameters)p, "", "unique_chat_mode", false), "r9kbetaOff", "r9kOff");
        commands.add("followers", p -> {
            int minutes = (int)DateTime.parseDurationSeconds(p.getArgs(), TimeUnit.MINUTES) / 60;
            if (minutes == -1) {
                this.updateChatSettings(client, (Commands.CommandParameters)p, "", "follower_mode", true);
            } else {
                this.updateChatSettings(client, (Commands.CommandParameters)p, " (" + TwitchCommands.formatDuration(minutes * 60) + ")", "follower_mode", true, "follower_mode_duration", minutes);
            }
        }, new String[0]);
        commands.add("followersOff", p -> this.updateChatSettings(client, (Commands.CommandParameters)p, "", "follower_mode", false), new String[0]);
        commands.add("slow", p -> {
            int seconds = (int)DateTime.parseDurationSeconds(p.getArgs());
            if (seconds == -1) {
                this.updateChatSettings(client, (Commands.CommandParameters)p, "", "slow_mode", true);
            } else {
                this.updateChatSettings(client, (Commands.CommandParameters)p, " (" + TwitchCommands.formatDuration(seconds) + ")", "slow_mode", true, "slow_mode_wait_time", seconds);
            }
        }, new String[0]);
        commands.add("slowOff", p -> this.updateChatSettings(client, (Commands.CommandParameters)p, "", "slow_mode", false), new String[0]);
        commands.add("subscribers", p -> this.updateChatSettings(client, (Commands.CommandParameters)p, "", "subscriber_mode", true), new String[0]);
        commands.add("subscribersOff", p -> this.updateChatSettings(client, (Commands.CommandParameters)p, "", "subscriber_mode", false), new String[0]);
        commands.add("emoteonly", p -> this.updateChatSettings(client, (Commands.CommandParameters)p, "", "emote_mode", true), new String[0]);
        commands.add("emoteonlyOff", p -> this.updateChatSettings(client, (Commands.CommandParameters)p, "", "emote_mode", false), new String[0]);
        commands.add("shieldMode", p -> this.channelCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 0), listener -> api.setShieldMode(p.getRoom(), true, (TwitchApi.SimpleRequestResultListener)listener)), new String[0]);
        commands.add("shieldModeOff", p -> this.channelCommand(client, (Commands.CommandParameters)p, p.parsedArgs(1, 0), listener -> api.setShieldMode(p.getRoom(), false, (TwitchApi.SimpleRequestResultListener)listener)), new String[0]);
        commands.add("color", p -> {
            Commands.CommandParsedArgs args = p.parsedArgs(1, 1);
            this.simpleCommand(client, (Commands.CommandParameters)p, args, listener -> api.setColor(args.get(0), (TwitchApi.SimpleRequestResultListener)listener), () -> args.get(0));
        }, new String[0]);
        commands.add("requests", p -> {
            String channel = p.getChannel();
            if (Helper.isRegularChannelStrict(channel)) {
                UrlOpener.openUrl("https://www.twitch.tv/popout/" + Helper.toStream(channel) + "/reward-queue");
            } else {
                this.printLine(channel, "Invalid channel to open reward queue for");
            }
        }, new String[0]);
    }

    private static int getTimeoutSeconds(Commands.CommandParsedArgs args) {
        int seconds = (int)DateTime.parseDurationSeconds(args.get(1, null));
        if (seconds < 1) {
            seconds = 600;
        }
        return seconds;
    }

    private void updateChatSettings(TwitchClient client, Commands.CommandParameters p, Object append, Object ... data) {
        if (!Helper.isValidChannelStrict(p.getChannel())) {
            client.g.printSystem(p.getRoom(), "Invalid channel.");
            return;
        }
        if (data == null) {
            client.g.printSystem(p.getRoom(), "Invalid command");
            return;
        }
        String msg = TwitchCommands.makeMsg(p.getCommand(), append);
        Object objectId = client.g.printLine(p.getRoom(), msg);
        client.api.updateChatSettings(p.getRoom(), (TwitchApi.SimpleRequestResult r) -> {
            if (r.error == null) {
                client.g.addToLine(p.getRoom(), objectId, "OK");
            } else {
                client.g.addToLine(p.getRoom(), objectId, r.error);
            }
        }, data);
    }

    private void userCommand(TwitchClient client, Commands.CommandParameters p, Commands.CommandParsedArgs args, BiConsumer<User, TwitchApi.SimpleRequestResultListener> doRequest, String append) {
        if (!Helper.isValidChannelStrict(p.getChannel())) {
            client.g.printSystem(p.getRoom(), "Invalid channel.");
            return;
        }
        if (args == null) {
            client.g.printSystem(p.getRoom(), TwitchCommands.getInvalidParametersMessage(p));
            return;
        }
        User user = client.getUser(p.getChannel(), args.get(0));
        String msg = String.format("Trying to %s %s%s..", p.getCommand().getName(), user.getName(), append);
        Object objectId = client.g.printLine(p.getRoom(), msg);
        doRequest.accept(user, r -> {
            if (r.error == null) {
                client.g.addToLine(p.getRoom(), objectId, "OK");
                RecentlyAffectedUsers.addUser(user);
            } else {
                client.g.addToLine(p.getRoom(), objectId, r.error);
            }
        });
    }

    private void channelCommand(TwitchClient client, Commands.CommandParameters p, Commands.CommandParsedArgs args, Consumer<TwitchApi.SimpleRequestResultListener> doRequest) {
        this.channelCommand(client, p, args, doRequest, () -> null);
    }

    private void channelCommand(TwitchClient client, Commands.CommandParameters p, Commands.CommandParsedArgs args, Consumer<TwitchApi.SimpleRequestResultListener> doRequest, Supplier<String> outputArg) {
        if (!Helper.isValidChannelStrict(p.getChannel())) {
            client.g.printSystem(p.getRoom(), "Invalid channel.");
            return;
        }
        this.simpleCommand(client, p, args, doRequest, outputArg);
    }

    private void simpleCommand(TwitchClient client, Commands.CommandParameters p, Commands.CommandParsedArgs args, Consumer<TwitchApi.SimpleRequestResultListener> doRequest, Supplier<String> outputArg) {
        if (args != null) {
            String msg = TwitchCommands.makeMsg(p.getCommand(), outputArg.get());
            Object objectId = client.g.printLine(p.getRoom(), msg);
            doRequest.accept(r -> {
                if (r.error == null) {
                    if (r.result == null) {
                        client.g.addToLine(p.getRoom(), objectId, "OK");
                    } else {
                        client.g.printLine(p.getRoom(), r.result);
                    }
                } else {
                    client.g.addToLine(p.getRoom(), objectId, r.error);
                }
            });
        } else {
            client.g.printSystem(p.getRoom(), TwitchCommands.getInvalidParametersMessage(p));
        }
    }

    private static String getInvalidParametersMessage(Commands.CommandParameters p) {
        String usage = p.getCommand().getUsage();
        return !StringUtil.isNullOrEmpty(usage) ? usage : "Invalid parameters";
    }

    private static String makeMsg(Commands.Command command, Object ... args) {
        String message = Language.getStringNull("chat.twitchcommands." + command.getName(), args);
        if (message == null) {
            message = "Trying to " + command.getName() + "..";
        }
        return message;
    }

    public static String formatDuration(int seconds) {
        if (seconds > 0) {
            return DateTime.duration(TimeUnit.SECONDS.toMillis(seconds), DateTime.Formatting.NO_ZERO_VALUES);
        }
        return "";
    }

    private boolean localUserIsBroadcaster(Room room, TwitchClient client) {
        return room.getStream() != null && room.getStream().equals(client.getUsername());
    }

    private boolean onChannel(String channel, boolean message) {
        return this.c.onChannel(channel, message);
    }

    private void sendMessage(String channel, String message, String echo) {
        this.sendMessage(channel, message, echo, MsgTags.EMPTY);
    }

    private void sendMessage(String channel, String message, String echo, MsgTags tags) {
        this.c.sendCommandMessage(channel, message, echo, tags);
    }

    private void printLine(String channel, String message) {
        this.c.info(channel, message, null);
    }

    public void modsSilent(String channel) {
        if (this.onChannel(channel, true)) {
            this.printLine(channel, "Trying to fix moderators..");
            this.requestModsSilent(channel);
        }
    }

    public void requestModsSilent(String channel) {
        if (this.onChannel(channel, false)) {
            this.silentModsRequestChannel.add(channel);
            this.c.sendSpamProtectedMessage(channel, ".mods", false);
        }
    }

    public boolean removeModsSilent(String channel) {
        return this.silentModsRequestChannel.remove(channel);
    }

    public boolean waitingForModsSilent() {
        return !this.silentModsRequestChannel.isEmpty();
    }

    public static List<String> parseModsList(String text) {
        String mods;
        int start = text.indexOf(":") + 1;
        ArrayList<String> modsList = new ArrayList<String>();
        if (start > 1 && text.length() > start && !(mods = text.substring(start)).trim().isEmpty()) {
            String[] modsArray;
            for (String mod : modsArray = mods.split(",")) {
                modsList.add(mod.trim());
            }
        }
        return modsList;
    }
}

