/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.ChannelState;
import chatty.ChannelStateManager;
import chatty.Commands;
import chatty.CustomNames;
import chatty.Helper;
import chatty.Irc;
import chatty.JoinChecker;
import chatty.Room;
import chatty.RoomManager;
import chatty.SpamProtection;
import chatty.TwitchClient;
import chatty.TwitchCommands;
import chatty.User;
import chatty.UserManager;
import chatty.gui.emoji.EmojiUtil;
import chatty.lang.Language;
import chatty.util.BotNameManager;
import chatty.util.StringUtil;
import chatty.util.api.Emoticons;
import chatty.util.irc.MsgTags;
import chatty.util.irc.UserTagsUtil;
import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class TwitchConnection {
    private static final Logger LOGGER = Logger.getLogger(TwitchConnection.class.getName());
    private final ConnectionListener listener;
    private final Settings settings;
    private volatile String[] autojoin;
    private final Set<String> openChannels = Collections.synchronizedSet(new HashSet());
    private long maxReconnectionAttempts = -1L;
    private static final int[] RECONNECTION_DELAY = new int[]{1, 5, 5, 10, 10, 60, 120};
    private volatile Timer reconnectionTimer;
    private volatile String username;
    private volatile String password;
    private volatile String server;
    private volatile String serverPorts = "6667";
    protected UserManager users = new UserManager();
    private final RoomManager rooms;
    private final IrcConnection irc;
    private final TwitchCommands twitchCommands;
    private final SpamProtection spamProtection;
    private final ChannelStateManager channelStates = new ChannelStateManager();
    private final SentMessages sentMessages = new SentMessages();

    public TwitchConnection(final ConnectionListener listener, Settings settings, String label, RoomManager rooms) {
        this.irc = new IrcConnection(label);
        this.listener = listener;
        this.settings = settings;
        this.twitchCommands = new TwitchCommands(this);
        this.rooms = rooms;
        this.spamProtection = new SpamProtection();
        this.spamProtection.setLinesPerSeconds(settings.getString("spamProtection"));
        this.users.setCapitalizedNames(settings.getBoolean("capitalizedNames"));
        this.users.setSettings(settings);
        this.users.addListener(new UserManager.UserManagerListener(){

            @Override
            public void userUpdated(User user) {
                if (user.isOnline()) {
                    listener.onUserUpdated(user);
                }
            }
        });
    }

    private TimerTask getReconnectionTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                TwitchConnection.this.reconnect();
            }
        };
    }

    public void simulate(String data) {
        this.irc.simulate(data);
    }

    public void debugConnection() {
        this.irc.debugConnection();
    }

    public void addChannelStateListener(ChannelStateManager.ChannelStateListener listener) {
        this.channelStates.addListener(listener);
    }

    public ChannelState getChannelState(String channel) {
        return this.channelStates.getState(channel);
    }

    public void setUserSettings(User.UserSettings settings) {
        this.users.setUserSettings(settings);
    }

    public void setBotNameManager(BotNameManager m) {
        this.users.setBotNameManager(m);
    }

    public void setCustomNamesManager(CustomNames customNames) {
        this.users.setCustomNamesManager(customNames);
    }

    public void setMaxReconnectionAttempts(long num) {
        this.maxReconnectionAttempts = num;
    }

    public void setSpamProtection(String setting) {
        this.spamProtection.setLinesPerSeconds(setting);
    }

    public String getSpamProtectionInfo() {
        return this.spamProtection.toString();
    }

    public void updateRoom(Room room) {
        this.users.updateRoom(room);
    }

    public User getUser(String channel, String name) {
        return this.users.getUser(this.rooms.getRoom(channel), name);
    }

    public User getExistingUser(String channel, String name) {
        name = StringUtil.toLowerCase(name);
        return this.users.getUserIfExists(channel, name);
    }

    public int clearLines(String channel, boolean numberOfMessagesOnly) {
        return this.users.clearLines(channel, numberOfMessagesOnly);
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isUserlistLoaded(String channel) {
        return this.irc.isRegistered() && this.irc.userlistReceived.contains(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getOpenChannels() {
        Set<String> set = this.openChannels;
        synchronized (set) {
            return new HashSet<String>(this.openChannels);
        }
    }

    public Set<Room> getOpenRooms() {
        Set<String> chans = this.getOpenChannels();
        HashSet<Room> result = new HashSet<Room>();
        for (String chan : chans) {
            result.add(this.rooms.getRoom(chan));
        }
        return result;
    }

    public Room getRoomByChannel(String channel) {
        return this.rooms.getRoom(channel);
    }

    private int getReconnectionDelay(int attempt) {
        if (attempt < 1 || attempt > RECONNECTION_DELAY.length) {
            return this.getMaxReconnectionDelay();
        }
        return RECONNECTION_DELAY[attempt - 1];
    }

    public int getState() {
        return this.irc.getState();
    }

    public boolean isOffline() {
        return this.irc.isOffline();
    }

    public boolean isRegistered() {
        return this.irc.isRegistered();
    }

    public boolean onChannel(String channel) {
        return this.onChannel(channel, false);
    }

    public Set<String> getJoinedChannels() {
        return this.irc.getJoinedChannels();
    }

    public boolean isChannelOpen(String channel) {
        return this.openChannels.contains(channel);
    }

    public void closeChannel(String channel) {
        if (channel.equals("$[whisper]")) {
            return;
        }
        this.partChannel(channel);
        this.openChannels.remove(channel);
        this.users.clear(channel);
        this.irc.cancelJoinAttempt(channel);
    }

    public void setAllOffline() {
        this.users.setAllOffline();
    }

    public void rejoinChannel(String channel) {
        if (this.onChannel(channel)) {
            this.irc.rejoinChannel.add(channel);
            this.partChannel(channel);
        }
    }

    public void partChannel(String channel) {
        if (this.onChannel(channel)) {
            this.irc.partChannel(channel);
        }
    }

    public boolean onChannel(String channel, boolean showMessage) {
        boolean onChannel = this.irc.joinedChannels.contains(channel);
        if (showMessage && !onChannel) {
            if (channel == null || channel.isEmpty()) {
                this.listener.onInfo("Not in a channel");
            } else {
                this.listener.onInfo("Not in this channel (" + channel + ")");
            }
        }
        return onChannel;
    }

    public boolean onOwnerChannel(String ownerChannel) {
        if (this.irc.joinedChannels.contains(ownerChannel)) {
            return true;
        }
        for (Room room : this.rooms.getRoomsByOwner(ownerChannel)) {
            if (!this.irc.joinedChannels.contains(room.getChannel())) continue;
            return true;
        }
        return false;
    }

    protected void reconnect() {
        this.cancelReconnectionTimer();
        this.connect();
    }

    private boolean cancelReconnectionTimer() {
        if (this.reconnectionTimer != null) {
            this.reconnectionTimer.cancel();
            this.reconnectionTimer = null;
            return true;
        }
        return false;
    }

    public void connect(String server, String serverPorts, String username, String password, String[] autojoin) {
        this.server = server;
        this.serverPorts = serverPorts;
        this.username = username;
        this.users.setLocalUsername(username);
        this.password = password;
        this.autojoin = autojoin;
        this.connect();
    }

    public void setLogin(String username, String password) {
        if (username.equals(this.username) && password.equals(this.password)) {
            return;
        }
        this.username = username;
        this.password = password;
        this.users.setLocalUsername(username);
        if (this.irc.getState() != 0) {
            this.disconnect();
            this.reconnect();
        }
    }

    private void connect() {
        if (this.irc.getState() <= 0) {
            this.cancelReconnectionTimer();
            new Thread("IRC connect"){

                @Override
                public void run() {
                    TwitchConnection.this.irc.connect(TwitchConnection.this.server, TwitchConnection.this.serverPorts, TwitchConnection.this.username, TwitchConnection.this.password, TwitchConnection.this.getSecuredPorts());
                }
            }.start();
        } else {
            this.listener.onConnectError("Already connected or connecting.");
        }
    }

    private Collection<Integer> getSecuredPorts() {
        List setting = this.settings.getList("securedPorts");
        HashSet<Integer> result = new HashSet<Integer>();
        for (Object value : setting) {
            result.add(((Long)value).intValue());
        }
        return result;
    }

    public User getSpecialUser() {
        return this.users.specialUser;
    }

    private int getMaxReconnectionDelay() {
        return RECONNECTION_DELAY[RECONNECTION_DELAY.length - 1];
    }

    public boolean disconnect() {
        if (this.cancelReconnectionTimer()) {
            this.listener.onGlobalInfo("Canceled reconnecting");
            this.irc.setState(0);
            this.irc.connectionAttempts = 0;
        }
        boolean success = this.irc.disconnect();
        return success;
    }

    public void quit() {
        this.irc.disconnect();
    }

    public String getConnectionInfo() {
        if (this.irc.getConnectionInfo() == null) {
            return "Not connected.";
        }
        return String.format("Connected to: %s (%s, %s channels)", this.irc.getConnectionInfo(), this.irc.getConnectedSince(), this.irc.joinedChannels.size());
    }

    public boolean autoRequestModsEnabled() {
        return this.settings.getBoolean("autoRequestMods");
    }

    public User localUserJoined(String channel) {
        return this.userJoined(channel, this.username);
    }

    public User getLocalUser(String channel) {
        return this.users.getUser(this.rooms.getRoom(channel), this.username);
    }

    public void sendRaw(String text) {
        this.irc.send(text);
    }

    public boolean command(String channel, String command, String parameters, String msgId) {
        return this.twitchCommands.command(channel, msgId, command, parameters);
    }

    public void addNewCommands(Commands commands, TwitchClient client) {
        this.twitchCommands.addNewCommands(commands, client);
    }

    public void sendCommandMessage(String channel, String message, String echo) {
        this.sendCommandMessage(channel, message, echo, MsgTags.EMPTY);
    }

    public void sendCommandMessage(String channel, String message, String echo, MsgTags tags) {
        if (this.sendSpamProtectedMessage(channel, message, false, tags)) {
            this.info(channel, echo, null);
        } else {
            this.info(channel, "# Command not sent to prevent ban: " + message, null);
        }
    }

    public boolean sendSpamProtectedMessage(String channel, String message, boolean action) {
        return this.sendSpamProtectedMessage(channel, message, action, MsgTags.EMPTY);
    }

    public boolean sendSpamProtectedMessage(String channel, String message, boolean action, MsgTags tags) {
        if (!this.spamProtection.check()) {
            return false;
        }
        if (this.settings.getLong("emojiZWJ") == 2L) {
            message = EmojiUtil.encodeZWJ(message);
        }
        if (Helper.isChatroomChannel(channel)) {
            this.sentMessages.messageSent(channel, message);
        }
        this.spamProtection.increase();
        if (action) {
            this.irc.sendActionMessage(channel, message);
        } else {
            this.irc.sendMessage(channel, message, tags);
        }
        return true;
    }

    public int getNumJoinedChannels() {
        return this.irc.joinedChannels.size();
    }

    private void join(String channel) {
        this.irc.joinChannel(channel);
    }

    public void joinChannel(String channel) {
        HashSet<String> channels = new HashSet<String>();
        channels.add(channel);
        this.joinChannels(channels);
    }

    public void joinChannels(Set<String> channels) {
        LinkedHashSet<String> valid = new LinkedHashSet<String>();
        LinkedHashSet<String> invalid = new LinkedHashSet<String>();
        LinkedHashSet<String> rooms = new LinkedHashSet<String>();
        for (String channel : channels) {
            String checkedChannel = Helper.toValidChannel(channel);
            if (checkedChannel == null) {
                invalid.add(channel);
                continue;
            }
            if (checkedChannel.startsWith("#chatrooms:")) {
                rooms.add(channel);
                continue;
            }
            valid.add(checkedChannel);
        }
        for (String channel : invalid) {
            this.listener.onJoinError(channels, channel, JoinError.INVALID_NAME);
        }
        for (String channel : rooms) {
            this.listener.onJoinError(channels, channel, JoinError.ROOM);
        }
        this.joinValidChannels(valid);
    }

    private void joinValidChannels(Set<String> valid) {
        if (valid.isEmpty()) {
            return;
        }
        if (!this.irc.isRegistered()) {
            this.listener.onJoinError(valid, null, JoinError.NOT_REGISTERED);
        } else {
            ArrayList<String> toJoin = new ArrayList<String>();
            for (String channel : valid) {
                if (this.onChannel(channel)) {
                    this.listener.onJoinError(valid, channel, JoinError.ALREADY_JOINED);
                    continue;
                }
                toJoin.add(channel);
            }
            if (!toJoin.isEmpty()) {
                this.listener.onJoinScheduled(toJoin);
                for (String channel : toJoin) {
                    this.join(channel);
                }
            }
        }
    }

    public User userOffline(String channel, String name) {
        User user = this.getUser(channel, name);
        if (user != null) {
            user.setOnline(false);
            this.listener.onUserRemoved(user);
        }
        return user;
    }

    public User userJoined(String channel, String name) {
        User user = this.getUser(channel, name);
        return this.userJoined(user);
    }

    public User userJoined(User user) {
        if (user.setOnline(true)) {
            user.setFirstSeen();
            if (user.getName().equals(user.getStream())) {
                user.setBroadcaster(true);
            }
            this.listener.onUserAdded(user);
        }
        return user;
    }

    public void info(String channel, String message, MsgTags tags) {
        this.listener.onInfo(this.rooms.getRoom(channel), message, tags);
    }

    public void info(Room room, String message, MsgTags tags) {
        this.listener.onInfo(room, message, tags);
    }

    public void info(String message) {
        this.listener.onInfo(message);
    }

    static /* synthetic */ String[] access$1402(TwitchConnection x0, String[] x1) {
        x0.autojoin = x1;
        return x1;
    }

    private static class SentMessages {
        private static final long TIMEOUT = 2000L;
        private final Map<String, List<Message>> messages = new HashMap<String, List<Message>>();

        private SentMessages() {
        }

        public synchronized void messageSent(String channel, String message) {
            if (!this.messages.containsKey(channel)) {
                this.messages.put(channel, new ArrayList());
            }
            this.messages.get(channel).add(new Message(channel, message));
        }

        public synchronized boolean shouldHide(String channel, String message) {
            if (this.messages.containsKey(channel)) {
                this.clearOld(channel);
                for (Message m : this.messages.get(channel)) {
                    if (!m.message.equals(message)) continue;
                    return true;
                }
            }
            return false;
        }

        private void clearOld(String channel) {
            Iterator<Message> it = this.messages.get(channel).iterator();
            while (it.hasNext()) {
                Message m = it.next();
                if (System.currentTimeMillis() - m.time <= 2000L) continue;
                it.remove();
            }
        }

        private static class Message {
            private final String channel;
            private final String message;
            private final long time = System.currentTimeMillis();

            public Message(String channel, String message) {
                this.channel = channel;
                this.message = message;
            }

            public String toString() {
                return this.channel + " " + this.message;
            }
        }
    }

    public static interface ConnectionListener {
        public void onJoinScheduled(Collection<String> var1);

        public void onJoinAttempt(Room var1);

        public void onChannelJoined(User var1);

        public void onChannelLeft(Room var1, boolean var2);

        public void onJoin(User var1);

        public void onPart(User var1);

        public void onUserAdded(User var1);

        public void onUserRemoved(User var1);

        public void onUserlistCleared(String var1);

        public void onUserUpdated(User var1);

        public void onChannelMessage(User var1, String var2, boolean var3, MsgTags var4);

        public void onWhisper(User var1, String var2, String var3);

        public void onNotice(String var1);

        public void onInfo(Room var1, String var2, MsgTags var3);

        public void onInfo(String var1);

        public void onGlobalInfo(String var1);

        public void onBan(User var1, long var2, String var4, String var5);

        public void onMsgDeleted(User var1, String var2, String var3);

        public void onRegistered();

        public void onDisconnect(int var1, String var2);

        public void onMod(User var1);

        public void onUnmod(User var1);

        public void onConnectionStateChanged(int var1);

        public void onConnectionPrepare(String var1);

        public void onConnectAttempt(String var1, int var2, boolean var3);

        public void onEmotesets(String var1, Set<String> var2);

        public void onConnectError(String var1);

        public void onJoinError(Set<String> var1, String var2, JoinError var3);

        public void onRawReceived(String var1);

        public void onRawSent(String var1);

        public void onChannelCleared(Room var1);

        public void onSubscriberNotification(User var1, String var2, String var3, int var4, MsgTags var5);

        public void onUsernotice(String var1, User var2, String var3, String var4, MsgTags var5);

        public void onSpecialMessage(String var1, String var2);

        public void onRoomId(String var1, String var2);
    }

    private class IrcConnection
    extends Irc {
        private int connectionAttempts;
        private final JoinChecker joinChecker;
        private final Set<String> joinedChannels;
        private final Set<String> rejoinChannel;
        private final String idPrefix;
        private Set<String> userlistReceived;

        public IrcConnection(String id) {
            super(id);
            this.connectionAttempts = 0;
            this.joinChecker = new JoinChecker(this);
            this.joinedChannels = Collections.synchronizedSet(new HashSet());
            this.rejoinChannel = Collections.synchronizedSet(new HashSet());
            this.userlistReceived = Collections.synchronizedSet(new HashSet());
            this.idPrefix = "[" + id + "] ";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getJoinedChannels() {
            Set<String> set = this.joinedChannels;
            synchronized (set) {
                return new HashSet<String>(this.joinedChannels);
            }
        }

        public boolean onChannel(String channel) {
            return this.joinedChannels.contains(channel);
        }

        public boolean primaryOnChannel(String channel) {
            return TwitchConnection.this.irc.onChannel(channel);
        }

        @Override
        void onUserlist(String channel, String[] nicknames) {
            if (this.isChannelOpen(channel = StringUtil.toLowerCase(channel))) {
                if (nicknames.length == 1 && nicknames[0].equalsIgnoreCase(TwitchConnection.this.username)) {
                    TwitchConnection.this.localUserJoined(channel);
                    return;
                }
                if (!this.userlistReceived.contains(channel)) {
                    this.clearUserlist(channel);
                }
                this.userlistReceived.add(channel);
                for (String nick : nicknames) {
                    TwitchConnection.this.userJoined(channel, nick);
                }
            }
        }

        @Override
        public void debug(String line) {
            LOGGER.info(this.idPrefix + line);
        }

        @Override
        void onConnectionPrepare(String server) {
            TwitchConnection.this.listener.onConnectionPrepare(server);
        }

        @Override
        void onConnectionAttempt(String server, int port, boolean secured) {
            ++this.connectionAttempts;
            if (this != TwitchConnection.this.irc) {
                return;
            }
            TwitchConnection.this.listener.onConnectAttempt(server, port, secured);
        }

        @Override
        void onConnectionAttemptCancel() {
            TwitchConnection.this.listener.onGlobalInfo(Language.getString("chat.cancelConnect"));
        }

        @Override
        void onConnect() {
            if (this == TwitchConnection.this.irc) {
                this.send("CAP REQ :twitch.tv/tags");
                this.send("CAP REQ :twitch.tv/commands");
                if (TwitchConnection.this.settings.getBoolean("membershipEnabled")) {
                    this.send("CAP REQ :twitch.tv/membership");
                }
                this.send("CAP END");
            }
            this.userlistReceived.clear();
        }

        @Override
        void onRegistered() {
            this.connectionAttempts = 1;
            if (this != TwitchConnection.this.irc) {
                return;
            }
            if (TwitchConnection.this.autojoin != null) {
                TwitchConnection.this.listener.onJoinScheduled(Arrays.asList(TwitchConnection.this.autojoin));
                for (String channel : TwitchConnection.this.autojoin) {
                    TwitchConnection.this.join(channel);
                }
                TwitchConnection.access$1402(TwitchConnection.this, null);
            } else {
                TwitchConnection.this.joinChannels(TwitchConnection.this.getOpenChannels());
            }
            TwitchConnection.this.listener.onRegistered();
        }

        @Override
        void onDisconnect(int reason, String reasonMessage) {
            this.joinedChannels.clear();
            this.joinChecker.cancelAll();
            if (this == TwitchConnection.this.irc) {
                TwitchConnection.this.channelStates.reset();
                TwitchConnection.this.listener.onGlobalInfo(Language.getString("chat.disconnected") + Helper.makeDisconnectReason(reason, reasonMessage));
                if (reason != 103) {
                    if (TwitchConnection.this.irc.shouldCancelConnecting()) {
                        TwitchConnection.this.listener.onGlobalInfo("Canceled reconnecting");
                        this.connectionAttempts = 0;
                    } else {
                        this.startReconnectTimer(reason);
                    }
                } else {
                    this.connectionAttempts = 0;
                }
                TwitchConnection.this.listener.onDisconnect(reason, reasonMessage);
            }
        }

        private void startReconnectTimer(int reason) {
            if (TwitchConnection.this.reconnectionTimer == null) {
                if ((long)this.connectionAttempts > TwitchConnection.this.maxReconnectionAttempts && TwitchConnection.this.maxReconnectionAttempts > -1L) {
                    TwitchConnection.this.listener.onGlobalInfo("Gave up reconnecting. :(");
                } else {
                    int delay = TwitchConnection.this.getReconnectionDelay(this.connectionAttempts);
                    TwitchConnection.this.listener.onGlobalInfo(String.format("Attempting to reconnect in %s seconds.. (%s/%s)", delay, ((TwitchConnection)TwitchConnection.this).irc.connectionAttempts, TwitchConnection.this.maxReconnectionAttempts < 0L ? "\u221e" : Long.valueOf(TwitchConnection.this.maxReconnectionAttempts)));
                    this.setState(-1);
                    TwitchConnection.this.reconnectionTimer = new Timer();
                    TwitchConnection.this.reconnectionTimer.schedule(TwitchConnection.this.getReconnectionTimerTask(), delay * 1000);
                }
            }
        }

        @Override
        void onJoinAttempt(String channel) {
            channel = StringUtil.toLowerCase(channel);
            this.joinChecker.joinAttempt(channel);
            if (this == TwitchConnection.this.irc) {
                TwitchConnection.this.listener.onJoinAttempt(TwitchConnection.this.rooms.getRoom(channel));
                TwitchConnection.this.openChannels.add(channel);
            }
        }

        @Override
        void onJoin(String channel, String nick) {
            channel = StringUtil.toLowerCase(channel);
            if (nick.equalsIgnoreCase(TwitchConnection.this.username)) {
                this.joinChecker.cancel(channel);
                this.debug("JOINED: " + channel);
                User user = TwitchConnection.this.userJoined(channel, nick);
                boolean onChannel = this.onChannel(channel);
                this.joinedChannels.add(channel);
                if (this == TwitchConnection.this.irc && !onChannel) {
                    TwitchConnection.this.listener.onChannelJoined(user);
                }
            } else if (this.isChannelOpen(channel)) {
                if (!this.userlistReceived.contains(channel)) {
                    this.clearUserlist(channel);
                    TwitchConnection.this.localUserJoined(channel);
                }
                User user = TwitchConnection.this.userJoined(channel, nick);
                TwitchConnection.this.listener.onJoin(user);
                this.userlistReceived.add(channel);
            }
        }

        private void clearUserlist(String channel) {
            TwitchConnection.this.users.setAllOffline(channel);
            TwitchConnection.this.listener.onUserlistCleared(channel);
        }

        public void cancelJoinAttempt(String channel) {
            this.joinChecker.cancel(channel);
        }

        @Override
        void onPart(String channel, String nick) {
            channel = StringUtil.toLowerCase(channel);
            if (nick.isEmpty()) {
                return;
            }
            if (!this.onChannel(channel)) {
                return;
            }
            if (nick.equalsIgnoreCase(TwitchConnection.this.username)) {
                boolean rejoin = false;
                this.joinChecker.cancel(channel);
                if (this == TwitchConnection.this.irc) {
                    TwitchConnection.this.userOffline(channel, nick);
                }
                this.joinedChannels.remove(channel);
                if (this == TwitchConnection.this.irc) {
                    if (this.rejoinChannel.contains(channel)) {
                        this.rejoinChannel.remove(channel);
                        TwitchConnection.this.listener.onChannelLeft(TwitchConnection.this.rooms.getRoom(channel), false);
                        rejoin = true;
                    } else {
                        TwitchConnection.this.users.clear(channel);
                        TwitchConnection.this.listener.onChannelLeft(TwitchConnection.this.rooms.getRoom(channel), true);
                    }
                    TwitchConnection.this.channelStates.reset(channel);
                }
                this.userlistReceived.remove(channel);
                this.debug("PARTED: " + channel);
                if (rejoin) {
                    this.joinChannel(channel);
                }
            } else if (this.isChannelOpen(channel)) {
                User user = TwitchConnection.this.userOffline(channel, nick);
                TwitchConnection.this.listener.onPart(user);
            }
        }

        @Override
        void onModeChange(String channel, String nick, boolean modeAdded, String mode, String prefix) {
            if (!this.onChannel(channel = StringUtil.toLowerCase(channel))) {
                return;
            }
            User user = TwitchConnection.this.getUser(channel, nick);
            if (modeAdded) {
                user.setMode(mode);
                if (mode.equals("o")) {
                    if (this == TwitchConnection.this.irc) {
                        TwitchConnection.this.listener.onMod(user);
                    }
                    if (!TwitchConnection.this.isUserlistLoaded(channel)) {
                        TwitchConnection.this.userJoined(user);
                    }
                }
            } else {
                user.setMode("");
                if (mode.equals("o") && this == TwitchConnection.this.irc) {
                    TwitchConnection.this.listener.onUnmod(user);
                }
            }
            if (user.isOnline()) {
                TwitchConnection.this.listener.onUserUpdated(user);
            }
        }

        private void updateUserFromTags(User user, MsgTags tags) {
            boolean changed = UserTagsUtil.updateUserFromTags(user, tags);
            if (changed && user != TwitchConnection.this.users.specialUser) {
                TwitchConnection.this.listener.onUserUpdated(user);
            }
        }

        @Override
        void onChannelMessage(String channel, String nick, String from, String text, MsgTags tags, boolean action) {
            channel = StringUtil.toLowerCase(channel);
            if (this != TwitchConnection.this.irc) {
                return;
            }
            if (nick.isEmpty()) {
                return;
            }
            if (this.onChannel(channel)) {
                if (TwitchConnection.this.settings.getBoolean("twitchnotifyAsInfo") && nick.equals("twitchnotify")) {
                    TwitchConnection.this.info(channel, "[Notification] " + text, tags);
                } else {
                    User user = TwitchConnection.this.userJoined(channel, nick);
                    this.updateUserFromTags(user, tags);
                    if (!user.getName().equals(TwitchConnection.this.username) || !TwitchConnection.this.sentMessages.shouldHide(channel, text)) {
                        TwitchConnection.this.listener.onChannelMessage(user, text, action, tags);
                    }
                }
            }
        }

        @Override
        void onNotice(String nick, String from, String text) {
            if (this != TwitchConnection.this.irc) {
                return;
            }
            TwitchConnection.this.listener.onNotice(text);
        }

        @Override
        void onNotice(String channel, String text, MsgTags tags) {
            channel = StringUtil.toLowerCase(channel);
            if (this != TwitchConnection.this.irc) {
                return;
            }
            String msg_id = tags.get("msg-id");
            if (msg_id != null && msg_id.startsWith("whisper_")) {
                TwitchConnection.this.listener.onInfo(text);
            } else if (this.onChannel(channel)) {
                this.infoMessage(channel, text, tags);
            } else if (this.isChannelOpen(channel)) {
                this.infoMessage(channel, text, tags);
                Room room = TwitchConnection.this.rooms.getRoom(channel);
                if (room.isChatroom() && tags.isValue("msg-id", "no_permission")) {
                    TwitchConnection.this.info(room, "Cancelled trying to join channel.", null);
                    this.joinChecker.cancel(channel);
                }
            } else {
                TwitchConnection.this.listener.onInfo(String.format("[Info/%s] %s", TwitchConnection.this.rooms.getRoom(channel), text));
            }
        }

        @Override
        void onUsernotice(String channel, String message, MsgTags tags) {
            if (tags.isEmpty()) {
                return;
            }
            if (!this.onChannel(channel)) {
                return;
            }
            if (tags.isValue("msg-id", "sharedchatnotice")) {
                tags = MsgTags.addTag(tags, "msg-id", tags.get("source-msg-id"));
            }
            String login = tags.get("login");
            String text = StringUtil.removeLinebreakCharacters(tags.get("system-msg"));
            int months = tags.getInteger("msg-param-cumulative-months", -1);
            if (months == -1) {
                months = tags.getInteger("msg-param-months", -1);
            }
            int giftMonths = tags.getInteger("msg-param-gift-months", -1);
            if (tags.isValue("msg-id", "announcement") && !StringUtil.isNullOrEmpty(login)) {
                String displayName = tags.get("display-name", login);
                text = String.format("<%s> ", displayName);
            }
            if (StringUtil.isNullOrEmpty(login, text)) {
                return;
            }
            User user = TwitchConnection.this.userJoined(channel, login);
            this.updateUserFromTags(user, tags);
            if (tags.isValueOf("msg-id", "resub", "sub", "subgift", "anonsubgift")) {
                text = text.trim();
                if (giftMonths > 1 && !text.matches(".* gifted " + giftMonths + " .*")) {
                    text = text + " It's a " + giftMonths + "-month gift!";
                }
                if (months > 1 && !text.matches(".*\\b" + months + "\\b.*")) {
                    String recipient = tags.get("msg-param-recipient-display-name");
                    recipient = StringUtil.isNullOrEmpty(recipient) ? "They've" : recipient + " has";
                    text = text + " " + recipient + " subscribed for " + months + " months!";
                }
                TwitchConnection.this.listener.onSubscriberNotification(user, text, message, months, tags);
            } else if (tags.isValue("msg-id", "charity") && login.equals("twitch")) {
                TwitchConnection.this.listener.onUsernotice("Charity", user, text, message, tags);
            } else if (tags.isValue("msg-id", "raid")) {
                TwitchConnection.this.listener.onUsernotice("Raid", user, text, message, tags);
            } else if (text.equals("reward") && !message.isEmpty()) {
                TwitchConnection.this.listener.onUsernotice("Usernotice", user, message, null, tags);
            } else if (tags.isValueOf("msg-id", "bitsbadgetier") && text.equals("bits badge tier notification") && tags.hasInteger("msg-param-threshold")) {
                text = String.format("%s just earned a new %,d Bits badge!", user.getDisplayNick(), tags.getInteger("msg-param-threshold", -1));
                TwitchConnection.this.listener.onUsernotice("Usernotice", user, text, null, tags);
            } else if (tags.isValueOf("msg-id", "announcement")) {
                TwitchConnection.this.listener.onUsernotice("Announcement", user, text, message, tags);
            } else {
                TwitchConnection.this.listener.onUsernotice("Usernotice", user, text, message, tags);
            }
        }

        @Override
        void onQueryMessage(String nick, String from, String text) {
            if (this != TwitchConnection.this.irc) {
                return;
            }
            if (nick.startsWith("*")) {
                TwitchConnection.this.listener.onSpecialMessage(nick, text);
            }
            if (nick.equals("jtv")) {
                TwitchConnection.this.listener.onInfo("[Info] " + text);
            }
        }

        private void infoMessage(String channel, String text, MsgTags tags) {
            if (text.startsWith("The moderators of")) {
                this.parseModeratorsList(text, channel);
            } else {
                TwitchConnection.this.info(channel, "[Info] " + text, tags);
            }
            if (text.startsWith("The VIPs of this channel are")) {
                List<String> vipsList = TwitchCommands.parseModsList(text);
                TwitchConnection.this.info(channel, "There are " + vipsList.size() + " VIPs on this channel.", null);
            }
        }

        private void parseModeratorsList(String text, String channel) {
            List<String> modsList = TwitchCommands.parseModsList(text);
            TwitchConnection.this.users.modsListReceived(TwitchConnection.this.rooms.getRoom(channel), modsList);
            if (!TwitchConnection.this.twitchCommands.waitingForModsSilent() || channel != null && !TwitchConnection.this.twitchCommands.removeModsSilent(channel)) {
                TwitchConnection.this.info(channel, "[Info] " + text, null);
                if (modsList.size() > 0) {
                    TwitchConnection.this.info(channel, "There are " + modsList.size() + " mods for this channel.", null);
                } else {
                    TwitchConnection.this.info(channel, "There are no mods for this channel.", null);
                }
            } else {
                this.debug("Silent mods list (" + channel + ")");
            }
        }

        private void channelCleared(String channel) {
            TwitchConnection.this.listener.onChannelCleared(TwitchConnection.this.rooms.getRoom(channel));
        }

        @Override
        void onWhoResponse(String channel, String nickname) {
        }

        @Override
        protected void setState(int state) {
            super.setState(state);
            TwitchConnection.this.listener.onConnectionStateChanged(state);
        }

        public boolean isChannelOpen(String channel) {
            return TwitchConnection.this.openChannels.contains(channel);
        }

        @Override
        public void raw(String text) {
            TwitchConnection.this.listener.onRawReceived(this.idPrefix + text);
        }

        @Override
        public void sent(String text) {
            if (text.startsWith("PASS")) {
                TwitchConnection.this.listener.onRawSent(this.idPrefix + "PASS <password>");
            } else {
                TwitchConnection.this.listener.onRawSent(this.idPrefix + text);
            }
        }

        @Override
        public void onUserstate(String channel, MsgTags tags) {
            if (this.onChannel(channel = StringUtil.toLowerCase(channel))) {
                this.updateUserstate(channel, tags);
            }
        }

        @Override
        public void onGlobalUserstate(MsgTags tags) {
            this.updateUserstate(null, tags);
        }

        private void updateUserstate(String channel, MsgTags tags) {
            if (channel != null) {
                User user = TwitchConnection.this.localUserJoined(channel);
                this.updateUserFromTags(user, tags);
            } else {
                for (User user : TwitchConnection.this.users.getUsersByName(TwitchConnection.this.username)) {
                    this.updateUserFromTags(user, tags);
                }
            }
            this.updateUserFromTags(TwitchConnection.this.users.specialUser, tags);
            TwitchConnection.this.listener.onEmotesets(channel, Emoticons.parseEmotesets(tags.get("emote-sets")));
        }

        @Override
        public void onClearChat(MsgTags tags, String channel, String nick) {
            channel = StringUtil.toLowerCase(channel);
            if (nick != null) {
                User user = TwitchConnection.this.users.getUserIfExists(channel, nick);
                if (user != null) {
                    long duration = tags.getLong("ban-duration", -1L);
                    String reason = tags.get("ban-reason", "");
                    String targetMsgId = tags.get("target-msg-id", null);
                    if (this.isChannelOpen(user.getChannel())) {
                        TwitchConnection.this.listener.onBan(user, duration, reason, targetMsgId);
                    }
                }
            } else {
                this.channelCleared(channel);
            }
        }

        @Override
        public void onClearMsg(MsgTags tags, String channel, String msg) {
            User user;
            String targetMsgId;
            channel = StringUtil.toLowerCase(channel);
            String login = tags.get("login");
            if (!StringUtil.isNullOrEmpty(login, targetMsgId = tags.get("target-msg-id")) && (user = TwitchConnection.this.users.getUserIfExists(channel, login)) != null) {
                TwitchConnection.this.listener.onMsgDeleted(user, targetMsgId, msg);
            }
        }

        @Override
        public void onChannelCommand(MsgTags tags, String nick, String channel, String command, String trailing) {
            channel = StringUtil.toLowerCase(channel);
            if (command.equals("ROOMSTATE")) {
                if (!tags.isEmpty()) {
                    if (tags.containsKey("r9k")) {
                        TwitchConnection.this.channelStates.setR9kMode(channel, tags.isTrue("r9k"));
                    }
                    if (tags.containsKey("emote-only")) {
                        TwitchConnection.this.channelStates.setEmoteOnly(channel, tags.isTrue("emote-only"));
                    }
                    if (tags.containsKey("subs-only")) {
                        TwitchConnection.this.channelStates.setSubmode(channel, tags.isTrue("subs-only"));
                    }
                    if (tags.containsKey("slow")) {
                        TwitchConnection.this.channelStates.setSlowmode(channel, tags.get("slow"));
                    }
                    if (tags.containsKey("broadcaster-lang")) {
                        TwitchConnection.this.channelStates.setLang(channel, tags.get("broadcaster-lang"));
                    }
                    if (tags.containsKey("followers-only")) {
                        TwitchConnection.this.channelStates.setFollowersOnly(channel, tags.get("followers-only"));
                    }
                    if (tags.hasValue("room-id")) {
                        TwitchConnection.this.listener.onRoomId(channel, tags.get("room-id"));
                        if (Helper.isRegularChannel(channel)) {
                            Room roomWithId = Room.createRegularWithId(channel, tags.get("room-id"));
                            TwitchConnection.this.rooms.addRoom(roomWithId);
                        }
                    }
                }
            } else if (command.equals("SERVERCHANGE")) {
                TwitchConnection.this.info(TwitchConnection.this.rooms.getRoom(channel), "*** You may be on the wrong server for this channel. Enter /fixserver to connect to the correct server (which may cause other channels to not work anymore, because Chatty only supports one main connection to a single server). ***", null);
            }
        }

        @Override
        public void onCommand(String nick, String command, String parameter, String text, MsgTags tags) {
            if (nick.isEmpty()) {
                return;
            }
            if (command.equals("WHISPER")) {
                User user = TwitchConnection.this.userJoined("$[whisper]", nick);
                this.updateUserFromTags(user, tags);
                TwitchConnection.this.listener.onWhisper(user, text, tags.get("emotes"));
            }
        }

        private class GiftedSubCombiner {
            private final int MAX_RECIPIENTS_PER_MESSAGE = 20;
            private final int COMBINE_INTERVAL = 1000;
            private final List<String> recipients = new ArrayList<String>();
            private User gifter;
            private String subPlan;
            private String text;
            private Timer timer;

            private GiftedSubCombiner() {
            }

            public synchronized void add(User user, String text, String message, int months, String emotes, MsgTags tags) {
                String recipient = tags.get("msg-param-recipient-display-name");
                String plan = tags.get("msg-param-sub-plan");
                boolean outputDirectly = false;
                if (message != null && !message.isEmpty()) {
                    outputDirectly = true;
                }
                if (recipient == null || plan == null) {
                    outputDirectly = true;
                }
                if (outputDirectly) {
                    this.flush();
                    TwitchConnection.this.listener.onSubscriberNotification(user, text, message, months, tags);
                    return;
                }
                if (this.gifter != user || !this.subPlan.equals(plan)) {
                    this.flush();
                }
                if (this.recipients.size() == 20) {
                    this.flush();
                }
                this.gifter = user;
                this.subPlan = plan;
                this.recipients.add(recipient);
                if (this.recipients.size() == 1) {
                    this.text = text;
                    this.timer = new Timer(true);
                    this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            GiftedSubCombiner.this.flush();
                        }
                    }, 1000L);
                }
            }

            private synchronized void flush() {
                if (this.recipients.isEmpty()) {
                    return;
                }
                StringBuilder b = new StringBuilder(this.text);
                if (this.recipients.size() > 1) {
                    b.append(" And also to: ");
                    for (int i = 1; i < this.recipients.size(); ++i) {
                        String displayName = this.recipients.get(i);
                        if (i > 1) {
                            b.append(", ");
                        }
                        b.append(displayName);
                    }
                    b.append(" (").append(this.recipients.size()).append(" total)");
                }
                TwitchConnection.this.listener.onSubscriberNotification(this.gifter, b.toString(), null, -1, MsgTags.EMPTY);
                this.gifter = null;
                this.text = null;
                this.subPlan = null;
                this.recipients.clear();
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    public static enum JoinError {
        NOT_REGISTERED,
        ALREADY_JOINED,
        INVALID_NAME,
        ROOM;

    }
}

