/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Addressbook;
import chatty.AddressbookEntry;
import chatty.Helper;
import chatty.Room;
import chatty.gui.Highlighter;
import chatty.gui.NamedColor;
import chatty.gui.colors.UsercolorManager;
import chatty.gui.components.textpane.ModLogInfo;
import chatty.util.Debugging;
import chatty.util.StringUtil;
import chatty.util.api.eventsub.payloads.ModActionPayload;
import chatty.util.api.eventsub.payloads.SuspiciousMessagePayload;
import chatty.util.api.usericons.Usericon;
import chatty.util.api.usericons.UsericonManager;
import chatty.util.colors.HtmlColors;
import chatty.util.irc.IrcBadges;
import chatty.util.irc.MsgTags;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class User
implements Comparable<User> {
    private static final NamedColor[] defaultColors = new NamedColor[]{new NamedColor("Red", 255, 0, 0), new NamedColor("Blue", 0, 0, 255), new NamedColor("Green", 0, 255, 0), new NamedColor("FireBrick", 178, 34, 34), new NamedColor("Coral", 255, 127, 80), new NamedColor("YellowGreen", 154, 205, 50), new NamedColor("OrangeRed", 255, 69, 0), new NamedColor("SeaGreen", 46, 139, 87), new NamedColor("GoldenRod", 218, 165, 32), new NamedColor("Chocolate", 210, 105, 30), new NamedColor("CadetBlue", 95, 158, 160), new NamedColor("DodgerBlue", 30, 144, 255), new NamedColor("HotPink", 255, 105, 180), new NamedColor("BlueViolet", 138, 43, 226), new NamedColor("SpringGreen", 0, 255, 127)};
    public static volatile int MSG_ID;
    private UserSettings userSettings = UserSettings.EMPTY;
    private long firstSeen = -1L;
    private volatile String id;
    private Room room;
    private volatile String nick;
    private String displayNick;
    private boolean hasDisplayNickSet;
    private String customNick;
    private String fullNick;
    private boolean hasRegularDisplayNick;
    private IrcBadges twitchBadges;
    private short subMonths;
    private Color color = HtmlColors.decode("");
    private Color correctedColor = HtmlColors.decode("");
    private boolean hasDefaultColor = true;
    private boolean hasCorrectedColor;
    private boolean hasCustomColor;
    private boolean localUser;
    private boolean online;
    private boolean isModerator;
    private boolean isBroadcaster;
    private boolean isAdmin;
    private boolean isStaff;
    private boolean hasTurbo;
    private boolean isSubscriber;
    private boolean isBot;
    private boolean isVip;
    private List<Message> lines;
    private int numberOfMessages;
    private int numberOfLines;
    private long lastHighlight = -1L;
    private List<ModActionPayload> cachedBanInfo;
    private static final int BAN_INFO_WAIT = 1000;
    private List<SuspiciousMessagePayload> cachedLowTrust;

    public User(String nick, Room room) {
        this(nick, null, null, room);
    }

    public User(String nick, String displayNick, Room room) {
        this(nick, null, displayNick, room);
    }

    public User(String nick, String capitalizedNick, String displayNick, Room room) {
        this.nick = StringUtil.toLowerCase(nick);
        this.displayNick = displayNick;
        if (this.displayNick == null) {
            this.displayNick = capitalizedNick != null ? capitalizedNick : nick;
        }
        this.hasDisplayNickSet = displayNick != null;
        this.checkForRegularDisplayNick();
        this.room = room;
        this.setDefaultColor();
        this.updateFullNick();
    }

    public synchronized void setUserSettings(UserSettings settings) {
        if (settings != null) {
            this.userSettings = settings;
        }
    }

    public synchronized boolean setTwitchBadges(IrcBadges badges) {
        if (!Objects.equals(badges, this.twitchBadges)) {
            this.twitchBadges = badges;
            this.updateFullNick();
            return true;
        }
        return false;
    }

    public synchronized IrcBadges getTwitchBadges() {
        return this.twitchBadges;
    }

    public synchronized boolean hasTwitchBadge(String id) {
        return this.twitchBadges != null && this.twitchBadges.hasId(id);
    }

    public synchronized boolean hasTwitchBadge(String id, String version) {
        return this.twitchBadges != null && this.twitchBadges.hasIdVersion(id, version);
    }

    public List<Usericon> getBadges(boolean botBadgeEnabled, MsgTags tags, User localUser, int channelLogoSize) {
        IrcBadges badges = this.getTwitchBadges();
        if (this.userSettings.iconManager != null) {
            return this.userSettings.iconManager.getBadges(badges, this, localUser, botBadgeEnabled, tags, channelLogoSize);
        }
        return null;
    }

    public UsericonManager getUsericonManager() {
        return this.userSettings.iconManager;
    }

    public synchronized void setSubMonths(short months) {
        this.subMonths = months;
    }

    public synchronized short getSubMonths() {
        return this.subMonths;
    }

    public Set<String> getCategories() {
        AddressbookEntry entry;
        if (this.userSettings.addressbook != null && (entry = this.userSettings.addressbook.get(this.nick)) != null) {
            return entry.getCategories();
        }
        return null;
    }

    public List<String> getPresetCategories() {
        if (this.userSettings.addressbook != null) {
            return this.userSettings.addressbook.getCategories();
        }
        return null;
    }

    public boolean hasCategory(String category) {
        return this.hasCategory(category, this.nick);
    }

    public boolean hasCategory(String category, String name) {
        AddressbookEntry entry;
        if (this.userSettings.addressbook != null && (entry = this.userSettings.addressbook.get(name)) != null) {
            return entry.hasCategory(category);
        }
        return false;
    }

    public Addressbook getAddressbook() {
        return this.userSettings.addressbook;
    }

    public synchronized String getChannel() {
        return this.room.getChannel();
    }

    public synchronized String getOwnerChannel() {
        return this.room.getOwnerChannel();
    }

    public synchronized String getStream() {
        return this.room.getStream();
    }

    public synchronized Room getRoom() {
        return this.room;
    }

    public synchronized void setRoom(Room room) {
        if (room != this.room && room.sameChannel(this.room)) {
            this.room = room;
        }
    }

    public synchronized long getFirstSeen() {
        return this.firstSeen;
    }

    public synchronized void setFirstSeen() {
        if (this.firstSeen == -1L) {
            this.firstSeen = System.currentTimeMillis();
        }
    }

    public synchronized int getNumberOfMessages() {
        return this.numberOfMessages;
    }

    public synchronized int getNumberOfLines() {
        return this.numberOfLines;
    }

    public synchronized int getMaxNumberOfLines() {
        return this.userSettings.maxLines;
    }

    public synchronized boolean linesCleared() {
        int numLines = this.lines != null ? this.lines.size() : 0;
        return numLines < this.userSettings.maxLines && numLines < this.numberOfLines;
    }

    public synchronized boolean maxLinesExceeded() {
        int numLines = this.lines != null ? this.lines.size() : 0;
        return numLines == this.userSettings.maxLines && numLines < this.numberOfLines;
    }

    public synchronized void addMessage(String line, boolean action, String id) {
        this.addMessage(line, action, id, null, null, System.currentTimeMillis());
    }

    public synchronized void addMessage(String line, boolean action, String id, String sourceId, String sourceChannel, long timestamp) {
        if (timestamp == -1L) {
            timestamp = System.currentTimeMillis();
        }
        this.setFirstSeen();
        if (sourceId != null && !sourceId.equals(id)) {
            this.addLine(new SharedTextMessage(timestamp, line, action, id, sourceId, sourceChannel, null));
        } else {
            this.addLine(new TextMessage(timestamp, line, action, id, null));
        }
        this.replayCachedLowTrust();
        ++this.numberOfMessages;
    }

    public synchronized void addBan(long duration, String reason, String id) {
        this.addLine(new BanMessage(System.currentTimeMillis(), duration, reason, id, null));
        this.replayCachedBanInfo();
    }

    public synchronized void addUnban(int type, String by, String sourceChannel) {
        if (sourceChannel != null) {
            this.addLine(new SharedUnbanMessage(System.currentTimeMillis(), type, by, sourceChannel));
        } else {
            this.addLine(new UnbanMessage(System.currentTimeMillis(), type, by));
        }
    }

    public synchronized void addMsgDeleted(String targetMsgId, String msg) {
        this.addLine(new MsgDeleted(System.currentTimeMillis(), targetMsgId, msg, null));
        this.replayCachedBanInfo();
    }

    public synchronized void addSub(String message, String text, String id, String sourceId, String sourceChannel) {
        this.setFirstSeen();
        if (sourceId != null && !sourceId.equals(id)) {
            this.addLine(new SharedSubMessage(System.currentTimeMillis(), message, text, id, sourceId, sourceChannel));
        } else {
            this.addLine(new SubMessage(System.currentTimeMillis(), message, text, id));
        }
    }

    public synchronized void addInfo(String message, String fullText, boolean isShared, String sourceChannel) {
        this.setFirstSeen();
        if (isShared) {
            this.addLine(new SharedInfoMessage(System.currentTimeMillis(), message, fullText, sourceChannel));
        } else {
            this.addLine(new InfoMessage(System.currentTimeMillis(), message, fullText));
        }
    }

    public synchronized void addWarning(String reason, String by) {
        this.setFirstSeen();
        this.addLine(new WarnMessage(System.currentTimeMillis(), reason, by));
    }

    public synchronized void addWarningAcknowledged() {
        this.setFirstSeen();
        this.addLine(new WarnMessage(System.currentTimeMillis(), null, null));
    }

    public synchronized void addModAction(ModActionPayload data) {
        this.setFirstSeen();
        if (data.created_by.equals(this.nick)) {
            if (data.isShared()) {
                this.addLine(new SharedModAction(System.currentTimeMillis(), data.getPseudoCommandString(), data.getSourceChannel()));
            } else {
                this.addLine(new ModAction(System.currentTimeMillis(), data.getPseudoCommandString()));
            }
        } else if (ModLogInfo.getTargetUserInfo(data) != null) {
            if (data.isShared()) {
                this.addLine(new SharedModAction(System.currentTimeMillis(), ModLogInfo.getTargetUserInfo(data), data.getSourceChannel()));
            } else {
                this.addLine(new ModAction(System.currentTimeMillis(), ModLogInfo.getTargetUserInfo(data)));
            }
        }
    }

    public synchronized void addBanInfo(ModActionPayload data) {
        if (!this.addBanInfoNow(data)) {
            Debugging.println("modlog", "[UserModLogInfo] Caching: %s", data.getPseudoCommandString());
            if (this.cachedBanInfo == null) {
                this.cachedBanInfo = new ArrayList<ModActionPayload>();
            }
            this.cachedBanInfo.add(data);
        }
    }

    private synchronized void replayCachedBanInfo() {
        if (this.cachedBanInfo == null) {
            return;
        }
        Debugging.println("modlog", "[UserModLogInfo] Replaying: %s", this.cachedBanInfo);
        Iterator<ModActionPayload> it = this.cachedBanInfo.iterator();
        while (it.hasNext()) {
            ModActionPayload data = it.next();
            if (System.currentTimeMillis() - data.created_at > 1000L) {
                it.remove();
                Debugging.println("modlog", "[UserModLogInfo] Abandoned: %s", data);
                continue;
            }
            if (!this.addBanInfoNow(data)) continue;
            it.remove();
            Debugging.println("modlog", "[UserModLogInfo] Added: %s", data);
        }
        if (this.cachedBanInfo.isEmpty()) {
            this.cachedBanInfo = null;
        }
    }

    private synchronized boolean addBanInfoNow(ModActionPayload data) {
        if (this.lines == null) {
            return false;
        }
        String command = ModLogInfo.makeCommand(data);
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            Message m = this.lines.get(i);
            if (System.currentTimeMillis() - m.getTime() > 1000L) {
                return false;
            }
            if (m instanceof BanMessage) {
                BanMessage bm = (BanMessage)m;
                if (bm.by != null || !command.equals(Helper.makeBanCommand(this, bm.duration, bm.id))) continue;
                this.lines.set(i, bm.addModLogInfo(data.created_by, ModLogInfo.getReason(data), data.getSourceChannel()));
                return true;
            }
            if (!(m instanceof MsgDeleted)) continue;
            MsgDeleted md = (MsgDeleted)m;
            if (md.by != null || !command.equals(Helper.makeBanCommand(this, -2L, md.targetMsgId))) continue;
            this.lines.set(i, md.addModLogInfo(data.created_by, data.getSourceChannel()));
            return true;
        }
        return false;
    }

    public synchronized void addLowTrust(SuspiciousMessagePayload data) {
        if (!this.addLowTrustNow(data)) {
            if (this.cachedLowTrust == null) {
                this.cachedLowTrust = new ArrayList<SuspiciousMessagePayload>();
            }
            this.cachedLowTrust.add(data);
        }
    }

    private synchronized void replayCachedLowTrust() {
        if (this.cachedLowTrust == null) {
            return;
        }
        Iterator<SuspiciousMessagePayload> it = this.cachedLowTrust.iterator();
        while (it.hasNext()) {
            SuspiciousMessagePayload data = it.next();
            if (System.currentTimeMillis() - data.created_at > 1000L) {
                it.remove();
                continue;
            }
            if (!this.addLowTrustNow(data)) continue;
            it.remove();
        }
        if (this.cachedLowTrust.isEmpty()) {
            this.cachedLowTrust = null;
        }
    }

    private synchronized boolean addLowTrustNow(SuspiciousMessagePayload data) {
        if (this.lines == null) {
            return false;
        }
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            Message m = this.lines.get(i);
            if (System.currentTimeMillis() - m.getTime() > 1000L) {
                return false;
            }
            if (!(m instanceof TextMessage)) continue;
            TextMessage tm = (TextMessage)m;
            if (tm.id == null || !tm.id.equals(data.aboutMessageId)) continue;
            this.lines.set(i, tm.addLowTrust(data));
            return true;
        }
        return false;
    }

    public synchronized void addAutoModMessage(String line, String id, String reason, ModActionPayload.Type type, String moderatorName) {
        this.addLine(new AutoModMessage(line, id, reason, type, moderatorName));
    }

    private void addLine(Message line) {
        if (this.lines == null) {
            this.lines = new ArrayList<Message>(1);
        }
        this.lines.add(line);
        if (this.lines.size() > this.userSettings.maxLines) {
            this.lines.remove(0);
        }
        ++this.numberOfLines;
    }

    public synchronized List<Message> getMessages() {
        if (this.lines == null) {
            return new ArrayList<Message>();
        }
        return new ArrayList<Message>(this.lines);
    }

    public synchronized int getNumberOfSimilarChatMessages(String compareMsg, int method, long timeframe, float minSimilarity, int minLen, char[] ignoredChars) {
        if (this.lines == null) {
            return 0;
        }
        compareMsg = StringUtil.prepareForSimilarityComparison(compareMsg, ignoredChars);
        int result = 0;
        long checkUntilTime = System.currentTimeMillis() - timeframe * 1000L;
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            String text;
            Message m = this.lines.get(i);
            if (!(m instanceof TextMessage)) continue;
            TextMessage msg = (TextMessage)m;
            if (msg.getTime() < checkUntilTime) break;
            if (msg.text.length() < minLen || !(StringUtil.checkSimilarity(compareMsg, text = StringUtil.prepareForSimilarityComparison(msg.text, ignoredChars), minSimilarity, method) > 0.0f)) continue;
            ++result;
        }
        return result;
    }

    public synchronized int getMatchingMessages(Highlighter.HighlightItem item, int num, long time, boolean beforeTime) {
        if (this.lines == null) {
            return 0;
        }
        int result = 0;
        int numMsgs = 0;
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            Message m = this.lines.get(i);
            if (beforeTime) {
                if (m.time > time) {
                    continue;
                }
            } else if (m.time < time) {
                return result;
            }
            if (!(m instanceof TextMessage)) continue;
            TextMessage tm = (TextMessage)m;
            if (item.matchesTextOnly(tm.text, null)) {
                ++result;
            }
            if (++numMsgs != num) continue;
            return result;
        }
        return result;
    }

    public synchronized int getNumberOfMessagesAfterBan() {
        if (this.lines == null) {
            return -1;
        }
        int msgsAfterBan = 0;
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            Message m = this.lines.get(i);
            if (m instanceof TextMessage) {
                ++msgsAfterBan;
                continue;
            }
            if (!(m instanceof BanMessage)) continue;
            return msgsAfterBan;
        }
        return -1;
    }

    public synchronized TextMessage getMessage(String msgId) {
        if (msgId == null) {
            return null;
        }
        if (this.lines == null) {
            return null;
        }
        for (Message msg : this.lines) {
            if (!(msg instanceof TextMessage)) continue;
            TextMessage textMsg = (TextMessage)msg;
            if (!msgId.equals(textMsg.id)) continue;
            return textMsg;
        }
        return null;
    }

    public synchronized SubMessage getSubMessage(String msgId) {
        if (msgId == null) {
            return null;
        }
        if (this.lines == null) {
            return null;
        }
        for (Message msg : this.lines) {
            if (!(msg instanceof SubMessage)) continue;
            SubMessage textMsg = (SubMessage)msg;
            if (!msgId.equals(textMsg.id)) continue;
            return textMsg;
        }
        return null;
    }

    public String getMessageText(String msgId) {
        TextMessage msg = this.getMessage(msgId);
        if (msg != null) {
            return msg.text;
        }
        SubMessage subMsg = this.getSubMessage(msgId);
        if (subMsg != null) {
            return subMsg.attached_message;
        }
        return null;
    }

    public synchronized AutoModMessage getAutoModMessage(String msgId) {
        if (msgId == null) {
            return null;
        }
        if (this.lines == null) {
            return null;
        }
        for (Message msg : this.lines) {
            if (!(msg instanceof AutoModMessage)) continue;
            AutoModMessage autoModMsg = (AutoModMessage)msg;
            if (!msgId.equals(autoModMsg.id)) continue;
            return autoModMsg;
        }
        return null;
    }

    public String getAutoModMessageText(String msgId) {
        AutoModMessage msg = this.getAutoModMessage(msgId);
        return msg != null ? msg.message : null;
    }

    public synchronized int clearLinesIfInactive(long duration) {
        if (this.lines != null && !this.lines.isEmpty() && System.currentTimeMillis() - this.getLastLineTime() >= duration) {
            int size = this.lines.size();
            this.lines = null;
            return size;
        }
        return 0;
    }

    public synchronized void clearLines() {
        this.lines = null;
        this.numberOfMessages = 0;
        this.numberOfLines = 0;
    }

    public synchronized void clearNumberOfMessages() {
        this.numberOfMessages = 0;
    }

    private long getLastLineTime() {
        if (this.lines != null && !this.lines.isEmpty()) {
            return this.lines.get(this.lines.size() - 1).time;
        }
        return -1L;
    }

    public synchronized String getName() {
        return this.nick;
    }

    public synchronized String getId() {
        return this.id;
    }

    public synchronized void setId(String id) {
        if (id != null) {
            this.id = id;
        }
    }

    public synchronized String getDisplayNick() {
        return this.displayNick;
    }

    public synchronized String getRegularDisplayNick() {
        if (this.hasRegularDisplayNick) {
            return this.displayNick;
        }
        return this.nick;
    }

    public synchronized boolean hasRegularDisplayNick() {
        return this.hasRegularDisplayNick;
    }

    public synchronized boolean setDisplayNick(String newDisplayNick) {
        if (newDisplayNick == null || newDisplayNick.isEmpty()) {
            return false;
        }
        this.hasDisplayNickSet = true;
        if (this.displayNick != null && this.displayNick.equals(newDisplayNick)) {
            return false;
        }
        this.displayNick = newDisplayNick;
        this.updateFullNick();
        this.checkForRegularDisplayNick();
        return true;
    }

    private void checkForRegularDisplayNick() {
        this.hasRegularDisplayNick = this.displayNick != null && this.displayNick.equalsIgnoreCase(this.nick);
    }

    public synchronized boolean hasDisplayNickSet() {
        return this.hasDisplayNickSet;
    }

    public synchronized String getCustomNick() {
        if (this.customNick != null) {
            return this.customNick;
        }
        return this.getDisplayNick();
    }

    public synchronized void setCustomNick(String nick) {
        this.customNick = nick;
        this.updateFullNick();
    }

    public synchronized boolean hasCustomNickSet() {
        return this.customNick != null;
    }

    public synchronized Color getColor() {
        if (this.userSettings.colorManager != null) {
            Color result = this.userSettings.colorManager.getColor(this);
            if (result != null) {
                this.hasCustomColor = true;
                return result;
            }
            this.hasCustomColor = false;
        }
        return this.color;
    }

    public synchronized Color getDisplayColor() {
        Color color = this.getColor();
        if (!this.hasCustomColor() && this.hasCorrectedColor()) {
            return this.correctedColor;
        }
        return color;
    }

    public synchronized Color getDisplayColor2() {
        Color color = this.getColor();
        if (this.hasCustomColor) {
            return color;
        }
        if (this.hasCorrectedColor) {
            return this.correctedColor;
        }
        return null;
    }

    public synchronized Color getPlainColor() {
        return this.color;
    }

    public synchronized boolean hasCustomColor() {
        return this.hasCustomColor;
    }

    public synchronized Color getCorrectedColor() {
        return this.correctedColor;
    }

    public synchronized boolean hasCorrectedColor() {
        return this.hasCorrectedColor;
    }

    public synchronized void setColor(Color color) {
        this.hasDefaultColor = false;
        this.color = color;
    }

    public synchronized void setColor(String htmlColor) {
        this.setColor(HtmlColors.decode(htmlColor));
    }

    public synchronized void setCorrectedColor(Color color) {
        this.correctedColor = color;
        this.hasCorrectedColor = true;
    }

    public synchronized boolean hasDefaultColor() {
        return this.hasDefaultColor;
    }

    private void setDefaultColor() {
        if (this.nick.isEmpty()) {
            return;
        }
        String name = StringUtil.toLowerCase(this.nick);
        int n = name.codePointAt(0) + name.codePointAt(name.length() - 1);
        this.color = defaultColors[n % defaultColors.length];
        this.hasDefaultColor = true;
    }

    public synchronized boolean setOnline(boolean online) {
        if (online != this.online) {
            this.online = online;
            return true;
        }
        return false;
    }

    public synchronized boolean isOnline() {
        return this.online;
    }

    @Override
    public synchronized int compareTo(User u) {
        int broadcaster = 16;
        int admin = 8;
        int moderator = 4;
        int vip = 2;
        int subscriber = 1;
        int result = 0;
        if (this.isAdmin() || this.isStaff()) {
            result -= admin;
        }
        if (u.isAdmin() || u.isStaff()) {
            result += admin;
        }
        if (this.isBroadcaster()) {
            result -= broadcaster;
        }
        if (u.isBroadcaster()) {
            result += broadcaster;
        }
        if (this.isSubscriber()) {
            result -= subscriber;
        }
        if (u.isSubscriber()) {
            result += subscriber;
        }
        if (this.isModerator()) {
            result -= moderator;
        }
        if (u.isModerator()) {
            result += moderator;
        }
        if (this.isVip()) {
            result -= vip;
        }
        if (u.isVip()) {
            result += vip;
        }
        if (result == 0) {
            return this.nick.compareTo(u.nick);
        }
        return result;
    }

    public synchronized String toString() {
        return this.fullNick;
    }

    public synchronized String getFullNick() {
        return this.fullNick;
    }

    public synchronized void setMode(String mode) {
        if (mode.equals("o")) {
            this.setModerator(true);
        } else {
            this.setModerator(false);
        }
    }

    public synchronized boolean isLocalUser() {
        return this.localUser;
    }

    public synchronized boolean sameUser(User user) {
        return user != null && user.getChannel().equals(this.getChannel()) && user.getName().equals(this.nick);
    }

    public synchronized boolean hasChannelModeratorRights() {
        return this.isModerator() || this.isBroadcaster();
    }

    public synchronized boolean hasModeratorRights() {
        return this.isAdmin() || this.isBroadcaster() || this.isGlobalMod() || this.isModerator() || this.isStaff();
    }

    public synchronized boolean isModerator() {
        return this.isModerator;
    }

    public synchronized boolean isGlobalMod() {
        return false;
    }

    public synchronized boolean isAdmin() {
        return this.isAdmin;
    }

    public synchronized boolean isStaff() {
        return this.isStaff;
    }

    public synchronized boolean isBroadcaster() {
        return this.isBroadcaster;
    }

    public synchronized boolean isSubscriber() {
        return this.isSubscriber;
    }

    public synchronized boolean hasTurbo() {
        return this.hasTurbo;
    }

    public synchronized boolean isBot() {
        return this.isBot;
    }

    public synchronized boolean isVip() {
        return this.isVip;
    }

    public synchronized boolean setLocalUser(boolean localUser) {
        if (this.localUser != localUser) {
            this.localUser = localUser;
            return true;
        }
        return false;
    }

    public synchronized boolean setModerator(boolean mod) {
        if (this.isModerator != mod) {
            this.isModerator = mod;
            this.updateFullNick();
            return true;
        }
        return false;
    }

    public synchronized boolean setAdmin(boolean admin) {
        if (this.isAdmin != admin) {
            this.isAdmin = admin;
            this.updateFullNick();
            return true;
        }
        return false;
    }

    public synchronized boolean setStaff(boolean staff) {
        if (this.isStaff != staff) {
            this.isStaff = staff;
            this.updateFullNick();
            return true;
        }
        return false;
    }

    public synchronized boolean setTurbo(boolean turbo) {
        if (this.hasTurbo != turbo) {
            this.hasTurbo = turbo;
            this.updateFullNick();
            return true;
        }
        return false;
    }

    public synchronized boolean setSubscriber(boolean subscriber) {
        if (this.isSubscriber != subscriber) {
            this.isSubscriber = subscriber;
            this.updateFullNick();
            return true;
        }
        return false;
    }

    public synchronized void setBroadcaster(boolean broadcaster) {
        this.isBroadcaster = broadcaster;
        this.updateFullNick();
    }

    public synchronized boolean setBot(boolean bot) {
        if (this.isBot != bot) {
            this.isBot = bot;
            this.updateFullNick();
            return true;
        }
        return false;
    }

    public synchronized boolean setVip(boolean vip) {
        if (this.isVip != vip) {
            this.isVip = vip;
            this.updateFullNick();
            return true;
        }
        return false;
    }

    private void updateFullNick() {
        this.fullNick = this.getModeSymbol() + this.getCustomNick();
        if (this.fullNick.equals(this.displayNick)) {
            this.fullNick = this.displayNick;
        }
    }

    public synchronized String getModeSymbol() {
        String result = "";
        if (this.isVip()) {
            result = result + "!";
        }
        if (this.isSubscriber()) {
            result = result + "%";
        }
        if (this.hasTwitchBadge("bits")) {
            result = result + "$";
        }
        if (this.hasTurbo()) {
            result = result + "+";
        }
        if (this.isBot()) {
            result = result + "^";
        }
        if (this.isBroadcaster()) {
            return "~" + result;
        }
        if (this.isStaff() || this.isAdmin()) {
            return "&" + result;
        }
        if (this.isModerator()) {
            return "@" + result;
        }
        return result;
    }

    public synchronized int getActivityScore() {
        long lastLine;
        int score = 0;
        if (this.lastHighlight != -1L) {
            score = (int)((double)score + (double)this.makeScore(this.lastHighlight) * 0.5);
        }
        if ((lastLine = this.getLastLineTime()) != -1L) {
            score += this.makeScore(lastLine);
        }
        return score;
    }

    private int makeScore(long time) {
        int ago = (int)(System.currentTimeMillis() - time) / 1000;
        int result = 1000 - ago / 120;
        return result < 0 ? 0 : result;
    }

    public synchronized void setHighlighted() {
        this.lastHighlight = System.currentTimeMillis();
    }

    public static class UserSettings {
        public static final UserSettings EMPTY = new UserSettings(100, null, null, null);
        private final int maxLines;
        private final UsercolorManager colorManager;
        private final Addressbook addressbook;
        private final UsericonManager iconManager;

        public UserSettings(int maxLines, UsercolorManager colorManager, Addressbook addressbook, UsericonManager iconManager) {
            if (maxLines < 0) {
                maxLines = 100;
            }
            this.maxLines = maxLines;
            this.colorManager = colorManager;
            this.addressbook = addressbook;
            this.iconManager = iconManager;
        }
    }

    public static class SharedTextMessage
    extends TextMessage
    implements SharedMessage {
        public final String sourceId;
        public final String sourceChannel;

        public SharedTextMessage(long time, String message, boolean action, String id, String sourceId, String sourceChannel, SuspiciousMessagePayload lowTrust) {
            super(time, message, action, id, lowTrust);
            this.sourceId = sourceId;
            this.sourceChannel = sourceChannel;
        }

        @Override
        public TextMessage addLowTrust(SuspiciousMessagePayload data) {
            return new SharedTextMessage(this.getTime(), this.text, this.action, this.id, this.sourceId, this.sourceChannel, data);
        }

        @Override
        public String getSourceChannel() {
            return this.sourceChannel;
        }
    }

    public static class Message {
        private final long time;

        public Message(long time) {
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }
    }

    public static class TextMessage
    extends Message {
        public final String text;
        public final boolean action;
        public final String id;
        public final SuspiciousMessagePayload lowTrust;

        public TextMessage(long time, String message, boolean action, String id, SuspiciousMessagePayload lowTrust) {
            super(time);
            this.text = message;
            this.action = action;
            this.id = id;
            this.lowTrust = lowTrust;
        }

        public String getText() {
            return this.text;
        }

        public boolean isAction() {
            return this.action;
        }

        public TextMessage addLowTrust(SuspiciousMessagePayload data) {
            return new TextMessage(this.getTime(), this.text, this.action, this.id, data);
        }
    }

    public static class BanMessage
    extends Message {
        public final long duration;
        public final String reason;
        public final String id;
        public final String by;

        public BanMessage(long time, long duration, String reason, String id, String by) {
            super(time);
            this.duration = duration;
            this.reason = reason;
            this.id = id;
            this.by = by;
        }

        public BanMessage addModLogInfo(String by, String reason, String sourceChannel) {
            if (reason == null) {
                reason = this.reason;
            }
            if (sourceChannel != null) {
                return new SharedBanMessage(this.getTime(), this.duration, reason, this.id, by, sourceChannel);
            }
            return new BanMessage(this.getTime(), this.duration, reason, this.id, by);
        }
    }

    public static class SharedUnbanMessage
    extends UnbanMessage
    implements SharedMessage {
        public final String sourceChannel;

        public SharedUnbanMessage(long time, int type, String by, String sourceChannel) {
            super(time, type, by);
            this.sourceChannel = sourceChannel;
        }

        @Override
        public String getSourceChannel() {
            return this.sourceChannel;
        }
    }

    public static class UnbanMessage
    extends Message {
        public static final int TYPE_UNKNOWN = -1;
        public static final int TYPE_UNBAN = 0;
        public static final int TYPE_UNTIMEOUT = 1;
        public final int type;
        public final String by;

        public UnbanMessage(long time, int type, String by) {
            super(time);
            this.type = type;
            this.by = by;
        }

        public static int getType(String modAction) {
            switch (modAction) {
                case "unban": {
                    return 0;
                }
                case "untimeout": {
                    return 1;
                }
            }
            return -1;
        }
    }

    public static class MsgDeleted
    extends Message {
        public final String targetMsgId;
        public final String msg;
        public final String by;

        public MsgDeleted(long time, String targetMsgId, String msg, String by) {
            super(time);
            this.targetMsgId = targetMsgId;
            this.msg = msg;
            this.by = by;
        }

        public MsgDeleted addModLogInfo(String by, String sourceChannel) {
            if (sourceChannel != null) {
                return new SharedMsgDeleted(this.getTime(), this.targetMsgId, this.msg, by, sourceChannel);
            }
            return new MsgDeleted(this.getTime(), this.targetMsgId, this.msg, by);
        }
    }

    public static class SharedSubMessage
    extends SubMessage
    implements SharedMessage {
        public final String sourceId;
        public final String sourceChannel;

        public SharedSubMessage(long time, String message, String text, String id, String sourceId, String sourceChannel) {
            super(time, message, text, id);
            this.sourceId = sourceId;
            this.sourceChannel = sourceChannel;
        }

        @Override
        public String getSourceChannel() {
            return this.sourceChannel;
        }
    }

    public static class SubMessage
    extends Message {
        public final String attached_message;
        public final String system_msg;
        public final String id;

        public SubMessage(long time, String message, String text, String id) {
            super(time);
            this.attached_message = message;
            this.system_msg = text;
            this.id = id;
        }
    }

    public static class SharedInfoMessage
    extends InfoMessage
    implements SharedMessage {
        public final String sourceChannel;

        public SharedInfoMessage(long time, String message, String full_text, String sourceChannel) {
            super(time, message, full_text);
            this.sourceChannel = sourceChannel;
        }

        @Override
        public String getSourceChannel() {
            return this.sourceChannel;
        }
    }

    public static class InfoMessage
    extends Message {
        public final String attached_message;
        public final String full_text;

        public InfoMessage(long time, String message, String full_text) {
            super(time);
            this.attached_message = message;
            this.full_text = full_text;
        }
    }

    public static class WarnMessage
    extends Message {
        public final String reason;
        public final String by;

        public WarnMessage(long time, String reason, String by) {
            super(time);
            this.reason = reason;
            this.by = by;
        }
    }

    public static class SharedModAction
    extends ModAction
    implements SharedMessage {
        public final String sourceChannel;

        public SharedModAction(long time, String commandAndParameters, String sourceChannel) {
            super(time, commandAndParameters);
            this.sourceChannel = sourceChannel;
        }

        @Override
        public String getSourceChannel() {
            return this.sourceChannel;
        }
    }

    public static class ModAction
    extends Message {
        public final String commandAndParameters;

        public ModAction(long time, String commandAndParameters) {
            super(time);
            this.commandAndParameters = commandAndParameters;
        }
    }

    public static class AutoModMessage
    extends Message {
        public final String message;
        public final String id;
        public final String reason;
        public final ModActionPayload.Type status;
        public final String moderatorName;

        public AutoModMessage(String message, String id, String reason, ModActionPayload.Type status, String moderatorName) {
            super(System.currentTimeMillis());
            this.message = message;
            this.id = id;
            this.reason = reason;
            this.status = status;
            this.moderatorName = moderatorName;
        }
    }

    public static interface SharedMessage {
        public String getSourceChannel();
    }

    public static class SharedMsgDeleted
    extends MsgDeleted
    implements SharedMessage {
        public final String sourceChannel;

        public SharedMsgDeleted(long time, String targetMsgId, String msg, String by, String sourceChannel) {
            super(time, targetMsgId, msg, by);
            this.sourceChannel = sourceChannel;
        }

        @Override
        public String getSourceChannel() {
            return this.sourceChannel;
        }
    }

    public static class SharedBanMessage
    extends BanMessage
    implements SharedMessage {
        public final String sourceChannel;

        public SharedBanMessage(long time, long duration, String reason, String id, String by, String sourceChannel) {
            super(time, duration, reason, id, by);
            this.sourceChannel = sourceChannel;
        }

        @Override
        public String getSourceChannel() {
            return this.sourceChannel;
        }
    }
}

