/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.CustomNames;
import chatty.Helper;
import chatty.Room;
import chatty.User;
import chatty.util.BotNameManager;
import chatty.util.StringUtil;
import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class UserManager {
    private static final Logger LOGGER = Logger.getLogger(UserManager.class.getName());
    private static final int CLEAR_MESSAGES_TIMER = 3600000;
    private final Set<UserManagerListener> listeners = new HashSet<UserManagerListener>();
    private volatile String localUsername;
    public final User specialUser = new User("[specialUser]", Room.createRegular("[nochannel]"));
    private final HashMap<String, HashMap<String, User>> users = new HashMap();
    private final HashMap<String, String> cachedColors = new HashMap();
    private boolean capitalizedNames = false;
    private final User errorUser = new User("[Error]", Room.createRegular("#[error]"));
    private CustomNames customNamesManager;
    private BotNameManager botNameManager;
    private Settings settings;
    private User.UserSettings userSettings;

    public UserManager() {
        Timer clearMessageTimer = new Timer("Clear User Messages", true);
        clearMessageTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                UserManager.this.clearLinesOfInactiveUsers();
            }
        }, 3600000L, 3600000L);
    }

    public void setLocalUsername(String username) {
        this.localUsername = username;
    }

    public void setBotNameManager(BotNameManager m) {
        this.botNameManager = m;
        m.addListener(new BotNameManager.BotNameListener(){

            private void setUserBot(User user) {
                if (user.setBot(true)) {
                    UserManager.this.userUpdated(user);
                }
            }

            @Override
            public void botNameAdded(String channel, String botName) {
                if (channel == null) {
                    for (User user : UserManager.this.getUsersByName(botName)) {
                        this.setUserBot(user);
                    }
                } else {
                    User user = UserManager.this.getUserIfExists(channel, botName);
                    if (user != null) {
                        this.setUserBot(user);
                    }
                }
            }
        });
    }

    public void addListener(UserManagerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void userUpdated(User user) {
        for (UserManagerListener listener : this.listeners) {
            listener.userUpdated(user);
        }
    }

    public void updateRoom(Room room) {
        HashMap<String, User> data = this.getUsersByChannel(room.getChannel());
        for (User user : data.values()) {
            user.setRoom(room);
        }
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setUserSettings(User.UserSettings settings) {
        this.userSettings = settings;
    }

    public void setCapitalizedNames(boolean capitalized) {
        this.capitalizedNames = capitalized;
    }

    public void setCustomNamesManager(CustomNames m) {
        if (m != null) {
            this.customNamesManager = m;
            m.addListener(new CustomNames.CustomNamesListener(){

                @Override
                public void setName(String name, String customNick) {
                    List<User> users = UserManager.this.getUsersByName(name);
                    for (User user : users) {
                        user.setCustomNick(customNick);
                        UserManager.this.userUpdated(user);
                    }
                }
            });
        }
    }

    public synchronized HashMap<String, User> getUsersByChannel(String channel) {
        HashMap<String, User> result = this.users.get(channel);
        if (result == null) {
            result = new HashMap();
            this.users.put(channel, result);
        }
        return result;
    }

    public synchronized List<User> getUsersByName(String name) {
        name = StringUtil.toLowerCase(name);
        ArrayList<User> result = new ArrayList<User>();
        for (HashMap<String, User> channelUsers : this.users.values()) {
            User user = channelUsers.get(name);
            if (user == null) continue;
            result.add(user);
        }
        return result;
    }

    public synchronized User getUserIfExists(String channel, String name) {
        return this.getUsersByChannel(channel).get(name);
    }

    public synchronized User getUser(Room room, String name) {
        if (name == null || name.isEmpty()) {
            return this.errorUser;
        }
        name = StringUtil.toLowerCase(name);
        User user = this.getUserIfExists(room.getChannel(), name);
        if (user == null) {
            String capitalizedName = name;
            if (this.capitalizedNames) {
                capitalizedName = name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1);
            }
            user = new User(name, capitalizedName, null, room);
            user.setUserSettings(this.userSettings);
            if (this.customNamesManager != null) {
                user.setCustomNick(this.customNamesManager.getCustomName(name));
            }
            if (this.botNameManager != null && this.botNameManager.isBotName(room.getOwnerChannel(), name)) {
                user.setBot(true);
            }
            if (this.cachedColors.containsKey(name)) {
                user.setColor(this.cachedColors.get(name));
            }
            if (name.equals(this.localUsername)) {
                user.setAdmin(this.specialUser.isAdmin());
                user.setStaff(this.specialUser.isStaff());
                user.setTurbo(this.specialUser.hasTurbo());
                user.setId(this.specialUser.getId());
                user.setLocalUser(true);
                if (!this.specialUser.hasDefaultColor()) {
                    user.setColor(this.specialUser.getPlainColor());
                }
                if (this.specialUser.hasDisplayNickSet()) {
                    user.setDisplayNick(this.specialUser.getDisplayNick());
                }
            }
            this.getUsersByChannel(room.getChannel()).put(name, user);
        }
        return user;
    }

    public synchronized HashMap<String, User> getChannelsAndUsersByUserName(String name) {
        String lowercaseName = StringUtil.toLowerCase(name);
        HashMap<String, User> result = new HashMap<String, User>();
        for (Map.Entry<String, HashMap<String, User>> channel : this.users.entrySet()) {
            String channelName = channel.getKey();
            HashMap<String, User> channelUsers = channel.getValue();
            User user = channelUsers.get(lowercaseName);
            if (user == null) continue;
            result.put(channelName, user);
        }
        return result;
    }

    public synchronized void clear() {
        this.users.clear();
    }

    public synchronized void clear(String channel) {
        this.getUsersByChannel(channel).clear();
    }

    public synchronized void clearLinesOfInactiveUsers() {
        if (this.settings == null) {
            return;
        }
        long clearUserMessages = this.settings.getLong("clearUserMessages");
        if (clearUserMessages >= 0L) {
            int numRemoved = 0;
            for (Map map : this.users.values()) {
                for (User user : map.values()) {
                    numRemoved += user.clearLinesIfInactive(clearUserMessages * 60L * 60L * 1000L);
                }
            }
            LOGGER.info("Cleared " + numRemoved + " user messages");
        }
    }

    public synchronized int clearLines(String channel, boolean messageNumberOnly) {
        if (channel == null) {
            int result = 0;
            for (String chan : this.users.keySet()) {
                if (chan == null) continue;
                result += this.clearLines(chan, messageNumberOnly);
            }
            return result;
        }
        int result = 0;
        Map usersOfChannel = this.users.get(channel);
        if (usersOfChannel != null) {
            result += usersOfChannel.size();
            for (User user : usersOfChannel.values()) {
                if (messageNumberOnly) {
                    user.clearNumberOfMessages();
                    continue;
                }
                user.clearLines();
            }
        }
        return result;
    }

    public synchronized void setAllOffline() {
        Iterator<HashMap<String, User>> it = this.users.values().iterator();
        while (it.hasNext()) {
            this.setAllOffline((Map<String, User>)it.next());
        }
    }

    public synchronized void setAllOffline(String channel) {
        Map usersInChannel;
        if (channel == null) {
            this.setAllOffline();
        }
        if ((usersInChannel = (Map)this.users.get(channel)) != null) {
            this.setAllOffline(usersInChannel);
        }
    }

    private void setAllOffline(Map<String, User> usersInChannel) {
        for (User user : usersInChannel.values()) {
            user.setOnline(false);
        }
    }

    protected synchronized void setColorForUsername(String userName, String color) {
        userName = StringUtil.toLowerCase(userName);
        this.cachedColors.put(userName, color);
        List<User> userAllChans = this.getUsersByName(userName);
        for (User user : userAllChans) {
            user.setColor(color);
        }
    }

    protected synchronized List<User> modsListReceived(Room room, List<String> modsList) {
        HashMap<String, User> usersToDemod = this.getUsersByChannel(room.getChannel());
        for (User user : usersToDemod.values()) {
            user.setModerator(false);
        }
        LOGGER.info("Setting users as mod for " + room.getChannel() + ": " + modsList);
        ArrayList<User> changedUsers = new ArrayList<User>();
        for (String userName : modsList) {
            if (!Helper.isValidChannel(userName)) continue;
            User user = this.getUser(room, userName);
            if (user.setModerator(true)) {
                this.userUpdated(user);
            }
            changedUsers.add(user);
        }
        return changedUsers;
    }

    public static interface UserManagerListener {
        public void userUpdated(User var1);
    }
}

