/*
 * Decompiled with CFR 0.152.
 */
package chatty;

import chatty.Helper;
import chatty.TwitchClient;
import chatty.TwitchConnection;
import chatty.User;
import chatty.util.StringUtil;
import chatty.util.settings.Settings;
import java.util.HashSet;
import java.util.Set;

public class WhisperManager {
    public static final String WHISPER_CHANNEL = "$[whisper]";
    public static final int DISPLAY_IN_CHAT = 0;
    public static final int DISPLAY_ONE_WINDOW = 1;
    public static final int DISPLAY_PER_USER = 2;
    private final String AUTO_RESPOND_MESSAGE = "[Auto-Message] This user has not allowed to receive whispers from you.";
    private final Set<String> autoRespondedTo = new HashSet<String>();
    private final WhisperListener listener;
    private final Settings settings;
    private final TwitchConnection c;
    private final TwitchClient client;

    public WhisperManager(WhisperListener listener, Settings settings, TwitchConnection c, TwitchClient client) {
        this.listener = listener;
        this.settings = settings;
        this.c = c;
        this.client = client;
    }

    public boolean isAvailable() {
        return this.c.isRegistered() && this.isEnabled();
    }

    public boolean isEnabled() {
        return this.settings.getBoolean("whisperEnabled");
    }

    public void whisperCommand(String parameter, boolean onlyReply) {
        if (parameter == null) {
            this.listener.info("Whisper: Invalid parameters.");
            return;
        }
        String[] split = parameter.split(" ", 2);
        if (split.length == 2) {
            this.whisper(split[0], split[1], onlyReply);
        } else {
            this.listener.info("Whisper: Invalid parameters.");
        }
    }

    public void whisperChannel(String channel, String message) {
        if (channel.equals(WHISPER_CHANNEL)) {
            this.whisperCommand(message, true);
        } else if (channel.startsWith("$") && channel.length() > 1) {
            String nick = channel.substring(1);
            this.whisper(nick, message, false);
        } else {
            this.listener.info("Whisper: Invalid parameters.");
        }
    }

    public void whisper(String nick, String message, boolean onlyReply) {
        if (!this.isEnabled()) {
            this.listener.info("Whisper feature not enabled (<Main - Settings - Advanced>)");
            return;
        }
        if (onlyReply && this.c.getExistingUser(WHISPER_CHANNEL, nick) == null) {
            this.listener.info("Didn't receive any whisper from '" + nick + "', use /w command");
            return;
        }
        if (this.isAvailable()) {
            if (Helper.isBeforeChatCommandsShutoff() && !this.settings.getBoolean("whisperApi")) {
                if (!this.rawWhisper(nick, message)) {
                    this.listener.info("# Whisper not sent (spam protection): " + message);
                } else {
                    User user = this.c.getUser(WHISPER_CHANNEL, nick);
                    this.listener.whisperSent(user, message);
                    if (this.isUserIgnored(user)) {
                        this.listener.info("You haven't allowed to receive whispers from " + user);
                    }
                }
            } else {
                this.client.api.whisper(nick, message, r -> {
                    if (r.error != null) {
                        this.listener.info("# Whisper not sent: " + r.error);
                    } else {
                        User user = this.c.getUser(WHISPER_CHANNEL, nick);
                        this.listener.whisperSent(user, message);
                        if (this.isUserIgnored(user)) {
                            this.listener.info("You haven't allowed to receive whispers from " + user);
                        }
                    }
                });
            }
        } else {
            this.listener.info("Can't send whisper: not connected");
        }
    }

    private boolean isUserAllowed(User user) {
        if (user.hasCategory("blockwhisper")) {
            return false;
        }
        return !this.settings.getBoolean("whisperWhitelist") || user.hasCategory("whisper");
    }

    private boolean isUserIgnored(User user) {
        if (this.settings.listContains("ignoredUsersWhisper", user.getName())) {
            return true;
        }
        return !this.isUserAllowed(user);
    }

    public void whisperReceived(User user, String message, String emotes) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isUserAllowed(user)) {
            this.listener.whisperReceived(user, message, emotes);
        }
        if (this.isUserIgnored(user) && this.settings.getBoolean("whisperAutoRespond")) {
            if (!this.autoRespondedTo.contains(user.getName())) {
                String msg = "[Auto-Message] This user has not allowed to receive whispers from you.";
                String customMsg = this.settings.getString("whisperAutoRespondCustom");
                if (!StringUtil.isNullOrEmpty(customMsg)) {
                    msg = String.format("%s (%s)", msg, customMsg);
                }
                this.rawWhisper(user.getName(), msg);
                this.autoRespondedTo.add(user.getName());
            }
        } else {
            this.autoRespondedTo.remove(user.getName());
        }
    }

    private boolean rawWhisper(String nick, String message) {
        return this.c.sendSpamProtectedMessage("#" + this.c.getUsername(), "/w " + nick + " " + message, false);
    }

    public static interface WhisperListener {
        public void whisperReceived(User var1, String var2, String var3);

        public void whisperSent(User var1, String var2);

        public void info(String var1);
    }
}

