/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.gui.GuiUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashSet;
import java.util.Set;

public class AttachedWindowManager {
    private final Set<Component> components = new HashSet<Component>();
    private final Component owner;
    private final Set<Point> ignoreOnce = new HashSet<Point>();
    private int width;
    private int height;
    private int x;
    private int y;
    private boolean enabled;
    private final Point temp = new Point();
    private final Point temp2 = new Point();

    public AttachedWindowManager(Component owner) {
        owner.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                int newWidth = e.getComponent().getWidth();
                int newHeight = e.getComponent().getHeight();
                boolean sizeChanged = newWidth != AttachedWindowManager.this.width || newHeight != AttachedWindowManager.this.height;
                AttachedWindowManager.this.width = newWidth;
                AttachedWindowManager.this.height = newHeight;
                int newX = e.getComponent().getX();
                int newY = e.getComponent().getY();
                int movedX = newX - AttachedWindowManager.this.x;
                int movedY = newY - AttachedWindowManager.this.y;
                AttachedWindowManager.this.x = newX;
                AttachedWindowManager.this.y = newY;
                if (AttachedWindowManager.this.ignoreOnce.contains(e.getComponent().getLocation(AttachedWindowManager.this.temp))) {
                    AttachedWindowManager.this.ignoreOnce.remove(AttachedWindowManager.this.temp);
                    return;
                }
                if (sizeChanged) {
                    return;
                }
                if (!AttachedWindowManager.this.enabled) {
                    return;
                }
                for (Component comp : AttachedWindowManager.this.components) {
                    ((AttachedWindowManager)AttachedWindowManager.this).temp2.x = comp.getX() + movedX;
                    ((AttachedWindowManager)AttachedWindowManager.this).temp2.y = comp.getY() + movedY;
                    if (!GuiUtil.isPointOnScreen(AttachedWindowManager.this.temp2, comp.getWidth() / 2, 10)) continue;
                    comp.setLocation(AttachedWindowManager.this.temp2);
                }
            }
        });
        this.owner = owner;
    }

    public void attach(Component comp) {
        if (comp != this.owner && !this.components.contains(comp)) {
            this.components.add(comp);
        }
    }

    public void detach(Component comp) {
        this.components.remove(comp);
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void ignoreLocationOnce(Point location) {
        this.ignoreOnce.add(location);
    }
}

