/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.Helper;
import chatty.Room;
import chatty.gui.DockStyledTabContainer;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.MouseClickedListener;
import chatty.gui.StyleManager;
import chatty.gui.components.Channel;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.TabContextMenu;
import chatty.gui.components.settings.TabSettings;
import chatty.gui.transparency.TransparencyManager;
import chatty.lang.Language;
import chatty.util.Debugging;
import chatty.util.IconManager;
import chatty.util.KeyChecker;
import chatty.util.MiscUtil;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockLayout;
import chatty.util.dnd.DockLayoutPopout;
import chatty.util.dnd.DockListener;
import chatty.util.dnd.DockManager;
import chatty.util.dnd.DockPath;
import chatty.util.dnd.DockPathEntry;
import chatty.util.dnd.DockPopout;
import chatty.util.dnd.DockSetting;
import chatty.util.dnd.DockUtil;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Channels {
    private final MainGui gui;
    private ChangeListener changeListener;
    private final HashMap<String, Channel> channels = new HashMap();
    private final Map<String, Channel> closingChannels = new HashMap<String, Channel>();
    private final List<LocationAndSize> dialogsAttributes = new ArrayList<LocationAndSize>();
    private final DockManager dock;
    private Channel defaultChannel;
    public static final String DEFAULT_CHANNEL_ID = "-nochannel-";
    private final StyleManager styleManager;
    private final ContextMenuListener contextMenuListener;
    private final MouseClickedListener mouseClickedListener = new MyMouseClickedListener();
    private int defaultUserlistWidth = 140;
    private int minUserlistWidth = 0;
    private boolean defaultUserlistVisibleState = true;
    private boolean chatScrollbarAlaways;
    private boolean savePopoutAttributes;
    private boolean closeLastChannelPopout;
    private boolean insertTop;
    private Channel lastActiveChannel;
    private final Set<String> liveStreams = new HashSet<String>();
    private boolean loadingLayout;
    private DockLayout lastLoadedLayout;
    private final Set<String> openedSinceLayoutLoad = new HashSet<String>();
    private static final int POPOUT_ATTRIBUTES_LIMIT = 30;
    private static Channels instance;
    private static final int LAYOUT_OPTION_CURRENT_CHANS = 1;
    private static final int LAYOUT_OPTION_LAYOUT_CHANS = 2;
    private static final int LAYOUT_OPTION_MAIN = 4;

    public Channels(final MainGui gui, StyleManager styleManager, ContextMenuListener contextMenuListener) {
        this.dock = new DockManager(new DockListener(){

            @Override
            public void activeContentChanged(DockPopout window, DockContent content, boolean focusChange) {
                if (content.getComponent() instanceof Channel) {
                    Channel c = (Channel)content.getComponent();
                    Channels.this.lastActiveChannel = c;
                    if (!focusChange) {
                        Channels.this.setInitialFocus(c, true);
                    }
                }
                Channels.this.updateActiveContent();
                Channels.this.resetTab(content);
                if (!(Channels.this.channels.isEmpty() && Channels.this.defaultChannel == null || Channels.this.dock.isMainEmpty())) {
                    Channels.this.channelChanged();
                }
                TransparencyManager.check();
                Debugging.println("dnda", "Path: %s", content.getPath());
            }

            @Override
            public void popoutOpened(DockPopout popout, DockContent content) {
                Channels.this.dockPopoutOpened(popout);
            }

            @Override
            public void popoutClosing(DockPopout popout) {
                if (Channels.this.dock.getContents(popout).isEmpty()) {
                    Channels.this.dock.closePopout(popout);
                } else if (KeyChecker.isPressed(16)) {
                    Channels.this.dock.closePopout(popout);
                } else if (KeyChecker.isPressed(17)) {
                    Channels.this.removeContents(Channels.this.dock.getContents(popout));
                } else {
                    switch (gui.getSettings().getString("popoutClose")) {
                        case "close": {
                            Channels.this.removeContents(Channels.this.dock.getContents(popout));
                            break;
                        }
                        case "move": {
                            Channels.this.dock.closePopout(popout);
                            break;
                        }
                        default: {
                            ClosingDialog d = new ClosingDialog(popout);
                            if (d.getChoice().equals("close")) {
                                Channels.this.removeContents(Channels.this.dock.getContents(popout));
                            } else if (d.getChoice().equals("move")) {
                                Channels.this.dock.closePopout(popout);
                            }
                            if (!d.shouldSaveChoice()) break;
                            gui.getSettings().setString("popoutClose", d.getChoice());
                        }
                    }
                }
            }

            @Override
            public void popoutClosed(DockPopout popout, List<DockContent> contents) {
                Channels.this.dockPopoutClosed(popout, contents);
            }

            @Override
            public void contentAdded(DockContent content) {
                Channels.this.checkDefaultChannel();
            }

            @Override
            public void contentRemoved(DockContent content) {
                Channels.this.checkDefaultChannel();
                TransparencyManager.check();
            }
        });
        this.dock.setSetting(DockSetting.Type.POPOUT_ICONS, IconManager.getPopoutIcons());
        this.dock.setSetting(DockSetting.Type.POPOUT_PARENT, gui);
        this.styleManager = styleManager;
        this.contextMenuListener = contextMenuListener;
        this.gui = gui;
        this.updateSettings();
        gui.getSettings().addSettingChangeListener((setting, type, value) -> {
            if (setting.startsWith("tab") || setting.equals("laf")) {
                SwingUtilities.invokeLater(() -> this.updateSettings());
            }
        });
        KeyChecker.watch(16);
        KeyChecker.watch(17);
        instance = this;
    }

    public void init() {
        if (this.gui.getSettings().getBoolean("restoreLayout")) {
            this.loadLastSessionLayout();
        }
        this.checkDefaultChannel();
    }

    public DockManager getDock() {
        return this.dock;
    }

    public Component getComponent() {
        return this.dock.getBase();
    }

    private void channelTabClosed(Channel channel) {
        this.gui.client.closeChannel(channel.getChannel());
    }

    private void updateSettings() {
        for (Channel chan : this.channels.values()) {
            this.updateSettings(chan);
        }
        if (this.defaultChannel != null) {
            this.updateSettings(this.defaultChannel);
        }
        this.dock.setSetting(DockSetting.Type.TAB_LAYOUT, this.getTabLayoutPolicyValue(this.gui.getSettings().getString("tabsLayout")));
        this.dock.setSetting(DockSetting.Type.TAB_PLACEMENT, this.getTabPlacementValue(this.gui.getSettings().getString("tabsPlacement")));
        this.dock.setSetting(DockSetting.Type.TAB_SCROLL, this.gui.getSettings().getBoolean("tabsMwheelScrolling"));
        this.dock.setSetting(DockSetting.Type.TAB_SCROLL_ANYWHERE, this.gui.getSettings().getBoolean("tabsMwheelScrollingAnywhere"));
        this.dock.setSetting(DockSetting.Type.TAB_CLOSE_MMB, this.gui.getSettings().getBoolean("tabsCloseMMB"));
        this.dock.setSetting(DockSetting.Type.TAB_CLOSE_SWITCH_TO_PREV, this.gui.getSettings().getBoolean("tabsCloseSwitchToPrev"));
        this.dock.setSetting(DockSetting.Type.TAB_ORDER, (Object)DockSetting.TabOrder.INSERTION);
        this.dock.setSetting(DockSetting.Type.FILL_COLOR, UIManager.getColor("TextField.selectionBackground"));
        this.dock.setSetting(DockSetting.Type.LINE_COLOR, UIManager.getColor("TextField.selectionForeground"));
        this.dock.setSetting(DockSetting.Type.POPOUT_TYPE_DRAG, (Object)this.getPopoutTypeValue((int)this.gui.getSettings().getLong("tabsPopoutDrag")));
        this.dock.setSetting(DockSetting.Type.DIVIDER_SIZE, 7);
        this.dock.setSetting(DockSetting.Type.NO_SINGLE, !this.gui.getSettings().getBoolean("tabsHideIfSingle"));
        this.updateTabComparator();
        this.updateKeepEmptySetting();
    }

    private void updateTabComparator() {
        final boolean alphabetical = this.gui.getSettings().getString("tabOrder").equals("alphabetical");
        this.dock.setSetting(DockSetting.Type.TAB_COMPARATOR, new Comparator<DockContent>(){

            @Override
            public int compare(DockContent o1, DockContent o2) {
                long o2Pos;
                long o1Pos = this.getPos(o1);
                if (o1Pos < (o2Pos = this.getPos(o2))) {
                    return -1;
                }
                if (o1Pos > o2Pos) {
                    return 1;
                }
                if (alphabetical) {
                    return o1.getTitle().compareToIgnoreCase(o2.getTitle());
                }
                return 0;
            }

            private long getPos(DockContent content) {
                long pos = Channels.this.gui.getSettings().mapGetLong("tabsPos", content.getId(), 0L);
                if (pos == 0L && !content.getId().isEmpty()) {
                    pos = Channels.this.gui.getSettings().mapGetLong("tabsPos", content.getId().substring(0, 1), 0L);
                }
                return pos;
            }
        });
    }

    private void updateKeepEmptySetting() {
        this.dock.setSetting(DockSetting.Type.KEEP_EMPTY, !this.gui.getSettings().getBoolean("tabsCloseEmpty"));
    }

    private int getTabLayoutPolicyValue(String type) {
        switch (type) {
            case "wrap": {
                return 0;
            }
            case "scroll": {
                return 1;
            }
        }
        return 0;
    }

    private int getTabPlacementValue(String location) {
        switch (location) {
            case "top": {
                return 1;
            }
            case "bottom": {
                return 3;
            }
            case "left": {
                return 2;
            }
            case "right": {
                return 4;
            }
        }
        return 1;
    }

    private DockSetting.TabOrder getTabOrderValue(String order) {
        if (order.equals("alphabetical")) {
            return DockSetting.TabOrder.ALPHABETIC;
        }
        return DockSetting.TabOrder.INSERTION;
    }

    private DockSetting.PopoutType getPopoutTypeValue(int type) {
        switch (type) {
            case 1: {
                return DockSetting.PopoutType.DIALOG;
            }
            case 2: {
                return DockSetting.PopoutType.FRAME;
            }
        }
        return DockSetting.PopoutType.NONE;
    }

    private void updateSettings(Channel chan) {
        chan.getDockContent().setSettings(this.gui.getSettings().getLong("tabsLive"), this.gui.getSettings().getLong("tabsMessage"), this.gui.getSettings().getLong("tabsHighlight"), this.gui.getSettings().getLong("tabsStatus"), this.gui.getSettings().getLong("tabsActive"), this.gui.getSettings().getLong("tabsMaxWidth"));
    }

    public void saveLayout() {
        this.gui.getSettings().mapPut("layouts", "", this.dock.getLayout().toList());
    }

    public void changeLayout(DockLayout layout, int options) {
        if (layout == null) {
            return;
        }
        List<DockContent> current = this.dock.getContents();
        DockLayoutPopout mainWindow = layout.getMain();
        boolean offerMainChange = mainWindow != null && mainWindow.canChange(this.gui.getLocation(), this.gui.getSize(), this.gui.getExtendedState());
        boolean showDialog = options == -1;
        ChangeLayoutDialog d = new ChangeLayoutDialog(this.gui, current, layout, offerMainChange, options != -1 ? options : this.gui.getSettings().getInt("layoutsOptions"));
        if (showDialog) {
            d.setVisible(true);
        }
        if (d.saveOptions()) {
            this.gui.getSettings().setLong("layoutsOptions", d.getOptions());
        }
        if (!d.shouldLoad() && showDialog) {
            return;
        }
        this.loadingLayout = true;
        Debugging.println("layout", "Loading layout.. (%s)", layout);
        if (d.loadMain()) {
            this.gui.setLocation(mainWindow.location);
            this.gui.setSize(mainWindow.size);
            this.gui.setExtendedState(mainWindow.state);
        }
        this.loadLayout(layout);
        this.dock.setSetting(DockSetting.Type.TAB_COMPARATOR, null);
        this.dock.setSetting(DockSetting.Type.KEEP_EMPTY, true);
        if (this.defaultChannel != null) {
            this.addDefaultChannelToDock();
        } else {
            this.addDefaultChannel();
        }
        for (String id : layout.getContentIds()) {
            DockContent currentContent = DockUtil.getContentById(current, id);
            if (id.equals(DEFAULT_CHANNEL_ID)) {
                this.dock.removeContent(this.defaultChannel.getDockContent());
                this.addDefaultChannelToDock();
                continue;
            }
            if (this.getTypeFromChannelName(id) == Channel.Type.CHANNEL) {
                this.handleContent(id, currentContent, d.getAddChannels().contains(id));
                continue;
            }
            if (this.getTypeFromChannelName(id) != Channel.Type.NONE) {
                this.handleContent(id, currentContent, d.getAddChannels().contains(id));
                continue;
            }
            this.handleContent(id, currentContent, true);
        }
        for (DockContent currentContent : current) {
            String id = currentContent.getId();
            boolean inLayout = layout.getContentIds().contains(id);
            if (inLayout) continue;
            if (this.getTypeFromChannelName(id) == Channel.Type.CHANNEL) {
                this.handleContent(id, currentContent, d.getAddChannels().contains(id));
                continue;
            }
            if (this.getTypeFromChannelName(id) != Channel.Type.NONE) {
                this.handleContent(id, currentContent, d.getAddChannels().contains(id));
                continue;
            }
            this.handleContent(id, currentContent, false);
        }
        if (!d.getJoinChannels().isEmpty()) {
            HashSet<String> toJoin = new HashSet<String>();
            for (String channel : d.getJoinChannels()) {
                if (!channel.startsWith("#")) continue;
                this.channels.get(channel).getDockContent().setJoining(true);
                toJoin.add(channel);
            }
            this.gui.client.joinChannels(new HashSet<String>(toJoin));
        }
        this.updateTabComparator();
        this.updateKeepEmptySetting();
        this.loadingLayout = false;
        this.checkDefaultChannel();
        this.setActiveTabs(layout);
        Debugging.println("layout", "Finished loading layout. Add: %s Join: %s Closing: %s Channels: %s", d.getAddChannels(), d.getJoinChannels(), this.closingChannels, this.channels);
    }

    private void handleContent(String id, DockContent currentContent, boolean add) {
        Debugging.println("layout", "Handle %s (%s) [%s]", id, add, currentContent);
        if (this.getTypeFromChannelName(id) != Channel.Type.NONE) {
            if (add) {
                if (currentContent != null) {
                    this.setTargetPath(currentContent);
                    this.dock.addContent(currentContent);
                } else {
                    this.getChannel(Room.createRegular(id));
                }
            } else {
                Channel channel = this.channels.remove(id);
                if (channel != null) {
                    this.closingChannels.put(id, channel);
                }
                this.gui.client.closeChannel(id);
            }
        } else if (id.startsWith("'")) {
            if (add) {
                this.gui.routingManager.addTarget(id.replace("'", ""));
            }
        } else if (add) {
            this.gui.dockedDialogs.openInDock(id);
        } else {
            this.gui.dockedDialogs.closeFromDock(id);
        }
    }

    private void loadLastSessionLayout() {
        DockLayout layout = DockLayout.fromList((List)this.gui.getSettings().mapGet("layouts", ""));
        if (layout != null) {
            this.loadingLayout = true;
            this.loadLayout(layout);
            this.addDefaultChannel();
            this.dock.setSetting(DockSetting.Type.TAB_COMPARATOR, null);
            this.dock.setSetting(DockSetting.Type.KEEP_EMPTY, true);
            for (String id : layout.getContentIds()) {
                if (id.equals(DEFAULT_CHANNEL_ID)) {
                    this.dock.removeContent(this.defaultChannel.getDockContent());
                    this.addDefaultChannelToDock();
                    continue;
                }
                if (this.getTypeFromChannelName(id) == Channel.Type.CHANNEL) {
                    if (this.gui.getSettings().getLong("onStart") != 3L) continue;
                    this.handleContent(id, null, true);
                    this.channels.get(id).getDockContent().setJoining(true);
                    continue;
                }
                if (this.getTypeFromChannelName(id) != Channel.Type.NONE) {
                    this.handleContent(id, null, this.gui.getSettings().getBoolean("restoreLayoutWhisper"));
                    continue;
                }
                this.handleContent(id, null, true);
            }
            this.loadingLayout = false;
            this.updateTabComparator();
            this.updateKeepEmptySetting();
            this.setActiveTabs(layout);
        }
    }

    private void loadLayout(DockLayout layout) {
        this.lastLoadedLayout = layout;
        this.openedSinceLayoutLoad.clear();
        this.dock.loadLayout(layout);
    }

    private void setActiveTabs(DockLayout layout) {
        for (String id : layout.getActiveContentIds()) {
            DockContent content = this.dock.getContentById(id);
            if (content == null) continue;
            this.dock.setActiveContent(content);
        }
    }

    public void updateRoom(Room room) {
        Channel channel = this.channels.get(room.getChannel());
        if (channel != null && channel.setRoom(room)) {
            Debugging.printlnf("Update Room: %s", room);
        }
    }

    private void updateActiveContent() {
        if (!this.doesChannelExist(this.lastActiveChannel)) {
            this.resetLastActiveChannel();
        }
        Channel active = this.getActiveChannel();
        for (Channel chan : this.channels.values()) {
            chan.getDockContent().setActive(active == chan);
        }
        if (this.defaultChannel != null) {
            this.defaultChannel.getDockContent().setActive(active == this.defaultChannel);
        }
    }

    public void setChannelHighlighted(Channel channel) {
        if (!channel.getDockContent().hasNewHighlight() && !this.dock.isContentVisible(channel.getDockContent())) {
            channel.getDockContent().setNewHighlight(true);
        }
    }

    public void setChannelNewMessage(Channel channel) {
        if (!(channel.getDockContent().hasNewMessages() || channel.getDockContent().hasNewHighlight() || this.dock.isContentVisible(channel.getDockContent()))) {
            channel.getDockContent().setNewMessage(true);
        }
    }

    public void setStreamLive(String stream, boolean isLive) {
        if (!Helper.isValidStream(stream)) {
            return;
        }
        if (isLive) {
            this.liveStreams.add(stream);
        } else {
            this.liveStreams.remove(stream);
        }
        Channel chan = this.getExistingChannel(Helper.toChannel(stream));
        if (chan != null) {
            chan.getDockContent().setLive(isLive);
        }
    }

    public void resetTab(DockContent content) {
        if (content instanceof DockStyledTabContainer) {
            ((DockStyledTabContainer)content).resetNew();
        }
    }

    public void setChannelNewStatus(String ownerChannel) {
        Collection<Channel> chans = this.getExistingChannelsByOwner(ownerChannel);
        for (Channel chan : chans) {
            if (!this.dock.isContentVisible(chan.getDockContent())) continue;
            return;
        }
        for (Channel chan : chans) {
            chan.getDockContent().setNewStatus(true);
        }
    }

    public void joinScheduled(String channel) {
        this.getChannel(Room.createRegular(channel)).getDockContent().setJoining(true);
    }

    public Channel getChannel(Room room) {
        String channelName = room.getChannel();
        return this.getChannel(room, this.getTypeFromChannelName(channelName));
    }

    public Channel.Type getTypeFromChannelName(String name) {
        if (name.startsWith("#")) {
            return Channel.Type.CHANNEL;
        }
        if (name.startsWith("$")) {
            return Channel.Type.WHISPER;
        }
        if (name.startsWith("*")) {
            return Channel.Type.SPECIAL;
        }
        return Channel.Type.NONE;
    }

    public Channel getChannel(Room room, Channel.Type type) {
        Channel panel = this.channels.get(room.getChannel());
        if (panel == null) {
            panel = this.closingChannels.get(room.getChannel());
        }
        if (panel == null) {
            panel = this.addChannel(room, type);
        } else if (panel.setRoom(room)) {
            Debugging.println("Updating Channel Name to " + panel.getName());
        }
        if (panel.getDockContent().isJoining()) {
            panel.getDockContent().setJoining(!this.gui.client.isChannelJoined(panel.getDockContent().getId()));
        }
        return panel;
    }

    private void addDefaultChannel() {
        this.defaultChannel = this.createChannel(Room.EMPTY, Channel.Type.NONE);
        this.defaultChannel.getDockContent().setId(DEFAULT_CHANNEL_ID);
        this.addDefaultChannelToDock();
    }

    private void addDefaultChannelToDock() {
        this.setTargetPath(this.defaultChannel.getDockContent(), "main");
        this.dock.addContent(this.defaultChannel.getDockContent());
    }

    private void setTargetPath(DockContent content) {
        this.setTargetPath(content, this.gui.getSettings().getString("tabsOpen"));
    }

    public void addContent(DockContent content) {
        this.setTargetPath(content);
        this.dock.addContent(content);
    }

    private void setTargetPath(DockContent content, String target) {
        DockContent active;
        DockPath layoutPath = this.getLayoutPath(content.getId());
        content.setTargetPath(null);
        if (layoutPath != null) {
            content.setTargetPath(layoutPath);
        } else if (this.dock.getPathOnRemove(content.getId()) != null) {
            content.setTargetPath(this.dock.getPathOnRemove(content.getId()));
        } else if (target.equals("active")) {
            active = this.dock.getActiveContent();
            if (active != null) {
                content.setTargetPath(active.getPath());
            }
        } else if (target.equals("active2")) {
            DockPopout popout;
            active = this.getActiveContent();
            if (active != null && ((popout = this.dock.getPopoutFromContent(active)) == null && this.gui.isActive() || popout != null && popout.getWindow().isActive())) {
                content.setTargetPath(active.getPath());
            }
        } else if (target.equalsIgnoreCase("activeChan") && this.lastActiveChannel != null) {
            content.setTargetPath(this.lastActiveChannel.getDockContent().getPath());
        }
        if (content.getTargetPath() == null) {
            DockPath path = new DockPath(content);
            path.addParent(DockPathEntry.createPopout(null));
            content.setTargetPath(path);
        }
        this.openedSinceLayoutLoad.add(content.getId());
    }

    private DockPath getLayoutPath(String id) {
        if (this.lastLoadedLayout != null && !this.openedSinceLayoutLoad.contains(id)) {
            return this.lastLoadedLayout.getPath(id);
        }
        return null;
    }

    public Channel addChannel(Room room, Channel.Type type) {
        Channel panel;
        if (this.channels.get(room.getChannel()) != null) {
            return null;
        }
        DockPath layoutPath = this.getLayoutPath(room.getChannel());
        if (this.defaultChannel != null && layoutPath == null) {
            panel = this.defaultChannel;
            this.defaultChannel = null;
            panel.setType(type);
            panel.setRoom(room);
            this.channels.put(room.getChannel(), panel);
        } else {
            panel = this.createChannel(room, type);
            this.channels.put(room.getChannel(), panel);
            this.setTargetPath(panel.getDockContent());
            this.dock.addContent(panel.getDockContent());
            if (type != Channel.Type.WHISPER) {
                this.dock.setActiveContent(panel.getDockContent());
            }
        }
        this.updateActiveContent();
        this.channelChanged();
        return panel;
    }

    private Channel createChannel(Room room, Channel.Type type) {
        Channel channel = new Channel(room, type, this.gui, this.styleManager, this.contextMenuListener, this.insertTop);
        channel.setDockContent(new DockChannelContainer(channel, this.dock, this, this.contextMenuListener));
        channel.init();
        channel.setUserlistWidth(this.defaultUserlistWidth, this.minUserlistWidth);
        channel.setMouseClickedListener(this.mouseClickedListener);
        channel.setScrollbarAlways(this.chatScrollbarAlaways);
        channel.setUserlistEnabled(this.defaultUserlistVisibleState);
        channel.getDockContent().setLive(this.liveStreams.contains(room.getStream()));
        channel.getDockContent().setId(room.getChannel());
        this.updateSettings(channel);
        if (type == Channel.Type.SPECIAL || type == Channel.Type.WHISPER) {
            channel.setUserlistEnabled(false);
        }
        if (!this.gui.getSettings().getBoolean("inputEnabled")) {
            channel.toggleInput();
        }
        return channel;
    }

    public void removeChannel(String channelName) {
        Channel closingChannel;
        Channel channel = this.channels.remove(channelName);
        if (channel != null) {
            this.dock.removeContent(channel.getDockContent());
            channel.cleanUp();
        }
        if ((closingChannel = this.closingChannels.remove(channelName)) != null) {
            closingChannel.cleanUp();
        }
    }

    private void removeContents(Collection<DockContent> contents) {
        for (DockContent c : contents) {
            c.remove();
        }
    }

    private void checkDefaultChannel() {
        if (this.loadingLayout) {
            return;
        }
        Debugging.println("defaultchannel", "Default channel: %s Chans: %s Main Contents: %s", this.defaultChannel != null ? "Present" : "-", this.channels.size(), this.dock.getContents(null).size());
        if (this.defaultChannel == null) {
            if (this.channels.isEmpty()) {
                this.addDefaultChannel();
            } else if (!(!this.dock.isMainEmpty() || this.closeLastChannelPopout && this.dock.closePopout())) {
                this.addDefaultChannel();
            }
        } else if (this.dock.hasContent(this.defaultChannel.getDockContent()) && !this.channels.isEmpty() && this.dock.getContents(null).size() > 1) {
            this.dock.setSetting(DockSetting.Type.KEEP_EMPTY, true);
            this.dock.removeContent(this.defaultChannel.getDockContent());
            this.updateKeepEmptySetting();
            this.defaultChannel.cleanUp();
            this.defaultChannel = null;
            Debugging.println("defaultchannel", "Default channel removed", new Object[0]);
        }
        this.updateActiveContent();
        this.channelChanged();
    }

    public void popout(DockContent content, boolean window) {
        if (!content.canPopout()) {
            return;
        }
        Point location = null;
        Dimension size = null;
        this.clearOpenPopoutsAttributes();
        if (!this.dialogsAttributes.isEmpty()) {
            LocationAndSize attr = this.dialogsAttributes.remove(0);
            if (GuiUtil.isPointOnScreen(attr.location, 5, 5)) {
                location = attr.location;
            }
            size = attr.size;
        }
        this.dock.popout(content, window ? DockSetting.PopoutType.FRAME : DockSetting.PopoutType.DIALOG, location, size);
        this.gui.updateState(true);
    }

    private void dockPopoutOpened(DockPopout popout) {
        this.gui.popoutCreated(popout.getWindow());
        this.checkDefaultChannel();
    }

    private void dockPopoutClosed(DockPopout popout, List<DockContent> contents) {
        if (this.savePopoutAttributes) {
            LocationAndSize attr = new LocationAndSize(popout.getWindow());
            this.dialogsAttributes.remove(attr);
            this.dialogsAttributes.add(0, attr);
        }
        this.checkDefaultChannel();
        this.gui.updateState(true);
    }

    public List getPopoutAttributes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (DockPopout popout : this.dock.getPopouts()) {
            Window w = popout.getWindow();
            result.add(w.getX() + "," + w.getY() + ";" + w.getWidth() + "," + w.getHeight());
        }
        for (LocationAndSize attr : this.dialogsAttributes) {
            result.add(attr.location.x + "," + attr.location.y + ";" + attr.size.width + "," + attr.size.height);
            if (result.size() < 30) continue;
            break;
        }
        return new ArrayList(result);
    }

    public void setPopoutAttributes(List<String> attributes) {
        this.dialogsAttributes.clear();
        for (String attr : attributes) {
            String[] split;
            if (attr == null || (split = attr.split(";")).length != 2) continue;
            Helper.IntegerPair location = Helper.getNumbersFromString(split[0]);
            Helper.IntegerPair size = Helper.getNumbersFromString(split[1]);
            if (location == null || size == null) continue;
            this.dialogsAttributes.add(new LocationAndSize(new Point(location.a, location.b), new Dimension(size.a, size.b)));
        }
    }

    private void clearOpenPopoutsAttributes() {
        for (DockPopout popout : this.dock.getPopouts()) {
            LocationAndSize attr = new LocationAndSize(popout.getWindow());
            this.dialogsAttributes.removeIf(entry -> attr.equals(entry));
        }
    }

    public void setCloseLastChannelPopout(boolean close) {
        this.closeLastChannelPopout = close;
    }

    public void setSavePopoutAttributes(boolean save) {
        this.savePopoutAttributes = save;
        if (!save) {
            this.dialogsAttributes.clear();
        }
    }

    public void setChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    private void channelChanged() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public static Channels getInstance() {
        return instance;
    }

    public Channel getActiveChannel() {
        DockContent activeContent = this.dock.getActiveContent();
        if (activeContent instanceof DockChannelContainer) {
            return (Channel)((DockChannelContainer)activeContent).getContent();
        }
        if (this.doesChannelExist(this.lastActiveChannel)) {
            return this.lastActiveChannel;
        }
        this.resetLastActiveChannel();
        return this.lastActiveChannel;
    }

    private void resetLastActiveChannel() {
        this.lastActiveChannel = null;
        if (!this.channels.isEmpty()) {
            for (Channel chan : this.channels.values()) {
                if (!this.dock.isContentVisible(chan.getDockContent())) continue;
                this.lastActiveChannel = chan;
                break;
            }
            if (this.lastActiveChannel == null) {
                this.lastActiveChannel = this.channels.values().iterator().next();
            }
        } else {
            this.lastActiveChannel = this.defaultChannel;
        }
        Debugging.println("dnda", "Reset last active channel to: %s", this.lastActiveChannel);
    }

    public Channel getLastActiveChannel() {
        return this.getActiveChannel();
    }

    public DockContent getActiveContent() {
        return this.dock.getActiveContent();
    }

    public Channel getMainActiveChannel() {
        DockContent activeContent = this.getMainActiveContent();
        if (activeContent instanceof DockChannelContainer) {
            return (Channel)((DockChannelContainer)activeContent).getContent();
        }
        return null;
    }

    public DockContent getMainActiveContent() {
        return this.dock.getActiveContent(null);
    }

    public Map<DockPopout, DockContent> getActivePopoutContent() {
        HashMap<DockPopout, DockContent> result = new HashMap<DockPopout, DockContent>();
        for (DockPopout popout : this.dock.getPopouts()) {
            result.put(popout, this.dock.getActiveContent(popout));
        }
        return result;
    }

    public Channel getChannelFromInput(Object input) {
        if (this.defaultChannel != null && input == this.defaultChannel.getInput()) {
            return this.defaultChannel;
        }
        for (String key : this.channels.keySet()) {
            Channel value = this.channels.get(key);
            if (input != value.getInput()) continue;
            return value;
        }
        return null;
    }

    public boolean isChannel(String channel) {
        if (channel == null) {
            return false;
        }
        return this.channels.get(channel) != null;
    }

    public Channel getExistingChannel(String channel) {
        return this.channels.get(channel);
    }

    private boolean doesChannelExist(Channel channel) {
        return channel != null && (this.channels.containsValue(channel) || channel == this.defaultChannel);
    }

    public Collection<Channel> getExistingChannelsByOwner(String channel) {
        ArrayList<Channel> result = new ArrayList<Channel>();
        for (Channel chan : this.channels.values()) {
            if (!Objects.equals(chan.getOwnerChannel(), channel)) continue;
            result.add(chan);
        }
        return result;
    }

    public Collection<Channel> channels() {
        return this.channels.values();
    }

    public Collection<Channel> allChannels() {
        if (this.channels.isEmpty() && this.defaultChannel != null) {
            ArrayList<Channel> result = new ArrayList<Channel>();
            result.add(this.defaultChannel);
            return result;
        }
        return this.channels.values();
    }

    public int getChannelCount() {
        return this.channels.size();
    }

    public List<Channel> getChannels() {
        return this.getChannelsOfType(null);
    }

    public List<Channel> getChannelsOfType(Channel.Type type) {
        ArrayList<Channel> result = new ArrayList<Channel>();
        for (DockContent content : this.dock.getContents()) {
            if (!(content.getComponent() instanceof Channel)) continue;
            Channel chan = (Channel)content.getComponent();
            boolean typeMatches = type == null || type == chan.getType();
            if (!typeMatches || !this.doesChannelExist(chan)) continue;
            result.add(chan);
        }
        return result;
    }

    public Collection<DockContent> getTabsRelativeTo(DockContent relativeToContent, int direction, String prefix) {
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        for (DockContent content : this.dock.getContentsRelativeTo(relativeToContent, direction)) {
            if (!content.getId().startsWith(prefix)) continue;
            result.add(content);
        }
        return result;
    }

    public void switchToChannel(String channel) {
        Channel c = this.getExistingChannel(channel);
        if (c != null) {
            this.dock.setActiveContent(c.getDockContent());
        }
    }

    public void switchToNextTab() {
        DockContent c = this.dock.getContentTabRelative(this.getActiveContent(), 1);
        if (c != null) {
            this.dock.setActiveContent(c);
        }
    }

    public void switchToPreviousTab() {
        DockContent c = this.dock.getContentTabRelative(this.getActiveContent(), -1);
        if (c != null) {
            this.dock.setActiveContent(c);
        }
    }

    public void switchToTabId(String id) {
        DockContent c = this.dock.getContentById(id);
        if (c != null) {
            this.dock.setActiveContent(c);
        }
    }

    public void switchToTabIndex(int index) {
        DockContent c = this.dock.getContentTabAbsolute(this.getActiveContent(), index);
        if (c != null) {
            this.dock.setActiveContent(c);
        }
    }

    public boolean hasLineId(String channel, long lineId) {
        Channel chan = this.getExistingChannel(channel);
        if (chan != null) {
            return this.getExistingChannel(channel).hasLineId(lineId);
        }
        return false;
    }

    public void scrollToLineId(String channel, long lineId, String label) {
        this.switchToChannel(channel);
        Channel chan = this.getExistingChannel(channel);
        if (chan != null) {
            chan.scrollToLine(lineId, label);
        }
    }

    public void setInitialFocus() {
        this.setInitialFocus(this.getActiveChannel(), true);
    }

    public void setInitialFocus(Channel channel, boolean later) {
        if (this.gui.getSettings().getLong("inputFocus") != 2L) {
            if (channel == null) {
                channel = this.getActiveChannel();
            }
            if (channel != null) {
                Channel channel2 = channel;
                if (later) {
                    SwingUtilities.invokeLater(() -> channel2.requestFocusInWindow());
                } else {
                    channel2.requestFocusInWindow();
                }
            }
        }
    }

    public void refreshStyles() {
        for (Channel channel : this.getChannels()) {
            channel.refreshStyles();
        }
    }

    public void updateUserlistSettings() {
        for (Channel channel : this.getChannels()) {
            channel.updateUserlistSettings();
        }
    }

    public void setCompletionEnabled(boolean enabled) {
        for (Channel channel : this.getChannels()) {
            channel.setCompletionEnabled(enabled);
        }
    }

    public void setInsertTop(boolean insertTop) {
        this.insertTop = insertTop;
    }

    public void setDefaultUserlistWidth(int width, int minWidth) {
        this.defaultUserlistWidth = width;
        this.minUserlistWidth = minWidth;
        if (this.defaultChannel != null) {
            this.defaultChannel.setUserlistWidth(width, minWidth);
        }
    }

    public void setDefaultUserlistVisibleState(boolean state) {
        this.defaultUserlistVisibleState = state;
        if (this.defaultChannel != null) {
            this.defaultChannel.setUserlistEnabled(state);
        }
    }

    public void setChatScrollbarAlways(boolean always) {
        this.chatScrollbarAlaways = always;
        for (Channel chan : this.channels.values()) {
            chan.setScrollbarAlways(always);
        }
        if (this.defaultChannel != null) {
            this.defaultChannel.setScrollbarAlways(always);
        }
    }

    public static Map<String, Collection<DockContent>> getCloseTabs(Channels channels, DockContent activeContent, boolean sameType) {
        String prefix = sameType ? activeContent.getId().substring(0, 1) : "";
        HashMap<String, Collection<DockContent>> result = new HashMap<String, Collection<DockContent>>();
        result.put("closeAllTabsButCurrent", channels.getTabsRelativeTo(activeContent, 0, prefix));
        result.put("closeAllTabsToLeft", channels.getTabsRelativeTo(activeContent, -1, prefix));
        result.put("closeAllTabsToRight", channels.getTabsRelativeTo(activeContent, 1, prefix));
        Collection<DockContent> all = channels.getTabsRelativeTo(activeContent, 0, prefix);
        all.add(activeContent);
        result.put("closeAllTabs", all);
        ArrayList<DockContent> allOffline = new ArrayList<DockContent>();
        for (DockContent c : all) {
            if (!Channels.isChanOffline(c)) continue;
            allOffline.add(c);
        }
        result.put("closeAllTabsOffline", allOffline);
        List<DockContent> all2 = DockUtil.getContentsByPrefix(channels.getDock().getContents(), prefix);
        all2.remove(activeContent);
        result.put("closeAllTabs2ButCurrent", all2);
        ArrayList<DockContent> all2Offline = new ArrayList<DockContent>();
        result.put("closeAllTabs2", DockUtil.getContentsByPrefix(channels.getDock().getContents(), prefix));
        for (DockContent c : DockUtil.getContentsByPrefix(channels.getDock().getContents(), prefix)) {
            if (!Channels.isChanOffline(c)) continue;
            all2Offline.add(c);
        }
        result.put("closeAllTabs2Offline", all2Offline);
        return result;
    }

    private static boolean isChanOffline(DockContent content) {
        Channel channel;
        if (content instanceof DockChannelContainer && (channel = (Channel)((DockChannelContainer)content).getContent()).getType() == Channel.Type.CHANNEL) {
            return !channel.getDockContent().isLive();
        }
        return false;
    }

    public void closeModPanels() {
        for (Channel chan : this.getChannels()) {
            chan.closeModPanel();
        }
    }

    public void sortContent(String id) {
        if (id == null) {
            this.dock.sortContent(null);
        } else {
            DockContent content = DockUtil.getContentById(this.dock.getContents(), id);
            if (content != null) {
                this.dock.sortContent(content);
            }
        }
    }

    public static long getTabPos(Settings settings, String id) {
        return settings.mapGetLong("tabsPos", id, 0L);
    }

    public static Map<Long, List<String>> getTabPosIds(Settings settings) {
        Map tabsPos = settings.getMap("tabsPos");
        HashMap<Long, List<String>> result = new HashMap<Long, List<String>>();
        for (Map.Entry entry : tabsPos.entrySet()) {
            if (!result.containsKey(entry.getValue())) {
                result.put((Long)entry.getValue(), new ArrayList());
            }
            ((List)result.get(entry.getValue())).add(TabSettings.tabPosLabel((String)entry.getKey()));
        }
        return result;
    }

    public static int makeLoadLayoutOptions(boolean keepCurrentChannels, boolean openLayoutChannels, boolean changeMain) {
        return (keepCurrentChannels ? 1 : 0) | (openLayoutChannels ? 2 : 0) | (changeMain ? 4 : 0);
    }

    private class MyMouseClickedListener
    implements MouseClickedListener {
        private MyMouseClickedListener() {
        }

        @Override
        public void mouseClicked(Channel chan, boolean onlyChangeChan) {
            if (onlyChangeChan) {
                if (Channels.this.getActiveChannel() != chan) {
                    Channels.this.setInitialFocus(chan, false);
                }
            } else {
                Channels.this.setInitialFocus(chan, false);
            }
        }
    }

    public static class DockChannelContainer
    extends DockStyledTabContainer<Channel> {
        private final ContextMenuListener listener;
        private final Channels channels;

        public DockChannelContainer(Channel channel, DockManager m, Channels channels, ContextMenuListener listener) {
            super(channel, channel.getName(), m);
            this.listener = listener;
            this.channels = channels;
        }

        @Override
        public JPopupMenu getContextMenu() {
            Channel channel = (Channel)this.getComponent();
            return new TabContextMenu(this.listener, channel.getDockContent(), Channels.getCloseTabs(this.channels, channel.getDockContent(), this.channels.gui.getSettings().getBoolean("closeTabsSameType")), this.channels.gui.getSettings());
        }

        @Override
        public void remove() {
            this.channels.channelTabClosed((Channel)this.getContent());
        }

        @Override
        public boolean canPopout() {
            return ((Channel)this.getComponent()).getRoom() != Room.EMPTY;
        }

        @Override
        public void setTitle(String title) {
            if (title.isEmpty()) {
                title = Language.getString("tabs.noChannel");
            }
            super.setTitle(title);
        }
    }

    private class ChangeLayoutDialog
    extends JDialog {
        private final List<String> joinChannels;
        private final List<String> addChannels;
        private final List<String> partChannels;
        private final JCheckBox changeMain;
        private final JCheckBox keepCurrentChannels;
        private final JCheckBox openLayoutChannels;
        private final JCheckBox rememberSettings;
        private boolean load;

        ChangeLayoutDialog(Window parent, List<DockContent> current, DockLayout layout, boolean offerMainChange, int options) {
            super(parent);
            this.joinChannels = new ArrayList<String>();
            this.addChannels = new ArrayList<String>();
            this.partChannels = new ArrayList<String>();
            this.setTitle("Load Layout");
            this.setModal(true);
            this.setResizable(false);
            this.setLayout(new GridBagLayout());
            ArrayList<String> currentChannelIds = new ArrayList<String>();
            for (DockContent dockContent : current) {
                if (!dockContent.getId().startsWith("#") && !dockContent.getId().startsWith("$")) continue;
                currentChannelIds.add(dockContent.getId());
            }
            ArrayList<String> layoutChannelIds = new ArrayList<String>();
            for (String id : layout.getContentIds()) {
                if (!id.startsWith("#") && !id.startsWith("$")) continue;
                layoutChannelIds.add(id);
            }
            this.keepCurrentChannels = new JCheckBox(String.format("Keep current channels open (%d)", currentChannelIds.size()));
            this.keepCurrentChannels.setEnabled(!currentChannelIds.isEmpty());
            this.openLayoutChannels = new JCheckBox(String.format("Join channels in layout (%d)", layoutChannelIds.size()));
            this.openLayoutChannels.setEnabled(!layoutChannelIds.isEmpty());
            this.changeMain = new JCheckBox("Load main window location and size");
            this.changeMain.setEnabled(offerMainChange);
            this.rememberSettings = new JCheckBox("Remember current selection");
            JLabel jLabel = new JLabel();
            Runnable updateResults = () -> {
                this.joinChannels.clear();
                this.addChannels.clear();
                this.partChannels.clear();
                if (this.openLayoutChannels.isSelected()) {
                    for (String id : layoutChannelIds) {
                        if (!currentChannelIds.contains(id)) {
                            this.joinChannels.add(id);
                        }
                        this.addChannels.add(id);
                    }
                }
                if (this.keepCurrentChannels.isSelected()) {
                    for (String id : currentChannelIds) {
                        if (this.addChannels.contains(id)) continue;
                        this.addChannels.add(id);
                    }
                } else {
                    for (String id : currentChannelIds) {
                        if (this.addChannels.contains(id)) continue;
                        this.partChannels.add(id);
                    }
                }
                result.setText(String.format("Open %d channels, Close %d channels", this.joinChannels.size(), this.partChannels.size()));
            };
            JPanel optionsPanel = new JPanel(new GridBagLayout());
            optionsPanel.setBorder(BorderFactory.createEtchedBorder());
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 1, 1, 1, 17);
            gbc.insets = new Insets(1, 5, 1, 5);
            optionsPanel.add((Component)this.keepCurrentChannels, gbc);
            gbc = GuiUtil.makeGbc(0, 2, 1, 1, 17);
            gbc.insets = new Insets(1, 5, 1, 5);
            optionsPanel.add((Component)this.openLayoutChannels, gbc);
            gbc = GuiUtil.makeGbc(0, 3, 1, 1, 17);
            gbc.insets = new Insets(2, 5, 5, 5);
            optionsPanel.add((Component)jLabel, gbc);
            gbc = GuiUtil.makeGbc(0, 4, 2, 1, 17);
            optionsPanel.add((Component)this.changeMain, gbc);
            JButton loadLayout = new JButton("Load Layout");
            loadLayout.addActionListener(e -> {
                this.load = true;
                this.setVisible(false);
            });
            ItemListener checkboxListener = e -> updateResults.run();
            this.keepCurrentChannels.addItemListener(checkboxListener);
            this.openLayoutChannels.addItemListener(checkboxListener);
            this.keepCurrentChannels.setSelected(MiscUtil.isBitEnabled(options, 1));
            this.openLayoutChannels.setSelected(MiscUtil.isBitEnabled(options, 2));
            this.changeMain.setSelected(MiscUtil.isBitEnabled(options, 4));
            updateResults.run();
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(e -> {
                this.load = false;
                this.setVisible(false);
            });
            Icon icon = UIManager.getIcon("OptionPane.questionIcon");
            if (icon != null) {
                gbc = GuiUtil.makeGbc(0, 0, 1, 1);
                gbc.insets = new Insets(10, 10, 10, 10);
                this.add((Component)new JLabel(icon), gbc);
            }
            gbc = GuiUtil.makeGbc(1, 0, 2, 1, 13);
            this.add((Component)new JLabel("<html><body width='250px'><p>Docked info dialogs ('Dock as tab'-option in their context menu) will be opened/closed to match the loaded layout, however non-docked dialogs are not affected.</p><p style='margin-top:5px;'>Channels will be joined/parted depending on the selection below.</p>"), gbc);
            gbc = GuiUtil.makeGbc(1, 5, 2, 1);
            gbc.fill = 2;
            this.add((Component)optionsPanel, gbc);
            gbc = GuiUtil.makeGbc(1, 11, 2, 1, 17);
            gbc.insets = new Insets(3, 5, 3, 5);
            this.add((Component)this.rememberSettings, gbc);
            gbc = GuiUtil.makeGbc(1, 10, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.add((Component)loadLayout, gbc);
            gbc = GuiUtil.makeGbc(2, 10, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(5, 5, 5, 10);
            this.add((Component)cancel, gbc);
            this.pack();
            this.setLocationRelativeTo(parent);
            GuiUtil.installEscapeCloseOperation(this);
        }

        public boolean shouldLoad() {
            return this.load;
        }

        public List<String> getJoinChannels() {
            return this.joinChannels;
        }

        public List<String> getPartChannels() {
            return this.partChannels;
        }

        public List<String> getAddChannels() {
            return this.addChannels;
        }

        public boolean loadMain() {
            return this.changeMain.isSelected();
        }

        public int getOptions() {
            return Channels.makeLoadLayoutOptions(this.keepCurrentChannels.isSelected(), this.openLayoutChannels.isSelected(), this.changeMain.isSelected());
        }

        private boolean saveOptions() {
            return this.rememberSettings.isSelected();
        }
    }

    private static class LocationAndSize {
        public final Point location;
        public final Dimension size;

        public LocationAndSize(Window window) {
            this.location = window.getLocation();
            this.size = window.getSize();
        }

        LocationAndSize(Point location, Dimension size) {
            this.location = location;
            this.size = size;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocationAndSize other = (LocationAndSize)obj;
            if (!Objects.equals(this.location, other.location)) {
                return false;
            }
            return Objects.equals(this.size, other.size);
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + Objects.hashCode(this.location);
            hash = 79 * hash + Objects.hashCode(this.size);
            return hash;
        }
    }

    private class ClosingDialog
    extends JDialog {
        private final JCheckBox rememberChoice;
        private String result;

        ClosingDialog(DockPopout popout) {
            super(popout.getWindow());
            this.result = "";
            this.setTitle(Language.getString("popoutClose.title"));
            this.setModal(true);
            this.setResizable(false);
            this.setLayout(new GridBagLayout());
            JButton closeChannels = new JButton(Language.getString("settings.string.popoutClose.option.close"));
            closeChannels.addActionListener(e -> {
                this.result = "close";
                this.setVisible(false);
            });
            JButton moveChannels = new JButton(Language.getString("settings.string.popoutClose.option.move"));
            moveChannels.addActionListener(e -> {
                this.result = "move";
                this.setVisible(false);
            });
            this.rememberChoice = new JCheckBox(Language.getString("popoutClose.rememberChoice"));
            GridBagConstraints gbc = GuiUtil.makeGbc(1, 0, 1, 1);
            Icon icon = UIManager.getIcon("OptionPane.questionIcon");
            if (icon != null) {
                gbc = GuiUtil.makeGbc(0, 0, 1, 1);
                gbc.insets = new Insets(10, 10, 10, 10);
                this.add((Component)new JLabel(icon), gbc);
            }
            gbc = GuiUtil.makeGbc(1, 0, 2, 1, 13);
            this.add((Component)new JLabel("<html><body width='250px'><p>" + Language.getString("popoutClose.question") + "</p><p style='margin-top:5px;'>" + Language.getString("popoutClose.keyTip") + "</p>"), gbc);
            gbc = GuiUtil.makeGbc(1, 1, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.add((Component)closeChannels, gbc);
            gbc = GuiUtil.makeGbc(2, 1, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(5, 5, 5, 10);
            this.add((Component)moveChannels, gbc);
            gbc = GuiUtil.makeGbc(1, 2, 2, 1, 13);
            gbc.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.rememberChoice, gbc);
            this.pack();
            this.setLocationRelativeTo(popout.getWindow());
            this.setVisible(true);
        }

        public String getChoice() {
            return this.result;
        }

        public boolean shouldSaveChoice() {
            return this.rememberChoice.isSelected();
        }
    }
}

