/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.gui.laf.LaF;
import chatty.util.dnd.DockContentContainer;
import chatty.util.dnd.DockManager;
import chatty.util.dnd.DockTabComponent;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class DockStyledTabContainer<T extends JComponent>
extends DockContentContainer<T> {
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int COLOR1 = 4;
    public static final int COLOR2 = 8;
    public static final int DOT1 = 16;
    public static final int DOT2 = 32;
    public static final int ASTERISK = 64;
    public static final int LINE = 128;
    public static final int CUSTOM_COLOR = 256;
    public static final int CUSTOM_COLOR_START_BIT = 16;
    private static final Border BORDER_INACTIVE = BorderFactory.createEmptyBorder(0, 3, 0, 3);
    private static final Border BORDER_ACTIVE = BorderFactory.createEmptyBorder(0, 0, 0, 6);
    private final TabComponent tab = new TabComponent();
    private boolean isLive;
    private long liveSetting;
    private boolean hasMessages;
    private long messageSetting;
    private boolean hasHighlight;
    private long highlightSetting;
    private boolean hasStatus;
    private long statusSetting;
    private boolean isActive;
    private long activeSetting;
    private boolean isJoining;
    private Color foreground;
    private Color defaultForeground = this.getForegroundColor();
    private Font defaultFont = this.tab.getFont();
    private boolean fontNoBold;
    private boolean fontNoItalic;
    private boolean fontBold;
    private boolean fontItalic;
    private Border border;
    private String suffix;
    private boolean dot1;
    private boolean dot2;
    private boolean line;
    private Color dot1Color;
    private Color dot2Color;
    private Color lineColor;

    public DockStyledTabContainer(T content, String title, DockManager m) {
        super(title, content, m);
    }

    public void setActive(boolean isActive) {
        if (isActive != this.isActive) {
            this.isActive = isActive;
            this.update();
        }
    }

    public void setLive(boolean isLive) {
        if (isLive != this.isLive) {
            this.isLive = isLive;
            this.update();
        }
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void setNewMessage(boolean hasMessage) {
        if (hasMessage != this.hasMessages) {
            this.hasMessages = hasMessage;
            this.update();
        }
    }

    public boolean hasNewMessages() {
        return this.hasMessages;
    }

    public void setNewHighlight(boolean hasHighlight) {
        if (hasHighlight != this.hasHighlight) {
            this.hasHighlight = hasHighlight;
            this.update();
        }
    }

    public boolean hasNewHighlight() {
        return this.hasHighlight;
    }

    public void setNewStatus(boolean newStatus) {
        if (newStatus != this.hasStatus) {
            this.hasStatus = newStatus;
            this.update();
        }
    }

    public void resetNew() {
        if (this.hasMessages || this.hasHighlight || this.hasStatus) {
            this.hasMessages = false;
            this.hasHighlight = false;
            this.hasStatus = false;
            this.update();
        }
    }

    public void setJoining(boolean isJoining) {
        if (isJoining != this.isJoining) {
            this.isJoining = isJoining;
            this.update();
        }
    }

    public boolean isJoining() {
        return this.isJoining;
    }

    public void setSettings(long liveSetting, long messageSetting, long highlightSetting, long statusSetting, long activeSetting, long maxWidth) {
        this.liveSetting = liveSetting;
        this.messageSetting = messageSetting;
        this.highlightSetting = highlightSetting;
        this.statusSetting = statusSetting;
        this.activeSetting = activeSetting;
        this.tab.setMaxWidth(maxWidth);
        this.update();
    }

    private void update() {
        String newText;
        this.border = null;
        this.dot1 = false;
        this.dot2 = false;
        this.line = false;
        this.fontNoItalic = false;
        this.fontNoBold = false;
        this.fontItalic = false;
        this.fontBold = false;
        this.dot1Color = new Color(255, 100, 100);
        this.dot2Color = new Color(100, 100, 255);
        this.lineColor = this.defaultForeground;
        this.foreground = this.defaultForeground;
        this.suffix = "";
        this.update(this.isLive, this.liveSetting);
        this.update(this.hasMessages, this.messageSetting);
        this.update(this.hasStatus, this.statusSetting);
        this.update(this.hasHighlight, this.highlightSetting);
        this.update(this.isActive, this.activeSetting);
        int fontStyle = this.defaultFont.getStyle();
        if (this.fontNoItalic) {
            fontStyle &= 0xFFFFFFFD;
        }
        if (this.fontNoBold) {
            fontStyle &= 0xFFFFFFFE;
        }
        if (this.fontItalic) {
            fontStyle |= 2;
        }
        if (this.fontBold) {
            fontStyle |= 1;
        }
        this.tab.setBorder(this.border);
        this.tab.setFont(this.defaultFont.deriveFont(fontStyle));
        if (this.isJoining && this.foreground != null) {
            this.foreground = new Color(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue(), 140);
        }
        if (!Objects.equals(this.foreground, this.tab.getForeground())) {
            this.tab.setForeground(this.foreground);
        }
        if (!(newText = this.getTitle() + this.suffix).equals(this.tab.getText())) {
            this.tab.setText(newText);
        }
    }

    private void update(boolean enabled, long setting) {
        if (enabled) {
            Color customColor = null;
            if (this.isEnabled(setting, 256L)) {
                customColor = DockStyledTabContainer.decodeColor(setting, 16);
            }
            if (this.isEnabled(setting, 16L)) {
                this.border = BORDER_ACTIVE;
                this.dot1 = true;
                if (customColor != null) {
                    this.dot1Color = customColor;
                }
            }
            if (this.isEnabled(setting, 32L)) {
                this.border = BORDER_ACTIVE;
                this.dot2 = true;
                if (customColor != null) {
                    this.dot2Color = customColor;
                }
            }
            if (this.isEnabled(setting, 128L)) {
                this.line = true;
                if (customColor != null) {
                    this.lineColor = customColor;
                }
            }
            if (this.isEnabled(setting, 2L)) {
                this.fontItalic = true;
            }
            if (this.isEnabled(setting, 1L)) {
                this.fontBold = true;
            }
            if (this.isEnabled(setting, 4L)) {
                this.foreground = customColor != null ? customColor : LaF.getTabForegroundUnread();
            }
            if (this.isEnabled(setting, 8L)) {
                this.foreground = customColor != null ? customColor : LaF.getTabForegroundHighlight();
            }
            if (this.isEnabled(setting, 64L)) {
                this.suffix = "*";
            }
        } else {
            if (this.isEnabled(setting, 16L) && this.border == null) {
                this.border = BORDER_INACTIVE;
            }
            if (this.isEnabled(setting, 32L) && this.border == null) {
                this.border = BORDER_INACTIVE;
            }
            if (this.isEnabled(setting, 2L)) {
                this.fontNoItalic = true;
            }
            if (this.isEnabled(setting, 1L)) {
                this.fontNoBold = true;
            }
        }
    }

    private boolean isEnabled(long settingValue, long optionConstant) {
        return (settingValue & optionConstant) != 0L;
    }

    public static long encodeColor(Color color, long value, int startBit) {
        value |= (long)color.getRed() << startBit;
        value |= (long)color.getGreen() << startBit + 8;
        return value |= (long)color.getBlue() << startBit + 16;
    }

    public static Color decodeColor(long value, int startBit) {
        int red = (int)(value >> startBit & 0xFFL);
        int green = (int)(value >> startBit + 8 & 0xFFL);
        int blue = (int)(value >> startBit + 16 & 0xFFL);
        return new Color(red, green, blue);
    }

    @Override
    public void setTitle(String title) {
        if (title.isEmpty()) {
            title = "-";
        }
        super.setTitle(title);
        this.tab.setText(title);
    }

    @Override
    public void setForegroundColor(Color color) {
        this.tab.setForeground(color);
    }

    @Override
    public DockTabComponent getTabComponent() {
        return this.tab;
    }

    private class TabComponent
    extends JLabel
    implements DockTabComponent {
        private long maxWidth;

        private TabComponent() {
        }

        @Override
        public void paintComponent(Graphics g) {
            int b = (int)((double)this.getHeight() * 0.2);
            if (DockStyledTabContainer.this.dot1) {
                g.setColor(DockStyledTabContainer.this.dot1Color);
                g.fillRect(this.getWidth() - 4, b, 4, 4);
            }
            if (DockStyledTabContainer.this.dot2) {
                g.setColor(DockStyledTabContainer.this.dot2Color);
                g.fillRect(this.getWidth() - 4, b + 6, 4, 4);
            }
            if (DockStyledTabContainer.this.line) {
                this.paintLine(g, 0, 1, 180, 20);
                this.paintLine(g, 1, 4, 100, 0);
            }
            super.paintComponent(g);
        }

        private void paintLine(Graphics g, int y, int fadeLength, int baseAlpha, int lowestAlpha) {
            fadeLength = (fadeLength = Math.min(fadeLength, this.getWidth() / 3)) > 0 ? fadeLength : 1;
            int alphaStep = (baseAlpha - lowestAlpha) / fadeLength;
            g.setColor(new Color(DockStyledTabContainer.this.lineColor.getRed(), DockStyledTabContainer.this.lineColor.getGreen(), DockStyledTabContainer.this.lineColor.getBlue(), baseAlpha));
            g.drawLine(fadeLength, y, this.getWidth() - fadeLength - 1, y);
            for (int i = 0; i < fadeLength; ++i) {
                int xLeft = i;
                int xRight = this.getWidth() - 1 - i;
                int pixelAlpha = lowestAlpha + i * alphaStep;
                g.setColor(new Color(DockStyledTabContainer.this.lineColor.getRed(), DockStyledTabContainer.this.lineColor.getGreen(), DockStyledTabContainer.this.lineColor.getBlue(), pixelAlpha));
                g.drawLine(xLeft, y, xLeft, y);
                g.drawLine(xRight, y, xRight, y);
            }
        }

        @Override
        public void update(JTabbedPane pane, int index) {
            Font font;
            boolean changed = false;
            Color foreground = pane.getUI() instanceof BaseTabbedPaneUI && pane.getSelectedIndex() == index ? AbstractLookAndFeel.getTheme().getTabSelectionForegroundColor() : pane.getForegroundAt(index);
            if (!Objects.equals(foreground, DockStyledTabContainer.this.defaultForeground)) {
                DockStyledTabContainer.this.defaultForeground = foreground;
                changed = true;
            }
            if (!Objects.equals(font = pane.getFont(), DockStyledTabContainer.this.defaultFont)) {
                DockStyledTabContainer.this.defaultFont = font;
                changed = true;
            }
            if (changed) {
                DockStyledTabContainer.this.update();
            }
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        public void setMaxWidth(long maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (this.maxWidth > 0L && (long)d.width > this.maxWidth) {
                return new Dimension((int)this.maxWidth, d.height);
            }
            return d;
        }
    }
}

