/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.Helper;
import chatty.gui.Channels;
import chatty.gui.DockStyledTabContainer;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.Channel;
import chatty.gui.components.menus.ContextMenu;
import chatty.util.MiscUtil;
import chatty.util.dnd.DockContent;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class DockedDialogHelper {
    public static final int DOCKED = 1;
    public static final int AUTO_OPEN = 2;
    public static final int AUTO_OPEN_ACTIVITY = 4;
    public static final int FIXED_CHANNEL = 8;
    private final DockedDialog dialog;
    private final DockContent content;
    private final Channels channels;
    private final Settings settings;
    private final MainGui gui;
    private boolean isDocked;
    private boolean autoOpen;
    private boolean autoOpenActivity;
    private boolean fixedChannel;
    private String currentChannel;
    private Consumer<String> channelChangeListener;

    public DockedDialogHelper(DockedDialog dialog, MainGui gui, Channels channels, Settings settings) {
        this.dialog = dialog;
        this.content = dialog.getContent();
        this.gui = gui;
        this.channels = channels;
        this.settings = settings;
    }

    public DockContent getContent() {
        return this.content;
    }

    public void setVisible(boolean visible, boolean switchTo) {
        if (visible == this.isVisible()) {
            return;
        }
        if (this.isDocked) {
            if (visible) {
                this.channels.addContent(this.content);
                if (switchTo) {
                    this.channels.getDock().setActiveContent(this.content);
                }
            } else {
                this.channels.getDock().removeContent(this.content);
            }
        } else {
            if (!switchTo) {
                GuiUtil.setNonAutoFocus(this.dialog.getWindow());
            }
            this.dialog.setVisible(visible);
        }
        if (visible) {
            this.gui.openWindow(this.dialog.getWindow());
        }
    }

    public boolean isVisible() {
        if (this.isDocked) {
            return this.channels.getDock().hasContent(this.content);
        }
        return this.dialog.isVisible();
    }

    public boolean isContentVisible() {
        if (this.isDocked) {
            return this.channels.getDock().isContentVisible(this.content);
        }
        return this.dialog.isVisible();
    }

    public void setDocked(boolean docked) {
        if (this.isDocked != docked && this.isVisible()) {
            this.toggleDock();
        }
        this.isDocked = docked;
        this.dialog.dockedChanged();
    }

    public void toggleDock() {
        if (this.isDocked) {
            this.channels.getDock().removeContent(this.content);
            this.dialog.addComponent(this.content.getComponent());
            this.isDocked = false;
            this.gui.setWindowPosition(this.dialog.getWindow());
            this.dialog.setVisible(true);
        } else {
            this.dialog.removeComponent(this.content.getComponent());
            this.channels.addContent(this.content);
            this.channels.getDock().setActiveContent(this.content);
            this.isDocked = true;
            this.dialog.setVisible(false);
        }
        this.saveSettings();
        this.dialog.dockedChanged();
    }

    public void menuAction(ActionEvent e) {
        String channel;
        switch (e.getActionCommand()) {
            case "dockToggleDocked": {
                this.toggleDock();
                break;
            }
            case "dockToggleAutoOpen": {
                this.autoOpen = !this.autoOpen;
                this.saveSettings();
                break;
            }
            case "dockToggleAutoOpenActivity": {
                this.autoOpenActivity = !this.autoOpenActivity;
                this.saveSettings();
                break;
            }
            case "dockToggleFixedChannel": {
                this.fixedChannel = !this.fixedChannel;
                this.saveSettings();
            }
        }
        if (e.getActionCommand().startsWith("dockChangeChannel.") && !(channel = e.getActionCommand().substring("dockChangeChannel.".length())).isEmpty() && this.channelChangeListener != null) {
            this.channelChangeListener.accept(channel);
        }
    }

    private void saveSettings() {
        int value = this.isDocked ? 1 : 0;
        value |= this.autoOpen ? 2 : 0;
        value |= this.autoOpenActivity ? 4 : 0;
        this.settings.mapPut("dock", this.content.getId(), value |= this.fixedChannel ? 8 : 0);
    }

    public void loadSettings() {
        int value = 0;
        Object o = this.settings.mapGet("dock", this.content.getId());
        if (o != null && o instanceof Number) {
            value = ((Number)o).intValue();
        }
        this.setDocked(MiscUtil.isBitEnabled(value, 1));
        this.setVisible(MiscUtil.isBitEnabled(value, 2), false);
        this.autoOpenActivity = MiscUtil.isBitEnabled(value, 2);
        this.fixedChannel = MiscUtil.isBitEnabled(value, 8);
    }

    public void loadTabSettings() {
        if (this.content instanceof DockStyledTabContainer) {
            ((DockStyledTabContainer)this.content).setSettings(0L, this.settings.getLong("tabsMessage"), 0L, 0L, 0L, -1L);
        }
    }

    public void setActivity() {
        if (this.autoOpenActivity) {
            this.setVisible(true, false);
        }
    }

    public void setNewMessage() {
        if (this.isDocked() && !this.channels.getDock().isContentVisible(this.content) && this.content instanceof DockStyledTabContainer) {
            ((DockStyledTabContainer)this.content).setNewMessage(true);
        }
    }

    public void resetNewMessage() {
        if (this.content instanceof DockStyledTabContainer) {
            ((DockStyledTabContainer)this.content).setNewMessage(false);
        }
    }

    public boolean isDocked() {
        return this.isDocked;
    }

    public boolean autoOpen() {
        return this.autoOpen;
    }

    public boolean autoOpenActivity() {
        return this.autoOpenActivity;
    }

    public void installContextMenu(Component c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DockedDialogHelper.this.openContextMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DockedDialogHelper.this.openContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DockedDialogHelper.this.openContextMenu(e);
            }
        });
    }

    private void openContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            MyContextMenu menu = new MyContextMenu();
            this.addToContextMenu(menu);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void addToContextMenu(ContextMenu menu) {
        menu.addCheckboxItem("dockToggleDocked", "Dock as tab", this.isDocked);
        if (this.channelChangeListener != null) {
            DockedDialogHelper.addChannelSelectionToContextMenu(menu, this.channels.getChannelsOfType(Channel.Type.CHANNEL), this.fixedChannel, false, false, this.currentChannel);
        }
    }

    public static void addChannelSelectionToContextMenu(ContextMenu menu, List<Channel> open, boolean fixedChannelEnabled, boolean addAllEntry, boolean showAll, String currentChannel) {
        JMenuItem selectedChannel;
        String optionsLabel = "Options";
        String openChansLabel = "Channel";
        JMenu changeChanMenu = new JMenu(optionsLabel);
        JMenu openChansMenu = new JMenu(openChansLabel);
        openChansMenu.setToolTipText("All open chans, active tabs marked with *");
        menu.registerSubmenu(changeChanMenu);
        menu.registerSubmenu(openChansMenu);
        Collections.sort(open, (o1, o2) -> o1.getChannel().compareTo(o2.getChannel()));
        if (!open.isEmpty()) {
            menu.add(openChansMenu);
            if (addAllEntry) {
                menu.addCheckboxItem("dockChannelsShowAll", "All", openChansLabel, showAll);
                menu.addSeparator(openChansLabel);
            }
        }
        for (Channel chan : open) {
            menu.addRadioItem("dockChangeChannel." + chan.getChannel(), chan.getChannel() + (chan.getDockContent().isContentVisible() ? "*" : ""), "chansGroup", openChansLabel);
        }
        if (currentChannel != null && (selectedChannel = menu.getItem("dockChangeChannel." + currentChannel)) != null) {
            selectedChannel.setSelected(true);
        }
        menu.add(changeChanMenu);
        menu.addCheckboxItem("dockToggleFixedChannel", "Channel Fixed", optionsLabel, fixedChannelEnabled);
        menu.getItem("dockToggleFixedChannel").setToolTipText("Stay on the channel it was opened on (or the first channel joined if it was open on start)");
    }

    public void setChannelChangeListener(Consumer<String> listener) {
        this.channelChangeListener = listener;
    }

    public void channelChanged(String channel) {
        if (this.channelChangeListener != null && !this.fixedChannel) {
            this.channelChangeListener.accept(channel);
        }
    }

    public void setCurrentChannel(String channel) {
        this.currentChannel = Helper.toChannel(channel);
    }

    public static abstract class DockedDialog {
        public abstract void setVisible(boolean var1);

        public abstract boolean isVisible();

        public abstract void addComponent(Component var1);

        public abstract void removeComponent(Component var1);

        public abstract Window getWindow();

        public abstract DockContent getContent();

        public void dockedChanged() {
        }
    }

    private class MyContextMenu
    extends ContextMenu {
        private MyContextMenu() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DockedDialogHelper.this.menuAction(e);
        }
    }
}

