/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.gui.Channels;
import chatty.gui.DockStyledTabContainer;
import chatty.gui.DockedDialogHelper;
import chatty.gui.MainGui;
import chatty.gui.components.Channel;
import chatty.gui.components.menus.TabContextMenu;
import chatty.util.BatchAction;
import chatty.util.Debugging;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockContentContainer;
import chatty.util.dnd.DockManager;
import chatty.util.settings.Settings;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class DockedDialogManager {
    private final Map<String, DockedDialogHelper> dialogs = new HashMap<String, DockedDialogHelper>();
    private final Channels channels;
    private final MainGui gui;
    private final Settings settings;
    private final Object channelChangedUnique = new Object();

    public DockedDialogManager(MainGui gui, Channels channels, Settings settings) {
        this.gui = gui;
        this.channels = channels;
        this.settings = settings;
        settings.addSettingChangeListener((setting, type, value) -> {
            if (setting.equals("tabsMessage")) {
                SwingUtilities.invokeLater(() -> this.loadTabSettings());
            }
        });
    }

    public DockManager getDockManager() {
        return this.channels.getDock();
    }

    public DockContent createContent(JComponent component, String title, String id) {
        DockContentContainer content = new DockContentContainer(title, component, this.channels.getDock()){

            @Override
            public JPopupMenu getContextMenu() {
                return DockedDialogManager.this.getPopupMenu(this);
            }
        };
        content.setId(id);
        return content;
    }

    public DockStyledTabContainer<JComponent> createStyledContent(JComponent component, String title, String id) {
        DockStyledTabContainer<JComponent> content = new DockStyledTabContainer<JComponent>(component, title, this.getDockManager()){

            @Override
            public JPopupMenu getContextMenu() {
                return DockedDialogManager.this.getPopupMenu(this);
            }
        };
        content.setId(id);
        return content;
    }

    private JPopupMenu getPopupMenu(DockContent content) {
        return new TabContextMenu(this.gui.contextMenuListener, content, Channels.getCloseTabs(this.channels, content, this.settings.getBoolean("closeTabsSameType")), this.settings);
    }

    public DockedDialogHelper createHelper(DockedDialogHelper.DockedDialog dialog) {
        DockedDialogHelper helper = new DockedDialogHelper(dialog, this.gui, this.channels, this.settings);
        helper.loadTabSettings();
        this.register(helper);
        return helper;
    }

    public void register(DockedDialogHelper helper) {
        this.dialogs.put(helper.getContent().getId(), helper);
    }

    public void loadSettings() {
        for (DockedDialogHelper helper : this.dialogs.values()) {
            helper.loadSettings();
        }
    }

    public void loadTabSettings() {
        for (DockedDialogHelper helper : this.dialogs.values()) {
            helper.loadTabSettings();
        }
    }

    public void openInDock(String id) {
        if (this.dialogs.containsKey(id)) {
            DockedDialogHelper helper = this.dialogs.get(id);
            helper.setDocked(true);
            helper.setVisible(true, false);
        }
    }

    public void closeFromDock(String id) {
        DockedDialogHelper helper;
        if (this.dialogs.containsKey(id) && (helper = this.dialogs.get(id)).isDocked()) {
            helper.setVisible(false, false);
        }
    }

    public void activeContentChanged() {
        DockContent content = this.channels.getActiveContent();
        if (content.getComponent() instanceof Channel) {
            Channel chan = (Channel)content.getComponent();
            if (chan.getType() == Channel.Type.CHANNEL) {
                String channel = chan.getChannel();
                Debugging.println("changechan", "Set channel to %s", channel);
                BatchAction.queue(this.channelChangedUnique, 300L, true, true, () -> {
                    for (DockedDialogHelper helper : this.dialogs.values()) {
                        helper.channelChanged(channel);
                    }
                });
            }
        } else {
            BatchAction.queue(this.channelChangedUnique, 300L, true, true, () -> Debugging.println("changechan", "Prevented channel change", new Object[0]));
        }
    }
}

