/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.Helper;
import chatty.gui.components.SimplePopup;
import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.laf.LaF;
import chatty.util.Debugging;
import chatty.util.MiscUtil;
import chatty.util.Pair;
import chatty.util.ProcessManager;
import chatty.util.StringUtil;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class GuiUtil {
    private static final Logger LOGGER = Logger.getLogger(GuiUtil.class.getName());
    public static final Insets NORMAL_BUTTON_INSETS = new Insets(2, 14, 2, 14);
    public static final Insets SMALLER_BUTTON_INSETS = new Insets(0, 4, 0, 4);
    public static final Insets SPECIAL_BUTTON_INSETS = new Insets(2, 12, 2, 6);
    public static final Insets SPECIAL_SMALL_BUTTON_INSETS = new Insets(-1, 12, -1, 6);
    private static final String CLOSE_DIALOG_ACTION_MAP_KEY = "CLOSE_DIALOG_ACTION_MAP_KEY";
    private static final KeyStroke ESCAPE_STROKE = KeyStroke.getKeyStroke(27, 0);
    private static final int MOUSE_LOCATION_HGAP = 60;
    public static boolean inputLimitsEnabled;

    public static void smallButtonInsets(AbstractButton button) {
        button.setMargin(LaF.defaultButtonInsets() ? null : new Insets(-1, 10, -1, 10));
    }

    public static void smallButtonInsetsSquare(AbstractButton button) {
        button.setMargin(LaF.defaultButtonInsets() ? null : new Insets(0, 0, 0, 0));
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction closingAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(ESCAPE_STROKE, CLOSE_DIALOG_ACTION_MAP_KEY);
        root.getActionMap().put(CLOSE_DIALOG_ACTION_MAP_KEY, closingAction);
    }

    public static int showNonAutoFocusOptionPane(Component parent, String title, String message, int messageType, int optionType, Object[] options) {
        JOptionPane p = new JOptionPane(message, messageType, optionType);
        p.setOptions(options);
        JDialog d = p.createDialog(parent, title);
        GuiUtil.setNonAutoFocus(d);
        d.setVisible(true);
        Object value = p.getValue();
        for (int i = 0; i < options.length; ++i) {
            if (options[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static void setNonAutoFocus(Window w) {
        w.setAutoRequestFocus(false);
        w.setFocusableWindowState(false);
        SwingUtilities.invokeLater(() -> w.setFocusableWindowState(true));
    }

    public static void showNonModalMessage(Component parent, String title, String message, int type) {
        GuiUtil.showNonModalMessage(parent, title, message, type, false);
    }

    public static void showNonModalMessage(Component parent, String title, String message, int type, boolean allowHtml) {
        if (!allowHtml) {
            message = Helper.htmlspecialchars_encode(message);
        }
        message = "<html><body style='font-family: Monospaced;width:400px;'>" + message;
        JOptionPane pane = new JOptionPane(message, type);
        JDialog dialog = pane.createDialog(parent, title);
        dialog.setModal(false);
        dialog.setVisible(true);
    }

    public static boolean isPointOnScreen(Point p, int xOffset, int yOffset) {
        Point moved = new Point(p.x + xOffset, p.y + yOffset);
        return GuiUtil.isPointOnScreen(moved);
    }

    public static boolean isPointOnScreen(Point p) {
        GraphicsDevice[] screens;
        for (GraphicsDevice screen : screens = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            if (!screen.getDefaultConfiguration().getBounds().contains(p)) continue;
            return true;
        }
        return false;
    }

    public static void setLocationToMouse(Component c) {
        if (c.getGraphicsConfiguration() == null) {
            return;
        }
        Rectangle screen = GuiUtil.getEffectiveScreenBounds(MouseInfo.getPointerInfo().getDevice().getDefaultConfiguration());
        Point mouseLocation = new Point(MouseInfo.getPointerInfo().getLocation());
        int width = c.getWidth();
        int height = c.getHeight();
        mouseLocation.translate(-width - 60, -height / 2);
        if (mouseLocation.y < screen.y) {
            mouseLocation.y = screen.y;
        }
        if (mouseLocation.y + height > screen.y + screen.height) {
            mouseLocation.y = screen.y + screen.height - height;
        }
        if (mouseLocation.x < screen.x) {
            mouseLocation.x += width + 120;
        }
        if (mouseLocation.x + width > screen.x + screen.width) {
            mouseLocation.x -= width + 120;
        }
        c.setLocation(mouseLocation);
    }

    public static Point getLocationWithinBounds(Rectangle bounds, Dimension size, int x, int y) {
        if (y + size.height > bounds.y + bounds.height) {
            y = bounds.y + bounds.height - size.height;
        }
        if (y < bounds.y) {
            y = bounds.y;
        }
        if (x + size.width > bounds.x + bounds.width) {
            x = bounds.x + bounds.width - size.width;
        }
        if (x < bounds.x) {
            x = bounds.x;
        }
        return new Point(x, y);
    }

    public static void setLocationRelativeTo(Window w, Component source) {
        if (source == null || !source.isShowing()) {
            w.setLocationRelativeTo(source);
        }
        Dimension wSize = w.getSize();
        Dimension sourceSize = source.getSize();
        Point location = source.getLocationOnScreen();
        int x = location.x + sourceSize.width / 2 - wSize.width / 2;
        int y = location.y + sourceSize.height / 2 - wSize.height / 2;
        Rectangle bounds = GuiUtil.getEffectiveScreenBounds(source);
        w.setLocation(GuiUtil.getLocationWithinBounds(bounds, w.getSize(), x, y));
    }

    public static Rectangle getEffectiveScreenBounds(GraphicsConfiguration config) {
        Rectangle bounds = new Rectangle(config.getBounds());
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        Debugging.println("screenbounds", "%s %s", bounds, insets);
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.right + insets.left;
        bounds.height -= insets.bottom + insets.top;
        return bounds;
    }

    public static Rectangle getEffectiveScreenBounds(Component c) {
        GraphicsConfiguration config = c.getGraphicsConfiguration();
        if (config == null) {
            return null;
        }
        return GuiUtil.getEffectiveScreenBounds(config);
    }

    public static void shake(Window window, int intensity, int length) {
        Point original = window.getLocation();
        for (int i = 0; i < length; ++i) {
            try {
                Thread.sleep(50L);
                window.setLocation(original.x + intensity, original.y);
                Thread.sleep(10L);
                window.setLocation(original.x, original.y - intensity);
                Thread.sleep(10L);
                window.setLocation(original.x - intensity, original.y + intensity);
                Thread.sleep(10L);
                window.setLocation(original);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            try {
                JFrame dialog = new JFrame();
                dialog.setSize(100, 100);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                JButton button = new JButton("Shake");
                button.addActionListener(e -> GuiUtil.shake(dialog, 2, 2));
                dialog.add((Component)button, "North");
                JTextArea input = new JTextArea();
                GuiUtil.installLengthLimitDocumentFilter(input, 5, false, new Object[0]);
                dialog.add((Component)input, "South");
                dialog.setDefaultCloseOperation(3);
            }
            catch (Exception ex) {
                Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    public static GridBagConstraints makeGbc(int x, int y, int w, int h) {
        return GuiUtil.makeGbc(x, y, w, h, 13);
    }

    public static GridBagConstraints makeGbc(int x, int y, int w, int h, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.anchor = anchor;
        gbc.insets = new Insets(5, 5, 5, 5);
        return gbc;
    }

    public static JPanel northWrap(JPanel panel) {
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)panel, "North");
        return container;
    }

    public static boolean hasRetinaDisplay() {
        Object obj = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor");
        if (obj instanceof Float) {
            int scale = ((Float)obj).intValue();
            return scale == 2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFontSize(float fontSize, Component component) {
        if (fontSize <= 0.0f) {
            return;
        }
        if (component instanceof Container) {
            Object object = component.getTreeLock();
            synchronized (object) {
                for (Component c : ((Container)component).getComponents()) {
                    GuiUtil.setFontSize(fontSize, c);
                }
            }
        }
        component.setFont(component.getFont().deriveFont(fontSize));
    }

    public static String getSortingFromTable(JTable table) {
        List<RowSorter.SortKey> keys = table.getRowSorter().getSortKeys();
        String result = "";
        for (RowSorter.SortKey key : keys) {
            int order = 0;
            if (key.getSortOrder() == SortOrder.ASCENDING) {
                order = 1;
            } else if (key.getSortOrder() == SortOrder.DESCENDING) {
                order = 2;
            }
            result = result + String.format("%s:%s;", key.getColumn(), order);
        }
        return result;
    }

    public static void setSortingForTable(JTable table, String sorting) {
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
        StringTokenizer t = new StringTokenizer(sorting, ";");
        while (t.hasMoreTokens()) {
            String[] split = t.nextToken().split(":");
            if (split.length != 2) continue;
            try {
                SortOrder order;
                int rowId = Integer.parseInt(split[0]);
                int orderId = Integer.parseInt(split[1]);
                switch (orderId) {
                    case 1: {
                        order = SortOrder.ASCENDING;
                        break;
                    }
                    case 2: {
                        order = SortOrder.DESCENDING;
                        break;
                    }
                    default: {
                        order = SortOrder.UNSORTED;
                    }
                }
                keys.add(new RowSorter.SortKey(rowId, order));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        try {
            if (!keys.isEmpty()) {
                table.getRowSorter().setSortKeys(keys);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void addMacKeyboardActions() {
        if (MiscUtil.OS_MAC) {
            GuiUtil.addMacKeyboardActionsTo("TextField.focusInputMap");
            GuiUtil.addMacKeyboardActionsTo("TextArea.focusInputMap");
            GuiUtil.addMacKeyboardActionsTo("TextPane.focusInputMap");
        }
    }

    private static void addMacKeyboardActionsTo(String key) {
        InputMap im = (InputMap)UIManager.get(key);
        im.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
        im.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
        im.put(KeyStroke.getKeyStroke(88, 256), "cut-to-clipboard");
        im.put(KeyStroke.getKeyStroke(37, 256), "caret-begin-line");
        im.put(KeyStroke.getKeyStroke(39, 256), "caret-end-line");
        im.put(KeyStroke.getKeyStroke(37, 512), "caret-previous-word");
        im.put(KeyStroke.getKeyStroke(39, 512), "caret-next-word");
        im.put(KeyStroke.getKeyStroke(37, 320), "selection-begin-line");
        im.put(KeyStroke.getKeyStroke(39, 320), "selection-end-line");
        im.put(KeyStroke.getKeyStroke(37, 576), "selection-previous-word");
        im.put(KeyStroke.getKeyStroke(39, 576), "selection-next-word");
        im.put(KeyStroke.getKeyStroke(65, 256), "select-all");
    }

    public static String showCommandNotification(String commandText, String title, String message, String channel) {
        CustomCommand command = CustomCommand.parse(commandText);
        Parameters param = Parameters.create("");
        param.put("title", title.replace("\"", "\\\""));
        param.put("message", message.replace("\"", "\\\""));
        param.put("channel", channel);
        param.put("chan", channel);
        if (command.hasError()) {
            LOGGER.warning("Notification command error: " + command.getSingleLineError());
            return "Error: " + command.getSingleLineError();
        }
        String resultCommand = command.replace(param);
        ProcessManager.execute(resultCommand, "Notification", null);
        return "Running: " + resultCommand;
    }

    public static void installTextComponentFocusWorkaround() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addVetoableChangeListener(new VetoableChangeListener(){
            private boolean rejectNext = false;
            private JComponent target;

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (evt.getNewValue() != null) {
                    if (this.rejectNext && evt.getPropertyName().equals("focusOwner")) {
                        if (evt.getNewValue() instanceof JTextComponent) {
                            JComponent component = (JComponent)evt.getNewValue();
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().upFocusCycle(component);
                            this.target = component;
                            LOGGER.info("[Focus] Rejected JTextComponent focus");
                            throw new PropertyVetoException("Rejected JTextComponent focus", evt);
                        }
                        this.rejectNext = false;
                        if (this.target != null) {
                            LOGGER.info("[Focus] Temp: " + evt.getNewValue());
                            this.target.requestFocus();
                            this.target = null;
                        }
                    } else if (evt.getPropertyName().equals("focusedWindow")) {
                        LOGGER.info("[Focus] Window focused");
                        this.rejectNext = true;
                    }
                }
                String oldV = evt.getOldValue() != null ? evt.getOldValue().getClass().toString() : null;
                String newV = evt.getNewValue() != null ? evt.getNewValue().getClass().toString() : null;
            }
        });
    }

    public static void resetFocusTraversalKeys(Component comp) {
        comp.setFocusTraversalKeys(0, null);
        comp.setFocusTraversalKeys(1, null);
    }

    public static void focusTest() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (evt.getOldValue() != null) {
                    System.out.println("from: " + evt.getOldValue().getClass().getName() + " (" + evt.getPropertyName() + ")");
                }
                if (evt.getNewValue() != null) {
                    System.out.println("to: " + evt.getNewValue().getClass().getName() + " (" + evt.getPropertyName() + ")");
                }
                if (evt.getNewValue() instanceof ChannelTextPane) {
                    // empty if block
                }
            }
        });
    }

    public static void installLengthLimitDocumentFilter(final JTextComponent comp, final int defaultLimit, final boolean allowNewlines, Object ... limitArray) {
        final ArrayList<Pair<Pattern, Integer>> limits = new ArrayList<Pair<Pattern, Integer>>();
        int i = 0;
        while (i + 1 < limitArray.length) {
            Object patternObject = limitArray[i];
            Object limitObject = limitArray[i + 1];
            Pattern pattern = null;
            int limit = -1;
            if (patternObject instanceof String) {
                pattern = Pattern.compile((String)patternObject);
            }
            if (limitObject instanceof Integer) {
                limit = (Integer)limitObject;
            }
            limits.add(new Pair<Pattern, Integer>(pattern, limit));
            i += 2;
        }
        DocumentFilter filter = new DocumentFilter(){
            private final SimplePopup popup;
            {
                this.popup = new SimplePopup(comp, null);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int delLength, String text, AttributeSet attrs) throws BadLocationException {
                String fullText = fb.getDocument().getText(0, offset) + text + fb.getDocument().getText(offset + delLength, fb.getDocument().getLength() - offset - delLength);
                int limit = defaultLimit;
                if (!(inputLimitsEnabled && comp.isShowing() && comp.isFocusOwner())) {
                    limit = 0;
                } else {
                    for (Pair limitEntry : limits) {
                        if (limitEntry.key == null || !((Pattern)limitEntry.key).matcher(fullText).find()) continue;
                        limit = (Integer)limitEntry.value;
                        break;
                    }
                }
                if (text == null || text.isEmpty() || limit <= 0) {
                    if (!allowNewlines) {
                        text = StringUtil.removeLinebreakCharacters(text);
                    }
                    super.replace(fb, offset, delLength, text, attrs);
                } else {
                    int currentLength = fb.getDocument().getLength();
                    int overLimit = currentLength + text.length() - limit - delLength;
                    if (overLimit > 0) {
                        int newLength = Math.max(text.length() - overLimit, 0);
                        text = text.substring(0, newLength);
                        if (overLimit == 1) {
                            this.popup.showPopup("Length limit reached");
                        } else {
                            this.popup.showPopup("Length limit reached (" + overLimit + " over limit)");
                        }
                    }
                    if (!allowNewlines) {
                        text = StringUtil.removeLinebreakCharacters(text);
                    }
                    super.replace(fb, offset, delLength, text, attrs);
                }
            }
        };
        Document doc = comp.getDocument();
        if (!(doc instanceof AbstractDocument)) {
            throw new IllegalArgumentException("Textcomponent not using AbstractDocument");
        }
        AbstractDocument ad = (AbstractDocument)doc;
        ad.setDocumentFilter(filter);
    }

    public static JLabel createInputLenghtLabel(JTextComponent comp, final int max) {
        JLabel label = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                int width = this.getFontMetrics(this.getFont()).stringWidth(max + "/" + max);
                Dimension d = super.getPreferredSize();
                return new Dimension(Math.max(d.width, width), d.height);
            }
        };
        label.setHorizontalAlignment(0);
        Runnable action = () -> label.setText(String.format("%d/%d", comp.getText().length(), max));
        GuiUtil.addChangeListener(comp.getDocument(), e -> action.run());
        action.run();
        return label;
    }

    public static void matchHeight(JComponent target, JComponent source) {
        target.setPreferredSize(new Dimension(target.getPreferredSize().width, source.getPreferredSize().height));
    }

    public static ImageIcon getScaledIcon(Icon icon, int w, int h) {
        BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = img.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return new ImageIcon(img.getScaledInstance(w, h, 4));
    }

    public static Icon getFallbackIcon(Icon icon, Class c, String name) {
        if (icon == null) {
            return GuiUtil.getIcon(c, name);
        }
        return icon;
    }

    public static ImageIcon getIcon(Object o, String name) {
        return GuiUtil.getIcon(o.getClass(), name);
    }

    public static ImageIcon getIcon(Class c, String name) {
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(c.getResource(name)));
    }

    public static ImageIcon combineIcons(ImageIcon a, ImageIcon b, int space) {
        int width = a.getIconWidth() + b.getIconWidth() + space;
        int height = Math.max(a.getIconHeight(), b.getIconHeight());
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        g.drawImage(a.getImage(), 0, 0, null);
        g.drawImage(b.getImage(), a.getIconWidth() + space, 0, null);
        g.dispose();
        return new ImageIcon(img);
    }

    public static ImageIcon createEmptyIcon(int width, int height) {
        BufferedImage res = new BufferedImage(width, height, 2);
        return new ImageIcon(res);
    }

    public static ImageIcon substituteColor(ImageIcon icon, Color search, Color target) {
        BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = img.createGraphics();
        g.drawImage(icon.getImage(), 0, 0, null);
        g.dispose();
        GuiUtil.substituteColor(img, search, target);
        return new ImageIcon(img);
    }

    public static void substituteColor(BufferedImage img, Color search, Color target) {
        int RGB_MASK = 0xFFFFFF;
        int ALPHA_MASK = -16777216;
        int searchRGB = search.getRed() << 16 | search.getGreen() << 8 | search.getBlue();
        int targetRGB = target.getRed() << 16 | target.getGreen() << 8 | target.getBlue();
        int[] rgb = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
        for (int i = 0; i < rgb.length; ++i) {
            if ((rgb[i] & RGB_MASK) != searchRGB) continue;
            rgb[i] = rgb[i] & ALPHA_MASK | targetRGB;
        }
        img.setRGB(0, 0, img.getWidth(), img.getHeight(), rgb, 0, img.getWidth());
    }

    public static void edtAndWait(Runnable runnable, String description) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception ex) {
                LOGGER.warning("Failed to execute edtAndWait (" + description + "): " + ex);
            }
        }
    }

    public static void edt(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void addChangeListener(Document doc, final Consumer<DocumentEvent> listener) {
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                listener.accept(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                listener.accept(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                listener.accept(e);
            }
        });
    }

    public static void addSimpleMouseListener(JComponent component, final SimpleMouseListener listener) {
        component.addMouseListener(new MouseAdapter(){
            boolean inside = false;

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    listener.contextMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.inside) {
                    listener.mouseClicked(e);
                }
                if (e.isPopupTrigger()) {
                    listener.contextMenu(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.inside = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.inside = false;
            }
        });
    }

    public static int getTableColumnHeaderWidth(JTable table, int column) {
        TableColumn tableColumn = table.getColumnModel().getColumn(column);
        Object value = tableColumn.getHeaderValue();
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component c = renderer.getTableCellRendererComponent(table, value, false, false, -1, column);
        return c.getPreferredSize().width;
    }

    public static void packKeepCenter(Window window) {
        Dimension size = window.getSize();
        window.pack();
        Point location = window.getLocation();
        location.translate((size.width - window.getWidth()) / 2, (size.height - window.getHeight()) / 2);
        window.setLocation(location);
    }

    public static abstract class SimpleMouseListener {
        public void mouseClicked(MouseEvent e) {
        }

        public void contextMenu(MouseEvent e) {
        }
    }
}

