/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.Addressbook;
import chatty.Helper;
import chatty.Logging;
import chatty.User;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.MiscUtil;
import chatty.util.Pair;
import chatty.util.RepeatMsgHelper;
import chatty.util.Replacer2;
import chatty.util.StringUtil;
import chatty.util.TimeoutPatternMatcher;
import chatty.util.api.StreamInfo;
import chatty.util.api.TwitchApi;
import chatty.util.api.usericons.BadgeType;
import chatty.util.colors.HtmlColors;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import chatty.util.irc.MsgTags;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Highlighter {
    private static final Logger LOGGER = Logger.getLogger(Highlighter.class.getName());
    private static final int LAST_HIGHLIGHTED_TIMEOUT = 10000;
    private final String type;
    private final Map<String, Long> lastHighlighted = new HashMap<String, Long>();
    private final Map<String, HighlightItem> lastHighlightedItem = new HashMap<String, HighlightItem>();
    private final List<HighlightItem> items = new ArrayList<HighlightItem>();
    private final List<HighlightItem> blacklistItems = new ArrayList<HighlightItem>();
    private HighlightItem usernameItem;
    private HighlightItem lastMatchItem;
    private List<HighlightItem> lastMatchItems;
    private Color lastMatchColor;
    private Color lastMatchBackgroundColor;
    private boolean lastMatchNoNotification;
    private boolean lastMatchNoSound;
    private boolean includeAllTextMatches;
    private List<Match> lastTextMatches;
    private String lastReplacement;
    private Replacer2 substitutes;
    private boolean substitutesDefault;
    private boolean highlightUsername;
    private boolean highlightNextMessages;
    private boolean hasOverrideIgnored;
    private boolean hasSubstitutesEnabled;

    public Highlighter(String type) {
        this.type = type;
    }

    public void update(List<String> newItems) {
        this.compile(newItems, this.items, "");
        this.hasOverrideIgnored = false;
        this.items.forEach(item -> {
            if (item.overrideIgnored()) {
                this.hasOverrideIgnored = true;
            }
        });
        this.updateSubstitutesState();
    }

    public void updateBlacklist(List<String> newItems) {
        this.compile(newItems, this.blacklistItems, "Blacklist");
    }

    public void setSubstitutitesDefault(boolean value) {
        this.substitutesDefault = value;
        this.updateSubstitutesState();
    }

    private void updateSubstitutesState() {
        this.hasSubstitutesEnabled = false;
        for (HighlightItem item : this.items) {
            if (!item.substitutesEnabled(this.substitutesDefault)) continue;
            this.hasSubstitutesEnabled = true;
            break;
        }
    }

    public void updateSubstitutes(Replacer2 replacer) {
        this.substitutes = replacer;
    }

    private void compile(List<String> newItems, List<HighlightItem> into, String typeSuffix) {
        into.clear();
        for (String item : newItems) {
            HighlightItem compiled;
            if (item == null || item.isEmpty() || (compiled = new HighlightItem(item, this.type + typeSuffix)).hasError()) continue;
            into.add(compiled);
        }
    }

    public void setUsername(String username) {
        HighlightItem newItem;
        this.usernameItem = username == null ? null : (!(newItem = new HighlightItem("w:" + username, "noPresetsUsernameHighlight")).hasError() ? newItem : null);
    }

    public void setHighlightUsername(boolean highlighted) {
        this.highlightUsername = highlighted;
    }

    public void setHighlightNextMessages(boolean highlight) {
        this.highlightNextMessages = highlight;
    }

    public void setIncludeAllTextMatches(boolean all) {
        this.includeAllTextMatches = all;
    }

    public HighlightItem getLastMatchItem() {
        return this.lastMatchItem;
    }

    public List<HighlightItem> getLastMatchItems() {
        return this.lastMatchItems;
    }

    public HighlightItem getColorSource() {
        if (this.lastMatchItem != null) {
            boolean itemHasColor;
            boolean bl = itemHasColor = this.lastMatchItem.getColor() != null || this.lastMatchItem.getBackgroundColor() != null;
            if (itemHasColor) {
                return this.lastMatchItem;
            }
        }
        return null;
    }

    public Color getLastMatchColor() {
        return this.lastMatchColor;
    }

    public Color getLastMatchBackgroundColor() {
        return this.lastMatchBackgroundColor;
    }

    public boolean getLastMatchNoNotification() {
        return this.lastMatchNoNotification;
    }

    public boolean getLastMatchNoSound() {
        return this.lastMatchNoSound;
    }

    public List<Match> getLastTextMatches() {
        return this.lastTextMatches;
    }

    public String getLastReplacement() {
        return this.lastReplacement;
    }

    public boolean hasOverrideIgnored() {
        return this.hasOverrideIgnored;
    }

    public boolean check(User user, String text) {
        return this.check(HighlightItem.Type.REGULAR, text, -1, -1, null, null, user, null, MsgTags.EMPTY, false);
    }

    public boolean check(HighlightItem.Type type, String text, int msgStart, int msgEnd, String channel, Addressbook ab, User user, User localUser, MsgTags tags, boolean ignored) {
        Replacer2.Result subResult = null;
        if (this.substitutes != null && this.hasSubstitutesEnabled) {
            subResult = this.substitutes.replace(text);
        }
        Blacklist blacklist = null;
        Blacklist subBlacklist = null;
        if (!this.blacklistItems.isEmpty()) {
            blacklist = new Blacklist(type, text, msgStart, msgEnd, channel, ab, user, localUser, tags, this.blacklistItems);
            if (subResult != null) {
                subBlacklist = new Blacklist(type, subResult.getChangedText(), subResult.indexToChanged(msgStart), subResult.indexToChanged(msgEnd), channel, ab, user, localUser, tags, this.blacklistItems);
            }
        }
        this.lastTextMatches = null;
        if (this.highlightUsername && this.usernameItem != null && (blacklist == null || !blacklist.block) && !ignored && this.usernameItem.matches(type, text, -1, -1, blacklist, channel, ab, user, localUser, tags)) {
            this.fillLastMatchVariables(this.usernameItem, text, -1, -1, null);
            this.addMatch(user, this.usernameItem);
            return true;
        }
        boolean alreadyMatched = false;
        for (HighlightItem item : this.items) {
            boolean ignoredBlocks;
            boolean subEnabled = item.substitutesEnabled(this.substitutesDefault) && subResult != null;
            String itemText = text;
            int itemMsgStart = msgStart;
            int itemMsgEnd = msgEnd;
            if (subEnabled && subResult != null) {
                itemText = subResult.getChangedText();
                itemMsgStart = subResult.indexToChanged(msgStart);
                itemMsgEnd = subResult.indexToChanged(msgEnd);
            }
            Replacer2.Result itemSubResult = subEnabled ? subResult : null;
            Blacklist itemBlacklist = subEnabled ? subBlacklist : blacklist;
            boolean blacklistBlocks = itemBlacklist != null && itemBlacklist.block && !item.overrideBlacklist;
            boolean bl = ignoredBlocks = ignored && !item.overrideIgnored();
            if (blacklistBlocks || ignoredBlocks || !item.matches(type, itemText, itemMsgStart, itemMsgEnd, item.overrideBlacklist ? null : itemBlacklist, channel, ab, user, localUser, tags)) continue;
            if (!alreadyMatched) {
                this.fillLastMatchVariables(item, itemText, itemMsgStart, itemMsgEnd, itemSubResult);
                this.addMatch(user, item);
                alreadyMatched = true;
            } else if (this.includeAllTextMatches) {
                List<Match> matches = item.getTextMatches(itemText, itemMsgStart, itemMsgEnd, itemSubResult);
                if (this.lastTextMatches == null && matches != null) {
                    this.lastTextMatches = new ArrayList<Match>();
                }
                if (Match.addAllIfNotAlreadyMatched(this.lastTextMatches, matches)) {
                    this.lastMatchItems.add(item);
                }
            }
            if (this.includeAllTextMatches) continue;
            return true;
        }
        if (alreadyMatched) {
            if (this.lastTextMatches != null) {
                Collections.sort(this.lastTextMatches);
            }
            return true;
        }
        if (user != null && this.hasRecentMatch(user.getName())) {
            this.fillLastMatchVariables(this.lastHighlightedItem.get(user.getName()), null, -1, -1, null);
            return true;
        }
        return false;
    }

    private void fillLastMatchVariables(HighlightItem item, String text, int msgStart, int msgEnd, Replacer2.Result subResult) {
        this.lastMatchItem = item;
        this.lastMatchItems = new ArrayList<HighlightItem>();
        this.lastMatchItems.add(item);
        this.lastMatchColor = item.getColor();
        this.lastMatchBackgroundColor = item.getBackgroundColor();
        this.lastMatchNoNotification = item.noNotification();
        this.lastMatchNoSound = item.noSound();
        this.lastReplacement = item.getReplacement();
        if (text != null) {
            this.lastTextMatches = item.getTextMatches(text, msgStart, msgEnd, subResult);
        }
    }

    public void resetLastMatchVariables() {
        this.lastMatchItem = null;
        this.lastMatchItems = null;
        this.lastMatchColor = null;
        this.lastMatchBackgroundColor = null;
        this.lastMatchNoNotification = false;
        this.lastMatchNoSound = false;
        this.lastReplacement = null;
        this.lastTextMatches = null;
    }

    private void addMatch(User user, HighlightItem item) {
        if (user == null) {
            return;
        }
        if (item.followUp == 0) {
            return;
        }
        if (!this.highlightNextMessages && item.followUp <= 0) {
            return;
        }
        String username = user.getName();
        this.lastHighlighted.put(username, MiscUtil.ems());
        this.lastHighlightedItem.put(username, item);
    }

    private boolean hasRecentMatch(String fromUsername) {
        this.clearRecentMatches();
        HighlightItem item = this.lastHighlightedItem.get(fromUsername);
        if (item == null) {
            return false;
        }
        return this.highlightNextMessages || item.followUp > 0;
    }

    private void clearRecentMatches() {
        Iterator<Map.Entry<String, Long>> it = this.lastHighlighted.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Long> entry = it.next();
            if (MiscUtil.ems() - entry.getValue() <= 10000L) continue;
            it.remove();
            this.lastHighlightedItem.remove(entry.getKey());
        }
    }

    public static class HighlightItem {
        private static final Pattern NO_MATCH = Pattern.compile("(?!)");
        private static final Item NO_MATCH_ITEM = new Item("Never Match", null){

            @Override
            public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                return false;
            }
        };
        private static Map<String, CustomCommand> globalPresets;
        private static TwitchApi api;
        private final String usedForFeature;
        private final boolean applyPresets;
        private Type appliesToType = Type.REGULAR;
        private final String raw;
        private final List<Item> matchItems = new ArrayList<Item>();
        private Pattern pattern;
        private boolean matchMessageText;
        private List<HighlightItem> localBlacklistItems;
        private final Map<String, CustomCommand> localPresets;
        private Color color;
        private Color backgroundColor;
        private boolean noNotification;
        private boolean noSound;
        private boolean hide;
        private boolean noLog;
        private int followUp = -1;
        private String replacement;
        private boolean blacklistBlock;
        private boolean overrideBlacklist;
        private boolean overrideIgnored;
        private boolean matchHistoric;
        private int substitutesEnabled = 1;
        private List<String> routingTargets;
        private List<String> nCats;
        private int msgsReq = 1;
        private int msgsLimit = 0;
        private long msgsDuration = 0L;
        private boolean msgsBeforeDuration;
        private boolean msgsMatchOuter;
        private String textWithoutPrefix = "";
        private boolean invalidRegexLog;
        private String mainPrefix;
        private String error;
        private String matchingError;
        private boolean patternWarning;
        private List<Modification> modifications = new ArrayList<Modification>();
        private Item failedItem;
        private boolean blacklistPreventedTextMatch;
        private boolean blockedByBlacklist;
        private static final Map<String, Function<String, String>> patternPrefixes;
        private static final String LOG_MATCHING_ERROR_KEY = "HighlighterRegexError";
        private static final long LOG_MATCHING_ERROR_DELAY;

        private void addUserItem(String info, Object infoData, final Function<User, Boolean> m) {
            Item item = new Item(info, infoData){

                @Override
                public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                    return user != null && (Boolean)m.apply(user) != false;
                }
            };
            this.matchItems.add(item);
        }

        private void addLocalUserItem(String info, Object infoData, final Function<User, Boolean> m) {
            Item item = new Item(info, infoData){

                @Override
                public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                    return localUser != null && (Boolean)m.apply(localUser) != false;
                }
            };
            this.matchItems.add(item);
        }

        private void addChanItem(String info, Object infoData, final Function<String, Boolean> m) {
            Item item = new Item(info, infoData){

                @Override
                public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                    return channel != null && (Boolean)m.apply(channel) != false;
                }
            };
            this.matchItems.add(item);
        }

        private void addChanCatItem(String info, Object infoData, final BiFunction<String, Addressbook, Boolean> m) {
            Item item = new Item(info, infoData){

                @Override
                public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                    if (channel == null || ab == null) {
                        return false;
                    }
                    return (Boolean)m.apply(channel, ab);
                }
            };
            this.matchItems.add(item);
        }

        private void addTagsItem(String info, Object infoData, final Function<MsgTags, Boolean> m) {
            Item item = new Item(info, infoData){

                @Override
                public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                    return tags != null && (Boolean)m.apply(tags) != false;
                }
            };
            this.matchItems.add(item);
        }

        public static synchronized void setGlobalPresets(Map<String, CustomCommand> presets) {
            globalPresets = presets;
        }

        public static synchronized Map<String, CustomCommand> getGlobalPresets() {
            return globalPresets;
        }

        public static synchronized void setTwitchApi(TwitchApi api) {
            HighlightItem.api = api;
        }

        public static synchronized TwitchApi getTwitchApi(TwitchApi api) {
            return HighlightItem.api;
        }

        public HighlightItem(String item, String type, boolean invalidRegexLog, Map<String, CustomCommand> localPresets) {
            this.raw = item;
            this.invalidRegexLog = invalidRegexLog;
            this.localPresets = localPresets;
            this.usedForFeature = type;
            this.applyPresets = type == null || !type.isEmpty();
            Map<String, CustomCommand> presets = this.getPresets();
            if (presets != null && type != null && !type.startsWith("noPresets") && this.applyPresets) {
                CustomCommand ccf = presets.get("_global_" + type);
                CustomCommand customCommand = ccf = ccf != null ? ccf : presets.get("_global");
                if (ccf != null) {
                    item = item.trim();
                    Parameters parameters = Parameters.create(item);
                    String newItem = ccf.replace(parameters);
                    this.modifications.add(new Modification(item, newItem, ccf.getName()));
                    item = newItem;
                }
            }
            this.prepare(item);
        }

        public HighlightItem(String item) {
            this(item, null, true, null);
        }

        public HighlightItem(String item, String type) {
            this(item, type, true, null);
        }

        private void prepare(String item) {
            if (this.modifications.size() > 20) {
                this.pattern = NO_MATCH;
                this.error = "Too many modifications (recursion?)";
                return;
            }
            if (!this.findPatternPrefixAndCompile(item = item.trim())) {
                if (item.startsWith("cat:")) {
                    List<String> categories = this.parseStringListPrefix(item, "cat:", s -> s);
                    this.addUserItem("Any of Addressbook Categories", categories, user -> {
                        for (String category : categories) {
                            if (!user.hasCategory(category)) continue;
                            return true;
                        }
                        return false;
                    });
                } else if (item.startsWith("!cat:")) {
                    List<String> categories = this.parseStringListPrefix(item, "!cat:", s -> s);
                    this.addUserItem("Not any of Addressbook Categories", categories, user -> {
                        for (String category : categories) {
                            if (user.hasCategory(category)) continue;
                            return true;
                        }
                        return false;
                    });
                } else if (item.startsWith("user:")) {
                    Pattern p = this.compilePattern(Pattern.quote(this.parsePrefix(item, "user:").toLowerCase(Locale.ENGLISH)));
                    this.addUserItem("Username", p, user -> p.matcher(user.getName()).matches());
                } else if (item.startsWith("!user:")) {
                    String username = this.parsePrefix(item, "!user:").toLowerCase(Locale.ENGLISH);
                    this.addUserItem("Not Username", username, user -> !user.getName().equals(username));
                } else if (item.startsWith("reuser:")) {
                    Pattern p = this.compilePattern(this.parsePrefix(item, "reuser:").toLowerCase(Locale.ENGLISH));
                    this.addUserItem("Username (Regex)", p, user -> p.matcher(user.getName()).matches());
                } else if (item.startsWith("status:")) {
                    Set<Status> s2 = this.parseStatus(this.parsePrefix(item, "status:"));
                    this.addUserItem("User Status", s2, user -> HighlightItem.checkStatus(user, s2, true));
                } else if (item.startsWith("!status:")) {
                    Set<Status> s3 = this.parseStatus(this.parsePrefix(item, "!status:"));
                    this.addUserItem("Not User Status", s3, user -> HighlightItem.checkStatus(user, s3, false));
                } else if (item.startsWith("msgs:") || item.startsWith("!msgs:")) {
                    boolean inverted = item.startsWith("!msgs:");
                    if (inverted) {
                        item = item.substring(1);
                    }
                    List<String> listEntries = this.parseStringListPrefix(item, "msgs:", s -> s);
                    ArrayList<HighlightItem> hlItems = new ArrayList<HighlightItem>(){

                        @Override
                        public String toString() {
                            StringBuilder b = new StringBuilder("\n");
                            for (HighlightItem hlItem : this) {
                                if (b.length() > 1) {
                                    b.append("OR\n");
                                }
                                b.append("  ");
                                if (hlItem.msgsMatchOuter) {
                                    b.append("Text match from outer item\n");
                                    continue;
                                }
                                b.append(hlItem.getMatchInfo().replaceAll("\\n(?!$)", "\n  "));
                            }
                            return b.toString();
                        }
                    };
                    for (String entry : listEntries) {
                        hlItems.add(new HighlightItem(entry));
                    }
                    this.addUserItem(inverted ? "Don't " : "Match user messages", hlItems, user -> {
                        boolean matched = false;
                        for (HighlightItem hlItem : hlItems) {
                            int num;
                            long time = -1L;
                            if (hlItem.msgsDuration > 0L) {
                                time = System.currentTimeMillis() - hlItem.msgsDuration;
                            }
                            if ((num = user.getMatchingMessages(hlItem.msgsMatchOuter ? this : hlItem, hlItem.msgsLimit, time, hlItem.msgsBeforeDuration)) < hlItem.msgsReq) continue;
                            matched = true;
                            break;
                        }
                        if (inverted) {
                            return !matched;
                        }
                        return matched;
                    });
                } else if (item.startsWith("mreq:")) {
                    try {
                        this.msgsReq = Integer.parseInt(this.parsePrefix(item, "mreq:"));
                    }
                    catch (NumberFormatException inverted) {}
                } else if (item.startsWith("mlimit:")) {
                    try {
                        this.msgsLimit = Integer.parseInt(this.parsePrefix(item, "mlimit:"));
                    }
                    catch (NumberFormatException inverted) {}
                } else if (item.startsWith("mtime:")) {
                    String value = this.parsePrefix(item, "mtime:");
                    this.msgsBeforeDuration = false;
                    if (value.startsWith(">")) {
                        value = value.substring(1);
                        this.msgsBeforeDuration = true;
                    }
                    if (value.startsWith("<")) {
                        value = value.substring(1);
                    }
                    try {
                        this.msgsDuration = DateTime.parseDuration(value);
                    }
                    catch (NumberFormatException listEntries) {}
                } else if (item.startsWith("mtype:")) {
                    try {
                        String value = this.parsePrefix(item, "mtype:");
                        if (value.equals("outer")) {
                            this.msgsMatchOuter = true;
                        }
                    }
                    catch (NumberFormatException value) {}
                } else if (item.startsWith("mystatus:")) {
                    Set<Status> s4 = this.parseStatus(this.parsePrefix(item, "mystatus:"));
                    this.addLocalUserItem("My User Status", s4, user -> HighlightItem.checkStatus(user, s4, true));
                } else if (item.startsWith("!mystatus:")) {
                    Set<Status> s5 = this.parseStatus(this.parsePrefix(item, "!mystatus:"));
                    this.addLocalUserItem("Not My User Status", s5, user -> HighlightItem.checkStatus(user, s5, false));
                } else if (item.startsWith("chan:")) {
                    List<String> chans = this.parseStringListPrefix(item, "chan:", c -> Helper.toChannel(c));
                    this.addChanItem("One of channels", chans, chan -> chans.contains(chan));
                } else if (item.startsWith("!chan:")) {
                    List<String> chans = this.parseStringListPrefix(item, "!chan:", c -> Helper.toChannel(c));
                    this.addChanItem("Not one of channels", chans, chan -> !chans.contains(chan));
                } else if (item.startsWith("chanCat:")) {
                    List<String> cats = this.parseStringListPrefix(item, "chanCat:", s -> s);
                    this.addChanCatItem("Channel Addressbook Category", cats, (channel, ab) -> {
                        for (String cat : cats) {
                            if (!ab.hasCategory((String)channel, cat)) continue;
                            return true;
                        }
                        return false;
                    });
                } else if (item.startsWith("!chanCat:")) {
                    List<String> cats = this.parseStringListPrefix(item, "!chanCat:", s -> s);
                    this.addChanCatItem("Not Channel Addressbook Category", cats, (channel, ab) -> {
                        for (String cat : cats) {
                            if (ab.hasCategory((String)channel, cat)) continue;
                            return true;
                        }
                        return false;
                    });
                } else if (item.startsWith("chanCat2:")) {
                    List<String> cats = this.parseStringListPrefix(item, "chanCat2:", s -> s);
                    this.addChanCatItem("Channel/User Addressbook Category", cats, (channel, ab) -> {
                        String stream = Helper.toStream(channel);
                        for (String cat : cats) {
                            if (!ab.hasCategory((String)channel, cat) && !ab.hasCategory(stream, cat)) continue;
                            return true;
                        }
                        return false;
                    });
                } else if (item.startsWith("!chanCat2:")) {
                    List<String> cats = this.parseStringListPrefix(item, "!chanCat2:", s -> s);
                    this.addChanCatItem("Not Channel/User Addressbook Category", cats, (channel, ab) -> {
                        String stream = Helper.toStream(channel);
                        for (String cat : cats) {
                            if (ab.hasCategory((String)channel, cat) || ab.hasCategory(stream, cat)) continue;
                            return true;
                        }
                        return false;
                    });
                } else if (item.startsWith("color:")) {
                    this.color = HtmlColors.decode(this.parsePrefix(item, "color:"));
                } else if (item.startsWith("bgcolor:")) {
                    this.backgroundColor = HtmlColors.decode(this.parsePrefix(item, "bgcolor:"));
                } else if (item.startsWith("replacement:")) {
                    this.replacement = this.parsePrefix(item, "replacement:");
                } else if (item.startsWith("config:")) {
                    List<String> list = this.parseStringListPrefix(item, "config:", s -> s);
                    list.forEach(part -> {
                        if (part.equals("silent")) {
                            this.noSound = true;
                        } else if (part.equals("!notify")) {
                            this.noNotification = true;
                        } else if (part.equals("hide")) {
                            this.hide = true;
                        } else if (part.equals("!log")) {
                            this.noLog = true;
                        } else if (part.startsWith("followup")) {
                            if (part.equals("followup")) {
                                this.followUp = 10;
                            } else if (part.equals("followup|0")) {
                                this.followUp = 0;
                            }
                        } else if (part.equals("block")) {
                            this.blacklistBlock = true;
                        } else if (part.equals("!blacklist")) {
                            this.overrideBlacklist = true;
                        } else if (part.equals("!ignore")) {
                            this.overrideIgnored = true;
                        } else if (part.equals("s")) {
                            this.substitutesEnabled = 2;
                        } else if (part.equals("!s")) {
                            this.substitutesEnabled = 0;
                        } else if (part.equals("info")) {
                            this.appliesToType = Type.INFO;
                        } else if (part.equals("any")) {
                            this.appliesToType = Type.ANY;
                        } else if (part.equals("firstmsg")) {
                            this.addUserItem("First Message of User", null, user -> user.getNumberOfMessages() == 0);
                        } else if (part.equals("restricted")) {
                            this.addTagsItem("Restricted Message", null, tags -> tags.isRestrictedMessage());
                        } else if (part.equals("hypechat")) {
                            this.addTagsItem("Hype Chat", null, tags -> tags.getHypeChatAmountText() != null);
                        } else if (part.equals("historic")) {
                            this.addTagsItem("History Service Message", null, tags -> {
                                this.matchHistoric = true;
                                return tags.isHistoricMsg();
                            });
                        } else if (part.equals("historic2")) {
                            this.matchHistoric = true;
                        } else if (part.startsWith("repeatedmsg")) {
                            String[] split = part.split("\\|");
                            final int requiredMsgNumber = split.length == 2 && split[1].matches("[0-9]+") ? Integer.parseInt(split[1]) : 1;
                            this.matchItems.add(new Item("Repeated User Message", null, false){

                                @Override
                                public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                                    return tags != null && RepeatMsgHelper.getRepeatMsg(tags) >= requiredMsgNumber;
                                }
                            });
                        } else if (part.startsWith("live") || part.startsWith("!live")) {
                            this.parseLive((String)part);
                        } else if (part.equals("hl")) {
                            this.addTagsItem("Highlighted by channel points", null, t -> t.isHighlightedMessage());
                        } else if (part.equals("highlighted")) {
                            this.addTagsItem("Highlighted by highlight list", null, t -> t.isChattyHighlighted());
                        } else if (part.equals("url") || part.equals("msgurl")) {
                            this.matchItems.add(new Item("Contains URL" + (part.startsWith("msg") ? " (msg)" : ""), null, true, (String)part){
                                final /* synthetic */ String val$part;
                                {
                                    this.val$part = string;
                                    super(info, infoData, matchesOnText);
                                }

                                @Override
                                public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                                    return this.matchesPattern(text, msgStart, msgEnd, this.val$part.startsWith("msg"), Helper.getUrlPattern(), blacklist);
                                }
                            });
                        } else if (part.startsWith("afterban")) {
                            String[] split = part.split("\\|");
                            int matchNumber = split.length == 2 && split[1].matches("[0-9]+") ? Integer.parseInt(split[1]) : Integer.MAX_VALUE;
                            this.addUserItem("Messages after ban/timeout", matchNumber < Integer.MAX_VALUE ? Integer.valueOf(matchNumber) : null, user -> {
                                int msgs = user.getNumberOfMessagesAfterBan();
                                return msgs != -1 && msgs < matchNumber;
                            });
                        } else if (part.startsWith("shared")) {
                            String[] split = part.split("\\|");
                            HashSet<String> sourceChans = new HashSet<String>();
                            for (int i = 1; i < split.length; ++i) {
                                sourceChans.add(Helper.toChannel(split[i]));
                            }
                            this.addTagsItem("Shared Message", sourceChans, t -> t.isSharedMessage() && (sourceChans.isEmpty() || sourceChans.contains(t.getSourceChannel())));
                        }
                    });
                    this.parseBadges(list);
                    this.parseTags(list);
                } else if (item.startsWith("blacklist:")) {
                    List<String> list = this.parseStringListPrefix(item, "blacklist:", s -> s);
                    List<HighlightItem> blItems = this.createHighlightItems(list);
                    if (!blItems.isEmpty()) {
                        if (this.localBlacklistItems == null) {
                            this.localBlacklistItems = blItems;
                        } else {
                            this.localBlacklistItems.addAll(blItems);
                        }
                    }
                } else if (item.startsWith("if:") || item.startsWith("!if:")) {
                    final boolean successValue = item.startsWith("if:");
                    List<String> list = successValue ? this.parseStringListPrefix(item, "if:", s -> s) : this.parseStringListPrefix(item, "!if:", s -> s);
                    final List<HighlightItem> items = this.createHighlightItems(list);
                    if (!items.isEmpty()) {
                        this.matchItems.add(new Item(successValue ? "If one matches" : "If none matches", "\n====\n" + StringUtil.join(items, "----\n", s -> ((HighlightItem)s).getMatchInfo()) + "====", true){

                            @Override
                            public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                                for (HighlightItem item : items) {
                                    if (!item.matches(type, text, msgStart, msgEnd, blacklist, channel, ab, user, localUser, tags)) continue;
                                    return successValue;
                                }
                                return !successValue;
                            }
                        });
                    }
                } else if (item.startsWith("cc:")) {
                    String value = item.substring("cc:".length());
                    this.parseCustomCommandPrefix(null, value);
                } else if (item.startsWith("cc2:")) {
                    String value = item.substring("cc2:".length());
                    String[] split = value.split("\\|", 2);
                    if (split.length != 2) {
                        this.error = "Usage: cc2:<escapeChar>[replacementChar]|<remaining text>";
                        this.pattern = NO_MATCH;
                    } else {
                        this.parseCustomCommandPrefix(split[0], split[1]);
                    }
                } else if (item.startsWith("ccf:")) {
                    String value = item.substring("ccf:".length());
                    String[] split = value.split("\\|", 2);
                    if (split.length != 2) {
                        this.error = "Usage: ccf:<functionName>|<remaining text>";
                        this.pattern = NO_MATCH;
                    } else if (this.applyPresets) {
                        String newItem = this.applyCustomCommandFunction(split[0], split[1]);
                        this.modifications.add(new Modification(item, newItem, "ccf:"));
                        this.prepare(newItem);
                    } else {
                        this.prepare(split[1]);
                    }
                } else if (item.startsWith("preset:")) {
                    List<String> split = StringUtil.split(item, ' ', '\"', '\"', 2, 0);
                    String list = split.get(0).substring("preset:".length());
                    String remaining = "";
                    if (split.size() == 2) {
                        remaining = split.get(1);
                    }
                    if (!remaining.isEmpty() && !this.applyPresets) {
                        this.prepare(remaining);
                        return;
                    }
                    String result = "";
                    List<String> listSplit = StringUtil.split(list, ',', '\"', '\"', 0, 1);
                    for (String part2 : listSplit) {
                        String args;
                        if (part2.isEmpty()) continue;
                        String[] valueSplit = part2.split("\\|", 2);
                        CustomCommand preset = this.getPresets().get(valueSplit[0]);
                        if (preset == null) continue;
                        String string = args = valueSplit.length == 2 ? valueSplit[1] : "";
                        if (preset.getName().startsWith("_")) {
                            result = StringUtil.append(result, " ", preset.replace(Parameters.create(args)));
                            continue;
                        }
                        result = StringUtil.append(result, " ", preset.replace(Parameters.create("")) + args);
                    }
                    String newItem = StringUtil.append(result, " ", remaining);
                    this.modifications.add(new Modification(item, newItem, "preset:"));
                    this.prepare(newItem);
                } else if (item.startsWith("to:")) {
                    this.routingTargets = this.parseStringListPrefix(item, "to:", c -> c);
                } else if (item.startsWith("n:")) {
                    this.parsePrefix(item, "n:");
                } else if (StringUtil.toLowerCase(item).startsWith("ncat:")) {
                    this.nCats = this.parseStringListPrefix(item, "ncat:", c -> c);
                } else {
                    this.textWithoutPrefix = item;
                    this.pattern = this.compilePattern("(?iu)" + Pattern.quote(item));
                }
            }
        }

        private void parseLive(String part) {
            int paramStart;
            boolean successResult;
            boolean bl = successResult = !part.startsWith("!");
            if (part.startsWith("!")) {
                part = part.substring(1);
            }
            Pattern titlePattern = null;
            Pattern categoryPattern = null;
            if (part.length() > "live".length() && (paramStart = part.indexOf("|")) != -1) {
                String param = part.substring(paramStart + 1);
                String[] split = param.split("/", 2);
                if (split.length == 2) {
                    titlePattern = this.compilePattern(split[0]);
                    categoryPattern = this.compilePattern(split[1]);
                }
                if (split.length == 1) {
                    titlePattern = this.compilePattern(split[0]);
                }
            }
            final Pattern titlePattern2 = titlePattern;
            final Pattern categoryPattern2 = categoryPattern;
            this.matchItems.add(new Item((!successResult ? "Not: " : "") + "Stream is live (Title:" + titlePattern + "/Game:" + categoryPattern + ")", null, false){

                @Override
                public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                    if (api != null && !StringUtil.isNullOrEmpty(channel)) {
                        StreamInfo info = api.getCachedStreamInfo(Helper.toStream(channel));
                        if (info != null && info.isValid() && info.getOnline()) {
                            if (titlePattern2 != null && !titlePattern2.matcher(info.getStatus()).find()) {
                                return !successResult;
                            }
                            if (categoryPattern2 != null && !categoryPattern2.matcher(info.getGame()).find()) {
                                return !successResult;
                            }
                            return successResult;
                        }
                        return !successResult;
                    }
                    return false;
                }
            });
        }

        private void parseBadges(List<String> list) {
            ArrayList badges = new ArrayList();
            list.forEach(part -> {
                if (part.startsWith("b|") && part.length() > 2) {
                    badges.add(BadgeType.parse(part.substring(2)));
                }
            });
            if (!badges.isEmpty()) {
                this.addUserItem("Any of Twitch Badge", badges, user -> {
                    for (BadgeType type : badges) {
                        if (!(type.version == null ? user.hasTwitchBadge(type.id) : user.hasTwitchBadge(type.id, type.version))) continue;
                        return true;
                    }
                    return false;
                });
            }
        }

        private void parseTags(List<String> list) {
            ArrayList items = new ArrayList();
            list.forEach(part -> {
                if (part.startsWith("t|") && part.length() > 2) {
                    String tag = part.substring(2);
                    String[] split = tag.split("=", 2);
                    if (split.length == 2) {
                        String value = split[1];
                        Pattern p = value.startsWith("reg:") ? this.compilePattern(split[1].substring("reg:".length())) : this.compilePattern(Pattern.quote(split[1]));
                        items.add(new Pair<String, Pattern>(split[0], p));
                    } else {
                        items.add(new Pair<String, Object>(split[0], null));
                    }
                }
            });
            if (!items.isEmpty()) {
                this.addTagsItem("Any of Message Tags", items, tags -> {
                    for (Pair item : items) {
                        if (!tags.containsKey((String)item.key)) continue;
                        if (item.value != null) {
                            if (!((Pattern)item.value).matcher(tags.get((String)item.key)).matches()) continue;
                            return true;
                        }
                        return true;
                    }
                    return false;
                });
            }
        }

        private Set<Status> parseStatus(String status) {
            HashSet<Status> result = new HashSet<Status>();
            for (Status s : Status.values()) {
                if (!status.contains(s.id)) continue;
                result.add(s);
            }
            return result;
        }

        private String parsePrefix(String item, String prefix) {
            List<String> split = StringUtil.split(item, ' ', '\"', '\"', 2, 1);
            if (split.size() == 2) {
                this.prepare(split.get(1));
            }
            return split.get(0).substring(prefix.length());
        }

        private void parseListPrefixSingle(String item, String prefix, Consumer<String> p) {
            List<String> split = StringUtil.split(item, ' ', '\"', '\"', 2, 0);
            if (split.size() == 2) {
                this.prepare(split.get(1));
            }
            HighlightItem.parseList(split.get(0).substring(prefix.length()), p);
        }

        private List<String> parseStringListPrefix(String item, String prefix, Function<String, String> c) {
            ArrayList<String> result = new ArrayList<String>();
            this.parseListPrefixSingle(item, prefix, p -> result.add((String)c.apply((String)p)));
            return result;
        }

        private static void parseList(String list, Consumer<String> p) {
            List<String> split = StringUtil.split(list, ',', '\"', '\"', 0, 1);
            for (String part : split) {
                if (part.isEmpty()) continue;
                p.accept(part);
            }
        }

        private void parseCustomCommandPrefix(String chars, String commandText) {
            if (!this.applyPresets) {
                this.prepare(commandText);
                return;
            }
            String escape = StringUtil.substring(chars, 0, 1, null);
            String special = StringUtil.substring(chars, 1, 2, null);
            CustomCommand main = CustomCommand.parseCustom(commandText, special, escape);
            if (main.hasError()) {
                this.error = "cc: prefix [" + main.getSingleLineError() + "]";
                this.pattern = NO_MATCH;
            } else {
                Parameters parameters = Parameters.create("");
                parameters.put("-presets-", "true");
                this.getPresets().forEach((n, c) -> parameters.putObject((String)n, c));
                String result = main.replace(parameters);
                if (result == null) {
                    this.error = "cc: prefix [Required replacement]";
                    this.pattern = NO_MATCH;
                } else {
                    this.modifications.add(new Modification(commandText, result, "cc:"));
                    this.prepare(result);
                }
            }
        }

        private String applyCustomCommandFunction(String function, String text) {
            CustomCommand f;
            Map<String, CustomCommand> r = this.getPresets();
            if (function != null && r != null && (f = r.get(function)) != null) {
                Parameters fParameters = Parameters.create(text);
                text = f.replace(fParameters);
            }
            return text;
        }

        private Map<String, CustomCommand> getPresets() {
            HashMap result = this.localPresets;
            if (result == null) {
                result = HighlightItem.getGlobalPresets();
            }
            return result != null ? result : new HashMap();
        }

        private List<HighlightItem> createHighlightItems(List<String> list) {
            ArrayList<HighlightItem> items = new ArrayList<HighlightItem>();
            for (String entry : list) {
                HighlightItem item = new HighlightItem(entry, this.usedForFeature, this.invalidRegexLog, this.localPresets);
                if (!item.hasError()) {
                    items.add(item);
                    if (!item.patternThrowsError()) continue;
                    this.patternWarning = true;
                    continue;
                }
                this.error = item.getError();
            }
            return items;
        }

        private boolean findPatternPrefixAndCompile(String input) {
            for (String prefix : patternPrefixes.keySet()) {
                if (this.findAdditionalPatternPrefix(input, "+", prefix)) {
                    return true;
                }
                if (this.findAdditionalPatternPrefix(input, "+!", prefix)) {
                    return true;
                }
                if (this.findAdditionalPatternPrefix(input, "!", prefix)) {
                    return true;
                }
                if (!input.startsWith(prefix) || input.length() <= prefix.length()) continue;
                String withoutPrefix = input.substring(prefix.length());
                String completePattern = patternPrefixes.get(prefix).apply(withoutPrefix);
                this.textWithoutPrefix = withoutPrefix;
                this.mainPrefix = prefix;
                this.pattern = this.compilePattern(completePattern);
                this.matchMessageText = prefix.startsWith("msg");
                return true;
            }
            return false;
        }

        private boolean findAdditionalPatternPrefix(String input, String type, final String prefix) {
            String fullPrefix = type + prefix;
            if (input.startsWith(fullPrefix) && input.length() > fullPrefix.length()) {
                String value;
                boolean isMainPrefix;
                boolean isPositiveMatch = type.equals("+");
                boolean bl = isMainPrefix = !type.startsWith("+");
                if (!isMainPrefix) {
                    value = this.parsePrefix(input, fullPrefix);
                } else {
                    value = input.substring(fullPrefix.length());
                    this.mainPrefix = fullPrefix;
                    this.textWithoutPrefix = value;
                    this.matchMessageText = prefix.startsWith("msg");
                }
                String completePattern = patternPrefixes.get(prefix).apply(value);
                final Pattern compiled = this.compilePattern(completePattern);
                if (isPositiveMatch) {
                    this.matchItems.add(new Item("Additional regex (" + prefix.substring(0, prefix.length() - 1) + ")", compiled, true){

                        @Override
                        public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                            return this.matchesPattern(text, msgStart, msgEnd, prefix.startsWith("msg"), compiled, blacklist);
                        }
                    });
                } else {
                    this.matchItems.add(new Item("Not matching regex (" + prefix.substring(0, prefix.length() - 1) + ")", compiled, true){

                        @Override
                        public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
                            return !this.matchesPattern(text, msgStart, msgEnd, prefix.startsWith("msg"), compiled, null);
                        }
                    });
                }
                return true;
            }
            return false;
        }

        private static void addPatternPrefix(Function<String, String> patternBuilder, String ... prefixes) {
            for (String prefix : prefixes) {
                patternPrefixes.put(prefix, patternBuilder);
                patternPrefixes.put("msg" + prefix, patternBuilder);
            }
        }

        private Pattern compilePattern(String patternString) {
            try {
                Pattern pattern = Pattern.compile(patternString);
                if (HighlightItem.patternThrowsError(pattern)) {
                    this.patternWarning = true;
                }
                return pattern;
            }
            catch (PatternSyntaxException ex) {
                this.error = ex.getDescription();
                if (this.invalidRegexLog) {
                    LOGGER.warning("Invalid regex: " + ex);
                }
                return NO_MATCH;
            }
        }

        private boolean matchesPattern(String text, int msgStart, int msgEnd, boolean matchMessageTextLocal, Pattern pattern, Blacklist blacklist) {
            if (pattern == null) {
                return true;
            }
            try {
                Matcher m = TimeoutPatternMatcher.create(pattern, text, 100L);
                if (!HighlightItem.applyMsgRestriction(m, msgStart, msgEnd, matchMessageTextLocal)) {
                    return false;
                }
                while (m.find()) {
                    boolean notBlacklisted;
                    boolean bl = notBlacklisted = blacklist == null || !blacklist.isBlacklisted(m.start(), m.end());
                    if (notBlacklisted) {
                        return true;
                    }
                    this.blacklistPreventedTextMatch = true;
                }
            }
            catch (Exception ex) {
                if (Debugging.millisecondsElapsedLenient(LOG_MATCHING_ERROR_KEY, LOG_MATCHING_ERROR_DELAY)) {
                    this.logRegexError(pattern, text, ex);
                }
                this.matchingError = ex.getLocalizedMessage();
            }
            return false;
        }

        private static boolean applyMsgRestriction(Matcher m, int msgStart, int msgEnd, boolean enabled) {
            if (enabled && msgStart != -2 && msgEnd != -2) {
                boolean msgRegionValid;
                boolean bl = msgRegionValid = msgStart > -1 && msgEnd > msgStart;
                if (msgRegionValid) {
                    m.region(msgStart, msgEnd);
                } else {
                    return false;
                }
            }
            return true;
        }

        private void logRegexError(Pattern pattern, String text, Exception ex) {
            LOGGER.log(Logging.USERINFO, String.format("Error: Regex match failed (see 'Extra - Debug window' for details)", this.usedForFeature, StringUtil.shortenTo(pattern.pattern(), 40)));
            LOGGER.warning(String.format("Regex match failed (%s/'%s'):\n\tregex '%s'\n\ton text '%s'\n\twith error '%s'\n\t(Note that this type of error is logged no more often than every %s seconds.)", this.usedForFeature, this.raw, pattern, text, Debugging.getStacktraceFilteredFlat(ex), LOG_MATCHING_ERROR_DELAY / 1000L));
        }

        public List<Match> getTextMatches(String text, int msgStart, int msgEnd, Replacer2.Result subResult) {
            if (this.pattern == null) {
                return null;
            }
            ArrayList<Match> result = new ArrayList<Match>();
            try {
                Matcher m = TimeoutPatternMatcher.create(this.pattern, text, 100L);
                if (!HighlightItem.applyMsgRestriction(m, msgStart, msgEnd, this.matchMessageText)) {
                    return result;
                }
                while (m.find()) {
                    if (m.group().isEmpty()) continue;
                    int start = m.start();
                    int end = m.end();
                    if (subResult != null) {
                        result.add(new Match(subResult.indexToOriginal(start), subResult.indexToOriginal(end)));
                        continue;
                    }
                    result.add(new Match(start, end));
                }
            }
            catch (Exception ex) {
                if (Debugging.millisecondsElapsedLenient(LOG_MATCHING_ERROR_KEY, LOG_MATCHING_ERROR_DELAY)) {
                    this.logRegexError(this.pattern, text, ex);
                }
                this.matchingError = ex.getLocalizedMessage();
            }
            return result;
        }

        private static boolean patternThrowsError(Pattern pattern) {
            if (pattern != null) {
                try {
                    pattern.matcher("\ud83d\udc95\ud83d\udc95\ud83d\udc95").find();
                }
                catch (Exception ex) {
                    return true;
                }
            }
            return false;
        }

        public boolean patternThrowsError() {
            return this.patternWarning;
        }

        public String getTextWithoutPrefix() {
            return this.textWithoutPrefix;
        }

        public String getMainPrefix() {
            return this.mainPrefix;
        }

        public String getMetaPrefixes() {
            String main = StringUtil.append(this.mainPrefix, "", this.textWithoutPrefix);
            String full = this.raw.trim();
            if (!StringUtil.isNullOrEmpty(main)) {
                return full.substring(0, full.length() - main.length()).trim();
            }
            return full;
        }

        public String getMatchInfo() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.modifications.size(); ++i) {
                if (i > 5) {
                    result.append("Shortened.. too many modifications.\n\n");
                    break;
                }
                Modification modification = this.modifications.get(i);
                result.append(String.join((CharSequence)"", Collections.nCopies(modification.source.length() + 3, " "))).append(modification.from).append("\n");
                result.append("[").append(modification.source).append("] ").append(modification.to).append("\n\n");
            }
            result.append("Applies to: ").append(this.appliesToType.description).append("\n");
            if (this.pattern != null) {
                result.append("Main regex");
                if (!StringUtil.isNullOrEmpty(this.mainPrefix)) {
                    result.append(" (").append(this.mainPrefix.substring(0, this.mainPrefix.length() - 1)).append(")");
                }
                result.append(": ").append(this.pattern).append("\n");
                HighlightItem.addPatternWarning(result, this.pattern);
            }
            for (Item item : this.matchItems) {
                result.append(item.toString());
                result.append("\n");
                HighlightItem.addPatternWarning(result, item.infoData);
            }
            if (this.localBlacklistItems != null) {
                result.append("Local blacklist:\n");
                for (HighlightItem highlightItem : this.localBlacklistItems) {
                    result.append("-- ").append(highlightItem.pattern).append("\n");
                    HighlightItem.addPatternWarning(result, highlightItem.pattern);
                }
            }
            if (this.routingTargets != null) {
                result.append("Copy message to: ").append(this.routingTargets);
                result.append("\n");
            }
            StringBuilder behaviour = new StringBuilder();
            if (this.color != null) {
                behaviour.append("Foreground: ").append(HtmlColors.getNamedColorString(this.color, true)).append("\n");
            }
            if (this.backgroundColor != null) {
                behaviour.append("Background: ").append(HtmlColors.getNamedColorString(this.backgroundColor, true)).append("\n");
            }
            if (this.noNotification) {
                behaviour.append("Don't show notification\n");
            }
            if (this.noSound) {
                behaviour.append("Don't play sound\n");
            }
            if (this.hide) {
                behaviour.append("Don't add to Highlighted/Ignored panel\n");
            }
            if (this.noLog) {
                behaviour.append("Don't add to Highlighted/Ignored log file\n");
            }
            if (this.followUp == 0) {
                behaviour.append("Don't highlight follow-up messages\n");
            }
            if (this.followUp > 0) {
                behaviour.append("Highlight follow-up messages\n");
            }
            if (behaviour.length() > 0) {
                result.append("\nIf message is matched:\n");
                result.append((CharSequence)behaviour);
            }
            return result.toString();
        }

        public boolean overrideIgnored() {
            return this.overrideIgnored;
        }

        public boolean matchHistoric() {
            return this.matchHistoric;
        }

        public boolean substitutesEnabled(boolean substitutesDefault) {
            if (this.substitutesEnabled == 0) {
                return false;
            }
            if (this.substitutesEnabled == 2) {
                return true;
            }
            return substitutesDefault;
        }

        private static void addPatternWarning(StringBuilder b, Object pattern) {
            if (pattern instanceof Pattern && HighlightItem.patternThrowsError((Pattern)pattern)) {
                b.append("-- [!] The above regex may throw an error on some texts (due to a bug in the Java Regex implementation).\n");
            }
        }

        public boolean matchesAny(String text, Blacklist blacklist) {
            return this.matches(Type.ANY, text, blacklist, null, null);
        }

        public boolean matchesTextOnly(String text, Blacklist blacklist) {
            return this.matches(Type.TEXT_MATCHING_ONLY, text, blacklist, null, null);
        }

        public boolean matches(Type type, String text, User user, User localUser, MsgTags tags) {
            return this.matches(type, text, -2, -2, null, null, null, user, localUser, tags);
        }

        public boolean matches(Type type, String text, Blacklist blacklist, User user, User localUser) {
            return this.matches(type, text, -2, -2, blacklist, null, null, user, localUser, MsgTags.EMPTY);
        }

        public boolean matches(Type type, String text, String channel, Addressbook ab) {
            return this.matches(type, text, -1, -1, null, channel, ab, null, null, MsgTags.EMPTY);
        }

        public boolean matches(User user) {
            return this.matches(Type.ANY, "", -1, -1, null, null, null, user, null, MsgTags.EMPTY);
        }

        public boolean matches(User user, MsgTags tags) {
            return this.matches(Type.ANY, "", -1, -1, null, null, null, user, null, tags);
        }

        public boolean matches(Type type, String text, int msgStart, int msgEnd, Blacklist blacklist, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
            this.failedItem = null;
            this.blacklistPreventedTextMatch = false;
            this.blockedByBlacklist = false;
            this.matchingError = null;
            if (blacklist != null && blacklist.block) {
                this.blockedByBlacklist = true;
                return false;
            }
            if (this.localBlacklistItems != null) {
                blacklist = Blacklist.addMatches(blacklist, text, msgStart, msgEnd, this.localBlacklistItems);
            }
            if (type != this.appliesToType && this.appliesToType != Type.ANY && type != Type.ANY && type != Type.TEXT_MATCHING_ONLY) {
                return false;
            }
            if (this.pattern != null && !this.matchesPattern(text, msgStart, msgEnd, this.matchMessageText, this.pattern, blacklist)) {
                return false;
            }
            if (user != null) {
                if (channel == null) {
                    channel = user.getChannel();
                }
                if (ab == null) {
                    ab = user.getAddressbook();
                }
            }
            if (localUser != null) {
                if (channel == null) {
                    channel = localUser.getChannel();
                }
                if (ab == null) {
                    ab = localUser.getAddressbook();
                }
            }
            if (tags == null) {
                tags = MsgTags.EMPTY;
            }
            for (Item item : this.matchItems) {
                boolean match;
                if (type == Type.TEXT_MATCHING_ONLY && !item.matchesOnText || (match = item.matches(type, text, msgStart, msgEnd, blacklist, channel, ab, user, localUser, tags))) continue;
                this.failedItem = item;
                return false;
            }
            return true;
        }

        private static boolean checkStatus(User user, Set<Status> req, boolean positive) {
            if (req.isEmpty()) {
                return true;
            }
            if (user == null) {
                return false;
            }
            boolean or = positive;
            if (req.contains((Object)Status.MOD) && user.isModerator()) {
                return or;
            }
            if (req.contains((Object)Status.LEAD_MOD) && user.hasTwitchBadge("lead_moderator")) {
                return or;
            }
            if (req.contains((Object)Status.SUBSCRIBER) && user.isSubscriber()) {
                return or;
            }
            if (req.contains((Object)Status.ADMIN) && user.isAdmin()) {
                return or;
            }
            if (req.contains((Object)Status.STAFF) && user.isStaff()) {
                return or;
            }
            if (req.contains((Object)Status.BROADCASTER) && user.isBroadcaster()) {
                return or;
            }
            if (req.contains((Object)Status.TURBO) && user.hasTurbo()) {
                return or;
            }
            if (req.contains((Object)Status.GLOBAL_MOD) && user.isGlobalMod()) {
                return or;
            }
            if (req.contains((Object)Status.BOT) && user.isBot()) {
                return or;
            }
            if (req.contains((Object)Status.ANY_MOD) && user.hasModeratorRights()) {
                return or;
            }
            if (req.contains((Object)Status.VIP) && user.isVip()) {
                return or;
            }
            return !or;
        }

        public String getRaw() {
            return this.raw;
        }

        public Color getColor() {
            return this.color;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public boolean noNotification() {
            return this.noNotification;
        }

        public boolean noSound() {
            return this.noSound;
        }

        public boolean hide() {
            return this.hide;
        }

        public boolean noLog() {
            return this.noLog;
        }

        public List<String> getRoutingTargets() {
            return this.routingTargets;
        }

        public List<String> getNotificationCategories() {
            if (this.nCats != null && this.nCats.isEmpty()) {
                return null;
            }
            return this.nCats;
        }

        public String getFailedReason() {
            if (this.failedItem != null) {
                return this.failedItem.toString();
            }
            if (this.blockedByBlacklist) {
                return "Blocked by blacklist";
            }
            if (this.blacklistPreventedTextMatch) {
                return "Blacklist prevented text match";
            }
            return null;
        }

        public boolean hasError() {
            return this.error != null;
        }

        public String getError() {
            return this.error;
        }

        public boolean hasMatchingError() {
            return this.matchingError != null;
        }

        public String getMatchingError() {
            return this.matchingError;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public String getUsedForFeature() {
            return this.usedForFeature;
        }

        public static Map<String, CustomCommand> makePresets(Collection<String> input) {
            HashMap<String, CustomCommand> result = new HashMap<String, CustomCommand>();
            for (String value : input) {
                CustomCommand command;
                String[] split = value.split(" ", 2);
                if (split.length != 2) continue;
                String commandName = split[0].trim();
                String commandValue = split[1].trim();
                if (commandName.isEmpty() || commandValue.isEmpty() || commandName.startsWith("#") || (command = commandName.startsWith("_") ? CustomCommand.parse(commandName, null, commandValue) : CustomCommand.parseCustom(commandName, null, commandValue, "", "")) == null || command.hasError()) continue;
                result.put(command.getName(), command);
            }
            return result;
        }

        static {
            patternPrefixes = new HashMap<String, Function<String, String>>();
            HighlightItem.addPatternPrefix(text -> text, "re*:", "reg:");
            HighlightItem.addPatternPrefix(text -> "(?iu)" + text, "regi:");
            HighlightItem.addPatternPrefix(text -> "\\b(?:" + text + ")\\b", "regw:");
            HighlightItem.addPatternPrefix(text -> "(?iu)\\b(?:" + text + ")\\b", "regwi:");
            HighlightItem.addPatternPrefix(text -> "^(?:" + text + ")$", "re:", "regm:");
            HighlightItem.addPatternPrefix(text -> "(?iu)^(?:" + text + ")$", "regmi:");
            HighlightItem.addPatternPrefix(text -> "(?iu)\\b" + Pattern.quote(text) + "\\b", "w:");
            HighlightItem.addPatternPrefix(text -> "\\b" + Pattern.quote(text) + "\\b", "wcs:");
            HighlightItem.addPatternPrefix(text -> Pattern.quote(text), "cs:");
            HighlightItem.addPatternPrefix(text -> "(?iu)^" + Pattern.quote(text), "start:");
            HighlightItem.addPatternPrefix(text -> "(?iu)^" + Pattern.quote(text) + "\\b", "startw:");
            HighlightItem.addPatternPrefix(text -> "(?iu)" + Pattern.quote(text), "text:");
            LOG_MATCHING_ERROR_DELAY = TimeUnit.SECONDS.toMillis(120L);
        }

        public static enum Type {
            REGULAR("Regular chat messages"),
            INFO("Info messages"),
            ANY("Any type of message"),
            TEXT_MATCHING_ONLY("Only match text, any message type");

            public final String description;

            private Type(String description) {
                this.description = description;
            }
        }

        private static enum Status {
            MOD("m"),
            LEAD_MOD("L"),
            SUBSCRIBER("s"),
            BROADCASTER("b"),
            ADMIN("a"),
            STAFF("f"),
            TURBO("t"),
            ANY_MOD("M"),
            GLOBAL_MOD("g"),
            BOT("r"),
            VIP("v");

            private final String id;

            private Status(String id) {
                this.id = id;
            }
        }

        private static abstract class Item {
            private final String info;
            private final Object infoData;
            private final boolean matchesOnText;

            private Item(String info, Object infoData, boolean matchesOnText) {
                this.info = info;
                this.infoData = infoData;
                this.matchesOnText = matchesOnText;
            }

            private Item(String info, Object infoData) {
                this(info, infoData, false);
            }

            public String toString() {
                if (this.infoData != null) {
                    return this.info + ": " + this.infoData;
                }
                return this.info;
            }

            public abstract boolean matches(Type var1, String var2, int var3, int var4, Blacklist var5, String var6, Addressbook var7, User var8, User var9, MsgTags var10);
        }
    }

    public static class Blacklist {
        private final Collection<Match> blacklisted;
        private final boolean block;

        public Blacklist(HighlightItem.Type type, String text, int msgStart, int msgEnd, String channel, Addressbook ab, User user, User localUser, MsgTags tags, Collection<HighlightItem> items) {
            this.blacklisted = new ArrayList<Match>();
            boolean block = false;
            for (HighlightItem item : items) {
                List<Match> matches;
                if (!item.matches(type, text, msgStart, msgEnd, null, channel, ab, user, localUser, tags)) continue;
                if (item.blacklistBlock) {
                    block = true;
                }
                if ((matches = item.getTextMatches(text, msgStart, msgEnd, null)) != null) {
                    this.blacklisted.addAll(matches);
                    continue;
                }
                this.blacklisted.add(null);
            }
            this.block = block;
        }

        private Blacklist(Collection<Match> blacklisted) {
            this.blacklisted = blacklisted;
            this.block = false;
        }

        public boolean isBlacklisted(int start, int end) {
            for (Match section : this.blacklisted) {
                if (section != null && !section.spans(start, end)) continue;
                return true;
            }
            return false;
        }

        public boolean doesBlock() {
            return this.block;
        }

        public String toString() {
            return this.blacklisted.toString();
        }

        public static Blacklist addMatches(Blacklist blacklist, String text, int msgStart, int msgEnd, Collection<HighlightItem> items) {
            ArrayList<Match> matches = new ArrayList<Match>();
            if (blacklist != null) {
                matches.addAll(blacklist.blacklisted);
            }
            if (items != null) {
                for (HighlightItem item : items) {
                    List<Match> m = item.getTextMatches(text, msgStart, msgEnd, null);
                    if (m != null) {
                        matches.addAll(m);
                        continue;
                    }
                    matches.add(null);
                }
            }
            return new Blacklist(matches);
        }
    }

    public static class Match
    implements Comparable<Match> {
        public final int start;
        public final int end;

        public Match(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean spans(int start, int end) {
            return this.start <= start && this.end >= end;
        }

        public String toString() {
            return this.start + "-" + this.end;
        }

        public static List<Match> shiftMatchList(List<Match> input, int shift) {
            if (input == null || input.isEmpty()) {
                return input;
            }
            ArrayList<Match> result = new ArrayList<Match>();
            for (Match m : input) {
                int end;
                int start = Math.max(m.start + shift, 0);
                if (start == (end = Math.max(m.end + shift, 0))) continue;
                result.add(new Match(start, end));
            }
            return result;
        }

        public static boolean addAllIfNotAlreadyMatched(List<Match> currentEntries, List<Match> newEntries) {
            if (currentEntries == null || newEntries == null) {
                return false;
            }
            boolean anyAdded = false;
            for (Match newEntry : newEntries) {
                boolean alreadyMatched = false;
                for (Match currentEntry : currentEntries) {
                    if (!currentEntry.spans(newEntry.start, newEntry.end)) continue;
                    alreadyMatched = true;
                    break;
                }
                if (alreadyMatched) continue;
                anyAdded = true;
                currentEntries.add(newEntry);
            }
            return anyAdded;
        }

        @Override
        public int compareTo(Match o) {
            return this.start - o.start;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Match other = (Match)obj;
            if (this.start != other.start) {
                return false;
            }
            return this.end == other.end;
        }

        public int hashCode() {
            int hash = 7;
            hash = 73 * hash + this.start;
            hash = 73 * hash + this.end;
            return hash;
        }
    }

    private static class Modification {
        public final String from;
        public final String to;
        public final String source;

        public Modification(String from, String to, String source) {
            this.from = from;
            this.to = to;
            this.source = source;
        }
    }
}

