/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.gui.MainGui;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Timer;

public class IgnoredMessages {
    public static final int MODE_HIDE = 0;
    public static final int MODE_COUNT = 1;
    public static final int MODE_COMPACT = 2;
    public static final int MODE_SHOW = 3;
    private static final int DELAY = 30;
    private final MainGui g;
    private final Map<String, Integer> countPerChannel = new HashMap<String, Integer>();

    public IgnoredMessages(MainGui g) {
        this.g = g;
        Timer timer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgnoredMessages.this.output();
            }
        });
        timer.setRepeats(true);
        timer.start();
    }

    public void ignoredMessage(String channel) {
        if (!this.countPerChannel.containsKey(channel)) {
            this.countPerChannel.put(channel, 1);
        } else {
            this.countPerChannel.put(channel, this.countPerChannel.get(channel) + 1);
        }
    }

    private void output() {
        for (String channel : this.countPerChannel.keySet()) {
            int count = this.countPerChannel.get(channel);
            if (count <= 0) continue;
            this.g.ignoredMessagesCount(channel, "Ignored " + count + " message" + (count == 1 ? "" : "s") + " in the last " + 30 + "s");
        }
        this.countPerChannel.clear();
    }
}

