/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.Addressbook;
import chatty.ChannelState;
import chatty.Commands;
import chatty.Helper;
import chatty.Room;
import chatty.SettingsManager;
import chatty.TwitchClient;
import chatty.User;
import chatty.gui.Channels;
import chatty.gui.DockedDialogManager;
import chatty.gui.GuiUtil;
import chatty.gui.Highlighter;
import chatty.gui.IgnoredMessages;
import chatty.gui.MainMenu;
import chatty.gui.StyleManager;
import chatty.gui.TrayIconManager;
import chatty.gui.TwitchUrl;
import chatty.gui.UrlOpener;
import chatty.gui.UserListener;
import chatty.gui.WindowManager;
import chatty.gui.WindowStateManager;
import chatty.gui.colors.MsgColorItem;
import chatty.gui.colors.MsgColorManager;
import chatty.gui.colors.UsercolorItem;
import chatty.gui.components.AddressbookDialog;
import chatty.gui.components.AutoModDialog;
import chatty.gui.components.Channel;
import chatty.gui.components.ChannelInfoDialog;
import chatty.gui.components.ConnectionDialog;
import chatty.gui.components.DebugWindow;
import chatty.gui.components.EmotesDialog;
import chatty.gui.components.ErrorMessage;
import chatty.gui.components.FavoritesDialog;
import chatty.gui.components.FollowersDialog;
import chatty.gui.components.HighlightedMessages;
import chatty.gui.components.JoinDialog;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.LiveStreamsDialog;
import chatty.gui.components.LivestreamerDialog;
import chatty.gui.components.ModerationLog;
import chatty.gui.components.SearchDialog;
import chatty.gui.components.StreamChat;
import chatty.gui.components.TokenDialog;
import chatty.gui.components.TokenGetDialog;
import chatty.gui.components.admin.AdminDialog;
import chatty.gui.components.admin.SelectGameDialog;
import chatty.gui.components.admin.StatusHistory;
import chatty.gui.components.eventlog.Event;
import chatty.gui.components.eventlog.EventLog;
import chatty.gui.components.help.About;
import chatty.gui.components.menus.CommandActionEvent;
import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.menus.ContextMenuHelper;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.EmoteContextMenu;
import chatty.gui.components.menus.StreamChatContextMenu;
import chatty.gui.components.menus.TextSelectionMenu;
import chatty.gui.components.routing.RoutingManager;
import chatty.gui.components.routing.RoutingTargets;
import chatty.gui.components.settings.EmoteSettings;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.srl.SRL;
import chatty.gui.components.textpane.AutoModMessage;
import chatty.gui.components.textpane.InfoMessage;
import chatty.gui.components.textpane.ModLogInfo;
import chatty.gui.components.textpane.SubscriberMessage;
import chatty.gui.components.textpane.UserMessage;
import chatty.gui.components.textpane.UserNotice;
import chatty.gui.components.updating.UpdateDialog;
import chatty.gui.components.userinfo.UserInfoManager;
import chatty.gui.components.userinfo.UserNotes;
import chatty.gui.emoji.EmojiUtil;
import chatty.gui.laf.LaF;
import chatty.gui.laf.LaFChanger;
import chatty.gui.notifications.Notification;
import chatty.gui.notifications.NotificationActionListener;
import chatty.gui.notifications.NotificationManager;
import chatty.gui.notifications.NotificationWindowManager;
import chatty.gui.transparency.TransparencyDialog;
import chatty.gui.transparency.TransparencyManager;
import chatty.lang.Language;
import chatty.util.BatchAction;
import chatty.util.ChattyMisc;
import chatty.util.CopyMessages;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.ElapsedTime;
import chatty.util.GitHub;
import chatty.util.IconManager;
import chatty.util.ImageCache;
import chatty.util.MiscUtil;
import chatty.util.OtherBadges;
import chatty.util.RecentlyAffectedUsers;
import chatty.util.RepeatMsgHelper;
import chatty.util.Replacer2;
import chatty.util.Sound;
import chatty.util.StringUtil;
import chatty.util.api.AccessChecker;
import chatty.util.api.CachedImage;
import chatty.util.api.ChannelStatus;
import chatty.util.api.CheerEmoticon;
import chatty.util.api.Emoticon;
import chatty.util.api.EmoticonUpdate;
import chatty.util.api.Emoticons;
import chatty.util.api.Follower;
import chatty.util.api.FollowerInfo;
import chatty.util.api.IgnoredEmotes;
import chatty.util.api.LocalEmotesSetting;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamInfo;
import chatty.util.api.TokenInfo;
import chatty.util.api.TwitchApi;
import chatty.util.api.eventsub.payloads.ModActionPayload;
import chatty.util.api.eventsub.payloads.SuspiciousMessagePayload;
import chatty.util.api.usericons.Usericon;
import chatty.util.colors.HtmlColors;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockLayout;
import chatty.util.dnd.DockPopout;
import chatty.util.gif.FocusUpdates;
import chatty.util.gif.GifUtil;
import chatty.util.history.HistoryUtil;
import chatty.util.hotkeys.HotkeyManager;
import chatty.util.irc.MsgTags;
import chatty.util.settings.FileManager;
import chatty.util.settings.SettingChangeListener;
import chatty.util.settings.Settings;
import chatty.util.settings.SettingsListener;
import chatty.util.seventv.WebPUtil;
import chatty.util.tts.TextToSpeech;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.json.simple.JSONValue;

public class MainGui
extends JFrame
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(MainGui.class.getName());
    public final Emoticons emoticons = new Emoticons();
    TwitchClient client = null;
    public volatile boolean guiCreated;
    private Channels channels;
    private ConnectionDialog connectionDialog;
    private TokenDialog tokenDialog;
    private TokenGetDialog tokenGetDialog;
    private DebugWindow debugWindow;
    private UserInfoManager userInfoDialog;
    private About aboutDialog;
    private ChannelInfoDialog channelInfoDialog;
    private AdminDialog adminDialog;
    private FavoritesDialog favoritesDialog;
    private JoinDialog joinDialog;
    private HighlightedMessages highlightedMessages;
    private HighlightedMessages ignoredMessages;
    private MainMenu menu;
    private LiveStreamsDialog liveStreamsDialog;
    private NotificationWindowManager<NotificationManager.NotificationWindowData> notificationWindowManager;
    private NotificationManager notificationManager;
    private ErrorMessage errorMessage;
    private AddressbookDialog addressbookDialog;
    private SRL srl;
    private LivestreamerDialog livestreamerDialog;
    private UpdateDialog updateDialog;
    private EmotesDialog emotesDialog;
    private FollowersDialog followerDialog;
    private FollowersDialog subscribersDialog;
    private StreamChat streamChat;
    private ModerationLog moderationLog;
    private AutoModDialog autoModDialog;
    private EventLog eventLog;
    private final Highlighter highlighter = new Highlighter("highlight");
    private final Highlighter ignoreList = new Highlighter("ignore");
    private final Highlighter filter = new Highlighter("filter");
    public final RepeatMsgHelper repeatMsg;
    private final MsgColorManager msgColorManager;
    private StyleManager styleManager;
    private TrayIconManager trayIcon;
    private final StateUpdater state = new StateUpdater();
    private WindowStateManager windowStateManager;
    protected DockedDialogManager dockedDialogs;
    private final IgnoredMessages ignoredMessagesHelper = new IgnoredMessages(this);
    public final HotkeyManager hotkeyManager = new HotkeyManager(this);
    public final LocalEmotesSetting localEmotes;
    public RoutingManager routingManager;
    private ActionListener actionListener;
    private final WindowListener windowListener = new MyWindowListener();
    private final UserListener userListener = new MyUserListener();
    private final LinkLabelListener linkLabelListener = new MyLinkLabelListener();
    protected final ContextMenuListener contextMenuListener = new MyContextMenuListener();
    private static final String[] menuBooleanSettings = new String[]{"showJoinsParts", "ontop", "showModMessages", "attachedWindows", "simpleTitle", "globalHotkeysEnabled", "mainResizable", "streamChatResizable", "titleShowUptime", "titleShowViewerCount", "titleShowChannelState", "titleLongerUptime", "titleConnections"};
    private String manuallyChangedToken = null;

    public MainGui(TwitchClient client) {
        this.client = client;
        this.msgColorManager = new MsgColorManager(client.settings);
        this.localEmotes = new LocalEmotesSetting(client.settings, this);
        this.repeatMsg = new RepeatMsgHelper(client.settings);
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.createGui();
    }

    private void setWindowIcons() {
        this.setIconImages(IconManager.getMainIcons());
    }

    private void setLiveStreamsWindowIcons() {
        this.liveStreamsDialog.setIconImages(IconManager.getLiveIcons());
    }

    private void setHelpWindowIcons() {
        this.aboutDialog.setIconImages(IconManager.getHelpIcons());
    }

    private void setDebugWindowIcons() {
        this.debugWindow.setIconImages(IconManager.getDebugIcons());
    }

    private void createGui() {
        this.setDefaultCloseOperation(0);
        this.setWindowIcons();
        this.actionListener = new MyActionListener();
        TextSelectionMenu.listener = this.contextMenuListener;
        this.debugWindow = new DebugWindow(new DebugCheckboxListener());
        this.setDebugWindowIcons();
        this.errorMessage = new ErrorMessage((Frame)this, this.linkLabelListener);
        this.connectionDialog = new ConnectionDialog(this);
        GuiUtil.installEscapeCloseOperation(this.connectionDialog);
        this.tokenDialog = new TokenDialog(this);
        this.tokenGetDialog = new TokenGetDialog(this);
        this.userInfoDialog = new UserInfoManager(this, this.client.settings, this.contextMenuListener, this.client.api);
        this.aboutDialog = new About();
        this.setHelpWindowIcons();
        this.favoritesDialog = new FavoritesDialog((Window)this, this.client.channelFavorites, this.contextMenuListener);
        GuiUtil.installEscapeCloseOperation(this.favoritesDialog);
        this.joinDialog = new JoinDialog(this);
        GuiUtil.installEscapeCloseOperation(this.joinDialog);
        EmoteContextMenu.setEmoteManager(this.emoticons);
        this.emotesDialog = new EmotesDialog((Window)this, this.emoticons, this, this.contextMenuListener);
        GuiUtil.installEscapeCloseOperation(this.emotesDialog);
        this.trayIcon = new TrayIconManager();
        this.trayIcon.addActionListener(new TrayMenuListener());
        if (this.client.settings.getBoolean("trayIconAlways")) {
            this.trayIcon.setIconVisible(true);
        }
        this.notificationWindowManager = new NotificationWindowManager(this);
        this.notificationWindowManager.setNotificationActionListener(new MyNotificationActionListener());
        this.notificationManager = new NotificationManager(this, this.client.settings, this.client.addressbook, this.client.channelFavorites);
        this.styleManager = new StyleManager(this.client.settings);
        this.channels = new Channels(this, this.styleManager, this.contextMenuListener);
        this.channels.getComponent().setPreferredSize(new Dimension(600, 300));
        this.add(this.channels.getComponent(), "Center");
        this.channels.setChangeListener(new ChannelChangeListener());
        this.routingManager = new RoutingManager(this, this.channels, this.styleManager, this.contextMenuListener, this.client.chatLog);
        this.dockedDialogs = new DockedDialogManager(this, this.channels, this.client.settings);
        this.highlightedMessages = new HighlightedMessages(this, this.styleManager, Language.getString("highlightedDialog.title"), Language.getString("menubar.dialog.highlightedMessages"), Language.getString("highlightedDialog.info"), this.contextMenuListener, this.dockedDialogs, "highlightDock");
        this.ignoredMessages = new HighlightedMessages(this, this.styleManager, Language.getString("ignoredDialog.title"), Language.getString("menubar.dialog.ignoredMessages"), Language.getString("ignoredDialog.info"), this.contextMenuListener, this.dockedDialogs, "ignoreDock");
        this.followerDialog = new FollowersDialog(FollowersDialog.Type.FOLLOWERS, this, this.client.api, this.contextMenuListener, this.dockedDialogs);
        this.subscribersDialog = new FollowersDialog(FollowersDialog.Type.SUBSCRIBERS, this, this.client.api, this.contextMenuListener, this.dockedDialogs);
        this.channelInfoDialog = new ChannelInfoDialog((Frame)this, this.dockedDialogs);
        this.channelInfoDialog.addContextMenuListener(this.contextMenuListener);
        this.adminDialog = new AdminDialog(this, this.client.api, this.dockedDialogs);
        this.liveStreamsDialog = new LiveStreamsDialog(this, this.contextMenuListener, this.client.channelFavorites, this.client.settings, this.dockedDialogs);
        this.setLiveStreamsWindowIcons();
        this.addressbookDialog = new AddressbookDialog(this, this.client.addressbook);
        this.srl = new SRL(this, this.client.speedrunsLive, this.contextMenuListener);
        this.livestreamerDialog = new LivestreamerDialog((Window)this, this.linkLabelListener, this.client.settings);
        this.updateDialog = new UpdateDialog((Window)this, this.linkLabelListener, this.client.settings, () -> this.exit());
        this.client.settings.addSettingChangeListener(new MySettingChangeListener());
        this.client.settings.addSettingsListener(new MySettingsListener());
        this.streamChat = new StreamChat(this, this.styleManager, this.contextMenuListener, this.client.settings.getBoolean("streamChatBottom"), this.dockedDialogs);
        StreamChatContextMenu.client = this.client;
        this.moderationLog = new ModerationLog(this, this.dockedDialogs);
        this.autoModDialog = new AutoModDialog(this, this.client.api, this.client, this.dockedDialogs);
        this.eventLog = new EventLog(this);
        EventLog.setMain(this.eventLog);
        if (this.client.settings.getBoolean("initSettingsDialog")) {
            this.getSettingsDialog(null);
        }
        MainMenuListener menuListener = new MainMenuListener();
        this.menu = new MainMenu(menuListener, menuListener);
        this.setJMenuBar(this.menu);
        this.addListeners();
        this.pack();
        this.client.api.setUserId(this.client.settings.getString("username"), this.client.settings.getString("userid"));
        if (this.client.settings.getBoolean("bttvEmotes")) {
            this.client.bttvEmotes.requestEmotes("$global$", false);
        }
        OtherBadges.requestBadges(r -> this.client.usericonManager.setThirdPartyIcons(r), false);
        ChattyMisc.request(() -> SwingUtilities.invokeLater(() -> this.updateSmilies()));
        this.windowStateManager = new WindowStateManager(this, this.client.settings);
        this.windowStateManager.addWindow(this, "main", true, true);
        this.windowStateManager.addWindow(this.highlightedMessages, "highlights", true, true);
        this.windowStateManager.addWindow(this.ignoredMessages, "ignoredMessages", true, true);
        this.windowStateManager.addWindow(this.channelInfoDialog, "channelInfo", true, true);
        this.windowStateManager.addWindow(this.liveStreamsDialog, "liveStreams", true, true);
        this.windowStateManager.addWindow(this.adminDialog, "admin", true, true);
        this.windowStateManager.addWindow(this.addressbookDialog, "addressbook", true, true);
        this.windowStateManager.addWindow(this.emotesDialog, "emotes", true, true);
        this.windowStateManager.addWindow(this.followerDialog, "followers", true, true);
        this.windowStateManager.addWindow(this.subscribersDialog, "subscribers", true, true);
        this.windowStateManager.addWindow(this.moderationLog, "moderationLog", true, true);
        this.windowStateManager.addWindow(this.streamChat, "streamChat", true, true);
        this.windowStateManager.addWindow(this.userInfoDialog.getDummyWindow(), "userInfo", true, false);
        this.windowStateManager.addWindow(this.autoModDialog, "autoMod", true, true);
        this.windowStateManager.addWindow(this.eventLog, "eventLog", true, true);
        if (System.getProperty("java.version").equals("1.8.0_161") || System.getProperty("java.version").equals("1.8.0_162")) {
            GuiUtil.installTextComponentFocusWorkaround();
        }
        ToolTipManager.sharedInstance().setInitialDelay(555);
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        TransparencyManager.init(this.channels);
        this.guiCreated = true;
    }

    public void setWindowAttached(Window window, boolean attached) {
        this.windowStateManager.setWindowAttached(window, attached);
    }

    protected void popoutCreated(Window popout) {
        this.hotkeyManager.registerPopout(popout);
    }

    public void getSettingsDialog(Consumer<SettingsDialog> action) {
        GuiUtil.edt(() -> SettingsDialog.get(this, action));
    }

    private void hotkeyCommand(String command, String parameter2, boolean selectedUserRequired) {
        String selectedUserName;
        Channel channel = this.channels.getLastActiveChannel();
        User selectedUser = channel.getSelectedUser();
        if (selectedUserRequired && selectedUser == null) {
            return;
        }
        String string = selectedUserName = selectedUser != null ? selectedUser.getName() : "";
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        String parameter = null;
        if (!selectedUserName.isEmpty() || parameter2 != null) {
            parameter = selectedUserName + (parameter2 != null ? " " + parameter2 : "");
        }
        this.client.command(this.channels.getLastActiveChannel().getRoom(), command, parameter);
    }

    private void hotkeyCommandAnon(String command) {
        Channel channel = this.channels.getActiveChannel();
        User selectedUser = channel.getSelectedUser();
        String selectedUserName = selectedUser != null ? selectedUser.getName() : "";
        Parameters p = Parameters.create(null);
        p.put("selectedUserName", selectedUserName);
        this.client.anonCustomCommand(channel.getRoom(), command, p);
    }

    private void addMenuAction(String id, String label, int mnemonic, Action action) {
        action.putValue("Name", Language.getString("menubar." + id));
        action.putValue("MnemonicKey", mnemonic);
        this.menu.setAction(id, action);
        this.hotkeyManager.registerAction(id, label, action);
    }

    private void addListeners() {
        WindowManager manager = new WindowManager(this);
        manager.addWindowOnTop(this.liveStreamsDialog);
        MainWindowListener mainWindowListener = new MainWindowListener();
        this.addWindowStateListener(mainWindowListener);
        this.addWindowListener(mainWindowListener);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (MainGui.this.client.settings.getLong("inputFocus") == 1L) {
                    MainGui.this.channels.setInitialFocus();
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        this.hotkeyManager.registerAction("custom.command", "Custom Command", "Enter the name of a Custom Command (only the name), as added to the Custom Commands list under \"Commands\". This is useful when you have it added to the Custom Commands list already anyway (for example if you want to use it in another context as well). Otherwise the \"Anon. Custom Command\" may be more convenient.", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.hotkeyCommand(e.getActionCommand(), null, false);
            }
        });
        this.hotkeyManager.registerAction("custom.anonCommand", "Anon. Custom Command", "Enter a Custom Command directly (for example \"/echo $datetime()\" to output the current time as an info message). This is an anonymous Custom Command because it is not added to the Custom Commands list and thus no name is specified for it. It can only be executed via this hotkey.", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.hotkeyCommandAnon(e.getActionCommand());
            }
        });
        this.hotkeyManager.registerAction("tabs.next", "Tabs: Switch to next tab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.channels.switchToNextTab();
            }
        });
        this.hotkeyManager.registerAction("tabs.previous", "Tabs: Switch to previous tab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.channels.switchToPreviousTab();
            }
        });
        this.hotkeyManager.registerAction("tabs.switch", "Tabs: Switch to tab (specify index or #chan)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String target = e.getActionCommand();
                try {
                    int index = Integer.parseInt(target);
                    MainGui.this.channels.switchToTabIndex(index - 1);
                }
                catch (NumberFormatException ex) {
                    MainGui.this.channels.switchToTabId(target);
                }
            }
        });
        this.hotkeyManager.registerAction("tabs.close", "Tabs: Close tab/popout", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.channels.getActiveContent().remove();
            }
        });
        this.addMenuAction("dialog.search", "Dialog: Open Search Dialog", 70, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.openSearchDialog();
            }
        });
        this.addMenuAction("dialog.addressbook", "Dialog: Addressbook (toggle)", 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleAddressbook();
            }
        });
        this.addMenuAction("dialog.autoModDialog", "Dialog: AutoMod Dialog (toggle)", 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleAutoModDialog();
            }
        });
        this.addMenuAction("dialog.moderationLog", "Dialog: Moderation Log (toggle)", 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleModerationLog();
            }
        });
        this.addMenuAction("dialog.channelInfo", "Dialog: Channel Info Dialog (toggle)", 67, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleChannelInfoDialog();
            }
        });
        this.addMenuAction("dialog.channelAdmin", "Dialog: Channel Admin Dialog (toggle)", 65, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleChannelAdminDialog();
            }
        });
        this.addMenuAction("dialog.eventLog", "Dialog: Event log (toggle)", 65, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleEventLog();
            }
        });
        this.addMenuAction("dialog.toggleEmotes", "Dialog: Emotes Dialog (toggle)", 69, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleEmotesDialog();
            }
        });
        this.addMenuAction("dialog.highlightedMessages", "Dialog: Highlighted Messages (toggle)", 72, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleHighlightedMessages();
            }
        });
        this.addMenuAction("dialog.ignoredMessages", "Dialog: Ignored Messages (toggle)", 73, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleIgnoredMessages();
            }
        });
        this.addMenuAction("dialog.streams", "Dialog: Live Channels Dialog (toggle)", 76, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleLiveStreamsDialog();
            }
        });
        this.addMenuAction("dialog.followers", "Dialog: Followers List (toggle)", 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleFollowerDialog();
            }
        });
        this.addMenuAction("dialog.subscribers", "Dialog: Subscriber List (toggle)", 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleSubscriberDialog();
            }
        });
        this.addMenuAction("dialog.livestreamer", "Dialog: " + Language.getString("menubar.dialog.livestreamer") + " (toggle)", 76, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainGui.this.livestreamerDialog.isVisible()) {
                    MainGui.this.livestreamerDialog.close();
                } else {
                    MainGui.this.livestreamerDialog.open(null, null);
                }
            }
        });
        this.addMenuAction("dialog.joinChannel", "Dialog: Join Channel", 74, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.openJoinDialog();
            }
        });
        this.addMenuAction("dialog.favorites", "Dialog: Favorites / History (toggle)", 70, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleFavoritesDialog();
            }
        });
        this.addMenuAction("dialog.updates", "Dialog: Updates", 85, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.openUpdateDialog();
            }
        });
        this.addMenuAction("about", "Open Help", 72, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.openHelp("");
            }
        });
        this.hotkeyManager.registerAction("selection.toggle", "User Selection: Toggle", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Channel channel = MainGui.this.channels.getLastActiveChannel();
                channel.toggleUserSelection();
            }
        });
        this.hotkeyManager.registerAction("selection.next", "User Selection: Next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Channel channel = MainGui.this.channels.getLastActiveChannel();
                channel.selectNextUser();
            }
        });
        this.hotkeyManager.registerAction("selection.nextExitAtBottom", "User Selection: Next (Exit at bottom)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Channel channel = MainGui.this.channels.getLastActiveChannel();
                channel.selectNextUserExitAtBottom();
            }
        });
        this.hotkeyManager.registerAction("selection.previous", "User Selection: Previous", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Channel channel = MainGui.this.channels.getLastActiveChannel();
                channel.selectPreviousUser();
            }
        });
        this.hotkeyManager.registerAction("selection.exit", "User Selection: Exit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Channel channel = MainGui.this.channels.getLastActiveChannel();
                channel.exitUserSelection();
            }
        });
        this.hotkeyManager.registerAction("selection.timeout30", "User Selection: Timeout (30s)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.hotkeyCommand("timeout", "30", true);
            }
        });
        this.hotkeyManager.registerAction("selection.timeout600", "User Selection: Timeout (10m)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.hotkeyCommand("timeout", "600", true);
            }
        });
        this.hotkeyManager.registerAction("selection.timeout30m", "User Selection: Timeout (30m)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.hotkeyCommand("timeout", "1800", true);
            }
        });
        this.hotkeyManager.registerAction("selection.timeout24h", "User Selection: Timeout (24h)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.hotkeyCommand("timeout", "86400", true);
            }
        });
        this.hotkeyManager.registerAction("commercial.30", "Run commercial (30s)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.runCommercial(30);
            }
        });
        this.hotkeyManager.registerAction("commercial.60", "Run commercial (60s)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.runCommercial(60);
            }
        });
        this.hotkeyManager.registerAction("commercial.90", "Run commercial (90s)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.runCommercial(90);
            }
        });
        this.hotkeyManager.registerAction("commercial.120", "Run commercial (120s)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.runCommercial(120);
            }
        });
        this.hotkeyManager.registerAction("commercial.180", "Run commercial (180s)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.runCommercial(180);
            }
        });
        this.addMenuAction("stream.addhighlight", "Stream: Add Stream Highlight", 65, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.hotkeyCommand("addstreamhighlight", null, false);
            }
        });
        this.hotkeyManager.registerAction("stream.addmarker", "Stream: Add Stream Marker", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.hotkeyCommand("marker", null, false);
            }
        });
        final Consumer<String> scrollAction = action -> {
            DockContent content = this.channels.getActiveContent();
            if (content.getComponent() instanceof Channel) {
                ((Channel)content.getComponent()).scroll((String)action);
            } else if (content.getId().startsWith("'")) {
                this.routingManager.scroll(content.getId(), (String)action);
            }
        };
        this.hotkeyManager.registerAction("scroll.pageUp", "Scroll: Page Up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scrollAction.accept("pageUp");
            }
        });
        this.hotkeyManager.registerAction("scroll.pageDown", "Scroll: Page Down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scrollAction.accept("pageDown");
            }
        });
        this.hotkeyManager.registerAction("window.minimizeToTray", "Window: Minimize to Tray", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.minimizeToTray();
            }
        });
        this.hotkeyManager.registerAction("window.restoreFromTray", "Window: Restore from Tray/Minimized", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.makeVisible();
            }
        });
        this.hotkeyManager.registerAction("window.toggleMinimizeToTray", "Window: Toggle Minimize to Tray", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainGui.this.isMinimized()) {
                    MainGui.this.makeVisible();
                } else {
                    MainGui.this.minimizeToTray();
                }
            }
        });
        this.hotkeyManager.registerAction("window.toggleCompact", "Window: Toggle Compact Mode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleCompact(false);
            }
        });
        this.hotkeyManager.registerAction("window.toggleCompactMaximized", "Window: Toggle Compact Mode (Maximized)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleCompact(true);
            }
        });
        this.hotkeyManager.registerAction("window.toggleInput", "Window: Toggle Input", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.channels.getActiveChannel().toggleInput();
            }
        });
        this.addMenuAction("window.toggleUserlist", "Window: Toggle Userlist", 85, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.channels.getActiveChannel().toggleUserlist();
            }
        });
        this.hotkeyManager.registerAction("dialog.toggleHelp", "Window: Toggle Help", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.toggleHelp();
            }
        });
        this.addMenuAction("dialog.streamchat", "Window: Open StreamChat", 79, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.openStreamChat();
            }
        });
        this.hotkeyManager.registerAction("dialog.toggleTransparency", "Window: Toggle Transparency", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransparencyManager.toggleTransparent();
            }
        });
        this.hotkeyManager.registerAction("notification.closeAll", "Close all shown/queued notifications", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.notificationWindowManager.clearAll();
            }
        });
        this.hotkeyManager.registerAction("notification.closeAllShown", "Close all shown notifications", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.notificationWindowManager.clearAllShown();
            }
        });
        this.hotkeyManager.registerAction("tts.pause", "Text to speech: Pause speaking (queue active)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextToSpeech.get(MainGui.this.client.settings).pause();
            }
        });
        this.hotkeyManager.registerAction("tts.resume", "Text to speech: Resume speaking", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextToSpeech.get(MainGui.this.client.settings).start();
            }
        });
        this.hotkeyManager.registerAction("tts.skipForwards", "Text to speech: Skip forwards in queue (interrupt current message)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextToSpeech.get(MainGui.this.client.settings).skipForwards();
            }
        });
        this.hotkeyManager.registerAction("tts.skipBackwards", "Text to speech: Skip backwards in queue (repeat previous message)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextToSpeech.get(MainGui.this.client.settings).skipBackwards();
            }
        });
        this.hotkeyManager.registerAction("tts.clearQueue", "Text to speech: Clear current queue", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextToSpeech.get(MainGui.this.client.settings).clearQueue();
            }
        });
        this.hotkeyManager.registerAction("tts.on", "Text to speech: Enable TTS (queue active, speaking)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextToSpeech.get(MainGui.this.client.settings).enable();
            }
        });
        this.hotkeyManager.registerAction("tts.off", "Text to speech: Disable TTS (queue inactive, no speaking)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextToSpeech.get(MainGui.this.client.settings).disable();
            }
        });
        this.addMenuAction("application.exit", "Exit Chatty", 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGui.this.exit();
            }
        });
    }

    public void showGui() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!MainGui.this.guiCreated) {
                    return;
                }
                MainGui.this.startUpdatingState();
                MainGui.this.windowStateManager.loadWindowStates();
                MainGui.this.windowStateManager.setWindowPosition(MainGui.this);
                MainGui.this.setVisible(true);
                SwingUtilities.invokeLater(() -> MainGui.this.windowStateManager.setAttachedWindowsEnabled(MainGui.this.client.settings.getBoolean("attachedWindows")));
                MainGui.this.channels.init();
                MainGui.this.state.init();
                MainGui.this.reopenWindows();
                MainGui.this.client.init();
                switch ((int)MainGui.this.client.settings.getLong("minimizeOnStart")) {
                    case 1: {
                        SwingUtilities.invokeLater(() -> MainGui.this.minimize(true));
                        break;
                    }
                    case 2: {
                        SwingUtilities.invokeLater(() -> MainGui.this.minimizeToTray(true));
                    }
                }
            }
        });
    }

    public void toggleCompact(boolean maximize) {
        boolean hide;
        if (!this.isVisible()) {
            return;
        }
        boolean bl = hide = this.getJMenuBar() != null;
        if (hide) {
            this.setJMenuBar(null);
        } else {
            this.setJMenuBar(this.menu);
            this.hotkeyManager.refreshHotkeys(this.getRootPane());
        }
        this.revalidate();
        if (maximize) {
            if (hide) {
                this.setExtendedState(6);
            } else {
                this.setExtendedState(0);
            }
        }
    }

    private void makeVisible() {
        this.setVisible(true);
        this.setState(0);
        this.channels.getDock().showHiddenWindows();
        this.toFront();
    }

    public void loadSettings() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainGui.this.guiCreated) {
                    MainGui.this.loadSettingsInternal();
                }
            }
        });
    }

    private void loadSettingsInternal() {
        if (this.client.settings.getBoolean("bufferStrategy1")) {
            this.createBufferStrategy(1);
        }
        this.setAlwaysOnTop(this.client.settings.getBoolean("ontop"));
        this.setResizable(this.client.settings.getBoolean("mainResizable"));
        this.streamChat.setResizable(this.client.settings.getBoolean("streamChatResizable"));
        this.loadMenuSettings();
        this.updateConnectionDialog(null);
        this.userInfoDialog.setUserDefinedButtonsDef(this.client.settings.getString("timeoutButtons"));
        this.debugWindow.getLogIrcCheckBox().setSelected(this.client.settings.getBoolean("debugLogIrc"));
        this.updateLiveStreamsDialog();
        this.updateFollowerDialogs();
        if (this.client.settings.getBoolean("maximized")) {
            this.setExtendedState(6);
        }
        this.updateMatchingPresets();
        this.updateHistoryRange();
        this.updateHistoryVerticalZoom();
        this.updateNotificationSettings();
        this.updateChannelsSettings();
        this.updateHighlightNextMessages();
        this.updateHighlightIncludeAllMatches();
        this.repeatMsg.loadSettings();
        this.msgColorManager.loadFromSettings();
        this.notificationManager.loadFromSettings();
        this.client.usericonManager.init();
        this.channels.setPopoutAttributes(this.client.settings.getList("popoutAttributes"));
        this.updatePopoutSettings();
        this.channels.setInsertTop(this.client.settings.getBoolean("chatInsertTop"));
        this.loadCommercialDelaySettings();
        UrlOpener.setSettings(this.client.settings);
        UrlOpener.setCustomCommandEnabled(this.client.settings.getBoolean("urlCommandEnabled"));
        UrlOpener.setCustomCommand(this.client.settings.getString("urlCommand"));
        this.favoritesDialog.setSorting((int)this.client.settings.getLong("favoritesSorting"));
        this.updateCustomContextMenuEntries();
        this.client.api.setToken(this.client.settings.getString("token"));
        this.client.api.setLocalUserId(this.client.settings.getString("userid"));
        if (this.client.settings.getList("scopes").isEmpty()) {
            this.client.api.checkToken();
        }
        this.client.api.getStreamLabels();
        this.localEmotes.init();
        this.emoticons.setLocalEmotes(this.localEmotes.getData());
        this.emoticons.setIgnoredEmotes(this.client.settings.getList("ignoredEmotes"));
        this.emoticons.loadFavoritesFromSettings(this.client.settings);
        this.client.api.getEmotesBySets(this.emoticons.getFavoritesNonGlobalEmotesets());
        this.emoticons.loadCustomEmotes();
        this.emoticons.addEmoji(this.client.settings.getString("emoji"));
        this.emoticons.setCheerState(this.client.settings.getString("cheersType"));
        this.emoticons.setCheerBackground(HtmlColors.decode(this.client.settings.getString("backgroundColor")));
        this.userInfoDialog.setTimestampFormat(this.styleManager.makeTimestampFormat("userDialogTimestamp"));
        this.userInfoDialog.setFontSize(this.client.settings.getLong("dialogFontSize"));
        UserNotes.init(this.client.api, this.client.settings);
        this.hotkeyManager.setGlobalHotkeysEnabled(this.client.settings.getBoolean("globalHotkeysEnabled"));
        this.hotkeyManager.loadFromSettings(this.client.settings);
        this.streamChat.setMessageTimeout((int)this.client.settings.getLong("streamChatMessageTimeout"));
        this.emotesDialog.setEmoteScale((int)this.client.settings.getLong("emoteScaleDialog"));
        this.emotesDialog.setEmoteImageType(Emoticon.makeImageType(this.client.settings.getBoolean("animatedEmotes")));
        this.emotesDialog.setHiddenEmotesets(this.client.settings.getList("emoteHiddenSets"));
        this.emotesDialog.setCloseOnDoubleClick(this.client.settings.getBoolean("closeEmoteDialogOnDoubleClick"));
        this.adminDialog.setStatusHistorySorting(this.client.settings.getString("statusHistorySorting"));
        Sound.setDeviceName(this.client.settings.getString("soundDevice"));
        Sound.setCommand(this.client.settings.getBoolean("soundCommandEnabled"), this.client.settings.getString("soundCommand"));
        this.dockedDialogs.loadSettings();
        this.updateTokenScopes();
        FocusUpdates.set(this.client.settings);
        GifUtil.setSettings(this.client.settings);
        TransparencyManager.loadSettings(this.client.settings);
    }

    private void loadMenuSettings() {
        for (String setting : menuBooleanSettings) {
            this.loadMenuSetting(setting);
        }
    }

    private void loadMenuSetting(String name) {
        this.menu.setItemState(name, this.client.settings.getBoolean(name));
    }

    private void updateHighlight() {
        BatchAction.queue(this.highlighter, () -> {
            this.highlighter.update(StringUtil.getStringList(this.client.settings.getList("highlight")));
            this.highlighter.updateBlacklist(StringUtil.getStringList(this.client.settings.getList("highlightBlacklist")));
            List substitutesValue = this.client.settings.getList("matchingSubstitutes");
            this.highlighter.updateSubstitutes(Replacer2.create(substitutesValue));
            this.highlighter.setSubstitutitesDefault(this.client.settings.getBoolean("matchingSubstitutesEnabled"));
        });
    }

    private void updateIgnore() {
        BatchAction.queue(this.ignoreList, () -> {
            this.ignoreList.update(StringUtil.getStringList(this.client.settings.getList("ignore")));
            this.ignoreList.updateBlacklist(StringUtil.getStringList(this.client.settings.getList("ignoreBlacklist")));
        });
    }

    private void updateMatchingPresets() {
        List settingValue = this.client.settings.getList("matchingPresets");
        Map<String, CustomCommand> presets = Highlighter.HighlightItem.makePresets(settingValue);
        if (SettingsManager.switchedFromVersionBefore("0.18")) {
            for (String name : presets.keySet()) {
                if (!name.equals("_global_highlight") && !name.equals("_global_ignore")) continue;
                EventLog.addSystemEvent("matching.presetsBlacklist", new Object[0]);
            }
        }
        Highlighter.HighlightItem.setGlobalPresets(presets);
        Highlighter.HighlightItem.setTwitchApi(this.client.api);
        this.updateHighlight();
        this.updateIgnore();
        this.updateFilter();
        this.updateRouting();
    }

    private void updateFilter() {
        BatchAction.queue(this.filter, () -> this.filter.update(StringUtil.getStringList(this.client.settings.getList("filter"))));
    }

    private void updateRouting() {
        BatchAction.queue(this.routingManager, () -> this.routingManager.updateRouting(StringUtil.getStringList(this.client.settings.getList("routing"))));
    }

    private void updateCustomContextMenuEntries() {
        CommandMenuItems.customCommands = this.client.customCommands;
        CommandMenuItems.setCommands(CommandMenuItems.MenuType.CHANNEL, this.client.settings.getString("channelContextMenu"));
        CommandMenuItems.setCommands(CommandMenuItems.MenuType.USER, this.client.settings.getString("userContextMenu"));
        CommandMenuItems.setCommands(CommandMenuItems.MenuType.STREAMS, this.client.settings.getString("streamsContextMenu"));
        CommandMenuItems.setCommands(CommandMenuItems.MenuType.TEXT, this.client.settings.getString("textContextMenu"));
        CommandMenuItems.setCommands(CommandMenuItems.MenuType.ADMIN, this.client.settings.getString("adminContextMenu"));
        TextSelectionMenu.update();
        ContextMenuHelper.livestreamerQualities = this.client.settings.getString("livestreamerQualities");
        ContextMenuHelper.enableLivestreamer = this.client.settings.getBoolean("livestreamer");
        ContextMenuHelper.settings = this.client.settings;
    }

    private void updateChannelsSettings() {
        this.channels.setDefaultUserlistWidth((int)this.client.settings.getLong("userlistWidth"), (int)this.client.settings.getLong("userlistMinWidth"));
        this.channels.setChatScrollbarAlways(this.client.settings.getBoolean("chatScrollbarAlways"));
        this.channels.setDefaultUserlistVisibleState(this.client.settings.getBoolean("userlistEnabled"));
    }

    public void updateHighlightSetUsername(String username) {
        this.highlighter.setUsername(username);
        this.highlighter.setHighlightUsername(this.client.settings.getBoolean("highlightUsername"));
    }

    private void updateHighlightSetUsernameHighlighted(boolean highlight) {
        this.highlighter.setHighlightUsername(highlight);
    }

    private void updateHighlightNextMessages() {
        this.highlighter.setHighlightNextMessages(this.client.settings.getBoolean("highlightNextMessages"));
    }

    private void updateHighlightIncludeAllMatches() {
        this.highlighter.setIncludeAllTextMatches(this.client.settings.getBoolean("highlightMatchesAllEntries"));
    }

    private void updateNotificationSettings() {
        this.notificationWindowManager.setDisplayTime((int)this.client.settings.getLong("nDisplayTime"));
        this.notificationWindowManager.setMaxDisplayTime((int)this.client.settings.getLong("nMaxDisplayTime"));
        this.notificationWindowManager.keepOpenOnHover(this.client.settings.getBoolean("nKeepOpenOnHover"));
        this.notificationWindowManager.setMaxDisplayItems((int)this.client.settings.getLong("nMaxDisplayed"));
        this.notificationWindowManager.setMaxQueueSize((int)this.client.settings.getLong("nMaxQueueSize"));
        int activityTime = this.client.settings.getBoolean("nActivity") ? (int)this.client.settings.getLong("nActivityTime") : -1;
        this.notificationWindowManager.setActivityTime(activityTime);
        this.notificationWindowManager.clearAll();
        this.notificationWindowManager.setScreen((int)this.client.settings.getLong("nScreen"));
        this.notificationWindowManager.setPosition((int)this.client.settings.getLong("nPosition"));
    }

    private void updatePopoutSettings() {
        this.channels.setSavePopoutAttributes(this.client.settings.getBoolean("popoutSaveAttributes"));
        this.channels.setCloseLastChannelPopout(this.client.settings.getBoolean("popoutCloseLastChannel"));
    }

    public void saveWindowStates() {
        this.userInfoDialog.aboutToSaveSettings();
        this.windowStateManager.saveWindowStates();
        this.client.settings.putList("popoutAttributes", this.channels.getPopoutAttributes());
        this.channels.saveLayout();
        TransparencyManager.saveSettings(this.client.settings);
    }

    public void setWindowPosition(Window window) {
        this.windowStateManager.setWindowPosition(window, this.getActiveWindow());
    }

    private void reopenWindows() {
        for (Window window : this.windowStateManager.getWindows()) {
            this.reopenWindow(window);
        }
    }

    private void reopenWindow(Window window) {
        if (this.windowStateManager.shouldReopen(window)) {
            this.openWindow(window);
        }
    }

    public void openWindow(Window window) {
        if (window == this.liveStreamsDialog) {
            this.openLiveStreamsDialog();
        } else if (window == this.highlightedMessages) {
            this.openHighlightedMessages(false);
        } else if (window == this.ignoredMessages) {
            this.openIgnoredMessages(false);
        } else if (window == this.channelInfoDialog) {
            this.openChannelInfoDialog();
        } else if (window == this.addressbookDialog) {
            this.openAddressbook(null);
        } else if (window == this.adminDialog) {
            this.openChannelAdminDialog();
        } else if (window == this.emotesDialog) {
            this.openEmotesDialog();
        } else if (window == this.followerDialog) {
            this.openFollowerDialog();
        } else if (window == this.subscribersDialog) {
            this.openSubscriberDialog();
        } else if (window == this.moderationLog) {
            this.openModerationLog();
        } else if (window == this.streamChat) {
            this.openStreamChat();
        } else if (window == this.autoModDialog) {
            this.openAutoModDialog();
        }
    }

    private void addLayout(String name) {
        if (StringUtil.isNullOrEmpty(name)) {
            name = JOptionPane.showInputDialog(this.rootPane, (Object)"Enter name to save the current layout:");
        }
        if (!StringUtil.isNullOrEmpty(name)) {
            boolean save = true;
            if (this.client.settings.mapGet("layouts", name) != null) {
                int result = JOptionPane.showConfirmDialog(this.rootPane, "Layout " + name + " already exists. Overwrite?", "Add layout", 0);
                boolean bl = save = result == 0;
            }
            if (save) {
                this.client.settings.mapPut("layouts", name, this.channels.getDock().getLayout().toList());
                this.printSystem("Saved current layout as " + name + ".");
            }
        } else {
            this.printSystem("Invalid layout name, didn't save layout.");
        }
    }

    private void removeLayout(String layoutName, boolean ask) {
        boolean remove = true;
        if (ask) {
            int result = JOptionPane.showConfirmDialog(this.rootPane, "Remove layout " + layoutName + "?", "Remove layout", 0);
            boolean bl = remove = result == 0;
        }
        if (!layoutName.isEmpty()) {
            if (remove) {
                this.client.settings.mapRemove("layouts", layoutName);
                this.printSystem("Layout " + layoutName + " removed.");
            }
        } else {
            this.printSystem("Invalid layout name.");
        }
    }

    private void loadLayout(String layoutName, int options) {
        DockLayout layout = DockLayout.fromList((List)this.client.settings.mapGet("layouts", layoutName));
        if (layout != null) {
            this.channels.changeLayout(layout, options);
        } else {
            this.printSystem("Layout not found: " + layoutName);
        }
    }

    private void saveLayout(String layoutName, boolean ask) {
        if (!StringUtil.isNullOrEmpty(layoutName)) {
            boolean save = true;
            if (ask && this.client.settings.mapGet("layouts", layoutName) != null) {
                int result = JOptionPane.showConfirmDialog(this.rootPane, "Overwrite layout " + layoutName + "?", "Save layout", 0);
                boolean bl = save = result == 0;
            }
            if (save) {
                this.client.settings.mapPut("layouts", layoutName, this.channels.getDock().getLayout().toList());
                this.printSystem("Saved current layout as " + layoutName + ".");
            }
        } else {
            this.printSystem("Invalid layout name.");
        }
    }

    private void saveState(Component c) {
        if (c == this) {
            this.client.settings.setBoolean("maximized", this.isMaximized());
        }
    }

    private boolean isMaximized() {
        return (this.getExtendedState() & 6) == 6;
    }

    private void updateConnectionDialog(String channelPreset) {
        this.connectionDialog.setUsername(this.client.settings.getString("username"));
        if (channelPreset != null) {
            this.connectionDialog.setChannel(channelPreset);
        } else {
            this.connectionDialog.setChannel(this.client.settings.getString("channel"));
        }
        String password = this.client.settings.getString("password");
        String token = this.client.settings.getString("token");
        boolean usePassword = this.client.settings.getBoolean("usePassword");
        this.connectionDialog.update(password, token, usePassword);
        this.connectionDialog.setAreChannelsOpen(this.channels.getChannelCount() > 0);
    }

    private void setChannelInfoDialogChannel(Channel channel) {
        this.channelInfoDialog.set(this.getStreamInfo(channel.getStreamName()));
    }

    private void updateChannelInfoDialog(StreamInfo info) {
        if (info == null) {
            this.setChannelInfoDialogChannel(this.channels.getLastActiveChannel());
        } else {
            this.channelInfoDialog.update(info);
        }
    }

    private void updateTokenDialog() {
        String username = this.client.settings.getString("username");
        String token = this.client.settings.getString("token");
        this.tokenDialog.update(username, token);
        this.tokenDialog.setForeignToken(this.client.settings.getBoolean("foreignToken"));
    }

    public void updateUserinfo(final User user) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.updateUserInfoDialog(user);
                MainGui.this.updateModButtons(user);
            }
        });
    }

    public void updateModButtons(User user) {
        SwingUtilities.invokeLater(() -> {
            Channel channel;
            if (user == null) {
                for (Channel chan : this.channels.getChannelsOfType(Channel.Type.CHANNEL)) {
                    chan.updateModButton();
                }
            } else if (user.isLocalUser() && (channel = this.channels.getExistingChannel(user.getChannel())) != null) {
                channel.updateModButton();
            }
        });
    }

    private void updateUserInfoDialog(User user) {
        this.userInfoDialog.update(user, this.client.getUsername());
    }

    private void updateLiveStreamsDialog() {
        this.liveStreamsDialog.setSorting(this.client.settings.getString("liveStreamsSorting"), this.client.settings.getBoolean("liveStreamsSortingFav"));
        this.liveStreamsDialog.setFiltering(this.client.settings.getBoolean("liveStreamsFavsOnly"));
    }

    private void updateFollowerDialogs() {
        this.followerDialog.setCompactMode(this.client.settings.getBoolean("followersCompact"));
        this.subscribersDialog.setCompactMode(this.client.settings.getBoolean("followersCompact"));
        this.followerDialog.setShowRegistered(this.client.settings.getBoolean("followersReg"));
        this.subscribersDialog.setShowRegistered(this.client.settings.getBoolean("followersReg"));
    }

    private void updateHistoryRange() {
        int range = (int)this.client.settings.getLong("historyRange");
        this.channelInfoDialog.setHistoryRange(range);
        this.liveStreamsDialog.setHistoryRange(range);
    }

    private void updateHistoryVerticalZoom() {
        boolean zoom = this.client.settings.getBoolean("historyVerticalZoom");
        this.channelInfoDialog.setHistoryVerticalZoom(zoom);
        this.liveStreamsDialog.setHistoryVerticalZoom(zoom);
    }

    private void openTokenDialog() {
        this.updateTokenDialog();
        this.updateTokenScopes();
        if (this.connectionDialog.isVisible()) {
            this.tokenDialog.setLocationRelativeTo(this.connectionDialog);
        } else {
            this.tokenDialog.setLocationRelativeTo(this);
        }
        this.tokenDialog.setVisible(true);
    }

    public void addStreamInfo(final StreamInfo streamInfo) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.liveStreamsDialog.addStream(streamInfo);
            }
        });
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public StatusHistory getStatusHistory() {
        return this.client.statusHistory;
    }

    public boolean getSaveStatusHistorySetting() {
        return this.client.settings.getBoolean("saveStatusHistory");
    }

    public String replaceEmojiCodes(String input) {
        if (this.client.settings.getBoolean("emojiReplace")) {
            return this.emoticons.emojiReplace(input);
        }
        return input;
    }

    public void anonCustomCommand(Room room, CustomCommand command, Parameters parameters) {
        this.client.anonCustomCommand(room, command, parameters);
    }

    public LinkLabelListener getLinkLabelListener() {
        return this.linkLabelListener;
    }

    public void clearHistory() {
        this.client.channelFavorites.clearHistory();
    }

    public void updateRoom(Room room) {
        SwingUtilities.invokeLater(() -> this.channels.updateRoom(room));
    }

    public UserListener getUserListener() {
        return this.userListener;
    }

    public List<UsercolorItem> getUsercolorData() {
        return this.client.usercolorManager.getData();
    }

    public void setUsercolorData(List<UsercolorItem> data) {
        this.client.usercolorManager.setData(data);
    }

    public List<MsgColorItem> getMsgColorData() {
        return this.msgColorManager.getData();
    }

    public void setMsgColorData(List<MsgColorItem> data) {
        this.msgColorManager.setData(data);
    }

    public List<Usericon> getUsericonData() {
        return this.client.usericonManager.getCustomData();
    }

    public List<Usericon> getHiddenBadgesData() {
        return this.client.usericonManager.getHiddenBadgesData();
    }

    public Set<String> getTwitchBadgeTypes() {
        return this.client.usericonManager.getTwitchBadgeTypes();
    }

    public void setUsericonData(List<Usericon> data) {
        this.client.usericonManager.setCustomData(data);
    }

    public void setHiddenBadgesData(List<Usericon> data) {
        this.client.usericonManager.setHiddenBadgesData(data);
    }

    public List<Notification> getNotificationData() {
        return this.notificationManager.getData();
    }

    public void setNotificationData(List<Notification> data) {
        this.notificationManager.setData(data);
    }

    public void addGuiCommands() {
        this.client.commands.addEdt("settings", p -> this.getSettingsDialog(s -> s.showSettings()), new String[0]);
        this.client.commands.addEdt("customEmotes", p -> this.printLine(this.emoticons.getCustomEmotesInfo()), new String[0]);
        this.client.commands.addEdt("reloadCustomEmotes", p -> {
            this.printLine("Reloading custom emotes from file..");
            this.emoticons.loadCustomEmotes();
            this.printLine(this.emoticons.getCustomEmotesInfo());
        }, new String[0]);
        this.client.commands.addEdt("livestreams", p -> this.openLiveStreamsDialog(), new String[0]);
        this.client.commands.addEdt("channelAdmin", p -> this.openChannelAdminDialog(), new String[0]);
        this.client.commands.addEdt("channelInfo", p -> this.openChannelInfoDialog(), new String[0]);
        this.client.commands.addEdt("userinfo", p -> {
            String channel = p.getChannel();
            String parameter = StringUtil.trim(p.getArgs());
            if (StringUtil.isNullOrEmpty(parameter)) {
                parameter = this.client.settings.getString("username");
            }
            String[] split = parameter.split(" ");
            String username = split[0];
            if (split.length > 1) {
                channel = Helper.toChannel(split[1]);
            }
            if (!Helper.isValidChannelStrict(channel)) {
                this.printSystem("Invalid channel: " + channel);
            } else if (!Helper.isValidStream(username)) {
                this.printSystem("Invalid username: " + username);
            } else {
                User user = this.client.getUser(channel, username);
                this.openUserInfoDialog(user, p.getParameters().get("msg-id"), null);
            }
        }, new String[0]);
        this.client.commands.addEdt("userinfoRecent", p -> {
            User user = RecentlyAffectedUsers.poll(p.getChannel());
            if (user == null) {
                this.printSystem(p.getRoom(), "No recently affected user found");
            } else {
                this.openUserInfoDialog(user, p.getParameters().get("msg-id"), null);
            }
        }, new String[0]);
        this.client.commands.addEdt("search", p -> this.openSearchDialog(), new String[0]);
        this.client.commands.addEdt("insert", p -> this.insert(p.getRoom(), p.getArgs(), false), new String[0]);
        this.client.commands.addEdt("insertWord", p -> this.insert(p.getRoom(), p.getArgs(), true), new String[0]);
        this.client.commands.addEdt("insert2", "[-options] <text>", p -> {
            Commands.CommandParsedArgs args = p.parsedArgs(1, 1);
            if (args == null) {
                this.printLine(p.getCommand().getUsage());
            } else {
                this.insert(p.getRoom(), args.get(0), args.options);
            }
        }, new String[0]);
        this.client.commands.addEdt("openUrl", p -> {
            if (!UrlOpener.openUrl(p.getArgs())) {
                this.printLine("Failed to open URL (none specified or invalid).");
            }
        }, new String[0]);
        this.client.commands.addEdt("openUrlPrompt", p -> {
            if (!UrlOpener.openUrlPrompt(this.getActiveWindow(), p.getArgs(), true)) {
                this.printLine("Failed to open URL (none specified or invalid).");
            }
        }, new String[0]);
        this.client.commands.addEdt("openFile", p -> MiscUtil.openFile(p.getArgs(), (Component)this.getActiveWindow()), new String[0]);
        this.client.commands.addEdt("openFilePrompt", p -> MiscUtil.openFilePrompt(p.getArgs(), this.getActiveWindow()), new String[0]);
        this.client.commands.addEdt("openFollowers", p -> this.openFollowerDialog(), new String[0]);
        this.client.commands.addEdt("openSubscribers", p -> this.openSubscriberDialog(), new String[0]);
        this.client.commands.addEdt("openRules", p -> {}, new String[0]);
        this.client.commands.addEdt("openStreamChat", p -> this.openStreamChat(), new String[0]);
        this.client.commands.addEdt("clearStreamChat", p -> this.streamChat.clear(), new String[0]);
        this.client.commands.addEdt("streamChatTest", p -> {
            String message = "A bit longer chat message with emotes and stuff FrankerZ ZreknarF MiniK (" + (int)(Math.random() * 10.0) + ")";
            if (p.hasArgs()) {
                message = p.getArgs();
            }
            UserMessage m = new UserMessage(this.client.getSpecialUser(), message, null, null, 0, null, null, null, MsgTags.EMPTY);
            this.streamChat.printMessage(m);
        }, new String[0]);
        this.client.commands.addEdt("livestreamer", p -> {
            String stream = null;
            String quality = null;
            String parameter = StringUtil.trim(p.getArgs());
            if (parameter != null && !parameter.isEmpty()) {
                String[] split = parameter.split(" ");
                stream = split[0];
                if (stream.equals("$active") && (stream = this.channels.getActiveChannel().getStreamName()) == null) {
                    this.printLine("Streamlink: No channel open.");
                    return;
                }
                if (split.length > 1) {
                    quality = split[1];
                }
            }
            this.printLine("Streamlink: Opening stream..");
            this.livestreamerDialog.open(stream, quality);
        }, new String[0]);
        this.client.commands.addEdt("help", p -> this.openHelp(null), new String[0]);
        this.client.commands.addEdt("setStreamChatSize", p -> {
            Dimension size = Helper.getDimensionFromParameter(p.getArgs());
            if (size != null) {
                this.setStreamChatSize(size.width, size.height);
                this.printSystem("Set StreamChat size to " + size.width + "x" + size.height);
            } else {
                this.printSystem("Invalid parameters.");
            }
        }, new String[0]);
        this.client.commands.addEdt("getStreamChatSize", p -> {
            Dimension d = this.streamChat.getSize();
            this.printSystem("StreamChat size: " + d.width + "x" + d.height);
        }, new String[0]);
        this.client.commands.addEdt("setSize", p -> {
            Dimension size = Helper.getDimensionFromParameter(p.getArgs());
            if (size != null) {
                this.setSize(size);
                this.printSystem(String.format("Set Window size to %dx%d", size.width, size.height));
            } else {
                this.printSystem("Invalid parameters.");
            }
        }, new String[0]);
        this.client.commands.addEdt("popoutChannel", p -> this.channels.popout(this.channels.getActiveContent(), false), new String[0]);
        this.client.commands.addEdt("popoutChannelWindow", p -> this.channels.popout(this.channels.getActiveContent(), true), new String[0]);
        this.client.commands.addEdt("layouts", p -> {
            if (p.hasArgs()) {
                String args = p.getArgs().trim();
                String command = null;
                String layoutName = null;
                int options = -1;
                String[] split = args.split(" ", 2);
                if (split.length == 2) {
                    command = split[0];
                    if (split[1].startsWith("-") && command.equals("load")) {
                        String[] optionsSplit = split[1].split(" ");
                        if (optionsSplit.length == 2) {
                            if (!optionsSplit[0].equals("--")) {
                                options = Channels.makeLoadLayoutOptions(optionsSplit[0].contains("c"), optionsSplit[0].contains("l"), optionsSplit[0].contains("m"));
                            }
                            layoutName = optionsSplit[1];
                        }
                    } else {
                        layoutName = split[1];
                    }
                }
                if (command == null || layoutName == null) {
                    this.printSystem("Invalid parameters.");
                } else {
                    switch (command) {
                        case "add": {
                            this.addLayout(layoutName);
                            break;
                        }
                        case "save": {
                            this.saveLayout(layoutName, false);
                            break;
                        }
                        case "load": {
                            this.loadLayout(layoutName, options);
                            break;
                        }
                        case "remove": {
                            this.removeLayout(layoutName, false);
                        }
                    }
                }
            }
        }, new String[0]);
    }

    public void insert(String text, boolean spaces) {
        this.insert(this.channels.getLastActiveChannel().getRoom(), text, spaces, false);
    }

    public void insert(String text, boolean spaces, boolean focus) {
        this.insert(this.channels.getLastActiveChannel().getRoom(), text, spaces, focus);
    }

    public void insert(Room room, String text, boolean spaces) {
        this.insert(room, text, spaces, false);
    }

    public void insert(Room room, String text, boolean spaces, boolean focus) {
        String options = spaces ? "s" : "";
        options = options + (focus ? "f" : "");
        this.insert(room, text, options);
    }

    public void insert(Room room, String text, String options) {
        SwingUtilities.invokeLater(() -> {
            if (text != null) {
                Channel chan = options.contains("c") ? this.channels.getLastActiveChannel() : this.channels.getChannel(room);
                chan.insertText(text, options);
                if (options.contains("f")) {
                    chan.requestFocus();
                    chan.getInput().requestFocusInWindow();
                }
            }
        });
    }

    private void openLiveStreamsDialog() {
        this.windowStateManager.setWindowPosition(this.liveStreamsDialog);
        this.liveStreamsDialog.setAlwaysOnTop(this.client.settings.getBoolean("ontop"));
        this.liveStreamsDialog.setState(0);
        this.liveStreamsDialog.setVisible(true);
    }

    private void toggleLiveStreamsDialog() {
        if (this.liveStreamsDialog.isVisible()) {
            this.liveStreamsDialog.setVisible(false);
        } else {
            this.openLiveStreamsDialog();
        }
    }

    public void openUserInfoDialog(User user, String msgId, String autoModMsgId) {
        this.openUserInfoDialog(user, msgId, autoModMsgId, false);
    }

    public void openUserInfoDialog(User user, String msgId, String autoModMsgId, boolean keepPosition) {
        this.windowStateManager.setWindowPosition(this.userInfoDialog.getDummyWindow(), this.getActiveWindow());
        this.userInfoDialog.show(this.getActiveWindow(), user, msgId, autoModMsgId, this.client.getUsername(), keepPosition);
    }

    private void openChannelInfoDialog() {
        this.windowStateManager.setWindowPosition(this.channelInfoDialog, this.getActiveWindow());
        this.channelInfoDialog.setVisible(true);
    }

    private void toggleChannelInfoDialog() {
        if (!this.closeDialog(this.channelInfoDialog)) {
            this.openChannelInfoDialog();
        }
    }

    private boolean closeDialog(JDialog dialog) {
        if (dialog.isVisible()) {
            dialog.setVisible(false);
            return true;
        }
        return false;
    }

    private void openChannelAdminDialog() {
        this.openChannelAdminDialog(this.channels.getActiveChannel().getStreamName());
    }

    private void openChannelAdminDialog(String stream) {
        this.windowStateManager.setWindowPosition(this.adminDialog, this.getActiveWindow());
        this.updateTokenScopes();
        if (stream == null) {
            stream = this.client.settings.getString("username");
        }
        this.adminDialog.open(stream);
    }

    private void toggleChannelAdminDialog() {
        if (!this.closeDialog(this.adminDialog)) {
            this.openChannelAdminDialog();
        }
    }

    private void openEventLog(int tab) {
        this.windowStateManager.setWindowPosition(this.eventLog);
        this.eventLog.setVisible(true);
        if (tab > -1) {
            this.eventLog.setTab(tab);
        }
    }

    private void toggleEventLog() {
        if (!this.closeDialog(this.eventLog)) {
            this.openEventLog(-1);
        }
    }

    public void setSystemEventCount(int count) {
        this.menu.setSystemEventCount(count);
    }

    private void openHelp(String ref) {
        this.openHelp(null, ref, false);
    }

    public void openHelp(String page, String ref) {
        this.openHelp(page, ref, false);
    }

    public void openHelp(String page, String ref, boolean keepPage) {
        if (!this.aboutDialog.isVisible()) {
            this.aboutDialog.setLocationRelativeTo(this);
        }
        if (!keepPage) {
            this.aboutDialog.open(page, ref);
        }
        this.aboutDialog.setAlwaysOnTop(this.client.settings.getBoolean("ontop"));
        this.aboutDialog.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.aboutDialog.toFront();
        this.aboutDialog.setState(0);
        this.aboutDialog.setVisible(true);
    }

    private void toggleHelp() {
        if (this.aboutDialog.isVisible()) {
            this.aboutDialog.setVisible(false);
        } else {
            this.openHelp(null, null, true);
        }
    }

    public void openReleaseInfo() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainGui.this.openHelp("help-releases.html", "latest");
                    }
                });
            }
        });
    }

    protected void openSearchDialog() {
        SearchDialog.showSearchDialog(this.channels.getActiveChannel(), this, this.getActiveWindow());
    }

    private void openEmotesDialog() {
        this.openEmotesDialog(this.channels.getLastActiveChannel().getStreamName());
    }

    private void openEmotesDialog(String stream) {
        this.windowStateManager.setWindowPosition(this.emotesDialog, this.getActiveWindow());
        this.emotesDialog.showDialog(this.client.getEmotesetsByChannel(Helper.toChannel(stream)), stream);
        this.channels.setInitialFocus();
    }

    private void openEmotesDialogChannelEmotes(String channel) {
        this.client.requestChannelEmotes(channel);
        this.openEmotesDialog();
        this.emotesDialog.setTempStream(channel);
        this.emotesDialog.showChannelEmotes();
    }

    private void openEmotesDialogEmoteDetails(Emoticon emote) {
        this.openEmotesDialog();
        this.emotesDialog.showEmoteDetails(emote);
    }

    protected void toggleEmotesDialog() {
        if (!this.closeDialog(this.emotesDialog)) {
            this.openEmotesDialog();
        }
    }

    private void openFollowerDialog() {
        this.windowStateManager.setWindowPosition(this.followerDialog);
        String stream = this.channels.getLastActiveChannel().getStreamName();
        if (stream == null || stream.isEmpty()) {
            stream = this.client.settings.getString("username");
        }
        if (stream != null && !stream.isEmpty()) {
            this.followerDialog.showDialog(stream);
        }
    }

    private void toggleFollowerDialog() {
        if (!this.closeDialog(this.followerDialog)) {
            this.openFollowerDialog();
        }
    }

    private void openSubscriberDialog() {
        this.windowStateManager.setWindowPosition(this.subscribersDialog);
        String stream = this.client.settings.getString("username");
        if (stream != null && !stream.isEmpty()) {
            this.subscribersDialog.showDialog(stream);
        }
    }

    private void toggleSubscriberDialog() {
        if (!this.closeDialog(this.subscribersDialog)) {
            this.openSubscriberDialog();
        }
    }

    private void openModerationLog() {
        this.windowStateManager.setWindowPosition(this.moderationLog);
        this.moderationLog.showDialog();
    }

    private void toggleModerationLog() {
        if (!this.closeDialog(this.moderationLog)) {
            this.openModerationLog();
        }
    }

    private void openAutoModDialog() {
        this.windowStateManager.setWindowPosition(this.autoModDialog);
        this.autoModDialog.showDialog();
    }

    private void toggleAutoModDialog() {
        if (!this.closeDialog(this.autoModDialog)) {
            this.openAutoModDialog();
        }
    }

    private void openUpdateDialog() {
        this.updateDialog.setLocationRelativeTo(this);
        this.updateDialog.showDialog();
    }

    private void openFavoritesDialogFromConnectionDialog(String channel) {
        Set<String> channels = this.chooseFavorites(this, channel);
        if (!channels.isEmpty()) {
            this.connectionDialog.setChannel(Helper.buildStreamsString(channels));
        }
    }

    public Set<String> chooseFavorites(Component owner, String channel) {
        this.favoritesDialog.setLocationRelativeTo(owner);
        int result = this.favoritesDialog.showDialog(channel);
        if (result == 1) {
            return this.favoritesDialog.getChannels();
        }
        return new HashSet<String>();
    }

    private void toggleFavoritesDialog() {
        if (this.favoritesDialog.isVisible()) {
            this.favoritesDialog.setVisible(false);
        } else {
            this.openFavoritesDialogToJoin("");
        }
    }

    private void openFavoritesDialogToJoin(String channel) {
        this.favoritesDialog.setLocationRelativeTo(this);
        int result = this.favoritesDialog.showDialog(channel);
        if (result == 1) {
            Set<String> selectedChannels = this.favoritesDialog.getChannels();
            this.client.joinChannels(selectedChannels);
        }
    }

    private void openJoinDialog() {
        this.joinDialog.setLocationRelativeTo(this);
        Set<String> chans = this.joinDialog.showDialog();
        this.client.joinChannels(chans);
    }

    private void openHighlightedMessages(boolean switchTo) {
        this.windowStateManager.setWindowPosition(this.highlightedMessages);
        this.highlightedMessages.setVisible(true, switchTo);
    }

    private void toggleHighlightedMessages() {
        if (!this.closeDialog(this.highlightedMessages)) {
            this.openHighlightedMessages(true);
        }
    }

    private void openIgnoredMessages(boolean switchTo) {
        this.windowStateManager.setWindowPosition(this.ignoredMessages);
        this.ignoredMessages.setVisible(true, switchTo);
    }

    private void toggleIgnoredMessages() {
        if (!this.closeDialog(this.ignoredMessages)) {
            this.openIgnoredMessages(true);
        }
    }

    private void openAddressbook(String name) {
        if (!this.addressbookDialog.isVisible()) {
            this.windowStateManager.setWindowPosition(this.addressbookDialog);
        }
        this.addressbookDialog.showDialog(name);
    }

    private void toggleAddressbook() {
        if (!this.closeDialog(this.addressbookDialog)) {
            this.openAddressbook(null);
        }
    }

    private void openSrlRaces() {
        this.srl.openRaceList();
    }

    public void removeChannel(final String channel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.channels.removeChannel(channel);
                MainGui.this.state.update();
            }
        });
    }

    public void switchToChannel(final String channel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.channels.switchToChannel(channel);
            }
        });
    }

    public void userJoined(final User user) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.notificationManager.userJoined(user);
            }
        });
    }

    public void userLeft(final User user) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.notificationManager.userLeft(user);
            }
        });
    }

    public void newFollowers(FollowerInfo info) {
        SwingUtilities.invokeLater(() -> this.notificationManager.newFollowers(info));
    }

    public void setChannelNewStatus(String ownerChannel, String newStatus) {
        SwingUtilities.invokeLater(() -> this.channels.setChannelNewStatus(ownerChannel));
    }

    public void statusNotification(final String channel, final StreamInfo info) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.notificationManager.streamInfoChanged(channel, info);
            }
        });
    }

    public void triggerCommandNotification(String channel, String title, String text, Highlighter.HighlightItem fakeItem) {
        GuiUtil.edt(() -> this.notificationManager.commandNotification(channel, title, text, fakeItem));
    }

    public void showNotification(String title, String message, Color foreground, Color background, NotificationManager.NotificationWindowData data) {
        long setting = this.client.settings.getLong("nType");
        if (setting == 0L) {
            this.notificationWindowManager.showMessage(title, message, foreground, background, data);
        } else if (setting == 1L) {
            this.trayIcon.displayInfo(title, message);
        } else if (setting == 2L) {
            GuiUtil.showCommandNotification(this.client.settings.getString("nCommand"), title, message, data.channel);
        }
        this.eventLog.add(new Event(Event.Type.NOTIFICATION, null, title, message, foreground, background));
    }

    public void showTestNotification(final String channel, final String title, final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainGui.this.client.settings.getString("username").equalsIgnoreCase("joshimuz")) {
                    MainGui.this.showNotification("[Test] It works!", "Now you have your notifications Josh.. Kappa", Color.BLACK, Color.WHITE, new NotificationManager.NotificationWindowData(null, channel));
                } else if (title != null && text != null) {
                    MainGui.this.showNotification(title, text, Color.BLACK, Color.WHITE, null);
                } else if (StringUtil.isNullOrEmpty(channel)) {
                    MainGui.this.showNotification("[Test] It works!", "This is where the text goes.", Color.BLACK, Color.WHITE, null);
                } else {
                    MainGui.this.showNotification("[Status] " + Helper.toValidChannel(channel), "Test Notification (this would pop up when a stream status changes)", Color.BLACK, Color.WHITE, new NotificationManager.NotificationWindowData(null, channel));
                }
            }
        });
    }

    public boolean isAppActive() {
        for (Window frame : Window.getWindows()) {
            if (!frame.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean isChanActive(String channel) {
        return this.channels.getLastActiveChannel().getChannel().equals(channel);
    }

    public Window getActiveWindow() {
        for (Window frame : Window.getWindows()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return this;
    }

    public void printMessage(User user, String text, boolean action) {
        this.printMessage(user, text, action, MsgTags.EMPTY);
    }

    public void printMessage(User user, final String text2, boolean action, MsgTags tags0) {
        this.client.resolveSourceData(user, tags0, tags1 -> SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ MsgTags val$tags1;
            final /* synthetic */ User val$user;
            final /* synthetic */ boolean val$action;
            {
                this.val$tags1 = msgTags;
                this.val$user = user;
                this.val$action = bl;
            }

            @Override
            public void run() {
                boolean allowLog;
                boolean ignored;
                Channel chan;
                boolean decodeZWF = MainGui.this.client.settings.getLong("emojiZWJ") > 0L;
                String text = decodeZWF ? EmojiUtil.decodeZWJ(text2) : text2;
                MsgTags tags = this.val$tags1;
                String channel = this.val$user.getChannel();
                boolean whisper = false;
                int bitsAmount = tags.getBits();
                User localUser = MainGui.this.client.getLocalUser(channel);
                int bitsForEmotes = bitsAmount;
                if (MainGui.this.client.settings.getString("cheersType").equals("none")) {
                    bitsForEmotes = 0;
                }
                if (channel.equals("$[whisper]")) {
                    int whisperSetting = (int)MainGui.this.client.settings.getLong("whisperDisplayMode");
                    chan = whisperSetting == 1 ? MainGui.this.channels.getChannel(MainGui.this.client.roomManager.getRoom(channel)) : (whisperSetting == 2 ? (!MainGui.this.userIgnored(this.val$user, true) ? MainGui.this.channels.getChannel(MainGui.this.client.roomManager.getRoom("$" + this.val$user.getName())) : MainGui.this.channels.getActiveChannel()) : MainGui.this.channels.getActiveChannel());
                    whisper = true;
                } else {
                    chan = MainGui.this.channels.getChannel(this.val$user.getRoom());
                }
                channel = chan.getChannel();
                tags = MainGui.this.repeatMsg.check(this.val$user, localUser, text, tags);
                boolean isOwnMessage = MainGui.this.client.isOwnUsername(this.val$user.getName()) || whisper && this.val$action;
                boolean ignoredUser = MainGui.this.userIgnored(this.val$user, whisper) && !isOwnMessage;
                boolean bl = ignored = MainGui.this.checkMsg(MainGui.this.ignoreList, "ignore", text, -2, -2, this.val$user, localUser, tags, isOwnMessage, false) || ignoredUser;
                if (!HistoryUtil.checkAllowMatch(tags, "Ignore", MainGui.this.ignoreList.getLastMatchItem(), MainGui.this.client.settings)) {
                    ignored = false;
                    ignoredUser = false;
                }
                boolean highlighted = false;
                List<Highlighter.Match> highlightMatches = null;
                if ((MainGui.this.client.settings.getBoolean("highlightIgnored") || MainGui.this.client.settings.getBoolean("highlightOverrideIgnored") || MainGui.this.highlighter.hasOverrideIgnored() || !ignored) && !MainGui.this.client.settings.listContains("noHighlightUsers", this.val$user.getName())) {
                    boolean rejectIgnoredWithoutPrefix = MainGui.this.client.settings.getBoolean("highlightOverrideIgnored") || MainGui.this.client.settings.getBoolean("highlightIgnored") ? false : ignored;
                    highlighted = MainGui.this.checkMsg(MainGui.this.highlighter, "highlight", text, -2, -2, this.val$user, localUser, tags, isOwnMessage, rejectIgnoredWithoutPrefix);
                    if (!HistoryUtil.checkAllowMatch(tags, "Highlight", MainGui.this.highlighter.getLastMatchItem(), MainGui.this.client.settings)) {
                        highlighted = false;
                    }
                    if (highlighted) {
                        if (MainGui.this.client.settings.getBoolean("highlightOverrideIgnored") || MainGui.this.highlighter.getLastMatchItem().overrideIgnored()) {
                            ignored = false;
                        }
                        tags = MsgTags.addTag(tags, "chatty-highlighted", "true");
                    }
                }
                boolean bl2 = allowLog = !tags.isHistoricMsg();
                if ((!ignored || MainGui.this.client.settings.getBoolean("logIgnored")) && allowLog) {
                    MainGui.this.client.chatLog.bits(chan.getFilename(), this.val$user, bitsAmount);
                    MainGui.this.client.chatLog.message(chan.getFilename(), this.val$user, text, this.val$action, null);
                }
                Emoticons.TagEmotes tagEmotes = Emoticons.parseEmotesTag(tags.getRawEmotes());
                if (highlighted) {
                    highlightMatches = MainGui.this.highlighter.getLastTextMatches();
                    if (!MainGui.this.highlighter.getLastMatchNoNotification()) {
                        MainGui.this.channels.setChannelHighlighted(chan);
                    } else {
                        MainGui.this.channels.setChannelNewMessage(chan);
                    }
                    MainGui.this.notificationManager.highlight(this.val$user, localUser, text, tags, isOwnMessage, whisper, bitsAmount > 0, MainGui.this.highlighter.getLastMatchItem());
                    TextToSpeech.get(MainGui.this.client.settings).message(this.val$user, text, tags, isOwnMessage);
                } else if (!ignored) {
                    if (whisper) {
                        MainGui.this.notificationManager.whisper(this.val$user, localUser, text, isOwnMessage);
                    } else {
                        MainGui.this.notificationManager.message(this.val$user, localUser, text, tags, isOwnMessage, bitsAmount > 0);
                        TextToSpeech.get(MainGui.this.client.settings).message(this.val$user, text, tags, isOwnMessage);
                    }
                    if (!isOwnMessage) {
                        MainGui.this.channels.setChannelNewMessage(chan);
                    }
                }
                RoutingTargets routingTargets = new RoutingTargets();
                if (ignored) {
                    List<Highlighter.Match> ignoreMatches = null;
                    List<Highlighter.HighlightItem> ignoreSource = null;
                    if (!ignoredUser) {
                        ignoreMatches = MainGui.this.ignoreList.getLastTextMatches();
                        ignoreSource = MainGui.this.ignoreList.getLastMatchItems();
                        routingTargets.add(MainGui.this.ignoreList.getLastMatchItem());
                        UserMessage message = new UserMessage(this.val$user, text, tagEmotes, null, bitsForEmotes, ignoreMatches, null, null, tags);
                        message.whisper = whisper;
                        message.ignoreSource = ignoreSource;
                        MainGui.this.routingManager.addUserMessage(routingTargets, message, localUser);
                    }
                    if (ignoredUser || !MainGui.this.ignoreList.getLastMatchItem().hide()) {
                        MainGui.this.ignoredMessages.addMessage(channel, this.val$user, text, this.val$action, tagEmotes, bitsForEmotes, whisper, ignoreMatches, ignoreSource, tags);
                        MainGui.this.ignoredMessagesHelper.ignoredMessage(channel);
                    }
                    if ((ignoredUser || !MainGui.this.ignoreList.getLastMatchItem().noLog()) && allowLog) {
                        MainGui.this.client.chatLog.message("ignored", this.val$user, text, this.val$action, channel);
                    }
                }
                long ignoreMode = MainGui.this.client.settings.getLong("ignoreMode");
                if (ignored && (ignoreMode <= 1L || !MainGui.this.showIgnoredInfo())) {
                    if (isOwnMessage && MainGui.this.channels.isChannel(channel)) {
                        MainGui.this.printInfo(chan, InfoMessage.createInfo("Own message ignored."));
                    }
                } else {
                    boolean hlByPoints;
                    boolean hasReplacements = MainGui.this.checkMsg(MainGui.this.filter, "filter", text, -2, -2, this.val$user, localUser, tags, isOwnMessage, false);
                    UserMessage message = new UserMessage(this.val$user, text, tagEmotes, tags.getId(), bitsForEmotes, highlightMatches, hasReplacements ? MainGui.this.filter.getLastTextMatches() : null, hasReplacements ? MainGui.this.filter.getLastReplacement() : null, tags);
                    message.localUser = localUser;
                    if (tags.isHistoricMsg()) {
                        message.historicTimeStamp = tags.getHistoricTimeStamp();
                    }
                    boolean bl3 = hlByPoints = tags.isHighlightedMessage() && MainGui.this.client.settings.getBoolean("highlightByPoints");
                    if (highlighted) {
                        message.color = MainGui.this.highlighter.getLastMatchColor();
                        message.backgroundColor = MainGui.this.highlighter.getLastMatchBackgroundColor();
                        message.colorSource = MainGui.this.highlighter.getColorSource();
                        message.highlightSource = MainGui.this.highlighter.getLastMatchItems();
                        routingTargets.add(MainGui.this.highlighter.getLastMatchItem());
                    }
                    if (!highlighted && !hlByPoints || MainGui.this.client.settings.getBoolean("msgColorsPrefer")) {
                        MsgColorItem colorItem = MainGui.this.msgColorManager.getMsgColor(this.val$user, localUser, text, -2, -2, tags);
                        if (!HistoryUtil.checkAllowMatch(tags, "msgColors", colorItem.getMatcher(), MainGui.this.client.settings)) {
                            colorItem = MsgColorManager.EMPTY;
                        }
                        if (!colorItem.isEmpty()) {
                            message.color = colorItem.getForegroundIfEnabled();
                            message.backgroundColor = colorItem.getBackgroundIfEnabled();
                            message.colorSource = colorItem;
                            routingTargets.add(colorItem.getMatcher());
                        }
                    }
                    message.whisper = whisper;
                    message.action = this.val$action;
                    if (highlighted || hlByPoints) {
                        message.highlighted = true;
                    } else if (ignored && ignoreMode == 2L) {
                        message.ignored_compact = true;
                    }
                    chan.printMessage(message);
                    if (highlighted) {
                        if (!MainGui.this.highlighter.getLastMatchItem().hide()) {
                            MainGui.this.highlightedMessages.addMessage(channel, message);
                        }
                        if (!MainGui.this.highlighter.getLastMatchItem().noLog() && allowLog) {
                            MainGui.this.client.chatLog.message("highlighted", this.val$user, text, this.val$action, channel);
                        }
                    }
                    if (MainGui.this.client.settings.listContains("streamChatChannels", channel)) {
                        MainGui.this.streamChat.printMessage(message);
                    }
                    if (!ignored) {
                        MainGui.this.routingManager.addUserMessage(routingTargets, message, localUser);
                    }
                }
                CopyMessages.copyMessage(MainGui.this.client.settings, this.val$user, text, highlighted);
                String hypeChatAmount = tags.getHypeChatAmountText();
                if (hypeChatAmount != null) {
                    this.val$user.addSub(MainGui.this.processMessage(text), tags.getHypeChatInfo(), tags.getId(), tags.getSourceId(), tags.getSourceChannel());
                } else {
                    this.val$user.addMessage(MainGui.this.processMessage(text), this.val$action, tags.getId(), tags.getSourceId(), tags.getSourceChannel(), tags.getHistoricTimeStamp());
                }
                if (highlighted) {
                    this.val$user.setHighlighted();
                }
                MainGui.this.updateUserInfoDialog(this.val$user);
            }
        }));
    }

    public void printSubscriberMessage(User user, String text, String message, MsgTags tags0) {
        this.client.resolveSourceData(user, tags0, tags -> SwingUtilities.invokeLater(() -> {
            SubscriberMessage m = new SubscriberMessage(user, text, message, (MsgTags)tags);
            boolean printed = this.printUsernoticeInternal(m);
            if (printed) {
                this.notificationManager.newSubscriber(user, this.client.getLocalUser(user.getChannel()), text, message);
            }
        }));
    }

    public void printPointsNotice(User user, String text, String message, MsgTags tags, String redemptionId, boolean isUpdate, String status) {
        SwingUtilities.invokeLater(() -> {
            if (isUpdate && redemptionId != null && status != null) {
                this.channels.getChannel(user.getRoom()).printInfoMessage(InfoMessage.createAppend(redemptionId, String.format("(%s)", status)));
            } else {
                UserNotice m = new UserNotice("Points", user, text, message, tags);
                if (redemptionId != null) {
                    m.objectId = redemptionId;
                }
                if (message != null) {
                    Helper.pointsMerge(m, this);
                } else {
                    this.printUsernoticeInternal(m);
                }
            }
        });
    }

    public void printUsernotice(String type, User user, String text, String message, MsgTags tags0) {
        this.client.resolveSourceData(user, tags0, tags -> SwingUtilities.invokeLater(() -> {
            UserNotice m = new UserNotice(type, user, text, message, (MsgTags)tags);
            this.printUsernoticeInternal(m);
        }));
    }

    public void printUsernotice(UserNotice m) {
        GuiUtil.edt(() -> this.printUsernoticeInternal(m));
    }

    private boolean printUsernoticeInternal(UserNotice m) {
        boolean notIgnored = this.printInfo(this.channels.getChannel(m.user.getRoom()), m);
        if (!m.user.getName().isEmpty()) {
            String message = m.attachedMessage != null ? this.processMessage(m.attachedMessage) : "";
            String text = m.infoText;
            if (m instanceof SubscriberMessage) {
                m.user.addSub(message, text, m.tags.getId(), m.tags.getSourceId(), m.tags.getSourceChannel());
            } else {
                m.user.addInfo(message, m.text, m.tags.isSharedMessage(), m.tags.getSourceChannel());
            }
            this.updateUserInfoDialog(m.user);
        }
        return notIgnored;
    }

    private boolean userIgnored(User user, boolean whisper) {
        String setting = whisper ? "ignoredUsersWhisper" : "ignoredUsers";
        return this.client.settings.listContains(setting, user.getName());
    }

    private String processMessage(String text) {
        int mode = (int)this.client.settings.getLong("filterCombiningCharacters");
        return Helper.filterCombiningCharacters(text, "****", mode);
    }

    private boolean checkHighlight(Highlighter.HighlightItem.Type type, String text, int msgStart, int msgEnd, String channel, Addressbook ab, User user, User localUser, MsgTags tags, Highlighter hl, String setting, boolean isOwnMessage, boolean ignored) {
        if (this.client.settings.getBoolean(setting + "Enabled") && (this.client.settings.getBoolean(setting + "OwnText") || !isOwnMessage)) {
            return hl.check(type, text, msgStart, msgEnd, channel, ab, user, localUser, tags, ignored);
        }
        return false;
    }

    private boolean checkMsg(Highlighter hl, String setting, String text, int msgStart, int msgEnd, User user, User localUser, MsgTags tags, boolean isOwnMessage, boolean ignored) {
        return this.checkHighlight(Highlighter.HighlightItem.Type.REGULAR, text, msgStart, msgEnd, null, null, user, localUser, tags, hl, setting, isOwnMessage, ignored);
    }

    private boolean checkInfoMsg(Highlighter hl, String setting, String text, int msgStart, int msgEnd, User user, MsgTags tags, String channel, Addressbook ab, boolean ignored) {
        return this.checkHighlight(Highlighter.HighlightItem.Type.INFO, text, msgStart, msgEnd, channel, ab, user, this.client.getLocalUser(channel), tags, hl, setting, false, ignored);
    }

    protected void ignoredMessagesCount(String channel, String message) {
        if (this.client.settings.getLong("ignoreMode") == 1L && this.showIgnoredInfo() && this.channels.isChannel(channel)) {
            this.channels.getExistingChannel(channel).printLine(message);
        }
    }

    private boolean showIgnoredInfo() {
        return !this.client.settings.getBoolean("ignoreShowNotDialog") || !this.ignoredMessages.isVisible();
    }

    public void userBanned(final User user, final long duration, final String reason, final String id) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.channels.getChannel(user.getRoom()).userBanned(user, duration, reason, id);
                user.addBan(duration, reason, id);
                MainGui.this.updateUserInfoDialog(user);
                if (MainGui.this.client.settings.listContains("streamChatChannels", user.getChannel())) {
                    MainGui.this.streamChat.userBanned(user, duration, reason, id);
                }
                MainGui.this.highlightedMessages.addBan(user, duration, reason, id);
                MainGui.this.ignoredMessages.addBan(user, duration, reason, id);
                MainGui.this.routingManager.addBan(user, duration, reason, id);
            }
        });
    }

    public void msgDeleted(User user, String targetMsgId, String msg) {
        SwingUtilities.invokeLater(() -> {
            this.channels.getChannel(user.getRoom()).userBanned(user, -2L, null, targetMsgId);
            user.addMsgDeleted(targetMsgId, msg);
            this.updateUserInfoDialog(user);
            if (this.client.settings.listContains("streamChatChannels", user.getChannel())) {
                this.streamChat.userBanned(user, -2L, null, targetMsgId);
            }
            this.highlightedMessages.addBan(user, -2L, null, targetMsgId);
            this.ignoredMessages.addBan(user, -2L, null, targetMsgId);
            this.routingManager.addBan(user, -2L, null, targetMsgId);
        });
    }

    public void clearChat() {
        this.clearChat(null);
    }

    public void clearChat(final Room room) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Channel panel;
                if (room == null) {
                    panel = MainGui.this.channels.getActiveChannel();
                } else {
                    panel = MainGui.this.channels.getChannel(room);
                    if (MainGui.this.client.settings.listContains("streamChatChannels", room.getChannel())) {
                        MainGui.this.streamChat.clear();
                    }
                }
                if (panel != null) {
                    panel.clearChat();
                }
            }
        });
    }

    public void testHotkey() {
        GuiUtil.edt(() -> {
            Channel panel = this.channels.getLastActiveChannel();
            if (panel != null) {
                panel.selectPreviousUser();
            }
        });
    }

    public void joinScheduled(String channel) {
        GuiUtil.edt(() -> this.channels.joinScheduled(channel));
    }

    public void printLine(String line) {
        GuiUtil.edt(() -> {
            Channel panel = this.channels.getLastActiveChannel();
            if (panel != null) {
                this.printInfo(panel, InfoMessage.createInfo(line));
            }
        });
    }

    public void addToLine(Room room, Object objectId, String text) {
        GuiUtil.edt(() -> this.channels.getChannel(room).printInfoMessage(InfoMessage.createAppend(objectId, text)));
    }

    public void printSystem(String line) {
        this.printSystem(null, line);
    }

    public void printSystem(Room room, String line) {
        GuiUtil.edt(() -> {
            Channel channel = room == null || room == Room.EMPTY ? this.channels.getActiveChannel() : this.channels.getChannel(room);
            if (channel != null) {
                this.printInfo(channel, InfoMessage.createSystem(line));
            }
        });
    }

    public void printSystemMultline(Room room, String text) {
        GuiUtil.edt(() -> {
            String[] lines;
            for (String line : lines = text.split("\n")) {
                this.printSystem(room, line);
            }
        });
    }

    public Object printLine(Room room, String line) {
        return this.printInfo(room, line, null);
    }

    public Object printInfo(Room room, String line, MsgTags tags) {
        Object objectId = new Object();
        GuiUtil.edt(() -> {
            if (room == null || room == Room.EMPTY) {
                this.printLine(line);
            } else {
                InfoMessage m = InfoMessage.createInfo(line, tags);
                m.objectId = objectId;
                this.printInfo(this.channels.getChannel(room), m);
            }
        });
        return objectId;
    }

    public Object printLineAll(String line) {
        Object objectId = new Object();
        SwingUtilities.invokeLater(() -> {
            for (Channel channel : this.channels.allChannels()) {
                InfoMessage m = InfoMessage.createInfo(line);
                m.objectId = objectId;
                this.printInfo(channel, m);
            }
        });
        return objectId;
    }

    public void printLineAllAppend(String text, Object objectId) {
        GuiUtil.edt(() -> {
            for (Channel channel : this.channels.allChannels()) {
                channel.printInfoMessage(InfoMessage.createAppend(objectId, text));
            }
        });
    }

    public void printLineByOwnerChannel(String channel, String text) {
        SwingUtilities.invokeLater(() -> {
            for (Channel chan : this.channels.getExistingChannelsByOwner(channel)) {
                this.printInfo(chan, InfoMessage.createInfo(text));
            }
        });
    }

    private boolean printInfo(Channel channel, InfoMessage message) {
        boolean ignoreCheck;
        User user = null;
        if (message instanceof UserNotice) {
            user = ((UserNotice)message).user;
        }
        boolean noHighlightUser = user != null && this.client.settings.listContains("noHighlightUsers", user.getName());
        MsgTags tags = message.tags;
        User localUser = this.client.getLocalUser(channel.getChannel());
        RoutingTargets routingTargets = new RoutingTargets();
        boolean ignored = this.checkInfoMsg(this.ignoreList, "ignore", message.text, message.getMsgStart(), message.getMsgEnd(), user, tags, channel.getChannel(), this.client.addressbook, false);
        boolean highlighted = false;
        boolean bl = ignoreCheck = !ignored || this.highlighter.hasOverrideIgnored() || this.client.settings.getBoolean("highlightOverrideIgnored");
        if (ignoreCheck && !message.isHidden() && !noHighlightUser) {
            boolean rejectIgnoredWithoutPrefix = this.client.settings.getBoolean("highlightOverrideIgnored") ? false : ignored;
            highlighted = this.checkInfoMsg(this.highlighter, "highlight", message.text, message.getMsgStart(), message.getMsgEnd(), user, tags, channel.getChannel(), this.client.addressbook, rejectIgnoredWithoutPrefix);
            if (highlighted) {
                if (this.client.settings.getBoolean("highlightOverrideIgnored") || this.highlighter.getLastMatchItem().overrideIgnored()) {
                    ignored = false;
                }
                tags = MsgTags.addTag(tags, "chatty-highlighted", "true");
            }
        }
        if (!ignored) {
            if (!message.isHidden()) {
                MsgColorItem colorItem;
                if (highlighted) {
                    message.highlighted = true;
                    message.highlightMatches = this.highlighter.getLastTextMatches();
                    message.color = this.highlighter.getLastMatchColor();
                    message.bgColor = this.highlighter.getLastMatchBackgroundColor();
                    message.colorSource = this.highlighter.getColorSource();
                    message.highlightSource = this.highlighter.getLastMatchItems();
                    message.localUser = localUser;
                    routingTargets.add(this.highlighter.getLastMatchItem());
                    if (!this.highlighter.getLastMatchNoNotification()) {
                        this.channels.setChannelHighlighted(channel);
                    } else {
                        this.channels.setChannelNewMessage(channel);
                    }
                    this.notificationManager.infoHighlight(channel.getRoom(), message.text, this.highlighter.getLastMatchItem(), localUser);
                } else {
                    this.notificationManager.info(channel.getRoom(), message.text, localUser);
                }
                if (!(highlighted && !this.client.settings.getBoolean("msgColorsPrefer") || (colorItem = this.msgColorManager.getInfoColor(message.text, message.getMsgStart(), message.getMsgEnd(), channel.getChannel(), this.client.addressbook, user, localUser, tags)).isEmpty())) {
                    message.color = colorItem.getForegroundIfEnabled();
                    message.bgColor = colorItem.getBackgroundIfEnabled();
                    message.colorSource = colorItem;
                    routingTargets.add(colorItem.getMatcher());
                }
                if (highlighted) {
                    if (!this.highlighter.getLastMatchItem().hide()) {
                        this.highlightedMessages.addInfoMessage(channel.getChannel(), message);
                    }
                    if (!this.highlighter.getLastMatchItem().noLog()) {
                        this.client.chatLog.info("highlighted", message.text, channel.getChannel());
                    }
                }
            }
            channel.printInfoMessage(message);
            if (channel.getType() == Channel.Type.SPECIAL) {
                this.channels.setChannelNewMessage(channel);
            }
        } else if (!message.isHidden()) {
            routingTargets.add(this.ignoreList.getLastMatchItem());
            if (!this.ignoreList.getLastMatchItem().hide()) {
                this.ignoredMessages.addInfoMessage(channel.getChannel(), message.text, this.ignoreList.getLastTextMatches(), this.ignoreList.getLastMatchItems(), localUser);
            }
            if (!this.ignoreList.getLastMatchItem().noLog()) {
                this.client.chatLog.info("ignored", message.text, channel.getChannel());
            }
        }
        this.routingManager.addInfoMessage(routingTargets, message, user, localUser, channel);
        if (message.isSystemMsg()) {
            this.client.chatLog.system(channel.getFilename(), message.text);
        } else if (!message.text.startsWith("[ModAction]")) {
            this.client.chatLog.info(channel.getFilename(), message.text, null);
        }
        return !ignored;
    }

    public void printCompact(final String type, final User user) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.channels.getChannel(user.getRoom()).printCompact(type, user);
            }
        });
    }

    public boolean search(Channel chan, String searchText) {
        if (chan == null) {
            return false;
        }
        return chan.search(searchText);
    }

    public void resetSearch(Channel chan) {
        SwingUtilities.invokeLater(() -> chan.resetSearch());
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainGui.this.connectionDialog.isVisible()) {
                    JOptionPane.showMessageDialog(MainGui.this.connectionDialog, message);
                } else {
                    MainGui.this.printLine(message);
                }
            }
        });
    }

    public void printDebug(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.debugWindow.printLine(line);
            }
        });
    }

    public void printDebugFFZ(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.debugWindow.printLineFFZ(line);
            }
        });
    }

    public void printDebugPubSub(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.debugWindow.printLinePubSub(line);
            }
        });
    }

    public void printDebugEventSub(String line) {
        SwingUtilities.invokeLater(() -> this.debugWindow.printLineEventSub(line));
    }

    public void printTimerLog(String line) {
        GuiUtil.edt(() -> this.debugWindow.printTimerLog(line));
    }

    public void printModerationAction(final ModActionPayload data, final boolean ownAction) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Collection<Channel> chans;
                MainGui.this.moderationLog.add(data);
                MainGui.this.autoModDialog.addData(data);
                String channel = Helper.toValidChannel(data.stream);
                if (MainGui.this.channels.isChannel(channel)) {
                    Channel chan = MainGui.this.channels.getExistingChannel(channel);
                    if (data.type == ModActionPayload.Type.AUTOMOD_FILTERED && data.action instanceof ModActionPayload.AutoModMessageUpdate) {
                        ModActionPayload.AutoModMessageUpdate update = (ModActionPayload.AutoModMessageUpdate)data.action;
                        String username = update.getUsername();
                        String message = update.getMessage();
                        if (MainGui.this.client.settings.getBoolean("showAutoMod")) {
                            User user = MainGui.this.client.getUser(channel, username);
                            MainGui.this.printInfo(chan, new AutoModMessage(user, message, update.getMsgId()));
                        }
                        MainGui.this.notificationManager.autoModMessage(channel, username, message);
                    }
                }
                if (!(chans = MainGui.this.channels.getExistingChannelsByOwner(channel)).isEmpty() && data.type != ModActionPayload.Type.AUTOMOD_FILTERED && data.type != ModActionPayload.Type.UNMODDED) {
                    boolean showActions = MainGui.this.client.settings.getBoolean("showModActions");
                    boolean showActionsRestrict = MainGui.this.client.settings.getBoolean("showModActionsRestrict");
                    boolean showMessage = !(!showActions || ownAction && !data.action.isIndirectAction() || showActionsRestrict && ModLogInfo.isAssociated(data));
                    boolean showActionby = MainGui.this.client.settings.getBoolean("showActionBy");
                    for (Channel chan : chans) {
                        ModLogInfo infoMessage = new ModLogInfo(chan, data, showActionby, ownAction);
                        infoMessage.setHidden(!showMessage);
                        MainGui.this.printInfo(chan, infoMessage);
                    }
                }
            }
        });
    }

    public void printLowTrustUserInfo(User user, SuspiciousMessagePayload data) {
        String channel = Helper.toValidChannel(data.stream);
        if (this.channels.isChannel(channel)) {
            data.fetchUserInfoForBannedChannels(this.client.api, () -> SwingUtilities.invokeLater(() -> {
                Channel chan = this.channels.getExistingChannel(channel);
                if (data.treatment == SuspiciousMessagePayload.Treatment.RESTRICTED && this.client.settings.getBoolean("showRestrictedMessages")) {
                    MsgTags tags = MsgTags.create("id", data.aboutMessageId, "chatty-is-restricted", "1");
                    this.printMessage(user, data.text, false, tags);
                }
                if (this.client.settings.getBoolean("showLowTrustInfo")) {
                    chan.printLowTrustInfo(user, data);
                }
            }));
        }
    }

    public void printAbandonedModLogInfo(ModLogInfo info) {
        boolean showActions = this.client.settings.getBoolean("showModActions");
        if (showActions && !info.ownAction) {
            this.printInfo(info.chan, InfoMessage.createInfo(info.text));
        }
    }

    public void autoModRequestResult(TwitchApi.AutoModAction action, String msgId, TwitchApi.AutoModActionResult result) {
        SwingUtilities.invokeLater(() -> this.autoModDialog.requestResult(action, msgId, result));
    }

    public void printDebugIrc(final String line) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.debugWindow.printLineIrc(line);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainGui.this.debugWindow.printLineIrc(line);
                }
            });
        }
    }

    public void addUser(User user) {
        SwingUtilities.invokeLater(() -> {
            if (this.shouldUpdateUser(user)) {
                Channel c = this.channels.getChannel(user.getRoom());
                c.addUser(user);
                if (this.channels.getActiveChannel() == c) {
                    this.state.update();
                }
            }
        });
    }

    public void removeUser(User user) {
        SwingUtilities.invokeLater(() -> {
            if (this.shouldUpdateUser(user)) {
                Channel c = this.channels.getChannel(user.getRoom());
                c.removeUser(user);
                if (this.channels.getActiveChannel() == c) {
                    this.state.update();
                }
            }
        });
    }

    public void updateUser(User user) {
        SwingUtilities.invokeLater(() -> {
            if (this.shouldUpdateUser(user)) {
                this.channels.getChannel(user.getRoom()).updateUser(user);
                this.state.update();
            }
        });
    }

    private boolean shouldUpdateUser(User user) {
        return !user.getChannel().equals("$[whisper]") || this.channels.isChannel("$[whisper]");
    }

    public void resortUsers(Room room) {
        SwingUtilities.invokeLater(() -> this.channels.getChannel(room).resortUserlist());
    }

    public void clearUsers(final String channel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (channel != null) {
                    Channel c = MainGui.this.channels.getExistingChannel(channel);
                    if (c != null) {
                        c.clearUsers();
                    }
                } else {
                    for (Channel channel2 : MainGui.this.channels.channels()) {
                        channel2.clearUsers();
                    }
                }
            }
        });
    }

    public User getUser(String channel, String name) {
        return this.client.getUser(channel, name);
    }

    public void reconnect() {
        this.client.commandReconnect();
    }

    public void setUpdateAvailable(String newVersion, GitHub.Releases releases) {
        SwingUtilities.invokeLater(() -> {
            this.menu.setUpdateNotification(true);
            this.updateDialog.setInfo(releases);
            if (releases != null) {
                this.updateDialog.showDialog();
            }
        });
    }

    public void setColor(final String item) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.getSettingsDialog(s -> s.showSettings("editUsercolorItem", item));
            }
        });
    }

    public void setCustomName(final String item) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.getSettingsDialog(s -> s.showSettings("editCustomNameItem", item));
            }
        });
    }

    public void updateChannelInfo(final StreamInfo info) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.updateChannelInfoDialog(info);
            }
        });
    }

    public void updateStreamLive(StreamInfo info) {
        SwingUtilities.invokeLater(() -> this.channels.setStreamLive(info.stream, info.isValidEnough() && info.getOnline()));
    }

    public ChannelState getChannelState(String channel) {
        return this.client.getChannelState(channel);
    }

    public void channelStateUpdated(ChannelState state) {
        SwingUtilities.invokeLater(() -> {
            Channel channel = this.channels.getExistingChannel(state.getChannel());
            if (channel != null) {
                channel.updateModPanel();
            }
        });
    }

    public void updateState(final boolean forced) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.state.update(forced);
            }
        });
    }

    public void startUpdatingState() {
        this.state.update(false);
        Timer timer = new Timer(5000, e -> this.state.update(false));
        timer.setRepeats(true);
        timer.start();
    }

    public void openConnectDialog(final String channelPreset) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.openConnectDialogInternal(channelPreset);
            }
        });
    }

    private void openConnectDialogInternal(String channelPreset) {
        this.updateConnectionDialog(channelPreset);
        this.connectionDialog.setLocationRelativeTo(this);
        this.connectionDialog.setVisible(true);
    }

    private void openStreamChat() {
        this.windowStateManager.setWindowPosition(this.streamChat);
        this.streamChat.setVisible(true);
    }

    private void setStreamChatSize(int width, int height) {
        this.streamChat.setSize(width, height);
    }

    public void updateEmotesDialog(final String stream, final Set<String> emotesets) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.emotesDialog.updateEmotesets(stream, emotesets);
            }
        });
    }

    public void refreshEmotes(String type, String stream) {
        if (type.equals("user")) {
            this.client.api.refreshEmotes();
        } else if (type.equals("channel") && !StringUtil.isNullOrEmpty(stream)) {
            this.client.api.getEmotesByChannelId(stream, null, true);
            if (this.client.settings.getBoolean("ffz")) {
                this.client.frankerFaceZ.requestEmotes(stream, true);
            }
            if (this.client.settings.getBoolean("bttvEmotes")) {
                this.client.bttvEmotes.requestEmotes(stream, true);
            }
            if (this.client.settings.getBoolean("seventv")) {
                this.client.sevenTV.requestEmotes(stream, true);
            }
        } else if (type.equals("globaltwitch")) {
            this.client.api.refreshSets(new HashSet<String>(Arrays.asList("0")));
        } else if (type.equals("globalother")) {
            if (this.client.settings.getBoolean("ffz")) {
                this.client.frankerFaceZ.requestGlobalEmotes(true);
            }
            if (this.client.settings.getBoolean("bttvEmotes")) {
                this.client.bttvEmotes.requestEmotes("$global$", true);
            }
            if (this.client.settings.getBoolean("seventv")) {
                this.client.sevenTV.requestEmotes(null, true);
            }
        }
    }

    public void updateEmoticons(EmoticonUpdate update) {
        SwingUtilities.invokeLater(() -> {
            this.emoticons.updateEmoticons(update);
            this.emotesDialog.update();
            this.autoSetSmilies(update);
            this.emoticons.setLocalEmotesetManager(this.client.emotesetManager);
        });
    }

    private void updateSmilies() {
        GuiUtil.edt(() -> {
            Map<String, Set<Emoticon>> smilies = ChattyMisc.getSmilies();
            if (smilies != null) {
                switch ((int)this.client.settings.getLong("smilies")) {
                    case 1: 
                    case 10: {
                        this.emoticons.setSmilies(smilies.get("robot"));
                        break;
                    }
                    case 2: 
                    case 20: {
                        this.emoticons.setSmilies(smilies.get("glitch"));
                        break;
                    }
                    case 3: 
                    case 30: {
                        this.emoticons.setSmilies(smilies.get("monkey"));
                        break;
                    }
                    default: {
                        this.emoticons.setSmilies(null);
                    }
                }
                this.emotesDialog.update();
            }
        });
    }

    private void autoSetSmilies(EmoticonUpdate update) {
        if (this.client.settings.getLong("smilies") < 10L) {
            return;
        }
        if (update.setsAdded != null) {
            String type = null;
            for (Emoticon emote : update.emotesToAdd) {
                type = ChattyMisc.getTypeByEmoteId(emote.stringId);
                if (type == null) continue;
                LOGGER.info("Set smilies type to " + type + " (by id " + emote.stringId + ")");
                break;
            }
            if (type == null) {
                for (String set : update.setsAdded) {
                    type = ChattyMisc.getTypeByEmoteSet(set);
                    if (type == null) continue;
                    LOGGER.info("Set smilies type to " + type + " (by set " + set + ")");
                    break;
                }
            }
            if (type != null) {
                switch (type) {
                    case "robot": {
                        this.client.settings.setLong("smilies", 10L);
                        break;
                    }
                    case "glitch": {
                        this.client.settings.setLong("smilies", 20L);
                        break;
                    }
                    case "monkey": {
                        this.client.settings.setLong("smilies", 30L);
                    }
                }
            }
        }
    }

    public void setCheerEmotes(final Set<CheerEmoticon> emotes) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.emoticons.setCheerEmotes(emotes);
            }
        });
    }

    public void webserverStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainGui.this.tokenGetDialog.isVisible()) {
                    MainGui.this.tokenGetDialog.ready();
                }
            }
        });
    }

    public void webserverError(final String error) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainGui.this.tokenGetDialog.isVisible()) {
                    MainGui.this.tokenGetDialog.error(error);
                }
            }
        });
    }

    public void webserverTokenReceived(final String token) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.tokenReceived(token);
            }
        });
    }

    private void tokenGetDialogClosed() {
        this.tokenGetDialog.setVisible(false);
        this.client.stopWebserver();
    }

    private void tokenReceived(String token) {
        this.client.settings.setString("token", token);
        this.client.settings.setBoolean("foreignToken", false);
        if (this.tokenGetDialog.isVisible()) {
            this.tokenGetDialog.tokenReceived();
        }
        this.tokenDialog.update("", token);
        this.updateConnectionDialog(null);
        this.verifyToken(token);
    }

    private void verifyToken(String token) {
        this.client.api.verifyToken(token);
        this.tokenDialog.verifyingToken();
    }

    public void tokenVerified(final String token, final TokenInfo tokenInfo) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.tokenVerifiedInternal(token, tokenInfo);
            }
        });
    }

    public void changeToken(final String token) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (token == null || token.isEmpty()) {
                    MainGui.this.printSystem("You have to supply a token.");
                } else if (MainGui.this.manuallyChangedToken != null) {
                    MainGui.this.printSystem("You already have changed the token, please wait..");
                } else if (token.equals(MainGui.this.client.settings.getString("token"))) {
                    MainGui.this.printSystem("The token you entered is already set.");
                } else {
                    MainGui.this.printSystem("Setting new token. Please wait..");
                    MainGui.this.client.settings.setString("username", null);
                    MainGui.this.manuallyChangedToken = token;
                    MainGui.this.tokenReceived(token);
                }
            }
        });
    }

    private void tokenVerifiedInternal(String token, TokenInfo tokenInfo) {
        String result;
        this.client.stopWebserver();
        String currentUsername = this.client.settings.getString("username");
        boolean getNewLogin = this.tokenGetDialog.isVisible();
        boolean showInDialog = this.tokenDialog.isVisible();
        boolean changedTokenResponse = token == null ? this.manuallyChangedToken == null : token.equals(this.manuallyChangedToken);
        boolean valid = false;
        if (tokenInfo == null) {
            result = getNewLogin ? "An error occured completing getting login data." : "An error occured verifying login data.";
        } else if (!tokenInfo.valid) {
            if (getNewLogin) {
                result = "Invalid token received when getting login data. Please try again.";
                this.client.settings.setString("token", "");
            } else if (changedTokenResponse) {
                result = "Invalid token entered. Please try again.";
                this.client.settings.setString("token", "");
            } else {
                result = "Login data invalid. This may only be temporary. If the issue persists, remove login and connect Twitch account again.";
            }
            if (!showInDialog && !changedTokenResponse) {
                this.showTokenWarning();
            }
        } else if (!tokenInfo.hasChatAccess()) {
            result = "No chat access (required) with token.";
        } else {
            valid = true;
            String username = tokenInfo.name;
            this.client.settings.setString("username", username);
            this.client.settings.setString("userid", tokenInfo.userId);
            this.client.settings.setString("token", token);
            this.tokenDialog.update(username, token);
            this.updateConnectionDialog(null);
            result = !currentUsername.isEmpty() && !username.equals(currentUsername) ? "Login verified and ready to connect (replaced '" + currentUsername + "' with '" + username + "')." : "Login verified and ready to connect.";
            if (!"spyiu9jqdnfjtwv6l1xjk5zgt8qb91l".equals(tokenInfo.clientId)) {
                result = result + " ClientID does not match, please generate token through Chatty.";
            }
            this.client.updateLogin();
        }
        if (changedTokenResponse) {
            this.printLine(result);
            this.manuallyChangedToken = null;
        }
        this.setTokenScopes(tokenInfo);
        this.tokenGetDialog.setVisible(false);
        this.tokenDialog.tokenVerified(valid, result);
    }

    private void setTokenScopes(TokenInfo info) {
        if (info == null) {
            return;
        }
        if (info.valid) {
            this.client.settings.putList("scopes", info.scopes);
            AccessChecker.instance().removeWarningsForAvailableScopes();
        } else {
            this.client.settings.listClear("scopes");
        }
        this.updateTokenScopes();
    }

    private void updateTokenScopes() {
        List scopes = this.client.settings.getList("scopes");
        this.tokenDialog.updateAccess(scopes);
        this.adminDialog.updateAccess(scopes.contains(TokenInfo.Scope.EDITOR.scope), scopes.contains(TokenInfo.Scope.EDIT_BROADCAST.scope), scopes.contains(TokenInfo.Scope.COMMERICALS.scope), scopes.contains(TokenInfo.Scope.BLOCKED_READ.scope) && scopes.contains(TokenInfo.Scope.BLOCKED_MANAGE.scope));
    }

    public void showTokenWarning() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String message = "<html><body style='width:400px;'>Login data was determined invalid, which means you may have to request it again before you can connect to chat or do authorized actions (like getting notified about streams you follow, edit stream title..).";
                Object[] options = new String[]{"Close / Configure login", "Just Close"};
                int result = GuiUtil.showNonAutoFocusOptionPane(MainGui.this, "Error", message, 0, -1, options);
                if (result == 0) {
                    MainGui.this.openTokenDialog();
                }
            }
        });
    }

    public void setSubscriberInfo(final FollowerInfo info) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.subscribersDialog.setFollowerInfo(info);
            }
        });
    }

    public void setFollowerInfo(final FollowerInfo info) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.followerDialog.setFollowerInfo(info);
                MainGui.this.userInfoDialog.setFollowerInfo(info);
            }
        });
    }

    public void setFollowInfo(String stream, String user, TwitchApi.RequestResultCode result, Follower follower) {
        SwingUtilities.invokeLater(() -> this.userInfoDialog.setFollowInfo(stream, user, result, follower));
    }

    public void channelStatusReceived(ChannelStatus status, TwitchApi.RequestResultCode result) {
        SwingUtilities.invokeLater(() -> this.adminDialog.channelStatusReceived(status, result));
    }

    public void putChannelInfo(ChannelStatus info) {
        this.client.api.putChannelInfoNew(info);
    }

    public String getActiveStream() {
        return this.channels.getActiveChannel().getStreamName();
    }

    public Room getActiveRoom() {
        return this.channels.getActiveChannel().getRoom();
    }

    public void setGameFavorites(Set<StreamCategory> favorites) {
        this.client.settings.putList("gamesFavorites", new ArrayList<String>(SelectGameDialog.favoritesToSettingsOld(favorites)));
        this.client.settings.putList("gamesFavorites2", new ArrayList<List>(SelectGameDialog.favoritesToSettings(favorites)));
    }

    public void setStreamTagFavorites(Map<String, String> favorites) {
        this.client.settings.putMap("tagsFavorites", favorites);
    }

    public Collection<StreamCategory> getGameFavorites() {
        Collection<StreamCategory> result = SelectGameDialog.settingsToFavorites(this.client.settings.getList("gamesFavorites2"));
        if (result.isEmpty()) {
            result = SelectGameDialog.settingsToFavoritesOld(this.client.settings.getList("gamesFavorites"));
        }
        return result;
    }

    public Map<String, String> getStreamTagFavorites() {
        return this.client.settings.getMap("tagsFavorites");
    }

    public void putChannelInfoResult(final TwitchApi.RequestResultCode result, final String error) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.adminDialog.setPutResult(result, error);
            }
        });
    }

    public void saveCommercialDelaySettings(boolean enabled, long delay) {
        this.client.settings.setBoolean("adDelay", enabled);
        this.client.settings.setLong("adDelayLength", delay);
    }

    private void loadCommercialDelaySettings() {
        boolean enabled = this.client.settings.getBoolean("adDelay");
        long length = this.client.settings.getLong("adDelayLength");
        this.adminDialog.updateCommercialDelaySettings(enabled, length);
    }

    public void runCommercial(String stream, int length) {
        this.client.runCommercial(stream, length);
    }

    private void runCommercial(int length) {
        if (this.adminDialog.isCommercialsTabVisible()) {
            this.adminDialog.commercialHotkey(length);
        } else {
            this.runCommercial(this.getActiveStream(), length);
        }
    }

    public void commercialResult(final String stream, final String text, final TwitchApi.RequestResultCode result) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.adminDialog.commercialResult(stream, text, result);
            }
        });
    }

    public List<String> getOpenChannels() {
        ArrayList<String> result = new ArrayList<String>();
        for (Channel chan : this.channels.getChannelsOfType(Channel.Type.CHANNEL)) {
            result.add(chan.getChannel());
        }
        return result;
    }

    public StreamInfo getStreamInfo(String stream) {
        HashSet<String> streams = new HashSet<String>();
        for (Channel chan : this.channels.getChannelsOfType(Channel.Type.CHANNEL)) {
            if (chan.getStreamName() == null) continue;
            streams.add(chan.getStreamName());
        }
        return this.client.api.getStreamInfo(stream, streams);
    }

    public void printStreamInfo(final Room room) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StreamInfo info;
                if (MainGui.this.client.settings.getBoolean("printStreamStatus") && (info = MainGui.this.getStreamInfo(room.getStream())).isValid()) {
                    MainGui.this.printLine(room, "~" + info.getFullStatus() + "~");
                }
            }
        });
    }

    private void requestFollowedStreams() {
        if (this.client.settings.getBoolean("requestFollowedStreams")) {
            if (this.client.settings.getList("scopes").contains(TokenInfo.Scope.FOLLOWS.scope)) {
                this.client.api.getFollowedStreams(this.client.settings.getString("token"));
            } else {
                EventLog.addSystemEvent("access.follows", new Object[0]);
            }
        }
    }

    private void updateLaF() {
        LaFChanger.changeLookAndFeel(LaF.LaFSettings.fromSettings(this.client.settings), this);
    }

    public Settings getSettings() {
        return this.client.settings;
    }

    public Collection<String> getSettingNames() {
        return this.client.settings.getSettingNames();
    }

    public String getCustomCompletionItem(String key) {
        return (String)this.client.settings.mapGet("customCompletion", key);
    }

    public boolean isEmoteIgnored(Emoticon emote, int in) {
        return this.emoticons.isEmoteIgnored(emote, in);
    }

    public Collection<String> getCustomCommandNames() {
        return this.client.customCommands.getCommandNames();
    }

    public Collection<String> getCommandNames() {
        return this.client.commands.getCommandNames();
    }

    public void updateEmoteNames(final Set<String> localEmotesets) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainGui.this.emoticons.updateLocalEmotes(localEmotesets);
            }
        });
    }

    public boolean hasLineId(String channel, long lineId) {
        return this.channels.hasLineId(channel, lineId);
    }

    public void scrollToLineId(String channel, long lineId, String label) {
        GuiUtil.edt(() -> this.channels.scrollToLineId(channel, lineId, label));
    }

    public WindowListener getWindowListener() {
        return this.windowListener;
    }

    private boolean isMinimized() {
        return (this.getExtendedState() & 1) == 1;
    }

    private void minimizeToTray() {
        this.minimizeToTray(this.client.settings.getBoolean("hidePopoutsIfTray"));
    }

    private void minimizeToTray(boolean includePopouts) {
        this.trayIcon.setIconVisible(true);
        if (!this.isMinimized()) {
            this.setExtendedState(this.getExtendedState() | 1);
        }
        if (this.trayIcon.isAvailable()) {
            this.setVisible(false);
            if (includePopouts) {
                this.channels.getDock().minimizeWindows();
                this.channels.getDock().hideWindows();
            }
        } else if (includePopouts) {
            this.channels.getDock().minimizeWindows();
        }
    }

    private void minimize(boolean includePopouts) {
        this.setExtendedState(this.getExtendedState() | 1);
        if (includePopouts) {
            this.channels.getDock().minimizeWindows();
        }
    }

    private void cleanupAfterRestoredFromTray() {
        if (this.client.settings.getLong("nType") != 1L && !this.client.settings.getBoolean("trayIconAlways")) {
            this.trayIcon.setIconVisible(false);
        }
    }

    public void showPopupMessage(String text) {
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, text));
    }

    public void error(final LogRecord error, final LinkedList<LogRecord> previous) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String ignore = MainGui.this.client.settings.getString("ignoreError");
                if (!ignore.isEmpty() && Pattern.compile(ignore).matcher(ErrorMessage.makeErrorText(error, previous)).find()) {
                    return;
                }
                int result = MainGui.this.errorMessage.show(error, previous, MainGui.this.client.getOpenChannels().size());
                if (result == 1) {
                    MainGui.this.exit();
                }
            }
        });
    }

    private void exit() {
        this.client.exit();
    }

    public void cleanUp() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.hotkeyManager.cleanUp();
            this.setVisible(false);
            this.dispose();
        }
    }

    private class StateUpdater {
        private final ElapsedTime lastUpdatedET = new ElapsedTime();
        private static final int UPDATE_STATE_DELAY = 500;
        private boolean init = false;

        private StateUpdater() {
        }

        protected void init() {
            this.init = true;
            this.update();
        }

        protected void update() {
            this.update(false);
        }

        protected void update(boolean forced) {
            if (!MainGui.this.guiCreated || !this.init) {
                return;
            }
            if (!forced && !this.lastUpdatedET.millisElapsed(500L)) {
                return;
            }
            this.lastUpdatedET.set();
            int state = MainGui.this.client.getState();
            MainGui.this.requestFollowedStreams();
            this.updateMenuState(state);
            this.updateTitles(state);
        }

        private void updateMenuState(int state) {
            MainGui.this.menu.getMenuItem("connect").setEnabled(state <= 0 && state != -1);
            MainGui.this.menu.getMenuItem("disconnect").setEnabled(state > 0 || state == -1);
        }

        private void updateTitles(int state) {
            String mainTitle = this.makeTitle(MainGui.this.channels.getMainActiveContent(), state);
            String trayTooltip = this.makeTitle(MainGui.this.channels.getLastActiveChannel().getDockContent(), state);
            MainGui.this.trayIcon.setTooltipText(trayTooltip);
            if (MainGui.this.client.settings.getBoolean("simpleTitle")) {
                MainGui.this.setTitle("Chatty");
            } else {
                MainGui.this.setTitle(mainTitle);
            }
            for (Map.Entry<DockPopout, DockContent> entry : MainGui.this.channels.getActivePopoutContent().entrySet()) {
                DockPopout popout = entry.getKey();
                DockContent active = entry.getValue();
                if (active == null) {
                    popout.setTitle(this.appendToTitle("Empty"));
                    continue;
                }
                String title = this.makeTitle(active, state);
                popout.setTitle(title);
            }
            if (MainGui.this.client.settings.getBoolean("tabsChanTitles")) {
                for (DockContent c : MainGui.this.channels.getDock().getContents()) {
                    Channel chan;
                    if (!(c.getComponent() instanceof Channel) || !(chan = (Channel)c.getComponent()).getName().startsWith("#")) continue;
                    c.setLongTitle(this.makeChannelInfo(chan));
                }
            } else {
                for (DockContent c : MainGui.this.channels.getDock().getContents()) {
                    if (!(c.getComponent() instanceof Channel)) continue;
                    c.setLongTitle(null);
                }
            }
        }

        private String makeTitle(DockContent content, int state) {
            Channel channel = null;
            if (content instanceof Channels.DockChannelContainer) {
                channel = (Channel)((Channels.DockChannelContainer)content).getContent();
            }
            if (channel == null) {
                String title = content.getLongTitle();
                if (StringUtil.isNullOrEmpty(title)) {
                    title = content.getTitle();
                }
                return this.appendToTitle(title);
            }
            String channelName = channel.getName();
            String stateText = "";
            if (state == 1) {
                stateText = "Connecting..";
            } else if (state == 2) {
                stateText = "Connecting...";
            } else if (state == 3) {
                if (channelName.isEmpty()) {
                    stateText = "Connected";
                }
            } else if (state == 0) {
                stateText = "Not connected";
            } else if (state == -1) {
                stateText = "Reconnecting..";
            }
            String title = stateText;
            String secondaryConnectionsStatus = "";
            if (MainGui.this.client.settings.getBoolean("titleConnections")) {
                secondaryConnectionsStatus = MainGui.this.client.getSecondaryConnectionsStatus();
            }
            if (!secondaryConnectionsStatus.isEmpty()) {
                secondaryConnectionsStatus = " [" + secondaryConnectionsStatus + "]";
            }
            if (!channelName.isEmpty()) {
                String chanNameText = channelName;
                chanNameText = chanNameText + secondaryConnectionsStatus;
                if (!title.isEmpty()) {
                    title = title + " - ";
                }
                title = title + chanNameText + " " + this.makeChannelInfo(channel);
            } else {
                title = title + secondaryConnectionsStatus;
            }
            return this.appendToTitle(title);
        }

        private String makeChannelInfo(Channel channel) {
            StreamInfo streamInfo;
            String chan = channel.getChannel();
            String title = "";
            boolean hideCounts = !MainGui.this.client.settings.getBoolean("titleShowViewerCount");
            String numUsers = Helper.formatViewerCount(channel.getNumUsers());
            if (!MainGui.this.client.isUserlistLoaded(chan)) {
                numUsers = numUsers + "*";
            }
            if (hideCounts) {
                numUsers = "";
            }
            String chanState = "";
            if (MainGui.this.client.settings.getBoolean("titleShowChannelState")) {
                chanState = MainGui.this.client.getChannelState(chan).getInfo();
            }
            if (!chanState.isEmpty()) {
                chanState = " " + chanState;
            }
            String topic = "";
            if (channel.getRoom().hasTopic()) {
                topic = "[" + channel.getRoom().getTopic() + "]";
            }
            if ((streamInfo = MainGui.this.getStreamInfo(channel.getStreamName())).isValidEnough()) {
                if (streamInfo.getOnline()) {
                    String uptime = "";
                    if (MainGui.this.client.settings.getBoolean("titleShowUptime") && streamInfo.getTimeStartedWithPicnic() != -1L) {
                        uptime = MainGui.this.client.settings.getBoolean("titleLongerUptime") ? DateTime.agoUptimeCompact2(streamInfo.getTimeStartedWithPicnic()) : DateTime.agoUptimeCompact(streamInfo.getTimeStartedWithPicnic());
                    }
                    String numViewers = "|" + Helper.formatViewerCount(streamInfo.getViewers());
                    if (!MainGui.this.client.settings.getBoolean("titleShowViewerCount")) {
                        numViewers = "";
                    } else if (!uptime.isEmpty()) {
                        uptime = "|" + uptime;
                    }
                    title = title + " [" + numUsers + numViewers + uptime + "]";
                } else if (!hideCounts) {
                    title = title + " [" + numUsers + "]";
                }
                title = title + chanState + topic + " - " + streamInfo.getFullStatus();
            } else {
                if (!hideCounts) {
                    title = title + " [" + numUsers + "]";
                }
                title = title + chanState;
                title = title + topic;
            }
            return title.trim();
        }

        private String appendToTitle(String title) {
            title = title + " - Chatty";
            String addition = MainGui.this.client.settings.getString("titleAddition");
            if (!addition.isEmpty()) {
                title = addition + " " + title;
            }
            return title;
        }
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (e.getSource() == MainGui.this.tokenGetDialog) {
                MainGui.this.tokenGetDialogClosed();
            }
        }
    }

    private class MyUserListener
    implements UserListener {
        private MyUserListener() {
        }

        @Override
        public void userClicked(User user, String msgId, String autoModMsgId, MouseEvent e) {
            if (e == null || !e.isControlDown() && !e.isAltDown() && !SwingUtilities.isMiddleMouseButton(e)) {
                MainGui.this.openUserInfoDialog(user, msgId, autoModMsgId);
                return;
            }
            String command = MainGui.this.client.settings.getString("commandOnCtrlClick").trim();
            if (SwingUtilities.isMiddleMouseButton(e)) {
                if (e.isControlDown()) {
                    this.userClickCommand(user, MainGui.this.client.settings.getString("commandOnCtrlMiddleClick"), msgId, autoModMsgId);
                } else {
                    this.userClickCommand(user, MainGui.this.client.settings.getString("commandOnMiddleClick"), msgId, autoModMsgId);
                }
            } else if (e.isControlDown() && command.length() > 1) {
                this.userClickCommand(user, command, msgId, autoModMsgId);
            } else if (!e.isAltDown()) {
                MainGui.this.openUserInfoDialog(user, msgId, autoModMsgId);
            }
        }

        private void userClickCommand(User user, String command, String msgId, String autoModMsgId) {
            CustomCommand customCommand;
            if ((command = command.trim()).length() <= 1) {
                return;
            }
            Parameters parameters = Parameters.create(user.getRegularDisplayNick());
            Helper.addUserParameters(user, msgId, autoModMsgId, parameters);
            if (command.contains(" ")) {
                customCommand = CustomCommand.parse(command);
            } else {
                if (!command.startsWith("/")) {
                    command = "/" + command;
                }
                customCommand = CustomCommand.createDefault(command);
            }
            MainGui.this.client.anonCustomCommand(user.getRoom(), customCommand, parameters);
        }

        @Override
        public void emoteClicked(Emoticon emote, MouseEvent e) {
            if (e.isControlDown()) {
                MainGui.this.insert(Emoticons.toWriteable(emote.code), true);
            } else {
                MainGui.this.openEmotesDialogEmoteDetails(emote);
            }
        }

        @Override
        public void usericonClicked(Usericon usericon, MouseEvent e) {
            if (!usericon.metaUrl.isEmpty()) {
                UrlOpener.openUrlPrompt(MainGui.this, usericon.metaUrl);
            }
        }

        @Override
        public void linkClicked(Channel channel, MsgTags.Link link) {
            switch (link.type) {
                case JOIN: {
                    MainGui.this.client.joinChannel(link.target);
                    break;
                }
                case URL: {
                    UrlOpener.openUrl(link.target);
                }
            }
        }
    }

    private class MyLinkLabelListener
    implements LinkLabelListener {
        private MyLinkLabelListener() {
        }

        @Override
        public void linkClicked(String type, String ref) {
            switch (type) {
                case "help": {
                    MainGui.this.openHelp(ref);
                    break;
                }
                case "help-settings": {
                    MainGui.this.openHelp("help-settings.html", ref);
                    break;
                }
                case "help-commands": {
                    MainGui.this.openHelp("help-custom_commands.html", ref);
                    break;
                }
                case "help-admin": {
                    MainGui.this.openHelp("help-admin.html", ref);
                    break;
                }
                case "help-livestreamer": {
                    MainGui.this.openHelp("help-livestreamer.html", ref);
                    break;
                }
                case "help-whisper": {
                    MainGui.this.openHelp("help-whisper.html", ref);
                    break;
                }
                case "help-laf": {
                    MainGui.this.openHelp("help-laf.html", ref);
                    break;
                }
                case "help-guide2": {
                    MainGui.this.openHelp("help-guide2.html", ref);
                    break;
                }
                case "help-releases": {
                    MainGui.this.openHelp("help-releases.html", ref);
                    break;
                }
                case "url": {
                    UrlOpener.openUrlPrompt(MainGui.this, ref);
                    break;
                }
                case "update": {
                    if (!ref.equals("show")) break;
                    MainGui.this.openUpdateDialog();
                    break;
                }
                case "announcement": {
                    if (!ref.equals("show")) break;
                    break;
                }
                case "settings": {
                    MainGui.this.getSettingsDialog(s -> {
                        if (!s.isVisible()) {
                            s.showSettings("show", ref);
                        } else {
                            s.showPage(ref);
                        }
                    });
                }
            }
        }
    }

    class MyContextMenuListener
    implements ContextMenuListener {
        private final Set<String> streamCmds = new HashSet<String>(Arrays.asList("profile", "join", "raidchannel"));
        private final Set<String> streamCmdsPrefix = new HashSet<String>(Arrays.asList("stream", "livestreamer"));

        MyContextMenuListener() {
        }

        @Override
        public void userMenuItemClicked(ActionEvent e, User user, String msgId, String autoModMsgId) {
            String cmd = e.getActionCommand();
            if (cmd.equals("userinfo")) {
                MainGui.this.openUserInfoDialog(user, msgId, autoModMsgId);
            } else if (cmd.startsWith("userinfo.")) {
                String chan = cmd.substring(9);
                MainGui.this.openUserInfoDialog(MainGui.this.client.getUser(chan, user.getName()), null, null, true);
            } else if (cmd.equals("addressbookEdit")) {
                MainGui.this.openAddressbook(user.getName());
            } else if (cmd.equals("addressbookRemove")) {
                MainGui.this.client.addressbook.remove(user.getName());
                MainGui.this.updateUserInfoDialog(user);
            } else if (cmd.startsWith("cat")) {
                if (e.getSource() instanceof JCheckBoxMenuItem) {
                    boolean selected = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                    String catName = cmd.substring(3);
                    if (selected) {
                        MainGui.this.client.addressbook.add(user.getName(), catName);
                    } else {
                        MainGui.this.client.addressbook.remove(user.getName(), catName);
                    }
                }
                MainGui.this.updateUserInfoDialog(user);
            } else if (cmd.equals("setcolor")) {
                MainGui.this.setColor(user.getName());
            } else if (cmd.equals("setname")) {
                MainGui.this.setCustomName(user.getName());
            } else if (cmd.equals("notes")) {
                UserNotes.instance().showDialog(user, MainGui.this, null);
            } else if (cmd.startsWith("command")) {
                Parameters parameters = Parameters.create(user.getRegularDisplayNick());
                Helper.addUserParameters(user, msgId, autoModMsgId, parameters);
                this.customCommand(user.getRoom(), e, parameters);
            } else if (cmd.equals("copyNick")) {
                MiscUtil.copyToClipboard(user.getName());
            } else if (cmd.equals("copyDisplayNick")) {
                MiscUtil.copyToClipboard(user.getDisplayNick());
            } else if (cmd.equals("ignore")) {
                MainGui.this.client.commandSetIgnored(user.getName(), "chat", true);
            } else if (cmd.equals("ignoreWhisper")) {
                MainGui.this.client.commandSetIgnored(user.getName(), "whisper", true);
            } else if (cmd.equals("unignore")) {
                MainGui.this.client.commandSetIgnored(user.getName(), "chat", false);
            } else if (cmd.equals("unignoreWhisper")) {
                MainGui.this.client.commandSetIgnored(user.getName(), "whisper", false);
            } else if (cmd.equals("autoModApprove")) {
                MainGui.this.client.command(user.getRoom(), "automod_approve", autoModMsgId);
            } else if (cmd.equals("autoModDeny")) {
                MainGui.this.client.command(user.getRoom(), "automod_deny", autoModMsgId);
            } else {
                this.nameBasedStuff(e, user.getName());
            }
        }

        @Override
        public void urlMenuItemClicked(ActionEvent e, String url) {
            String cmd = e.getActionCommand();
            if (cmd.equals("open")) {
                UrlOpener.openUrlPrompt(MainGui.this, url);
            } else if (cmd.equals("copy")) {
                MiscUtil.copyToClipboard(url);
            } else if (cmd.equals("join")) {
                MainGui.this.client.commandJoinChannel(url);
            }
        }

        @Override
        public void menuItemClicked(ActionEvent e) {
            Debugging.println("cmchan", "[cm] tab: %s chan: %s lastchan: %s", MainGui.this.channels.getMainActiveChannel(), MainGui.this.channels.getActiveChannel(), MainGui.this.channels.getLastActiveChannel());
            String cmd = e.getActionCommand();
            if (cmd.startsWith("historyRange")) {
                int range = Integer.parseInt(cmd.substring("historyRange".length()));
                MainGui.this.client.settings.setLong("historyRange", range);
            } else if (cmd.startsWith("toggleVerticalZoom")) {
                boolean selected = ((JMenuItem)e.getSource()).isSelected();
                MainGui.this.client.settings.setBoolean("historyVerticalZoom", selected);
            } else if (cmd.startsWith("highlightSource.")) {
                MainGui.this.getSettingsDialog(s -> s.showSettings("selectHighlight", JSONValue.parse(cmd.substring("highlightSource.".length()))));
            } else if (cmd.startsWith("ignoreSource.")) {
                MainGui.this.getSettingsDialog(s -> s.showSettings("selectIgnore", JSONValue.parse(cmd.substring("ignoreSource.".length()))));
            } else if (cmd.startsWith("msgColorSource.")) {
                MainGui.this.getSettingsDialog(s -> s.showSettings("selectMsgColor", cmd.substring("msgColorSource.".length())));
            } else if (cmd.startsWith("routingSource.")) {
                MainGui.this.getSettingsDialog(s -> s.showSettings("selectRouting", JSONValue.parse(cmd.substring("routingSource.".length()))));
            } else if (cmd.startsWith("notificationSource.")) {
                MainGui.this.getSettingsDialog(s -> s.showSettings("selectNotification", cmd.substring("notificationSource.".length())));
            } else {
                this.nameBasedStuff(e, MainGui.this.channels.getActiveChannel().getStreamName());
            }
        }

        @Override
        public void tabMenuItemClicked(ActionEvent e, DockContent content) {
            String cmd = e.getActionCommand();
            if (cmd.equals("closeChannel")) {
                content.remove();
            } else if (cmd.startsWith("tabsPosTab")) {
                long pos = Long.parseLong(cmd.substring("tabsPosTab".length()));
                MainGui.this.getSettings().mapPut("tabsPos", content.getId(), pos);
                MainGui.this.getSettings().setSettingChanged("tabsPos");
            } else if (cmd.startsWith("tabsPosType")) {
                long pos = Long.parseLong(cmd.substring("tabsPosType".length()));
                MainGui.this.getSettings().mapPut("tabsPos", content.getId().substring(0, 1), pos);
                MainGui.this.getSettings().setSettingChanged("tabsPos");
            } else if (cmd.equals("tabsSort")) {
                MainGui.this.channels.sortContent(null);
            } else if (cmd.equals("tabsAutoSort")) {
                MainGui.this.client.settings.toggleBoolean("tabsAutoSort");
            } else if (cmd.equals("popoutChannel")) {
                MainGui.this.channels.popout(content, false);
            } else if (cmd.equals("popoutChannelWindow")) {
                MainGui.this.channels.popout(content, true);
            } else if (cmd.startsWith("closeAllTabs")) {
                Collection<DockContent> chans = Channels.getCloseTabs(MainGui.this.channels, content, MainGui.this.client.settings.getBoolean("closeTabsSameType")).get(cmd);
                if (chans != null) {
                    for (DockContent c : chans) {
                        c.remove();
                    }
                }
            } else if (cmd.equals("tabsCloseSameType")) {
                MainGui.this.client.settings.toggleBoolean("closeTabsSameType");
            } else {
                Channel channel;
                Channel channel2 = channel = content instanceof Channels.DockChannelContainer ? (Channel)((Channels.DockChannelContainer)content).getContent() : null;
                if (channel != null) {
                    if (cmd.startsWith("command")) {
                        this.customCommand(channel.getRoom(), e, Parameters.create(channel.getStreamName()));
                    } else {
                        this.nameBasedStuff(e, channel.getStreamName());
                    }
                }
            }
        }

        @Override
        public void channelMenuItemClicked(ActionEvent e, Channel channel) {
            Debugging.println("cmchan", "[channelcm] tab: %s chan: %s lastchan: %s", MainGui.this.channels.getMainActiveChannel(), MainGui.this.channels.getActiveChannel(), MainGui.this.channels.getLastActiveChannel());
            String cmd = e.getActionCommand();
            if (cmd.equals("channelInfo")) {
                MainGui.this.setChannelInfoDialogChannel(channel);
                MainGui.this.openChannelInfoDialog();
            } else if (cmd.equals("channelAdmin")) {
                MainGui.this.openChannelAdminDialog(channel.getStreamName());
            } else if (cmd.equals("closeChannel")) {
                MainGui.this.client.closeChannel(channel.getChannel());
            } else if (cmd.equals("srcOpen")) {
                MainGui.this.client.speedruncom.openCurrentGame(channel);
            } else if (cmd.startsWith("command")) {
                this.customCommand(channel.getRoom(), e, Parameters.create(channel.getStreamName()));
            } else {
                this.nameBasedStuff(e, channel.getStreamName());
            }
        }

        @Override
        public void streamsMenuItemClicked(ActionEvent e, Collection<String> streams) {
            this.streamStuff(e, streams);
            this.channelStuff(e, streams);
        }

        @Override
        public void roomsMenuItemClicked(ActionEvent e, Collection<Room> rooms) {
            this.roomsStuff(e, rooms);
        }

        @Override
        public void streamInfosMenuItemClicked(ActionEvent e, Collection<StreamInfo> streamInfos) {
            String cmd = e.getActionCommand();
            String sorting = null;
            if (cmd.startsWith("sort_")) {
                sorting = cmd.substring("sort_".length());
            }
            if (sorting != null) {
                MainGui.this.client.settings.setString("liveStreamsSorting", sorting);
            } else {
                ArrayList<String> streams = new ArrayList<String>();
                for (StreamInfo info : streamInfos) {
                    streams.add(info.getCapitalizedName());
                }
                this.streamStuff(e, streams);
                this.channelStuff(e, streams);
            }
            if (cmd.equals("manualRefreshStreams")) {
                MainGui.this.client.api.manualRefreshStreams();
                MainGui.this.state.update(true);
            }
            if (cmd.equals("liveStreamsSettings")) {
                MainGui.this.getSettingsDialog(s -> s.showSettings("show", "LIVE_STREAMS"));
            }
            if (cmd.equals("sortOption_favFirst")) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                MainGui.this.client.settings.setBoolean("liveStreamsSortingFav", item.isSelected());
            }
            if (cmd.equals("filterOption_favsOnly")) {
                MainGui.this.client.settings.setBoolean("liveStreamsFavsOnly", ((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
            if (cmd.equals("favoriteGame")) {
                for (StreamInfo info : streamInfos) {
                    if (StringUtil.isNullOrEmpty(info.getGame())) continue;
                    MainGui.this.client.settings.setAdd("gameFavorites", info.getGame());
                }
                MainGui.this.client.settings.setSettingChanged("gameFavorites");
            }
            if (cmd.equals("unfavoriteGame")) {
                for (StreamInfo info : streamInfos) {
                    if (StringUtil.isNullOrEmpty(info.getGame())) continue;
                    MainGui.this.client.settings.listRemove("gameFavorites", info.getGame());
                }
                MainGui.this.client.settings.setSettingChanged("gameFavorites");
            }
        }

        private void nameBasedStuff(ActionEvent e, String name) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(name);
            this.streamStuff(e, list);
            this.channelStuff(e, list);
        }

        private boolean cmdRequiresStream(String cmd) {
            for (String prefix : this.streamCmdsPrefix) {
                if (!cmd.startsWith(prefix)) continue;
                return true;
            }
            return this.streamCmds.contains(cmd);
        }

        private void roomsStuff(ActionEvent e, Collection<Room> rooms) {
            ArrayList<String> channels = new ArrayList<String>();
            ArrayList<String> streams = new ArrayList<String>();
            for (Room room : rooms) {
                channels.add(room.getChannel());
                if (!room.hasStream()) continue;
                streams.add(room.getStream());
            }
            this.channelStuff(e, channels);
            this.streamStuff(e, streams);
        }

        private void channelStuff(ActionEvent e, Collection<String> channels) {
            String cmd = e.getActionCommand();
            TwitchUrl.removeInvalidStreams(channels);
            if (cmd.equals("join")) {
                MainGui.this.makeVisible();
                MainGui.this.client.joinChannels(new HashSet<String>(channels));
            } else if (cmd.equals("favoriteChannel")) {
                for (String chan : channels) {
                    MainGui.this.client.channelFavorites.addFavorite(chan);
                }
                MainGui.this.favoritesDialog.updateData();
            } else if (cmd.equals("unfavoriteChannel")) {
                for (String chan : channels) {
                    MainGui.this.client.channelFavorites.removeFavorite(chan);
                }
                MainGui.this.favoritesDialog.updateData();
            }
        }

        private void streamStuff(ActionEvent e, Collection<String> streams) {
            String cmd = e.getActionCommand();
            TwitchUrl.removeInvalidStreams(streams);
            if (streams.isEmpty() && this.cmdRequiresStream(cmd)) {
                JOptionPane.showMessageDialog(MainGui.this.getActiveWindow(), "Can't perform action: No stream/channel.", "Info", 1);
                return;
            }
            String firstStream = null;
            if (!streams.isEmpty()) {
                firstStream = streams.iterator().next();
            }
            if (cmd.equals("stream") || cmd.equals("streamPopout") || cmd.equals("streamPopoutOld") || cmd.equals("profile") || cmd.equals("streamChat")) {
                ArrayList<String> urls = new ArrayList<String>();
                for (String stream : streams) {
                    String url;
                    switch (cmd) {
                        case "stream": {
                            url = TwitchUrl.makeTwitchStreamUrl(stream);
                            break;
                        }
                        case "profile": {
                            url = TwitchUrl.makeTwitchProfileUrl(stream);
                            break;
                        }
                        case "streamPopout": {
                            url = TwitchUrl.makeTwitchPlayerUrl(stream);
                            break;
                        }
                        case "streamChat": {
                            url = TwitchUrl.makeTwitchChatUrl(stream);
                            break;
                        }
                        default: {
                            url = TwitchUrl.makeTwitchStreamUrl(stream);
                        }
                    }
                    urls.add(url);
                }
                if (urls.size() > 1) {
                    UrlOpener.openUrlsPrompt(MainGui.this.getActiveWindow(), urls, true);
                } else {
                    UrlOpener.openUrlsPrompt(MainGui.this.getActiveWindow(), urls);
                }
            } else if (cmd.startsWith("streams")) {
                ArrayList<String> streams2 = new ArrayList<String>();
                for (String stream : streams) {
                    streams2.add(stream);
                }
                String type = "http://multitwitch.tv/";
                switch (cmd) {
                    case "streamsSpeedruntv": {
                        type = "http://speedrun.tv/";
                        break;
                    }
                    case "streamsKadgar": {
                        type = "http://kadgar.net/live/";
                    }
                }
                TwitchUrl.openMultitwitch(streams2, MainGui.this.getActiveWindow(), type);
            } else if (cmd.startsWith("livestreamer")) {
                String quality = null;
                if (cmd.startsWith("livestreamerQ") && (quality = StringUtil.toLowerCase(cmd.substring(13))).equalsIgnoreCase("select")) {
                    quality = null;
                }
                for (String stream : streams) {
                    MainGui.this.livestreamerDialog.open(StringUtil.toLowerCase(stream), quality);
                }
            } else if (cmd.equals("showChannelEmotes")) {
                if (firstStream != null) {
                    MainGui.this.openEmotesDialogChannelEmotes(StringUtil.toLowerCase(firstStream));
                    MainGui.this.client.api.requestEmotesNow();
                }
            } else if (cmd.equals("raidchannel")) {
                if (firstStream != null && streams.size() == 1) {
                    String ownChannel = "#" + MainGui.this.client.getUsername();
                    Channel chan = MainGui.this.channels.getExistingChannel(ownChannel);
                    if (chan == null) {
                        MainGui.this.printSystem("Must have your own channel open to raid.");
                    } else {
                        MainGui.this.client.command(chan.getRoom(), "raid", StringUtil.toLowerCase(firstStream));
                        MainGui.this.printSystem(String.format("Trying to raid %s from %s..", firstStream, ownChannel));
                    }
                } else {
                    MainGui.this.printSystem("Can't raid more than one channel.");
                }
            } else if (cmd.equals("copy") && !streams.isEmpty()) {
                MiscUtil.copyToClipboard(StringUtil.join(streams, ", "));
            } else if (cmd.startsWith("command")) {
                this.customCommand(MainGui.this.channels.getLastActiveChannel().getRoom(), e, Parameters.create(StringUtil.join(streams, " ")));
            } else if (cmd.startsWith("toggleBoolean_")) {
                String setting = cmd.substring("toggleBoolean_".length());
                MainGui.this.client.settings.setBoolean(setting, !MainGui.this.client.settings.getBoolean(setting));
            }
        }

        @Override
        public void emoteMenuItemClicked(ActionEvent e, CachedImage<Emoticon> emoteImage) {
            Emoticon emote = emoteImage.getObject();
            String url = null;
            if (e.getActionCommand().equals("code")) {
                MainGui.this.channels.getActiveChannel().insertText(emote.code, "s");
            } else if (e.getActionCommand().equals("codeEmoji")) {
                MainGui.this.channels.getActiveChannel().insertText(emote.stringId, "s");
            } else if (e.getActionCommand().equals("cheer")) {
                url = "https://help.twitch.tv/customer/portal/articles/2449458";
            } else if (e.getActionCommand().equals("emoteImage")) {
                url = emoteImage.getSourceUrl();
            } else if (e.getActionCommand().equals("emoteImageLoaded")) {
                url = emoteImage.getLoadedFromUrl();
            } else if (e.getActionCommand().equals("ffzlink")) {
                url = TwitchUrl.makeFFZUrl();
            } else if (e.getActionCommand().equals("emoteId")) {
                url = TwitchUrl.makeEmoteUrl(emote.type, emote.stringId);
            } else if (e.getActionCommand().equals("emoteCreator")) {
                if (emote.type == Emoticon.Type.FFZ) {
                    url = TwitchUrl.makeFFZUserUrl(emote.creator);
                } else if (emote.creator.equals("Twemoji")) {
                    url = "https://github.com/twitter/twemoji";
                }
            } else if (e.getActionCommand().equals("twitchturbolink")) {
                url = TwitchUrl.makeTwitchTurboUrl();
            } else if (e.getActionCommand().equals("bttvlink")) {
                url = TwitchUrl.makeBttvUrl();
            } else if (e.getActionCommand().equals("seventvlink")) {
                url = "https://7tv.app/";
            } else if (e.getActionCommand().equals("emoteDetails")) {
                MainGui.this.openEmotesDialogEmoteDetails(emote);
            } else if (e.getActionCommand().equals("ignoreEmote")) {
                IgnoredEmotes.Item item = EmoteSettings.showIgnoredEmoteEditDialog(MainGui.this, MainGui.this.getActiveWindow(), emote, MainGui.this.emoticons.getIgnoredEmoteMatches(emote));
                if (item != null) {
                    MainGui.this.emoticons.setEmoteIgnored(emote, item.context, MainGui.this.client.settings);
                    MainGui.this.emotesDialog.update();
                }
            } else if (e.getActionCommand().equals("favoriteEmote")) {
                MainGui.this.emoticons.addFavorite(emote);
                MainGui.this.client.settings.setAdd("favoriteEmotes", emote.code);
                MainGui.this.emotesDialog.favoritesUpdated();
            } else if (e.getActionCommand().equals("unfavoriteEmote")) {
                MainGui.this.emoticons.removeFavorite(emote);
                MainGui.this.client.settings.listRemove("favoriteEmotes", emote.code);
                MainGui.this.emotesDialog.favoritesUpdated();
            } else if (e.getActionCommand().equals("addCustomLocalEmote")) {
                MainGui.this.localEmotes.add(emote);
            } else if (e.getActionCommand().equals("removeCustomLocalEmote")) {
                MainGui.this.localEmotes.remove(emote);
            }
            if (emote.hasStreamSet()) {
                this.nameBasedStuff(e, emote.getStream());
            }
            if (url != null) {
                UrlOpener.openUrlPrompt(MainGui.this.getActiveWindow(), url, true);
            }
        }

        @Override
        public void usericonMenuItemClicked(ActionEvent e, CachedImage<Usericon> usericonImage) {
            Usericon usericon = usericonImage.getObject();
            if (e.getActionCommand().equals("usericonUrl")) {
                if (!usericon.metaUrl.isEmpty()) {
                    UrlOpener.openUrlPrompt(MainGui.this, usericon.metaUrl);
                }
            } else if (e.getActionCommand().equals("copyBadgeType")) {
                MiscUtil.copyToClipboard(usericon.badgeType.toString());
            } else if (e.getActionCommand().startsWith("addUsericonOfBadgeType")) {
                MainGui.this.getSettingsDialog(s -> s.showSettings(e.getActionCommand(), usericon));
            } else if (e.getActionCommand().startsWith("hideUsericonOfBadgeType")) {
                if (MainGui.this.client.usericonManager.hideBadge(usericon)) {
                    JOptionPane.showMessageDialog(MainGui.this.rootPane, "Badges of type '" + usericon.readableLenientType() + "' will not show up in new messages.\n\nSee: <Main - Settings - Badges - View Hidden Badges>");
                } else {
                    JOptionPane.showMessageDialog(MainGui.this.rootPane, "Badges of type '" + usericon.readableLenientType() + "' are already hidden.\n\nSee: <Main - Settings - Badges - View Hidden Badges>");
                }
            } else if (e.getActionCommand().equals("badgeImage")) {
                UrlOpener.openUrlPrompt(MainGui.this.getActiveWindow(), usericonImage.getSourceUrl(), true);
            } else if (e.getActionCommand().equals("hideChannelLogo")) {
                JOptionPane.showMessageDialog(MainGui.this.getActiveWindow(), "Custom Tabs/Stream Chat: Right-click on empty space to open context menu.");
            }
        }

        @Override
        public void textMenuItemClick(ActionEvent e, String selected) {
            if (e.getActionCommand().startsWith("command")) {
                Room room = MainGui.this.channels.getLastActiveChannel().getRoom();
                Parameters parameters = Parameters.create(selected);
                parameters.put("msg", selected);
                this.customCommand(room, e, parameters);
            }
        }

        private void customCommand(Room room, ActionEvent e, Parameters parameters) {
            CommandActionEvent ce = (CommandActionEvent)e;
            CustomCommand command = ce.getCommand();
            MainGui.this.client.anonCustomCommand(room, command, parameters);
        }
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source;
            Channel chan = MainGui.this.channels.getChannelFromInput(event.getSource());
            if (chan != null) {
                MainGui.this.client.textInput(chan.getRoom(), chan.getInputText(), null);
            }
            if ((source = event.getSource()) == MainGui.this.connectionDialog.getCancelButton()) {
                MainGui.this.connectionDialog.setVisible(false);
                MainGui.this.channels.setInitialFocus();
            } else if (source == MainGui.this.connectionDialog.getConnectButton() || source == MainGui.this.connectionDialog.getChannelInput()) {
                String password = MainGui.this.connectionDialog.getPassword();
                String channel = MainGui.this.connectionDialog.getChannel();
                MainGui.this.client.settings.setString("password", password);
                MainGui.this.client.settings.setString("channel", channel);
                if (MainGui.this.client.prepareConnection(MainGui.this.connectionDialog.rejoinOpenChannels())) {
                    MainGui.this.connectionDialog.setVisible(false);
                    MainGui.this.channels.setInitialFocus();
                }
            } else if (event.getSource() == MainGui.this.connectionDialog.getGetTokenButton()) {
                MainGui.this.openTokenDialog();
            } else if (event.getSource() == MainGui.this.connectionDialog.getFavoritesButton()) {
                MainGui.this.openFavoritesDialogFromConnectionDialog(MainGui.this.connectionDialog.getChannel());
            } else if (event.getSource() == MainGui.this.tokenDialog.getDeleteTokenButton()) {
                int result = JOptionPane.showOptionDialog(MainGui.this.tokenDialog, "<html><body style='width:400px'>" + Language.getString("login.removeLogin") + "<ul><li>" + Language.getString("login.removeLogin.revoke") + "<li>" + Language.getString("login.removeLogin.remove") + "</ul>" + Language.getString("login.removeLogin.note"), Language.getString("login.removeLogin.title"), -1, 3, null, new String[]{Language.getString("login.removeLogin.button.revoke"), Language.getString("login.removeLogin.button.remove"), Language.getString("dialog.button.cancel")}, Language.getString("login.removeLogin.button.revoke"));
                if (result == 0) {
                    MainGui.this.client.api.revokeToken(MainGui.this.client.settings.getString("token"));
                }
                if (result == 0 || result == 1) {
                    MainGui.this.client.settings.setString("token", "");
                    MainGui.this.client.settings.setBoolean("foreignToken", false);
                    MainGui.this.client.settings.setString("username", "");
                    MainGui.this.client.settings.setString("userid", "");
                    MainGui.this.client.settings.listClear("scopes");
                    MainGui.this.updateConnectionDialog(null);
                    MainGui.this.tokenDialog.update("", "");
                    MainGui.this.updateTokenScopes();
                }
            } else if (event.getSource() == MainGui.this.tokenDialog.getRequestTokenButton()) {
                MainGui.this.tokenGetDialog.setLocationRelativeTo(MainGui.this.tokenDialog);
                MainGui.this.tokenGetDialog.reset();
                MainGui.this.client.startWebserver();
                MainGui.this.tokenGetDialog.setVisible(true);
            } else if (event.getSource() == MainGui.this.tokenDialog.getDoneButton()) {
                MainGui.this.tokenDialog.setVisible(false);
            } else if (event.getSource() == MainGui.this.tokenDialog.getVerifyTokenButton()) {
                MainGui.this.verifyToken(MainGui.this.client.settings.getString("token"));
            } else if (event.getSource() == MainGui.this.tokenGetDialog.getCloseButton()) {
                MainGui.this.tokenGetDialogClosed();
            }
        }
    }

    private class DebugCheckboxListener
    implements ItemListener {
        private DebugCheckboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean state;
            boolean bl = state = e.getStateChange() == 1;
            if (e.getSource() == MainGui.this.debugWindow.getLogIrcCheckBox()) {
                MainGui.this.client.settings.setBoolean("debugLogIrc", state);
            }
        }
    }

    private class TrayMenuListener
    implements ActionListener {
        private final ElapsedTime lastEvent = new ElapsedTime();

        private TrayMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd == null || cmd.equals("show") || cmd.equals("doubleClick") || cmd.equals("singleClick") && MainGui.this.client.settings.getBoolean("singleClickTrayOpen")) {
                if (this.lastEvent.millisElapsed(80L)) {
                    this.lastEvent.set();
                    if (MainGui.this.isMinimized()) {
                        MainGui.this.makeVisible();
                    } else {
                        MainGui.this.minimizeToTray();
                    }
                }
            } else if (cmd.equals("exit")) {
                MainGui.this.exit();
            }
        }
    }

    private class MyNotificationActionListener
    implements NotificationActionListener<NotificationManager.NotificationWindowData> {
        private MyNotificationActionListener() {
        }

        @Override
        public void notificationAction(NotificationManager.NotificationWindowData data) {
            if (data != null) {
                Notification notification = data.notification;
                String channel = data.channel;
                if (MainGui.this.client.settings.getBoolean("liveStreamsNotificationAction") && notification != null && notification.type == Notification.Type.STREAM_STATUS) {
                    StreamInfo status = MainGui.this.client.api.getCachedStreamInfo(Helper.toStream(channel));
                    if (status != null) {
                        MainGui.this.liveStreamsDialog.handleStreamsAction(Arrays.asList(status), true);
                    }
                } else {
                    MainGui.this.makeVisible();
                    MainGui.this.client.joinChannel(channel);
                }
            }
        }
    }

    private class ChannelChangeListener
    implements ChangeListener {
        private boolean openedFirstChannel = false;

        private ChannelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MainGui.this.updateChannelInfoDialog(null);
            String stream = MainGui.this.channels.getLastActiveChannel().getStreamName();
            MainGui.this.emotesDialog.updateStream(stream, MainGui.this.client.getEmotesetsByChannel(Helper.toChannel(stream)));
            MainGui.this.moderationLog.setChannel(MainGui.this.channels.getLastActiveChannel().getStreamName());
            if (!this.openedFirstChannel && MainGui.this.channels.getLastActiveChannel().getType() == Channel.Type.CHANNEL) {
                this.openedFirstChannel = true;
                if (MainGui.this.adminDialog.isVisible()) {
                    MainGui.this.openChannelAdminDialog();
                }
                MainGui.this.autoModDialog.setStream(MainGui.this.channels.getActiveChannel().getStreamName());
                if (MainGui.this.followerDialog.isVisible()) {
                    MainGui.this.openFollowerDialog();
                }
            }
            MainGui.this.channels.closeModPanels();
            MainGui.this.dockedDialogs.activeContentChanged();
            MainGui.this.routingManager.setChannel(MainGui.this.channels.getLastActiveChannel());
            MainGui.this.state.update(true);
        }
    }

    private class MySettingChangeListener
    implements SettingChangeListener {
        private MySettingChangeListener() {
        }

        @Override
        public void settingChanged(final String setting, final int type, final Object value) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.settingChangedInternal(setting, type, value);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MySettingChangeListener.this.settingChangedInternal(setting, type, value);
                    }
                });
            }
        }

        private void settingChangedInternal(String setting, int type, Object value) {
            HashSet<String> notificationSettings;
            if (type == 0) {
                boolean bool = (Boolean)value;
                if (setting.equals("ontop")) {
                    MainGui.this.setAlwaysOnTop((Boolean)value);
                } else if (setting.equals("highlightUsername")) {
                    MainGui.this.updateHighlightSetUsernameHighlighted((Boolean)value);
                } else if (setting.equals("highlightNextMessages")) {
                    MainGui.this.updateHighlightNextMessages();
                } else if (setting.equals("highlightMatchesAllEntries")) {
                    MainGui.this.updateHighlightIncludeAllMatches();
                } else if (setting.equals("popoutSaveAttributes") || setting.equals("popoutCloseLastChannel")) {
                    MainGui.this.updatePopoutSettings();
                } else if (setting.equals("livestreamer")) {
                    ContextMenuHelper.enableLivestreamer = (Boolean)value;
                } else if (setting.equals("attachedWindows")) {
                    MainGui.this.windowStateManager.setAttachedWindowsEnabled((Boolean)value);
                } else if (setting.equals("globalHotkeysEnabled")) {
                    MainGui.this.hotkeyManager.setGlobalHotkeysEnabled((Boolean)value);
                } else if (setting.equals("imageCache")) {
                    ImageCache.setCachingEnabled(bool);
                } else if (setting.equals("mainResizable")) {
                    MainGui.this.setResizable(bool);
                } else if (setting.equals("streamChatResizable")) {
                    MainGui.this.streamChat.setResizable(bool);
                } else if (setting.equals("closeEmoteDialogOnDoubleClick")) {
                    MainGui.this.emotesDialog.setCloseOnDoubleClick(bool);
                } else if (setting.equals("foreignToken")) {
                    MainGui.this.tokenDialog.setForeignToken(bool);
                } else if (setting.equals("completionEnabled")) {
                    MainGui.this.channels.setCompletionEnabled(bool);
                } else if (setting.equals("animatedEmotes")) {
                    MainGui.this.emotesDialog.setEmoteImageType(Emoticon.makeImageType(bool));
                } else if (setting.equals("matchingSubstitutesEnabled")) {
                    MainGui.this.updateHighlight();
                } else if (setting.equals("webp")) {
                    if (bool) {
                        WebPUtil.runIfWebPAvailable(() -> {});
                    }
                    WebPUtil.setUseWebP(bool);
                }
                if (setting.startsWith("title") || setting.equals("tabsChanTitles")) {
                    MainGui.this.updateState(true);
                }
                MainGui.this.loadMenuSetting(setting);
            }
            if (StyleManager.settingNames.contains(setting)) {
                BatchAction.queue(MainGui.this.styleManager, () -> {
                    MainGui.this.styleManager.refresh();
                    MainGui.this.channels.refreshStyles();
                    MainGui.this.highlightedMessages.refreshStyles();
                    MainGui.this.ignoredMessages.refreshStyles();
                    MainGui.this.streamChat.refreshStyles();
                    MainGui.this.routingManager.refreshStyles();
                });
            }
            if (setting.equals("displayNamesModeUserlist")) {
                MainGui.this.channels.updateUserlistSettings();
            }
            if (type == 1) {
                if (setting.equals("timeoutButtons") || setting.equals("banReasonsHotkey")) {
                    MainGui.this.userInfoDialog.setUserDefinedButtonsDef(MainGui.this.client.settings.getString("timeoutButtons"));
                } else if (setting.equals("token")) {
                    MainGui.this.client.api.setToken((String)value);
                } else if (setting.equals("userid")) {
                    MainGui.this.client.api.setLocalUserId((String)value);
                } else if (setting.equals("emoji")) {
                    MainGui.this.emoticons.addEmoji((String)value);
                } else if (setting.equals("cheersType")) {
                    MainGui.this.emoticons.setCheerState((String)value);
                } else if (setting.equals("backgroundColor")) {
                    MainGui.this.emoticons.setCheerBackground(HtmlColors.decode((String)value));
                } else if (setting.equals("soundDevice")) {
                    Sound.setDeviceName((String)value);
                } else if (setting.startsWith("soundCommand")) {
                    BatchAction.queue(Sound.SOUND_COMMAND_UNIQUE, () -> Sound.setCommand(MainGui.this.client.settings.getBoolean("soundCommandEnabled"), MainGui.this.client.settings.getString("soundCommand")));
                } else if (setting.equals("userDialogTimestamp")) {
                    MainGui.this.userInfoDialog.setTimestampFormat(MainGui.this.styleManager.makeTimestampFormat("userDialogTimestamp"));
                }
            }
            if (type == 4) {
                if (setting.equals("highlight") || setting.equals("highlightBlacklist") || setting.equals("matchingSubstitutes")) {
                    MainGui.this.updateHighlight();
                } else if (setting.equals("ignore") || setting.equals("ignoreBlacklist")) {
                    MainGui.this.updateIgnore();
                } else if (setting.equals("matchingPresets")) {
                    MainGui.this.updateMatchingPresets();
                } else if (setting.equals("filter")) {
                    MainGui.this.updateFilter();
                } else if (setting.equals("routing")) {
                    MainGui.this.updateRouting();
                } else if (setting.equals("hotkeys")) {
                    MainGui.this.hotkeyManager.loadFromSettings(MainGui.this.client.settings);
                } else if (setting.equals("localEmotes")) {
                    MainGui.this.emoticons.setLocalEmotes(MainGui.this.localEmotes.getData());
                    MainGui.this.emotesDialog.update();
                }
            }
            if (type == 2) {
                if (setting.equals("dialogFontSize")) {
                    MainGui.this.userInfoDialog.setFontSize(((Long)value).longValue());
                } else if (setting.equals("streamChatMessageTimeout")) {
                    MainGui.this.streamChat.setMessageTimeout(((Long)value).intValue());
                } else if (setting.equals("emoteScaleDialog")) {
                    MainGui.this.emotesDialog.setEmoteScale(((Long)value).intValue());
                } else if (setting.equals("smilies")) {
                    MainGui.this.updateSmilies();
                }
            }
            if (setting.equals("liveStreamsSorting") || setting.equals("liveStreamsSortingFav") || setting.equals("liveStreamsFavsOnly")) {
                MainGui.this.updateLiveStreamsDialog();
            }
            if (setting.equals("followersCompact") || setting.equals("followersReg")) {
                MainGui.this.updateFollowerDialogs();
            }
            if (setting.equals("historyRange")) {
                MainGui.this.updateHistoryRange();
            }
            if (setting.equals("historyVerticalZoom")) {
                MainGui.this.updateHistoryVerticalZoom();
            }
            if ((notificationSettings = new HashSet<String>(Arrays.asList("nScreen", "nPosition", "nDisplayTime", "nMaxDisplayTime", "nMaxDisplayed", "nMaxQueueSize", "nActivity", "nActivityTime", "nKeepOpenOnHover"))).contains(setting)) {
                MainGui.this.updateNotificationSettings();
            }
            if (setting.equals("spamProtection")) {
                MainGui.this.client.setLinesPerSeconds((String)value);
            }
            if (setting.equals("urlCommandEnabled")) {
                UrlOpener.setCustomCommandEnabled((Boolean)value);
            }
            if (setting.equals("urlCommand")) {
                UrlOpener.setCustomCommand((String)value);
            }
            if (setting.equals("abUniqueCats")) {
                MainGui.this.client.addressbook.setSomewhatUniqueCategories((String)value);
            }
            if (setting.equals("commands")) {
                MainGui.this.client.updateCustomCommands();
            }
            if (setting.equals("channelContextMenu") || setting.equals("userContextMenu") || setting.equals("livestreamerQualities") || setting.equals("streamsContextMenu") || setting.equals("textContextMenu") || setting.equals("adminContextMenu")) {
                MainGui.this.updateCustomContextMenuEntries();
            } else if (setting.equals("chatScrollbarAlways") || setting.equals("userlistWidth")) {
                MainGui.this.updateChannelsSettings();
            } else if (setting.equals("ignoredEmotes")) {
                List data = MainGui.this.client.settings.getList("ignoredEmotes");
                MainGui.this.emoticons.setIgnoredEmotes(data);
                MainGui.this.emotesDialog.update();
            } else if (LaF.shouldUpdate(setting)) {
                MainGui.this.updateLaF();
            } else if (setting.equals("tabsPos") && MainGui.this.client.settings.getBoolean("tabsAutoSort")) {
                MainGui.this.channels.sortContent(null);
            }
        }
    }

    private class MySettingsListener
    implements SettingsListener {
        private MySettingsListener() {
        }

        @Override
        public void aboutToSaveSettings(Settings settings) {
            GuiUtil.edtAndWait(() -> {
                System.out.println("Saving GUI settings.");
                MainGui.this.client.settings.setLong("favoritesSorting", MainGui.this.favoritesDialog.getSorting());
                MainGui.this.emoticons.saveFavoritesToSettings(settings);
                MainGui.this.client.settings.setString("statusHistorySorting", MainGui.this.adminDialog.getStatusHistorySorting());
                MainGui.this.client.settings.putList("emoteHiddenSets", MainGui.this.emotesDialog.getHiddenEmotesets());
            }, "Save GUI settings");
        }
    }

    private class MainMenuListener
    implements ItemListener,
    ActionListener,
    MenuListener {
        private MainMenuListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean state;
            String setting = MainGui.this.menu.getSettingByMenuItem(e.getSource());
            boolean bl = state = e.getStateChange() == 1;
            if (setting != null) {
                MainGui.this.client.settings.setBoolean(setting, state);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("debug")) {
                if (!MainGui.this.debugWindow.isShowing()) {
                    MainGui.this.debugWindow.setLocationByPlatform(true);
                    MainGui.this.debugWindow.setPreferredSize(new Dimension(500, 400));
                }
                MainGui.this.debugWindow.setVisible(true);
            } else if (cmd.equals("connect")) {
                MainGui.this.openConnectDialogInternal(null);
            } else if (cmd.equals("disconnect")) {
                MainGui.this.client.disconnect();
            } else if (cmd.equals("about")) {
                MainGui.this.openHelp("");
            } else if (!cmd.equals("news")) {
                if (cmd.equals("settings")) {
                    MainGui.this.getSettingsDialog(s -> s.showSettings());
                } else if (cmd.equals("saveSettings")) {
                    int result = JOptionPane.showOptionDialog(MainGui.this, Language.getString("saveSettings.text") + "\n\n" + Language.getString("saveSettings.textBackup"), Language.getString("saveSettings.title"), 2, 3, null, new String[]{Language.getString("dialog.button.save"), Language.getString("saveSettings.saveAndBackup"), Language.getString("dialog.button.cancel")}, null);
                    if (result == 0) {
                        List<FileManager.SaveResult> saveResult = MainGui.this.client.saveSettings(false, true);
                        JOptionPane.showMessageDialog(MainGui.this, Helper.makeSaveResultInfo(saveResult), Language.getString("saveSettings.title"), 1);
                    } else if (result == 1) {
                        List<FileManager.SaveResult> saveResult = MainGui.this.client.saveSettings(false, true);
                        List<FileManager.SaveResult> backupResult = MainGui.this.client.manualBackup();
                        JOptionPane.showMessageDialog(MainGui.this, Helper.makeSaveResultInfo(saveResult) + "\nManual Backup:\n" + Helper.makeSaveResultInfo(backupResult), Language.getString("saveSettings.title"), 1);
                    }
                } else if (cmd.equals("website")) {
                    UrlOpener.openUrlPrompt(MainGui.this, "https://chatty.github.io", true);
                } else if (cmd.equals("unhandledException")) {
                    String[] array = new String[]{};
                    String string = array[1];
                } else if (cmd.equals("errorTest")) {
                    Logger.getLogger(MainGui.class.getName()).log(Level.SEVERE, null, new ArrayIndexOutOfBoundsException(2));
                } else if (cmd.equals("addressbook")) {
                    MainGui.this.openAddressbook(null);
                } else if (cmd.equals("srlRaces")) {
                    MainGui.this.openSrlRaces();
                } else if (cmd.equals("srlRaceActive")) {
                    MainGui.this.srl.searchRaceWithEntrant(MainGui.this.channels.getActiveChannel().getStreamName());
                } else if (cmd.startsWith("srlRace4")) {
                    String stream = cmd.substring(8);
                    if (!stream.isEmpty()) {
                        MainGui.this.srl.searchRaceWithEntrant(stream);
                    }
                } else if (cmd.equals("configureLogin")) {
                    MainGui.this.openTokenDialog();
                } else if (cmd.equals("addStreamHighlight")) {
                    MainGui.this.client.commandAddStreamHighlight(MainGui.this.channels.getActiveChannel().getRoom(), null);
                } else if (cmd.equals("openStreamHighlights")) {
                    MainGui.this.client.commandOpenStreamHighlights(MainGui.this.channels.getActiveChannel().getRoom());
                } else if (cmd.equals("srcOpen")) {
                    MainGui.this.client.speedruncom.openCurrentGame(MainGui.this.channels.getActiveChannel());
                } else if (cmd.startsWith("room:")) {
                    String channel = cmd.substring("room:".length());
                    MainGui.this.client.joinChannel(channel);
                } else if (cmd.equals("dialog.chattyInfo")) {
                    MainGui.this.openEventLog(1);
                } else if (cmd.equals("layouts.add")) {
                    MainGui.this.addLayout(null);
                } else if (cmd.startsWith("layouts.load.")) {
                    String layoutName = cmd.substring("layouts.load.".length());
                    MainGui.this.loadLayout(layoutName, -1);
                } else if (cmd.startsWith("layouts.save.")) {
                    String layoutName = cmd.substring("layouts.save.".length());
                    MainGui.this.saveLayout(layoutName, true);
                } else if (cmd.startsWith("layouts.remove.")) {
                    String layoutName = cmd.substring("layouts.remove.".length());
                    MainGui.this.removeLayout(layoutName, true);
                } else if (cmd.equals("transparency")) {
                    TransparencyDialog dialog = TransparencyDialog.instance(MainGui.this);
                    dialog.setLocationRelativeTo(MainGui.this);
                    dialog.setVisible(true);
                    dialog.refresh();
                } else if (cmd.startsWith("customTab.")) {
                    String name = cmd.substring("customTab.".length());
                    MainGui.this.routingManager.selectTarget(name);
                }
            }
        }

        @Override
        public void menuSelected(MenuEvent e) {
            if (e.getSource() == ((MainGui)MainGui.this).menu.srlStreams) {
                ArrayList<String> popoutStreams = new ArrayList<String>();
                String activeStream = MainGui.this.channels.getActiveChannel().getStreamName();
                for (DockContent c : MainGui.this.channels.getDock().getPopoutContents()) {
                    Channel channel;
                    if (!(c instanceof Channels.DockChannelContainer) || (channel = (Channel)((Channels.DockChannelContainer)c).getContent()).getStreamName() == null || channel.getStreamName().equals(activeStream)) continue;
                    popoutStreams.add(channel.getStreamName());
                }
                MainGui.this.menu.updateSrlStreams(activeStream, popoutStreams);
            } else if (e.getSource() == ((MainGui)MainGui.this).menu.view) {
                MainGui.this.menu.updateCount(MainGui.this.highlightedMessages.getNewCount(), MainGui.this.highlightedMessages.getDisplayedCount(), MainGui.this.ignoredMessages.getNewCount(), MainGui.this.ignoredMessages.getDisplayedCount());
            } else if (e.getSource() == ((MainGui)MainGui.this).menu.layoutsMenu) {
                MainGui.this.menu.updateLayouts(Helper.getLayoutsFromSettings(MainGui.this.client.settings));
            } else if (e.getSource() == ((MainGui)MainGui.this).menu.customTabsMenu) {
                MainGui.this.menu.updateCustomTabs(MainGui.this.routingManager.getInfo());
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }

    private class MainWindowListener
    extends WindowAdapter {
        private boolean liveStreamsHidden;

        private MainWindowListener() {
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            if (e.getComponent() == MainGui.this) {
                MainGui.this.saveState(e.getComponent());
                if (MainGui.this.isMinimized()) {
                    if (MainGui.this.liveStreamsDialog.isVisible() && MainGui.this.client.settings.getBoolean("hideStreamsOnMinimize") && !MainGui.this.liveStreamsDialog.isDocked()) {
                        MainGui.this.liveStreamsDialog.setVisible(false);
                        this.liveStreamsHidden = true;
                    }
                    if (MainGui.this.client.settings.getBoolean("minimizeToTray")) {
                        MainGui.this.minimizeToTray();
                    }
                } else {
                    MainGui.this.cleanupAfterRestoredFromTray();
                    if (this.liveStreamsHidden) {
                        MainGui.this.liveStreamsDialog.setVisible(true);
                        this.liveStreamsHidden = false;
                    }
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (evt.getComponent() == MainGui.this) {
                if (MainGui.this.client.settings.getBoolean("closeToTray")) {
                    MainGui.this.minimizeToTray();
                } else {
                    MainGui.this.exit();
                }
            }
        }
    }
}

