/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.gui.GuiUtil;
import chatty.gui.components.routing.RoutingTargetInfo;
import chatty.gui.components.settings.SettingsUtil;
import chatty.lang.Language;
import chatty.util.dnd.DockLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.MenuListener;

public class MainMenu
extends JMenuBar {
    private final JMenu main = new JMenu(Language.getString("menubar.menu.main"));
    protected final JMenu view = new JMenu(Language.getString("menubar.menu.view"));
    protected final JMenu customTabsMenu = new JMenu("Custom Tabs");
    protected final JMenu channels = new JMenu(Language.getString("menubar.menu.channels"));
    private final JMenu srl = new JMenu(Language.getString("menubar.menu.srl"));
    protected final JMenu srlStreams = new JMenu("Races with..");
    private final JMenu extra = new JMenu(Language.getString("menubar.menu.extra"));
    private final JMenu help = new JMenu(Language.getString("menubar.menu.help"));
    protected final JMenu layoutsMenu = new JMenu("Layouts");
    private final JMenuItem highlights;
    private final JMenuItem ignored;
    private final ItemListener itemListener;
    private final ActionListener actionListener;
    private final String IGNORED_LABEL = Language.getString("menubar.dialog.ignoredMessages");
    private final String HIGHLIGHTS_LABEL = Language.getString("menubar.dialog.highlightedMessages");
    private final NotifyIcons notifyIcons = new NotifyIcons();
    private final HashMap<String, JMenuItem> menuItems = new HashMap();

    public MainMenu(ActionListener actionListener, ItemListener itemListener) {
        this.itemListener = itemListener;
        this.actionListener = actionListener;
        this.main.addActionListener(actionListener);
        this.view.addActionListener(actionListener);
        this.channels.addActionListener(actionListener);
        this.channels.addMenuListener((MenuListener)((Object)itemListener));
        this.srl.addActionListener(actionListener);
        this.extra.addActionListener(actionListener);
        this.help.addActionListener(actionListener);
        this.view.addMenuListener((MenuListener)((Object)itemListener));
        this.layoutsMenu.addMenuListener((MenuListener)((Object)itemListener));
        this.customTabsMenu.addMenuListener((MenuListener)((Object)itemListener));
        this.main.setMnemonic(77);
        this.view.setMnemonic(86);
        this.channels.setMnemonic(67);
        this.srl.setMnemonic(83);
        this.extra.setMnemonic(69);
        this.help.setMnemonic(72);
        this.addItem(this.main, "connect", Language.getString("menubar.dialog.connect"));
        this.addItem(this.main, "disconnect", Language.getString("menubar.action.disconnect")).setEnabled(false);
        this.main.addSeparator();
        this.setIcon(this.addItem(this.main, "settings", Language.getString("menubar.dialog.settings"), 83), "preferences-system.png");
        this.addItem(this.main, "configureLogin", Language.getString("menubar.dialog.login"));
        this.main.addSeparator();
        this.addItem(this.main, "saveSettings", Language.getString("menubar.dialog.save"));
        this.main.addSeparator();
        this.addItem(this.main, "application.exit");
        this.addCheckboxItemSetting(this.view, "ontop");
        JMenu viewOptions = new JMenu(Language.getString("menubar.menu.options"));
        JMenu titleOptions = new JMenu(Language.getString("menubar.menu.titlebar"));
        this.addCheckboxItemSetting(titleOptions, "titleShowUptime");
        this.addCheckboxItemSetting(titleOptions, "titleLongerUptime");
        this.addCheckboxItemSetting(titleOptions, "titleShowChannelState");
        this.addCheckboxItemSetting(titleOptions, "titleShowViewerCount");
        this.addCheckboxItemSetting(titleOptions, "titleConnections");
        titleOptions.addSeparator();
        this.addCheckboxItemSetting(titleOptions, "simpleTitle");
        viewOptions.add(titleOptions);
        this.addCheckboxItemSetting(viewOptions, "showJoinsParts");
        this.addCheckboxItemSetting(viewOptions, "showModMessages");
        this.addCheckboxItemSetting(viewOptions, "attachedWindows");
        this.addCheckboxItemSetting(viewOptions, "mainResizable");
        this.view.add(viewOptions);
        this.view.addSeparator();
        this.addItem(this.view, "dialog.channelInfo");
        this.addItem(this.view, "dialog.channelAdmin");
        this.view.addSeparator();
        this.highlights = this.addItem(this.view, "dialog.highlightedMessages", this.HIGHLIGHTS_LABEL);
        this.ignored = this.addItem(this.view, "dialog.ignoredMessages", this.IGNORED_LABEL);
        this.view.addSeparator();
        this.addItem(this.view, "dialog.eventLog");
        this.addItem(this.view, "window.toggleUserlist");
        this.view.addSeparator();
        this.addItem(this.view, "dialog.search");
        this.view.addSeparator();
        this.view.add(this.layoutsMenu);
        this.view.add(this.customTabsMenu);
        this.addItem(this.channels, "dialog.favorites");
        this.addItem(this.channels, "dialog.streams");
        this.addItem(this.channels, "dialog.addressbook");
        this.channels.addSeparator();
        this.addItem(this.channels, "dialog.joinChannel");
        this.addItem(this.srl, "srlRaces", "Race List");
        this.srl.addSeparator();
        this.srl.add(this.srlStreams);
        this.srlStreams.addMenuListener((MenuListener)((Object)itemListener));
        this.addItem(this.extra, "dialog.livestreamer");
        this.addItem(this.extra, "dialog.toggleEmotes");
        this.extra.addSeparator();
        this.addItem(this.extra, "dialog.followers");
        this.addItem(this.extra, "dialog.subscribers");
        this.extra.addSeparator();
        this.addItem(this.extra, "dialog.moderationLog");
        this.addItem(this.extra, "dialog.autoModDialog");
        this.extra.addSeparator();
        JMenu streamChat = new JMenu("Stream Chat");
        this.addItem(streamChat, "dialog.streamchat");
        this.addCheckboxItem(streamChat, "streamChatResizable", "Resizable");
        this.extra.add(streamChat);
        JMenu streamHighlights = new JMenu("Stream Highlights");
        streamHighlights.setMnemonic(72);
        this.addItem(streamHighlights, "stream.addhighlight", "Add Stream Highlight");
        this.addItem(streamHighlights, "openStreamHighlights", "Open Stream Highlights");
        this.extra.add(streamHighlights);
        this.extra.addSeparator();
        this.addItem(this.extra, "transparency", "Transparency");
        this.extra.addSeparator();
        JMenu debugOptions = new JMenu("Options");
        this.addCheckboxItem(debugOptions, "globalHotkeysEnabled", "Global Hotkeys");
        this.extra.add(debugOptions);
        this.addItem(this.extra, "debug", "Debug window");
        this.addItem(this.help, "website", Language.getString("menubar.action.openWebsite"));
        JMenuItem helpItem = this.addItem(this.help, "about", "About/Help", 72);
        helpItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        this.setIcon(helpItem, "help-browser.png");
        this.help.addSeparator();
        this.addItem(this.help, "dialog.updates");
        this.add(this.main);
        this.add(this.view);
        this.add(this.channels);
        this.add(this.extra);
        this.add(this.help);
    }

    public final JMenuItem addItem(JMenu menu, String key, String label, int mnemonic) {
        JMenuItem item = new JMenuItem(label);
        if (mnemonic != -1) {
            item.setMnemonic(mnemonic);
        }
        this.menuItems.put(key, item);
        item.setActionCommand(key);
        menu.add(item);
        item.addActionListener(this.actionListener);
        return item;
    }

    public final JMenuItem addItem(JMenu menu, String key) {
        return this.addItem(menu, key, Language.getString("menubar." + key));
    }

    public final JMenuItem addItem(JMenu menu, String key, String label) {
        return this.addItem(menu, key, label, -1);
    }

    public final void setAction(String key, Action action) {
        JMenuItem item = this.menuItems.get(key);
        Icon icon = item.getIcon();
        item.setAction(action);
        item.setIcon(icon);
    }

    public final JMenuItem addCheckboxItem(JMenu menu, String key, String label) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(label);
        this.menuItems.put(key, item);
        item.setActionCommand(key);
        menu.add(item);
        item.addItemListener(this.itemListener);
        return item;
    }

    public final JMenuItem addCheckboxItemSetting(JMenu menu, String key) {
        JMenuItem item = this.addCheckboxItem(menu, key, Language.getString("menubar.setting." + key));
        String tooltip = Language.getStringNull("menubar.setting." + key + ".tip");
        if (tooltip != null) {
            item.setToolTipText(SettingsUtil.addTooltipLinebreaks(tooltip));
        }
        return item;
    }

    public JMenuItem getMenuItem(String key) {
        return this.menuItems.get(key);
    }

    public String getSettingByMenuItem(Object item) {
        for (Map.Entry<String, JMenuItem> entry : this.menuItems.entrySet()) {
            if (entry.getValue() != item) continue;
            return entry.getKey();
        }
        return null;
    }

    public void setItemState(String setting, boolean state) {
        JMenuItem item = this.getMenuItem(setting);
        if (item != null && item instanceof JCheckBoxMenuItem) {
            ((JCheckBoxMenuItem)item).setState(state);
        }
    }

    private void setIcon(JMenuItem item, String name) {
        item.setIcon(new ImageIcon(MainMenu.class.getResource(name)));
    }

    public void updateCount(int highlightsCountNew, int highlightsCount, int ignoredCountNew, int ignoredCount) {
        this.highlights.setText(this.buildCount(this.HIGHLIGHTS_LABEL, highlightsCountNew, highlightsCount));
        this.ignored.setText(this.buildCount(this.IGNORED_LABEL, ignoredCountNew, ignoredCount));
    }

    private String buildCount(String label, int countNew, int count) {
        if (count == 0) {
            return label;
        }
        return label + " (" + countNew + "/" + count + ")";
    }

    public void updateSrlStreams(String active, List<String> popout) {
        this.srlStreams.removeAll();
        if (active == null || active.isEmpty()) {
            this.addItem(this.srlStreams, "", "No channel joined");
        } else {
            this.addItem(this.srlStreams, "srlRaceActive", active);
        }
        if (!popout.isEmpty()) {
            this.srlStreams.addSeparator();
            for (String chan : popout) {
                this.addItem(this.srlStreams, "srlRace4" + chan, chan);
            }
        }
    }

    public void updateLayouts(Map<String, DockLayout> layouts) {
        layouts.remove("");
        this.layoutsMenu.removeAll();
        if (!layouts.isEmpty()) {
            for (Map.Entry<String, DockLayout> entry : layouts.entrySet()) {
                JMenu submenu = new JMenu(entry.getKey());
                this.addItem(submenu, "layouts.load." + entry.getKey(), "Load").setToolTipText("Load this layout (you'll still have the chance to cancel loading)");
                submenu.addSeparator();
                this.addItem(submenu, "layouts.remove." + entry.getKey(), "Remove");
                this.addItem(submenu, "layouts.save." + entry.getKey(), "Overwrite").setToolTipText("");
                this.layoutsMenu.add(submenu);
            }
            this.layoutsMenu.addSeparator();
        }
        this.addItem(this.layoutsMenu, "layouts.add", "Add");
    }

    public void updateCustomTabs(List<RoutingTargetInfo> infos) {
        this.customTabsMenu.removeAll();
        if (infos.isEmpty()) {
            this.addItem(this.customTabsMenu, "", "No custom tabs").setEnabled(false);
        } else {
            for (RoutingTargetInfo info : infos) {
                String label = info.name;
                if (info.messages > -1) {
                    label = String.format("%s (%d)", info.name, info.messages);
                }
                this.addItem(this.customTabsMenu, "customTab." + info.name, label);
            }
        }
    }

    public void setUpdateNotification(boolean enabled) {
        this.notifyIcons.addItem("update", 1, "Update", "download.png", unused -> {
            String id = "dialog.updates";
            this.menuItems.get(id).getAction().actionPerformed(new ActionEvent(this, 1001, id));
        });
    }

    public void setSystemEventCount(int count) {
        if (count > 0) {
            this.notifyIcons.addItem("chattyInfo", 0, "Events: " + String.valueOf(count), "warning.png", id -> this.actionListener.actionPerformed(new ActionEvent(this, 1001, "dialog.chattyInfo")));
        } else {
            this.notifyIcons.removeItem("chattyInfo");
        }
    }

    private class NotifyIcons {
        private final Map<String, JMenu> current = new HashMap<String, JMenu>();
        private final Map<JMenu, Integer> targetPositions = new HashMap<JMenu, Integer>();
        private final Map<JMenu, Boolean> flashing = new HashMap<JMenu, Boolean>();
        private final Component glue = Box.createHorizontalGlue();

        private NotifyIcons() {
        }

        public void addItem(final String id, int pos, String text, String imageFile, final Consumer<String> consumer) {
            JMenu label = this.current.get(id);
            if (label == null) {
                label = new JMenu();
                int iconSize = label.getFontMetrics(label.getFont()).getHeight();
                ImageIcon icon = GuiUtil.getScaledIcon(GuiUtil.getIcon(this, imageFile), iconSize, iconSize);
                label.setIcon(icon);
                label.setIconTextGap(0);
                label.setCursor(Cursor.getPredefinedCursor(12));
                label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 4));
                label.setToolTipText(Language.getStringNull("menubar.notification." + id));
                JMenuItem item = new JMenuItem(new AbstractAction(Language.getString("menubar.notification.view")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        consumer.accept(id);
                    }
                });
                label.add(item);
                if (this.current.isEmpty()) {
                    MainMenu.this.add(this.glue);
                }
                MainMenu.this.add((Component)label, this.findInsertionPos(pos));
                this.current.put(id, label);
                this.targetPositions.put(label, pos);
                MainMenu.this.revalidate();
                MainMenu.this.repaint();
            }
            if (!label.getText().equals(text)) {
                this.flash(label);
            }
            label.setText(text);
        }

        private int findInsertionPos(int targetPos) {
            for (int i = 0; i < MainMenu.this.getComponentCount(); ++i) {
                Component c = MainMenu.this.getComponent(i);
                Integer cPos = this.targetPositions.get(c);
                if (cPos == null || targetPos > cPos) continue;
                return i;
            }
            return MainMenu.this.getComponentCount();
        }

        private void flash(JMenu label) {
            Icon icon = label.getIcon();
            if (icon != null && !this.flashing.containsKey(label)) {
                this.flashing.put(label, Boolean.TRUE);
                ImageIcon grayIcon = GuiUtil.createEmptyIcon(icon.getIconWidth(), icon.getIconHeight());
                Timer timer = new Timer(450, e -> {
                    if (label.getIcon() == icon) {
                        label.setIcon(grayIcon);
                    } else {
                        label.setIcon(icon);
                    }
                });
                timer.setRepeats(true);
                timer.start();
                Timer timer2 = new Timer(3000, e -> {
                    timer.stop();
                    label.setIcon(icon);
                    this.flashing.remove(label);
                });
                timer2.setRepeats(false);
                timer2.start();
            }
        }

        public void removeItem(String id) {
            JMenu label = this.current.get(id);
            if (label != null) {
                MainMenu.this.remove(label);
                this.current.remove(id);
                this.targetPositions.remove(label);
                if (this.current.isEmpty()) {
                    MainMenu.this.remove(this.glue);
                }
                MainMenu.this.revalidate();
                MainMenu.this.repaint();
            }
        }
    }
}

