/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.util.StringUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class NamedColor
extends Color {
    private final String name;
    private final Set<String> names;
    private final Set<String> namesLowercase;

    public NamedColor(String name, int r, int g, int b) {
        super(r, g, b);
        if (name == null) {
            name = "";
        }
        this.name = name;
        this.names = new HashSet<String>();
        this.names.add(name);
        this.namesLowercase = new HashSet<String>();
        this.namesLowercase.add(StringUtil.toLowerCase(name));
    }

    public NamedColor(String[] namesArray, int r, int g, int b) {
        super(r, g, b);
        this.names = new HashSet<String>();
        this.names.addAll(Arrays.asList(namesArray));
        this.namesLowercase = new HashSet<String>();
        for (String thisName : namesArray) {
            this.namesLowercase.add(StringUtil.toLowerCase(thisName));
        }
        this.name = namesArray.length == 0 ? "" : namesArray[0];
    }

    public String getName() {
        return this.name;
    }

    public boolean hasName(String nameToCheck) {
        return this.namesLowercase.contains(StringUtil.toLowerCase(nameToCheck));
    }

    @Override
    public String toString() {
        return super.toString() + this.names;
    }

    public String getRgbString() {
        return this.getRed() + "," + this.getGreen() + "," + this.getBlue();
    }
}

