/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.gui.components.SimplePopup;
import chatty.lang.Language;
import chatty.util.StringUtil;
import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class RegexDocumentFilter
extends DocumentFilter {
    private final Pattern pattern;
    private final SimplePopup popup;
    private String latestFiltered = "";

    public RegexDocumentFilter(String regex, Component popupOwner) {
        this.pattern = Pattern.compile(regex);
        this.popup = popupOwner != null ? new SimplePopup(popupOwner, () -> {
            this.latestFiltered = "";
        }) : null;
    }

    public String getRegex() {
        return this.pattern.pattern();
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int off, String str, AttributeSet attr) {
        try {
            fb.insertString(off, this.getFiltered(str), attr);
        }
        catch (NullPointerException | BadLocationException exception) {
            // empty catch block
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int off, int len, String str, AttributeSet attr) {
        try {
            if (str == null) {
                fb.replace(off, len, str, attr);
            } else {
                fb.replace(off, len, this.getFiltered(str), attr);
            }
        }
        catch (NullPointerException | BadLocationException exception) {
            // empty catch block
        }
    }

    private String getFiltered(String input) {
        Matcher m = this.pattern.matcher(input);
        boolean result = m.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            StringBuilder filtered = new StringBuilder();
            do {
                m.appendReplacement(sb, "");
                filtered.append(m.group());
            } while (result = m.find());
            m.appendTail(sb);
            this.showPopup(filtered.toString());
            return sb.toString();
        }
        return input;
    }

    private void showPopup(String filtered) {
        if (this.popup == null) {
            return;
        }
        this.latestFiltered = this.latestFiltered + filtered;
        this.popup.showPopup(String.format("%s '%s'", Language.getString("dialog.error.invalidInput"), StringUtil.shortenTo(this.latestFiltered, 100)));
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame();
            JTextField text = new JTextField();
            ((AbstractDocument)text.getDocument()).setDocumentFilter(new RegexDocumentFilter("[^0-9.]", text));
            frame.add((Component)text, "South");
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        });
    }
}

