/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.gui.StyleServer;
import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.components.textpane.MyStyleConstants;
import chatty.util.Timestamp;
import chatty.util.colors.ColorCorrector;
import chatty.util.colors.HtmlColors;
import chatty.util.settings.Settings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class StyleManager
implements StyleServer {
    private static final Logger LOGGER = Logger.getLogger(StyleManager.class.getName());
    public static final Set<String> settingNames = new HashSet<String>(Arrays.asList("font", "fontSize", "timestampEnabled", "emoticonsEnabled", "foregroundColor", "infoColor", "compactColor", "backgroundColor", "backgroundColor2", "alternateBackground", "messageSeparator", "separatorColor", "bottomMargin", "inputBackgroundColor", "inputForegroundColor", "usericonsEnabled", "timestamp", "timestampColor", "timestampColorEnabled", "timestampFontEnabled", "timestampFont", "timestampColorInherit", "highlightColor", "highlightBackgroundColor", "highlightBackground", "showBanMessages", "autoScroll", "deletedMessagesMode", "deletedMessagesMaxLength", "searchResultColor", "lineSpacing", "bufferSize", "actionColored", "combineBanMessages", "timestampTimezone", "autoScrollTimeout", "searchResultColor2", "inputFont", "emoteScale", "emoteMaxHeight", "usericonScale", "emoteScaleGigantified", "customUsericonScaleMode", "botBadgeEnabled", "filterCombiningCharacters", "pauseChatOnMouseMove", "pauseChatOnMouseMoveCtrlRequired", "animatedEmotes", "streamChatLogos", "banReasonAppended", "banDurationAppended", "banDurationMessage", "banReasonMessage", "displayNamesMode", "paragraphSpacing", "bufferSizes", "userlistFont", "showImageTooltips", "showTooltipImages", "highlightMatches", "nickColorCorrection", "mentions", "mentionsInfo", "markHoveredUser", "highlightMatchesAll", "nickColorBackground", "mentionMessages", "msgColorsLinks", "sharedBadges", "sharedLogoSize", "sharedLogoAlways", "inputHistoryMultirowRequireCtrl"));
    private MutableAttributeSet baseStyle;
    private MutableAttributeSet standardStyle;
    private MutableAttributeSet timestampStyle;
    private MutableAttributeSet specialStyle;
    private MutableAttributeSet infoStyle;
    private MutableAttributeSet paragraphStyle;
    private MutableAttributeSet other;
    private MutableAttributeSet highlightStyle;
    private Font inputFont;
    private Font userlistFont;
    private Color backgroundColor;
    private Color foregroundColor;
    private Color inputBackgroundColor;
    private Color inputForegroundColor;
    private Color highlightColor;
    private Color highlightBackgroundColor;
    private Color searchResultColor;
    private Color searchResultColor2;
    private Color infoColor;
    private ColorCorrector colorCorrector;
    private final Settings settings;
    private final Component dummyComponent = new JDialog();

    public StyleManager(Settings settings) {
        this.settings = settings;
        this.makeStyles();
    }

    public void refresh() {
        LOGGER.info("Refreshing styles..");
        this.makeStyles();
    }

    private void makeStyles() {
        this.inputFont = Font.decode(this.settings.getString("inputFont"));
        this.userlistFont = Font.decode(this.settings.getString("userlistFont"));
        this.foregroundColor = this.makeColor("foregroundColor", Color.BLACK);
        HtmlColors.setDefaultColor(this.foregroundColor);
        this.backgroundColor = this.makeColor("backgroundColor");
        this.inputBackgroundColor = this.makeColor("inputBackgroundColor");
        this.inputForegroundColor = this.makeColor("inputForegroundColor");
        this.highlightColor = this.makeColor("highlightColor");
        this.highlightBackgroundColor = this.settings.getBoolean("highlightBackground") ? this.makeColor("highlightBackgroundColor", null) : null;
        this.searchResultColor = this.makeColor("searchResultColor");
        this.searchResultColor2 = this.makeColor("searchResultColor2");
        this.infoColor = this.makeColor("infoColor");
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        String fontFamily = this.settings.getString("font");
        int fontSize = (int)this.settings.getLong("fontSize");
        this.baseStyle = new SimpleAttributeSet(defaultStyle);
        StyleConstants.setFontFamily(this.baseStyle, fontFamily);
        StyleConstants.setFontSize(this.baseStyle, fontSize);
        this.standardStyle = new SimpleAttributeSet(this.baseStyle);
        StyleConstants.setForeground(this.standardStyle, this.makeColor("foregroundColor"));
        this.timestampStyle = new SimpleAttributeSet();
        this.timestampStyle.addAttribute((Object)ChannelTextPane.Attribute.TIME_CREATED, System.currentTimeMillis());
        if (this.settings.getBoolean("timestampFontEnabled") || this.settings.getBoolean("timestampColorEnabled")) {
            if (this.settings.getBoolean("timestampFontEnabled")) {
                Font font = Font.decode(this.settings.getString("timestampFont"));
                StyleConstants.setFontFamily(this.timestampStyle, font.getName());
                StyleConstants.setFontSize(this.timestampStyle, font.getSize());
                StyleConstants.setBold(this.timestampStyle, font.isBold());
                StyleConstants.setItalic(this.timestampStyle, font.isItalic());
            }
            if (this.settings.getBoolean("timestampColorEnabled")) {
                StyleConstants.setForeground(this.timestampStyle, this.makeColor("timestampColor"));
                String inherit = this.settings.getString("timestampColorInherit");
                if (!inherit.equals("off")) {
                    try {
                        float inheritFactor = 1.0f - (float)Integer.parseInt(inherit) / 100.0f;
                        inheritFactor = Math.min(inheritFactor, 1.0f);
                        this.timestampStyle.addAttribute((Object)ChannelTextPane.Attribute.TIMESTAMP_COLOR_INHERIT, Float.valueOf(inheritFactor));
                    }
                    catch (NumberFormatException inheritFactor) {
                        // empty catch block
                    }
                }
            }
        }
        this.highlightStyle = new SimpleAttributeSet(this.baseStyle);
        StyleConstants.setForeground(this.highlightStyle, this.highlightColor);
        this.specialStyle = new SimpleAttributeSet(this.baseStyle);
        StyleConstants.setForeground(this.specialStyle, this.makeColor("compactColor"));
        this.infoStyle = new SimpleAttributeSet(this.baseStyle);
        StyleConstants.setForeground(this.infoStyle, this.makeColor("infoColor"));
        this.paragraphStyle = new SimpleAttributeSet();
        float spacing = (float)this.settings.getLong("lineSpacing") / 10.0f;
        StyleConstants.setLineSpacing(this.paragraphStyle, spacing);
        this.paragraphStyle.addAttribute((Object)ChannelTextPane.Attribute.PARAGRAPH_SPACING, this.settings.getLong("paragraphSpacing"));
        MyStyleConstants.setBackground2(this.paragraphStyle, this.settings.getBoolean("alternateBackground") ? this.makeColor("backgroundColor2", null) : null);
        MyStyleConstants.setHighlightBackground(this.paragraphStyle, this.highlightBackgroundColor);
        MyStyleConstants.setSeparatorColor(this.paragraphStyle, this.settings.getBoolean("messageSeparator") ? this.makeColor("separatorColor", null) : null);
        MyStyleConstants.setFontHeight(this.paragraphStyle, this.dummyComponent.getFontMetrics(new Font(fontFamily, 0, fontSize)).getHeight());
        MyStyleConstants.setHighlightMatchesEnabled(this.paragraphStyle, this.settings.getBoolean("highlightMatches"));
        this.other = new SimpleAttributeSet();
        this.addBooleanSetting(ChannelTextPane.Setting.EMOTICONS_ENABLED, "emoticonsEnabled");
        this.addLongSetting(ChannelTextPane.Setting.EMOTICON_SCALE_FACTOR, "emoteScale");
        this.addLongSetting(ChannelTextPane.Setting.EMOTICON_MAX_HEIGHT, "emoteMaxHeight");
        this.addLongSetting(ChannelTextPane.Setting.EMOTICON_SCALE_FACTOR_GIGANTIFIED, "emoteScaleGigantified");
        this.addLongSetting(ChannelTextPane.Setting.USERICON_SCALE_FACTOR, "usericonScale");
        this.addLongSetting(ChannelTextPane.Setting.CUSTOM_USERICON_SCALE_MODE, "customUsericonScaleMode");
        this.addBooleanSetting(ChannelTextPane.Setting.USERICONS_ENABLED, "usericonsEnabled");
        this.addBooleanSetting(ChannelTextPane.Setting.SHOW_BANMESSAGES, "showBanMessages");
        this.addBooleanSetting(ChannelTextPane.Setting.AUTO_SCROLL, "autoScroll");
        this.addLongSetting(ChannelTextPane.Setting.AUTO_SCROLL_TIME, "autoScrollTimeout");
        this.addBooleanSetting(ChannelTextPane.Setting.ACTION_COLORED, "actionColored");
        this.addLongSetting(ChannelTextPane.Setting.BUFFER_SIZE, "bufferSize");
        this.addBooleanSetting(ChannelTextPane.Setting.COMBINE_BAN_MESSAGES, "combineBanMessages");
        this.addBooleanSetting(ChannelTextPane.Setting.BAN_DURATION_APPENDED, "banDurationAppended");
        this.addBooleanSetting(ChannelTextPane.Setting.BAN_REASON_APPENDED, "banReasonAppended");
        this.addBooleanSetting(ChannelTextPane.Setting.BAN_DURATION_MESSAGE, "banDurationMessage");
        this.addBooleanSetting(ChannelTextPane.Setting.BAN_REASON_MESSAGE, "banReasonMessage");
        this.addBooleanSetting(ChannelTextPane.Setting.BOT_BADGE_ENABLED, "botBadgeEnabled");
        this.addBooleanSetting(ChannelTextPane.Setting.SHOW_TOOLTIPS, "showImageTooltips");
        this.addBooleanSetting(ChannelTextPane.Setting.SHOW_TOOLTIP_IMAGES, "showTooltipImages");
        this.addBooleanSetting(ChannelTextPane.Setting.HIGHLIGHT_MATCHES_ALL, "highlightMatchesAll");
        this.addBooleanSetting(ChannelTextPane.Setting.LINKS_CUSTOM_COLOR, "msgColorsLinks");
        this.addLongSetting(ChannelTextPane.Setting.HIGHLIGHT_HOVERED_USER, "markHoveredUser");
        this.addLongSetting(ChannelTextPane.Setting.FILTER_COMBINING_CHARACTERS, "filterCombiningCharacters");
        this.addBooleanSetting(ChannelTextPane.Setting.PAUSE_ON_MOUSEMOVE, "pauseChatOnMouseMove");
        this.addBooleanSetting(ChannelTextPane.Setting.PAUSE_ON_MOUSEMOVE_CTRL_REQUIRED, "pauseChatOnMouseMoveCtrlRequired");
        this.addBooleanSetting(ChannelTextPane.Setting.EMOTICONS_ANIMATED, "animatedEmotes");
        this.addLongSetting(ChannelTextPane.Setting.USERCOLOR_BACKGROUND, "nickColorBackground");
        this.addLongSetting(ChannelTextPane.Setting.BOTTOM_MARGIN, "bottomMargin");
        this.addLongSetting(ChannelTextPane.Setting.MENTIONS, "mentions");
        this.addLongSetting(ChannelTextPane.Setting.MENTIONS_INFO, "mentionsInfo");
        this.addLongSetting(ChannelTextPane.Setting.MENTION_MESSAGES, "mentionMessages");
        String deletedMessagesMode = this.settings.getString("deletedMessagesMode");
        long deletedMessagesModeNumeric = 0L;
        if (deletedMessagesMode.equals("delete")) {
            deletedMessagesModeNumeric = -1L;
        } else if (deletedMessagesMode.equals("keepShortened")) {
            deletedMessagesModeNumeric = this.settings.getLong("deletedMessagesMaxLength");
        }
        this.other.addAttribute((Object)ChannelTextPane.Setting.DELETED_MESSAGES_MODE, deletedMessagesModeNumeric);
        this.addLongSetting(ChannelTextPane.Setting.DISPLAY_NAMES_MODE, "displayNamesMode");
        this.addLongSetting(ChannelTextPane.Setting.SHARED_BADGES, "sharedBadges");
        this.addLongSetting(ChannelTextPane.Setting.SHARED_LOGO_SIZE, "sharedLogoSize");
        this.addBooleanSetting(ChannelTextPane.Setting.SHARED_LOGO_ALWAYS, "sharedLogoAlways");
        this.colorCorrector = ColorCorrector.get(this.settings.getString("nickColorCorrection"));
    }

    private void addBooleanSetting(ChannelTextPane.Setting key, String name) {
        this.other.addAttribute((Object)key, this.settings.getBoolean(name));
    }

    private void addLongSetting(ChannelTextPane.Setting key, String name) {
        this.other.addAttribute((Object)key, this.settings.getLong(name));
    }

    private Color makeColor(String setting) {
        return this.makeColor(setting, this.foregroundColor);
    }

    private Color makeColor(String setting, Color defaultColor) {
        return HtmlColors.decode(this.settings.getString(setting), defaultColor);
    }

    @Override
    public MutableAttributeSet getStyle(String type) {
        switch (type) {
            case "special": {
                return new SimpleAttributeSet(this.specialStyle);
            }
            case "standard": {
                return new SimpleAttributeSet(this.standardStyle);
            }
            case "timestamp": {
                return new SimpleAttributeSet(this.timestampStyle);
            }
            case "info": {
                return new SimpleAttributeSet(this.infoStyle);
            }
            case "highlight": {
                return new SimpleAttributeSet(this.highlightStyle);
            }
            case "paragraph": {
                return new SimpleAttributeSet(this.paragraphStyle);
            }
            case "settings": {
                return new SimpleAttributeSet(this.other);
            }
        }
        return new SimpleAttributeSet(this.baseStyle);
    }

    @Override
    public Font getFont(String type) {
        switch (type) {
            case "input": {
                return this.inputFont;
            }
            case "userlist": {
                return this.userlistFont;
            }
        }
        return null;
    }

    @Override
    public Color getColor(String type) {
        switch (type) {
            case "foreground": {
                return this.foregroundColor;
            }
            case "background": {
                return this.backgroundColor;
            }
            case "inputBackground": {
                return this.inputBackgroundColor;
            }
            case "inputForeground": {
                return this.inputForegroundColor;
            }
            case "searchResult": {
                return this.searchResultColor;
            }
            case "searchResult2": {
                return this.searchResultColor2;
            }
            case "info": {
                return this.infoColor;
            }
            case "highlight": {
                return this.highlightColor;
            }
            case "highlightBackground": {
                return this.highlightBackgroundColor;
            }
        }
        return this.foregroundColor;
    }

    @Override
    public Timestamp getTimestampFormat() {
        return this.makeTimestampFormat("timestamp");
    }

    public Timestamp makeTimestampFormat(String setting) {
        String timezone;
        String timestamp = this.settings.getString(setting);
        Timestamp timestampFormat = new Timestamp(timestamp, timezone = this.settings.getString("timestampTimezone"));
        if (timestampFormat.isEnabled()) {
            return timestampFormat;
        }
        return null;
    }

    @Override
    public ColorCorrector getColorCorrector() {
        return this.colorCorrector;
    }
}

