/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.lang.Language;
import chatty.util.IconManager;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;

public class TrayIconManager {
    private static final Logger LOGGER = Logger.getLogger(TrayIconManager.class.getName());
    private final SystemTray tray;
    private final TrayIcon trayIcon;
    private final PopupMenu popup;
    private boolean iconAdded;

    public TrayIconManager() {
        if (SystemTray.isSupported()) {
            this.tray = SystemTray.getSystemTray();
            this.popup = new PopupMenu();
            MenuItem showItem = new MenuItem(Language.getString("trayCm.show"));
            showItem.setActionCommand("show");
            this.popup.add(showItem);
            MenuItem exitItem = new MenuItem(Language.getString("trayCm.exit"));
            exitItem.setActionCommand("exit");
            this.popup.add(exitItem);
            Dimension iconDimension = this.tray.getTrayIconSize();
            int size = Math.min(iconDimension.width, iconDimension.height);
            LOGGER.info("Creating TrayIcon (" + iconDimension.width + "x" + iconDimension.height + ")");
            Image image = IconManager.getTrayIcon(size);
            this.trayIcon = new TrayIcon(image, "Chatty");
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.setPopupMenu(this.popup);
        } else {
            this.tray = null;
            this.trayIcon = null;
            this.popup = null;
        }
    }

    public void displayInfo(String title, String message) {
        if (this.trayIcon != null) {
            this.addIcon();
            this.trayIcon.displayMessage(title, message, TrayIcon.MessageType.NONE);
        }
    }

    public void setTooltipText(String text) {
        if (this.trayIcon != null) {
            this.trayIcon.setToolTip(text);
        }
    }

    public void addActionListener(final ActionListener listener) {
        if (this.trayIcon != null) {
            this.trayIcon.addActionListener(listener);
            this.trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isPopupTrigger() && e.getButton() == 1) {
                        if (e.getClickCount() % 2 == 0) {
                            listener.actionPerformed(new ActionEvent(e, 1001, "doubleClick"));
                        } else {
                            listener.actionPerformed(new ActionEvent(e, 1001, "singleClick"));
                        }
                    }
                }
            });
            this.popup.addActionListener(listener);
        }
    }

    private void addIcon() {
        if (this.tray != null && !this.iconAdded && !this.isIconAdded()) {
            try {
                this.tray.add(this.trayIcon);
                this.iconAdded = true;
            }
            catch (AWTException ex) {
                LOGGER.warning("Error adding tray icon: " + ex.getLocalizedMessage());
            }
        }
    }

    private void removeIcon() {
        if (this.iconAdded && this.tray != null) {
            this.tray.remove(this.trayIcon);
            this.iconAdded = false;
        }
    }

    private boolean isIconAdded() {
        for (TrayIcon icon : this.tray.getTrayIcons()) {
            if (icon != this.trayIcon) continue;
            return true;
        }
        return false;
    }

    public void setIconVisible(boolean visible) {
        if (visible) {
            this.addIcon();
        } else {
            this.removeIcon();
        }
    }

    public boolean isAvailable() {
        return SystemTray.isSupported() && this.isIconAdded();
    }
}

