/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.gui.components.settings.SettingsUtil;
import chatty.lang.Language;
import chatty.util.MiscUtil;
import chatty.util.ProcessManager;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public class UrlOpener {
    private static final Logger LOGGER = Logger.getLogger(UrlOpener.class.getName());
    private static final int MAX_URL_LENGTH = 80;
    private static Settings settings;
    private static boolean customCommandEnabled;
    private static String customCommand;

    public static void setSettings(Settings settings) {
        UrlOpener.settings = settings;
    }

    public static void setCustomCommandEnabled(boolean enabled) {
        customCommandEnabled = enabled;
    }

    public static void setCustomCommand(String command) {
        customCommand = command;
    }

    public static boolean openUrlPrompt(Component parent, String url) {
        return UrlOpener.openUrlPrompt(parent, url, false);
    }

    public static boolean openUrlPrompt(Component parent, String url, boolean forcePrompt) {
        if (url == null) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(url);
        return UrlOpener.openUrlsPrompt(parent, list, forcePrompt);
    }

    public static boolean openUrl(String url) {
        URI parsed;
        if (url == null) {
            return false;
        }
        url = url.trim();
        try {
            parsed = new URI(url);
        }
        catch (URISyntaxException ex) {
            LOGGER.warning("Invalid URI format: " + ex);
            return false;
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE) && !customCommandEnabled) {
            try {
                Desktop.getDesktop().browse(parsed);
                return true;
            }
            catch (IOException ex) {
                LOGGER.warning("Error opening URL: " + ex);
            }
        } else {
            return UrlOpener.openUrlNative(url);
        }
        return false;
    }

    private static boolean openUrlNative(String url) {
        String command = null;
        if (customCommandEnabled && customCommand != null && !customCommand.isEmpty()) {
            command = customCommand + " " + url;
        } else if (MiscUtil.OS_WINDOWS) {
            command = "explorer " + url;
        } else if (MiscUtil.OS_LINUX) {
            command = "xdg-open " + url;
        } else if (MiscUtil.OS_MAC) {
            command = "open " + url;
        }
        if (command != null) {
            ProcessManager.execute(command, "URL", null);
            return true;
        }
        return false;
    }

    public static void openUrlsPrompt(Component parent, List<String> urls) {
        UrlOpener.openUrlsPrompt(parent, urls, false);
    }

    public static boolean openUrlsPrompt(Component parent, List<String> urls, boolean forcePrompt) {
        if (urls.isEmpty()) {
            return false;
        }
        if (!forcePrompt && settings != null && !settings.getBoolean("urlPrompt")) {
            return UrlOpener.openUrls(urls);
        }
        switch (UrlOpener.showUrlsPrompt(parent, urls, forcePrompt)) {
            case 0: {
                return UrlOpener.openUrls(urls);
            }
            case 1: {
                MiscUtil.copyToClipboard(urls.get(0).trim());
            }
        }
        return true;
    }

    public static boolean openUrls(List<String> urls) {
        boolean result = true;
        for (String url : urls) {
            if (UrlOpener.openUrl(url)) continue;
            result = false;
        }
        return result;
    }

    private static int showUrlsPrompt(Component parent, List<String> urls, boolean forced) {
        String text = "<html><body style='width: 100px;'>";
        for (String url : urls) {
            url = UrlOpener.splitUrl(url).trim();
            text = text + url + "<br />";
        }
        String okOption = Language.getString("openUrl.button.open", urls.size());
        String cancelOption = Language.getString("dialog.button.cancel");
        String copyOption = Language.getString("openUrl.button.copy");
        Object[] options = urls.size() == 1 ? new String[]{okOption, copyOption, cancelOption} : new String[]{okOption, cancelOption};
        JCheckBox setting = new JCheckBox(Language.getString("openUrl.setting"));
        setting.setToolTipText(SettingsUtil.addTooltipLinebreaks(Language.getString("openUrl.setting.tip")));
        Object[] content = new Object[]{text};
        if (!forced) {
            content = new Object[]{text + "<br />", setting};
        }
        int chosenOption = JOptionPane.showOptionDialog(parent, content, Language.getString("openUrl.title"), 2, 3, null, options, 1);
        if (urls.size() > 1 && chosenOption == 1) {
            return 2;
        }
        if (setting.isSelected() && chosenOption != 2) {
            settings.setBoolean("urlPrompt", false);
        }
        return chosenOption;
    }

    private static String splitUrl(String url) {
        if (url.length() > 80) {
            return url.substring(0, 80) + " " + UrlOpener.splitUrl(url.substring(80));
        }
        return url;
    }
}

