/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractListModel;

public class UserlistModel<T extends Comparable<T>>
extends AbstractListModel<T> {
    ArrayList<T> data = new ArrayList();

    public ArrayList<T> getData() {
        return (ArrayList)this.data.clone();
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public T getElementAt(int index) {
        return (T)((Comparable)this.data.get(index));
    }

    public void add(T item) {
        int insertionPoint = this.findInsertionPoint(item);
        this.data.add(insertionPoint, item);
        super.fireIntervalAdded(this, insertionPoint, insertionPoint);
    }

    public void remove(T item) {
        int index = this.data.indexOf(item);
        if (index == -1) {
            return;
        }
        this.data.remove(index);
        super.fireIntervalRemoved(this, index, index);
    }

    private int findInsertionPoint(T item) {
        int insertionPoint = Collections.binarySearch(this.data, item, null);
        if (insertionPoint < 0) {
            insertionPoint = -(insertionPoint + 1);
        }
        return insertionPoint;
    }

    public void updated(T item) {
        int index = this.data.indexOf(item);
        if (index == -1) {
            return;
        }
        super.fireContentsChanged(this, index, index);
    }

    public void clear() {
        if (!this.data.isEmpty()) {
            super.fireIntervalRemoved(this, 0, this.data.size() - 1);
            this.data.clear();
        }
    }

    public void sort() {
        Collections.sort(this.data);
        super.fireContentsChanged(this, 0, this.data.size() - 1);
    }

    public void update() {
        super.fireContentsChanged(this, 0, this.data.size() - 1);
    }
}

