/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui;

import chatty.Helper;
import chatty.gui.AttachedWindowManager;
import chatty.gui.GuiUtil;
import chatty.util.settings.Settings;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class WindowStateManager {
    private static final Logger LOGGER = Logger.getLogger(WindowStateManager.class.getName());
    private static final String SETTING = "windows";
    private static final String MODE_SETTING = "restoreMode";
    private static final String CHECK_ON_SCREEN_SETTING = "restoreOnlyIfOnScreen";
    public static final int DONT_RESTORE = 0;
    public static final int RESTORE_MAIN = 1;
    public static final int RESTORE_ALL = 2;
    public static final int RESTORE_ON_START = 3;
    public static final int REOPEN_ON_START = 4;
    private final HashMap<Window, StateItem> windows = new HashMap();
    private final Set<Window> locationSet = new HashSet<Window>();
    private final Settings settings;
    private final Window primaryWindow;
    private Point primaryMovedBy;
    private final AttachedWindowManager attachedWindowManager;

    public WindowStateManager(Window primaryWindow, Settings settings) {
        this.settings = settings;
        this.primaryWindow = primaryWindow;
        this.attachedWindowManager = new AttachedWindowManager(primaryWindow);
    }

    public void addWindow(Window window, String id, boolean saveSize, boolean reopen) {
        this.windows.put(window, new StateItem(id, saveSize, reopen));
        this.attachedWindowManager.attach(window);
    }

    public void setWindowAttached(Window window, boolean attached) {
        if (attached) {
            this.attachedWindowManager.attach(window);
        } else {
            this.attachedWindowManager.detach(window);
        }
    }

    public Set<Window> getWindows() {
        return new HashSet<Window>(this.windows.keySet());
    }

    public void setAttachedWindowsEnabled(boolean enabled) {
        this.attachedWindowManager.setEnabled(enabled);
    }

    public void saveWindowStates() {
        for (Window window : this.windows.keySet()) {
            this.saveWindowState(window);
        }
    }

    public void loadWindowStates() {
        this.loadWindowState(this.primaryWindow);
        for (Window window : this.windows.keySet()) {
            if (window == this.primaryWindow) continue;
            this.loadWindowState(window);
        }
    }

    private void saveWindowState(Window window) {
        if (!this.locationSet.contains(window) && window != this.primaryWindow) {
            return;
        }
        StateItem item = this.windows.get(window);
        Point location = window.getLocation();
        String state = location.x + "," + location.y;
        Dimension size = window.getSize();
        state = state + ";" + size.width + "," + size.height;
        state = state + ";" + (window.isVisible() ? "1" : "0");
        this.settings.mapPut(SETTING, item.id, state);
    }

    private void loadWindowState(Window window) {
        StateItem item = this.windows.get(window);
        String state = (String)this.settings.mapGet(SETTING, item.id);
        if (state == null) {
            return;
        }
        String[] states = state.split(";");
        if (states.length < 3) {
            return;
        }
        if (this.mode() >= 3 || this.mode() >= 1 && window == this.primaryWindow) {
            Helper.IntegerPair locationTemp;
            Helper.IntegerPair sizeTemp = Helper.getNumbersFromString(states[1]);
            if (sizeTemp != null && item.saveSize) {
                Dimension size = new Dimension(sizeTemp.a, sizeTemp.b);
                window.setSize(size);
            }
            if ((locationTemp = Helper.getNumbersFromString(states[0])) != null) {
                Point location = new Point(locationTemp.a, locationTemp.b);
                if (!this.settings.getBoolean(CHECK_ON_SCREEN_SETTING) || this.isOnScreen(location, window.getWidth())) {
                    if (window == this.primaryWindow) {
                        this.attachedWindowManager.ignoreLocationOnce(location);
                    }
                    window.setLocation(location);
                    this.locationSet.add(window);
                } else if (window == this.primaryWindow) {
                    if (!(window instanceof Frame) || (((Frame)window).getExtendedState() & 6) != 6) {
                        window.setLocationRelativeTo(null);
                        this.attachedWindowManager.ignoreLocationOnce(window.getLocation());
                    }
                    this.locationSet.add(window);
                    this.primaryMovedBy = new Point(window.getLocation().x - location.x, window.getLocation().y - location.y);
                    LOGGER.info("Location for " + item.id + " [" + location + "] moved (not on screen)");
                } else if (this.primaryMovedBy != null) {
                    Point newLocation = new Point(location.x + this.primaryMovedBy.x, location.y + this.primaryMovedBy.y);
                    if (this.isOnScreen(newLocation, window.getWidth())) {
                        window.setLocation(newLocation);
                        this.locationSet.add(window);
                        LOGGER.info("Location for " + item.id + " [" + location + "] moved same as primary (not on screen)");
                    } else {
                        LOGGER.info("Location for " + item.id + " [" + location + "] not restored (moved location not on screen)");
                    }
                } else {
                    LOGGER.info("Location for " + item.id + " [" + location + "] not restored (not on screen)");
                }
            }
        }
        item.wasOpen = states[2].equals("1");
    }

    private boolean isOnScreen(Point location, int width) {
        return GuiUtil.isPointOnScreen(location, 100, 8) || GuiUtil.isPointOnScreen(location, width - 100, 8);
    }

    public void setWindowPosition(Window window, Window parent) {
        boolean setLocationBefore = this.locationSet.contains(window);
        if (window == this.primaryWindow) {
            if (!setLocationBefore) {
                window.setLocationRelativeTo(null);
            }
        } else if (this.mode() < 2 || !setLocationBefore) {
            if (parent == null) {
                parent = this.primaryWindow;
            }
            window.setLocationRelativeTo(parent);
            this.locationSet.add(window);
        }
    }

    public void setWindowPosition(Window window) {
        this.setWindowPosition(window, null);
    }

    public boolean wasOpen(Window window) {
        StateItem item = this.windows.get(window);
        return item != null && item.wasOpen;
    }

    public boolean shouldReopen(Window window) {
        StateItem item = this.windows.get(window);
        return this.mode() >= 4 && item != null && item.reopen && item.wasOpen;
    }

    private int mode() {
        return (int)this.settings.getLong(MODE_SETTING);
    }

    private static class StateItem {
        public final boolean saveSize;
        public final String id;
        public final boolean reopen;
        public boolean wasOpen;

        StateItem(String id, boolean saveSize, boolean reopen) {
            this.saveSize = saveSize;
            this.reopen = reopen;
            this.id = id;
        }
    }
}

