/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.colors;

import java.awt.Color;
import java.util.Objects;

public class ColorItem {
    private final String id;
    private final Color foreground;
    private final Color background;
    private final boolean foregroundEnabled;
    private final boolean backgroundEnabled;

    public ColorItem(String id, Color foreground, boolean foregroundEnabled, Color background, boolean backgroundEnabled) {
        this.id = id;
        this.foreground = foreground;
        this.foregroundEnabled = foregroundEnabled;
        this.background = background;
        this.backgroundEnabled = backgroundEnabled;
    }

    public String getId() {
        return this.id;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForegroundIfEnabled() {
        return this.foregroundEnabled ? this.foreground : null;
    }

    public Color getBackgroundIfEnabled() {
        return this.backgroundEnabled ? this.background : null;
    }

    public boolean getForegroundEnabled() {
        return this.foregroundEnabled;
    }

    public boolean getBackgroundEnabled() {
        return this.backgroundEnabled;
    }

    public boolean isEmpty() {
        return this.foreground == null && this.background == null;
    }

    public String toString() {
        return this.getId();
    }

    public String toStringAll() {
        return String.format("%s,%s/%s/%s/%s", this.getId(), this.getForeground(), this.getForegroundEnabled(), this.getBackground(), this.getBackgroundEnabled());
    }

    public boolean equals(Object o) {
        if (o instanceof ColorItem) {
            return this.getId().equals(((ColorItem)o).getId());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.getId());
        return hash;
    }

    public boolean equalsAll(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorItem other = (ColorItem)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (!Objects.equals(this.foreground, other.foreground)) {
            return false;
        }
        if (!Objects.equals(this.background, other.background)) {
            return false;
        }
        if (this.foregroundEnabled != other.foregroundEnabled) {
            return false;
        }
        return this.backgroundEnabled == other.backgroundEnabled;
    }
}

