/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.colors;

import chatty.Addressbook;
import chatty.User;
import chatty.gui.Highlighter;
import chatty.gui.colors.MsgColorItem;
import chatty.util.colors.HtmlColors;
import chatty.util.irc.MsgTags;
import chatty.util.settings.Settings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MsgColorManager {
    public static final MsgColorItem EMPTY = new MsgColorItem(null, null, false, null, false);
    private static final String DATA_SETTING = "msgColors";
    private static final String ENABLED_SETTING = "msgColorsEnabled";
    private final Settings settings;
    private volatile List<MsgColorItem> data;

    public MsgColorManager(Settings settings) {
        this.settings = settings;
    }

    public synchronized void loadFromSettings() {
        LinkedList loadedList = new LinkedList();
        this.settings.getList(DATA_SETTING, loadedList);
        ArrayList<MsgColorItem> loadedData = new ArrayList<MsgColorItem>();
        for (String entry : loadedList) {
            boolean backgroundEnabled;
            boolean foregroundEnabled;
            Color background;
            int splitAt = entry.lastIndexOf(",");
            if (splitAt <= 0 || entry.length() <= splitAt + 1) continue;
            String id = entry.substring(0, splitAt);
            String colorsPart = entry.substring(splitAt + 1);
            String[] colors = colorsPart.split("/");
            Color foreground = HtmlColors.decode(colors[0]);
            if (colors.length == 4) {
                background = HtmlColors.decode(colors[2], null);
                foregroundEnabled = colors[1].equals("1");
                backgroundEnabled = colors[3].equals("1");
            } else {
                background = null;
                foregroundEnabled = true;
                backgroundEnabled = false;
            }
            loadedData.add(new MsgColorItem(id, foreground, foregroundEnabled, background, backgroundEnabled));
        }
        this.data = loadedData;
    }

    private void saveToSettings() {
        LinkedList<String> dataToSave = new LinkedList<String>();
        for (MsgColorItem item : this.data) {
            dataToSave.add(String.format("%s,%s/%s/%s/%s", item.getId(), HtmlColors.getColorString(item.getForeground()), item.getForegroundEnabled() ? "1" : "0", HtmlColors.getColorString(item.getBackground()), item.getBackgroundEnabled() ? "1" : "0"));
        }
        this.settings.putList(DATA_SETTING, dataToSave);
    }

    public synchronized List<MsgColorItem> getData() {
        return new ArrayList<MsgColorItem>(this.data);
    }

    public synchronized void setData(List<MsgColorItem> newData) {
        this.data = new ArrayList<MsgColorItem>(newData);
        this.saveToSettings();
    }

    private synchronized MsgColorItem getColor(Highlighter.HighlightItem.Type type, User user, User localUser, String text, int msgStart, int msgEnd, String channel, MsgTags tags, Addressbook ab) {
        if (this.data == null || !this.settings.getBoolean(ENABLED_SETTING)) {
            return EMPTY;
        }
        for (MsgColorItem item : this.data) {
            if (!item.matches(type, text, msgStart, msgEnd, channel, ab, user, localUser, tags)) continue;
            return item;
        }
        return EMPTY;
    }

    public synchronized MsgColorItem getMsgColor(User user, User localUser, String text, int msgStart, int msgEnd, MsgTags tags) {
        return this.getColor(Highlighter.HighlightItem.Type.REGULAR, user, localUser, text, msgStart, msgEnd, user.getChannel(), tags, user.getAddressbook());
    }

    public synchronized MsgColorItem getInfoColor(String text, int msgStart, int msgEnd, String channel, Addressbook ab, User user, User localUser, MsgTags tags) {
        return this.getColor(Highlighter.HighlightItem.Type.INFO, user, localUser, text, msgStart, msgEnd, channel, tags, ab);
    }
}

