/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.colors;

import chatty.Helper;
import chatty.User;
import chatty.gui.colors.UsercolorItem;
import chatty.util.colors.HtmlColors;
import chatty.util.settings.Settings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class UsercolorManager {
    private final Settings settings;
    private volatile List<UsercolorItem> data;

    public UsercolorManager(Settings settings) {
        this.settings = settings;
        this.loadFromSettings();
    }

    private void loadFromSettings() {
        LinkedList l = new LinkedList();
        this.settings.getList("usercolors", l);
        ArrayList<UsercolorItem> loadedData = new ArrayList<UsercolorItem>();
        for (String entry : l) {
            int splitAt = entry.lastIndexOf(",");
            if (splitAt <= 0 || entry.length() <= splitAt + 1) continue;
            String id = entry.substring(0, splitAt);
            Color color = HtmlColors.decode(entry.substring(splitAt + 1));
            loadedData.add(new UsercolorItem(id, color));
        }
        this.data = loadedData;
    }

    private void saveToSettings() {
        LinkedList<String> dataToSave = new LinkedList<String>();
        for (UsercolorItem item : this.data) {
            dataToSave.add(item.getId() + "," + HtmlColors.getColorString(item.getForeground()));
        }
        this.settings.putList("usercolors", dataToSave);
    }

    public synchronized List<UsercolorItem> getData() {
        return new ArrayList<UsercolorItem>(this.data);
    }

    public synchronized void setData(List<UsercolorItem> newData) {
        this.data = new ArrayList<UsercolorItem>(newData);
        this.saveToSettings();
    }

    public synchronized Color getColor(User user) {
        if (this.data == null || !this.settings.getBoolean("customUsercolors")) {
            return null;
        }
        for (UsercolorItem item : this.data) {
            if (!(item.type == 1 ? item.idColor.equals(user.getPlainColor()) : (item.type == 0 ? item.id.equalsIgnoreCase(user.getName()) : (item.type == 2 ? Helper.matchUserStatus(item.id, user) : (item.type == 4 ? user.hasCategory(item.category) : (item.type == 6 ? item.match.matches(user) : (item.type == 5 ? user.hasDefaultColor() : item.type == 3))))))) continue;
            return item.color;
        }
        return null;
    }
}

