/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Addressbook;
import chatty.AddressbookEntry;
import chatty.gui.RegexDocumentFilter;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.TableEditor;
import chatty.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class AddressbookEditor
extends TableEditor<AddressbookEntry> {
    private final MyTableModel data = new MyTableModel();

    public AddressbookEditor(JDialog parent, TableEditor.TableEditorListener<AddressbookEntry> listener) {
        super(1, true);
        this.setModel(this.data);
        this.setTableEditorListener(listener);
        this.setItemEditor(() -> new MyEditor(parent));
    }

    public void edit(String name) {
        AddressbookEntry preset = new AddressbookEntry(name, new HashSet<String>());
        int index = this.data.indexOf(preset);
        if (index == -1) {
            this.addItem(preset);
        } else {
            this.editItem(index);
        }
    }

    public void setContextMenu(TableEditor.TableContextMenu menu) {
        this.setPopupMenu(menu);
    }

    public void setEntry(AddressbookEntry entry) {
        int index = this.data.indexOf(entry);
        if (index != -1) {
            this.data.set(index, entry);
        }
    }

    private static class MyTableModel
    extends ListTableModel<AddressbookEntry> {
        public MyTableModel() {
            super(new String[]{"Name", "Categories"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((AddressbookEntry)this.get(rowIndex)).getName();
            }
            return StringUtil.join(((AddressbookEntry)this.get(rowIndex)).getCategories(), ",");
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return String.class;
            }
            return String.class;
        }
    }

    private static class MyEditor
    extends JDialog
    implements TableEditor.ItemEditor<AddressbookEntry> {
        private final JTextField name = new JTextField(15);
        private final JTextField categories = new JTextField(15);
        private final JButton ok = new JButton("Done");
        private final JButton cancel = new JButton("Cancel");
        private boolean save;

        public MyEditor(JDialog owner) {
            super(owner);
            this.setModal(true);
            this.setResizable(false);
            ButtonListener listener = new ButtonListener();
            this.ok.addActionListener(listener);
            this.cancel.addActionListener(listener);
            this.name.addActionListener(listener);
            this.categories.addActionListener(listener);
            TextFieldListener documentListener = new TextFieldListener();
            this.name.getDocument().addDocumentListener(documentListener);
            this.categories.getDocument().addDocumentListener(documentListener);
            ((AbstractDocument)this.name.getDocument()).setDocumentFilter(new RegexDocumentFilter("\\s+", this));
            this.setLayout(new GridBagLayout());
            JLabel nameLabel = new JLabel("Name: ");
            JLabel categoriesLabel = new JLabel("Categories: ");
            nameLabel.setLabelFor(this.name);
            GridBagConstraints gbc = this.makeGbc(0, 1, 1, 1, 13);
            this.add((Component)nameLabel, gbc);
            gbc = this.makeGbc(1, 1, 2, 1, 10);
            this.add((Component)this.name, gbc);
            gbc = this.makeGbc(0, 2, 1, 1, 13);
            this.add((Component)categoriesLabel, gbc);
            gbc = this.makeGbc(1, 2, 2, 1, 10);
            this.add((Component)this.categories, gbc);
            gbc = this.makeGbc(1, 3, 1, 1, 10);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.add((Component)this.ok, gbc);
            gbc = this.makeGbc(2, 3, 1, 1, 10);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.add((Component)this.cancel, gbc);
            this.pack();
        }

        private GridBagConstraints makeGbc(int x, int y, int w, int h, int anchor) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.gridwidth = w;
            gbc.gridheight = h;
            gbc.insets = new Insets(5, 3, 5, 3);
            gbc.anchor = anchor;
            return gbc;
        }

        @Override
        public AddressbookEntry showEditor(AddressbookEntry preset, Component c, boolean edit, int column) {
            this.setLocationRelativeTo(c);
            this.updateButtons();
            this.setData(preset);
            if (edit) {
                this.setTitle("Edit entry");
            } else {
                this.setTitle("Add entry");
            }
            this.name.requestFocusInWindow();
            this.setVisible(true);
            if (this.save && this.valid()) {
                return this.loadData();
            }
            return null;
        }

        private void setData(AddressbookEntry preset) {
            if (preset == null) {
                this.name.setText("");
                this.categories.setText("");
            } else {
                this.name.setText(preset.getName());
                this.categories.setText(StringUtil.join(preset.getCategories(), ","));
            }
        }

        private AddressbookEntry loadData() {
            String name = this.name.getText();
            Set<String> categories = Addressbook.getCategoriesFromString(this.categories.getText());
            return new AddressbookEntry(name, categories);
        }

        private void updateButtons() {
            boolean enabled = this.valid();
            this.ok.setEnabled(enabled);
        }

        private boolean valid() {
            return !this.name.getText().isEmpty();
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == MyEditor.this.ok) {
                    MyEditor.this.save = true;
                    MyEditor.this.setVisible(false);
                } else if (e.getSource() == MyEditor.this.cancel) {
                    MyEditor.this.save = false;
                    MyEditor.this.setVisible(false);
                }
                if ((e.getSource() == MyEditor.this.name || e.getSource() == MyEditor.this.categories) && MyEditor.this.valid()) {
                    MyEditor.this.save = true;
                    MyEditor.this.setVisible(false);
                }
            }
        }

        private class TextFieldListener
        implements DocumentListener {
            private TextFieldListener() {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MyEditor.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MyEditor.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MyEditor.this.updateButtons();
            }
        }
    }
}

