/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Helper;
import chatty.TwitchClient;
import chatty.User;
import chatty.gui.DockStyledTabContainer;
import chatty.gui.DockedDialogHelper;
import chatty.gui.DockedDialogManager;
import chatty.gui.MainGui;
import chatty.gui.components.menus.AutoModContextMenu;
import chatty.util.DateTime;
import chatty.util.MiscUtil;
import chatty.util.StringUtil;
import chatty.util.api.TwitchApi;
import chatty.util.api.eventsub.payloads.ModActionPayload;
import chatty.util.dnd.DockContent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AutoModDialog
extends JDialog {
    private static final int MESSAGE_LIMIT = 20;
    private final MainGui gui;
    private final TwitchApi api;
    private final TwitchClient client;
    private final DockedDialogHelper helper;
    private final JList<Item> list;
    private final DefaultListModel<Item> data;
    private final Map<String, List<Item>> cache = new HashMap<String, List<Item>>();
    private String currentRoom = "";
    private String currentRoomLoaded = "";

    public AutoModDialog(MainGui main, TwitchApi api, TwitchClient client, DockedDialogManager dockedDialogs) {
        super(main);
        this.setTitle("AutoMod");
        this.gui = main;
        this.api = api;
        this.client = client;
        this.list = new JList<Item>(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        this.data = new DefaultListModel();
        this.list.setModel(this.data);
        this.list.setCellRenderer(new MyCellRenderer());
        this.list.setSelectionMode(0);
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.getVerticalScrollBar().setUnitIncrement(20);
        this.add(scroll);
        final DockStyledTabContainer<JComponent> content = dockedDialogs.createStyledContent(scroll, "AutoMod", "-automod-");
        this.helper = dockedDialogs.createHelper(new DockedDialogHelper.DockedDialog(){

            @Override
            public void setVisible(boolean visible) {
                AutoModDialog.super.setVisible(visible);
            }

            @Override
            public boolean isVisible() {
                return AutoModDialog.super.isVisible();
            }

            @Override
            public void addComponent(Component comp) {
                AutoModDialog.this.add(comp);
            }

            @Override
            public void removeComponent(Component comp) {
                AutoModDialog.this.remove(comp);
            }

            @Override
            public Window getWindow() {
                return AutoModDialog.this;
            }

            @Override
            public DockContent getContent() {
                return content;
            }
        });
        this.helper.setChannelChangeListener(channel -> {
            if (this.isVisible()) {
                this.setStream(Helper.toStream(channel));
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AutoModDialog.this.openUserInfoDialog();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AutoModDialog.this.openContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AutoModDialog.this.openContextMenu(e);
            }
        });
        Timer timer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoModDialog.this.list.repaint();
            }
        });
        timer.setRepeats(true);
        timer.start();
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke("A"), "automod.approve");
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke("alt A"), "automod.approve");
        this.list.getActionMap().put("automod.approve", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoModDialog.this.approve(null);
            }
        });
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke("D"), "automod.deny");
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke("alt D"), "automod.deny");
        this.list.getActionMap().put("automod.deny", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoModDialog.this.deny(null);
            }
        });
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke("S"), "automod.next");
        this.list.getActionMap().put("automod.next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoModDialog.this.selectNext();
            }
        });
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke("W"), "automod.previous");
        this.list.getActionMap().put("automod.previous", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoModDialog.this.selectPrevious();
            }
        });
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke("alt S"), "automod.nextUnhandled");
        this.list.getActionMap().put("automod.nextUnhandled", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoModDialog.this.selectNext(true);
            }
        });
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke("alt W"), "automod.previousUnhandled");
        this.list.getActionMap().put("automod.previousUnhandled", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoModDialog.this.selectPrevious(true);
            }
        });
        this.list.getInputMap(0).put(KeyStroke.getKeyStroke("Q"), "automod.close");
        this.list.getActionMap().put("automod.close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoModDialog.this.setVisible(false);
            }
        });
        ComponentAdapter l = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AutoModDialog.this.list.setFixedCellHeight(10);
                AutoModDialog.this.list.setFixedCellHeight(-1);
            }
        };
        this.list.addComponentListener(l);
        this.setSize(new Dimension(400, 200));
    }

    @Override
    public void setVisible(boolean visible) {
        this.helper.setVisible(visible, true);
    }

    @Override
    public boolean isVisible() {
        if (this.helper != null) {
            return this.helper.isVisible();
        }
        return super.isVisible();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.helper != null) {
            this.helper.getContent().setLongTitle(title);
        }
    }

    public void showDialog() {
        this.switchDataToCurrent();
        this.setVisible(true);
        this.list.setSelectedIndex(this.data.size() - 1);
        this.scrollDown();
    }

    public void setStream(String stream) {
        if (stream != null && !stream.equals(this.currentRoom)) {
            this.currentRoom = stream;
            this.helper.setCurrentChannel(stream);
            if (this.isVisible()) {
                this.switchDataToCurrent();
            }
        }
    }

    private void switchDataToCurrent() {
        if (!this.currentRoom.equals(this.currentRoomLoaded)) {
            this.currentRoomLoaded = this.currentRoom;
            this.setTitle("AutoMod (" + this.currentRoom + ") [Use Context Menu to Approve/Deny]");
            List<Item> cached = this.cache.get(this.currentRoom);
            this.data.removeAllElements();
            if (cached != null) {
                for (Item item : cached) {
                    this.data.addElement(item);
                }
            }
            this.scrollDown();
        }
    }

    public void addData(ModActionPayload modData) {
        if (modData.stream == null) {
            return;
        }
        if (modData.type == ModActionPayload.Type.AUTOMOD_FILTERED) {
            this.addItem(modData);
        }
        if (modData.type == ModActionPayload.Type.AUTOMOD_APPROVED) {
            this.handledExternally(modData, 5);
        }
        if (modData.type == ModActionPayload.Type.AUTOMOD_DENIED) {
            this.handledExternally(modData, 6);
        }
    }

    public void requestResult(TwitchApi.AutoModAction action, String msgId, TwitchApi.AutoModActionResult result) {
        Item changedItem = this.findItemByMsgId(msgId);
        if (changedItem != null) {
            changedItem.setRequestPending(false);
            if (result == TwitchApi.AutoModActionResult.SUCCESS && action == TwitchApi.AutoModAction.ALLOW) {
                changedItem.setStatus(5);
            } else if (result == TwitchApi.AutoModActionResult.SUCCESS && action == TwitchApi.AutoModAction.DENY) {
                changedItem.setStatus(6);
            } else if (changedItem.status <= 0) {
                if (result == TwitchApi.AutoModActionResult.ALREADY_PROCESSED) {
                    changedItem.setStatus(2);
                } else if (result == TwitchApi.AutoModActionResult.NOT_FOUND) {
                    changedItem.setStatus(4);
                } else {
                    changedItem.setStatus(3);
                }
            }
        }
        this.repaintFor(changedItem);
    }

    private Item findItemByMsgId(String msgId) {
        for (List<Item> items : this.cache.values()) {
            for (Item item : items) {
                if (!this.getMsgId(item.data).equals(msgId)) continue;
                return item;
            }
        }
        return null;
    }

    private void addItem(ModActionPayload modData) {
        ModActionPayload.AutoModMessageUpdate eventData = (ModActionPayload.AutoModMessageUpdate)modData.action;
        if (StringUtil.isNullOrEmpty(eventData.getMsgId())) {
            return;
        }
        String room = modData.stream;
        String channel = Helper.toValidChannel(modData.stream);
        String username = eventData.getUsername();
        String message = eventData.getMessage();
        String reason = eventData.getReason();
        if (channel == null) {
            return;
        }
        if (!Helper.isValidStream(username)) {
            return;
        }
        User user = this.client.getUser(channel, username);
        user.addAutoModMessage(message, eventData.getMsgId(), reason, modData.type, null);
        this.gui.updateUserinfo(user);
        Item item = new Item(modData, user);
        if (!this.cache.containsKey(room)) {
            this.cache.put(room, new ArrayList());
        }
        this.cache.get(room).add(item);
        if (this.cache.get(room).size() > 20) {
            this.cache.get(room).remove(0);
            if (room.equals(this.currentRoom) && !this.data.isEmpty()) {
                this.data.remove(0);
            }
        }
        if (room.equals(this.currentRoom)) {
            this.data.addElement(item);
            this.scrollDownIfApplicable();
            this.helper.setNewMessage();
        }
    }

    private void handledExternally(ModActionPayload modData, int status) {
        String channel;
        ModActionPayload.AutoModMessageUpdate update = (ModActionPayload.AutoModMessageUpdate)modData.action;
        String handledBy = modData.created_by;
        String targetUsername = update.getUsername();
        String room = modData.stream;
        String msgId = update.getMsgId();
        Item item = !StringUtil.isNullOrEmpty(msgId) ? this.findItemByMsgId(msgId) : this.findItemByUsername(room, targetUsername);
        if (item != null && !item.hasRequestPending && !item.isHandled()) {
            item.setStatus(status, handledBy);
            this.repaintFor(item);
        }
        if ((channel = Helper.toValidChannel(modData.stream)) != null) {
            User user = this.client.getUser(channel, targetUsername);
            user.addAutoModMessage(update.getMessage(), update.getMsgId(), update.getReason(), modData.type, modData.created_by);
            this.gui.updateUserinfo(user);
        }
    }

    private Item findItemByUsername(String room, String username) {
        Item foundItem = null;
        List<Item> items = this.cache.get(room);
        if (items != null) {
            boolean oldEnoughHistory = false;
            for (int i = items.size() - 1; i >= 0; --i) {
                Item item = items.get(i);
                if (item.getAge() > 300L) {
                    oldEnoughHistory = true;
                    break;
                }
                if (item.hasRequestPending || item.isHandled() || !item.targetUser.getName().equals(username)) continue;
                if (foundItem != null) {
                    foundItem = null;
                    break;
                }
                foundItem = item;
            }
            if (!oldEnoughHistory) {
                foundItem = null;
            }
        }
        return foundItem;
    }

    private void scrollDownIfApplicable() {
        if (this.list.getLastVisibleIndex() >= this.data.size() - 2) {
            this.scrollDown();
        }
    }

    private void scrollDown() {
        this.list.ensureIndexIsVisible(this.data.size() - 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoModDialog.this.list.ensureIndexIsVisible(AutoModDialog.this.data.size() - 1);
            }
        });
    }

    private void selectClicked(MouseEvent e) {
        int index = this.list.locationToIndex(e.getPoint());
        if (index != -1) {
            this.list.setSelectedIndex(index);
        }
    }

    private void openContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.selectClicked(e);
            Item selectedItem = this.list.getSelectedValue();
            AutoModContextMenu m = new AutoModContextMenu(selectedItem, this.helper, new AutoModContextMenu.AutoModContextMenuListener(){

                @Override
                public void itemClicked(Item item, ActionEvent e) {
                    if (e.getActionCommand().equals("approve")) {
                        AutoModDialog.this.approve(item);
                    } else if (e.getActionCommand().equals("reject")) {
                        AutoModDialog.this.deny(item);
                    } else if (e.getActionCommand().equals("copy")) {
                        MiscUtil.copyToClipboard(item.toString());
                    } else if (e.getActionCommand().equals("help")) {
                        AutoModDialog.this.gui.openHelp(null, "automod");
                    } else if (e.getActionCommand().equals("user")) {
                        AutoModDialog.this.openUserInfoDialog();
                    } else if (e.getActionCommand().equals("close")) {
                        AutoModDialog.this.setVisible(false);
                    }
                    AutoModDialog.this.helper.menuAction(e);
                }
            });
            m.show(this.list, e.getX(), e.getY());
        }
    }

    private String getMsgId(ModActionPayload data) {
        if (data.action instanceof ModActionPayload.AutoModMessageUpdate) {
            return ((ModActionPayload.AutoModMessageUpdate)data.action).getMsgId();
        }
        return null;
    }

    private void openUserInfoDialog() {
        Item item = this.list.getSelectedValue();
        if (item != null) {
            this.gui.openUserInfoDialog(item.targetUser, null, this.getMsgId(item.data));
        }
    }

    private void approve(Item item) {
        if (item == null) {
            item = this.list.getSelectedValue();
        }
        if (item == null) {
            return;
        }
        this.setPending(item);
        this.api.autoModApprove(this.getMsgId(item.data));
    }

    private void deny(Item item) {
        if (item == null) {
            item = this.list.getSelectedValue();
        }
        if (item == null) {
            return;
        }
        this.setPending(item);
        this.api.autoModDeny(this.getMsgId(item.data));
    }

    private void setPending(Item item) {
        item.setRequestPending(true);
        this.repaintFor(item);
    }

    private void repaintFor(Item item) {
        if (this.data.contains(item)) {
            this.list.repaint();
        }
    }

    private void selectNext() {
        this.selectNext(false);
    }

    private void selectPrevious() {
        this.selectPrevious(false);
    }

    private void selectNext(boolean onlyUnhandled) {
        if (this.data.isEmpty()) {
            return;
        }
        int selected = this.list.getSelectedIndex();
        if (selected == -1) {
            selected = this.data.size() - 2;
        }
        for (int i = selected + 1; i < this.data.size(); ++i) {
            if (!this.select(i, onlyUnhandled)) continue;
            return;
        }
        if (this.list.getSelectedIndex() != this.data.size() - 1) {
            this.scrollDown();
            this.list.removeSelectionInterval(selected, selected);
        }
    }

    private void selectPrevious(boolean onlyUnhandled) {
        if (this.data.isEmpty()) {
            return;
        }
        int selected = this.list.getSelectedIndex();
        if (selected == -1) {
            selected = this.data.size();
        }
        for (int i = selected - 1; i >= 0; --i) {
            if (!this.select(i, onlyUnhandled)) continue;
            return;
        }
    }

    private boolean select(int i, boolean onlyUnhandled) {
        Item item = this.data.get(i);
        if (!onlyUnhandled || item.status == 0) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
            return true;
        }
        return false;
    }

    public static class Item {
        public static final int STATUS_NONE = 0;
        public static final int STATUS_HANDLED = 2;
        public static final int STATUS_ERROR = 3;
        public static final int STATUS_NA = 4;
        public static final int STATUS_APPROVED = 5;
        public static final int STATUS_DENIED = 6;
        public final ModActionPayload data;
        public final User targetUser;
        private int status;
        private String handledBy;
        private boolean hasRequestPending;

        private Item(ModActionPayload data, User targetUser) {
            this.data = data;
            this.targetUser = targetUser;
        }

        public void setStatus(int status, String handledBy) {
            this.status = status;
            this.handledBy = handledBy;
        }

        public void setStatus(int status) {
            this.setStatus(status, null);
        }

        public void setRequestPending(boolean isPending) {
            this.hasRequestPending = isPending;
        }

        public boolean hasRequestPending() {
            return this.hasRequestPending;
        }

        public String getHandledBy() {
            return this.handledBy;
        }

        public boolean isHandled() {
            return this.status == 5 || this.status == 6 || this.status == 2 || this.status == 4;
        }

        public long getAge() {
            return (System.currentTimeMillis() - this.data.created_at) / 1000L;
        }

        public String toString() {
            ModActionPayload.AutoModMessageUpdate update = (ModActionPayload.AutoModMessageUpdate)this.data.action;
            return String.format("[%s] <%s> %s", DateTime.format(this.data.created_at), update.getUsername(), update.getMessage());
        }

        public String getStatusText() {
            if (this.hasRequestPending) {
                return "Pending";
            }
            switch (this.status) {
                case 0: {
                    return "";
                }
                case 2: {
                    return "Handled";
                }
                case 5: {
                    return "Approved";
                }
                case 6: {
                    return "Denied";
                }
                case 3: {
                    return "Error";
                }
                case 4: {
                    return "N/A";
                }
            }
            return "";
        }
    }

    private static class MyCellRenderer
    extends DefaultListCellRenderer {
        private final JTextArea area = new JTextArea();

        public MyCellRenderer() {
            this.area.setBorder(BorderFactory.createEmptyBorder(4, 5, 5, 5));
            this.area.setLineWrap(true);
            this.area.setWrapStyleWord(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.area.setText(null);
                return this.area;
            }
            Item item = (Item)value;
            ModActionPayload.AutoModMessageUpdate updateData = (ModActionPayload.AutoModMessageUpdate)item.data.action;
            String agoText = System.currentTimeMillis() - item.data.created_at < 60000L ? "now" : DateTime.agoSingleCompact(item.data.created_at);
            String status = item.hasRequestPending() ? "-Pending- " : (item.getHandledBy() == null ? (item.status > 0 ? "-" + item.getStatusText() + "- " : "") : (item.status > 0 ? "-" + item.getStatusText() + " by " + item.getHandledBy() + "- " : ""));
            String text = String.format("%s[%s] <%s> %s", status, agoText, updateData.getUsername(), updateData.getMessage());
            this.area.setText(text);
            int width = list.getWidth();
            if (width > 0) {
                this.area.setSize(width, Short.MAX_VALUE);
            }
            if (isSelected) {
                this.area.setBackground(list.getSelectionBackground());
            } else {
                this.area.setBackground(list.getBackground());
            }
            if (item.isHandled() || item.getAge() > 300L) {
                this.area.setForeground(Color.GRAY);
            } else {
                this.area.setForeground(list.getForeground());
            }
            return this.area;
        }
    }
}

