/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.ChannelState;
import chatty.Room;
import chatty.User;
import chatty.gui.Channels;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.MouseClickedListener;
import chatty.gui.StyleManager;
import chatty.gui.StyleServer;
import chatty.gui.components.ChannelCompletion;
import chatty.gui.components.ChannelEditBox;
import chatty.gui.components.ModerationPanel;
import chatty.gui.components.UserList;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.TextSelectionMenu;
import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.components.textpane.InfoMessage;
import chatty.gui.components.textpane.Message;
import chatty.util.StringUtil;
import chatty.util.api.AccessChecker;
import chatty.util.api.TokenInfo;
import chatty.util.api.eventsub.payloads.SuspiciousMessagePayload;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;

public final class Channel
extends JPanel {
    private static final int DIVIDER_SIZE = 5;
    private final JPanel inputPanel;
    private final ChannelEditBox input;
    private final ChannelTextPane text;
    private final UserList users;
    private final JSplitPane mainPane;
    private final JScrollPane userlist;
    private final JScrollPane west;
    private final StyleServer styleManager;
    private final MainGui main;
    private Type type;
    private Channels.DockChannelContainer content;
    private boolean userlistEnabled = true;
    private int previousUserlistWidth;
    private int userlistMinWidth;
    private Room room;
    private ModerationPanel modPanel;
    private Popup modPanelPopup;
    private final JButton modPanelButton;
    private boolean inputPreviouslyShown = true;

    public Channel(Room room, Type type, MainGui main, StyleManager styleManager, ContextMenuListener contextMenuListener, boolean insertTop) {
        this.setLayout(new BorderLayout());
        this.styleManager = styleManager;
        this.main = main;
        this.type = type;
        this.room = room;
        this.setName(room.getDisplayName());
        this.text = new ChannelTextPane(main, styleManager, ChannelTextPane.Type.REGULAR, true, insertTop);
        this.text.setContextMenuListener(contextMenuListener);
        this.setTextPreferredSizeTemporarily();
        this.west = new JScrollPane(this.text);
        this.text.setScrollPane(this.west);
        this.west.setVerticalScrollBarPolicy(22);
        this.west.getVerticalScrollBar().setUnitIncrement(40);
        this.users = new UserList(contextMenuListener, main.getUserListener(), main.getSettings());
        this.updateUserlistSettings();
        this.userlist = new JScrollPane(this.users);
        this.mainPane = new JSplitPane(1, this.west, this.userlist);
        this.mainPane.setResizeWeight(1.0);
        this.mainPane.setDividerSize(5);
        this.input = new ChannelEditBox();
        this.input.addActionListener(main.getActionListener());
        this.input.setCompletionServer(new ChannelCompletion(this, main, this.input, this.users));
        this.input.setCompletionEnabled(main.getSettings().getBoolean("completionEnabled"));
        Channel.installLimits(this.input);
        TextSelectionMenu.install(this.input);
        this.inputPanel = new JPanel(new BorderLayout());
        this.inputPanel.add((Component)this.input, "Center");
        this.modPanelButton = new JButton("M");
        this.modPanelButton.setToolTipText("Channel Modes");
        this.modPanelButton.setVisible(false);
        this.inputPanel.add((Component)this.modPanelButton, "East");
        this.modPanelButton.addActionListener(e -> this.openModPanel());
        this.add((Component)this.mainPane, "Center");
        this.add((Component)this.inputPanel, "South");
    }

    public void updateModButton() {
        boolean hasAccess = AccessChecker.isModerator(this.room.getChannel(), TokenInfo.Scope.MANAGE_CHAT);
        this.modPanelButton.setVisible(hasAccess);
    }

    public void updateModPanel() {
        if (this.modPanel != null) {
            ChannelState state = this.main.getChannelState(this.room.getChannel());
            this.modPanel.updateState(state);
        }
    }

    public void closeModPanel() {
        if (this.modPanelPopup != null) {
            this.modPanelPopup.hide();
            this.modPanelPopup = null;
        }
    }

    private void openModPanel() {
        if (this.modPanelPopup != null) {
            this.closeModPanel();
            return;
        }
        if (this.modPanel == null) {
            this.modPanel = new ModerationPanel(this.main, this.main.getSettings());
            this.modPanel.setBorder(BorderFactory.createRaisedSoftBevelBorder());
            this.modPanel.addCommandListener(s -> this.main.anonCustomCommand(this.room, CustomCommand.parse(s), Parameters.create("")));
            this.text.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Channel.this.closeModPanel();
                }
            });
            this.input.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Channel.this.closeModPanel();
                }
            });
        }
        this.updateModPanel();
        Point inputLocation = this.input.getLocationOnScreen();
        Dimension panelSize = this.modPanel.getPreferredSize();
        int buttonWidth = this.modPanelButton.getSize().width;
        Popup popup = PopupFactory.getSharedInstance().getPopup(this.input, this.modPanel, inputLocation.x + this.input.getWidth() - panelSize.width + buttonWidth, inputLocation.y - panelSize.height);
        popup.show();
        this.modPanelPopup = popup;
    }

    public ChannelEditBox createInputBox() {
        ChannelEditBox result = new ChannelEditBox();
        result.setCompletionServer(new ChannelCompletion(this, this.main, result, this.users));
        result.setCompletionEnabled(this.main.getSettings().getBoolean("completionEnabled"));
        Channel.installLimits(result);
        TextSelectionMenu.install(result);
        return result;
    }

    private static void installLimits(JTextComponent comp) {
        GuiUtil.installLengthLimitDocumentFilter(comp, 500, false, "^/(say|me|msg|msgreply|msgreplythread) ", 504, "^/", 100000);
    }

    public Channels.DockChannelContainer getDockContent() {
        return this.content;
    }

    public void setDockContent(Channels.DockChannelContainer content) {
        this.content = content;
        this.updateContentData();
    }

    private void updateContentData() {
        if (this.content != null) {
            this.content.setTitle(this.getName());
        }
    }

    public void init() {
        this.text.setChannel(this);
        this.input.requestFocusInWindow();
        this.setStyles();
    }

    public boolean setRoom(Room room) {
        if (room != null && this.room != room) {
            this.room = room;
            this.refreshBufferSize();
            this.setName(room.getDisplayName());
            this.updateContentData();
            this.getDockContent().setId(room.getChannel());
            return true;
        }
        return false;
    }

    public Room getRoom() {
        return this.room;
    }

    public void cleanUp() {
        this.text.cleanUp();
        this.input.cleanUp();
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setScrollbarAlways(boolean always) {
        this.west.setVerticalScrollBarPolicy(always ? 22 : 20);
    }

    public void setMouseClickedListener(MouseClickedListener listener) {
        this.text.setMouseClickedListener(listener);
    }

    public String getChannel() {
        return this.room.getChannel();
    }

    @Override
    public String getToolTipText() {
        if (this.room.getStreamId() != null) {
            return this.room.getChannel() + " (" + this.room.getStreamId() + ")";
        }
        return this.room.getChannel();
    }

    public String getFilename() {
        return this.room.getFilename();
    }

    @Override
    public String getName() {
        return this.room != null ? this.room.getDisplayName() : null;
    }

    public String getOwnerChannel() {
        return this.room.getOwnerChannel();
    }

    public String getStreamName() {
        return this.room.getStream();
    }

    public void addUser(User user) {
        this.users.addUser(user);
    }

    public void removeUser(User user) {
        this.users.removeUser(user);
    }

    public void updateUser(User user) {
        this.users.updateUser(user);
    }

    public void resortUserlist() {
        this.users.resort();
    }

    public void clearUsers() {
        this.users.clearUsers();
    }

    public int getNumUsers() {
        return this.users.getNumUsers();
    }

    public final void updateUserlistSettings() {
        this.users.setDisplayNamesMode(this.main.getSettings().getLong("displayNamesModeUserlist"));
    }

    public ChannelEditBox getInput() {
        return this.input;
    }

    public String getInputText() {
        return this.input.getText();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.input.requestFocusInWindow();
    }

    public boolean search(String searchText) {
        return this.text.search(searchText);
    }

    public void resetSearch() {
        this.text.resetSearch();
    }

    public void printLine(String line) {
        this.text.printLine(line);
    }

    public void printInfoMessage(InfoMessage message) {
        this.text.printInfoMessage(message);
    }

    public void userBanned(User user, long duration, String reason, String id) {
        this.text.userBanned(user, duration, reason, id);
    }

    public void printCompact(String type, User user) {
        this.text.printCompact(type, user);
    }

    public void printMessage(Message message) {
        this.text.printMessage(message);
    }

    public void printLowTrustInfo(User user, SuspiciousMessagePayload data) {
        this.text.printLowTrustInfo(user, data);
    }

    public void refreshStyles() {
        this.text.refreshStyles();
        this.setStyles();
    }

    private void setStyles() {
        this.input.setFont(this.styleManager.getFont("input"));
        this.input.setBackground(this.styleManager.getColor("inputBackground"));
        this.input.setCaretColor(this.styleManager.getColor("inputForeground"));
        this.input.setForeground(this.styleManager.getColor("inputForeground"));
        this.input.setHistoryRequireCtrlMultirow(this.main.getSettings().getBoolean("inputHistoryMultirowRequireCtrl"));
        this.users.setFont(this.styleManager.getFont("userlist"));
        this.users.setBackground(this.styleManager.getColor("background"));
        this.users.setForeground(this.styleManager.getColor("foreground"));
        this.refreshBufferSize();
    }

    private void refreshBufferSize() {
        Long bufferSize = (Long)this.main.getSettings().mapGet("bufferSizes", StringUtil.toLowerCase(this.getChannel()));
        this.text.setBufferSize(bufferSize != null ? bufferSize.intValue() : -1);
    }

    public void clearChat() {
        this.text.clearAll();
    }

    public void insertText(String text, String options) {
        if (options.contains("p")) {
            this.input.setCaretPosition(0);
        } else if (options.contains("a")) {
            this.input.setCaretPosition(this.input.getText().length());
        }
        this.input.insertAtCaret(text, options.contains("s"));
        if (options.contains("b")) {
            this.input.setCaretPosition(0);
        }
        if (options.contains("e")) {
            this.input.setCaretPosition(this.input.getText().length());
        }
    }

    public void scroll(String action) {
        Channel.scroll(this.west.getVerticalScrollBar(), action);
    }

    public static void scroll(JScrollBar scrollbar, String action) {
        int now = scrollbar.getValue();
        int height = scrollbar.getVisibleAmount();
        height -= height / 10;
        int newValue = 0;
        switch (action) {
            case "pageUp": {
                newValue = now - height;
                break;
            }
            case "pageDown": {
                newValue = now + height;
            }
        }
        scrollbar.setValue(newValue);
    }

    public final void setUserlistWidth(int width, int minWidth) {
        this.userlist.setPreferredSize(new Dimension(width, 10));
        this.userlist.setMinimumSize(new Dimension(minWidth, 0));
        this.userlistMinWidth = minWidth;
    }

    private void setTextPreferredSizeTemporarily() {
        this.text.setPreferredSize(new Dimension(0, 0));
        Timer t = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Channel.this.text.setPreferredSize(null);
            }
        });
        t.setRepeats(false);
        t.start();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public final void toggleInput() {
        this.inputPanel.setVisible(!this.inputPanel.isVisible());
        this.revalidate();
    }

    public final void hideInput() {
        this.inputPreviouslyShown = this.inputPanel.isVisible();
        this.inputPanel.setVisible(false);
        this.revalidate();
    }

    public final void restoreInput() {
        this.inputPanel.setVisible(this.inputPreviouslyShown);
        this.revalidate();
    }

    public final void setUserlistEnabled(boolean enable) {
        if (enable == this.userlistEnabled) {
            return;
        }
        if (enable) {
            this.userlist.setVisible(true);
            this.mainPane.setDividerSize(5);
            this.setUserlistWidth(this.previousUserlistWidth, this.userlistMinWidth);
            this.setTextPreferredSizeTemporarily();
            this.mainPane.setDividerLocation(-1);
        } else {
            this.previousUserlistWidth = this.userlist.getWidth();
            this.userlist.setVisible(false);
            this.mainPane.setDividerSize(0);
        }
        this.userlistEnabled = enable;
        this.revalidate();
    }

    public void setCompletionEnabled(boolean enabled) {
        this.input.setCompletionEnabled(enabled);
    }

    public final void toggleUserlist() {
        this.setUserlistEnabled(!this.userlistEnabled);
    }

    public void selectPreviousUser() {
        this.text.selectPreviousUser();
    }

    public void selectNextUser() {
        this.text.selectNextUser();
    }

    public void selectNextUserExitAtBottom() {
        this.text.selectNextUserExitAtBottom();
    }

    public void exitUserSelection() {
        this.text.exitUserSelection();
    }

    public void toggleUserSelection() {
        this.text.toggleUserSelection();
    }

    public User getSelectedUser() {
        return this.text.getSelectedUser();
    }

    public boolean hasLineId(long lineId) {
        return this.text.hasLineId(lineId);
    }

    public void scrollToLine(long lineId, String label) {
        this.text.scrollToLine(lineId, label);
    }

    @Override
    public String toString() {
        return String.format("%s '%s'", new Object[]{this.type, this.room});
    }

    public static enum Type {
        NONE,
        CHANNEL,
        WHISPER,
        SPECIAL;

    }
}

