/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components;

import chatty.Room;
import chatty.User;
import chatty.gui.MainGui;
import chatty.gui.components.Channel;
import chatty.gui.components.ChannelEditBox;
import chatty.gui.components.UserList;
import chatty.gui.components.completion.AutoCompletionServer;
import chatty.util.StringUtil;
import chatty.util.api.CachedImage;
import chatty.util.api.Emoticon;
import chatty.util.api.Emoticons;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;

public class ChannelCompletion
implements AutoCompletionServer {
    private final Channel channel;
    private final ChannelEditBox input;
    private final MainGui main;
    private final UserList users;
    private final Set<String> commands = new TreeSet<String>(Arrays.asList(new String[0]));
    private final Set<String> settingCommands = new TreeSet<String>(Arrays.asList("set", "set2", "add", "add2", "addUnique", "addUnique2", "clearSetting", "remove", "remove2", "get", "reset", "setSwitch", "setList"));
    private final Set<String> prefixesPreferUsernames = new HashSet<String>(Arrays.asList("/ban ", "/to ", "/setname ", "/resetname ", "/timeout ", "/unban ", "/ignore ", "/unignore ", "/ignorechat ", "/unignorechat ", "/ignorewhisper ", "/unignorewhisper ", "/follow ", "/unfollow ", "/untimeout ", "/favorite ", "/unfavorite ", "@@"));
    private Font currentFont;
    private int currentEmoteScaling;
    private CachedImage.ImageType currentEmoteImageType;
    private static final Comparator<Emoticon> SORT_EMOTES_BY_NAME = new Comparator<Emoticon>(){

        @Override
        public int compare(Emoticon o1, Emoticon o2) {
            return o1.code.compareToIgnoreCase(o2.code);
        }
    };
    private final Comparator<AutoCompletionServer.CompletionItem> SORT_FAV_EMOTES_FIRST = new Comparator<AutoCompletionServer.CompletionItem>(){

        @Override
        public int compare(AutoCompletionServer.CompletionItem o1, AutoCompletionServer.CompletionItem o2) {
            boolean o1Fav = ((ChannelCompletion)ChannelCompletion.this).main.emoticons.isFavorite(((EmoteCompletionItem)o1).emote);
            boolean o2Fav = ((ChannelCompletion)ChannelCompletion.this).main.emoticons.isFavorite(((EmoteCompletionItem)o2).emote);
            if (o1Fav && !o2Fav) {
                return -1;
            }
            if (!o1Fav && o2Fav) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<Emoticon> EMOJI_SORTER = new Comparator<Emoticon>(){

        @Override
        public int compare(Emoticon o1, Emoticon o2) {
            return o1.stringId.compareTo(o2.stringId);
        }
    };
    private final UserSorterNew userSorterNew = new UserSorterNew();
    private final UserSorterAlphabetic userSorterAlphabetical = new UserSorterAlphabetic();

    public ChannelCompletion(Channel channel, MainGui main, ChannelEditBox input, UserList users) {
        this.channel = channel;
        this.main = main;
        this.input = input;
        this.users = users;
    }

    private boolean isSettingPrefix(String prefix) {
        for (String command : this.settingCommands) {
            if (!prefix.equals("/" + StringUtil.toLowerCase(command) + " ")) continue;
            return true;
        }
        return false;
    }

    private Settings settings() {
        return this.main.getSettings();
    }

    private void updateSettings() {
        this.input.setCompletionMaxItemsShown((int)this.main.getSettings().getLong("completionMaxItemsShown"));
        this.input.setCompletionShowPopup(this.main.getSettings().getBoolean("completionShowPopup"));
        this.input.setCompleteToCommonPrefix(this.main.getSettings().getBoolean("completionCommonPrefix"));
        this.input.setCompletionAppendSpace(this.settings().getBoolean("completionSpace"));
        if (this.main.getSettings().getLong("emoteScaleDialog") != (long)this.currentEmoteScaling || this.input.getFont() != this.currentFont) {
            this.currentEmoteScaling = (int)this.main.getSettings().getLong("emoteScaleDialog");
            this.currentFont = this.input.getFont();
            this.updateSizeSettings();
        }
        this.currentEmoteImageType = Emoticon.makeImageType(this.main.getSettings().getBoolean("animatedEmotes"));
    }

    private void updateSizeSettings() {
        int baseEmoteHeight = 32;
        int baseEmoteWidth = 30;
        int emoteScale = this.currentEmoteScaling;
        int scaledEmoteHeight = baseEmoteHeight * emoteScale / 100;
        int scaledEmoteWidth = baseEmoteWidth * emoteScale / 100;
        int fontHeight = this.input.getGraphics().getFontMetrics().getHeight();
        int cellHeight = Math.max(scaledEmoteHeight, fontHeight);
        String testText = "AbcdefghIJKLmnoPQRSTUVwxyz123456";
        int textWidth = this.input.getGraphics().getFontMetrics().stringWidth(testText);
        int cellWidth = textWidth + scaledEmoteWidth;
        this.input.setCompletionCellSize(cellWidth, cellHeight);
    }

    @Override
    public AutoCompletionServer.CompletionItems getCompletionItems(String type, String prefix, String search) {
        this.updateSettings();
        String searchLower = StringUtil.toLowerCase(search);
        prefix = StringUtil.toLowerCase(prefix);
        if (type == null || type.equals("auto")) {
            return this.getRegularCompletionItems(prefix, searchLower, search);
        }
        if (type.equals("special")) {
            return this.getSpecialItems(prefix, searchLower, search);
        }
        return new AutoCompletionServer.CompletionItems();
    }

    private AutoCompletionServer.CompletionItems getRegularCompletionItems(String prefix, String search, String searchCase) {
        List<String> items;
        HashMap<String, String> info = new HashMap<String, String>();
        if (prefix.startsWith("/") && this.isSettingPrefix(prefix)) {
            this.input.setCompleteToCommonPrefix(true);
            items = this.filterCompletionItems(this.main.getSettingNames(), search);
        } else if (prefix.matches("/timer (-[a-z]+ )?:")) {
            items = new ArrayList<String>();
        } else if (prefix.equals("/")) {
            ArrayList<String> c = new ArrayList<String>();
            Collection<String> customCommandNames = this.main.getCustomCommandNames();
            c.addAll(this.commands);
            c.addAll(this.settingCommands);
            c.addAll(customCommandNames);
            c.addAll(this.main.getCommandNames());
            items = this.filterCompletionItems(c, search);
            for (String item : items) {
                if (!customCommandNames.contains(item)) continue;
                info.put(item, "Custom Command");
            }
        } else {
            return this.getMainItems(this.main.getSettings().getString("completionTab"), prefix, search, searchCase);
        }
        return AutoCompletionServer.CompletionItems.createFromStrings(items, "", info);
    }

    private AutoCompletionServer.CompletionItems getSpecialItems(String prefix, String search, String searchCase) {
        return this.getMainItems(this.main.getSettings().getString("completionTab2"), prefix, search, searchCase);
    }

    private AutoCompletionServer.CompletionItems getMainItems(String setting, String prefix, String search, String searchCase) {
        boolean preferUsernames = this.prefixesPreferUsernames.contains(prefix) && this.main.getSettings().getBoolean("completionPreferUsernames");
        String emotePrefix = this.settings().getString("completionEmotePrefix");
        if (prefix.endsWith("@") || this.prefixesPreferUsernames.contains(prefix)) {
            return this.getCompletionItemsNames(search, preferUsernames);
        }
        if (prefix.endsWith(".")) {
            return AutoCompletionServer.CompletionItems.createFromStrings(this.getCustomCompletionItems(searchCase), ".");
        }
        if (prefix.endsWith(":")) {
            if (emotePrefix.equals(":")) {
                switch ((int)this.settings().getLong("completionMixed")) {
                    case 0: {
                        AutoCompletionServer.CompletionItems items = this.getCompletionItemsEmoji(search);
                        items.append(this.getCompletionItemsEmotes(search, ":"));
                        ChannelCompletion.sortMixed(items, search);
                        this.sortFavoritesFirst(items);
                        return items;
                    }
                    case 1: {
                        AutoCompletionServer.CompletionItems items = this.getCompletionItemsEmoji(search);
                        items.append(this.getCompletionItemsEmotes(search, ":"));
                        this.sortFavoritesFirst(items);
                        return items;
                    }
                    case 2: {
                        AutoCompletionServer.CompletionItems items = this.getCompletionItemsEmotes(search, ":");
                        items.append(this.getCompletionItemsEmoji(search));
                        this.sortFavoritesFirst(items);
                        return items;
                    }
                }
            }
            return this.getCompletionItemsEmoji(search);
        }
        if (!emotePrefix.isEmpty() && prefix.endsWith(emotePrefix)) {
            return this.sortFavoritesFirst(this.getCompletionItemsEmotes(search, emotePrefix));
        }
        if (setting.equals("names")) {
            return this.getCompletionItemsNames(search, preferUsernames);
        }
        if (setting.equals("emotes")) {
            return this.sortFavoritesFirst(this.getCompletionItemsEmotes(search, ""));
        }
        if (setting.equals("custom")) {
            return AutoCompletionServer.CompletionItems.createFromStrings(this.getCustomCompletionItems(searchCase), "");
        }
        AutoCompletionServer.CompletionItems names = this.getCompletionItemsNames(search, preferUsernames);
        AutoCompletionServer.CompletionItems emotes = this.sortFavoritesFirst(this.getCompletionItemsEmotes(search, ""));
        if (setting.equals("both")) {
            names.append(emotes);
            return names;
        }
        emotes.append(names);
        return emotes;
    }

    private AutoCompletionServer.CompletionItems getCompletionItemsEmotes(String search, String prefix) {
        LinkedList<Emoticon> allEmotes = new LinkedList<Emoticon>();
        allEmotes.addAll(this.main.emoticons.getUsableGlobalTwitchEmotes());
        allEmotes.addAll(this.main.emoticons.getUsableFollowerEmotes(this.channel.getStreamName()));
        allEmotes.addAll(this.main.emoticons.getUsableEmotesByStream(this.channel.getStreamName()));
        allEmotes.addAll(this.main.emoticons.getUsableGlobalOtherEmotes());
        List<Emoticon> result = this.filterCompletionItems(allEmotes, search, SORT_EMOTES_BY_NAME, item -> {
            if (this.main.isEmoteIgnored((Emoticon)item, 4)) {
                return null;
            }
            return item.code;
        });
        ArrayList<AutoCompletionServer.CompletionItem> items = new ArrayList<AutoCompletionServer.CompletionItem>();
        for (Emoticon emote : result) {
            String code = Emoticons.toWriteable(emote.code);
            String info = emote.type.label;
            if (info.equals("Custom2")) {
                info = "Chatty Local";
            }
            if (emote.hasStreamRestrictions()) {
                info = info + ", Channel";
            }
            if (this.main.emoticons.isFavorite(emote)) {
                info = info + ", Fav";
            }
            items.add(this.createEmoteItem(code, info, emote));
        }
        return new AutoCompletionServer.CompletionItems(items, prefix);
    }

    private AutoCompletionServer.CompletionItem createEmoteItem(String code, String info, Emoticon emote) {
        return new EmoteCompletionItem(code, info, emote);
    }

    private AutoCompletionServer.CompletionItems sortFavoritesFirst(AutoCompletionServer.CompletionItems items) {
        if (this.settings().getBoolean("completionFavEmotesFirst")) {
            Collections.sort(items.items, this.SORT_FAV_EMOTES_FIRST);
        }
        return items;
    }

    private List<String> getCustomCompletionItems(String search) {
        String result = this.main.getCustomCompletionItem(search);
        ArrayList<String> list = new ArrayList<String>();
        if (result != null) {
            list.add(result);
        }
        return list;
    }

    private AutoCompletionServer.CompletionItems getCompletionItemsEmoji(String search) {
        LinkedList<AutoCompletionServer.CompletionItem> result = new LinkedList<AutoCompletionServer.CompletionItem>();
        LinkedHashSet<Emoticon> searchResult = new LinkedHashSet<Emoticon>();
        this.findEmoji(searchResult, code -> code.startsWith(":" + search));
        if (searchResult.size() < 20) {
            this.findEmoji(searchResult, code -> code.contains("_" + search));
        }
        if (searchResult.size() < 20) {
            this.findEmoji(searchResult, code -> code.contains(search));
        }
        for (Emoticon emote : searchResult) {
            if (this.main.getSettings().getBoolean("emojiReplace")) {
                String alias = null;
                if (!emote.stringId.contains(search) && emote.stringIdAlias.contains(search)) {
                    alias = emote.stringIdAlias;
                }
                String info = alias;
                if (this.main.emoticons.isFavorite(emote)) {
                    info = StringUtil.append(info, ", ", "Fav");
                }
                result.add(this.createEmoteItem(emote.stringId, info, emote));
                continue;
            }
            String info = null;
            if (this.main.emoticons.isFavorite(emote)) {
                info = "Fav";
            }
            result.add(this.createEmoteItem(emote.code, info, emote));
        }
        return new AutoCompletionServer.CompletionItems(result, ":");
    }

    private void findEmoji(Collection<Emoticon> result, Function<String, Boolean> matcher) {
        LinkedList<Emoticon> searchResult = new LinkedList<Emoticon>();
        for (Emoticon emote : this.main.emoticons.getEmoji()) {
            if (this.main.isEmoteIgnored(emote, 4)) continue;
            if (emote.stringId != null && matcher.apply(emote.stringId).booleanValue()) {
                searchResult.add(emote);
                continue;
            }
            if (emote.stringIdAlias == null || !matcher.apply(emote.stringIdAlias).booleanValue()) continue;
            searchResult.add(emote);
        }
        Collections.sort(searchResult, EMOJI_SORTER);
        result.addAll(searchResult);
    }

    private List<String> filterCompletionItems(Collection<String> data, String search) {
        return this.filterCompletionItems(data, search, String.CASE_INSENSITIVE_ORDER, item -> item);
    }

    private <T> List<T> filterCompletionItems(Collection<T> data, String search, Comparator<T> comparator, Function<T, String> getString) {
        ArrayList<T> containing = new ArrayList<T>();
        ArrayList<T> matched = new ArrayList<T>();
        Pattern cSearch = Pattern.compile(Pattern.quote(search.substring(0, 1).toUpperCase(Locale.ENGLISH)) + "(?i)" + Pattern.quote(search.substring(1)));
        String searchMode = this.main.getSettings().getString("completionSearch");
        HashSet<String> added = new HashSet<String>();
        for (T item : data) {
            String itemString = getString.apply(item);
            if (StringUtil.isNullOrEmpty(itemString) || added.contains(itemString)) continue;
            String lc = StringUtil.toLowerCase(itemString);
            if (lc.startsWith(search)) {
                matched.add(item);
                added.add(itemString);
                continue;
            }
            if (searchMode.equals("words") && !this.input.getCompleteToCommonPrefix() && cSearch.matcher(itemString).find()) {
                containing.add(item);
                added.add(itemString);
                continue;
            }
            if (!searchMode.equals("anywhere") || !lc.contains(search)) continue;
            containing.add(item);
            added.add(itemString);
        }
        Collections.sort(matched, comparator);
        Collections.sort(containing, comparator);
        matched.addAll(containing);
        return matched;
    }

    private static void sortMixed(AutoCompletionServer.CompletionItems items, final String search) {
        final String emojiSearch = ":" + search;
        Collections.sort(items.items, new Comparator<AutoCompletionServer.CompletionItem>(){

            @Override
            public int compare(AutoCompletionServer.CompletionItem o1, AutoCompletionServer.CompletionItem o2) {
                boolean o2s;
                String o1l = StringUtil.toLowerCase(o1.getCode());
                String o2l = StringUtil.toLowerCase(o2.getCode());
                boolean o1s = o1l.startsWith(search) || o1.getCode().startsWith(emojiSearch);
                boolean bl = o2s = o2l.startsWith(search) || o2.getCode().startsWith(emojiSearch);
                if (o1s == o2s) {
                    return this.normalize(o1l).compareTo(this.normalize(o2l));
                }
                if (o1s) {
                    return -1;
                }
                return 1;
            }

            private String normalize(String input) {
                if (input.startsWith(":")) {
                    return input.substring(1);
                }
                return input;
            }
        });
    }

    private AutoCompletionServer.CompletionItems getCompletionItemsNames(String search, boolean preferUsernames) {
        ArrayList<User> matchedUsers = new ArrayList<User>();
        HashSet<User> regularMatched = new HashSet<User>();
        HashSet<User> customMatched = new HashSet<User>();
        HashSet<User> localizedMatched = new HashSet<User>();
        for (User user : this.users.getData()) {
            ChannelCompletion.matchUser(user, search, matchedUsers, regularMatched, localizedMatched, customMatched);
        }
        if (this.channel.getRoom().hasStream()) {
            Object channelUser = new User(this.channel.getStreamName(), Room.EMPTY);
            boolean channelUserMatched = false;
            for (User user : matchedUsers) {
                if (!user.getName().equals(((User)channelUser).getName())) continue;
                channelUserMatched = true;
            }
            if (!channelUserMatched) {
                ChannelCompletion.matchUser((User)channelUser, search, matchedUsers, regularMatched, localizedMatched, customMatched);
            }
        }
        switch (this.main.getSettings().getString("completionSorting")) {
            case "predictive": {
                Collections.sort(matchedUsers, this.userSorterNew);
                break;
            }
            case "alphabetical": {
                Collections.sort(matchedUsers, this.userSorterAlphabetical);
                break;
            }
            default: {
                Collections.sort(matchedUsers);
            }
        }
        boolean includeAllNameTypes = this.main.getSettings().getBoolean("completionAllNameTypes");
        boolean includeAllNameTypesRestriction = this.main.getSettings().getBoolean("completionAllNameTypesRestriction");
        ArrayList<String> nicks = new ArrayList<String>();
        HashMap<String, String> info = new HashMap<String, String>();
        for (User user : matchedUsers) {
            if (includeAllNameTypes && (!includeAllNameTypesRestriction || matchedUsers.size() <= 2)) {
                if (customMatched.contains(user) && !preferUsernames) {
                    nicks.add(user.getCustomNick());
                    if (!user.hasRegularDisplayNick()) {
                        nicks.add(user.getDisplayNick());
                    }
                    if (user.hasCustomNickSet() && !user.getCustomNick().equalsIgnoreCase(user.getRegularDisplayNick())) {
                        nicks.add(user.getRegularDisplayNick());
                    }
                } else if (localizedMatched.contains(user) && !preferUsernames) {
                    nicks.add(user.getDisplayNick());
                    if (user.hasCustomNickSet() && !user.getCustomNick().equalsIgnoreCase(user.getRegularDisplayNick())) {
                        nicks.add(user.getCustomNick());
                    }
                    nicks.add(user.getRegularDisplayNick());
                } else {
                    nicks.add(user.getRegularDisplayNick());
                    if (!user.hasRegularDisplayNick()) {
                        nicks.add(user.getDisplayNick());
                    }
                    if (user.hasCustomNickSet() && !user.getCustomNick().equalsIgnoreCase(user.getRegularDisplayNick())) {
                        nicks.add(user.getCustomNick());
                    }
                }
            } else {
                if (regularMatched.contains(user) || preferUsernames) {
                    nicks.add(user.getRegularDisplayNick());
                }
                if (localizedMatched.contains(user) && !preferUsernames) {
                    nicks.add(user.getDisplayNick());
                }
                if (customMatched.contains(user) && !preferUsernames) {
                    nicks.add(user.getCustomNick());
                }
            }
            if (!user.hasRegularDisplayNick()) {
                info.put(user.getDisplayNick(), user.getRegularDisplayNick());
                info.put(user.getRegularDisplayNick(), user.getDisplayNick());
            }
            if (!user.hasCustomNickSet()) continue;
            info.put(user.getCustomNick(), user.getRegularDisplayNick());
            info.put(user.getRegularDisplayNick(), user.getCustomNick());
        }
        ArrayList<AutoCompletionServer.CompletionItem> result = new ArrayList<AutoCompletionServer.CompletionItem>();
        for (String nick : nicks) {
            String nickInfo = (String)info.get(nick);
            result.add(new AutoCompletionServer.CompletionItem(nick, nickInfo));
        }
        return new AutoCompletionServer.CompletionItems(result, "");
    }

    private static void matchUser(User user, String search, List<User> matchedUsers, Set<User> regularMatched, Set<User> localizedMatched, Set<User> customMatched) {
        boolean matched = false;
        if (user.getName().startsWith(search)) {
            matched = true;
            regularMatched.add(user);
        }
        if (!user.hasRegularDisplayNick() && StringUtil.toLowerCase(user.getDisplayNick()).startsWith(search)) {
            matched = true;
            localizedMatched.add(user);
        }
        if (user.hasCustomNickSet() && StringUtil.toLowerCase(user.getCustomNick()).startsWith(search)) {
            matched = true;
            customMatched.add(user);
        }
        if (matched) {
            matchedUsers.add(user);
        }
    }

    @Override
    public boolean isAutostartPrefix(String prefix) {
        if (this.settings().getBoolean("completionAuto") && !prefix.isEmpty()) {
            boolean eligible = prefix.endsWith(":") || prefix.endsWith("@") || prefix.endsWith("@@") || prefix.endsWith(this.settings().getString("completionEmotePrefix"));
            boolean beforeRequirement = prefix.length() == 1 || prefix.charAt(prefix.length() - 2) == ' ' || prefix.equals("@@");
            return eligible && beforeRequirement;
        }
        return false;
    }

    private class UserSorterNew
    implements Comparator<User> {
        private UserSorterNew() {
        }

        @Override
        public int compare(User o1, User o2) {
            int s2;
            int s1 = o1.getActivityScore();
            if (s1 == (s2 = o2.getActivityScore())) {
                return o1.compareTo(o2);
            }
            if (s1 > s2) {
                return -1;
            }
            return 1;
        }
    }

    private class UserSorterAlphabetic
    implements Comparator<User> {
        private UserSorterAlphabetic() {
        }

        @Override
        public int compare(User o1, User o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    private class EmoteCompletionItem
    extends AutoCompletionServer.CompletionItem {
        private final Emoticon emote;

        private EmoteCompletionItem(String code, String info, Emoticon emote) {
            super(code, info);
            this.emote = emote;
        }

        @Override
        public ImageIcon getImage(final Component c) {
            float scale = (float)((double)ChannelCompletion.this.currentEmoteScaling / 100.0);
            ImageIcon icon = this.emote.getIcon(scale, 0, ChannelCompletion.this.currentEmoteImageType, new CachedImage.CachedImageUser(){

                @Override
                public void iconLoaded(Image oldImage, Image newImage, boolean sizeChanged) {
                    c.repaint();
                }
            }).getImageIcon();
            return new ImageIcon(icon.getImage());
        }

        public Emoticon getEmoticon() {
            return this.emote;
        }
    }
}

